# 章末小測試

<CourseFloatingBanner
    chapter={1}
    classNames="absolute z-10 right-0 top-0"
/>

這一章涵蓋了很多內容！ 如果有一些不太明白的地方，請不要擔心； 下一章將幫助你瞭解這些模塊在底層是如何運作的。

讓我們來測試一下你在這一章學到了什麼！

### 1. 探索 Hub 並尋找 `roberta-large-mnli` checkpoint。 它可以完成什麼類型的任務？


<Question
	choices={[
		{
			text: "文本摘要提取",
			explain: "點擊前往<a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli 頁面</a>回顧一下."
		},
		{
			text: "文本分類",
			explain: "更準確地說，它對兩個句子在三個標籤（矛盾、無關、相近）之間的邏輯鏈接進行分類——這項任務也稱爲<em>自然語言推理</em>.",
			correct: true
		},
		{
			text: "文本生成",
			explain: "點擊前往<a href=\"https://huggingface.co/roberta-large-mnli\">roberta-large-mnli 頁面</a>回顧一下."
		}
	]}
/>

### 2. 下面的代碼將會返回什麼結果？

```py
from transformers import pipeline

ner = pipeline("ner", grouped_entities=True)
ner("My name is Sylvain and I work at Hugging Face in Brooklyn.")
```

<Question
	choices={[
		{
			text: "它將返回這個句子的分類的分數, 帶有 \"positive\" 或者 \"negative\"的標籤.",
			explain: "這個選項是不對的 — <code>sentiment-analysis</code> pipeline將會返回這些."
		},
		{
			text: "它將返回一個生成的文本來完成這句話。",
			explain: "這個選項是不對的 — <code>text-generation</code> pipeline將會返回這些.",
		},
		{
			text: "它將返回代表人員、組織或位置的單詞。",
			explain: "此外，使用 <code>grouped_entities=True</code>，它會將屬於同一實體的單詞組合在一起，例如“Hugging Face”。",
			correct: true
		}
	]}
/>

### 3. 在此代碼示例中...的地方應該填寫什麼？

```py
from transformers import pipeline

filler = pipeline("fill-mask", model="bert-base-cased")
result = filler("...")
```

<Question
	choices={[
		{
			text: "This <mask> has been waiting for you.",
			explain: "這個選項是不對的。 請查看 <code>bert-base-cased</code> 模型卡片,然後再嘗試找找錯在哪裏。"
		},
		{
			text: "This [MASK] has been waiting for you.",
			explain: "正解! 這個模型的mask的掩碼是[MASK].",
			correct: true
		},
		{
			text: "This man has been waiting for you.",
			explain: "這個選項是不對的。 這個pipeline的作用是填充經過mask的文字，因此它需要在輸入的文本中存在mask的token。"
		}
	]}
/>

### 4. 爲什麼這段代碼會無法運行？

```py
from transformers import pipeline

classifier = pipeline("zero-shot-classification")
result = classifier("This is a course about the Transformers library")
```

<Question
	choices={[
		{
			text: "這個 pipeline 要求提供用來分類此文本的標籤。",
			explain: "正解 — 正確的代碼需要包括：<code>candidate_labels=[...]</code>.",
			correct: true
		},
		{
			text: "這個pipeline需要多個句子，而不僅僅是一個。",
			explain: "這個選項是不對的。儘管正確使用時，此pipeline可以同時處理多個句子（與所有其他pipeline一樣）。"
		},
		{
			text: "像往常一樣，🤗 Transformers 庫出故障了。",
			explain: "對此，我們不予置評！"
		},
		{
			text: "該 pipeline 需要更長的輸入； 這個句子太短了。",
			explain: "這個選項是不對的。 不過請注意，在這個 pipeline 處理時，太長的文本將被截斷。"
		}
	]}
/>

### 5. “遷移學習”是什麼意思？

<Question
	choices={[
		{
			text: "通過在同一數據集上訓練模型，將預訓練模型的知識遷移到新模型。",
			explain: "不，那將是同一模型的兩個版本。"
		},
		{
			text: "通過使用第一個模型的權重初始化第二個模型，將預訓練模型的知識遷移到新模型。",
			explain: "正確：當第二個模型接受新任務訓練時，它*遷移*第一個模型的知識。",
			correct: true
		},
		{
			text: "構建與第一個模型具有相同架構的第二個模型，將預訓練模型的知識遷移到新模型。",
			explain: "架構只是模型的構建方式； 在這種情況下，沒有知識共享或遷移。"
		}
	]}
/>

### 6. 語言模型在預訓練時通常不需要標籤，這樣的說法是否正確。


<Question
	choices={[
		{
			text: "正確",
			explain: "預訓練通常是<em>自監督</em>，這意味着標籤是根據輸入自動創建的（例如：預測下一個單詞或填充一些[MARSK]單詞）。",
			correct: true
		},
		{
			text: "錯誤",
			explain: "這不是一個正確的答案。"
		}
	]}
/>


### 7. 選擇最能描述「模型(model)」、「架構(architecture)」和「權重(weights)」的句子。
<Question
	choices={[
		{
			text: "如果模型是一座建築物，那麼它的架構就是藍圖，而權重就是住在裏面的人。",
			explain: "按照這個比喻，權重將是用於建造建築物的磚塊和其他材料。"
		},
		{
			text: "架構是構建模型的地圖，其權重是地圖上表示的城市。",
			explain: "這個比喻的問題在於，一張地圖通常代表只有一個確定的事實（法國只有一個城市叫巴黎）。 對於給定的體系結構，多個權重是可能的。"
		},
		{
			text: "架構是用於構建模型的一系列數學函數，其權重是這些函數參數。",
			explain: "同一組數學函數（架構）可以通過使用不同的參數（權重）來構建不同的模型。",
			correct: true
		}
	]}
/>


### 8. 你將使用以下哪種類型的模型來根據輸入的提示生成文本？

<Question
	choices={[
		{
			text: "一個“編碼器”模型",
			explain: "“編碼器”模型生成整個句子的表示，這種表示更適合於分類之類的任務。"
		},
		{
			text: "一個“解碼器”模型",
			explain: "“解碼器”模型非常適合根據提示生成文本。",
			correct: true
		},
		{
			text: "一個“序列到序列”模型",
			explain: "“序列到序列”模型更適合於你想要根據輸入的句子而不是給定的提示生成句子的任務。"
		}
	]}
/>

### 9. 你會使用哪些類型的模型來生成文本的摘要？

<Question
	choices={[
		{
			text: "一個「編碼器」模型",
			explain: "「編碼器」模型生成整個句子的表示，這種表示更適合於分類之類的任務。"
		},
		{
			text: "一個「解碼器」模型",
			explain: "「解碼器」模型對於生成輸出文本(如摘要)很好，但它們不具備利用上下文(如整個文本)進行總結的能力。"
		},
		{
			text: "一個「序列到序列」模型",
			explain: "「序列到序列」模型非常適合摘要任務。",
			correct: true
		}
	]}
/>

### 10. 你會使用哪一種類型的模型來根據特定的標籤對文本輸入進行分類？

<Question
	choices={[
		{
			text: "一個“編碼器”模型",
			explain: "“編碼器”模型可以生成整個句子的表示，非常適合分類這樣的任務。",
			correct: true
		},
		{
			text: "一個“解碼器”模型",
			explain: "“解碼器”模型適合於生成輸出文本，而不是從句子中提取標籤。"
		},
		{
			text: "一個“序列到序列”模型",
			explain: "“序列到序列”模型更適合於輸入句子而不是標籤生成文本的任務。",
		}
	]}
/>

### 11. 模型中觀察到的偏見有哪些可能的來源？

<Question
	choices={[
		{
			text: "這個模型是一個預訓練模型的微調版本，它從中繼承了預訓練模型的偏見。",
			explain: "當應用遷移學習時，在預訓練模型中產生的偏見在微調模型中不能完全去除。",
			correct: true
		},
		{
			text: "用於訓練模型的數據是有偏見的。",
			explain: "這是最明顯的偏見來源，但不是唯一的來源。",
			correct: true
		},
		{
			text: "模型優化的指標是有偏見的。",
			explain: "一個不太明顯的偏見來源是模型的訓練方式。你的模型將盲目地只針對你選擇的指標進行優化，而不會思考是否會帶有偏見。",
			correct: true
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter1/10.mdx" />