# 模型

{#if fw === 'pt'}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_pt.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_pt.ipynb"},
]} />

{:else}

<CourseFloatingBanner chapter={2}
  classNames="absolute z-10 right-0 top-0"
  notebooks={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_tf.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter2/section3_tf.ipynb"},
]} />

{/if}

{#if fw === 'pt'}
<Youtube id="AhChOFRegn4"/>
{:else}
<Youtube id="d3JVgghSOew"/>
{/if}

{#if fw === 'pt'}
在本節中，我們將更詳細地瞭解如何創建和使用模型。我們將使用
AutoModel類，當您希望從檢查點實例化任何模型時，這非常方便。

這個AutoModel類及其所有相關項實際上是對庫中各種可用模型的簡單包裝。它是一個聰明的包裝器，因為它可以自動猜測檢查點的適當模型體系結構，然後用該體系結構實例化模型。

{:else}
在本節中，我們將更詳細地瞭解如何創建和使用模型。我們將使用
AutoModel類，當您希望從檢查點實例化任何模型時，這非常方便。

這個AutoModel類及其所有相關項實際上是對庫中各種可用模型的簡單包裝。它是一個聰明的包裝器，因為它可以自動猜測檢查點的適當模型體系結構，然後用該體系結構實例化模型。

{/if}

但是，如果您知道要使用的模型類型，則可以使用直接定義其體系結構的類。讓我們看看這是如何與BERT模型一起工作的。

## 創建轉換器

初始化BERT模型需要做的第一件事是加載配置對象：

{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

# Building the config
config = BertConfig()

# Building the model from the config
model = BertModel(config)
```
{:else}
```py
from transformers import BertConfig, TFBertModel

# Building the config
config = BertConfig()

# Building the model from the config
model = TFBertModel(config)
```
{/if}

配置包含許多用於構建模型的屬性：

```py
print(config)
```

```python out
BertConfig {
  [...]
  "hidden_size": 768,
  "intermediate_size": 3072,
  "max_position_embeddings": 512,
  "num_attention_heads": 12,
  "num_hidden_layers": 12,
  [...]
}
```

雖然您還沒有看到所有這些屬性都做了什麼，但您應該認識到其中的一些屬性：hidden_size屬性定義了hidden_狀態向量的大小，num_hidden_layers定義了Transformer模型的層數。

### 不同的加載方式

從默認配置創建模型會使用隨機值對其進行初始化：


{#if fw === 'pt'}
```py
from transformers import BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

# Model is randomly initialized!
```
{:else}
```py
from transformers import BertConfig, TFBertModel

config = BertConfig()
model = TFBertModel(config)

# Model is randomly initialized!
```
{/if}


該模型可以在這種狀態下使用，但會輸出胡言亂語；首先需要對其進行訓練。我們可以根據手頭的任務從頭開始訓練模型，但正如您在
[Chapter 1](/course/chapter1)
，這將需要很長的時間和大量的數據，並將產生不可忽視的環境影響。為了避免不必要的重複工作，必須能夠共享和重用已經訓練過的模型。


加載已經訓練過的Transformers模型很簡單-我們可以使用from_pretrained()
方法：

{#if fw === 'pt'}
```py
from transformers import BertModel

model = BertModel.from_pretrained("bert-base-cased")
```

正如您之前看到的，我們可以用等效的AutoModel類替換Bert模型。從現在開始，我們將這樣做，因為這會產生檢查點不可知的代碼；如果您的代碼適用於一個檢查點，那麼它應該與另一個檢查點無縫地工作。即使體系結構不同，這也適用，只要檢查點是針對類似任務（例如，情緒分析任務）訓練的。

{:else}
```py
from transformers import TFBertModel

model = TFBertModel.from_pretrained("bert-base-cased")
```

正如您之前看到的，我們可以用等效的AutoModel類替換Bert模型。從現在開始，我們將這樣做，因為這會產生檢查點不可知的代碼；如果您的代碼適用於一個檢查點，那麼它應該與另一個檢查點無縫地工作。即使體系結構不同，這也適用，只要檢查點是針對類似任務（例如，情緒分析任務）訓練的。

{/if}

在上面的代碼示例中，我們沒有使用BertConfig

，而是通過Bert base cased標識符加載了一個預訓練模型。這是一個模型檢查點，由BERT的作者自己訓練；您可以在
[model card](https://huggingface.co/bert-base-cased)中找到更多細節.



該模型現在使用檢查點的所有權重進行初始化。它可以直接用於對訓練過的任務進行推理，也可以對新任務進行微調。通過預先訓練重量而不是從頭開始的訓練，我們可以很快取得好的效果。



權重已下載並緩存在緩存文件夾中（因此將來對from_pretrained()方法的調用將不會重新下載它們）默認為
~/.cache/huggingface/transformers
. 您可以通過設置
HF_HOME
環境變量來自定義緩存文件夾。



用於加載模型的標識符可以是模型中心Hub上任何模型的標識符，只要它與BERT體系結構兼容。可以找到可用的BERT檢查點的完整列表
[here](https://huggingface.co/models?filter=bert)
.
### 保存模型

保存模型和加載模型一樣簡單--我們使用
save_pretrained()
方法，類似於
from_pretrained()
方法：

```py
model.save_pretrained("directory_on_my_computer")
```

這會將兩個文件保存到磁盤：

{#if fw === 'pt'}
```
ls directory_on_my_computer

config.json model.safetensors
```
{:else}
```
ls directory_on_my_computer

config.json tf_model.h5
```
{/if}

如果你看一下
config.json
文件，您將識別構建模型體系結構所需的屬性。該文件還包含一些元數據，例如檢查點的來源以及上次保存檢查點時使用的🤗 Transformers版本。

{#if fw === 'pt'}
這個 *model.safetensors* 文件就是眾所周知的*state dictionary*; 它包含模型的所有權重。這兩個文件齊頭並進；配置是瞭解模型體系結構所必需的，而模型權重是模型的參數。

{:else}
這個 *model.safetensors* 文件就是眾所周知的*state dictionary*; 它包含模型的所有權重。這兩個文件齊頭並進；配置是瞭解模型體系結構所必需的，而模型權重是模型的參數。

{/if}

### 使用Transformers模型進行推理

既然您知道了如何加載和保存模型，那麼讓我們嘗試使用它進行一些預測。Transformer模型只能處理數字——分詞器生成的數字。但在我們討論標記化器之前，讓我們先探討模型接受哪些輸入。

標記化器可以將輸入轉換為適當的框架張量，但為了幫助您瞭解發生了什麼，我們將快速瞭解在將輸入發送到模型之前必須做什麼。

假設我們有幾個序列：

```py
sequences = ["Hello!", "Cool.", "Nice!"]
```

分詞器將這些轉換為詞彙表索引，通常稱為
input IDs
. 每個序列現在都是一個數字列表！結果是：

```py no-format
encoded_sequences = [
    [101, 7592, 999, 102],
    [101, 4658, 1012, 102],
    [101, 3835, 999, 102],
]
```

這是一個編碼序列列表：一個列表列表。張量只接受矩形（想想矩陣）。此“數組”已為矩形，因此將其轉換為張量很容易：

{#if fw === 'pt'}
```py
import torch

model_inputs = torch.tensor(encoded_sequences)
```
{:else}
```py
import tensorflow as tf

model_inputs = tf.constant(encoded_sequences)
```
{/if}

### 使用張量作為模型的輸入



在模型中使用張量非常簡單-我們只需將輸入稱為模型：


```python
output = model(model_inputs)
```



雖然模型接受許多不同的參數，但只需要
input IDs。我們稍後將解釋其他參數的作用以及何時需要它們，但首先我們需要更仔細地瞭解
Transformer模型可以理解的輸入的標記


<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter2/3.mdx" />