# 在論壇上尋求幫助

<DocNotebookDropdown
  classNames="absolute z-10 right-0 top-0"
  options={[
    {label: "Google Colab", value: "https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter8/section3.ipynb"},
    {label: "Aws Studio", value: "https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter8/section3.ipynb"},
]} />

<Youtube id="S2EEG3JIt2A"/>

[Hugging Face 論壇](https://discuss.huggingface.co) 是從開源團隊和更廣泛的 Hugging Face 社區獲得幫助的好地方。以下是論壇某一天的主頁面：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums.png" alt="The Hugging Face forums." width="100%"/>
</div>

在左側，您可以看到各種主題分組的所有類別，而右側顯示了最新的主題。主題是包含標題、類別和描述的帖子；它與我們在創建自己的數據集時看到的 GitHub 問題格式非常相似[Chapter 5](/course/chapter5).顧名思義，[Beginners](https://discuss.huggingface.co/c/beginners/5)類別主要面向剛開始使用 Hugging Face 庫和生態系統的人。歡迎對任何庫提出任何問題，無論是調試一些代碼還是尋求有關如何做某事的幫助。 （也就是說，如果您的問題特別涉及某個圖書館，您可能應該前往論壇上的相應圖書館類別。）

同樣，the [Intermediate](https://discuss.huggingface.co/c/intermediate/6)和[Research](https://discuss.huggingface.co/c/research/7)類別用於更高級的問題，例如關於圖書館或您想討論的一些很酷的新 NLP 研究。

當然，我們也應該提到[Course](https://discuss.huggingface.co/c/course/20)類別，您可以在其中提出與 Hugging Face 課程相關的任何問題！

選擇類別後，您就可以編寫第一個主題了。 你可以找一些[guidelines](https://discuss.huggingface.co/t/how-to-request-support/3128) 在有關如何執行此操作的論壇中，在本節中，我們將看看構成一個好的主題的一些功能。

## 寫一篇好的論壇帖子

作為一個運行示例，假設我們試圖從 Wikipedia 文章生成嵌入表示以創建自定義搜索引擎。像往常一樣，我們按如下方式加載分詞器和模型：

```python
from transformers import AutoTokenizer, AutoModel

model_checkpoint = "distilbert-base-uncased"
tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
model = AutoModel.from_pretrained(model_checkpoint)
```

現在我們嘗試將[變形金剛的維基百科](https://en.wikipedia.org/wiki/Transformers)的一整段進行嵌入表示（熱知識：變形金剛的英文就是 Transformers ，而現在 Transformers 作為一個 🤗 Python 庫也被越來越多人熟知）：

```python
text = """
Generation One is a retroactive term for the Transformers characters that
appeared between 1984 and 1993. The Transformers began with the 1980s Japanese
toy lines Micro Change and Diaclone. They presented robots able to transform
into everyday vehicles, electronic items or weapons. Hasbro bought the Micro
Change and Diaclone toys, and partnered with Takara. Marvel Comics was hired by
Hasbro to create the backstory; editor-in-chief Jim Shooter wrote an overall
story, and gave the task of creating the characthers to writer Dennis O'Neil.
Unhappy with O'Neil's work (although O'Neil created the name "Optimus Prime"),
Shooter chose Bob Budiansky to create the characters.

The Transformers mecha were largely designed by Shōji Kawamori, the creator of
the Japanese mecha anime franchise Macross (which was adapted into the Robotech
franchise in North America). Kawamori came up with the idea of transforming
mechs while working on the Diaclone and Macross franchises in the early 1980s
(such as the VF-1 Valkyrie in Macross and Robotech), with his Diaclone mechs
later providing the basis for Transformers.

The primary concept of Generation One is that the heroic Optimus Prime, the
villainous Megatron, and their finest soldiers crash land on pre-historic Earth
in the Ark and the Nemesis before awakening in 1985, Cybertron hurtling through
the Neutral zone as an effect of the war. The Marvel comic was originally part
of the main Marvel Universe, with appearances from Spider-Man and Nick Fury,
plus some cameos, as well as a visit to the Savage Land.

The Transformers TV series began around the same time. Produced by Sunbow
Productions and Marvel Productions, later Hasbro Productions, from the start it
contradicted Budiansky's backstories. The TV series shows the Autobots looking
for new energy sources, and crash landing as the Decepticons attack. Marvel
interpreted the Autobots as destroying a rogue asteroid approaching Cybertron.
Shockwave is loyal to Megatron in the TV series, keeping Cybertron in a
stalemate during his absence, but in the comic book he attempts to take command
of the Decepticons. The TV series would also differ wildly from the origins
Budiansky had created for the Dinobots, the Decepticon turned Autobot Jetfire
(known as Skyfire on TV), the Constructicons (who combine to form
Devastator),[19][20] and Omega Supreme. The Marvel comic establishes early on
that Prime wields the Creation Matrix, which gives life to machines. In the
second season, the two-part episode The Key to Vector Sigma introduced the
ancient Vector Sigma computer, which served the same original purpose as the
Creation Matrix (giving life to Transformers), and its guardian Alpha Trion.
"""

inputs = tokenizer(text, return_tensors="pt")
logits = model(**inputs).logits
```

```python output
IndexError: index out of range in self
```

呃，我們遇到了一個問題——錯誤信息比我們看到的要神秘得多[section 2](/course/chapter8/section2)!我們無法確定完整回溯的正面或反面，因此我們決定轉向 Hugging Face 論壇尋求幫助。我們如何設計主題？

首先，我們需要點擊右上角的“新建主題”按鈕（注意，要創建主題，我們需要登錄）：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forums-new-topic.png" alt="Creating a new forum topic." width="100%"/>
</div>

這會出現一個寫作界面，我們可以在其中輸入我們的主題標題，選擇一個類別，並起草內容：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic01.png" alt="The interface for creating a forum topic." width="100%"/>
</div>

由於錯誤似乎僅與 🤗 Transformers有關，因此我們將為該類別選擇此錯誤。我們第一次嘗試解釋這個問題可能看起來像這樣：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic02.png" alt="Drafting the content for a new forum topic." width="100%"/>
</div>

儘管本主題包含我們需要幫助的錯誤消息，但其編寫方式存在一些問題：

1. 標題描述性不是很強，因此瀏覽論壇的任何人都無法在不閱讀正文的情況下分辨出主題的內容。

2. 正文沒有提供足夠的信息，說明錯誤來自何處以及如何重現錯誤。

3. 這個話題直接用一種有點苛刻的語氣標記了幾個人。

像這樣的主題不太可能很快得到答案（如果他們得到了答案），那麼讓我們看看如何改進它。我們將從選擇一個好標題的第一個問題開始。

### 選擇描述性標題

如果您想就代碼中的錯誤尋求幫助，一個好的經驗法則是在標題中包含足夠的信息，以便其他人可以快速確定他們是否認為他們可以回答您的問題。在我們的運行示例中，我們知道正在引發的異常的名稱，並有一些提示它是在模型的前向傳遞中觸發的，我們調用 **model(**inputs)** .為了傳達這一點，一個可能的標題可能是：

> 自動建模正向傳遞中的索引錯誤的來源？

這個標題告訴讀者在哪裡你認為錯誤來自，如果他們遇到了 **IndexError** 在此之前，他們很有可能知道如何調試它。當然，標題可以是您想要的任何內容，也可以是其他變體，例如：

> 為什麼我的模型會產生索引錯誤？

也可以。現在我們有了一個描述性的標題，讓我們來看看改善主體。

### 設置代碼段的格式

如：也可以。現在我們有了一個描述性的標題，讓我們來看看改善身體。在 IDE 中閱讀源代碼已經夠難的了，但是當將代碼複製粘貼為純文本時就更難了！幸運的是，Hugging Face 論壇支持使用 Markdown，因此您應該始終用三個反引號 (```) 將代碼塊括起來，以便更容易閱讀。讓我們這樣做來美化錯誤消息——在我們這樣做的時候，讓我們讓正文比我們的原始版本更有禮貌：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic03.png" alt="Our revised forum topic, with proper code formatting." width="100%"/>
</div>

正如您在屏幕截圖中看到的，將代碼塊括在反引號中會將原始文本轉換為格式化代碼，並帶有顏色樣式！另請注意，單個反引號可用於格式化內聯變量，就像我們所做的那樣 **distilbert-base-uncased** .這個主題看起來好多了，如果幸運的話，我們可能會在社區中找到可以猜測錯誤是什麼的人。然而，與其依靠運氣，不如讓我們在其完整的血腥細節中包含回溯，讓生活更輕鬆！

### 包括完整的回溯

由於回溯的最後一行通常足以調試您自己的代碼，因此很容易在您的主題中提供它以“節省空間”。雖然本意是好的，但這實際上使它更難供其他人調試問題，因為回溯中較高的信息也非常有用。因此，一個好的做法是複製並粘貼所有的回溯，同時確保它的格式很好。由於這些回溯可能會很長，有些人更喜歡在解釋了源代碼之後再展示它們。我們開工吧。現在，我們的論壇主題如下所示：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic04.png" alt="Our example forum topic, with the complete traceback." width="100%"/>
</div>

這提供了更多信息，細心的讀者可能會指出問題似乎是由於回溯中的這一行而傳遞了一個長輸入：

> 令牌索引序列長度長於為此模型指定的最大序列長度 （583 > 512）。

但是，通過提供觸發錯誤的實際代碼，我們可以讓他們更輕鬆。我們現在就這樣做。

### 提供可重複的示例

如果您曾經嘗試過調試其他人的代碼，那麼您可能首先嚐試重現他們報告的問題，以便您可以開始通過回溯來查明錯誤。在論壇上獲得（或提供）幫助時沒有什麼不同，所以如果你能提供一個重現錯誤的小例子真的很有幫助。有一半的時間，簡單地完成這個練習將幫助你找出問題所在。在任何情況下，我們的示例缺少的部分是顯示輸入我們提供給模型的。這樣做會為我們提供類似於以下完整示例的內容：

<div class="flex justify-center">
<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter8/forum-topic05.png" alt="The final version of our forum topic." width="100%"/>
</div>

該主題現在包含相當多的信息，並且它的編寫方式更可能吸引社區的注意力並獲得有用的答案。有了這些基本指南，您現在可以創建很棒的主題來找到您的 🤗 Transformers問題的答案！



<EditOnGithub source="https://github.com/huggingface/course/blob/main/chapters/zh-TW/chapter8/3.mdx" />