import{s as ss,o as as,n as ts}from"../chunks/scheduler.0219f8bd.js";import{S as ls,i as ns,g as i,s as l,r,A as is,h as o,f as s,c as n,j as Ot,u as p,x as f,k as Kt,y as os,a,v as c,d,t as h,w as m}from"../chunks/index.f61edf3b.js";import{T as es}from"../chunks/Tip.5d1e3ef4.js";import{C as M}from"../chunks/CodeBlock.38e566ae.js";import{H as w,E as rs}from"../chunks/EditOnGithub.48fa589f.js";function ps(je){let g,y='For the full list of available tasks/pipelines, check out <a href="#available-tasks">this table</a>.';return{c(){g=i("p"),g.innerHTML=y},l(u){g=o(u,"P",{"data-svelte-h":!0}),f(g)!=="svelte-gomgj3"&&(g.innerHTML=y)},m(u,J){a(u,g,J)},p:ts,d(u){u&&s(g)}}}function cs(je){let g,y='By default, models will be downloaded from the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face Hub</a> and stored in <a href="https://developer.mozilla.org/en-US/docs/Web/API/Cache" rel="nofollow">browser cache</a>, but there are ways to specify custom models and cache locations. For more information see <a href="./custom_usage">here</a>.';return{c(){g=i("p"),g.innerHTML=y},l(u){g=o(u,"P",{"data-svelte-h":!0}),f(g)!=="svelte-197t2db"&&(g.innerHTML=y)},m(u,J){a(u,g,J)},p:ts,d(u){u&&s(g)}}}function ds(je){let g,y,u,J,b,be,U,Ut='Just like the <a href="https://github.com/huggingface/transformers" rel="nofollow">transformers Python library</a>, Transformers.js provides users with a simple way to leverage the power of transformers. The <code>pipeline()</code> function is the easiest and fastest way to use a pretrained model for inference.',Ue,j,xe,x,ke,k,xt="Start by creating an instance of <code>pipeline()</code> and specifying a task you want to use it for. For example, to create a sentiment analysis pipeline, you can do:",Ie,I,$e,$,kt="When running for the first time, the <code>pipeline</code> will download and cache the default pretrained model associated with the task. This can take a while, but subsequent calls will be much faster.",ve,T,Ge,v,It="You can now use the classifier on your target text by calling it as a function:",Be,G,Ce,B,$t="If you have multiple inputs, you can pass them as an array:",Ne,C,Ze,N,vt="You can also specify a different model to use for the pipeline by passing it as the second argument to the <code>pipeline()</code> function. For example, to use a different model for sentiment analysis (like one trained to predict sentiment of a review as a number of stars between 1 and 5), you can do:",_e,Z,We,_,Gt='Transformers.js supports loading any model hosted on the Hugging Face Hub, provided it has ONNX weights (located in a subfolder called <code>onnx</code>). For more information on how to convert your PyTorch, TensorFlow, or JAX model to ONNX, see the <a href="./custom_usage#convert-your-models-to-onnx">conversion section</a>.',Xe,W,Bt="The <code>pipeline()</code> function is a great way to quickly use a pretrained model for inference, as it takes care of all the preprocessing and postprocessing for you. For example, if you want to perform Automatic Speech Recognition (ASR) using OpenAI’s Whisper model, you can do:",Qe,X,He,Q,Fe,H,Re,F,Ct=`We offer a variety of options to control how models are loaded from the Hugging Face Hub (or locally).
By default, the <em>quantized</em> version of the model is used, which is smaller and faster, but usually less accurate.
To override this behaviour (i.e., use the unquantized model), you can use a custom <code>PretrainedOptions</code> object
as the third parameter to the <code>pipeline</code> function:`,Se,R,Ye,S,Nt=`You can also specify which revision of the model to use, by passing a <code>revision</code> parameter.
Since the Hugging Face Hub uses a git-based versioning system, you can use any valid git revision specifier (e.g., branch name or commit hash)`,Ee,Y,Ae,E,Zt='For the full list of options, check out the <a href="./api/utils/hub#module_utils/hub..PretrainedOptions">PretrainedOptions</a> documentation.',Le,A,ze,L,_t="Many pipelines have additional options that you can specify. For example, when using a model that does multilingual translation, you can specify the source and target languages like this:",Ve,z,Pe,V,Wt='When using models that support auto-regressive generation, you can specify generation parameters like the number of new tokens, sampling methods, temperature, repetition penalty, and much more. For a full list of available parameters, see to the <a href="./api/utils/generation#module_utils/generation.GenerationConfig">GenerationConfig</a> class.',qe,P,Xt="For example, to generate a poem using <code>LaMini-Flan-T5-783M</code>, you can do:",De,q,Oe,D,Qt="Logging <code>result[0].generated_text</code> to the console gives:",Ke,O,et,K,tt,ee,Ht="Some pipelines such as <code>text-generation</code> or <code>automatic-speech-recognition</code> support streaming output. This is achieved using the <code>TextStreamer</code> class. For example, when using a chat model like <code>Qwen2.5-Coder-0.5B-Instruct</code>, you can specify a callback function that will be called with each generated token text (if unset, new tokens will be printed to the console).",st,te,at,se,Ft="Logging <code>result[0].generated_text</code> to the console gives:",lt,ae,Rt=`<summary>Click to view the console output</summary> <pre>Here&#39;s a simple implementation of the quick sort algorithm in Python:
\`\`\`python
def quick_sort(arr):
    if len(arr) &lt;= 1:
        return arr
    pivot = arr[len(arr) // 2]
    left = [x for x in arr if x &lt; pivot]
    middle = [x for x in arr if x == pivot]
    right = [x for x in arr if x &gt; pivot]
    return quick_sort(left) + middle + quick_sort(right)
# Example usage:
arr = [3, 6, 8, 10, 1, 2]
sorted_arr = quick_sort(arr)
print(sorted_arr)
\`\`\`
### Explanation:
- **Base Case**: If the array has less than or equal to one element (i.e., \`len(arr)\` is less than or equal to \`1\`), it is already sorted and can be returned as is.
- **Pivot Selection**: The pivot is chosen as the middle element of the array.
- **Partitioning**: The array is partitioned into three parts: elements less than the pivot (\`left\`), elements equal to the pivot (\`middle\`), and elements greater than the pivot (\`right\`). These partitions are then recursively sorted.
- **Recursive Sorting**: The subarrays are sorted recursively using \`quick_sort\`.
This approach ensures that each recursive call reduces the problem size by half until it reaches a base case.
</pre>`,nt,le,St="This streaming feature allows you to process the output as it is generated, rather than waiting for the entire output to be generated before processing it.",it,ne,Yt=`For more information on the available options for each pipeline, refer to the <a href="./api/pipelines">API Reference</a>.
If you would like more control over the inference process, you can use the <a href="./api/models"><code>AutoModel</code></a>, <a href="./api/tokenizers"><code>AutoTokenizer</code></a>, or <a href="./api/processors"><code>AutoProcessor</code></a> classes instead.`,ot,ie,rt,oe,pt,re,ct,pe,Et='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/fill-mask" rel="nofollow">Fill-Mask</a></td> <td><code>fill-mask</code></td> <td>Masking some of the words in a sentence and predicting which words should replace those masks.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FillMaskPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=fill-mask&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/question-answering" rel="nofollow">Question Answering</a></td> <td><code>question-answering</code></td> <td>Retrieve the answer to a question from a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.QuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/sentence-similarity" rel="nofollow">Sentence Similarity</a></td> <td><code>sentence-similarity</code></td> <td>Determining how similar two texts are.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=sentence-similarity&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/summarization" rel="nofollow">Summarization</a></td> <td><code>summarization</code></td> <td>Producing a shorter version of a document while preserving its important information.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.SummarizationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=summarization&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/table-question-answering" rel="nofollow">Table Question Answering</a></td> <td><code>table-question-answering</code></td> <td>Answering a question about information from a given table.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/text-classification" rel="nofollow">Text Classification</a></td> <td><code>text-classification</code> or <code>sentiment-analysis</code></td> <td>Assigning a label or class to a given text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#completion-generation-models" rel="nofollow">Text Generation</a></td> <td><code>text-generation</code></td> <td>Producing new text by predicting the next word in a sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-generation#text-to-text-generation-models" rel="nofollow">Text-to-text Generation</a></td> <td><code>text2text-generation</code></td> <td>Converting one text sequence into another text sequence.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.Text2TextGenerationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text2text-generation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/token-classification" rel="nofollow">Token Classification</a></td> <td><code>token-classification</code> or <code>ner</code></td> <td>Assigning a label to each token in a text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TokenClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=token-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/translation" rel="nofollow">Translation</a></td> <td><code>translation</code></td> <td>Converting text from one language to another.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TranslationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=translation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-classification" rel="nofollow">Zero-Shot Classification</a></td> <td><code>zero-shot-classification</code></td> <td>Classifying text into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/feature-extraction" rel="nofollow">Feature Extraction</a></td> <td><code>feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original dataset.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.FeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',dt,ce,ht,de,At='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/image-segmentation#background-removal" rel="nofollow">Background Removal</a></td> <td><code>background-removal</code></td> <td>Isolating the main subject of an image by removing or making the background transparent.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.BackgroundRemovalPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=background-removal&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/depth-estimation" rel="nofollow">Depth Estimation</a></td> <td><code>depth-estimation</code></td> <td>Predicting the depth of objects present in an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DepthEstimationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-classification" rel="nofollow">Image Classification</a></td> <td><code>image-classification</code></td> <td>Assigning a label or class to an entire image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-segmentation" rel="nofollow">Image Segmentation</a></td> <td><code>image-segmentation</code></td> <td>Divides an image into segments where each pixel is mapped to an object. This task has multiple variants such as instance segmentation, panoptic segmentation and semantic segmentation.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageSegmentationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-segmentation&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-image" rel="nofollow">Image-to-Image</a></td> <td><code>image-to-image</code></td> <td>Transforming a source image to match the characteristics of a target image or a target image domain.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToImagePipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-image&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/mask-generation" rel="nofollow">Mask Generation</a></td> <td><code>mask-generation</code></td> <td>Generate masks for the objects in an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/object-detection" rel="nofollow">Object Detection</a></td> <td><code>object-detection</code></td> <td>Identify objects of certain defined classes within an image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/video-classification" rel="nofollow">Video Classification</a></td> <td>n/a</td> <td>Assigning a label or class to an entire video.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/unconditional-image-generation" rel="nofollow">Unconditional Image Generation</a></td> <td>n/a</td> <td>Generating images with no condition in any context (like a prompt text or another image).</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/image-feature-extraction" rel="nofollow">Image Feature Extraction</a></td> <td><code>image-feature-extraction</code></td> <td>Transforming raw data into numerical features that can be processed while preserving the information in the original image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageFeatureExtractionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-feature-extraction&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',mt,he,ft,me,Lt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/audio-classification" rel="nofollow">Audio Classification</a></td> <td><code>audio-classification</code></td> <td>Assigning a label or class to a given audio.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/audio-to-audio" rel="nofollow">Audio-to-Audio</a></td> <td>n/a</td> <td>Generating audio from an input audio source.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/automatic-speech-recognition" rel="nofollow">Automatic Speech Recognition</a></td> <td><code>automatic-speech-recognition</code></td> <td>Transcribing a given audio into text.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.AutomaticSpeechRecognitionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-speech" rel="nofollow">Text-to-Speech</a></td> <td><code>text-to-speech</code> or <code>text-to-audio</code></td> <td>Generating natural-sounding speech given text input.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.TextToAudioPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=text-to-audio&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',gt,fe,ut,ge,zt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/tabular-classification" rel="nofollow">Tabular Classification</a></td> <td>n/a</td> <td>Classifying a target category (a group) based on set of attributes.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/tabular-regression" rel="nofollow">Tabular Regression</a></td> <td>n/a</td> <td>Predicting a numerical value given a set of attributes.</td> <td>❌</td></tr></tbody>',wt,ue,Mt,we,Vt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/document-question-answering" rel="nofollow">Document Question Answering</a></td> <td><code>document-question-answering</code></td> <td>Answering questions on document images.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.DocumentQuestionAnsweringPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=document-question-answering&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/image-to-text" rel="nofollow">Image-to-Text</a></td> <td><code>image-to-text</code></td> <td>Output text from a given image.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ImageToTextPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=image-to-text&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/text-to-image" rel="nofollow">Text-to-Image</a></td> <td><code>text-to-image</code></td> <td>Generates images from input text.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/tasks/visual-question-answering" rel="nofollow">Visual Question Answering</a></td> <td><code>visual-question-answering</code></td> <td>Answering open-ended questions based on an image.</td> <td>❌</td></tr> <tr><td><a href="https://huggingface.co/learn/audio-course/chapter4/classification_models#zero-shot-audio-classification" rel="nofollow">Zero-Shot Audio Classification</a></td> <td><code>zero-shot-audio-classification</code></td> <td>Classifying audios into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotAudioClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-audio-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-image-classification" rel="nofollow">Zero-Shot Image Classification</a></td> <td><code>zero-shot-image-classification</code></td> <td>Classifying images into classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotImageClassificationPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?pipeline_tag=zero-shot-image-classification&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr> <tr><td><a href="https://huggingface.co/tasks/zero-shot-object-detection" rel="nofollow">Zero-Shot Object Detection</a></td> <td><code>zero-shot-object-detection</code></td> <td>Identify objects of classes that are unseen during training.</td> <td>✅ <a href="https://huggingface.co/docs/transformers.js/api/pipelines#module_pipelines.ZeroShotObjectDetectionPipeline" rel="nofollow">(docs)</a><br/><a href="https://huggingface.co/models?other=zero-shot-object-detection&amp;library=transformers.js" rel="nofollow">(models)</a></td></tr></tbody>',yt,Me,Jt,ye,Pt='<thead><tr><th>Task</th> <th>ID</th> <th>Description</th> <th>Supported?</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/tasks/reinforcement-learning" rel="nofollow">Reinforcement Learning</a></td> <td>n/a</td> <td>Learning from actions by interacting with an environment through trial and error and receiving rewards (negative or positive) as feedback.</td> <td>✅</td></tr></tbody>',jt,Je,Tt,Te,bt;return b=new w({props:{title:"The pipeline API",local:"the-pipeline-api",headingTag:"h1"}}),j=new es({props:{$$slots:{default:[ps]},$$scope:{ctx:je}}}),x=new w({props:{title:"The basics",local:"the-basics",headingTag:"h2"}}),I=new M({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWNvbnN0JTIwY2xhc3NpZmllciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcycpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">const</span> classifier = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>);`,wrap:!1}}),T=new es({props:{$$slots:{default:[cs]},$$scope:{ctx:je}}}),G=new M({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzIScpJTNCJTBBJTJGJTJGJTIwJTVCJTdCJ2xhYmVsJyUzQSUyMCdQT1NJVElWRSclMkMlMjAnc2NvcmUnJTNBJTIwMC45OTk4JTdEJTVE",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>(<span class="hljs-string">&#x27;I love transformers!&#x27;</span>);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}]</span>`,wrap:!1}}),C=new M({props:{code:"Y29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMGNsYXNzaWZpZXIoJTVCJ0klMjBsb3ZlJTIwdHJhbnNmb3JtZXJzISclMkMlMjAnSSUyMGhhdGUlMjB0cmFuc2Zvcm1lcnMhJyU1RCklM0IlMEElMkYlMkYlMjAlNUIlN0InbGFiZWwnJTNBJTIwJ1BPU0lUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5OTglN0QlMkMlMjAlN0InbGFiZWwnJTNBJTIwJ05FR0FUSVZFJyUyQyUyMCdzY29yZSclM0ElMjAwLjk5ODIlN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">classifier</span>([<span class="hljs-string">&#x27;I love transformers!&#x27;</span>, <span class="hljs-string">&#x27;I hate transformers!&#x27;</span>]);
<span class="hljs-comment">// [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9998}, {&#x27;label&#x27;: &#x27;NEGATIVE&#x27;, &#x27;score&#x27;: 0.9982}]</span>`,wrap:!1}}),Z=new M({props:{code:"Y29uc3QlMjByZXZpZXdlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3NlbnRpbWVudC1hbmFseXNpcyclMkMlMjAnWGVub3ZhJTJGYmVydC1iYXNlLW11bHRpbGluZ3VhbC11bmNhc2VkLXNlbnRpbWVudCcpJTNCJTBBJTBBY29uc3QlMjByZXN1bHQlMjAlM0QlMjBhd2FpdCUyMHJldmlld2VyKCdUaGUlMjBTaGF3c2hhbmslMjBSZWRlbXB0aW9uJTIwaXMlMjBhJTIwdHJ1ZSUyMG1hc3RlcnBpZWNlJTIwb2YlMjBjaW5lbWEuJyklM0IlMEElMkYlMkYlMjAlNUIlN0JsYWJlbCUzQSUyMCc1JTIwc3RhcnMnJTJDJTIwc2NvcmUlM0ElMjAwLjgxNjc5Mjk2NDkzNTMwMjclN0QlNUQ=",highlighted:`<span class="hljs-keyword">const</span> reviewer = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;sentiment-analysis&#x27;</span>, <span class="hljs-string">&#x27;Xenova/bert-base-multilingual-uncased-sentiment&#x27;</span>);

<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">reviewer</span>(<span class="hljs-string">&#x27;The Shawshank Redemption is a true masterpiece of cinema.&#x27;</span>);
<span class="hljs-comment">// [{label: &#x27;5 stars&#x27;, score: 0.8167929649353027}]</span>`,wrap:!1}}),X=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjBBdXRvbWF0aWMlMjBTcGVlY2glMjBSZWNvZ25pdGlvbiUwQWNvbnN0JTIwdHJhbnNjcmliZXIlMjAlM0QlMjBhd2FpdCUyMHBpcGVsaW5lKCdhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJyUyQyUyMCdYZW5vdmElMkZ3aGlzcGVyLXNtYWxsLmVuJyklM0IlMEElMEElMkYlMkYlMjBUcmFuc2NyaWJlJTIwYW4lMjBhdWRpbyUyMGZpbGUlMkMlMjBsb2FkZWQlMjBmcm9tJTIwYSUyMFVSTC4lMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNjcmliZXIoJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMnKSUzQiUwQSUyRiUyRiUyMCU3QnRleHQlM0ElMjAnJTIwSSUyMGhhdmUlMjBhJTIwZHJlYW0lMjB0aGF0JTIwb25lJTIwZGF5JTIwdGhpcyUyMG5hdGlvbiUyMHdpbGwlMjByaXNlJTIwdXAlMjBhbmQlMjBsaXZlJTIwb3V0JTIwdGhlJTIwdHJ1ZSUyMG1lYW5pbmclMjBvZiUyMGl0cyUyMGNyZWVkLiclN0Q=",highlighted:`<span class="hljs-comment">// Allocate a pipeline for Automatic Speech Recognition</span>
<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-small.en&#x27;</span>);

<span class="hljs-comment">// Transcribe an audio file, loaded from a URL.</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">transcriber</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>);
<span class="hljs-comment">// {text: &#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;}</span>`,wrap:!1}}),Q=new w({props:{title:"Pipeline options",local:"pipeline-options",headingTag:"h2"}}),H=new w({props:{title:"Loading",local:"loading",headingTag:"h3"}}),R=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMGZlYXR1cmUlMjBleHRyYWN0aW9uJTJDJTIwdXNpbmclMjB0aGUlMjB1bnF1YW50aXplZCUyMG1vZGVsJTBBY29uc3QlMjBwaXBlJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgnZmVhdHVyZS1leHRyYWN0aW9uJyUyQyUyMCdYZW5vdmElMkZhbGwtTWluaUxNLUw2LXYyJyUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1YW50aXplZCUzQSUyMGZhbHNlJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for feature extraction, using the unquantized model</span>
<span class="hljs-keyword">const</span> pipe = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;feature-extraction&#x27;</span>, <span class="hljs-string">&#x27;Xenova/all-MiniLM-L6-v2&#x27;</span>, {
    <span class="hljs-attr">quantized</span>: <span class="hljs-literal">false</span>,
});`,wrap:!1}}),Y=new M({props:{code:"Y29uc3QlMjB0cmFuc2NyaWJlciUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ2F1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24nJTJDJTIwJ1hlbm92YSUyRndoaXNwZXItdGlueS5lbiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjByZXZpc2lvbiUzQSUyMCdvdXRwdXRfYXR0ZW50aW9ucyclMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">const</span> transcriber = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;automatic-speech-recognition&#x27;</span>, <span class="hljs-string">&#x27;Xenova/whisper-tiny.en&#x27;</span>, {
    <span class="hljs-attr">revision</span>: <span class="hljs-string">&#x27;output_attentions&#x27;</span>,
});`,wrap:!1}}),A=new w({props:{title:"Running",local:"running",headingTag:"h3"}}),z=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGlvbiUyMGElMjBwaXBlbGluZSUyMGZvciUyMHRyYW5zbGF0aW9uJTBBY29uc3QlMjB0cmFuc2xhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSgndHJhbnNsYXRpb24nJTJDJTIwJ1hlbm92YSUyRm5sbGItMjAwLWRpc3RpbGxlZC02MDBNJyklM0IlMEElMEElMkYlMkYlMjBUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR3JlZWslMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwdHJhbnNsYXRvcignSSUyMGxpa2UlMjB0byUyMHdhbGslMjBteSUyMGRvZy4nJTJDJTIwJTdCJTBBJTIwJTIwJTIwJTIwc3JjX2xhbmclM0ElMjAnZW5nX0xhdG4nJTJDJTBBJTIwJTIwJTIwJTIwdGd0X2xhbmclM0ElMjAnZWxsX0dyZWsnJTBBJTdEKSUzQiUwQSUyRiUyRiUyMCU1QiUyMCU3QiUyMHRyYW5zbGF0aW9uX3RleHQlM0ElMjAnJUNFJTlDJUNFJUJGJUNGJTg1JTIwJUNFJUIxJUNGJTgxJUNFJUFEJUNGJTgzJUNFJUI1JUNFJUI5JTIwJUNFJUJEJUNFJUIxJTIwJUNGJTgwJUNFJUI1JUNGJTgxJUNGJTgwJUNFJUIxJUNGJTg0JUNFJUFDJUNGJTg5JTIwJUNGJTg0JUNFJUJGJTIwJUNGJTgzJUNFJUJBJUNGJTg1JUNFJUJCJUNFJUFGJTIwJUNFJUJDJUNFJUJGJUNGJTg1LiclMjAlN0QlMjAlNUQlMEElMEElMkYlMkYlMjBUcmFuc2xhdGUlMjBiYWNrJTIwdG8lMjBFbmdsaXNoJTBBY29uc3QlMjByZXN1bHQyJTIwJTNEJTIwYXdhaXQlMjB0cmFuc2xhdG9yKHJlc3VsdCU1QjAlNUQudHJhbnNsYXRpb25fdGV4dCUyQyUyMCU3QiUwQSUyMCUyMCUyMCUyMHNyY19sYW5nJTNBJTIwJ2VsbF9HcmVrJyUyQyUwQSUyMCUyMCUyMCUyMHRndF9sYW5nJTNBJTIwJ2VuZ19MYXRuJyUwQSU3RCklM0IlMEElMkYlMkYlMjAlNUIlMjAlN0IlMjB0cmFuc2xhdGlvbl90ZXh0JTNBJTIwJ0klMjBsaWtlJTIwdG8lMjB3YWxrJTIwbXklMjBkb2cuJyUyMCU3RCUyMCU1RA==",highlighted:`<span class="hljs-comment">// Allocation a pipeline for translation</span>
<span class="hljs-keyword">const</span> translator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;translation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/nllb-200-distilled-600M&#x27;</span>);

<span class="hljs-comment">// Translate from English to Greek</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(<span class="hljs-string">&#x27;I like to walk my dog.&#x27;</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;Μου αρέσει να περπατάω το σκυλί μου.&#x27; } ]</span>

<span class="hljs-comment">// Translate back to English</span>
<span class="hljs-keyword">const</span> result2 = <span class="hljs-keyword">await</span> <span class="hljs-title function_">translator</span>(result[<span class="hljs-number">0</span>].<span class="hljs-property">translation_text</span>, {
    <span class="hljs-attr">src_lang</span>: <span class="hljs-string">&#x27;ell_Grek&#x27;</span>,
    <span class="hljs-attr">tgt_lang</span>: <span class="hljs-string">&#x27;eng_Latn&#x27;</span>
});
<span class="hljs-comment">// [ { translation_text: &#x27;I like to walk my dog.&#x27; } ]</span>`,wrap:!1}}),q=new M({props:{code:"JTJGJTJGJTIwQWxsb2NhdGUlMjBhJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0MnRleHQtZ2VuZXJhdGlvbiUwQWNvbnN0JTIwcG9ldCUyMCUzRCUyMGF3YWl0JTIwcGlwZWxpbmUoJ3RleHQydGV4dC1nZW5lcmF0aW9uJyUyQyUyMCdYZW5vdmElMkZMYU1pbmktRmxhbi1UNS03ODNNJyklM0IlMEFjb25zdCUyMHJlc3VsdCUyMCUzRCUyMGF3YWl0JTIwcG9ldCgnV3JpdGUlMjBtZSUyMGElMjBsb3ZlJTIwcG9lbSUyMGFib3V0JTIwY2hlZXNlLiclMkMlMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDIwMCUyQyUwQSUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNBJTIwMC45JTJDJTBBJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNBJTIwMi4wJTJDJTBBJTIwJTIwJTIwJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0ElMjAzJTJDJTBBJTdEKSUzQg==",highlighted:`<span class="hljs-comment">// Allocate a pipeline for text2text-generation</span>
<span class="hljs-keyword">const</span> poet = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(<span class="hljs-string">&#x27;text2text-generation&#x27;</span>, <span class="hljs-string">&#x27;Xenova/LaMini-Flan-T5-783M&#x27;</span>);
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">poet</span>(<span class="hljs-string">&#x27;Write me a love poem about cheese.&#x27;</span>, {
    <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">200</span>,
    <span class="hljs-attr">temperature</span>: <span class="hljs-number">0.9</span>,
    <span class="hljs-attr">repetition_penalty</span>: <span class="hljs-number">2.0</span>,
    <span class="hljs-attr">no_repeat_ngram_size</span>: <span class="hljs-number">3</span>,
});`,wrap:!1}}),O=new M({props:{code:"Q2hlZXNlJTJDJTIwb2glMjBjaGVlc2UhJTIwWW91J3JlJTIwdGhlJTIwcGVyZmVjdCUyMGNvbWZvcnQlMjBmb29kLiUwQVlvdXIlMjB0ZXh0dXJlJTIwc28lMjBzbW9vdGglMjBhbmQlMjBjcmVhbXklMjB5b3UlMjBjYW4lMjBuZXZlciUyMGdldCUyMG9sZC4lMEFXaXRoJTIwZXZlcnklMjBiaXRlJTIwaXQlMjBtZWx0cyUyMGluJTIweW91ciUyMG1vdXRoJTIwbGlrZSUyMGJ1dHRlcnklMjBkZWxpZ2h0cyUwQXRoYXQlMjBtYWtlJTIwbWUlMjBmZWVsJTIwcmlnaHQlMjBhdCUyMGhvbWUlMjB3aXRoJTIwdGhpcyUyMHN3ZWV0JTIwdHJlYXQlMjBvZiUyMG1pbmUuJTIwJTBBJTBBRnJvbSUyMGNsYXNzaWMlMjB0byUyMGJvbGQlMjBmbGF2b3IlMjBjb21iaW5hdGlvbnMlMkMlMEFJJTIwbG92ZSUyMGhvdyUyMHZlcnNhdGlsZSUyMHlvdSUyMGFyZSUyMGFzJTIwYW4lMjBpbmdyZWRpZW50JTIwdG9vJTNGJTBBQ2hlZGRhciUyMGlzJTIwbXklMjBnby10byUyMGZvciUyMGFueSUyMG9jY2FzaW9uJTIwb3IlMjBtb29kJTNCJTIwJTBBSXQlMjBhZGRzJTIwZGVwdGglMjBhbmQlMjByaWNobmVzcyUyMHdpdGhvdXQlMjBiZWluZyUyMG92ZXJwb3dlcmluZyUyMGl0cyUyMHRhc3RlJTIwYnVkcyUyMGFsb25l",highlighted:`Cheese, oh cheese! You&#x27;re <span class="hljs-keyword">the</span> perfect comfort food.
Your texture so smooth <span class="hljs-keyword">and</span> creamy you can never <span class="hljs-keyword">get</span> old.
With <span class="hljs-keyword">every</span> bite <span class="hljs-keyword">it</span> melts <span class="hljs-keyword">in</span> your mouth like buttery delights
<span class="hljs-keyword">that</span> make <span class="hljs-keyword">me</span> feel right <span class="hljs-keyword">at</span> home <span class="hljs-keyword">with</span> this sweet treat <span class="hljs-keyword">of</span> mine. 

From classic <span class="hljs-keyword">to</span> bold flavor combinations,
I love how versatile you are <span class="hljs-keyword">as</span> an ingredient too?
Cheddar <span class="hljs-keyword">is</span> <span class="hljs-keyword">my</span> go-<span class="hljs-keyword">to</span> <span class="hljs-keyword">for</span> any occasion <span class="hljs-keyword">or</span> mood; 
It adds depth <span class="hljs-keyword">and</span> richness <span class="hljs-keyword">without</span> being overpowering <span class="hljs-keyword">its</span> taste buds alone`,wrap:!1}}),K=new w({props:{title:"Streaming",local:"streaming",headingTag:"h3"}}),te=new M({props:{code:"aW1wb3J0JTIwJTdCJTIwcGlwZWxpbmUlMkMlMjBUZXh0U3RyZWFtZXIlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMlMjIlM0IlMEElMEElMkYlMkYlMjBDcmVhdGUlMjBhJTIwdGV4dCUyMGdlbmVyYXRpb24lMjBwaXBlbGluZSUwQWNvbnN0JTIwZ2VuZXJhdG9yJTIwJTNEJTIwYXdhaXQlMjBwaXBlbGluZSglMEElMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjJvbm54LWNvbW11bml0eSUyRlF3ZW4yLjUtQ29kZXItMC41Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCU3QiUyMGR0eXBlJTNBJTIwJTIycTQlMjIlMjAlN0QlMkMlMEEpJTNCJTBBJTBBJTJGJTJGJTIwRGVmaW5lJTIwdGhlJTIwbGlzdCUyMG9mJTIwbWVzc2FnZXMlMEFjb25zdCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTdCJTIwcm9sZSUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlMjAlN0QlMkMlMEElMjAlMjAlN0IlMjByb2xlJTNBJTIwJTIydXNlciUyMiUyQyUyMGNvbnRlbnQlM0ElMjAlMjAlMjJXcml0ZSUyMGElMjBxdWljayUyMHNvcnQlMjBhbGdvcml0aG0uJTIyJTIwJTdEJTJDJTBBJTVEJTNCJTBBJTBBJTJGJTJGJTIwQ3JlYXRlJTIwdGV4dCUyMHN0cmVhbWVyJTBBY29uc3QlMjBzdHJlYW1lciUyMCUzRCUyMG5ldyUyMFRleHRTdHJlYW1lcihnZW5lcmF0b3IudG9rZW5pemVyJTJDJTIwJTdCJTBBJTIwJTIwc2tpcF9wcm9tcHQlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTJGJTJGJTIwT3B0aW9uYWxseSUyQyUyMGRvJTIwc29tZXRoaW5nJTIwd2l0aCUyMHRoZSUyMHRleHQlMjAoZS5nLiUyQyUyMHdyaXRlJTIwdG8lMjBhJTIwdGV4dGJveCklMEElMjAlMjAlMkYlMkYlMjBjYWxsYmFja19mdW5jdGlvbiUzQSUyMCh0ZXh0KSUyMCUzRCUzRSUyMCU3QiUyMCUyRiolMjBEbyUyMHNvbWV0aGluZyUyMHdpdGglMjB0ZXh0JTIwKiUyRiUyMCU3RCUyQyUwQSU3RCklMEElMEElMkYlMkYlMjBHZW5lcmF0ZSUyMGElMjByZXNwb25zZSUwQWNvbnN0JTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBnZW5lcmF0b3IobWVzc2FnZXMlMkMlMjAlN0IlMjBtYXhfbmV3X3Rva2VucyUzQSUyMDUxMiUyQyUyMGRvX3NhbXBsZSUzQSUyMGZhbHNlJTJDJTIwc3RyZWFtZXIlMjAlN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { pipeline, <span class="hljs-title class_">TextStreamer</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/transformers&quot;</span>;

<span class="hljs-comment">// Create a text generation pipeline</span>
<span class="hljs-keyword">const</span> generator = <span class="hljs-keyword">await</span> <span class="hljs-title function_">pipeline</span>(
  <span class="hljs-string">&quot;text-generation&quot;</span>,
  <span class="hljs-string">&quot;onnx-community/Qwen2.5-Coder-0.5B-Instruct&quot;</span>,
  { <span class="hljs-attr">dtype</span>: <span class="hljs-string">&quot;q4&quot;</span> },
);

<span class="hljs-comment">// Define the list of messages</span>
<span class="hljs-keyword">const</span> messages = [
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-attr">content</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
  { <span class="hljs-attr">role</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-attr">content</span>:  <span class="hljs-string">&quot;Write a quick sort algorithm.&quot;</span> },
];

<span class="hljs-comment">// Create text streamer</span>
<span class="hljs-keyword">const</span> streamer = <span class="hljs-keyword">new</span> <span class="hljs-title class_">TextStreamer</span>(generator.<span class="hljs-property">tokenizer</span>, {
  <span class="hljs-attr">skip_prompt</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-comment">// Optionally, do something with the text (e.g., write to a textbox)</span>
  <span class="hljs-comment">// callback_function: (text) =&gt; { /* Do something with text */ },</span>
})

<span class="hljs-comment">// Generate a response</span>
<span class="hljs-keyword">const</span> result = <span class="hljs-keyword">await</span> <span class="hljs-title function_">generator</span>(messages, { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">512</span>, <span class="hljs-attr">do_sample</span>: <span class="hljs-literal">false</span>, streamer });`,wrap:!1}}),ie=new w({props:{title:"Available tasks",local:"available-tasks",headingTag:"h2"}}),oe=new w({props:{title:"Tasks",local:"tasks",headingTag:"h3"}}),re=new w({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h4"}}),ce=new w({props:{title:"Vision",local:"vision",headingTag:"h4"}}),he=new w({props:{title:"Audio",local:"audio",headingTag:"h4"}}),fe=new w({props:{title:"Tabular",local:"tabular",headingTag:"h4"}}),ue=new w({props:{title:"Multimodal",local:"multimodal",headingTag:"h4"}}),Me=new w({props:{title:"Reinforcement Learning",local:"reinforcement-learning",headingTag:"h4"}}),Je=new rs({props:{source:"https://github.com/huggingface/transformers.js/blob/main/docs/source/pipelines.md"}}),{c(){g=i("meta"),y=l(),u=i("p"),J=l(),r(b.$$.fragment),be=l(),U=i("p"),U.innerHTML=Ut,Ue=l(),r(j.$$.fragment),xe=l(),r(x.$$.fragment),ke=l(),k=i("p"),k.innerHTML=xt,Ie=l(),r(I.$$.fragment),$e=l(),$=i("p"),$.innerHTML=kt,ve=l(),r(T.$$.fragment),Ge=l(),v=i("p"),v.textContent=It,Be=l(),r(G.$$.fragment),Ce=l(),B=i("p"),B.textContent=$t,Ne=l(),r(C.$$.fragment),Ze=l(),N=i("p"),N.innerHTML=vt,_e=l(),r(Z.$$.fragment),We=l(),_=i("p"),_.innerHTML=Gt,Xe=l(),W=i("p"),W.innerHTML=Bt,Qe=l(),r(X.$$.fragment),He=l(),r(Q.$$.fragment),Fe=l(),r(H.$$.fragment),Re=l(),F=i("p"),F.innerHTML=Ct,Se=l(),r(R.$$.fragment),Ye=l(),S=i("p"),S.innerHTML=Nt,Ee=l(),r(Y.$$.fragment),Ae=l(),E=i("p"),E.innerHTML=Zt,Le=l(),r(A.$$.fragment),ze=l(),L=i("p"),L.textContent=_t,Ve=l(),r(z.$$.fragment),Pe=l(),V=i("p"),V.innerHTML=Wt,qe=l(),P=i("p"),P.innerHTML=Xt,De=l(),r(q.$$.fragment),Oe=l(),D=i("p"),D.innerHTML=Qt,Ke=l(),r(O.$$.fragment),et=l(),r(K.$$.fragment),tt=l(),ee=i("p"),ee.innerHTML=Ht,st=l(),r(te.$$.fragment),at=l(),se=i("p"),se.innerHTML=Ft,lt=l(),ae=i("details"),ae.innerHTML=Rt,nt=l(),le=i("p"),le.textContent=St,it=l(),ne=i("p"),ne.innerHTML=Yt,ot=l(),r(ie.$$.fragment),rt=l(),r(oe.$$.fragment),pt=l(),r(re.$$.fragment),ct=l(),pe=i("table"),pe.innerHTML=Et,dt=l(),r(ce.$$.fragment),ht=l(),de=i("table"),de.innerHTML=At,mt=l(),r(he.$$.fragment),ft=l(),me=i("table"),me.innerHTML=Lt,gt=l(),r(fe.$$.fragment),ut=l(),ge=i("table"),ge.innerHTML=zt,wt=l(),r(ue.$$.fragment),Mt=l(),we=i("table"),we.innerHTML=Vt,yt=l(),r(Me.$$.fragment),Jt=l(),ye=i("table"),ye.innerHTML=Pt,jt=l(),r(Je.$$.fragment),Tt=l(),Te=i("p"),this.h()},l(e){const t=is("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),y=n(e),u=o(e,"P",{}),Ot(u).forEach(s),J=n(e),p(b.$$.fragment,e),be=n(e),U=o(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-i79xeb"&&(U.innerHTML=Ut),Ue=n(e),p(j.$$.fragment,e),xe=n(e),p(x.$$.fragment,e),ke=n(e),k=o(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1fxrwx6"&&(k.innerHTML=xt),Ie=n(e),p(I.$$.fragment,e),$e=n(e),$=o(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-q94tv7"&&($.innerHTML=kt),ve=n(e),p(T.$$.fragment,e),Ge=n(e),v=o(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1iimk7d"&&(v.textContent=It),Be=n(e),p(G.$$.fragment,e),Ce=n(e),B=o(e,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1rl0sgr"&&(B.textContent=$t),Ne=n(e),p(C.$$.fragment,e),Ze=n(e),N=o(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1ceakdm"&&(N.innerHTML=vt),_e=n(e),p(Z.$$.fragment,e),We=n(e),_=o(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-6d1hww"&&(_.innerHTML=Gt),Xe=n(e),W=o(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-16cwp52"&&(W.innerHTML=Bt),Qe=n(e),p(X.$$.fragment,e),He=n(e),p(Q.$$.fragment,e),Fe=n(e),p(H.$$.fragment,e),Re=n(e),F=o(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-1fmte3u"&&(F.innerHTML=Ct),Se=n(e),p(R.$$.fragment,e),Ye=n(e),S=o(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-1ocw6xp"&&(S.innerHTML=Nt),Ee=n(e),p(Y.$$.fragment,e),Ae=n(e),E=o(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-166r3ga"&&(E.innerHTML=Zt),Le=n(e),p(A.$$.fragment,e),ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1pm722b"&&(L.textContent=_t),Ve=n(e),p(z.$$.fragment,e),Pe=n(e),V=o(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1ml0f50"&&(V.innerHTML=Wt),qe=n(e),P=o(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1tl1lis"&&(P.innerHTML=Xt),De=n(e),p(q.$$.fragment,e),Oe=n(e),D=o(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-1y86c95"&&(D.innerHTML=Qt),Ke=n(e),p(O.$$.fragment,e),et=n(e),p(K.$$.fragment,e),tt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-9navcy"&&(ee.innerHTML=Ht),st=n(e),p(te.$$.fragment,e),at=n(e),se=o(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-1y86c95"&&(se.innerHTML=Ft),lt=n(e),ae=o(e,"DETAILS",{"data-svelte-h":!0}),f(ae)!=="svelte-f75h31"&&(ae.innerHTML=Rt),nt=n(e),le=o(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-1yu2d49"&&(le.textContent=St),it=n(e),ne=o(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-iq082d"&&(ne.innerHTML=Yt),ot=n(e),p(ie.$$.fragment,e),rt=n(e),p(oe.$$.fragment,e),pt=n(e),p(re.$$.fragment,e),ct=n(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),f(pe)!=="svelte-16dc737"&&(pe.innerHTML=Et),dt=n(e),p(ce.$$.fragment,e),ht=n(e),de=o(e,"TABLE",{"data-svelte-h":!0}),f(de)!=="svelte-93fio9"&&(de.innerHTML=At),mt=n(e),p(he.$$.fragment,e),ft=n(e),me=o(e,"TABLE",{"data-svelte-h":!0}),f(me)!=="svelte-vw70ih"&&(me.innerHTML=Lt),gt=n(e),p(fe.$$.fragment,e),ut=n(e),ge=o(e,"TABLE",{"data-svelte-h":!0}),f(ge)!=="svelte-1rd81se"&&(ge.innerHTML=zt),wt=n(e),p(ue.$$.fragment,e),Mt=n(e),we=o(e,"TABLE",{"data-svelte-h":!0}),f(we)!=="svelte-sb1q1h"&&(we.innerHTML=Vt),yt=n(e),p(Me.$$.fragment,e),Jt=n(e),ye=o(e,"TABLE",{"data-svelte-h":!0}),f(ye)!=="svelte-93ujrz"&&(ye.innerHTML=Pt),jt=n(e),p(Je.$$.fragment,e),Tt=n(e),Te=o(e,"P",{}),Ot(Te).forEach(s),this.h()},h(){Kt(g,"name","hf:doc:metadata"),Kt(g,"content",hs)},m(e,t){os(document.head,g),a(e,y,t),a(e,u,t),a(e,J,t),c(b,e,t),a(e,be,t),a(e,U,t),a(e,Ue,t),c(j,e,t),a(e,xe,t),c(x,e,t),a(e,ke,t),a(e,k,t),a(e,Ie,t),c(I,e,t),a(e,$e,t),a(e,$,t),a(e,ve,t),c(T,e,t),a(e,Ge,t),a(e,v,t),a(e,Be,t),c(G,e,t),a(e,Ce,t),a(e,B,t),a(e,Ne,t),c(C,e,t),a(e,Ze,t),a(e,N,t),a(e,_e,t),c(Z,e,t),a(e,We,t),a(e,_,t),a(e,Xe,t),a(e,W,t),a(e,Qe,t),c(X,e,t),a(e,He,t),c(Q,e,t),a(e,Fe,t),c(H,e,t),a(e,Re,t),a(e,F,t),a(e,Se,t),c(R,e,t),a(e,Ye,t),a(e,S,t),a(e,Ee,t),c(Y,e,t),a(e,Ae,t),a(e,E,t),a(e,Le,t),c(A,e,t),a(e,ze,t),a(e,L,t),a(e,Ve,t),c(z,e,t),a(e,Pe,t),a(e,V,t),a(e,qe,t),a(e,P,t),a(e,De,t),c(q,e,t),a(e,Oe,t),a(e,D,t),a(e,Ke,t),c(O,e,t),a(e,et,t),c(K,e,t),a(e,tt,t),a(e,ee,t),a(e,st,t),c(te,e,t),a(e,at,t),a(e,se,t),a(e,lt,t),a(e,ae,t),a(e,nt,t),a(e,le,t),a(e,it,t),a(e,ne,t),a(e,ot,t),c(ie,e,t),a(e,rt,t),c(oe,e,t),a(e,pt,t),c(re,e,t),a(e,ct,t),a(e,pe,t),a(e,dt,t),c(ce,e,t),a(e,ht,t),a(e,de,t),a(e,mt,t),c(he,e,t),a(e,ft,t),a(e,me,t),a(e,gt,t),c(fe,e,t),a(e,ut,t),a(e,ge,t),a(e,wt,t),c(ue,e,t),a(e,Mt,t),a(e,we,t),a(e,yt,t),c(Me,e,t),a(e,Jt,t),a(e,ye,t),a(e,jt,t),c(Je,e,t),a(e,Tt,t),a(e,Te,t),bt=!0},p(e,[t]){const qt={};t&2&&(qt.$$scope={dirty:t,ctx:e}),j.$set(qt);const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),T.$set(Dt)},i(e){bt||(d(b.$$.fragment,e),d(j.$$.fragment,e),d(x.$$.fragment,e),d(I.$$.fragment,e),d(T.$$.fragment,e),d(G.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(X.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(A.$$.fragment,e),d(z.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(te.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(he.$$.fragment,e),d(fe.$$.fragment,e),d(ue.$$.fragment,e),d(Me.$$.fragment,e),d(Je.$$.fragment,e),bt=!0)},o(e){h(b.$$.fragment,e),h(j.$$.fragment,e),h(x.$$.fragment,e),h(I.$$.fragment,e),h(T.$$.fragment,e),h(G.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(X.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(R.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(Je.$$.fragment,e),bt=!1},d(e){e&&(s(y),s(u),s(J),s(be),s(U),s(Ue),s(xe),s(ke),s(k),s(Ie),s($e),s($),s(ve),s(Ge),s(v),s(Be),s(Ce),s(B),s(Ne),s(Ze),s(N),s(_e),s(We),s(_),s(Xe),s(W),s(Qe),s(He),s(Fe),s(Re),s(F),s(Se),s(Ye),s(S),s(Ee),s(Ae),s(E),s(Le),s(ze),s(L),s(Ve),s(Pe),s(V),s(qe),s(P),s(De),s(Oe),s(D),s(Ke),s(et),s(tt),s(ee),s(st),s(at),s(se),s(lt),s(ae),s(nt),s(le),s(it),s(ne),s(ot),s(rt),s(pt),s(ct),s(pe),s(dt),s(ht),s(de),s(mt),s(ft),s(me),s(gt),s(ut),s(ge),s(wt),s(Mt),s(we),s(yt),s(Jt),s(ye),s(jt),s(Tt),s(Te)),s(g),m(b,e),m(j,e),m(x,e),m(I,e),m(T,e),m(G,e),m(C,e),m(Z,e),m(X,e),m(Q,e),m(H,e),m(R,e),m(Y,e),m(A,e),m(z,e),m(q,e),m(O,e),m(K,e),m(te,e),m(ie,e),m(oe,e),m(re,e),m(ce,e),m(he,e),m(fe,e),m(ue,e),m(Me,e),m(Je,e)}}}const hs='{"title":"The pipeline API","local":"the-pipeline-api","sections":[{"title":"The basics","local":"the-basics","sections":[],"depth":2},{"title":"Pipeline options","local":"pipeline-options","sections":[{"title":"Loading","local":"loading","sections":[],"depth":3},{"title":"Running","local":"running","sections":[],"depth":3},{"title":"Streaming","local":"streaming","sections":[],"depth":3}],"depth":2},{"title":"Available tasks","local":"available-tasks","sections":[{"title":"Tasks","local":"tasks","sections":[{"title":"Natural Language Processing","local":"natural-language-processing","sections":[],"depth":4},{"title":"Vision","local":"vision","sections":[],"depth":4},{"title":"Audio","local":"audio","sections":[],"depth":4},{"title":"Tabular","local":"tabular","sections":[],"depth":4},{"title":"Multimodal","local":"multimodal","sections":[],"depth":4},{"title":"Reinforcement Learning","local":"reinforcement-learning","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function ms(je){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ls{constructor(g){super(),ns(this,g,ms,ds,ss,{})}}export{ys as component};
