import{s as Nt,a as qt,n as Xt,o as Rt}from"../chunks/scheduler.9cda857a.js";import{S as Dt,i as Kt,e as n,s as a,c,h as Ot,a as o,d as l,b as i,f as Ft,g as h,j as r,k as u,l as el,m as s,n as m,t as p,o as f,p as g}from"../chunks/index.f47f3121.js";import{C as tl}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as At}from"../chunks/CodeBlock.24d62f98.js";import{H as ce,E as ll}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function sl(ot){let d,he,ue,me,H,pe,k,fe,J,rt='To upload models to the Hub, you’ll need to create an account at <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a>. Models on the Hub are <a href="./repositories">Git-based repositories</a>, which give you versioning, branches, discoverability and sharing features, integration with dozens of libraries, and more! You have control over what you want to upload to your repository, which could include checkpoints, configs, and any other files.',ge,x,ut='You can link repositories with an individual user, such as <a href="https://huggingface.co/osanseviero/fashion_brands_patterns" rel="nofollow">osanseviero/fashion_brands_patterns</a>, or with an organization, such as <a href="https://huggingface.co/facebook/bart-large-xsum" rel="nofollow">facebook/bart-large-xsum</a>. Organizations can collect models related to a company, community, or library! If you choose an organization, the model will be featured on the organization’s page, and every member of the organization will have the ability to contribute to the repository. You can create a new organization <a href="https://huggingface.co/organizations/new" rel="nofollow">here</a>.',ye,L,dt="<p><strong><em>NOTE:</em></strong> Models do NOT need to be compatible with the Transformers/Diffusers libraries to get download metrics. Any custom model is supported. Read more below!</p>",Me,I,ct='There are several ways to upload models for them to be nicely integrated into the Hub and get <a href="models-download-stats">download metrics</a>, described below.',be,W,ht='<li>In case your model is designed for a library that has <a href="#upload-from-a-library-with-built-in-support">built-in support</a>, you can use the methods provided by the library. Custom models that use <code>trust_remote_code=True</code> can also leverage these methods.</li> <li>In case your model is a custom PyTorch model, one can leverage the <a href="#upload-a-pytorch-model-using-huggingfacehub"><code>PyTorchModelHubMixin</code> class</a> as it allows to add <code>from_pretrained</code>, <code>push_to_hub</code> to any <code>nn.Module</code> class, just like models in the Transformers, Diffusers and Timm libraries.</li> <li>In addition to programmatic uploads, you can always use the <a href="#using-the-web-interface">web interface</a> or <a href="#using-git">the git command line</a>.</li>',we,$,mt='Once your model is uploaded, we suggest adding a <a href="./model-cards">Model Card</a> to your repo to document your model and make it more discoverable.',Te,y,pt,ve,B,ft="Example [repository](https://huggingface.co/LiheYoung/depth_anything_vitl14) that leverages [PyTorchModelHubMixin](#upload-a-pytorch-model-using-huggingfacehub). Downloads are shown on the right.",_e,Z,Ue,G,gt='To create a brand new model repository, visit <a href="http://huggingface.co/new" rel="nofollow">huggingface.co/new</a>. Then follow these steps:',Ce,z,yt="<li>In the “Files and versions” tab, select “Add File” and specify “Upload File”:</li>",je,M,Mt='<img class="block dark:hidden" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file.png"/> <img class="hidden dark:block" width="300" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/add-file-dark.png"/>',He,b,bt="<li>From there, select a file from your computer to upload and leave a helpful commit message to know what you are uploading:</li>",ke,w,wt='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/commit-file-dark.png"/>',Je,T,Tt="<li><p>Afterwards, click <strong>Commit changes</strong> to upload your model to the Hub!</p></li> <li><p>Inspect files and history</p></li>",xe,V,vt="You can check your repository with all the recently added files!",Le,v,_t='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/repo_with_files-dark.png"/>',Ie,S,Ut="The UI allows you to explore the model files and commits and to see the diff introduced by each commit:",We,_,Ct='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/explore_history-dark.gif"/>',$e,U,jt="<li>Add metadata</li>",Be,E,Ht="You can add metadata to your model card. You can specify:",Ze,P,kt="<li>the type of task this model is for, enabling widgets and the Inference API.</li> <li>the used library (<code>transformers</code>, <code>spaCy</code>, etc.)</li> <li>the language</li> <li>the dataset</li> <li>metrics</li> <li>license</li> <li>a lot more!</li>",Ge,Y,Jt='Read more about model tags <a href="./model-cards#model-card-metadata">here</a>.',ze,C,xt="<li>Add TensorBoard traces</li>",Ve,Q,Lt='Any repository that contains TensorBoard traces (filenames that contain <code>tfevents</code>) is categorized with the <a href="https://huggingface.co/models?filter=tensorboard" rel="nofollow"><code>TensorBoard</code> tag</a>. As a convention, we suggest that you save traces under the <code>runs/</code> subfolder. The “Training metrics” tab then makes it easy to review charts of the logged variables, like the loss or the accuracy.',Se,j,It='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/tensorboard-dark.png"/>',Ee,F,Wt='Models trained with 🤗 Transformers will generate <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow">TensorBoard traces</a> by default if <a href="https://pypi.org/project/tensorboard/" rel="nofollow"><code>tensorboard</code></a> is installed.',Pe,A,Ye,N,$t='First check if your model is from a library that has built-in support to push to/load from the Hub, like Transformers, Diffusers, Timm, Asteroid, etc.: <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">https://huggingface.co/docs/hub/models-libraries</a>. Below we’ll show how easy this is for a library like Transformers:',Qe,q,Fe,X,Bt='Some libraries, like Transformers, support loading <a href="https://huggingface.co/docs/transformers/custom_models" rel="nofollow">code from the Hub</a>. This is a way to make your model work with Transformers using the <code>trust_remote_code=True</code> flag. You may want to consider this option instead of a full-fledged library integration.',Ae,R,Ne,D,Zt='In case your model is a (custom) PyTorch model, you can leverage the <code>PyTorchModelHubMixin</code> <a href="https://huggingface.co/docs/huggingface_hub/package_reference/mixins#huggingface_hub.PyTorchModelHubMixin" rel="nofollow">class</a> available in the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> Python library. It is a minimal class which adds <code>from_pretrained</code> and <code>push_to_hub</code> capabilities to any <code>nn.Module</code>, along with download metrics.',qe,K,Gt="Here is how to use it (assuming you have run <code>pip install huggingface_hub</code>):",Xe,O,Re,ee,zt="As you can see, the only requirement is that your model inherits from <code>PyTorchModelHubMixin</code>. All instance attributes will be automatically serialized to a <code>config.json</code> file. Note that the <code>init</code> method can only take arguments which are JSON serializable. Python dataclasses are supported.",De,te,Vt="This comes with automated download metrics, meaning that you’ll be able to see how many times the model is downloaded, the same way they are available for models integrated natively in the Transformers, Diffusers or Timm libraries. With this mixin class, each separate checkpoint is stored on the Hub in a single repository consisting of 2 files:",Ke,le,St='<li>a <code>pytorch_model.bin</code> or <code>model.safetensors</code> file containing the weights</li> <li>a <code>config.json</code> file which is a serialized version of the model configuration. This class is used for counting download metrics: everytime a user calls <code>from_pretrained</code> to load a <code>config.json</code>, the count goes up by one. See <a href="https://huggingface.co/docs/hub/models-download-stats" rel="nofollow">this guide</a> regarding automated download metrics.</li>',Oe,se,Et="It’s recommended to add a model card to each checkpoint so that people can read what the model is about, have a link to the paper, etc.",et,ae,Pt='Visit <a href="https://huggingface.co/docs/huggingface_hub/guides/integrations" rel="nofollow">the huggingface_hub’s documentation</a> to learn more.',tt,ie,Yt='Alternatively, one can also simply programmatically upload files or folders to the hub: <a href="https://huggingface.co/docs/huggingface_hub/guides/upload" rel="nofollow">https://huggingface.co/docs/huggingface_hub/guides/upload</a>.',lt,ne,st,oe,Qt='Finally, since model repos are just Git repositories, you can also use Git to push your model files to the Hub. Follow the guide on <a href="repositories-getting-started#terminal">Getting Started with Repositories</a> to learn about using the <code>git</code> CLI to commit and push your models.',at,re,it,de,nt;return H=new tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),k=new ce({props:{title:"Uploading models",local:"uploading-models",headingTag:"h1"}}),Z=new ce({props:{title:"Using the web interface",local:"using-the-web-interface",headingTag:"h2"}}),A=new ce({props:{title:"Upload from a library with built-in support",local:"upload-from-a-library-with-built-in-support",headingTag:"h2"}}),q=new At({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRDb25maWclMkMlMjBCZXJ0TW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBCZXJ0Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEJlcnRNb2RlbChjb25maWcpJTBBJTBBbW9kZWwucHVzaF90b19odWIoJTIybmllbHNyJTJGbXktYXdlc29tZS1iZXJ0LW1vZGVsJTIyKSUwQSUwQSUyMyUyMHJlbG9hZCUwQW1vZGVsJTIwJTNEJTIwQmVydE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuaWVsc3IlMkZteS1hd2Vzb21lLWJlcnQtbW9kZWwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertConfig, BertModel

config = BertConfig()
model = BertModel(config)

model.push_to_hub(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;nielsr/my-awesome-bert-model&quot;</span>)`,wrap:!1}}),R=new ce({props:{title:"Upload a PyTorch model using huggingface_hub",local:"upload-a-pytorch-model-using-huggingfacehub",headingTag:"h2"}}),O=new At({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEElMEFjbGFzcyUyME15TW9kZWwoJTBBJTIwJTIwJTIwJTIwbm4uTW9kdWxlJTJDJTBBJTIwJTIwJTIwJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMkMlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBvcHRpb25hbGx5JTJDJTIweW91JTIwY2FuJTIwYWRkJTIwbWV0YWRhdGElMjB3aGljaCUyMGdldHMlMjBwdXNoZWQlMjB0byUyMHRoZSUyMG1vZGVsJTIwY2FyZCUwQSUyMCUyMCUyMCUyMHJlcG9fdXJsJTNEJTIyeW91ci1yZXBvLXVybCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lX3RhZyUzRCUyMnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBsaWNlbnNlJTNEJTIybWl0JTIyJTJDJTBBKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBudW1fY2hhbm5lbHMlM0ElMjBpbnQlMkMlMjBoaWRkZW5fc2l6ZSUzQSUyMGludCUyQyUyMG51bV9jbGFzc2VzJTNBJTIwaW50KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZChudW1fY2hhbm5lbHMlMkMlMjBoaWRkZW5fc2l6ZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX3NpemUlMkMlMjBudW1fY2xhc3NlcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjB4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubGluZWFyKHglMjAlMkIlMjBzZWxmLnBhcmFtKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMG1vZGVsJTBBY29uZmlnJTIwJTNEJTIwJTdCJTIybnVtX2NoYW5uZWxzJTIyJTNBJTIwMyUyQyUyMCUyMmhpZGRlbl9zaXplJTIyJTNBJTIwMzIlMkMlMjAlMjJudW1fY2xhc3NlcyUyMiUzQSUyMDEwJTdEJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsKCoqY29uZmlnKSUwQSUwQSUyMyUyMHNhdmUlMjBsb2NhbGx5JTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwcHVzaCUyMHRvJTIwdGhlJTIwaHViJTBBbW9kZWwucHVzaF90b19odWIoJTIyeW91ci1oZi11c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBJTIzJTIwcmVsb2FkJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ5b3VyLWhmLXVzZXJuYW1lJTJGbXktYXdlc29tZS1tb2RlbCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(
    nn.Module,
    PyTorchModelHubMixin, 
    <span class="hljs-comment"># optionally, you can add metadata which gets pushed to the model card</span>
    repo_url=<span class="hljs-string">&quot;your-repo-url&quot;</span>,
    pipeline_tag=<span class="hljs-string">&quot;text-to-image&quot;</span>,
    license=<span class="hljs-string">&quot;mit&quot;</span>,
):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_channels: <span class="hljs-built_in">int</span>, hidden_size: <span class="hljs-built_in">int</span>, num_classes: <span class="hljs-built_in">int</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.param = nn.Parameter(torch.rand(num_channels, hidden_size))
        self.linear = nn.Linear(hidden_size, num_classes)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.linear(x + self.param)

<span class="hljs-comment"># create model</span>
config = {<span class="hljs-string">&quot;num_channels&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;hidden_size&quot;</span>: <span class="hljs-number">32</span>, <span class="hljs-string">&quot;num_classes&quot;</span>: <span class="hljs-number">10</span>}
model = MyModel(**config)

<span class="hljs-comment"># save locally</span>
model.save_pretrained(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># push to the hub</span>
model.push_to_hub(<span class="hljs-string">&quot;your-hf-username/my-awesome-model&quot;</span>)

<span class="hljs-comment"># reload</span>
model = MyModel.from_pretrained(<span class="hljs-string">&quot;your-hf-username/my-awesome-model&quot;</span>)`,wrap:!1}}),ne=new ce({props:{title:"Using Git",local:"using-git",headingTag:"h2"}}),re=new ll({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/models-uploading.md"}}),{c(){d=n("meta"),he=a(),ue=n("p"),me=a(),c(H.$$.fragment),pe=a(),c(k.$$.fragment),fe=a(),J=n("p"),J.innerHTML=rt,ge=a(),x=n("p"),x.innerHTML=ut,ye=a(),L=n("blockquote"),L.innerHTML=dt,Me=a(),I=n("p"),I.innerHTML=ct,be=a(),W=n("ul"),W.innerHTML=ht,we=a(),$=n("p"),$.innerHTML=mt,Te=a(),y=n("img"),ve=a(),B=n("small"),B.textContent=ft,_e=a(),c(Z.$$.fragment),Ue=a(),G=n("p"),G.innerHTML=gt,Ce=a(),z=n("ol"),z.innerHTML=yt,je=a(),M=n("div"),M.innerHTML=Mt,He=a(),b=n("ol"),b.innerHTML=bt,ke=a(),w=n("div"),w.innerHTML=wt,Je=a(),T=n("ol"),T.innerHTML=Tt,xe=a(),V=n("p"),V.textContent=vt,Le=a(),v=n("div"),v.innerHTML=_t,Ie=a(),S=n("p"),S.textContent=Ut,We=a(),_=n("div"),_.innerHTML=Ct,$e=a(),U=n("ol"),U.innerHTML=jt,Be=a(),E=n("p"),E.textContent=Ht,Ze=a(),P=n("ul"),P.innerHTML=kt,Ge=a(),Y=n("p"),Y.innerHTML=Jt,ze=a(),C=n("ol"),C.innerHTML=xt,Ve=a(),Q=n("p"),Q.innerHTML=Lt,Se=a(),j=n("div"),j.innerHTML=It,Ee=a(),F=n("p"),F.innerHTML=Wt,Pe=a(),c(A.$$.fragment),Ye=a(),N=n("p"),N.innerHTML=$t,Qe=a(),c(q.$$.fragment),Fe=a(),X=n("p"),X.innerHTML=Bt,Ae=a(),c(R.$$.fragment),Ne=a(),D=n("p"),D.innerHTML=Zt,qe=a(),K=n("p"),K.innerHTML=Gt,Xe=a(),c(O.$$.fragment),Re=a(),ee=n("p"),ee.innerHTML=zt,De=a(),te=n("p"),te.textContent=Vt,Ke=a(),le=n("ul"),le.innerHTML=St,Oe=a(),se=n("p"),se.textContent=Et,et=a(),ae=n("p"),ae.innerHTML=Pt,tt=a(),ie=n("p"),ie.innerHTML=Yt,lt=a(),c(ne.$$.fragment),st=a(),oe=n("p"),oe.innerHTML=Qt,at=a(),c(re.$$.fragment),it=a(),de=n("p"),this.h()},l(e){const t=Ot("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),he=i(e),ue=o(e,"P",{}),Ft(ue).forEach(l),me=i(e),h(H.$$.fragment,e),pe=i(e),h(k.$$.fragment,e),fe=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1k1s32s"&&(J.innerHTML=rt),ge=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1yho9nm"&&(x.innerHTML=ut),ye=i(e),L=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(L)!=="svelte-5gr2ts"&&(L.innerHTML=dt),Me=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-u47biw"&&(I.innerHTML=ct),be=i(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-1b166lh"&&(W.innerHTML=ht),we=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-vwc1dj"&&($.innerHTML=mt),Te=i(e),y=o(e,"IMG",{src:!0,alt:!0,width:!0}),ve=i(e),B=o(e,"SMALL",{"data-svelte-h":!0}),r(B)!=="svelte-rw6688"&&(B.textContent=ft),_e=i(e),h(Z.$$.fragment,e),Ue=i(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-x37mbe"&&(G.innerHTML=gt),Ce=i(e),z=o(e,"OL",{"data-svelte-h":!0}),r(z)!=="svelte-m7dyke"&&(z.innerHTML=yt),je=i(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1kwaicp"&&(M.innerHTML=Mt),He=i(e),b=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-bnx7wi"&&(b.innerHTML=bt),ke=i(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1yhipjn"&&(w.innerHTML=wt),Je=i(e),T=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(T)!=="svelte-1g8w05a"&&(T.innerHTML=Tt),xe=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-197c7zs"&&(V.textContent=vt),Le=i(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1vobd2z"&&(v.innerHTML=_t),Ie=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-9fow57"&&(S.textContent=Ut),We=i(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-cdui6d"&&(_.innerHTML=Ct),$e=i(e),U=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-j2g6d3"&&(U.innerHTML=jt),Be=i(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-gkc8cy"&&(E.textContent=Ht),Ze=i(e),P=o(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-tl31d8"&&(P.innerHTML=kt),Ge=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-6zfhus"&&(Y.innerHTML=Jt),ze=i(e),C=o(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-1r5hl08"&&(C.innerHTML=xt),Ve=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-duz775"&&(Q.innerHTML=Lt),Se=i(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-rlnnzb"&&(j.innerHTML=It),Ee=i(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-hpisbu"&&(F.innerHTML=Wt),Pe=i(e),h(A.$$.fragment,e),Ye=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-mz82tu"&&(N.innerHTML=$t),Qe=i(e),h(q.$$.fragment,e),Fe=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mkmuk9"&&(X.innerHTML=Bt),Ae=i(e),h(R.$$.fragment,e),Ne=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1pq7dxk"&&(D.innerHTML=Zt),qe=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-uwt68k"&&(K.innerHTML=Gt),Xe=i(e),h(O.$$.fragment,e),Re=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-pgbixj"&&(ee.innerHTML=zt),De=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1f1zsla"&&(te.textContent=Vt),Ke=i(e),le=o(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-m0rjhi"&&(le.innerHTML=St),Oe=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1j0lu4s"&&(se.textContent=Et),et=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1e814df"&&(ae.innerHTML=Pt),tt=i(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1x88idh"&&(ie.innerHTML=Yt),lt=i(e),h(ne.$$.fragment,e),st=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-y1l1ro"&&(oe.innerHTML=Qt),at=i(e),h(re.$$.fragment,e),it=i(e),de=o(e,"P",{}),Ft(de).forEach(l),this.h()},h(){u(d,"name","hf:doc:metadata"),u(d,"content",al),qt(y.src,pt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/example_repository.png")||u(y,"src",pt),u(y,"alt","drawing"),u(y,"width","600"),u(M,"class","flex justify-center"),u(b,"start","2"),u(w,"class","flex justify-center"),u(T,"start","3"),u(v,"class","flex justify-center"),u(_,"class","flex justify-center"),u(U,"start","5"),u(C,"start","6"),u(j,"class","flex justify-center")},m(e,t){el(document.head,d),s(e,he,t),s(e,ue,t),s(e,me,t),m(H,e,t),s(e,pe,t),m(k,e,t),s(e,fe,t),s(e,J,t),s(e,ge,t),s(e,x,t),s(e,ye,t),s(e,L,t),s(e,Me,t),s(e,I,t),s(e,be,t),s(e,W,t),s(e,we,t),s(e,$,t),s(e,Te,t),s(e,y,t),s(e,ve,t),s(e,B,t),s(e,_e,t),m(Z,e,t),s(e,Ue,t),s(e,G,t),s(e,Ce,t),s(e,z,t),s(e,je,t),s(e,M,t),s(e,He,t),s(e,b,t),s(e,ke,t),s(e,w,t),s(e,Je,t),s(e,T,t),s(e,xe,t),s(e,V,t),s(e,Le,t),s(e,v,t),s(e,Ie,t),s(e,S,t),s(e,We,t),s(e,_,t),s(e,$e,t),s(e,U,t),s(e,Be,t),s(e,E,t),s(e,Ze,t),s(e,P,t),s(e,Ge,t),s(e,Y,t),s(e,ze,t),s(e,C,t),s(e,Ve,t),s(e,Q,t),s(e,Se,t),s(e,j,t),s(e,Ee,t),s(e,F,t),s(e,Pe,t),m(A,e,t),s(e,Ye,t),s(e,N,t),s(e,Qe,t),m(q,e,t),s(e,Fe,t),s(e,X,t),s(e,Ae,t),m(R,e,t),s(e,Ne,t),s(e,D,t),s(e,qe,t),s(e,K,t),s(e,Xe,t),m(O,e,t),s(e,Re,t),s(e,ee,t),s(e,De,t),s(e,te,t),s(e,Ke,t),s(e,le,t),s(e,Oe,t),s(e,se,t),s(e,et,t),s(e,ae,t),s(e,tt,t),s(e,ie,t),s(e,lt,t),m(ne,e,t),s(e,st,t),s(e,oe,t),s(e,at,t),m(re,e,t),s(e,it,t),s(e,de,t),nt=!0},p:Xt,i(e){nt||(p(H.$$.fragment,e),p(k.$$.fragment,e),p(Z.$$.fragment,e),p(A.$$.fragment,e),p(q.$$.fragment,e),p(R.$$.fragment,e),p(O.$$.fragment,e),p(ne.$$.fragment,e),p(re.$$.fragment,e),nt=!0)},o(e){f(H.$$.fragment,e),f(k.$$.fragment,e),f(Z.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(R.$$.fragment,e),f(O.$$.fragment,e),f(ne.$$.fragment,e),f(re.$$.fragment,e),nt=!1},d(e){e&&(l(he),l(ue),l(me),l(pe),l(fe),l(J),l(ge),l(x),l(ye),l(L),l(Me),l(I),l(be),l(W),l(we),l($),l(Te),l(y),l(ve),l(B),l(_e),l(Ue),l(G),l(Ce),l(z),l(je),l(M),l(He),l(b),l(ke),l(w),l(Je),l(T),l(xe),l(V),l(Le),l(v),l(Ie),l(S),l(We),l(_),l($e),l(U),l(Be),l(E),l(Ze),l(P),l(Ge),l(Y),l(ze),l(C),l(Ve),l(Q),l(Se),l(j),l(Ee),l(F),l(Pe),l(Ye),l(N),l(Qe),l(Fe),l(X),l(Ae),l(Ne),l(D),l(qe),l(K),l(Xe),l(Re),l(ee),l(De),l(te),l(Ke),l(le),l(Oe),l(se),l(et),l(ae),l(tt),l(ie),l(lt),l(st),l(oe),l(at),l(it),l(de)),l(d),g(H,e),g(k,e),g(Z,e),g(A,e),g(q,e),g(R,e),g(O,e),g(ne,e),g(re,e)}}}const al='{"title":"Uploading models","local":"uploading-models","sections":[{"title":"Using the web interface","local":"using-the-web-interface","sections":[],"depth":2},{"title":"Upload from a library with built-in support","local":"upload-from-a-library-with-built-in-support","sections":[],"depth":2},{"title":"Upload a PyTorch model using huggingface_hub","local":"upload-a-pytorch-model-using-huggingfacehub","sections":[],"depth":2},{"title":"Using Git","local":"using-git","sections":[],"depth":2}],"depth":1}';function il(ot){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Dt{constructor(d){super(),Kt(this,d,il,sl,Nt,{})}}export{cl as component};
