import{s as Qi,n as bi,o as Ri}from"../chunks/scheduler.9cda857a.js";import{S as xi,i as vi,e as a,s,c as M,h as Ni,a as T,d as t,b as n,f as Di,g as p,j as o,k as It,l as $i,m as i,n as U,t as y,o as J,p as w}from"../chunks/index.f47f3121.js";import{C as Fi}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as h}from"../chunks/CodeBlock.24d62f98.js";import{H as r,E as Vi}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function Bi(Ot){let c,Wl,Sl,zl,m,Pl,u,Yl,C,kt="Pickle is a widely used serialization format in ML. Most notably, it is the default format for PyTorch model weights.",Xl,d,gt='There are dangerous arbitrary code execution attacks that can be perpetrated when you load a pickle file. We suggest loading models from users and organizations you trust, relying on signed commits, and/or loading models from TF or Jax formats with the <code>from_tf=True</code> auto-conversion mechanism. We also alleviate this issue by displaying/“vetting” the list of imports in any pickled file, directly on the Hub. Finally, we are experimenting with a new, simple serialization format for weights called <a href="https://github.com/huggingface/safetensors" rel="nofollow"><code>safetensors</code></a>.',ql,I,Kl,O,At='From the <a href="https://docs.python.org/3/library/pickle.html" rel="nofollow">official docs</a> :',le,k,jt="<p>The <code>pickle</code> module implements binary protocols for serializing and de-serializing a Python object structure.</p>",ee,g,Dt="What this means is that pickle is a serializing protocol, something you use to efficiently share data amongst parties.",te,A,Qt="We call a pickle the binary file that was generated while pickling.",ie,j,bt="At its core, the pickle is basically a stack of instructions or opcodes. As you probably have guessed, it’s not human readable. The opcodes are generated when pickling and read sequentially at unpickling. Based on the opcode, a given action is executed.",se,D,Rt="Here’s a small example:",ne,Q,ae,b,xt="When you run this, it will create a pickle file and print the following instructions in your terminal:",Te,R,oe,x,vt='Don’t worry too much about the instructions for now, just know that the <a href="https://docs.python.org/3/library/pickletools.html" rel="nofollow">pickletools</a> module is very useful for analyzing pickles. It allows you to read the instructions in the file <strong><em>without</em></strong> executing any code.',Me,v,Nt="Pickle is not simply a serialization protocol, it allows more flexibility by giving the ability to users to run python code at de-serialization time. Doesn’t sound good, does it?",pe,N,Ue,$,$t="As we’ve stated above, de-serializing pickle means that code can be executed. But this comes with certain limitations: you can only reference functions and classes from the top level module; you cannot embed them in the pickle file itself.",ye,F,Ft="Back to the drawing board:",Je,V,we,B,Vt="When we run this script we get the <code>payload.pkl</code> again. When we check the file’s contents:",re,_,ce,H,Bt="We can see that there isn’t much in there, a few opcodes and the associated data. You might be thinking, so what’s the problem with pickle?",he,E,_t="Let’s try something else:",fe,L,me,G,Ht='Here we’re using the <a href="https://github.com/trailofbits/fickling" rel="nofollow">fickling</a> library for simplicity. It allows us to add pickle instructions to execute code contained in a string via the <code>exec</code> function. This is how you circumvent the fact that you cannot define functions or classes in your pickles: you run exec on python code saved as a string.',ue,S,Et="When you run this, it creates a <code>payload.pkl</code> and prints the following:",Ce,Z,de,W,Lt="If we check the contents of the pickle file, we get:",Ie,z,Oe,P,Gt="Basically, this is what’s happening when you unpickle:",ke,Y,ge,X,St="The instructions that pose a threat are <code>STACK_GLOBAL</code>, <code>GLOBAL</code> and <code>REDUCE</code>.",Ae,q,Zt="<code>REDUCE</code> is what tells the unpickler to execute the function with the provided arguments and <code>*GLOBAL</code> instructions are telling the unpickler to <code>import</code> stuff.",je,K,Wt="To sum up, pickle is dangerous because:",De,ll,zt="<li>when importing a python module, arbitrary code can be executed</li> <li>you can import builtin functions like <code>eval</code> or <code>exec</code>, which can be used to execute arbitrary code</li> <li>when instantiating an object, the constructor may be called</li>",Qe,el,Pt="This is why it is stated in most docs using pickle, do not unpickle data from untrusted sources.",be,tl,Re,il,Yt="<strong><em>Don’t use pickle</em></strong>",xe,sl,Xt="Sound advice Luc, but pickle is used profusely and isn’t going anywhere soon: finding a new format everyone is happy with and initiating the change will take some time.",ve,nl,qt="So what can we do for now?",Ne,al,$e,Tl,Kt='On the Hub, you have the ability to <a href="./security-gpg">sign your commits with a GPG key</a>. This does <strong>not</strong> guarantee that your file is safe, but it does guarantee the origin of the file.',Fe,ol,li="If you know and trust user A and the commit that includes the file on the Hub is signed by user A’s GPG key, it’s pretty safe to assume that you can trust the file.",Ve,Ml,Be,pl,ei="TensorFlow and Flax checkpoints are not affected, and can be loaded within PyTorch architectures using the <code>from_tf</code> and <code>from_flax</code> kwargs for the <code>from_pretrained</code> method to circumvent this issue.",_e,Ul,ti="E.g.:",He,yl,Ee,Jl,Le,wl,ii='<li><a href="https://msgpack.org/index.html" rel="nofollow">MsgPack</a></li> <li><a href="https://developers.google.com/protocol-buffers" rel="nofollow">Protobuf</a></li> <li><a href="https://capnproto.org/" rel="nofollow">Cap’n’proto</a></li> <li><a href="https://avro.apache.org/" rel="nofollow">Avro</a></li> <li><a href="https://github.com/huggingface/safetensors" rel="nofollow">safetensors</a></li>',Ge,rl,si="This last format, <code>safetensors</code>, is a simple serialization format that we are working on and experimenting with currently! Please help or contribute if you can 🔥.",Se,cl,Ze,hl,ni='There’s an open discussion in progress at PyTorch on having a <a href="https://github.com/pytorch/pytorch/issues/52181" rel="nofollow">Safe way of loading only weights from *.pt file by default</a> – please chime in there!',We,fl,ze,ml,Pe,ul,ai="We have created a security scanner that scans every file pushed to the Hub and runs security checks. At the time of writing, it runs two types of scans:",Ye,Cl,Ti="<li>ClamAV scans</li> <li>Pickle Import scans</li>",Xe,dl,oi='For ClamAV scans, files are run through the open-source antivirus <a href="https://www.clamav.net" rel="nofollow">ClamAV</a>. While this covers a good amount of dangerous files, it doesn’t cover pickle exploits.',qe,Il,Mi="We have implemented a Pickle Import scan, which extracts the list of imports referenced in a pickle file. Every time you upload a <code>pytorch_model.bin</code> or any other pickled file, this scan is run.",Ke,Ol,pi="On the hub the list of imports will be displayed next to each file containing imports. If any import looks suspicious, it will be highlighted.",lt,f,Ui='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/security-pickle-imports-dark.png"/>',et,kl,yi='We get this data thanks to <a href="https://docs.python.org/3/library/pickletools.html#pickletools.genops" rel="nofollow"><code>pickletools.genops</code></a> which allows us to read the file without executing potentially dangerous code.',tt,gl,Ji="Note that this is what allows to know if, when unpickling a file, it will <code>REDUCE</code> on a potentially dangerous function that was imported by <code>*GLOBAL</code>.",it,Al,wi=`<strong><em>Disclaimer</em></strong>: this is not 100% foolproof. It is your responsibility as a user to check if something is safe or not. We are not actively auditing python packages for safety, the safe/unsafe imports lists we have are maintained in a best-effort manner.
Please contact us if you think something is not safe, and we flag it as such, by sending us an email to website at huggingface.co`,st,jl,nt,Dl,ri='One could think of creating a custom <a href="https://docs.python.org/3/library/pickle.html#pickle.Unpickler" rel="nofollow">Unpickler</a> in the likes of <a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">this one</a>. But as we can see in this <a href="https://ctftime.org/writeup/16723" rel="nofollow">sophisticated exploit</a>, this won’t work.',at,Ql,ci="Thankfully, there is always a trace of the <code>eval</code> import, so reading the opcodes directly should allow to catch malicious usage.",Tt,bl,hi="The current solution I propose is creating a file resembling a <code>.gitignore</code> but for imports.",ot,Rl,fi="This file would be a whitelist of imports that would make a <code>pytorch_model.bin</code> file flagged as dangerous if there are imports not included in the whitelist.",Mt,xl,mi="One could imagine having a regex-ish format where you could allow all numpy submodules for instance via a simple line like: <code>numpy.*</code>.",pt,vl,Ut,Nl,ui='<a href="https://docs.python.org/3/library/pickle.html#what-can-be-pickled-and-unpickled" rel="nofollow">pickle - Python object serialization - Python 3.10.6 documentation</a>',yt,$l,Ci='<a href="https://intoli.com/blog/dangerous-pickles/" rel="nofollow">Dangerous Pickles - Malicious Python Serialization</a>',Jt,Fl,di='<a href="https://github.com/trailofbits/fickling" rel="nofollow">GitHub - trailofbits/fickling: A Python pickling decompiler and static analyzer</a>',wt,Vl,Ii='<a href="https://davidhamann.de/2020/04/05/exploiting-python-pickle/" rel="nofollow">Exploiting Python pickles</a>',rt,Bl,Oi='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickletools.py" rel="nofollow">cpython/pickletools.py at 3.10 · python/cpython</a>',ct,_l,ki='<a href="https://github.com/python/cpython/blob/3.10/Lib/pickle.py" rel="nofollow">cpython/pickle.py at 3.10 · python/cpython</a>',ht,Hl,gi='<a href="https://github.com/facebookresearch/CrypTen/blob/main/crypten/common/serial.py" rel="nofollow">CrypTen/serial.py at main · facebookresearch/CrypTen</a>',ft,El,Ai='<a href="https://ctftime.org/writeup/16723" rel="nofollow">CTFtime.org / Balsn CTF 2019 / pyshv1 / Writeup</a>',mt,Ll,ji='<a href="https://github.com/moreati/pickle-fuzz" rel="nofollow">Rehabilitating Python’s pickle module</a>',ut,Gl,Ct,Zl,dt;return m=new Fi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new r({props:{title:"Pickle Scanning",local:"pickle-scanning",headingTag:"h1"}}),I=new r({props:{title:"What is a pickle?",local:"what-is-a-pickle",headingTag:"h2"}}),Q=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEF2YXIlMjAlM0QlMjAlMjJkYXRhJTIwSSUyMHdhbnQlMjB0byUyMHNoYXJlJTIwd2l0aCUyMGElMjBmcmllbmQlMjIlMEElMEElMjMlMjBzdG9yZSUyMHRoZSUyMHBpY2tsZSUyMGRhdGElMjBpbiUyMGElMjBmaWxlJTIwbmFtZWQlMjAncGF5bG9hZC5wa2wnJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAodmFyJTJDJTIwZiklMEElMEElMjMlMjBkaXNhc3NlbWJsZSUyMHRoZSUyMHBpY2tsZSUwQSUyMyUyMGFuZCUyMHByaW50JTIwdGhlJTIwaW5zdHJ1Y3Rpb25zJTIwdG8lMjB0aGUlMjBjb21tYW5kJTIwbGluZSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAncmInKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHBpY2tsZXRvb2xzLmRpcyhmKQ==",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

var = <span class="hljs-string">&quot;data I want to share with a friend&quot;</span>

<span class="hljs-comment"># store the pickle data in a file named &#x27;payload.pkl&#x27;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(var, f)

<span class="hljs-comment"># disassemble the pickle</span>
<span class="hljs-comment"># and print the instructions to the command line</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickletools.dis(f)`,wrap:!1}}),R=new h({props:{code:"JTIwJTIwJTIwJTIwMCUzQSUyMCU1Q3g4MCUyMFBST1RPJTIwJTIwJTIwJTIwJTIwJTIwNCUwQSUyMCUyMCUyMCUyMDIlM0ElMjAlNUN4OTUlMjBGUkFNRSUyMCUyMCUyMCUyMCUyMCUyMDQ4JTBBJTIwJTIwJTIwMTElM0ElMjAlNUN4OGMlMjBTSE9SVF9CSU5VTklDT0RFJTIwJ2RhdGElMjBJJTIwd2FudCUyMHRvJTIwc2hhcmUlMjB3aXRoJTIwYSUyMGZyaWVuZCclMEElMjAlMjAlMjA1NyUzQSUyMCU1Q3g5NCUyME1FTU9JWkUlMjAlMjAlMjAlMjAoYXMlMjAwKSUwQSUyMCUyMCUyMDU4JTNBJTIwLiUyMCUyMCUyMCUyMFNUT1AlMEFoaWdoZXN0JTIwcHJvdG9jb2wlMjBhbW9uZyUyMG9wY29kZXMlMjAlM0QlMjA0",highlighted:`    <span class="hljs-number">0</span>: \\x80 PROTO      <span class="hljs-number">4</span>
    <span class="hljs-number">2</span>: \\x95 FRAME      <span class="hljs-number">48</span>
   <span class="hljs-number">11</span>: \\x8c SHORT_BINUNICODE <span class="hljs-string">&#x27;data I want to share with a friend&#x27;</span>
   <span class="hljs-number">57</span>: \\x94 MEMOIZE    (<span class="hljs-keyword">as</span> <span class="hljs-number">0</span>)
   <span class="hljs-number">58</span>: .    STOP
highest protocol among opcodes = <span class="hljs-number">4</span>`,wrap:!1}}),N=new r({props:{title:"Why is it dangerous?",local:"why-is-it-dangerous",headingTag:"h2"}}),V=new h({props:{code:"aW1wb3J0JTIwcGlja2xlJTBBaW1wb3J0JTIwcGlja2xldG9vbHMlMEElMEFjbGFzcyUyMERhdGElM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwaW1wb3J0YW50X3N0dWZmJTNBJTIwc3RyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW1wb3J0YW50X3N0dWZmJTIwJTNEJTIwaW1wb3J0YW50X3N0dWZmJTBBJTBBZCUyMCUzRCUyMERhdGEoJTIyNDIlMjIpJTBBJTBBd2l0aCUyMG9wZW4oJ3BheWxvYWQucGtsJyUyQyUyMCd3YicpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwcGlja2xlLmR1bXAoZCUyQyUyMGYp",highlighted:`<span class="hljs-keyword">import</span> pickle
<span class="hljs-keyword">import</span> pickletools

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Data</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, important_stuff: <span class="hljs-built_in">str</span></span>):
        self.important_stuff = important_stuff

d = Data(<span class="hljs-string">&quot;42&quot;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    pickle.dump(d, f)`,wrap:!1}}),_=new h({props:{code:"JTBBJTIzJTIwY2F0JTIwcGF5bG9hZC5wa2wlMEFfX21haW5fX0RhdGEpJTdEaW1wb3J0YW50X3N0dWZmNDJzYi4lMjUlMEElMEElMjMlMjBoZXh5bCUyMHBheWxvYWQucGtsJTBBJUUyJTk0JThDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTgwJUUyJTk0JTkwJTBBJUUyJTk0JTgyMDAwMDAwMDAlRTIlOTQlODIlMjA4MCUyMDA0JTIwOTUlMjAzMyUyMDAwJTIwMDAlMjAwMCUyMDAwJTIwJUUyJTk0JThBJTIwMDAlMjAwMCUyMDAwJTIwOGMlMjAwOCUyMDVmJTIwNWYlMjA2ZCUyMCVFMiU5NCU4MiVDMyU5NyVFMiU4MCVBMiVDMyU5NzMwMDAwJUUyJTk0JThBMDAwJUMzJTk3JUUyJTgwJUEyX19tJUUyJTk0JTgyJTBBJUUyJTk0JTgyMDAwMDAwMTAlRTIlOTQlODIlMjA2MSUyMDY5JTIwNmUlMjA1ZiUyMDVmJTIwOTQlMjA4YyUyMDA0JTIwJUUyJTk0JThBJTIwNDQlMjA2MSUyMDc0JTIwNjElMjA5NCUyMDkzJTIwOTQlMjAyOSUyMCVFMiU5NCU4MmFpbl9fJUMzJTk3JUMzJTk3JUUyJTgwJUEyJUUyJTk0JThBRGF0YSVDMyU5NyVDMyU5NyVDMyU5NyklRTIlOTQlODIlMEElRTIlOTQlODIwMDAwMDAyMCVFMiU5NCU4MiUyMDgxJTIwOTQlMjA3ZCUyMDk0JTIwOGMlMjAwZiUyMDY5JTIwNmQlMjAlRTIlOTQlOEElMjA3MCUyMDZmJTIwNzIlMjA3NCUyMDYxJTIwNmUlMjA3NCUyMDVmJTIwJUUyJTk0JTgyJUMzJTk3JUMzJTk3JTdEJUMzJTk3JUMzJTk3JUUyJTgwJUEyaW0lRTIlOTQlOEFwb3J0YW50XyVFMiU5NCU4MiUwQSVFMiU5NCU4MjAwMDAwMDMwJUUyJTk0JTgyJTIwNzMlMjA3NCUyMDc1JTIwNjYlMjA2NiUyMDk0JTIwOGMlMjAwMiUyMCVFMiU5NCU4QSUyMDM0JTIwMzIlMjA5NCUyMDczJTIwNjIlMjAyZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU4MnN0dWZmJUMzJTk3JUMzJTk3JUUyJTgwJUEyJUUyJTk0JThBNDIlQzMlOTdzYi4lMjAlMjAlRTIlOTQlODIlMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlQjQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlQjQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlQjQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlQjQlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlOTg=",highlighted:`
<span class="hljs-comment"># cat payload.pkl</span>
__main__Data)}important_stuff42sb.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 80 04 95 33 00 00 00 00 ┊ 00 00 00 8c 08 5f 5f 6d │×•×30000┊000×•__m│
│00000010│ 61 69 6e 5f 5f 94 8c 04 ┊ 44 61 74 61 94 93 94 29 │ain__××•┊Data×××)│
│00000020│ 81 94 7d 94 8c 0f 69 6d ┊ 70 6f 72 74 61 6e 74 5f │××}××•im┊portant_│
│00000030│ 73 74 75 66 66 94 8c 02 ┊ 34 32 94 73 62 2e       │stuff××•┊42×sb.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMGZpY2tsaW5nLnBpY2tsZSUyMGltcG9ydCUyMFBpY2tsZWQlMEFpbXBvcnQlMjBwaWNrbGUlMEElMEElMjMlMjBDcmVhdGUlMjBhJTIwbWFsaWNpb3VzJTIwcGlja2xlJTBBZGF0YSUyMCUzRCUyMCUyMm15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlzJTIyJTBBJTBBcGlja2xlX2JpbiUyMCUzRCUyMHBpY2tsZS5kdW1wcyhkYXRhKSUwQSUwQXAlMjAlM0QlMjBQaWNrbGVkLmxvYWQocGlja2xlX2JpbiklMEElMEFwLmluc2VydF9weXRob25fZXhlYygncHJpbnQoJTIyeW91JTVDJ3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUyMiknKSUwQSUwQXdpdGglMjBvcGVuKCdwYXlsb2FkLnBrbCclMkMlMjAnd2InKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMHAuZHVtcChmKSUwQSUwQSUyMyUyMGlubm9jZW50bHklMjB1bnBpY2tsZSUyMGFuZCUyMGdldCUyMHlvdXIlMjBmcmllbmQncyUyMGRhdGElMEF3aXRoJTIwb3BlbigncGF5bG9hZC5wa2wnJTJDJTIwJ3JiJyklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBkYXRhJTIwJTNEJTIwcGlja2xlLmxvYWQoZiklMEElMjAlMjAlMjAlMjBwcmludChkYXRhKQ==",highlighted:`<span class="hljs-keyword">from</span> fickling.pickle <span class="hljs-keyword">import</span> Pickled
<span class="hljs-keyword">import</span> pickle

<span class="hljs-comment"># Create a malicious pickle</span>
data = <span class="hljs-string">&quot;my friend needs to know this&quot;</span>

pickle_bin = pickle.dumps(data)

p = Pickled.load(pickle_bin)

p.insert_python_exec(<span class="hljs-string">&#x27;print(&quot;you\\&#x27;ve been pwned !&quot;)&#x27;</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;wb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    p.dump(f)

<span class="hljs-comment"># innocently unpickle and get your friend&#x27;s data</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&#x27;payload.pkl&#x27;</span>, <span class="hljs-string">&#x27;rb&#x27;</span>) <span class="hljs-keyword">as</span> f:
    data = pickle.load(f)
    <span class="hljs-built_in">print</span>(data)`,wrap:!1}}),Z=new h({props:{code:"eW91J3ZlJTIwYmVlbiUyMHB3bmVkJTIwISUwQW15JTIwZnJpZW5kJTIwbmVlZHMlMjB0byUyMGtub3clMjB0aGlz",highlighted:`you<span class="hljs-comment">&#x27;ve been pwned !</span>
my <span class="hljs-keyword">friend</span> needs <span class="hljs-keyword">to</span> know this`,wrap:!1}}),z=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># cat payload.pkl</span>
c__builtin__
<span class="hljs-built_in">exec</span>
(Vprint(<span class="hljs-string">&quot;you&#x27;ve been pwned !&quot;</span>)
tR my friend needs to know this.%

<span class="hljs-comment"># hexyl payload.pkl</span>
┌────────┬─────────────────────────┬─────────────────────────┬────────┬────────┐
│00000000│ 63 5f 5f 62 75 69 6c 74 ┊ 69 6e 5f 5f 0a 65 78 65 │c__built┊in___exe│
│00000010│ 63 0a 28 56 70 72 69 6e ┊ 74 28 22 79 6f 75 27 76 │c_(Vprin┊t(<span class="hljs-string">&quot;you&#x27;v│
│00000020│ 65 20 62 65 65 6e 20 70 ┊ 77 6e 65 64 20 21 22 29 │e been p┊wned !&quot;</span>)│
│00000030│ 0a 74 52 80 04 95 20 00 ┊ 00 00 00 00 00 00 8c 1c │_tR×•× 0┊000000×•│
│00000040│ 6d 79 20 66 72 69 65 6e ┊ 64 20 6e 65 65 64 73 20 │my frien┊d needs │
│00000050│ 74 6f 20 6b 6e 6f 77 20 ┊ 74 68 69 73 94 2e       │to know ┊this×.  │
└────────┴─────────────────────────┴─────────────────────────┴────────┴────────┘`,wrap:!1}}),Y=new h({props:{code:"JTIzJTIwLi4uJTBBb3Bjb2Rlc19zdGFjayUyMCUzRCUyMCU1QmV4ZWNfZnVuYyUyQyUyMCUyMm1hbGljaW91cyUyMGFyZ3VtZW50JTIyJTJDJTIwJTIyUkVEVUNFJTIyJTVEJTBBb3Bjb2RlJTIwJTNEJTIwc3RhY2sucG9wKCklMEFpZiUyMG9wY29kZSUyMCUzRCUzRCUyMCUyMlJFRFVDRSUyMiUzQSUwQSUyMCUyMCUyMCUyMGFyZyUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBjYWxsYWJsZSUyMCUzRCUyMG9wY29kZXNfc3RhY2sucG9wKCklMEElMjAlMjAlMjAlMjBvcGNvZGVzX3N0YWNrLmFwcGVuZChjYWxsYWJsZShhcmcpKSUwQSUyMyUyMC4uLg==",highlighted:`<span class="hljs-comment"># ...</span>
opcodes_stack = [exec_func, <span class="hljs-string">&quot;malicious argument&quot;</span>, <span class="hljs-string">&quot;REDUCE&quot;</span>]
opcode = stack.pop()
<span class="hljs-keyword">if</span> opcode == <span class="hljs-string">&quot;REDUCE&quot;</span>:
    arg = opcodes_stack.pop()
    <span class="hljs-built_in">callable</span> = opcodes_stack.pop()
    opcodes_stack.append(<span class="hljs-built_in">callable</span>(arg))
<span class="hljs-comment"># ...</span>`,wrap:!1}}),tl=new r({props:{title:"Mitigation Strategies",local:"mitigation-strategies",headingTag:"h2"}}),al=new r({props:{title:"Load files from users and organizations you trust",local:"load-files-from-users-and-organizations-you-trust",headingTag:"h3"}}),Ml=new r({props:{title:"Load model weights from TF or Flax",local:"load-model-weights-from-tf-or-flax",headingTag:"h3"}}),yl=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMGZyb21fZmxheCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>, from_flax=<span class="hljs-literal">True</span>)`,wrap:!1}}),Jl=new r({props:{title:"Use your own serialization format",local:"use-your-own-serialization-format",headingTag:"h3"}}),cl=new r({props:{title:"Improve torch.load/save",local:"improve-torchloadsave",headingTag:"h3"}}),fl=new r({props:{title:"Hub’s Security Scanner",local:"hubs-security-scanner",headingTag:"h3"}}),ml=new r({props:{title:"What we have now",local:"what-we-have-now",headingTag:"h4"}}),jl=new r({props:{title:"Potential solutions",local:"potential-solutions",headingTag:"h4"}}),vl=new r({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),Gl=new Vi({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/security-pickle.md"}}),{c(){c=a("meta"),Wl=s(),Sl=a("p"),zl=s(),M(m.$$.fragment),Pl=s(),M(u.$$.fragment),Yl=s(),C=a("p"),C.textContent=kt,Xl=s(),d=a("p"),d.innerHTML=gt,ql=s(),M(I.$$.fragment),Kl=s(),O=a("p"),O.innerHTML=At,le=s(),k=a("blockquote"),k.innerHTML=jt,ee=s(),g=a("p"),g.textContent=Dt,te=s(),A=a("p"),A.textContent=Qt,ie=s(),j=a("p"),j.textContent=bt,se=s(),D=a("p"),D.textContent=Rt,ne=s(),M(Q.$$.fragment),ae=s(),b=a("p"),b.textContent=xt,Te=s(),M(R.$$.fragment),oe=s(),x=a("p"),x.innerHTML=vt,Me=s(),v=a("p"),v.textContent=Nt,pe=s(),M(N.$$.fragment),Ue=s(),$=a("p"),$.textContent=$t,ye=s(),F=a("p"),F.textContent=Ft,Je=s(),M(V.$$.fragment),we=s(),B=a("p"),B.innerHTML=Vt,re=s(),M(_.$$.fragment),ce=s(),H=a("p"),H.textContent=Bt,he=s(),E=a("p"),E.textContent=_t,fe=s(),M(L.$$.fragment),me=s(),G=a("p"),G.innerHTML=Ht,ue=s(),S=a("p"),S.innerHTML=Et,Ce=s(),M(Z.$$.fragment),de=s(),W=a("p"),W.textContent=Lt,Ie=s(),M(z.$$.fragment),Oe=s(),P=a("p"),P.textContent=Gt,ke=s(),M(Y.$$.fragment),ge=s(),X=a("p"),X.innerHTML=St,Ae=s(),q=a("p"),q.innerHTML=Zt,je=s(),K=a("p"),K.textContent=Wt,De=s(),ll=a("ul"),ll.innerHTML=zt,Qe=s(),el=a("p"),el.textContent=Pt,be=s(),M(tl.$$.fragment),Re=s(),il=a("p"),il.innerHTML=Yt,xe=s(),sl=a("p"),sl.textContent=Xt,ve=s(),nl=a("p"),nl.textContent=qt,Ne=s(),M(al.$$.fragment),$e=s(),Tl=a("p"),Tl.innerHTML=Kt,Fe=s(),ol=a("p"),ol.textContent=li,Ve=s(),M(Ml.$$.fragment),Be=s(),pl=a("p"),pl.innerHTML=ei,_e=s(),Ul=a("p"),Ul.textContent=ti,He=s(),M(yl.$$.fragment),Ee=s(),M(Jl.$$.fragment),Le=s(),wl=a("ul"),wl.innerHTML=ii,Ge=s(),rl=a("p"),rl.innerHTML=si,Se=s(),M(cl.$$.fragment),Ze=s(),hl=a("p"),hl.innerHTML=ni,We=s(),M(fl.$$.fragment),ze=s(),M(ml.$$.fragment),Pe=s(),ul=a("p"),ul.textContent=ai,Ye=s(),Cl=a("ul"),Cl.innerHTML=Ti,Xe=s(),dl=a("p"),dl.innerHTML=oi,qe=s(),Il=a("p"),Il.innerHTML=Mi,Ke=s(),Ol=a("p"),Ol.textContent=pi,lt=s(),f=a("div"),f.innerHTML=Ui,et=s(),kl=a("p"),kl.innerHTML=yi,tt=s(),gl=a("p"),gl.innerHTML=Ji,it=s(),Al=a("p"),Al.innerHTML=wi,st=s(),M(jl.$$.fragment),nt=s(),Dl=a("p"),Dl.innerHTML=ri,at=s(),Ql=a("p"),Ql.innerHTML=ci,Tt=s(),bl=a("p"),bl.innerHTML=hi,ot=s(),Rl=a("p"),Rl.innerHTML=fi,Mt=s(),xl=a("p"),xl.innerHTML=mi,pt=s(),M(vl.$$.fragment),Ut=s(),Nl=a("p"),Nl.innerHTML=ui,yt=s(),$l=a("p"),$l.innerHTML=Ci,Jt=s(),Fl=a("p"),Fl.innerHTML=di,wt=s(),Vl=a("p"),Vl.innerHTML=Ii,rt=s(),Bl=a("p"),Bl.innerHTML=Oi,ct=s(),_l=a("p"),_l.innerHTML=ki,ht=s(),Hl=a("p"),Hl.innerHTML=gi,ft=s(),El=a("p"),El.innerHTML=Ai,mt=s(),Ll=a("p"),Ll.innerHTML=ji,ut=s(),M(Gl.$$.fragment),Ct=s(),Zl=a("p"),this.h()},l(l){const e=Ni("svelte-u9bgzb",document.head);c=T(e,"META",{name:!0,content:!0}),e.forEach(t),Wl=n(l),Sl=T(l,"P",{}),Di(Sl).forEach(t),zl=n(l),p(m.$$.fragment,l),Pl=n(l),p(u.$$.fragment,l),Yl=n(l),C=T(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-fqsq33"&&(C.textContent=kt),Xl=n(l),d=T(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-a29lns"&&(d.innerHTML=gt),ql=n(l),p(I.$$.fragment,l),Kl=n(l),O=T(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-t990cu"&&(O.innerHTML=At),le=n(l),k=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),o(k)!=="svelte-mvgji8"&&(k.innerHTML=jt),ee=n(l),g=T(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-xlsbn2"&&(g.textContent=Dt),te=n(l),A=T(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-crw8fq"&&(A.textContent=Qt),ie=n(l),j=T(l,"P",{"data-svelte-h":!0}),o(j)!=="svelte-903ikp"&&(j.textContent=bt),se=n(l),D=T(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-ybkvbq"&&(D.textContent=Rt),ne=n(l),p(Q.$$.fragment,l),ae=n(l),b=T(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-dc6jzh"&&(b.textContent=xt),Te=n(l),p(R.$$.fragment,l),oe=n(l),x=T(l,"P",{"data-svelte-h":!0}),o(x)!=="svelte-2o2p4t"&&(x.innerHTML=vt),Me=n(l),v=T(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1lc08qc"&&(v.textContent=Nt),pe=n(l),p(N.$$.fragment,l),Ue=n(l),$=T(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-18mv2f5"&&($.textContent=$t),ye=n(l),F=T(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-qlmkz7"&&(F.textContent=Ft),Je=n(l),p(V.$$.fragment,l),we=n(l),B=T(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-45qs4"&&(B.innerHTML=Vt),re=n(l),p(_.$$.fragment,l),ce=n(l),H=T(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-162o2y5"&&(H.textContent=Bt),he=n(l),E=T(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1cipmup"&&(E.textContent=_t),fe=n(l),p(L.$$.fragment,l),me=n(l),G=T(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-tiwo6o"&&(G.innerHTML=Ht),ue=n(l),S=T(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-exjbyy"&&(S.innerHTML=Et),Ce=n(l),p(Z.$$.fragment,l),de=n(l),W=T(l,"P",{"data-svelte-h":!0}),o(W)!=="svelte-f6hcto"&&(W.textContent=Lt),Ie=n(l),p(z.$$.fragment,l),Oe=n(l),P=T(l,"P",{"data-svelte-h":!0}),o(P)!=="svelte-17mv8nc"&&(P.textContent=Gt),ke=n(l),p(Y.$$.fragment,l),ge=n(l),X=T(l,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1ywjbrq"&&(X.innerHTML=St),Ae=n(l),q=T(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-2a921e"&&(q.innerHTML=Zt),je=n(l),K=T(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1anxjjv"&&(K.textContent=Wt),De=n(l),ll=T(l,"UL",{"data-svelte-h":!0}),o(ll)!=="svelte-tgdm9a"&&(ll.innerHTML=zt),Qe=n(l),el=T(l,"P",{"data-svelte-h":!0}),o(el)!=="svelte-nlb4po"&&(el.textContent=Pt),be=n(l),p(tl.$$.fragment,l),Re=n(l),il=T(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1gahowb"&&(il.innerHTML=Yt),xe=n(l),sl=T(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1i4ndwq"&&(sl.textContent=Xt),ve=n(l),nl=T(l,"P",{"data-svelte-h":!0}),o(nl)!=="svelte-1akd8xr"&&(nl.textContent=qt),Ne=n(l),p(al.$$.fragment,l),$e=n(l),Tl=T(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-18verv9"&&(Tl.innerHTML=Kt),Fe=n(l),ol=T(l,"P",{"data-svelte-h":!0}),o(ol)!=="svelte-xz3ko3"&&(ol.textContent=li),Ve=n(l),p(Ml.$$.fragment,l),Be=n(l),pl=T(l,"P",{"data-svelte-h":!0}),o(pl)!=="svelte-gbqaor"&&(pl.innerHTML=ei),_e=n(l),Ul=T(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-oz78gk"&&(Ul.textContent=ti),He=n(l),p(yl.$$.fragment,l),Ee=n(l),p(Jl.$$.fragment,l),Le=n(l),wl=T(l,"UL",{"data-svelte-h":!0}),o(wl)!=="svelte-iyr210"&&(wl.innerHTML=ii),Ge=n(l),rl=T(l,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-ztaxgy"&&(rl.innerHTML=si),Se=n(l),p(cl.$$.fragment,l),Ze=n(l),hl=T(l,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-15ucwe"&&(hl.innerHTML=ni),We=n(l),p(fl.$$.fragment,l),ze=n(l),p(ml.$$.fragment,l),Pe=n(l),ul=T(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-65c4de"&&(ul.textContent=ai),Ye=n(l),Cl=T(l,"UL",{"data-svelte-h":!0}),o(Cl)!=="svelte-1zxf3f"&&(Cl.innerHTML=Ti),Xe=n(l),dl=T(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-g06wit"&&(dl.innerHTML=oi),qe=n(l),Il=T(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-1hmoht6"&&(Il.innerHTML=Mi),Ke=n(l),Ol=T(l,"P",{"data-svelte-h":!0}),o(Ol)!=="svelte-3ixeiy"&&(Ol.textContent=pi),lt=n(l),f=T(l,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1skhc0f"&&(f.innerHTML=Ui),et=n(l),kl=T(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-wdhs2f"&&(kl.innerHTML=yi),tt=n(l),gl=T(l,"P",{"data-svelte-h":!0}),o(gl)!=="svelte-1bjlcuv"&&(gl.innerHTML=Ji),it=n(l),Al=T(l,"P",{"data-svelte-h":!0}),o(Al)!=="svelte-t5sie"&&(Al.innerHTML=wi),st=n(l),p(jl.$$.fragment,l),nt=n(l),Dl=T(l,"P",{"data-svelte-h":!0}),o(Dl)!=="svelte-17489ml"&&(Dl.innerHTML=ri),at=n(l),Ql=T(l,"P",{"data-svelte-h":!0}),o(Ql)!=="svelte-4971ge"&&(Ql.innerHTML=ci),Tt=n(l),bl=T(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-bttwre"&&(bl.innerHTML=hi),ot=n(l),Rl=T(l,"P",{"data-svelte-h":!0}),o(Rl)!=="svelte-1her4zo"&&(Rl.innerHTML=fi),Mt=n(l),xl=T(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-19plnsx"&&(xl.innerHTML=mi),pt=n(l),p(vl.$$.fragment,l),Ut=n(l),Nl=T(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-dshrcb"&&(Nl.innerHTML=ui),yt=n(l),$l=T(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-1nbw5zj"&&($l.innerHTML=Ci),Jt=n(l),Fl=T(l,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-1pxtenc"&&(Fl.innerHTML=di),wt=n(l),Vl=T(l,"P",{"data-svelte-h":!0}),o(Vl)!=="svelte-dgsssn"&&(Vl.innerHTML=Ii),rt=n(l),Bl=T(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-9sknvp"&&(Bl.innerHTML=Oi),ct=n(l),_l=T(l,"P",{"data-svelte-h":!0}),o(_l)!=="svelte-yi9gp3"&&(_l.innerHTML=ki),ht=n(l),Hl=T(l,"P",{"data-svelte-h":!0}),o(Hl)!=="svelte-162i3ur"&&(Hl.innerHTML=gi),ft=n(l),El=T(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1uviqpm"&&(El.innerHTML=Ai),mt=n(l),Ll=T(l,"P",{"data-svelte-h":!0}),o(Ll)!=="svelte-1bxqg0w"&&(Ll.innerHTML=ji),ut=n(l),p(Gl.$$.fragment,l),Ct=n(l),Zl=T(l,"P",{}),Di(Zl).forEach(t),this.h()},h(){It(c,"name","hf:doc:metadata"),It(c,"content",_i),It(f,"class","flex justify-center")},m(l,e){$i(document.head,c),i(l,Wl,e),i(l,Sl,e),i(l,zl,e),U(m,l,e),i(l,Pl,e),U(u,l,e),i(l,Yl,e),i(l,C,e),i(l,Xl,e),i(l,d,e),i(l,ql,e),U(I,l,e),i(l,Kl,e),i(l,O,e),i(l,le,e),i(l,k,e),i(l,ee,e),i(l,g,e),i(l,te,e),i(l,A,e),i(l,ie,e),i(l,j,e),i(l,se,e),i(l,D,e),i(l,ne,e),U(Q,l,e),i(l,ae,e),i(l,b,e),i(l,Te,e),U(R,l,e),i(l,oe,e),i(l,x,e),i(l,Me,e),i(l,v,e),i(l,pe,e),U(N,l,e),i(l,Ue,e),i(l,$,e),i(l,ye,e),i(l,F,e),i(l,Je,e),U(V,l,e),i(l,we,e),i(l,B,e),i(l,re,e),U(_,l,e),i(l,ce,e),i(l,H,e),i(l,he,e),i(l,E,e),i(l,fe,e),U(L,l,e),i(l,me,e),i(l,G,e),i(l,ue,e),i(l,S,e),i(l,Ce,e),U(Z,l,e),i(l,de,e),i(l,W,e),i(l,Ie,e),U(z,l,e),i(l,Oe,e),i(l,P,e),i(l,ke,e),U(Y,l,e),i(l,ge,e),i(l,X,e),i(l,Ae,e),i(l,q,e),i(l,je,e),i(l,K,e),i(l,De,e),i(l,ll,e),i(l,Qe,e),i(l,el,e),i(l,be,e),U(tl,l,e),i(l,Re,e),i(l,il,e),i(l,xe,e),i(l,sl,e),i(l,ve,e),i(l,nl,e),i(l,Ne,e),U(al,l,e),i(l,$e,e),i(l,Tl,e),i(l,Fe,e),i(l,ol,e),i(l,Ve,e),U(Ml,l,e),i(l,Be,e),i(l,pl,e),i(l,_e,e),i(l,Ul,e),i(l,He,e),U(yl,l,e),i(l,Ee,e),U(Jl,l,e),i(l,Le,e),i(l,wl,e),i(l,Ge,e),i(l,rl,e),i(l,Se,e),U(cl,l,e),i(l,Ze,e),i(l,hl,e),i(l,We,e),U(fl,l,e),i(l,ze,e),U(ml,l,e),i(l,Pe,e),i(l,ul,e),i(l,Ye,e),i(l,Cl,e),i(l,Xe,e),i(l,dl,e),i(l,qe,e),i(l,Il,e),i(l,Ke,e),i(l,Ol,e),i(l,lt,e),i(l,f,e),i(l,et,e),i(l,kl,e),i(l,tt,e),i(l,gl,e),i(l,it,e),i(l,Al,e),i(l,st,e),U(jl,l,e),i(l,nt,e),i(l,Dl,e),i(l,at,e),i(l,Ql,e),i(l,Tt,e),i(l,bl,e),i(l,ot,e),i(l,Rl,e),i(l,Mt,e),i(l,xl,e),i(l,pt,e),U(vl,l,e),i(l,Ut,e),i(l,Nl,e),i(l,yt,e),i(l,$l,e),i(l,Jt,e),i(l,Fl,e),i(l,wt,e),i(l,Vl,e),i(l,rt,e),i(l,Bl,e),i(l,ct,e),i(l,_l,e),i(l,ht,e),i(l,Hl,e),i(l,ft,e),i(l,El,e),i(l,mt,e),i(l,Ll,e),i(l,ut,e),U(Gl,l,e),i(l,Ct,e),i(l,Zl,e),dt=!0},p:bi,i(l){dt||(y(m.$$.fragment,l),y(u.$$.fragment,l),y(I.$$.fragment,l),y(Q.$$.fragment,l),y(R.$$.fragment,l),y(N.$$.fragment,l),y(V.$$.fragment,l),y(_.$$.fragment,l),y(L.$$.fragment,l),y(Z.$$.fragment,l),y(z.$$.fragment,l),y(Y.$$.fragment,l),y(tl.$$.fragment,l),y(al.$$.fragment,l),y(Ml.$$.fragment,l),y(yl.$$.fragment,l),y(Jl.$$.fragment,l),y(cl.$$.fragment,l),y(fl.$$.fragment,l),y(ml.$$.fragment,l),y(jl.$$.fragment,l),y(vl.$$.fragment,l),y(Gl.$$.fragment,l),dt=!0)},o(l){J(m.$$.fragment,l),J(u.$$.fragment,l),J(I.$$.fragment,l),J(Q.$$.fragment,l),J(R.$$.fragment,l),J(N.$$.fragment,l),J(V.$$.fragment,l),J(_.$$.fragment,l),J(L.$$.fragment,l),J(Z.$$.fragment,l),J(z.$$.fragment,l),J(Y.$$.fragment,l),J(tl.$$.fragment,l),J(al.$$.fragment,l),J(Ml.$$.fragment,l),J(yl.$$.fragment,l),J(Jl.$$.fragment,l),J(cl.$$.fragment,l),J(fl.$$.fragment,l),J(ml.$$.fragment,l),J(jl.$$.fragment,l),J(vl.$$.fragment,l),J(Gl.$$.fragment,l),dt=!1},d(l){l&&(t(Wl),t(Sl),t(zl),t(Pl),t(Yl),t(C),t(Xl),t(d),t(ql),t(Kl),t(O),t(le),t(k),t(ee),t(g),t(te),t(A),t(ie),t(j),t(se),t(D),t(ne),t(ae),t(b),t(Te),t(oe),t(x),t(Me),t(v),t(pe),t(Ue),t($),t(ye),t(F),t(Je),t(we),t(B),t(re),t(ce),t(H),t(he),t(E),t(fe),t(me),t(G),t(ue),t(S),t(Ce),t(de),t(W),t(Ie),t(Oe),t(P),t(ke),t(ge),t(X),t(Ae),t(q),t(je),t(K),t(De),t(ll),t(Qe),t(el),t(be),t(Re),t(il),t(xe),t(sl),t(ve),t(nl),t(Ne),t($e),t(Tl),t(Fe),t(ol),t(Ve),t(Be),t(pl),t(_e),t(Ul),t(He),t(Ee),t(Le),t(wl),t(Ge),t(rl),t(Se),t(Ze),t(hl),t(We),t(ze),t(Pe),t(ul),t(Ye),t(Cl),t(Xe),t(dl),t(qe),t(Il),t(Ke),t(Ol),t(lt),t(f),t(et),t(kl),t(tt),t(gl),t(it),t(Al),t(st),t(nt),t(Dl),t(at),t(Ql),t(Tt),t(bl),t(ot),t(Rl),t(Mt),t(xl),t(pt),t(Ut),t(Nl),t(yt),t($l),t(Jt),t(Fl),t(wt),t(Vl),t(rt),t(Bl),t(ct),t(_l),t(ht),t(Hl),t(ft),t(El),t(mt),t(Ll),t(ut),t(Ct),t(Zl)),t(c),w(m,l),w(u,l),w(I,l),w(Q,l),w(R,l),w(N,l),w(V,l),w(_,l),w(L,l),w(Z,l),w(z,l),w(Y,l),w(tl,l),w(al,l),w(Ml,l),w(yl,l),w(Jl,l),w(cl,l),w(fl,l),w(ml,l),w(jl,l),w(vl,l),w(Gl,l)}}}const _i='{"title":"Pickle Scanning","local":"pickle-scanning","sections":[{"title":"What is a pickle?","local":"what-is-a-pickle","sections":[],"depth":2},{"title":"Why is it dangerous?","local":"why-is-it-dangerous","sections":[],"depth":2},{"title":"Mitigation Strategies","local":"mitigation-strategies","sections":[{"title":"Load files from users and organizations you trust","local":"load-files-from-users-and-organizations-you-trust","sections":[],"depth":3},{"title":"Load model weights from TF or Flax","local":"load-model-weights-from-tf-or-flax","sections":[],"depth":3},{"title":"Use your own serialization format","local":"use-your-own-serialization-format","sections":[],"depth":3},{"title":"Improve torch.load/save","local":"improve-torchloadsave","sections":[],"depth":3},{"title":"Hub’s Security Scanner","local":"hubs-security-scanner","sections":[{"title":"What we have now","local":"what-we-have-now","sections":[],"depth":4},{"title":"Potential solutions","local":"potential-solutions","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Hi(Ot){return Ri(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wi extends xi{constructor(c){super(),vi(this,c,Hi,Bi,Qi,{})}}export{Wi as component};
