import{s as Ue,n as Ze,o as _e}from"../chunks/scheduler.9cda857a.js";import{S as Be,i as Ce,e as i,s as l,c as d,h as Xe,a as o,d as a,b as n,f as je,g as r,j as p,k as Ge,l as Re,m as s,n as m,t as u,o as f,p as c}from"../chunks/index.f47f3121.js";import{C as Ie}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as h}from"../chunks/CodeBlock.24d62f98.js";import{H as pt,E as ve}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function He(ee){let y,dt,it,rt,M,mt,w,ut,J,ae='<a href="https://www.dask.org/?utm_source=hf-docs" rel="nofollow">Dask</a> is a parallel and distributed computing library that scales the existing Python and PyData ecosystem.',ft,k,se='In particular, we can use <a href="https://docs.dask.org/en/stable/dataframe.html?utm_source=hf-docs" rel="nofollow">Dask DataFrame</a> to scale up pandas workflows. Dask DataFrame parallelizes pandas to handle large tabular data. It closely mirrors the pandas API, making it simple to transition from testing on a single dataset to processing the full dataset. Dask is particularly effective with Parquet, the default format on Hugging Face Datasets, as it supports rich data types, efficient columnar filtering, and compression.',ct,T,le='A good practical use case for Dask is running data processing or model inference on a dataset in a distributed manner. See, for example, <a href="https://www.coiled.io/?utm_source=hf-docs" rel="nofollow">Coiled’s</a> excellent blog post on <a href="https://huggingface.co/blog/dask-scaling" rel="nofollow">Scaling AI-Based Data Processing with Hugging Face + Dask</a>.',ht,g,yt,b,ne='Since Dask uses <a href="https://filesystem-spec.readthedocs.io" rel="nofollow">fsspec</a> to read and write remote data, you can use the Hugging Face paths (<a href="/docs/huggingface_hub/guides/hf_file_system#integrations"><code>hf://</code></a>) to read and write data on the Hub.',Mt,$,ie='First you need to <a href="/docs/huggingface_hub/quick-start#login">Login with your Hugging Face account</a>, for example using:',wt,j,Jt,G,oe='Then you can <a href="/docs/huggingface_hub/quick-start#create-a-repository">Create a dataset repository</a>, for example using:',kt,U,Tt,Z,pe=`Finally, you can use <a href="/docs/huggingface_hub/guides/hf_file_system#integrations">Hugging Face paths</a> in Dask.
Dask DataFrame supports distributed writing to Parquet on Hugging Face, which uses commits to track dataset changes:`,gt,_,bt,B,de="Since this creates one commit per file, it is recommended to squash the history after the upload:",$t,C,jt,X,re=`This creates a dataset repository <code>username/my_dataset</code> containing your Dask dataset in Parquet format.
You can reload it later:`,Gt,R,Ut,I,me='For more information on the Hugging Face paths and how they are implemented, please refer to the <a href="/docs/huggingface_hub/guides/hf_file_system">the client library’s documentation on the HfFileSystem</a>.',Zt,v,_t,H,ue="To process a dataset in parallel using Dask, you can first define your data processing function for a pandas DataFrame or Series, and then use the Dask <code>map_partitions</code> function to apply this function to all the partitions of a dataset in parallel:",Bt,F,Ct,V,fe="or a similar function using pandas string methods (faster):",Xt,x,Rt,W,ce="In pandas you can use this function on a text column:",It,q,vt,Y,he="And in Dask you can run this function on every partition:",Ht,z,Ft,Q,ye=`Note that you also need to provide <code>meta</code> which is the type of the pandas Series or DataFrame in the output of your function.
This is needed because Dask DataFrame uses a lazy API. Since Dask will only run the data processing once <code>.compute()</code> is called, it needs
the <code>meta</code> argument to know the type of the new column in the meantime.`,Vt,P,xt,L,Me="When reading Parquet data from Hugging Face, Dask automatically leverages the metadata in Parquet files to skip entire files or row groups if they are not needed. For example if you apply a filter (predicate) on a Hugging Face Dataset in Parquet format or if you select a subset of the columns (projection), Dask will read the metadata of the Parquet files to discard the parts that are not needed without downloading them.",Wt,N,we='This is possible thanks to a <a href="https://docs.coiled.io/blog/dask-dataframe-is-fast.html?utm_source=hf-docs" rel="nofollow">reimplementation of the Dask DataFrame API</a> to support query optimization, which makes Dask faster and more robust.',qt,D,Je="For example this subset of FineWeb-Edu contains many Parquet files. If you can filter the dataset to keep the text from recent CC dumps, Dask will skip most of the files and only download the data that match the filter:",Yt,S,zt,E,ke=`Dask will also read only the required columns for your computation and skip the rest.
For example if you drop a column late in your code, it will not bother to load it early on in the pipeline if it’s not needed.
This is useful when you want to manipulate a subset of the columns or for analytics:`,Qt,A,Pt,K,Lt,O,Te="Most features in <code>dask</code> are optimized for a cluster or a local <code>Client</code> to launch the parallel computations:",Nt,tt,Dt,et,ge="For local usage, the <code>Client</code> uses a Dask <code>LocalCluster</code> with multiprocessing by default. You can manually configure the multiprocessing of <code>LocalCluster</code> with",St,at,Et,st,be='Note that if you use the default threaded scheduler locally without <code>Client</code>, a DataFrame can become slower after certain operations (more details <a href="https://github.com/dask/dask-expr/issues/1181" rel="nofollow">here</a>).',At,lt,$e='Find more information on setting up a local or cloud cluster in the <a href="https://docs.dask.org/en/latest/deploying.html" rel="nofollow">Deploying Dask documentation</a>.',Kt,nt,Ot,ot,te;return M=new Ie({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new pt({props:{title:"Dask",local:"dask",headingTag:"h1"}}),g=new pt({props:{title:"Read and Write",local:"read-and-write",headingTag:"h2"}}),j=new h({props:{code:"aGYlMjBhdXRoJTIwbG9naW4=",highlighted:'<span class="hljs-attribute">hf auth login</span>',wrap:!1}}),U=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().create_repo(repo_id=<span class="hljs-string">&quot;username/my_dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),_=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTIyKSUwQSUwQSUyMyUyMG9yJTIwd3JpdGUlMjBpbiUyMHNlcGFyYXRlJTIwZGlyZWN0b3JpZXMlMjBpZiUyMHRoZSUyMGRhdGFzZXQlMjBoYXMlMjB0cmFpbiUyRnZhbGlkYXRpb24lMkZ0ZXN0JTIwc3BsaXRzJTBBZGZfdHJhaW4udG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdHJhaW4lMjIpJTBBZGZfdmFsaWQudG9fcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdmFsaWRhdGlvbiUyMiklMEFkZl90ZXN0JTIwLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnRlc3QlMjIp",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset&quot;</span>)

<span class="hljs-comment"># or write in separate directories if the dataset has train/validation/test splits</span>
df_train.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/train&quot;</span>)
df_valid.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation&quot;</span>)
df_test .to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/test&quot;</span>)`,wrap:!1}}),C=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBSGZBcGkoKS5zdXBlcl9zcXVhc2hfaGlzdG9yeShyZXBvX2lkJTNEcmVwb19pZCUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

HfApi().super_squash_history(repo_id=repo_id, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),R=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyMiklMEElMEElMjMlMjBvciUyMHJlYWQlMjBmcm9tJTIwc2VwYXJhdGUlMjBkaXJlY3RvcmllcyUyMGlmJTIwdGhlJTIwZGF0YXNldCUyMGhhcyUyMHRyYWluJTJGdmFsaWRhdGlvbiUyRnRlc3QlMjBzcGxpdHMlMEFkZl90cmFpbiUyMCUzRCUyMGRkLnJlYWRfcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdHJhaW4lMjIpJTBBZGZfdmFsaWQlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXlfZGF0YXNldCUyRnZhbGlkYXRpb24lMjIpJTBBZGZfdGVzdCUyMCUyMCUzRCUyMGRkLnJlYWRfcGFycXVldCglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGdXNlcm5hbWUlMkZteV9kYXRhc2V0JTJGdGVzdCUyMik=",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset&quot;</span>)

<span class="hljs-comment"># or read from separate directories if the dataset has train/validation/test splits</span>
df_train = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/train&quot;</span>)
df_valid = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/validation&quot;</span>)
df_test  = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/username/my_dataset/test&quot;</span>)`,wrap:!1}}),v=new pt({props:{title:"Process data",local:"process-data",headingTag:"h2"}}),F=new h({props:{code:"ZGVmJTIwZHVtbXlfY291bnRfd29yZHModGV4dHMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcGQuU2VyaWVzKCU1Qmxlbih0ZXh0LnNwbGl0KCUyMiUyMCUyMikpJTIwZm9yJTIwdGV4dCUyMGluJTIwdGV4dHMlNUQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dummy_count_words</span>(<span class="hljs-params">texts</span>):
    <span class="hljs-keyword">return</span> pd.Series([<span class="hljs-built_in">len</span>(text.split(<span class="hljs-string">&quot; &quot;</span>)) <span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> texts])`,wrap:!1}}),x=new h({props:{code:"ZGVmJTIwZHVtbXlfY291bnRfd29yZHModGV4dHMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGV4dHMuc3RyLmNvdW50KCUyMiUyMCUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">dummy_count_words</span>(<span class="hljs-params">texts</span>):
    <span class="hljs-keyword">return</span> texts.<span class="hljs-built_in">str</span>.count(<span class="hljs-string">&quot; &quot;</span>)`,wrap:!1}}),q=new h({props:{code:"JTIzJTIwcGFuZGFzJTIwQVBJJTBBZGYlNUIlMjJudW1fd29yZHMlMjIlNUQlMjAlM0QlMjBkdW1teV9jb3VudF93b3JkcyhkZi50ZXh0KQ==",highlighted:`<span class="hljs-comment"># pandas API</span>
df[<span class="hljs-string">&quot;num_words&quot;</span>] = dummy_count_words(df.text)`,wrap:!1}}),z=new h({props:{code:"JTIzJTIwRGFzayUyMEFQSSUzQSUyMHJ1biUyMHRoZSUyMGZ1bmN0aW9uJTIwb24lMjBldmVyeSUyMHBhcnRpdGlvbiUwQWRmJTVCJTIybnVtX3dvcmRzJTIyJTVEJTIwJTNEJTIwZGYudGV4dC5tYXBfcGFydGl0aW9ucyhkdW1teV9jb3VudF93b3JkcyUyQyUyMG1ldGElM0RpbnQp",highlighted:`<span class="hljs-comment"># Dask API: run the function on every partition</span>
df[<span class="hljs-string">&quot;num_words&quot;</span>] = df.text.map_partitions(dummy_count_words, meta=<span class="hljs-built_in">int</span>)`,wrap:!1}}),P=new pt({props:{title:"Predicate and Projection Pushdown",local:"predicate-and-projection-pushdown",headingTag:"h2"}}),S=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBJTBBZGYlMjAlM0QlMjBkZC5yZWFkX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRkh1Z2dpbmdGYWNlRlclMkZmaW5ld2ViLWVkdSUyRnNhbXBsZSUyRjEwQlQlMkYqLnBhcnF1ZXQlMjIpJTBBJTBBJTIzJTIwRGFzayUyMHdpbGwlMjBza2lwJTIwdGhlJTIwZmlsZXMlMjBvciUyMHJvdyUyMGdyb3VwcyUyMHRoYXQlMjBkb24ndCUwQSUyMyUyMG1hdGNoJTIwdGhlJTIwcXVlcnklMjB3aXRob3V0JTIwZG93bmxvYWRpbmclMjB0aGVtLiUwQWRmJTIwJTNEJTIwZGYlNUJkZi5kdW1wJTIwJTNFJTNEJTIwJTIyQ0MtTUFJTi0yMDIzJTIyJTVE",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd

df = dd.read_parquet(<span class="hljs-string">&quot;hf://datasets/HuggingFaceFW/fineweb-edu/sample/10BT/*.parquet&quot;</span>)

<span class="hljs-comment"># Dask will skip the files or row groups that don&#x27;t</span>
<span class="hljs-comment"># match the query without downloading them.</span>
df = df[df.dump &gt;= <span class="hljs-string">&quot;CC-MAIN-2023&quot;</span>]`,wrap:!1}}),A=new h({props:{code:"JTIzJTIwRGFzayUyMHdpbGwlMjBkb3dubG9hZCUyMHRoZSUyMCdkdW1wJyUyMGFuZCUyMCd0b2tlbl9jb3VudCclMjBuZWVkZWQlMEElMjMlMjBmb3IlMjB0aGUlMjBmaWx0ZXJpbmclMjBhbmQlMjBjb21wdXRhdGlvbiUyMGFuZCUyMHNraXAlMjB0aGUlMjBvdGhlciUyMGNvbHVtbnMuJTBBZGYudG9rZW5fY291bnQubWVhbigpLmNvbXB1dGUoKQ==",highlighted:`<span class="hljs-comment"># Dask will download the &#x27;dump&#x27; and &#x27;token_count&#x27; needed</span>
<span class="hljs-comment"># for the filtering and computation and skip the other columns.</span>
df.token_count.mean().compute()`,wrap:!1}}),K=new pt({props:{title:"Client",local:"client",headingTag:"h2"}}),tt=new h({props:{code:"aW1wb3J0JTIwZGFzay5kYXRhZnJhbWUlMjBhcyUyMGRkJTBBZnJvbSUyMGRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwQ2xpZW50JTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTIwJTIwJTIzJTIwbmVlZGVkJTIwZm9yJTIwY3JlYXRpbmclMjBuZXclMjBwcm9jZXNzZXMlMEElMjAlMjAlMjAlMjBjbGllbnQlMjAlM0QlMjBDbGllbnQoKSUwQSUyMCUyMCUyMCUyMGRmJTIwJTNEJTIwZGQucmVhZF9wYXJxdWV0KC4uLiklMEElMjAlMjAlMjAlMjAuLi4=",highlighted:`<span class="hljs-keyword">import</span> dask.dataframe <span class="hljs-keyword">as</span> dd
<span class="hljs-keyword">from</span> distributed <span class="hljs-keyword">import</span> Client

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:  <span class="hljs-comment"># needed for creating new processes</span>
    client = Client()
    df = dd.read_parquet(...)
    ...`,wrap:!1}}),at=new h({props:{code:"ZnJvbSUyMGRhc2suZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBMb2NhbENsdXN0ZXIlMEFjbHVzdGVyJTIwJTNEJTIwTG9jYWxDbHVzdGVyKG5fd29ya2VycyUzRDglMkMlMjB0aHJlYWRzX3Blcl93b3JrZXIlM0Q4KSUwQWNsaWVudCUyMCUzRCUyMENsaWVudChjbHVzdGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> dask.distributed <span class="hljs-keyword">import</span> Client, LocalCluster
cluster = LocalCluster(n_workers=<span class="hljs-number">8</span>, threads_per_worker=<span class="hljs-number">8</span>)
client = Client(cluster)`,wrap:!1}}),nt=new ve({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-dask.md"}}),{c(){y=i("meta"),dt=l(),it=i("p"),rt=l(),d(M.$$.fragment),mt=l(),d(w.$$.fragment),ut=l(),J=i("p"),J.innerHTML=ae,ft=l(),k=i("p"),k.innerHTML=se,ct=l(),T=i("p"),T.innerHTML=le,ht=l(),d(g.$$.fragment),yt=l(),b=i("p"),b.innerHTML=ne,Mt=l(),$=i("p"),$.innerHTML=ie,wt=l(),d(j.$$.fragment),Jt=l(),G=i("p"),G.innerHTML=oe,kt=l(),d(U.$$.fragment),Tt=l(),Z=i("p"),Z.innerHTML=pe,gt=l(),d(_.$$.fragment),bt=l(),B=i("p"),B.textContent=de,$t=l(),d(C.$$.fragment),jt=l(),X=i("p"),X.innerHTML=re,Gt=l(),d(R.$$.fragment),Ut=l(),I=i("p"),I.innerHTML=me,Zt=l(),d(v.$$.fragment),_t=l(),H=i("p"),H.innerHTML=ue,Bt=l(),d(F.$$.fragment),Ct=l(),V=i("p"),V.textContent=fe,Xt=l(),d(x.$$.fragment),Rt=l(),W=i("p"),W.textContent=ce,It=l(),d(q.$$.fragment),vt=l(),Y=i("p"),Y.textContent=he,Ht=l(),d(z.$$.fragment),Ft=l(),Q=i("p"),Q.innerHTML=ye,Vt=l(),d(P.$$.fragment),xt=l(),L=i("p"),L.textContent=Me,Wt=l(),N=i("p"),N.innerHTML=we,qt=l(),D=i("p"),D.textContent=Je,Yt=l(),d(S.$$.fragment),zt=l(),E=i("p"),E.textContent=ke,Qt=l(),d(A.$$.fragment),Pt=l(),d(K.$$.fragment),Lt=l(),O=i("p"),O.innerHTML=Te,Nt=l(),d(tt.$$.fragment),Dt=l(),et=i("p"),et.innerHTML=ge,St=l(),d(at.$$.fragment),Et=l(),st=i("p"),st.innerHTML=be,At=l(),lt=i("p"),lt.innerHTML=$e,Kt=l(),d(nt.$$.fragment),Ot=l(),ot=i("p"),this.h()},l(t){const e=Xe("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(a),dt=n(t),it=o(t,"P",{}),je(it).forEach(a),rt=n(t),r(M.$$.fragment,t),mt=n(t),r(w.$$.fragment,t),ut=n(t),J=o(t,"P",{"data-svelte-h":!0}),p(J)!=="svelte-7bngbf"&&(J.innerHTML=ae),ft=n(t),k=o(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-i5foif"&&(k.innerHTML=se),ct=n(t),T=o(t,"P",{"data-svelte-h":!0}),p(T)!=="svelte-x5cdod"&&(T.innerHTML=le),ht=n(t),r(g.$$.fragment,t),yt=n(t),b=o(t,"P",{"data-svelte-h":!0}),p(b)!=="svelte-17pc16c"&&(b.innerHTML=ne),Mt=n(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-1jdzygp"&&($.innerHTML=ie),wt=n(t),r(j.$$.fragment,t),Jt=n(t),G=o(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-wfb25d"&&(G.innerHTML=oe),kt=n(t),r(U.$$.fragment,t),Tt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1qjbxya"&&(Z.innerHTML=pe),gt=n(t),r(_.$$.fragment,t),bt=n(t),B=o(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1g4eau0"&&(B.textContent=de),$t=n(t),r(C.$$.fragment,t),jt=n(t),X=o(t,"P",{"data-svelte-h":!0}),p(X)!=="svelte-14rczfs"&&(X.innerHTML=re),Gt=n(t),r(R.$$.fragment,t),Ut=n(t),I=o(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-smuvdf"&&(I.innerHTML=me),Zt=n(t),r(v.$$.fragment,t),_t=n(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-jyx2ul"&&(H.innerHTML=ue),Bt=n(t),r(F.$$.fragment,t),Ct=n(t),V=o(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-13b7gvr"&&(V.textContent=fe),Xt=n(t),r(x.$$.fragment,t),Rt=n(t),W=o(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1qxyr3j"&&(W.textContent=ce),It=n(t),r(q.$$.fragment,t),vt=n(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1387ba7"&&(Y.textContent=he),Ht=n(t),r(z.$$.fragment,t),Ft=n(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1php7k6"&&(Q.innerHTML=ye),Vt=n(t),r(P.$$.fragment,t),xt=n(t),L=o(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-eeqqwq"&&(L.textContent=Me),Wt=n(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1eaadiq"&&(N.innerHTML=we),qt=n(t),D=o(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-nn7d20"&&(D.textContent=Je),Yt=n(t),r(S.$$.fragment,t),zt=n(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-13j15e1"&&(E.textContent=ke),Qt=n(t),r(A.$$.fragment,t),Pt=n(t),r(K.$$.fragment,t),Lt=n(t),O=o(t,"P",{"data-svelte-h":!0}),p(O)!=="svelte-hps2t7"&&(O.innerHTML=Te),Nt=n(t),r(tt.$$.fragment,t),Dt=n(t),et=o(t,"P",{"data-svelte-h":!0}),p(et)!=="svelte-2utr02"&&(et.innerHTML=ge),St=n(t),r(at.$$.fragment,t),Et=n(t),st=o(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-1kflfyu"&&(st.innerHTML=be),At=n(t),lt=o(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-112dp33"&&(lt.innerHTML=$e),Kt=n(t),r(nt.$$.fragment,t),Ot=n(t),ot=o(t,"P",{}),je(ot).forEach(a),this.h()},h(){Ge(y,"name","hf:doc:metadata"),Ge(y,"content",Fe)},m(t,e){Re(document.head,y),s(t,dt,e),s(t,it,e),s(t,rt,e),m(M,t,e),s(t,mt,e),m(w,t,e),s(t,ut,e),s(t,J,e),s(t,ft,e),s(t,k,e),s(t,ct,e),s(t,T,e),s(t,ht,e),m(g,t,e),s(t,yt,e),s(t,b,e),s(t,Mt,e),s(t,$,e),s(t,wt,e),m(j,t,e),s(t,Jt,e),s(t,G,e),s(t,kt,e),m(U,t,e),s(t,Tt,e),s(t,Z,e),s(t,gt,e),m(_,t,e),s(t,bt,e),s(t,B,e),s(t,$t,e),m(C,t,e),s(t,jt,e),s(t,X,e),s(t,Gt,e),m(R,t,e),s(t,Ut,e),s(t,I,e),s(t,Zt,e),m(v,t,e),s(t,_t,e),s(t,H,e),s(t,Bt,e),m(F,t,e),s(t,Ct,e),s(t,V,e),s(t,Xt,e),m(x,t,e),s(t,Rt,e),s(t,W,e),s(t,It,e),m(q,t,e),s(t,vt,e),s(t,Y,e),s(t,Ht,e),m(z,t,e),s(t,Ft,e),s(t,Q,e),s(t,Vt,e),m(P,t,e),s(t,xt,e),s(t,L,e),s(t,Wt,e),s(t,N,e),s(t,qt,e),s(t,D,e),s(t,Yt,e),m(S,t,e),s(t,zt,e),s(t,E,e),s(t,Qt,e),m(A,t,e),s(t,Pt,e),m(K,t,e),s(t,Lt,e),s(t,O,e),s(t,Nt,e),m(tt,t,e),s(t,Dt,e),s(t,et,e),s(t,St,e),m(at,t,e),s(t,Et,e),s(t,st,e),s(t,At,e),s(t,lt,e),s(t,Kt,e),m(nt,t,e),s(t,Ot,e),s(t,ot,e),te=!0},p:Ze,i(t){te||(u(M.$$.fragment,t),u(w.$$.fragment,t),u(g.$$.fragment,t),u(j.$$.fragment,t),u(U.$$.fragment,t),u(_.$$.fragment,t),u(C.$$.fragment,t),u(R.$$.fragment,t),u(v.$$.fragment,t),u(F.$$.fragment,t),u(x.$$.fragment,t),u(q.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(S.$$.fragment,t),u(A.$$.fragment,t),u(K.$$.fragment,t),u(tt.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),te=!0)},o(t){f(M.$$.fragment,t),f(w.$$.fragment,t),f(g.$$.fragment,t),f(j.$$.fragment,t),f(U.$$.fragment,t),f(_.$$.fragment,t),f(C.$$.fragment,t),f(R.$$.fragment,t),f(v.$$.fragment,t),f(F.$$.fragment,t),f(x.$$.fragment,t),f(q.$$.fragment,t),f(z.$$.fragment,t),f(P.$$.fragment,t),f(S.$$.fragment,t),f(A.$$.fragment,t),f(K.$$.fragment,t),f(tt.$$.fragment,t),f(at.$$.fragment,t),f(nt.$$.fragment,t),te=!1},d(t){t&&(a(dt),a(it),a(rt),a(mt),a(ut),a(J),a(ft),a(k),a(ct),a(T),a(ht),a(yt),a(b),a(Mt),a($),a(wt),a(Jt),a(G),a(kt),a(Tt),a(Z),a(gt),a(bt),a(B),a($t),a(jt),a(X),a(Gt),a(Ut),a(I),a(Zt),a(_t),a(H),a(Bt),a(Ct),a(V),a(Xt),a(Rt),a(W),a(It),a(vt),a(Y),a(Ht),a(Ft),a(Q),a(Vt),a(xt),a(L),a(Wt),a(N),a(qt),a(D),a(Yt),a(zt),a(E),a(Qt),a(Pt),a(Lt),a(O),a(Nt),a(Dt),a(et),a(St),a(Et),a(st),a(At),a(lt),a(Kt),a(Ot),a(ot)),a(y),c(M,t),c(w,t),c(g,t),c(j,t),c(U,t),c(_,t),c(C,t),c(R,t),c(v,t),c(F,t),c(x,t),c(q,t),c(z,t),c(P,t),c(S,t),c(A,t),c(K,t),c(tt,t),c(at,t),c(nt,t)}}}const Fe='{"title":"Dask","local":"dask","sections":[{"title":"Read and Write","local":"read-and-write","sections":[],"depth":2},{"title":"Process data","local":"process-data","sections":[],"depth":2},{"title":"Predicate and Projection Pushdown","local":"predicate-and-projection-pushdown","sections":[],"depth":2},{"title":"Client","local":"client","sections":[],"depth":2}],"depth":1}';function Ve(ee){return _e(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qe extends Be{constructor(y){super(),Ce(this,y,Ve,He,Ue,{})}}export{Qe as component};
