import{s as Ee,n as qe,o as Re}from"../chunks/scheduler.9cda857a.js";import{S as Xe,i as Fe,e as n,s as l,c as d,h as Be,a as o,d as a,b as s,f as Le,g as u,j as r,k as Ge,l as De,m as i,n as h,t as p,o as f,p as m}from"../chunks/index.f47f3121.js";import{C as Se}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as ae}from"../chunks/CodeBlock.24d62f98.js";import{H as b,E as Ze}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function ze(ie){let c,dt,ot,ut,g,ht,y,pt,w,le=`The Datasets Hub has support for several libraries in the Open Source ecosystem.
Thanks to the <a href="/docs/huggingface_hub">huggingface_hub Python library</a>, it’s easy to enable sharing your datasets on the Hub.
We’re happy to welcome to the Hub a set of Open Source libraries that are pushing Machine Learning forward.`,ft,M,se="The table below summarizes the supported libraries and their level of integration.",mt,v,ne='<thead><tr><th>Library</th> <th>Description</th> <th>Download from Hub</th> <th>Push to Hub</th></tr></thead> <tbody><tr><td><a href="./datasets-argilla">Argilla</a></td> <td>Collaboration tool for AI engineers and domain experts that value high quality data.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-daft">Daft</a></td> <td>Data engine for large scale, multimodal data processing with a Python-native interface.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-dask">Dask</a></td> <td>Parallel and distributed computing library that scales the existing Python and PyData ecosystem.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-usage">Datasets</a></td> <td>🤗 Datasets is a library for accessing and sharing datasets for Audio, Computer Vision, and Natural Language Processing (NLP).</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-distilabel">Distilabel</a></td> <td>The framework for synthetic data generation and AI feedback.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-duckdb">DuckDB</a></td> <td>In-process SQL OLAP database management system.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-embedding-atlas">Embedding Atlas</a></td> <td>Interactive visualization and exploration tool for large embeddings.</td> <td>✅</td> <td>❌</td></tr> <tr><td><a href="./datasets-fiftyone">FiftyOne</a></td> <td>FiftyOne is a library for curation and visualization of image, video, and 3D data.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-pandas">Pandas</a></td> <td>Python data analysis toolkit.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-polars">Polars</a></td> <td>A DataFrame library on top of an OLAP query engine.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-pyarrow">PyArrow</a></td> <td>Apache Arrow is a columnar format and a toolbox for fast data interchange and in-memory analytics.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-spark">Spark</a></td> <td>Real-time, large-scale data processing tool in a distributed environment.</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="./datasets-webdataset">WebDataset</a></td> <td>Library to write I/O pipelines for large datasets.</td> <td>✅</td> <td>❌</td></tr></tbody>',ct,T,bt,$,oe="This guide is designed for developers and maintainers of data libraries and tools who want to integrate with the Hugging Face Hub. Whether you’re building a data processing library, analysis tool, or any software that needs to interact with datasets, this documentation will help you implement a Hub integration.",gt,x,re="The guide covers:",yt,_,de="<li>Possible approaches to loading data from the Hub into your library/tool</li> <li>Possible approaches to uploading data from your library/tool to the Hub</li>",wt,H,Mt,C,ue="If you have a library for working with data, it can be helpful for your users to load data from the Hub.",vt,U,he="In general, we suggest relying on an existing library like <code>datasets</code>, <code>pandas</code> or <code>polars</code> to do this unless you have a specific reason to implement your own. If you require more control over the loading process, you can use the <code>huggingface_hub</code> library, which will allow you, for example, to download a specific subset of files from a repository.",Tt,J,pe='You can find more information about loading data from the Hub <a href="https://huggingface.co/docs/hub/datasets-downloading" rel="nofollow">here</a>.',$t,k,xt,P,fe="The Hub’s dataset viewer and Parquet conversion system provide a standardized way to integrate with datasets, regardless of their original format. This infrastructure is a reliable integration layer between the Hub and external libraries.",_t,j,me="If the dataset is not already in Parquet, the Hub automatically converts the first 5GB of every dataset to Parquet format to power the dataset viewer and provide consistent access patterns. This standardization offers several benefits for library integrations:",Ht,I,ce='<li>Consistent data access patterns regardless of original format</li> <li>Built-in dataset preview and exploration through the Hub’s dataset viewer. The dataset viewer can also be embedded as an iframe in your applications, making it easy to provide rich dataset previews. For more information about embedding the viewer, see the <a href="https://huggingface.co/docs/hub/en/datasets-viewer-embed" rel="nofollow">dataset viewer embedding documentation</a>.</li> <li>Efficient columnar storage optimized for querying. For example, you could use a tool like <a href="https://duckdb.org/" rel="nofollow">DuckDB</a> to query or filter for a specific subset of data.</li> <li>Parquet is well supported across the machine learning and data science ecosystem.</li>',Ct,L,be='For more details on working with the Dataset Viewer API, see the <a href="https://huggingface.co/docs/dataset-viewer/index" rel="nofollow">Dataset Viewer API documentation</a>',Ut,G,Jt,E,ge="This section covers possible approaches for adding the ability to upload data to the Hub in your library, i.e. how to implement a <code>push_to_hub</code> method.",kt,q,ye="This guide will cover three primary ways to upload data to the Hub:",Pt,R,we="<li>using the <code>datasets</code> library and the <code>push_to_hub</code> method</li> <li>using <code>pandas</code> to write to the Hub</li> <li>using the <code>huggingface_hub</code> library and the <code>hf_hub_download</code> method</li> <li>directly using the API or Git LFS</li>",jt,X,It,F,Me='The most straightforward approach to pushing data to the Hub is to rely on the existing <a href="https://huggingface.co/docs/datasets/v3.2.0/en/package_reference/main_classes#datasets.Dataset.push_to_hub" rel="nofollow"><code>push_to_hub</code></a> method from the <code>datasets</code> library. The <code>push_to_hub</code> method will automatically handle:',Lt,B,ve="<li>the creation of the repository</li> <li>the conversion of the dataset to Parquet</li> <li>chunking the dataset into suitable parts</li> <li>uploading the data</li>",Gt,D,Te="For example, if you have a synthetic data generation library that returns a list of dictionaries, you could simply do the following:",Et,S,qt,Z,$e="Examples of this kind of integration:",Rt,z,xe='<li><a href="https://github.com/argilla-io/distilabel/blob/8ad48387dfa4d7bd5639065661f1975dcb44c16a/src/distilabel/distiset.py#L77" rel="nofollow">Distilabel</a></li>',Xt,A,Ft,V,_e='Polars, Pandas, Dask, Spark, DuckDB, and Daft can all write to a Hugging Face Hub repository. See <a href="https://huggingface.co/docs/hub/datasets-libraries" rel="nofollow">datasets libraries</a> for more details.',Bt,N,He="If you are already using one of these libraries in your code, adding the ability to push to the Hub is straightforward. For example, if you have a synthetic data generation library that can return a Pandas DataFrame, here is the code you would need to write to the Hub:",Dt,W,St,Y,Zt,Q,Ce="The <code>huggingface_hub</code> Python library offers a more flexible approach to uploading data to the Hub. The library allows you to upload specific files or subsets of files to a repository. This is useful if you have a large dataset that you don’t want to convert to Parquet, want to upload a specific subset of files, or want more control over the repo structure.",zt,O,Ue="Depending on your use case, you can upload a file or folder at a specific point in your code, i.e., export annotations from a tool to the Hub when a user clicks “push to Hub”. For example,",At,K,Vt,tt,Je='You can find more information about ways to upload data to the Hub <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload" rel="nofollow">here</a>.',Nt,et,ke='Alternatively, there are situations where you may want to upload data in the background, for example, synthetic data being generated every 10 minutes. In this case you can use the <code>scheduled_uploads</code> feature of the <code>huggingface_hub</code> library. For more details, see the <a href="https://huggingface.co/docs/huggingface_hub/main/en/guides/upload#scheduled-uploads" rel="nofollow">scheduled uploads documentation</a>.',Wt,at,Pe="You can see an example of using this approach to upload data to the Hub in",Yt,it,je='<li>The <a href="https://github.com/AnswerDotAI/fastdata/blob/main/nbs/00_core.ipynb" rel="nofollow">fastdata</a> library</li> <li>This <a href="https://huggingface.co/spaces/davanstrien/magpie/blob/fc79672c740b8d3d098378dca37c0f191c208de0/app.py#L67" rel="nofollow">magpie</a> Demo Space</li>',Qt,lt,Ot,st,Ie='For technical questions about integration, feel free to contact the datasets team at <a href="mailto:datasets@huggingface.co">datasets@huggingface.co</a>.',Kt,nt,te,rt,ee;return g=new Se({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new b({props:{title:"Libraries",local:"libraries",headingTag:"h1"}}),T=new b({props:{title:"Integrating data libraries and tools with the Hub",local:"integrating-data-libraries-and-tools-with-the-hub",headingTag:"h2"}}),H=new b({props:{title:"Loading data from the Hub",local:"loading-data-from-the-hub",headingTag:"h3"}}),k=new b({props:{title:"Integrating via the Dataset Viewer and Parquet Files",local:"integrating-via-the-dataset-viewer-and-parquet-files",headingTag:"h4"}}),G=new b({props:{title:"Uploading data to the Hub",local:"uploading-data-to-the-hub",headingTag:"h3"}}),X=new b({props:{title:"Use the datasets library",local:"use-the-datasets-library",headingTag:"h4"}}),S=new ae({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGElMjAlM0QlMjAlNUIlN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjJXcml0ZSUyMGElMjBjYWtlJTIwcmVjaXBlJTIyJTJDJTIwJTIycmVzcG9uc2UlMjIlM0ElMjAlMjJNZWFzdXJlJTIwMSUyMGN1cCUyMC4uLiUyMiU3RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2xpc3QoZGF0YSklMEFkcy5wdXNoX3RvX2h1YiglMjJVU0VSTkFNRV9PUl9PUkclMkZyZXBvX0lEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

data = [{<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;Write a cake recipe&quot;</span>, <span class="hljs-string">&quot;response&quot;</span>: <span class="hljs-string">&quot;Measure 1 cup ...&quot;</span>}]
ds = Dataset.from_list(data)
ds.push_to_hub(<span class="hljs-string">&quot;USERNAME_OR_ORG/repo_ID&quot;</span>)`,wrap:!1}}),A=new b({props:{title:"Rely on an existing libraries integration with the Hub",local:"rely-on-an-existing-libraries-integration-with-the-hub",headingTag:"h4"}}),W=new ae({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMEh1YiUyMEFQSSUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSklMEElMEElMjMlMjBDcmVhdGUlMjBhJTIwcmVwb3NpdG9yeSUyMChpZiUyMGl0JTIwZG9lc24ndCUyMGV4aXN0KSUwQWhmX2FwaS5jcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIydXNlcm5hbWUlMkZteS1kYXRhc2V0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiklMEElMEElMjMlMjBDb252ZXJ0JTIweW91ciUyMGRhdGElMjB0byUyMGElMjBEYXRhRnJhbWUlMjBhbmQlMjBzYXZlJTIwZGlyZWN0bHklMjB0byUyMHRoZSUyMEh1YiUwQWRmLnRvX3BhcnF1ZXQoJTIyaGYlM0ElMkYlMkZkYXRhc2V0cyUyRnVzZXJuYW1lJTJGbXktZGF0YXNldCUyRmRhdGEucGFycXVldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

<span class="hljs-comment"># Initialize the Hub API</span>
hf_api = HfApi(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>))

<span class="hljs-comment"># Create a repository (if it doesn&#x27;t exist)</span>
hf_api.create_repo(repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)

<span class="hljs-comment"># Convert your data to a DataFrame and save directly to the Hub</span>
df.to_parquet(<span class="hljs-string">&quot;hf://datasets/username/my-dataset/data.parquet&quot;</span>)`,wrap:!1}}),Y=new b({props:{title:"Using the huggingface_hub Python library",local:"using-the-huggingfacehub-python-library",headingTag:"h4"}}),K=new ae({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBYXBpJTIwJTNEJTIwSGZBcGkodG9rZW4lM0RIRl9UT0tFTiklMEElMEFhcGkudXBsb2FkX2ZvbGRlciglMEElMjAlMjAlMjAlMjBmb2xkZXJfcGF0aCUzRCUyMiUyRm15LWNvb2wtbGlicmFyeSUyRmRhdGEtZm9sZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMnVzZXJuYW1lJTJGbXktY29vbC1zcGFjZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjBjb21taXRfbWVzc2FnZSUzRCUyMlB1c2glMjBhbm5vdGF0aW9ucyUyMHRvJTIwSHViJTIyJTBBJTIwJTIwJTIwJTIwYWxsb3dfcGF0dGVybnMlM0QlMjIqLmpzb25sJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi
api = HfApi(token=HF_TOKEN)

api.upload_folder(
    folder_path=<span class="hljs-string">&quot;/my-cool-library/data-folder&quot;</span>,
    repo_id=<span class="hljs-string">&quot;username/my-cool-space&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    commit_message=<span class="hljs-string">&quot;Push annotations to Hub&quot;</span>
    allow_patterns=<span class="hljs-string">&quot;*.jsonl&quot;</span>,
)`,wrap:!1}}),lt=new b({props:{title:"More support",local:"more-support",headingTag:"h2"}}),nt=new Ze({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/datasets-libraries.md"}}),{c(){c=n("meta"),dt=l(),ot=n("p"),ut=l(),d(g.$$.fragment),ht=l(),d(y.$$.fragment),pt=l(),w=n("p"),w.innerHTML=le,ft=l(),M=n("p"),M.textContent=se,mt=l(),v=n("table"),v.innerHTML=ne,ct=l(),d(T.$$.fragment),bt=l(),$=n("p"),$.textContent=oe,gt=l(),x=n("p"),x.textContent=re,yt=l(),_=n("ul"),_.innerHTML=de,wt=l(),d(H.$$.fragment),Mt=l(),C=n("p"),C.textContent=ue,vt=l(),U=n("p"),U.innerHTML=he,Tt=l(),J=n("p"),J.innerHTML=pe,$t=l(),d(k.$$.fragment),xt=l(),P=n("p"),P.textContent=fe,_t=l(),j=n("p"),j.textContent=me,Ht=l(),I=n("ul"),I.innerHTML=ce,Ct=l(),L=n("p"),L.innerHTML=be,Ut=l(),d(G.$$.fragment),Jt=l(),E=n("p"),E.innerHTML=ge,kt=l(),q=n("p"),q.textContent=ye,Pt=l(),R=n("ul"),R.innerHTML=we,jt=l(),d(X.$$.fragment),It=l(),F=n("p"),F.innerHTML=Me,Lt=l(),B=n("ul"),B.innerHTML=ve,Gt=l(),D=n("p"),D.textContent=Te,Et=l(),d(S.$$.fragment),qt=l(),Z=n("p"),Z.textContent=$e,Rt=l(),z=n("ul"),z.innerHTML=xe,Xt=l(),d(A.$$.fragment),Ft=l(),V=n("p"),V.innerHTML=_e,Bt=l(),N=n("p"),N.textContent=He,Dt=l(),d(W.$$.fragment),St=l(),d(Y.$$.fragment),Zt=l(),Q=n("p"),Q.innerHTML=Ce,zt=l(),O=n("p"),O.textContent=Ue,At=l(),d(K.$$.fragment),Vt=l(),tt=n("p"),tt.innerHTML=Je,Nt=l(),et=n("p"),et.innerHTML=ke,Wt=l(),at=n("p"),at.textContent=Pe,Yt=l(),it=n("ul"),it.innerHTML=je,Qt=l(),d(lt.$$.fragment),Ot=l(),st=n("p"),st.innerHTML=Ie,Kt=l(),d(nt.$$.fragment),te=l(),rt=n("p"),this.h()},l(t){const e=Be("svelte-u9bgzb",document.head);c=o(e,"META",{name:!0,content:!0}),e.forEach(a),dt=s(t),ot=o(t,"P",{}),Le(ot).forEach(a),ut=s(t),u(g.$$.fragment,t),ht=s(t),u(y.$$.fragment,t),pt=s(t),w=o(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-19pvdk"&&(w.innerHTML=le),ft=s(t),M=o(t,"P",{"data-svelte-h":!0}),r(M)!=="svelte-ff3ufa"&&(M.textContent=se),mt=s(t),v=o(t,"TABLE",{"data-svelte-h":!0}),r(v)!=="svelte-1l3hzk9"&&(v.innerHTML=ne),ct=s(t),u(T.$$.fragment,t),bt=s(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1bmppgx"&&($.textContent=oe),gt=s(t),x=o(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-e0z0qx"&&(x.textContent=re),yt=s(t),_=o(t,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-162x9zs"&&(_.innerHTML=de),wt=s(t),u(H.$$.fragment,t),Mt=s(t),C=o(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-chb2m7"&&(C.textContent=ue),vt=s(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-m9xre3"&&(U.innerHTML=he),Tt=s(t),J=o(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1kfkj1n"&&(J.innerHTML=pe),$t=s(t),u(k.$$.fragment,t),xt=s(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-nyvi1q"&&(P.textContent=fe),_t=s(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-sdabnb"&&(j.textContent=me),Ht=s(t),I=o(t,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-14xyszt"&&(I.innerHTML=ce),Ct=s(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-145eyta"&&(L.innerHTML=be),Ut=s(t),u(G.$$.fragment,t),Jt=s(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-ia8icy"&&(E.innerHTML=ge),kt=s(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-166sdwe"&&(q.textContent=ye),Pt=s(t),R=o(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1dyhahs"&&(R.innerHTML=we),jt=s(t),u(X.$$.fragment,t),It=s(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1x8099z"&&(F.innerHTML=Me),Lt=s(t),B=o(t,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-iaou6v"&&(B.innerHTML=ve),Gt=s(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-d45nz"&&(D.textContent=Te),Et=s(t),u(S.$$.fragment,t),qt=s(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-53l0c9"&&(Z.textContent=$e),Rt=s(t),z=o(t,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-5zd4l0"&&(z.innerHTML=xe),Xt=s(t),u(A.$$.fragment,t),Ft=s(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1lhir1l"&&(V.innerHTML=_e),Bt=s(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1s8u1ie"&&(N.textContent=He),Dt=s(t),u(W.$$.fragment,t),St=s(t),u(Y.$$.fragment,t),Zt=s(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ygt6jd"&&(Q.innerHTML=Ce),zt=s(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-7hs1zn"&&(O.textContent=Ue),At=s(t),u(K.$$.fragment,t),Vt=s(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-7kkfko"&&(tt.innerHTML=Je),Nt=s(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-iljeu7"&&(et.innerHTML=ke),Wt=s(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-yedhy2"&&(at.textContent=Pe),Yt=s(t),it=o(t,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-5ri1p0"&&(it.innerHTML=je),Qt=s(t),u(lt.$$.fragment,t),Ot=s(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-zmwud2"&&(st.innerHTML=Ie),Kt=s(t),u(nt.$$.fragment,t),te=s(t),rt=o(t,"P",{}),Le(rt).forEach(a),this.h()},h(){Ge(c,"name","hf:doc:metadata"),Ge(c,"content",Ae)},m(t,e){De(document.head,c),i(t,dt,e),i(t,ot,e),i(t,ut,e),h(g,t,e),i(t,ht,e),h(y,t,e),i(t,pt,e),i(t,w,e),i(t,ft,e),i(t,M,e),i(t,mt,e),i(t,v,e),i(t,ct,e),h(T,t,e),i(t,bt,e),i(t,$,e),i(t,gt,e),i(t,x,e),i(t,yt,e),i(t,_,e),i(t,wt,e),h(H,t,e),i(t,Mt,e),i(t,C,e),i(t,vt,e),i(t,U,e),i(t,Tt,e),i(t,J,e),i(t,$t,e),h(k,t,e),i(t,xt,e),i(t,P,e),i(t,_t,e),i(t,j,e),i(t,Ht,e),i(t,I,e),i(t,Ct,e),i(t,L,e),i(t,Ut,e),h(G,t,e),i(t,Jt,e),i(t,E,e),i(t,kt,e),i(t,q,e),i(t,Pt,e),i(t,R,e),i(t,jt,e),h(X,t,e),i(t,It,e),i(t,F,e),i(t,Lt,e),i(t,B,e),i(t,Gt,e),i(t,D,e),i(t,Et,e),h(S,t,e),i(t,qt,e),i(t,Z,e),i(t,Rt,e),i(t,z,e),i(t,Xt,e),h(A,t,e),i(t,Ft,e),i(t,V,e),i(t,Bt,e),i(t,N,e),i(t,Dt,e),h(W,t,e),i(t,St,e),h(Y,t,e),i(t,Zt,e),i(t,Q,e),i(t,zt,e),i(t,O,e),i(t,At,e),h(K,t,e),i(t,Vt,e),i(t,tt,e),i(t,Nt,e),i(t,et,e),i(t,Wt,e),i(t,at,e),i(t,Yt,e),i(t,it,e),i(t,Qt,e),h(lt,t,e),i(t,Ot,e),i(t,st,e),i(t,Kt,e),h(nt,t,e),i(t,te,e),i(t,rt,e),ee=!0},p:qe,i(t){ee||(p(g.$$.fragment,t),p(y.$$.fragment,t),p(T.$$.fragment,t),p(H.$$.fragment,t),p(k.$$.fragment,t),p(G.$$.fragment,t),p(X.$$.fragment,t),p(S.$$.fragment,t),p(A.$$.fragment,t),p(W.$$.fragment,t),p(Y.$$.fragment,t),p(K.$$.fragment,t),p(lt.$$.fragment,t),p(nt.$$.fragment,t),ee=!0)},o(t){f(g.$$.fragment,t),f(y.$$.fragment,t),f(T.$$.fragment,t),f(H.$$.fragment,t),f(k.$$.fragment,t),f(G.$$.fragment,t),f(X.$$.fragment,t),f(S.$$.fragment,t),f(A.$$.fragment,t),f(W.$$.fragment,t),f(Y.$$.fragment,t),f(K.$$.fragment,t),f(lt.$$.fragment,t),f(nt.$$.fragment,t),ee=!1},d(t){t&&(a(dt),a(ot),a(ut),a(ht),a(pt),a(w),a(ft),a(M),a(mt),a(v),a(ct),a(bt),a($),a(gt),a(x),a(yt),a(_),a(wt),a(Mt),a(C),a(vt),a(U),a(Tt),a(J),a($t),a(xt),a(P),a(_t),a(j),a(Ht),a(I),a(Ct),a(L),a(Ut),a(Jt),a(E),a(kt),a(q),a(Pt),a(R),a(jt),a(It),a(F),a(Lt),a(B),a(Gt),a(D),a(Et),a(qt),a(Z),a(Rt),a(z),a(Xt),a(Ft),a(V),a(Bt),a(N),a(Dt),a(St),a(Zt),a(Q),a(zt),a(O),a(At),a(Vt),a(tt),a(Nt),a(et),a(Wt),a(at),a(Yt),a(it),a(Qt),a(Ot),a(st),a(Kt),a(te),a(rt)),a(c),m(g,t),m(y,t),m(T,t),m(H,t),m(k,t),m(G,t),m(X,t),m(S,t),m(A,t),m(W,t),m(Y,t),m(K,t),m(lt,t),m(nt,t)}}}const Ae='{"title":"Libraries","local":"libraries","sections":[{"title":"Integrating data libraries and tools with the Hub","local":"integrating-data-libraries-and-tools-with-the-hub","sections":[{"title":"Loading data from the Hub","local":"loading-data-from-the-hub","sections":[{"title":"Integrating via the Dataset Viewer and Parquet Files","local":"integrating-via-the-dataset-viewer-and-parquet-files","sections":[],"depth":4}],"depth":3},{"title":"Uploading data to the Hub","local":"uploading-data-to-the-hub","sections":[{"title":"Use the datasets library","local":"use-the-datasets-library","sections":[],"depth":4},{"title":"Rely on an existing libraries integration with the Hub","local":"rely-on-an-existing-libraries-integration-with-the-hub","sections":[],"depth":4},{"title":"Using the huggingface_hub Python library","local":"using-the-huggingfacehub-python-library","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"More support","local":"more-support","sections":[],"depth":2}],"depth":1}';function Ve(ie){return Re(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ke extends Xe{constructor(c){super(),Fe(this,c,Ve,ze,Ee,{})}}export{Ke as component};
