import{s as Xe,n as Ee,o as Le}from"../chunks/scheduler.9cda857a.js";import{S as ze,i as Fe,e as i,s as a,c as o,h as Qe,a as m,d as l,b as n,f as He,g as p,j as h,k as We,l as Ye,m as s,n as r,t as c,o as d,p as M}from"../chunks/index.f47f3121.js";import{C as Ne}from"../chunks/CopyLLMTxtMenu.676ed699.js";import{C as be}from"../chunks/CodeBlock.24d62f98.js";import{H as f,E as Ve}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.64d112fc.js";function Se($e){let g,V,Y,S,w,A,y,q,u,je='<a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow"><code>mlx-image</code></a> is an image models library developed by <a href="https://github.com/riccardomusmeci" rel="nofollow">Riccardo Musmeci</a> built on Apple <a href="https://github.com/ml-explore/mlx" rel="nofollow">MLX</a>. It tries to replicate the great <a href="https://github.com/huggingface/pytorch-image-models" rel="nofollow">timm</a>, but for MLX models.',P,T,D,J,Ue=`You can find <code>mlx-image</code> models by filtering using the <code>mlx-image</code> library name, like in <a href="https://huggingface.co/models?library=mlx-image&amp;sort=trending" rel="nofollow">this query</a>.
There’s also an open <a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision</a> community for contributors converting and publishing weights for MLX format.`,K,b,O,$,ee,j,te,U,Ie='Model weights are available on the <a href="https://huggingface.co/mlx-vision" rel="nofollow"><code>mlx-vision</code></a> community on HuggingFace.',le,I,xe="To load a model with pre-trained weights:",se,x,ae,C,Ce="To list all available models:",ne,Z,ie,v,oe,G,Ze='Go to <a href="https://github.com/riccardomusmeci/mlx-image/blob/main/results/results-imagenet-1k.csv" rel="nofollow">results-imagenet-1k.csv</a> to check every model converted to <code>mlx-image</code> and its performance on ImageNet-1K with different settings.',me,k,ve="<p><strong>TL;DR</strong> performance is comparable to the original models from PyTorch implementations.</p>",pe,_,re,R,Ge="<code>mlx-image</code> tries to be as close as possible to PyTorch:",ce,B,ke="<li><p><code>DataLoader</code> -&gt; you can define your own <code>collate_fn</code> and also use <code>num_workers</code> to speed up data loading</p></li> <li><p><code>Dataset</code> -&gt; <code>mlx-image</code> already supports <code>LabelFolderDataset</code> (the good and old PyTorch <code>ImageFolder</code>) and <code>FolderDataset</code> (a generic folder with images in it)</p></li> <li><p><code>ModelCheckpoint</code> -&gt; keeps track of the best model and saves it to disk (similar to PyTorchLightning). It also suggests early stopping</p></li>",de,H,Me,W,_e="Training is similar to PyTorch. Here’s an example of how to train a model:",he,X,ge,E,fe,L,Re='<li><a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow">mlx-image repository</a></li> <li><a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision community</a></li>',we,z,ye,F,Be="If you have any questions, please email <code>riccardomusmeci92@gmail.com</code>.",ue,Q,Te,N,Je;return w=new Ne({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new f({props:{title:"Using mlx-image at Hugging Face",local:"using-mlx-image-at-hugging-face",headingTag:"h1"}}),T=new f({props:{title:"Exploring mlx-image on the Hub",local:"exploring-mlx-image-on-the-hub",headingTag:"h2"}}),b=new f({props:{title:"Installation",local:"installation",headingTag:"h2"}}),$=new be({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC1pbWFnZQ==",highlighted:"pip install mlx-image",wrap:!1}}),j=new f({props:{title:"Models",local:"models",headingTag:"h2"}}),x=new be({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwY3JlYXRlX21vZGVsJTBBJTBBJTIzJTIwbG9hZGluZyUyMHdlaWdodHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMjAoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRm1seC12aXNpb24lMkZyZXNuZXQxOC1tbHhpbSklMEFtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQxOCUyMiklMjAlMjMlMjBwcmV0cmFpbmVkJTIwd2VpZ2h0cyUyMGxvYWRlZCUyMGZyb20lMjBIRiUwQSUwQSUyMyUyMGxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyJTJDJTIwd2VpZ2h0cyUzRCUyMnBhdGglMkZ0byUyRnJlc25ldDE4JTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model

<span class="hljs-comment"># loading weights from HuggingFace (https://huggingface.co/mlx-vision/resnet18-mlxim)</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>

<span class="hljs-comment"># loading weights from local file</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>, weights=<span class="hljs-string">&quot;path/to/resnet18/model.safetensors&quot;</span>)`,wrap:!1}}),Z=new be({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEFsaXN0X21vZGVscygp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> list_models
list_models()`,wrap:!1}}),v=new f({props:{title:"ImageNet-1K Results",local:"imagenet-1k-results",headingTag:"h2"}}),_=new f({props:{title:"Similarity to PyTorch and other familiar tools",local:"similarity-to-pytorch-and-other-familiar-tools",headingTag:"h2"}}),H=new f({props:{title:"Training",local:"training",headingTag:"h2"}}),X=new be({props:{code:"aW1wb3J0JTIwbWx4Lm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMG1seC5vcHRpbWl6ZXJzJTIwYXMlMjBvcHRpbSUwQWZyb20lMjBtbHhpbS5tb2RlbCUyMGltcG9ydCUyMGNyZWF0ZV9tb2RlbCUwQWZyb20lMjBtbHhpbS5kYXRhJTIwaW1wb3J0JTIwTGFiZWxGb2xkZXJEYXRhc2V0JTJDJTIwRGF0YUxvYWRlciUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBMYWJlbEZvbGRlckRhdGFzZXQoJTBBJTIwJTIwJTIwJTIwcm9vdF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX21hcCUzRCU3QjAlM0ElMjAlMjJjbGFzc18wJTIyJTJDJTIwMSUzQSUyMCUyMmNsYXNzXzElMjIlMkMlMjAyJTNBJTIwJTVCJTIyY2xhc3NfMiUyMiUyQyUyMCUyMmNsYXNzXzMlMjIlNUQlN0QlMEEpJTBBdHJhaW5fbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dvcmtlcnMlM0Q0JTBBKSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyKSUyMCUyMyUyMHByZXRyYWluZWQlMjB3ZWlnaHRzJTIwbG9hZGVkJTIwZnJvbSUyMEhGJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShsZWFybmluZ19yYXRlJTNEMWUtMyklMEElMEFkZWYlMjB0cmFpbl9zdGVwKG1vZGVsJTJDJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG14Lm1lYW4obm4ubG9zc2VzLmNyb3NzX2VudHJvcHkobG9naXRzJTJDJTIwdGFyZ2V0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb3NzJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgxMCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5fbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyQyUyMHRhcmdldCUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fc3RlcF9mbiUyMCUzRCUyMG5uLnZhbHVlX2FuZF9ncmFkKG1vZGVsJTJDJTIwdHJhaW5fc3RlcCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTJDJTIwZ3JhZHMlMjAlM0QlMjB0cmFpbl9zdGVwX2ZuKHglMkMlMjB0YXJnZXQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnVwZGF0ZShtb2RlbCUyQyUyMGdyYWRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG14LmV2YWwobW9kZWwuc3RhdGUlMkMlMjBvcHRpbWl6ZXIuc3RhdGUp",highlighted:`<span class="hljs-keyword">import</span> mlx.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> mlx.optimizers <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model
<span class="hljs-keyword">from</span> mlxim.data <span class="hljs-keyword">import</span> LabelFolderDataset, DataLoader

train_dataset = LabelFolderDataset(
    root_dir=<span class="hljs-string">&quot;path/to/train&quot;</span>,
    class_map={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;class_0&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;class_1&quot;</span>, <span class="hljs-number">2</span>: [<span class="hljs-string">&quot;class_2&quot;</span>, <span class="hljs-string">&quot;class_3&quot;</span>]}
)
train_loader = DataLoader(
    dataset=train_dataset,
    batch_size=<span class="hljs-number">32</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>
optimizer = optim.Adam(learning_rate=<span class="hljs-number">1e-3</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_step</span>(<span class="hljs-params">model, inputs, targets</span>):
    logits = model(inputs)
    loss = mx.mean(nn.losses.cross_entropy(logits, target))
    <span class="hljs-keyword">return</span> loss

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_loader:
        x, target = batch
        train_step_fn = nn.value_and_grad(model, train_step)
        loss, grads = train_step_fn(x, target)
        optimizer.update(model, grads)
        mx.<span class="hljs-built_in">eval</span>(model.state, optimizer.state)`,wrap:!1}}),E=new f({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),z=new f({props:{title:"Contact",local:"contact",headingTag:"h2"}}),Q=new Ve({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/mlx-image.md"}}),{c(){g=i("meta"),V=a(),Y=i("p"),S=a(),o(w.$$.fragment),A=a(),o(y.$$.fragment),q=a(),u=i("p"),u.innerHTML=je,P=a(),o(T.$$.fragment),D=a(),J=i("p"),J.innerHTML=Ue,K=a(),o(b.$$.fragment),O=a(),o($.$$.fragment),ee=a(),o(j.$$.fragment),te=a(),U=i("p"),U.innerHTML=Ie,le=a(),I=i("p"),I.textContent=xe,se=a(),o(x.$$.fragment),ae=a(),C=i("p"),C.textContent=Ce,ne=a(),o(Z.$$.fragment),ie=a(),o(v.$$.fragment),oe=a(),G=i("p"),G.innerHTML=Ze,me=a(),k=i("blockquote"),k.innerHTML=ve,pe=a(),o(_.$$.fragment),re=a(),R=i("p"),R.innerHTML=Ge,ce=a(),B=i("ul"),B.innerHTML=ke,de=a(),o(H.$$.fragment),Me=a(),W=i("p"),W.textContent=_e,he=a(),o(X.$$.fragment),ge=a(),o(E.$$.fragment),fe=a(),L=i("ul"),L.innerHTML=Re,we=a(),o(z.$$.fragment),ye=a(),F=i("p"),F.innerHTML=Be,ue=a(),o(Q.$$.fragment),Te=a(),N=i("p"),this.h()},l(e){const t=Qe("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(l),V=n(e),Y=m(e,"P",{}),He(Y).forEach(l),S=n(e),p(w.$$.fragment,e),A=n(e),p(y.$$.fragment,e),q=n(e),u=m(e,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1c0kah6"&&(u.innerHTML=je),P=n(e),p(T.$$.fragment,e),D=n(e),J=m(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-15ir2pb"&&(J.innerHTML=Ue),K=n(e),p(b.$$.fragment,e),O=n(e),p($.$$.fragment,e),ee=n(e),p(j.$$.fragment,e),te=n(e),U=m(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-13m84xx"&&(U.innerHTML=Ie),le=n(e),I=m(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-rlp6qh"&&(I.textContent=xe),se=n(e),p(x.$$.fragment,e),ae=n(e),C=m(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-1xjx8g7"&&(C.textContent=Ce),ne=n(e),p(Z.$$.fragment,e),ie=n(e),p(v.$$.fragment,e),oe=n(e),G=m(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-kcleo1"&&(G.innerHTML=Ze),me=n(e),k=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),h(k)!=="svelte-1xz4blu"&&(k.innerHTML=ve),pe=n(e),p(_.$$.fragment,e),re=n(e),R=m(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-11sjtis"&&(R.innerHTML=Ge),ce=n(e),B=m(e,"UL",{"data-svelte-h":!0}),h(B)!=="svelte-jcjia8"&&(B.innerHTML=ke),de=n(e),p(H.$$.fragment,e),Me=n(e),W=m(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1cvxtzq"&&(W.textContent=_e),he=n(e),p(X.$$.fragment,e),ge=n(e),p(E.$$.fragment,e),fe=n(e),L=m(e,"UL",{"data-svelte-h":!0}),h(L)!=="svelte-k2vhlo"&&(L.innerHTML=Re),we=n(e),p(z.$$.fragment,e),ye=n(e),F=m(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-12c9hfs"&&(F.innerHTML=Be),ue=n(e),p(Q.$$.fragment,e),Te=n(e),N=m(e,"P",{}),He(N).forEach(l),this.h()},h(){We(g,"name","hf:doc:metadata"),We(g,"content",Ae)},m(e,t){Ye(document.head,g),s(e,V,t),s(e,Y,t),s(e,S,t),r(w,e,t),s(e,A,t),r(y,e,t),s(e,q,t),s(e,u,t),s(e,P,t),r(T,e,t),s(e,D,t),s(e,J,t),s(e,K,t),r(b,e,t),s(e,O,t),r($,e,t),s(e,ee,t),r(j,e,t),s(e,te,t),s(e,U,t),s(e,le,t),s(e,I,t),s(e,se,t),r(x,e,t),s(e,ae,t),s(e,C,t),s(e,ne,t),r(Z,e,t),s(e,ie,t),r(v,e,t),s(e,oe,t),s(e,G,t),s(e,me,t),s(e,k,t),s(e,pe,t),r(_,e,t),s(e,re,t),s(e,R,t),s(e,ce,t),s(e,B,t),s(e,de,t),r(H,e,t),s(e,Me,t),s(e,W,t),s(e,he,t),r(X,e,t),s(e,ge,t),r(E,e,t),s(e,fe,t),s(e,L,t),s(e,we,t),r(z,e,t),s(e,ye,t),s(e,F,t),s(e,ue,t),r(Q,e,t),s(e,Te,t),s(e,N,t),Je=!0},p:Ee,i(e){Je||(c(w.$$.fragment,e),c(y.$$.fragment,e),c(T.$$.fragment,e),c(b.$$.fragment,e),c($.$$.fragment,e),c(j.$$.fragment,e),c(x.$$.fragment,e),c(Z.$$.fragment,e),c(v.$$.fragment,e),c(_.$$.fragment,e),c(H.$$.fragment,e),c(X.$$.fragment,e),c(E.$$.fragment,e),c(z.$$.fragment,e),c(Q.$$.fragment,e),Je=!0)},o(e){d(w.$$.fragment,e),d(y.$$.fragment,e),d(T.$$.fragment,e),d(b.$$.fragment,e),d($.$$.fragment,e),d(j.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(_.$$.fragment,e),d(H.$$.fragment,e),d(X.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),Je=!1},d(e){e&&(l(V),l(Y),l(S),l(A),l(q),l(u),l(P),l(D),l(J),l(K),l(O),l(ee),l(te),l(U),l(le),l(I),l(se),l(ae),l(C),l(ne),l(ie),l(oe),l(G),l(me),l(k),l(pe),l(re),l(R),l(ce),l(B),l(de),l(Me),l(W),l(he),l(ge),l(fe),l(L),l(we),l(ye),l(F),l(ue),l(Te),l(N)),l(g),M(w,e),M(y,e),M(T,e),M(b,e),M($,e),M(j,e),M(x,e),M(Z,e),M(v,e),M(_,e),M(H,e),M(X,e),M(E,e),M(z,e),M(Q,e)}}}const Ae='{"title":"Using mlx-image at Hugging Face","local":"using-mlx-image-at-hugging-face","sections":[{"title":"Exploring mlx-image on the Hub","local":"exploring-mlx-image-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"ImageNet-1K Results","local":"imagenet-1k-results","sections":[],"depth":2},{"title":"Similarity to PyTorch and other familiar tools","local":"similarity-to-pytorch-and-other-familiar-tools","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2},{"title":"Contact","local":"contact","sections":[],"depth":2}],"depth":1}';function qe($e){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends ze{constructor(g){super(),Fe(this,g,qe,Se,Xe,{})}}export{tt as component};
