# Academia Hub

> [!TIP]
> Ask your university's IT or Procurement Team to <a href="https://huggingface.co/contact/sales?from=academia" target="_blank">get in touch</a> from a university-affiliated email address to initiate the subscription process.

Academia Hub is a paid offering that provides the Hugging Face Hub’s PRO features to every student, researcher, or faculty member of an academic institution. Explore advanced tools, enhanced collaboration, and exclusive resources to accelerate your learning, research, and teaching. The Hugging Face team is able to work with your IT or procurement department to set the product up.

<a href="https://huggingface.co/contact/sales?from=academia" class="flex justify-center">
    <img class="block" src="https://huggingface.co/datasets/Chunte/documentation-images/resolve/main/AcademiaHub.png" />
</a>

#### How does it work

When Academia Hub is enabled, any affiliated user will need to add their `@your-university-name.edu` email address (or other university domain) to their HF account.

Academia Hub is designed for:
- **Students:** Unlock powerful features to learn about AI and Machine learning in the most efficient way.
- **Researchers:** Collaborate with peers using the standard AI ecosystem of tools.
- **Faculty members:** Enhance your classes' projects with PRO capabilities.

Key Features of Academia Hub:

- **ZeroGPU:** Get 5x usage quota and highest GPU queue priority.
- **Spaces Hosting:** Create ZeroGPU Spaces with H200 hardware.
- **Spaces Dev Mode:** Fast iterations via SSH/VS Code for Spaces.
- **Inference Providers:** Get monthly included credits across all Inference Providers.
- **Dataset Viewer:** Activate it on private datasets.
- **Blog Articles:** Publish articles to the Hugging Face blog.
- **Social Posts:** Share short updates with the community.
- **Seamless Onboarding:** Quick and secure sign-up with your academic email.
- **Enhanced Collaboration:** Connect with peers and mentors.
- **Exclusive Resources:** Access datasets, models, and projects tailored for academia.

#### Eligibility

- Must possess a valid university or college email address.
- Open to all students regardless of discipline or level of study.
- Pricing: Academia Hub is priced based on volume of usage and number of active users at your institution.

#### Subscribe

Ask your university's IT or Procurement Team to <a href="https://huggingface.co/contact/sales?from=academia" target="_blank">get in touch</a> to initiate the subscription process to the Academia Hub today. Academia Hub can not be initiated by students themselves. 

#### Repository Storage

Academia Hub includes more [included public storage](./storage-limits) as well as 1TB of [private repository storage](./storage-limits) per seat in the subscription, i.e. if your institution has 400 students and faculty, your students and faculty have 400TB included storage across their private models and datasets.


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/academia-hub.md" />