# Licenses

You are able to add a license to any repo that you create on the Hugging Face Hub to let other users know about the permissions that you want to attribute to your code or data. The license can be specified in your repository's `README.md` file, known as a _card_ on the Hub, in the card's metadata section. Remember to seek out and respect a project's license if you're considering using their code or data.

A full list of the available licenses is available here:

<!-- IMPORTANT: do not remove or alter the "region" comments below -->

<!-- region licenses -->

| Fullname                                                       | License identifier (to use in repo card) |
| -------------------------------------------------------------- | ---------------------------------------- |
| Apache license 2.0                                             | `apache-2.0`                             |
| MIT                                                            | `mit`                                    |
| OpenRAIL license family                                        | `openrail`                               | <!-- info: https://huggingface.co/blog/open_rail -->
| BigScience OpenRAIL-M                                          | `bigscience-openrail-m`                  | <!-- info: https://bigscience.huggingface.co/blog/bigscience-openrail-m -->
| CreativeML OpenRAIL-M                                          | `creativeml-openrail-m`                  | <!-- info: https://huggingface.co/spaces/CompVis/stable-diffusion-license -->
| BigScience BLOOM RAIL 1.0                                      | `bigscience-bloom-rail-1.0`              | <!-- info: https://bigscience.huggingface.co/blog/the-bigscience-rail-license license: https://huggingface.co/spaces/bigscience/license -->
| BigCode Open RAIL-M v1                                         | `bigcode-openrail-m`                     | <!-- info: https://www.bigcode-project.org/docs/pages/bigcode-openrail -->
| Academic Free License v3.0                                     | `afl-3.0`                                |
| Artistic license 2.0                                           | `artistic-2.0`                           |
| Boost Software License 1.0                                     | `bsl-1.0`                                |
| BSD license family                                             | `bsd`                                    |
| BSD 2-clause "Simplified" license                              | `bsd-2-clause`                           |
| BSD 3-clause "New" or "Revised" license                        | `bsd-3-clause`                           |
| BSD 3-clause Clear license                                     | `bsd-3-clause-clear`                     |
| Computational Use of Data Agreement                            | `c-uda`                                  |
| Creative Commons license family                                | `cc`                                     |
| Creative Commons Zero v1.0 Universal                           | `cc0-1.0`                                |
| Creative Commons Attribution 2.0                               | `cc-by-2.0`                              |
| Creative Commons Attribution 2.5                               | `cc-by-2.5`                              |
| Creative Commons Attribution 3.0                               | `cc-by-3.0`                              |
| Creative Commons Attribution 4.0                               | `cc-by-4.0`                              |
| Creative Commons Attribution Share Alike 3.0                   | `cc-by-sa-3.0`                           |
| Creative Commons Attribution Share Alike 4.0                   | `cc-by-sa-4.0`                           |
| Creative Commons Attribution Non Commercial 2.0                | `cc-by-nc-2.0`                           |
| Creative Commons Attribution Non Commercial 3.0                | `cc-by-nc-3.0`                           |
| Creative Commons Attribution Non Commercial 4.0                | `cc-by-nc-4.0`                           |
| Creative Commons Attribution No Derivatives 4.0                | `cc-by-nd-4.0`                           |
| Creative Commons Attribution Non Commercial No Derivatives 3.0 | `cc-by-nc-nd-3.0`                        |
| Creative Commons Attribution Non Commercial No Derivatives 4.0 | `cc-by-nc-nd-4.0`                        |
| Creative Commons Attribution Non Commercial Share Alike 2.0    | `cc-by-nc-sa-2.0`                        |
| Creative Commons Attribution Non Commercial Share Alike 3.0    | `cc-by-nc-sa-3.0`                        |
| Creative Commons Attribution Non Commercial Share Alike 4.0    | `cc-by-nc-sa-4.0`                        |
| Community Data License Agreement – Sharing, Version 1.0        | `cdla-sharing-1.0`                       |
| Community Data License Agreement – Permissive, Version 1.0     | `cdla-permissive-1.0`                    |
| Community Data License Agreement – Permissive, Version 2.0     | `cdla-permissive-2.0`                    |
| Do What The F\*ck You Want To Public License                   | `wtfpl`                                  |
| Educational Community License v2.0                             | `ecl-2.0`                                |
| Eclipse Public License 1.0                                     | `epl-1.0`                                |
| Eclipse Public License 2.0                                     | `epl-2.0`                                |
| Etalab Open License 2.0                                        | `etalab-2.0`                             |
| European Union Public License 1.1                              | `eupl-1.1`                               |
| European Union Public License 1.2                              | `eupl-1.2`                               |
| GNU Affero General Public License v3.0                         | `agpl-3.0`                               |
| GNU Free Documentation License family                          | `gfdl`                                   |
| GNU General Public License family                              | `gpl`                                    |
| GNU General Public License v2.0                                | `gpl-2.0`                                |
| GNU General Public License v3.0                                | `gpl-3.0`                                |
| GNU Lesser General Public License family                       | `lgpl`                                   |
| GNU Lesser General Public License v2.1                         | `lgpl-2.1`                               |
| GNU Lesser General Public License v3.0                         | `lgpl-3.0`                               |
| ISC                                                            | `isc`                                    |
| H Research License                                             | `h-research`                             | <!-- license: https://huggingface.co/Hcompany/Holo1-3B/blob/main/LICENSE -->
| Intel Research Use License Agreement                           | `intel-research`                         | <!-- license: https://huggingface.co/OpenVINO/Llama-3.1-8B-Instruct-FastDraft-150M-int8-ov/blob/main/LICENSE.md -->
| LaTeX Project Public License v1.3c                             | `lppl-1.3c`                              |
| Microsoft Public License                                       | `ms-pl`                                  |
| Apple Sample Code license                                      | `apple-ascl`                             | <!-- license: https://developer.apple.com/support/downloads/terms/apple-sample-code/Apple-Sample-Code-License.pdf -->
| Apple Model License for Research                               | `apple-amlr`                             | <!-- license: https://huggingface.co/apple/deeplabv3-mobilevit-small/blob/main/LICENSE -->
| Mozilla Public License 2.0                                     | `mpl-2.0`                                |
| Open Data Commons License Attribution family                   | `odc-by`                                 |
| Open Database License family                                   | `odbl`                                   |
| Open Model, Data & Weights License Agreement                   | `openmdw-1.0`                            | <!-- license: https://openmdw.ai/license -->
| Open Rail++-M License                                          | `openrail++`                             | <!-- license: https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/LICENSE.md -->
| Open Software License 3.0                                      | `osl-3.0`                                |
| PostgreSQL License                                             | `postgresql`                             |
| SIL Open Font License 1.1                                      | `ofl-1.1`                                |
| University of Illinois/NCSA Open Source License                | `ncsa`                                   |
| The Unlicense                                                  | `unlicense`                              |
| zLib License                                                   | `zlib`                                   |
| Open Data Commons Public Domain Dedication and License         | `pddl`                                   |
| Lesser General Public License For Linguistic Resources         | `lgpl-lr`                                |
| DeepFloyd IF Research License Agreement                        | `deepfloyd-if-license`                   |
| FAIR Noncommercial Research License                            | `fair-noncommercial-research-license`    | <!-- license: https://huggingface.co/facebook/fair-noncommercial-research-license/blob/main/LICENSE -->
| Llama 2 Community License Agreement                            | `llama2`                                 | <!-- license: https://huggingface.co/meta-llama/Llama-2-7b-chat-hf/blob/main/LICENSE.txt -->
| Llama 3 Community License Agreement                            | `llama3`                                 | <!-- license: https://huggingface.co/meta-llama/Meta-Llama-3-8B/blob/main/LICENSE -->
| Llama 3.1 Community License Agreement                          | `llama3.1`                               | <!-- license: https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct/blob/main/LICENSE -->
| Llama 3.2 Community License Agreement                          | `llama3.2`                               | <!-- license: https://huggingface.co/meta-llama/Llama-3.2-1B/blob/main/LICENSE.txt -->
| Llama 3.3 Community License Agreement                          | `llama3.3`                               | <!-- license: https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct/blob/main/LICENSE -->
| Llama 4 Community License Agreement                            | `llama4`                                 | <!-- license: https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E-Instruct/blob/main/LICENSE -->
| Grok 2 Community License Agreement                             | `grok2-community`                        | <!-- license: https://huggingface.co/xai-org/grok-2/blob/main/LICENSE -->
| Gemma Terms of Use                                             | `gemma`                                  | <!-- license: https://ai.google.dev/gemma/terms -->
| Unknown                                                        | `unknown`                                |
| Other                                                          | `other`                                  |

<!-- endregion -->

In case of `license: other` please add the license's text to a `LICENSE` file inside your repo (or contact us to add the license you use to this list), and set a name for it in `license_name`.


<EditOnGithub source="https://github.com/huggingface/hub-docs/blob/main/docs/hub/repositories-licenses.md" />