import{s as qt,n as At,o as $t}from"../chunks/scheduler.56725da7.js";import{S as Vt,i as Ht,e as o,s as n,c as r,h as Ft,a as i,d as l,b as a,f as Gt,g as c,j as p,k as kt,l as Qt,m as s,n as M,t as u,o as m,p as d}from"../chunks/index.18a26576.js";import{C as Lt}from"../chunks/CopyLLMTxtMenu.f644b58a.js";import{C as y}from"../chunks/CodeBlock.a5342303.js";import{H as ce}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.401933eb.js";function Rt(at){let h,Me,pe,ue,T,me,U,de,f,ot='In this tutorial you will learn how to deploy <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">/meta-llama/Llama-3.3-70B-Instruct</a> model on AWS Inferentia2 with Hugging Face Optimum on Amazon SageMaker. We are going to use the Hugging Face TGI Neuron Container, a purpose-built Inference Container to easily deploy LLMs on AWS Inferentia2 powered by<a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference</a> and <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>.',he,j,it="We will cover how to:",ye,w,pt='<li><a href="#1-setup-development-environment">Setup development environment</a></li> <li><a href="#2-retrieve-the-new-hugging-face-tgi-neuron-dlc">Retrieve the new Hugging Face TGI Neuron DLC</a></li> <li><a href="#3-deploy-llama-33-70b-to-inferentia2">Deploy Llama 3.3 70B to inferentia2</a></li> <li><a href="#4-clean-up">Clean up</a></li>',Te,J,rt="Lets get started! 🚀",Ue,g,ct='<a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">AWS inferentia (Inf2)</a> are purpose-built EC2 for deep learning (DL) inference workloads. Here are the different instances of the Inferentia2 family.',fe,b,Mt="<thead><tr><th>instance size</th> <th>accelerators</th> <th>Neuron Cores</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>on-demand price ($/h)</th></tr></thead> <tbody><tr><td>inf2.xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>4</td> <td>16</td> <td>0.76</td></tr> <tr><td>inf2.8xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>32</td> <td>128</td> <td>1.97</td></tr> <tr><td>inf2.24xlarge</td> <td>6</td> <td>12</td> <td>192</td> <td>96</td> <td>384</td> <td>6.49</td></tr> <tr><td>inf2.48xlarge</td> <td>12</td> <td>24</td> <td>384</td> <td>192</td> <td>768</td> <td>12.98</td></tr></tbody>",je,I,we,C,ut="For this tutorial, we are going to use a Notebook Instance in Amazon SageMaker with the Python 3 (ipykernel) and the <code>sagemaker</code> python SDK to deploy Llama 3.3 70B to a SageMaker inference endpoint.",Je,B,mt="Make sur you have the latest version of the SageMaker SDK installed.",ge,W,be,N,dt="Then, instantiate the sagemaker role and session.",Ie,Z,Ce,E,Be,v,ht="The latest Hugging Face TGI Neuron DLCs can be used to run inference on AWS Inferentia2. You can use the <code>ecr.image_uri</code> function from Optimum Neuron to retrieve the appropriate Hugging Face TGI Neuron DLC URI based on your desired <code>region</code> and <code>version</code>. Default values can be deduced by your AWS credentials.",We,_,Ne,S,Ze,x,yt=`At the time of writing, <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/v2.6.0/general/arch/neuron-features/dynamic-shapes.html#neuron-dynamic-shapes" rel="nofollow">AWS Inferentia2 does not support dynamic shapes for inference</a>, which means that we need to specify our sequence length and batch size ahead of time.
To make it easier for customers to utilize the full power of Inferentia2, we created a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">neuron model cache</a>, which contains pre-compiled configurations for the most popular LLMs, including Llama 3.3 70B.`,Ee,G,Tt='This means we don’t need to compile the model ourselves, but we can use the pre-compiled model from the cache. You can find compiled/cached configurations on the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/tree/main/inference-cache-config" rel="nofollow">Hugging Face Hub</a>. If your desired configuration is not yet cached, you can compile it yourself using the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">Optimum CLI</a> or open a request at the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/discussions" rel="nofollow">Cache repository</a>.',ve,k,Ut="<strong>Deploying Llama 3.3 70B to a SageMaker Endpoint</strong>",_e,q,ft="Before deploying the model to Amazon SageMaker, we must define the TGI Neuron endpoint configuration. We need to make sure the following additional parameters are defined:",Se,A,jt="<li><code>HF_NUM_CORES</code>: Number of Neuron Cores used for the compilation.</li> <li><code>HF_BATCH_SIZE</code>: The batch size that was used to compile the model.</li> <li><code>HF_SEQUENCE_LENGTH</code>: The sequence length that was used to compile the model.</li> <li><code>HF_AUTO_CAST_TYPE</code>: The auto cast type that was used to compile the model.</li>",xe,$,wt="We still need to define traditional TGI parameters with:",Ge,V,Jt="<li><code>HF_MODEL_ID</code>: The Hugging Face model ID.</li> <li><code>HF_TOKEN</code>: The Hugging Face API token to access gated models.</li> <li><code>MAX_BATCH_SIZE</code>: The maximum batch size that the model can handle, equal to the batch size used for compilation.</li> <li><code>MAX_INPUT_TOKEN</code>: The maximum input length that the model can handle.</li> <li><code>MAX_TOTAL_TOKENS</code>: The maximum total tokens the model can generate, equal to the sequence length used for compilation.</li>",ke,H,gt="Optionnaly, you can configure the endpoint to support chat templates:",qe,F,bt="<li><code>MESSAGES_API_ENABLED</code>: Enable Messages API</li>",Ae,Q,It="<strong>Select the right instance type</strong>",$e,L,Ct='Llama 3.3 70B is a large model and requires a lot of memory. We are going to use the <code>inf2.48xlarge</code> instance type, which has 192 vCPUs and 384 GB of accelerator memory. The <code>inf2.48xlarge</code> instance comes with 12 Inferentia2 accelerators that include 24 Neuron Cores. If you want to find the cached configurations for Llama 3.3 70B, you can find them <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/blob/main/inference-cache-config/llama3-70b.json#L16" rel="nofollow">here</a>. In our case we will use a batch size of 4 and a sequence length of 4096.',Ve,R,Bt='Before we can deploy Llama 3.3 70B to Inferentia2, we need to make sure we have the necessary permissions to access the model. You can request access to the model <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">here</a> and create a User access token following this <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">guide</a>.',He,X,Wt="After that we can create our endpoint configuration and deploy the model to Amazon SageMaker. We will deploy the endpoint with the Messages API enabled, so that it is fully compatible with the OpenAI Chat Completion API.",Fe,z,Qe,Y,Nt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.inf2.48xlarge</code> instance type. TGI will automatically distribute and shard the model across all Inferentia devices.",Le,P,Re,D,Zt="SageMaker will now create our endpoint and deploy the model to it. It takes around 30 minutes for deployment.",Xe,O,Et="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",ze,K,vt="The endpoint supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. The Messages API allows us to interact with the model in a conversational way. We can define the role of the message and the content. The role can be either <code>system</code>,<code>assistant</code> or <code>user</code>. The <code>system</code> role is used to provide context to the model and the <code>user</code> role is used to ask questions or provide input to the model.",Ye,ee,_t='Parameters can be defined as in the <code>parameters</code> attribute of the payload. Check out the chat completion <a href="https://platform.openai.com/docs/api-reference/chat/create" rel="nofollow">documentation</a> to find supported parameters.',Pe,te,De,le,Oe,se,St="Okay lets test it.",Ke,ne,et,ae,tt,oe,xt="To clean up, we can delete the model and endpoint.",lt,ie,st,re,nt;return T=new Lt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new ce({props:{title:"Deploy Llama 3.3 70B on AWS Inferentia2",local:"deploy-llama-33-70b-on-aws-inferentia2",headingTag:"h1"}}),I=new ce({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),W=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),Z=new y({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBzZXNzaW9uJTIwcmVnaW9uJTNBJTIwJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),E=new ce({props:{title:"2. Retrieve the latest Hugging Face TGI Neuron DLC",local:"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc",headingTag:"h2"}}),_=new y({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uLnV0aWxzJTIwaW1wb3J0JTIwZWNyJTBBJTBBbGxtX2ltYWdlJTIwJTNEJTIwZWNyLmltYWdlX3VyaSglMjJ0Z2klMjIpJTBBJTIzJTIwcHJpbnQlMjBpbWFnZSUyMHVyaSUwQXByaW50KGYlMjJsbG0lMjBpbWFnZSUyMHVyaSUzQSUyMCU3QmxsbV9pbWFnZSU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron.utils <span class="hljs-keyword">import</span> ecr

llm_image = ecr.image_uri(<span class="hljs-string">&quot;tgi&quot;</span>)
<span class="hljs-comment"># print image uri</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;llm image uri: <span class="hljs-subst">{llm_image}</span>&quot;</span>)`,wrap:!1}}),S=new ce({props:{title:"3. Deploy Llama 3.3 70B to Inferentia2",local:"3-deploy-llama-33-70b-to-inferentia2",headingTag:"h2"}}),z=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.inf2.48xlarge&quot;</span>
health_check_timeout = <span class="hljs-number">3600</span>  <span class="hljs-comment"># additional time to load the model</span>
volume_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># size in GB of the EBS volume</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
    <span class="hljs-string">&quot;HF_NUM_CORES&quot;</span>: <span class="hljs-string">&quot;24&quot;</span>,  <span class="hljs-comment"># number of neuron cores</span>
    <span class="hljs-string">&quot;HF_AUTO_CAST_TYPE&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>,  <span class="hljs-comment"># dtype of the model</span>
    <span class="hljs-string">&quot;MAX_BATCH_SIZE&quot;</span>: <span class="hljs-string">&quot;4&quot;</span>,  <span class="hljs-comment"># max batch size for the model</span>
    <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;4000&quot;</span>,  <span class="hljs-comment"># max length of input text</span>
    <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,  <span class="hljs-comment"># max length of generated text</span>
    <span class="hljs-string">&quot;MESSAGES_API_ENABLED&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Enable the messages API</span>
    <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>,
}

<span class="hljs-keyword">assert</span> config[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] != <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>, (
    <span class="hljs-string">&quot;Please replace &#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27; with your Hugging Face Hub API token&quot;</span>
)


<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
llm_model = HuggingFaceModel(role=role, image_uri=llm_image, env=config)`,wrap:!1}}),P=new y({props:{code:"JTIzJTIwZGVhY3RpdmF0ZSUyMHdhcm5pbmclMjBzaW5jZSUyMG1vZGVsJTIwaXMlMjBjb21waWxlZCUwQWxsbV9tb2RlbC5faXNfY29tcGlsZWRfbW9kZWwlMjAlM0QlMjBUcnVlJTBBJTBBbGxtJTIwJTNEJTIwbGxtX21vZGVsLmRlcGxveSglMEElMjAlMjAlMjAlMjBpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0RpbnN0YW5jZV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwY29udGFpbmVyX3N0YXJ0dXBfaGVhbHRoX2NoZWNrX3RpbWVvdXQlM0RoZWFsdGhfY2hlY2tfdGltZW91dCUyQyUwQSUyMCUyMCUyMCUyMHZvbHVtZV9zaXplJTNEdm9sdW1lX3NpemUlMkMlMEEp",highlighted:`<span class="hljs-comment"># deactivate warning since model is compiled</span>
llm_model._is_compiled_model = <span class="hljs-literal">True</span>

llm = llm_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
    container_startup_health_check_timeout=health_check_timeout,
    volume_size=volume_size,
)`,wrap:!1}}),te=new y({props:{code:"JTdCJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is deep learning?&quot;</span> <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),le=new y({props:{code:"JTIzJTIwUHJvbXB0JTIwdG8lMjBnZW5lcmF0ZSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclMjBpbiUyMG9uZSUyMHNlbnRlbmNlJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3VtZW50cyUyMGh0dHBzJTNBJTJGJTJGcGxhdGZvcm0ub3BlbmFpLmNvbSUyRmRvY3MlMkZhcGktcmVmZXJlbmNlJTJGY2hhdCUyRmNyZWF0ZSUwQXBhcmFtZXRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMTAwJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt to generate</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning in one sentence?&quot;</span>},
]

<span class="hljs-comment"># Generation arguments https://platform.openai.com/docs/api-reference/chat/create</span>
parameters = {
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>,
}`,wrap:!1}}),ne=new y({props:{code:"Y2hhdCUyMCUzRCUyMGxsbS5wcmVkaWN0KCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAqKnBhcmFtZXRlcnMlMkMlMjAlMjJzdGVhbSUyMiUzQSUyMFRydWUlN0QpJTBBJTBBcHJpbnQoY2hhdCU1QiUyMmNob2ljZXMlMjIlNUQlNUIwJTVEJTVCJTIybWVzc2FnZSUyMiU1RCU1QiUyMmNvbnRlbnQlMjIlNUQuc3RyaXAoKSk=",highlighted:`chat = llm.predict({<span class="hljs-string">&quot;messages&quot;</span>: messages, **parameters, <span class="hljs-string">&quot;steam&quot;</span>: <span class="hljs-literal">True</span>})

<span class="hljs-built_in">print</span>(chat[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>].strip())`,wrap:!1}}),ae=new ce({props:{title:"4. Clean up",local:"4-clean-up",headingTag:"h2"}}),ie=new y({props:{code:"bGxtLmRlbGV0ZV9tb2RlbCgpJTBBbGxtLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`llm.delete_model()
llm.delete_endpoint()`,wrap:!1}}),{c(){h=o("meta"),Me=n(),pe=o("p"),ue=n(),r(T.$$.fragment),me=n(),r(U.$$.fragment),de=n(),f=o("p"),f.innerHTML=ot,he=n(),j=o("p"),j.textContent=it,ye=n(),w=o("ol"),w.innerHTML=pt,Te=n(),J=o("p"),J.textContent=rt,Ue=n(),g=o("p"),g.innerHTML=ct,fe=n(),b=o("table"),b.innerHTML=Mt,je=n(),r(I.$$.fragment),we=n(),C=o("p"),C.innerHTML=ut,Je=n(),B=o("p"),B.textContent=mt,ge=n(),r(W.$$.fragment),be=n(),N=o("p"),N.textContent=dt,Ie=n(),r(Z.$$.fragment),Ce=n(),r(E.$$.fragment),Be=n(),v=o("p"),v.innerHTML=ht,We=n(),r(_.$$.fragment),Ne=n(),r(S.$$.fragment),Ze=n(),x=o("p"),x.innerHTML=yt,Ee=n(),G=o("p"),G.innerHTML=Tt,ve=n(),k=o("p"),k.innerHTML=Ut,_e=n(),q=o("p"),q.textContent=ft,Se=n(),A=o("ul"),A.innerHTML=jt,xe=n(),$=o("p"),$.textContent=wt,Ge=n(),V=o("ul"),V.innerHTML=Jt,ke=n(),H=o("p"),H.textContent=gt,qe=n(),F=o("ul"),F.innerHTML=bt,Ae=n(),Q=o("p"),Q.innerHTML=It,$e=n(),L=o("p"),L.innerHTML=Ct,Ve=n(),R=o("p"),R.innerHTML=Bt,He=n(),X=o("p"),X.textContent=Wt,Fe=n(),r(z.$$.fragment),Qe=n(),Y=o("p"),Y.innerHTML=Nt,Le=n(),r(P.$$.fragment),Re=n(),D=o("p"),D.textContent=Zt,Xe=n(),O=o("p"),O.innerHTML=Et,ze=n(),K=o("p"),K.innerHTML=vt,Ye=n(),ee=o("p"),ee.innerHTML=_t,Pe=n(),r(te.$$.fragment),De=n(),r(le.$$.fragment),Oe=n(),se=o("p"),se.textContent=St,Ke=n(),r(ne.$$.fragment),et=n(),r(ae.$$.fragment),tt=n(),oe=o("p"),oe.textContent=xt,lt=n(),r(ie.$$.fragment),st=n(),re=o("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),Me=a(e),pe=i(e,"P",{}),Gt(pe).forEach(l),ue=a(e),c(T.$$.fragment,e),me=a(e),c(U.$$.fragment,e),de=a(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-18ykppc"&&(f.innerHTML=ot),he=a(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-df2280"&&(j.textContent=it),ye=a(e),w=i(e,"OL",{"data-svelte-h":!0}),p(w)!=="svelte-ouxi3x"&&(w.innerHTML=pt),Te=a(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-fedw35"&&(J.textContent=rt),Ue=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1q2zsrn"&&(g.innerHTML=ct),fe=a(e),b=i(e,"TABLE",{"data-svelte-h":!0}),p(b)!=="svelte-1tmwmqe"&&(b.innerHTML=Mt),je=a(e),c(I.$$.fragment,e),we=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1e6mm58"&&(C.innerHTML=ut),Je=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gxxxnf"&&(B.textContent=mt),ge=a(e),c(W.$$.fragment,e),be=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-k2b9z7"&&(N.textContent=dt),Ie=a(e),c(Z.$$.fragment,e),Ce=a(e),c(E.$$.fragment,e),Be=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-vw1yzd"&&(v.innerHTML=ht),We=a(e),c(_.$$.fragment,e),Ne=a(e),c(S.$$.fragment,e),Ze=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-w7lp5p"&&(x.innerHTML=yt),Ee=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1kijx5w"&&(G.innerHTML=Tt),ve=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-prnhqf"&&(k.innerHTML=Ut),_e=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1lo8mr8"&&(q.textContent=ft),Se=a(e),A=i(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-19xkqok"&&(A.innerHTML=jt),xe=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-7y1w5l"&&($.textContent=wt),Ge=a(e),V=i(e,"UL",{"data-svelte-h":!0}),p(V)!=="svelte-21hz0o"&&(V.innerHTML=Jt),ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ba46xn"&&(H.textContent=gt),qe=a(e),F=i(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-i1wt4y"&&(F.innerHTML=bt),Ae=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1qiwbk5"&&(Q.innerHTML=It),$e=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1px60yi"&&(L.innerHTML=Ct),Ve=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1mh0xpb"&&(R.innerHTML=Bt),He=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-dbarld"&&(X.textContent=Wt),Fe=a(e),c(z.$$.fragment,e),Qe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-eb49q4"&&(Y.innerHTML=Nt),Le=a(e),c(P.$$.fragment,e),Re=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-hs5wbn"&&(D.textContent=Zt),Xe=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1popn9h"&&(O.innerHTML=Et),ze=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-7vzs06"&&(K.innerHTML=vt),Ye=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-gr6587"&&(ee.innerHTML=_t),Pe=a(e),c(te.$$.fragment,e),De=a(e),c(le.$$.fragment,e),Oe=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1pq3qhh"&&(se.textContent=St),Ke=a(e),c(ne.$$.fragment,e),et=a(e),c(ae.$$.fragment,e),tt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-100mxno"&&(oe.textContent=xt),lt=a(e),c(ie.$$.fragment,e),st=a(e),re=i(e,"P",{}),Gt(re).forEach(l),this.h()},h(){kt(h,"name","hf:doc:metadata"),kt(h,"content",Xt)},m(e,t){Qt(document.head,h),s(e,Me,t),s(e,pe,t),s(e,ue,t),M(T,e,t),s(e,me,t),M(U,e,t),s(e,de,t),s(e,f,t),s(e,he,t),s(e,j,t),s(e,ye,t),s(e,w,t),s(e,Te,t),s(e,J,t),s(e,Ue,t),s(e,g,t),s(e,fe,t),s(e,b,t),s(e,je,t),M(I,e,t),s(e,we,t),s(e,C,t),s(e,Je,t),s(e,B,t),s(e,ge,t),M(W,e,t),s(e,be,t),s(e,N,t),s(e,Ie,t),M(Z,e,t),s(e,Ce,t),M(E,e,t),s(e,Be,t),s(e,v,t),s(e,We,t),M(_,e,t),s(e,Ne,t),M(S,e,t),s(e,Ze,t),s(e,x,t),s(e,Ee,t),s(e,G,t),s(e,ve,t),s(e,k,t),s(e,_e,t),s(e,q,t),s(e,Se,t),s(e,A,t),s(e,xe,t),s(e,$,t),s(e,Ge,t),s(e,V,t),s(e,ke,t),s(e,H,t),s(e,qe,t),s(e,F,t),s(e,Ae,t),s(e,Q,t),s(e,$e,t),s(e,L,t),s(e,Ve,t),s(e,R,t),s(e,He,t),s(e,X,t),s(e,Fe,t),M(z,e,t),s(e,Qe,t),s(e,Y,t),s(e,Le,t),M(P,e,t),s(e,Re,t),s(e,D,t),s(e,Xe,t),s(e,O,t),s(e,ze,t),s(e,K,t),s(e,Ye,t),s(e,ee,t),s(e,Pe,t),M(te,e,t),s(e,De,t),M(le,e,t),s(e,Oe,t),s(e,se,t),s(e,Ke,t),M(ne,e,t),s(e,et,t),M(ae,e,t),s(e,tt,t),s(e,oe,t),s(e,lt,t),M(ie,e,t),s(e,st,t),s(e,re,t),nt=!0},p:At,i(e){nt||(u(T.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(Z.$$.fragment,e),u(E.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),nt=!0)},o(e){m(T.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(E.$$.fragment,e),m(_.$$.fragment,e),m(S.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),nt=!1},d(e){e&&(l(Me),l(pe),l(ue),l(me),l(de),l(f),l(he),l(j),l(ye),l(w),l(Te),l(J),l(Ue),l(g),l(fe),l(b),l(je),l(we),l(C),l(Je),l(B),l(ge),l(be),l(N),l(Ie),l(Ce),l(Be),l(v),l(We),l(Ne),l(Ze),l(x),l(Ee),l(G),l(ve),l(k),l(_e),l(q),l(Se),l(A),l(xe),l($),l(Ge),l(V),l(ke),l(H),l(qe),l(F),l(Ae),l(Q),l($e),l(L),l(Ve),l(R),l(He),l(X),l(Fe),l(Qe),l(Y),l(Le),l(Re),l(D),l(Xe),l(O),l(ze),l(K),l(Ye),l(ee),l(Pe),l(De),l(Oe),l(se),l(Ke),l(et),l(tt),l(oe),l(lt),l(st),l(re)),l(h),d(T,e),d(U,e),d(I,e),d(W,e),d(Z,e),d(E,e),d(_,e),d(S,e),d(z,e),d(P,e),d(te,e),d(le,e),d(ne,e),d(ae,e),d(ie,e)}}}const Xt='{"title":"Deploy Llama 3.3 70B on AWS Inferentia2","local":"deploy-llama-33-70b-on-aws-inferentia2","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the latest Hugging Face TGI Neuron DLC","local":"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc","sections":[],"depth":2},{"title":"3. Deploy Llama 3.3 70B to Inferentia2","local":"3-deploy-llama-33-70b-to-inferentia2","sections":[],"depth":2},{"title":"4. Clean up","local":"4-clean-up","sections":[],"depth":2}],"depth":1}';function zt(at){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Vt{constructor(h){super(),Ht(this,h,zt,Rt,qt,{})}}export{el as component};
