import{s as $s,n as Zs,o as Bs}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Ws,g as p,s as l,r as m,A as Gs,h as i,f as e,c as n,j as Is,u as o,x as J,k as Us,y as Cs,a,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as xs}from"../chunks/getInferenceSnippets.2d2e232c.js";function Ns(Ms){let g,z,_,H,d,R,j,Js="<strong>Big Transfer (BiT)</strong> is a type of pretraining recipe that pre-trains  on a large supervised source dataset, and fine-tunes the weights on the target task. Models are trained on the JFT-300M dataset. The finetuned models contained in this collection are finetuned on ImageNet.",F,w,A,T,gs="To load a pretrained model:",S,y,L,u,ds="To load and preprocess the image:",D,b,P,f,js="To get the model predictions:",q,I,K,U,ws="To get the top-5 predictions class names:",O,$,ss,Z,Ts="Replace the model name with the variant you want to use, e.g. <code>resnetv2_101x1_bitm</code>. You can find the IDs in the model summaries at the top of this page.",ts,B,ys='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,k,as,W,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ls,G,ns,C,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,x,is,N,fs='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ms,V,os,E,rs,v,cs,Q,hs;return d=new Y({props:{title:"Big Transfer (BiT)",local:"big-transfer-bit",headingTag:"h1"}}),w=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25ldHYyXzEwMXgxX2JpdG0nJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),I=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV0djJfMTAxeDFfYml0bSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnetv2_101x1_bitm&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),V=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new X({props:{code:"JTQwbWlzYyU3QmtvbGVzbmlrb3YyMDIwYmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JCaWclMjBUcmFuc2ZlciUyMChCaVQpJTNBJTIwR2VuZXJhbCUyMFZpc3VhbCUyMFJlcHJlc2VudGF0aW9uJTIwTGVhcm5pbmclN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JBbGV4YW5kZXIlMjBLb2xlc25pa292JTIwYW5kJTIwTHVjYXMlMjBCZXllciUyMGFuZCUyMFhpYW9odWElMjBaaGFpJTIwYW5kJTIwSm9hbiUyMFB1aWdjZXJ2ZXIlMjBhbmQlMjBKZXNzaWNhJTIwWXVuZyUyMGFuZCUyMFN5bHZhaW4lMjBHZWxseSUyMGFuZCUyME5laWwlMjBIb3Vsc2J5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTEyLjExMzcwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{kolesnikov<span class="hljs-symbol">2020b</span>ig,
      title={<span class="hljs-keyword">Big </span>Transfer (<span class="hljs-keyword">BiT): </span>General Visual Representation Learning}, 
      author={Alexander Kolesnikov <span class="hljs-keyword">and </span>Lucas <span class="hljs-keyword">Beyer </span><span class="hljs-keyword">and </span>Xiaohua Zhai <span class="hljs-keyword">and </span><span class="hljs-keyword">Joan </span>Puigcerver <span class="hljs-keyword">and </span><span class="hljs-keyword">Jessica </span>Yung <span class="hljs-keyword">and </span>Sylvain Gelly <span class="hljs-keyword">and </span>Neil Houlsby},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">1912</span>.<span class="hljs-number">11370</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),v=new xs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/big-transfer.mdx"}}),{c(){g=p("meta"),z=l(),_=p("p"),H=l(),m(d.$$.fragment),R=l(),j=p("p"),j.innerHTML=Js,F=l(),m(w.$$.fragment),A=l(),T=p("p"),T.textContent=gs,S=l(),m(y.$$.fragment),L=l(),u=p("p"),u.textContent=ds,D=l(),m(b.$$.fragment),P=l(),f=p("p"),f.textContent=js,q=l(),m(I.$$.fragment),K=l(),U=p("p"),U.textContent=ws,O=l(),m($.$$.fragment),ss=l(),Z=p("p"),Z.innerHTML=Ts,ts=l(),B=p("p"),B.innerHTML=ys,es=l(),m(k.$$.fragment),as=l(),W=p("p"),W.textContent=us,ls=l(),m(G.$$.fragment),ns=l(),C=p("p"),C.innerHTML=bs,ps=l(),m(x.$$.fragment),is=l(),N=p("p"),N.innerHTML=fs,ms=l(),m(V.$$.fragment),os=l(),m(E.$$.fragment),rs=l(),m(v.$$.fragment),cs=l(),Q=p("p"),this.h()},l(s){const t=Gs("svelte-u9bgzb",document.head);g=i(t,"META",{name:!0,content:!0}),t.forEach(e),z=n(s),_=i(s,"P",{}),Is(_).forEach(e),H=n(s),o(d.$$.fragment,s),R=n(s),j=i(s,"P",{"data-svelte-h":!0}),J(j)!=="svelte-1la1ia4"&&(j.innerHTML=Js),F=n(s),o(w.$$.fragment,s),A=n(s),T=i(s,"P",{"data-svelte-h":!0}),J(T)!=="svelte-18ywhxh"&&(T.textContent=gs),S=n(s),o(y.$$.fragment,s),L=n(s),u=i(s,"P",{"data-svelte-h":!0}),J(u)!=="svelte-1c2ipa8"&&(u.textContent=ds),D=n(s),o(b.$$.fragment,s),P=n(s),f=i(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-1n9qsq1"&&(f.textContent=js),q=n(s),o(I.$$.fragment,s),K=n(s),U=i(s,"P",{"data-svelte-h":!0}),J(U)!=="svelte-19cnvx1"&&(U.textContent=ws),O=n(s),o($.$$.fragment,s),ss=n(s),Z=i(s,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-xm05fa"&&(Z.innerHTML=Ts),ts=n(s),B=i(s,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1wmi3ea"&&(B.innerHTML=ys),es=n(s),o(k.$$.fragment,s),as=n(s),W=i(s,"P",{"data-svelte-h":!0}),J(W)!=="svelte-9sr7nh"&&(W.textContent=us),ls=n(s),o(G.$$.fragment,s),ns=n(s),C=i(s,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1kguc51"&&(C.innerHTML=bs),ps=n(s),o(x.$$.fragment,s),is=n(s),N=i(s,"P",{"data-svelte-h":!0}),J(N)!=="svelte-xtxxu6"&&(N.innerHTML=fs),ms=n(s),o(V.$$.fragment,s),os=n(s),o(E.$$.fragment,s),rs=n(s),o(v.$$.fragment,s),cs=n(s),Q=i(s,"P",{}),Is(Q).forEach(e),this.h()},h(){Us(g,"name","hf:doc:metadata"),Us(g,"content",Vs)},m(s,t){Cs(document.head,g),a(s,z,t),a(s,_,t),a(s,H,t),r(d,s,t),a(s,R,t),a(s,j,t),a(s,F,t),r(w,s,t),a(s,A,t),a(s,T,t),a(s,S,t),r(y,s,t),a(s,L,t),a(s,u,t),a(s,D,t),r(b,s,t),a(s,P,t),a(s,f,t),a(s,q,t),r(I,s,t),a(s,K,t),a(s,U,t),a(s,O,t),r($,s,t),a(s,ss,t),a(s,Z,t),a(s,ts,t),a(s,B,t),a(s,es,t),r(k,s,t),a(s,as,t),a(s,W,t),a(s,ls,t),r(G,s,t),a(s,ns,t),a(s,C,t),a(s,ps,t),r(x,s,t),a(s,is,t),a(s,N,t),a(s,ms,t),r(V,s,t),a(s,os,t),r(E,s,t),a(s,rs,t),r(v,s,t),a(s,cs,t),a(s,Q,t),hs=!0},p:Zs,i(s){hs||(c(d.$$.fragment,s),c(w.$$.fragment,s),c(y.$$.fragment,s),c(b.$$.fragment,s),c(I.$$.fragment,s),c($.$$.fragment,s),c(k.$$.fragment,s),c(G.$$.fragment,s),c(x.$$.fragment,s),c(V.$$.fragment,s),c(E.$$.fragment,s),c(v.$$.fragment,s),hs=!0)},o(s){h(d.$$.fragment,s),h(w.$$.fragment,s),h(y.$$.fragment,s),h(b.$$.fragment,s),h(I.$$.fragment,s),h($.$$.fragment,s),h(k.$$.fragment,s),h(G.$$.fragment,s),h(x.$$.fragment,s),h(V.$$.fragment,s),h(E.$$.fragment,s),h(v.$$.fragment,s),hs=!1},d(s){s&&(e(z),e(_),e(H),e(R),e(j),e(F),e(A),e(T),e(S),e(L),e(u),e(D),e(P),e(f),e(q),e(K),e(U),e(O),e(ss),e(Z),e(ts),e(B),e(es),e(as),e(W),e(ls),e(ns),e(C),e(ps),e(is),e(N),e(ms),e(os),e(rs),e(cs),e(Q)),e(g),M(d,s),M(w,s),M(y,s),M(b,s),M(I,s),M($,s),M(k,s),M(G,s),M(x,s),M(V,s),M(E,s),M(v,s)}}}const Vs='{"title":"Big Transfer (BiT)","local":"big-transfer-bit","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(Ms){return Bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends ks{constructor(g){super(),Ws(this,g,Es,Ns,$s,{})}}export{Ys as component};
