import{s as $l,n as Gl,o as vl}from"../chunks/scheduler.85c25b89.js";import{S as El,i as xl,g as M,s as e,r as J,A as Ql,h as p,f as a,c as n,j as Wl,u as w,x as m,k as Zl,y as Yl,a as t,v as i,d as T,t as o,w as j}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.e573519b.js";import{H as V,E as Nl}from"../chunks/getInferenceSnippets.2d2e232c.js";function Rl(cl){let r,S,X,F,y,H,c,hl='<strong>Inception-ResNet-v2</strong> is a convolutional neural architecture that builds on the Inception family of architectures but incorporates <a href="https://paperswithcode.com/method/residual-connection" rel="nofollow">residual connections</a> (replacing the filter concatenation stage of the Inception architecture).',z,h,Il="This particular model was trained for study of adversarial examples (adversarial training).",L,I,dl='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',D,d,P,U,Ul="To load a pretrained model:",q,u,K,g,ul="To load and preprocess the image:",O,b,ll,A,gl="To get the model predictions:",sl,C,al,f,bl="To get the top-5 predictions class names:",tl,k,el,B,Al="Replace the model name with the variant you want to use, e.g. <code>ens_adv_inception_resnet_v2</code>. You can find the IDs in the model summaries at the top of this page.",nl,W,Cl='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',Ml,Z,pl,$,fl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Jl,G,wl,v,kl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ml,E,il,x,Bl='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',Tl,Q,ol,Y,jl,N,rl,_,yl;return y=new V({props:{title:"# Ensemble Adversarial Inception ResNet v2",local:"-ensemble-adversarial-inception-resnet-v2",headingTag:"h1"}}),d=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2Vuc19hZHZfaW5jZXB0aW9uX3Jlc25ldF92MiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ens_adv_inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZW5zX2Fkdl9pbmNlcHRpb25fcmVzbmV0X3YyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;ens_adv_inception_resnet_v2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),E=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Y=new R({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1804-00097,</span>
  author    = {Alexey Kurakin <span class="hljs-keyword">and</span>
               Ian J. Goodfellow <span class="hljs-keyword">and</span>
               Samy Bengio <span class="hljs-keyword">and</span>
               Yinpeng Dong <span class="hljs-keyword">and</span>
               Fangzhou Liao <span class="hljs-keyword">and</span>
               Ming Liang <span class="hljs-keyword">and</span>
               Tianyu Pang <span class="hljs-keyword">and</span>
               Jun Zhu <span class="hljs-keyword">and</span>
               Xiaolin Hu <span class="hljs-keyword">and</span>
               Cihang Xie <span class="hljs-keyword">and</span>
               Jianyu Wang <span class="hljs-keyword">and</span>
               Zhishuai Zhang <span class="hljs-keyword">and</span>
               Zhou Ren <span class="hljs-keyword">and</span>
               Alan L. Yuille <span class="hljs-keyword">and</span>
               Sangxia Huang <span class="hljs-keyword">and</span>
               Yao Zhao <span class="hljs-keyword">and</span>
               Yuzhe Zhao <span class="hljs-keyword">and</span>
               Zhonglin Han <span class="hljs-keyword">and</span>
               Junjiajia Long <span class="hljs-keyword">and</span>
               Yerkebulan Berdibekov <span class="hljs-keyword">and</span>
               Takuya Akiba <span class="hljs-keyword">and</span>
               Seiya Tokui <span class="hljs-keyword">and</span>
               Motoki Abe},
  title     = {Adversarial Attacks <span class="hljs-keyword">and</span> Defences Competition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1804.00097},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  timestamp = {Thu, <span class="hljs-number">31</span> Oct <span class="hljs-number">2019</span> <span class="hljs-number">16</span>:<span class="hljs-number">31</span>:<span class="hljs-number">22</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1804-00097.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),N=new Nl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/ensemble-adversarial.mdx"}}),{c(){r=M("meta"),S=e(),X=M("p"),F=e(),J(y.$$.fragment),H=e(),c=M("p"),c.innerHTML=hl,z=e(),h=M("p"),h.textContent=Il,L=e(),I=M("p"),I.innerHTML=dl,D=e(),J(d.$$.fragment),P=e(),U=M("p"),U.textContent=Ul,q=e(),J(u.$$.fragment),K=e(),g=M("p"),g.textContent=ul,O=e(),J(b.$$.fragment),ll=e(),A=M("p"),A.textContent=gl,sl=e(),J(C.$$.fragment),al=e(),f=M("p"),f.textContent=bl,tl=e(),J(k.$$.fragment),el=e(),B=M("p"),B.innerHTML=Al,nl=e(),W=M("p"),W.innerHTML=Cl,Ml=e(),J(Z.$$.fragment),pl=e(),$=M("p"),$.textContent=fl,Jl=e(),J(G.$$.fragment),wl=e(),v=M("p"),v.innerHTML=kl,ml=e(),J(E.$$.fragment),il=e(),x=M("p"),x.innerHTML=Bl,Tl=e(),J(Q.$$.fragment),ol=e(),J(Y.$$.fragment),jl=e(),J(N.$$.fragment),rl=e(),_=M("p"),this.h()},l(l){const s=Ql("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(a),S=n(l),X=p(l,"P",{}),Wl(X).forEach(a),F=n(l),w(y.$$.fragment,l),H=n(l),c=p(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-gd1at0"&&(c.innerHTML=hl),z=n(l),h=p(l,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1fjxi1n"&&(h.textContent=Il),L=n(l),I=p(l,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1nh6o5x"&&(I.innerHTML=dl),D=n(l),w(d.$$.fragment,l),P=n(l),U=p(l,"P",{"data-svelte-h":!0}),m(U)!=="svelte-18ywhxh"&&(U.textContent=Ul),q=n(l),w(u.$$.fragment,l),K=n(l),g=p(l,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1c2ipa8"&&(g.textContent=ul),O=n(l),w(b.$$.fragment,l),ll=n(l),A=p(l,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1n9qsq1"&&(A.textContent=gl),sl=n(l),w(C.$$.fragment,l),al=n(l),f=p(l,"P",{"data-svelte-h":!0}),m(f)!=="svelte-19cnvx1"&&(f.textContent=bl),tl=n(l),w(k.$$.fragment,l),el=n(l),B=p(l,"P",{"data-svelte-h":!0}),m(B)!=="svelte-mhe8ax"&&(B.innerHTML=Al),nl=n(l),W=p(l,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1wmi3ea"&&(W.innerHTML=Cl),Ml=n(l),w(Z.$$.fragment,l),pl=n(l),$=p(l,"P",{"data-svelte-h":!0}),m($)!=="svelte-9sr7nh"&&($.textContent=fl),Jl=n(l),w(G.$$.fragment,l),wl=n(l),v=p(l,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1kguc51"&&(v.innerHTML=kl),ml=n(l),w(E.$$.fragment,l),il=n(l),x=p(l,"P",{"data-svelte-h":!0}),m(x)!=="svelte-xtxxu6"&&(x.innerHTML=Bl),Tl=n(l),w(Q.$$.fragment,l),ol=n(l),w(Y.$$.fragment,l),jl=n(l),w(N.$$.fragment,l),rl=n(l),_=p(l,"P",{}),Wl(_).forEach(a),this.h()},h(){Zl(r,"name","hf:doc:metadata"),Zl(r,"content",Xl)},m(l,s){Yl(document.head,r),t(l,S,s),t(l,X,s),t(l,F,s),i(y,l,s),t(l,H,s),t(l,c,s),t(l,z,s),t(l,h,s),t(l,L,s),t(l,I,s),t(l,D,s),i(d,l,s),t(l,P,s),t(l,U,s),t(l,q,s),i(u,l,s),t(l,K,s),t(l,g,s),t(l,O,s),i(b,l,s),t(l,ll,s),t(l,A,s),t(l,sl,s),i(C,l,s),t(l,al,s),t(l,f,s),t(l,tl,s),i(k,l,s),t(l,el,s),t(l,B,s),t(l,nl,s),t(l,W,s),t(l,Ml,s),i(Z,l,s),t(l,pl,s),t(l,$,s),t(l,Jl,s),i(G,l,s),t(l,wl,s),t(l,v,s),t(l,ml,s),i(E,l,s),t(l,il,s),t(l,x,s),t(l,Tl,s),i(Q,l,s),t(l,ol,s),i(Y,l,s),t(l,jl,s),i(N,l,s),t(l,rl,s),t(l,_,s),yl=!0},p:Gl,i(l){yl||(T(y.$$.fragment,l),T(d.$$.fragment,l),T(u.$$.fragment,l),T(b.$$.fragment,l),T(C.$$.fragment,l),T(k.$$.fragment,l),T(Z.$$.fragment,l),T(G.$$.fragment,l),T(E.$$.fragment,l),T(Q.$$.fragment,l),T(Y.$$.fragment,l),T(N.$$.fragment,l),yl=!0)},o(l){o(y.$$.fragment,l),o(d.$$.fragment,l),o(u.$$.fragment,l),o(b.$$.fragment,l),o(C.$$.fragment,l),o(k.$$.fragment,l),o(Z.$$.fragment,l),o(G.$$.fragment,l),o(E.$$.fragment,l),o(Q.$$.fragment,l),o(Y.$$.fragment,l),o(N.$$.fragment,l),yl=!1},d(l){l&&(a(S),a(X),a(F),a(H),a(c),a(z),a(h),a(L),a(I),a(D),a(P),a(U),a(q),a(K),a(g),a(O),a(ll),a(A),a(sl),a(al),a(f),a(tl),a(el),a(B),a(nl),a(W),a(Ml),a(pl),a($),a(Jl),a(wl),a(v),a(ml),a(il),a(x),a(Tl),a(ol),a(jl),a(rl),a(_)),a(r),j(y,l),j(d,l),j(u,l),j(b,l),j(C,l),j(k,l),j(Z,l),j(G,l),j(E,l),j(Q,l),j(Y,l),j(N,l)}}}const Xl='{"title":"# Ensemble Adversarial Inception ResNet v2","local":"-ensemble-adversarial-inception-resnet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _l(cl){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends El{constructor(r){super(),xl(this,r,_l,Rl,$l,{})}}export{zl as component};
