import{s as Gs,n as ks,o as Ns}from"../chunks/scheduler.85c25b89.js";import{S as xs,i as Ws,g as p,s as a,r as m,A as Bs,h as i,f as l,c as n,j as Zs,u as o,x as y,k as $s,y as vs,a as e,v as M,d as c,t as r,w as h}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.e573519b.js";import{H as X,E as As}from"../chunks/getInferenceSnippets.2d2e232c.js";function Es(Js){let J,_,Y,S,g,z,j,gs='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifier</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',H,w,js='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,T,L,d,ws="To load a pretrained model:",D,u,P,U,Ts="To load and preprocess the image:",q,b,K,f,ds="To get the model predictions:",O,C,ss,I,us="To get the top-5 predictions class names:",ts,Z,ls,$,Us="Replace the model name with the variant you want to use, e.g. <code>gluon_inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",es,G,bs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',as,k,ns,N,fs="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ps,x,is,W,Cs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ms,B,os,v,Is='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',Ms,A,cs,E,rs,Q,hs,R,ys;return g=new X({props:{title:"(Gluon) Inception v3",local:"gluon-inception-v3",headingTag:"h1"}}),T=new X({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new X({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),x=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25faW5jZXB0aW9uX3YzJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new X({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),A=new X({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZTemVnZWR5VklTVzE1JTJDJTBBJTIwJTIwYXV0aG9yJTIwJTIwJTIwJTIwJTNEJTIwJTdCQ2hyaXN0aWFuJTIwU3plZ2VkeSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFZpbmNlbnQlMjBWYW5ob3Vja2UlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTZXJnZXklMjBJb2ZmZSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEpvbmF0aG9uJTIwU2hsZW5zJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwWmJpZ25pZXclMjBXb2puYSU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCUmV0aGlua2luZyUyMHRoZSUyMEluY2VwdGlvbiUyMEFyY2hpdGVjdHVyZSUyMGZvciUyMENvbXB1dGVyJTIwVmlzaW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxNTEyLjAwNTY3JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTUlN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTUxMi4wMDU2NyU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE1MTIuMDA1NjclN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAxMyUyMEF1ZyUyMDIwMTglMjAxNiUzQTQ5JTNBMDclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRlN6ZWdlZHlWSVNXMTUuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15,
  author    = {Christian Szegedy and
               Vincent Vanhoucke and
               Sergey Ioffe and
               Jonathon Shlens and
               Zbigniew Wojna},
  title     = {Rethinking the Inception Architecture <span class="hljs-keyword">for</span> Computer Vision},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1512.00567</span>},
  year      = {<span class="hljs-number">2015</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1512.00567</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1512.00567</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">49</span>:<span class="hljs-number">07</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>SzegedyVISW15.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),Q=new As({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-inception-v3.mdx"}}),{c(){J=p("meta"),_=a(),Y=p("p"),S=a(),m(g.$$.fragment),z=a(),j=p("p"),j.innerHTML=gs,H=a(),w=p("p"),w.innerHTML=js,F=a(),m(T.$$.fragment),L=a(),d=p("p"),d.textContent=ws,D=a(),m(u.$$.fragment),P=a(),U=p("p"),U.textContent=Ts,q=a(),m(b.$$.fragment),K=a(),f=p("p"),f.textContent=ds,O=a(),m(C.$$.fragment),ss=a(),I=p("p"),I.textContent=us,ts=a(),m(Z.$$.fragment),ls=a(),$=p("p"),$.innerHTML=Us,es=a(),G=p("p"),G.innerHTML=bs,as=a(),m(k.$$.fragment),ns=a(),N=p("p"),N.textContent=fs,ps=a(),m(x.$$.fragment),is=a(),W=p("p"),W.innerHTML=Cs,ms=a(),m(B.$$.fragment),os=a(),v=p("p"),v.innerHTML=Is,Ms=a(),m(A.$$.fragment),cs=a(),m(E.$$.fragment),rs=a(),m(Q.$$.fragment),hs=a(),R=p("p"),this.h()},l(s){const t=Bs("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),_=n(s),Y=i(s,"P",{}),Zs(Y).forEach(l),S=n(s),o(g.$$.fragment,s),z=n(s),j=i(s,"P",{"data-svelte-h":!0}),y(j)!=="svelte-1oyeygh"&&(j.innerHTML=gs),H=n(s),w=i(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-1vag5uc"&&(w.innerHTML=js),F=n(s),o(T.$$.fragment,s),L=n(s),d=i(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-18ywhxh"&&(d.textContent=ws),D=n(s),o(u.$$.fragment,s),P=n(s),U=i(s,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1c2ipa8"&&(U.textContent=Ts),q=n(s),o(b.$$.fragment,s),K=n(s),f=i(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1n9qsq1"&&(f.textContent=ds),O=n(s),o(C.$$.fragment,s),ss=n(s),I=i(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-19cnvx1"&&(I.textContent=us),ts=n(s),o(Z.$$.fragment,s),ls=n(s),$=i(s,"P",{"data-svelte-h":!0}),y($)!=="svelte-t399n1"&&($.innerHTML=Us),es=n(s),G=i(s,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1wmi3ea"&&(G.innerHTML=bs),as=n(s),o(k.$$.fragment,s),ns=n(s),N=i(s,"P",{"data-svelte-h":!0}),y(N)!=="svelte-9sr7nh"&&(N.textContent=fs),ps=n(s),o(x.$$.fragment,s),is=n(s),W=i(s,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1kguc51"&&(W.innerHTML=Cs),ms=n(s),o(B.$$.fragment,s),os=n(s),v=i(s,"P",{"data-svelte-h":!0}),y(v)!=="svelte-xtxxu6"&&(v.innerHTML=Is),Ms=n(s),o(A.$$.fragment,s),cs=n(s),o(E.$$.fragment,s),rs=n(s),o(Q.$$.fragment,s),hs=n(s),R=i(s,"P",{}),Zs(R).forEach(l),this.h()},h(){$s(J,"name","hf:doc:metadata"),$s(J,"content",Qs)},m(s,t){vs(document.head,J),e(s,_,t),e(s,Y,t),e(s,S,t),M(g,s,t),e(s,z,t),e(s,j,t),e(s,H,t),e(s,w,t),e(s,F,t),M(T,s,t),e(s,L,t),e(s,d,t),e(s,D,t),M(u,s,t),e(s,P,t),e(s,U,t),e(s,q,t),M(b,s,t),e(s,K,t),e(s,f,t),e(s,O,t),M(C,s,t),e(s,ss,t),e(s,I,t),e(s,ts,t),M(Z,s,t),e(s,ls,t),e(s,$,t),e(s,es,t),e(s,G,t),e(s,as,t),M(k,s,t),e(s,ns,t),e(s,N,t),e(s,ps,t),M(x,s,t),e(s,is,t),e(s,W,t),e(s,ms,t),M(B,s,t),e(s,os,t),e(s,v,t),e(s,Ms,t),M(A,s,t),e(s,cs,t),M(E,s,t),e(s,rs,t),M(Q,s,t),e(s,hs,t),e(s,R,t),ys=!0},p:ks,i(s){ys||(c(g.$$.fragment,s),c(T.$$.fragment,s),c(u.$$.fragment,s),c(b.$$.fragment,s),c(C.$$.fragment,s),c(Z.$$.fragment,s),c(k.$$.fragment,s),c(x.$$.fragment,s),c(B.$$.fragment,s),c(A.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),ys=!0)},o(s){r(g.$$.fragment,s),r(T.$$.fragment,s),r(u.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(Z.$$.fragment,s),r(k.$$.fragment,s),r(x.$$.fragment,s),r(B.$$.fragment,s),r(A.$$.fragment,s),r(E.$$.fragment,s),r(Q.$$.fragment,s),ys=!1},d(s){s&&(l(_),l(Y),l(S),l(z),l(j),l(H),l(w),l(F),l(L),l(d),l(D),l(P),l(U),l(q),l(K),l(f),l(O),l(ss),l(I),l(ts),l(ls),l($),l(es),l(G),l(as),l(ns),l(N),l(ps),l(is),l(W),l(ms),l(os),l(v),l(Ms),l(cs),l(rs),l(hs),l(R)),l(J),h(g,s),h(T,s),h(u,s),h(b,s),h(C,s),h(Z,s),h(k,s),h(x,s),h(B,s),h(A,s),h(E,s),h(Q,s)}}}const Qs='{"title":"(Gluon) Inception v3","local":"gluon-inception-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vs(Js){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends xs{constructor(J){super(),Ws(this,J,Vs,Es,Gs,{})}}export{Ss as component};
