import{s as Oe,f as st,o as et}from"../chunks/scheduler.85c25b89.js";import{S as tt,i as at,g as p,s as n,r,A as nt,h as i,f as t,c as l,j as Ae,u as m,x as d,k as xs,y as lt,a,v as c,d as o,t as h,w as g,m as qe,n as De}from"../chunks/index.c9837788.js";import{T as Ke}from"../chunks/Tip.6bd863a0.js";import{C as u}from"../chunks/CodeBlock.52fa569e.js";import{H as js}from"../chunks/Heading.3097d2ed.js";function pt(bs){let f;return{c(){f=qe("Note: The returned PyTorch model is set to train mode by default, so you must call .eval() on it if you plan to use it for inference.")},l(j){f=De(j,"Note: The returned PyTorch model is set to train mode by default, so you must call .eval() on it if you plan to use it for inference.")},m(j,b){a(j,f,b)},d(j){j&&t(f)}}}function it(bs){let f;return{c(){f=qe("Note: Here, the pretrained model's config happens to be the same as the generic config we made earlier. This is not always the case. So, it's safer to use the data config to create the transform as we did here instead of using the generic transform.")},l(j){f=De(j,"Note: Here, the pretrained model's config happens to be the same as the generic config we made earlier. This is not always the case. So, it's safer to use the data config to create the transform as we did here instead of using the generic transform.")},m(j,b){a(j,f,b)},d(j){j&&t(f)}}}function rt(bs){let f,j,b,ws,M,Ms,y,we="This quickstart is intended for developers who are ready to dive into the code and see an example of how to integrate <code>timm</code> into their model training workflow.",ys,_,Me='First, you’ll need to install <code>timm</code>. For more information on installation, see <a href="installation">Installation</a>.',_s,T,Ts,v,vs,J,ye='Pretrained models can be loaded using <a href="/docs/timm/main/en/reference/models#timm.create_model">create_model()</a>.',Js,W,_e="Here, we load the pretrained <code>mobilenetv3_large_100</code> model.",Ws,k,ks,$,Zs,Z,Cs,C,Te='To list models packaged with <code>timm</code>, you can use <a href="/docs/timm/main/en/reference/models#timm.list_models">list_models()</a>. If you specify <code>pretrained=True</code>, this function will only return model names that have associated pretrained weights available.',Us,U,Hs,H,ve="You can also list models with a specific pattern in their name.",Rs,R,Fs,F,Vs,V,Je="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ls,L,Ns,N,We='To fine-tune on your own dataset, you have to write a PyTorch training loop or adapt <code>timm</code>’s <a href="training_script">training script</a> to use your dataset.',Gs,G,zs,z,ke="Without modifying the network, one can call model.forward_features(input) on any model instead of the usual model(input). This will bypass the head classifier and global pooling for networks.",Qs,Q,Ze='For a more in depth guide to using <code>timm</code> for feature extraction, see <a href="feature_extraction">Feature Extraction</a>.',Es,E,Is,I,Bs,B,Ce='To transform images into valid inputs for a model, you can use <a href="/docs/timm/main/en/reference/data#timm.data.create_transform">timm.data.create_transform()</a>, providing the desired <code>input_size</code> that the model expects.',Xs,X,Ue="This will return a generic transform that uses reasonable defaults.",Ps,P,Ss,S,He="Pretrained models have specific transforms that were applied to images fed into them while training. If you use the wrong transform on your image, the model won’t understand what it’s seeing!",Ys,Y,Re="To figure out which transformations were used for a given pretrained model, we can start by taking a look at its <code>pretrained_cfg</code>",As,A,Ks,K,Fe='We can then resolve only the data related configuration by using <a href="/docs/timm/main/en/reference/data#timm.data.resolve_data_config">timm.data.resolve_data_config()</a>.',qs,q,Ds,D,Ve='We can pass this data config to <a href="/docs/timm/main/en/reference/data#timm.data.create_transform">timm.data.create_transform()</a> to initialize the model’s associated transform.',Os,O,se,x,ee,ss,te,es,Le="Here, we will put together the above sections and use a pretrained model for inference.",ae,ts,Ne="First we’ll need an image to do inference on. Here we load a picture of a leaf from the web:",ne,as,le,ns,Ge="Here’s the image we loaded:",pe,w,ze,ie,ls,Qe="Now, we’ll create our model and transforms again. This time, we make sure to set our model in evaluation mode.",re,ps,me,is,Ee="We can prepare this image for the model by passing it to the transform.",ce,rs,oe,ms,Ie="Now we can pass that image to the model to get the predictions. We use <code>unsqueeze(0)</code> in this case, as the model is expecting a batch dimension.",he,cs,ge,os,Be="To get the predicted probabilities, we apply softmax to the output. This leaves us with a tensor of shape <code>(num_classes,)</code>.",de,hs,fe,gs,Xe="Now we’ll find the top 5 predicted class indexes and values using <code>torch.topk</code>.",ue,ds,je,fs,Pe="If we check the imagenet labels for the top index, we can see what the model predicted…",be,us,$e,$s,xe;return M=new js({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),T=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRpbW0=",highlighted:"pip install timm",wrap:!1}}),v=new js({props:{title:"Load a Pretrained Model",local:"load-a-pretrained-model",headingTag:"h2"}}),k=new u({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW0lMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW0uZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm

<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),$=new Ke({props:{$$slots:{default:[pt]},$$scope:{ctx:bs}}}),Z=new js({props:{title:"List Models with Pretrained Weights",local:"list-models-with-pretrained-weights",headingTag:"h2"}}),U=new u({props:{code:"aW1wb3J0JTIwdGltbSUwQWZyb20lMjBwcHJpbnQlMjBpbXBvcnQlMjBwcHJpbnQlMEFtb2RlbF9uYW1lcyUyMCUzRCUyMHRpbW0ubGlzdF9tb2RlbHMocHJldHJhaW5lZCUzRFRydWUpJTBBcHByaW50KG1vZGVsX25hbWVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pprint <span class="hljs-keyword">import</span> pprint
<span class="hljs-meta">&gt;&gt;&gt; </span>model_names = timm.list_models(pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pprint(model_names)
[
    <span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>,
    <span class="hljs-string">&#x27;cspdarknet53&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnext50&#x27;</span>,
    <span class="hljs-string">&#x27;densenet121&#x27;</span>,
    <span class="hljs-string">&#x27;densenet161&#x27;</span>,
    <span class="hljs-string">&#x27;densenet169&#x27;</span>,
    <span class="hljs-string">&#x27;densenet201&#x27;</span>,
    <span class="hljs-string">&#x27;densenetblur121d&#x27;</span>,
    <span class="hljs-string">&#x27;dla34&#x27;</span>,
    <span class="hljs-string">&#x27;dla46_c&#x27;</span>,
]`,wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwdGltbSUwQWZyb20lMjBwcHJpbnQlMjBpbXBvcnQlMjBwcHJpbnQlMEFtb2RlbF9uYW1lcyUyMCUzRCUyMHRpbW0ubGlzdF9tb2RlbHMoJypyZXNuZSp0KicpJTBBcHByaW50KG1vZGVsX25hbWVzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pprint <span class="hljs-keyword">import</span> pprint
<span class="hljs-meta">&gt;&gt;&gt; </span>model_names = timm.list_models(<span class="hljs-string">&#x27;*resne*t*&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pprint(model_names)
[
    <span class="hljs-string">&#x27;cspresnet50&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnet50d&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnet50w&#x27;</span>,
    <span class="hljs-string">&#x27;cspresnext50&#x27;</span>,
    ...
]`,wrap:!1}}),F=new js({props:{title:"Fine-Tune a Pretrained Model",local:"fine-tune-a-pretrained-model",headingTag:"h2"}}),L=new u({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new js({props:{title:"Use a Pretrained Model for Feature Extraction",local:"use-a-pretrained-model-for-feature-extraction",headingTag:"h2"}}),E=new u({props:{code:"aW1wb3J0JTIwdGltbSUwQWltcG9ydCUyMHRvcmNoJTBBeCUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYzX2xhcmdlXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFmZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmZvcndhcmRfZmVhdHVyZXMoeCklMEFwcmludChmZWF0dXJlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>features = model.forward_features(x)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(features.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">960</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>])`,wrap:!1}}),I=new js({props:{title:"Image Augmentation",local:"image-augmentation",headingTag:"h2"}}),P=new u({props:{code:"dGltbS5kYXRhLmNyZWF0ZV90cmFuc2Zvcm0oKDMlMkMlMjAyMjQlMkMlMjAyMjQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>timm.data.create_transform((<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
Compose(
    Resize(size=<span class="hljs-number">256</span>, interpolation=bilinear, max_size=<span class="hljs-literal">None</span>, antialias=<span class="hljs-literal">None</span>)
    CenterCrop(size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    ToTensor()
    Normalize(mean=tensor([<span class="hljs-number">0.4850</span>, <span class="hljs-number">0.4560</span>, <span class="hljs-number">0.4060</span>]), std=tensor([<span class="hljs-number">0.2290</span>, <span class="hljs-number">0.2240</span>, <span class="hljs-number">0.2250</span>]))
)`,wrap:!1}}),A=new u({props:{code:"bW9kZWwucHJldHJhaW5lZF9jZmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.pretrained_cfg
{<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/rwightman/pytorch-image-models/releases/download/v0.1-weights/mobilenetv3_large_100_ra-f55367f5.pth&#x27;</span>,
 <span class="hljs-string">&#x27;num_classes&#x27;</span>: <span class="hljs-number">1000</span>,
 <span class="hljs-string">&#x27;input_size&#x27;</span>: (<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>),
 <span class="hljs-string">&#x27;pool_size&#x27;</span>: (<span class="hljs-number">7</span>, <span class="hljs-number">7</span>),
 <span class="hljs-string">&#x27;crop_pct&#x27;</span>: <span class="hljs-number">0.875</span>,
 <span class="hljs-string">&#x27;interpolation&#x27;</span>: <span class="hljs-string">&#x27;bicubic&#x27;</span>,
 <span class="hljs-string">&#x27;mean&#x27;</span>: (<span class="hljs-number">0.485</span>, <span class="hljs-number">0.456</span>, <span class="hljs-number">0.406</span>),
 <span class="hljs-string">&#x27;std&#x27;</span>: (<span class="hljs-number">0.229</span>, <span class="hljs-number">0.224</span>, <span class="hljs-number">0.225</span>),
 <span class="hljs-string">&#x27;first_conv&#x27;</span>: <span class="hljs-string">&#x27;conv_stem&#x27;</span>,
 <span class="hljs-string">&#x27;classifier&#x27;</span>: <span class="hljs-string">&#x27;classifier&#x27;</span>,
 <span class="hljs-string">&#x27;architecture&#x27;</span>: <span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>}`,wrap:!1}}),q=new u({props:{code:"dGltbS5kYXRhLnJlc29sdmVfZGF0YV9jb25maWcobW9kZWwucHJldHJhaW5lZF9jZmcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>timm.data.resolve_data_config(model.pretrained_cfg)
{<span class="hljs-string">&#x27;input_size&#x27;</span>: (<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>),
 <span class="hljs-string">&#x27;interpolation&#x27;</span>: <span class="hljs-string">&#x27;bicubic&#x27;</span>,
 <span class="hljs-string">&#x27;mean&#x27;</span>: (<span class="hljs-number">0.485</span>, <span class="hljs-number">0.456</span>, <span class="hljs-number">0.406</span>),
 <span class="hljs-string">&#x27;std&#x27;</span>: (<span class="hljs-number">0.229</span>, <span class="hljs-number">0.224</span>, <span class="hljs-number">0.225</span>),
 <span class="hljs-string">&#x27;crop_pct&#x27;</span>: <span class="hljs-number">0.875</span>}`,wrap:!1}}),O=new u({props:{code:"ZGF0YV9jZmclMjAlM0QlMjB0aW1tLmRhdGEucmVzb2x2ZV9kYXRhX2NvbmZpZyhtb2RlbC5wcmV0cmFpbmVkX2NmZyklMEF0cmFuc2Zvcm0lMjAlM0QlMjB0aW1tLmRhdGEuY3JlYXRlX3RyYW5zZm9ybSgqKmRhdGFfY2ZnKSUwQXRyYW5zZm9ybQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_cfg = timm.data.resolve_data_config(model.pretrained_cfg)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = timm.data.create_transform(**data_cfg)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform
Compose(
    Resize(size=<span class="hljs-number">256</span>, interpolation=bicubic, max_size=<span class="hljs-literal">None</span>, antialias=<span class="hljs-literal">None</span>)
    CenterCrop(size=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    ToTensor()
    Normalize(mean=tensor([<span class="hljs-number">0.4850</span>, <span class="hljs-number">0.4560</span>, <span class="hljs-number">0.4060</span>]), std=tensor([<span class="hljs-number">0.2290</span>, <span class="hljs-number">0.2240</span>, <span class="hljs-number">0.2250</span>]))
)`,wrap:!1}}),x=new Ke({props:{$$slots:{default:[it]},$$scope:{ctx:bs}}}),ss=new js({props:{title:"Using Pretrained Models for Inference",local:"using-pretrained-models-for-inference",headingTag:"h2"}}),as=new u({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwaW8lMjBpbXBvcnQlMjBCeXRlc0lPJTBBdXJsJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGZGF0YXNldHMtc2VydmVyLmh1Z2dpbmdmYWNlLmNvJTJGYXNzZXRzJTJGaW1hZ2VuZXQtMWslMkYtLSUyRmRlZmF1bHQlMkZ0ZXN0JTJGMTIlMkZpbWFnZSUyRmltYWdlLmpwZyclMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&#x27;https://datasets-server.huggingface.co/assets/imagenet-1k/--/default/test/12/image/image.jpg&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),ps=new u({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKS5ldmFsKCklMEF0cmFuc2Zvcm0lMjAlM0QlMjB0aW1tLmRhdGEuY3JlYXRlX3RyYW5zZm9ybSg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>).<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = timm.data.create_transform(
    **timm.data.resolve_data_config(model.pretrained_cfg)
)`,wrap:!1}}),rs=new u({props:{code:"aW1hZ2VfdGVuc29yJTIwJTNEJTIwdHJhbnNmb3JtKGltYWdlKSUwQWltYWdlX3RlbnNvci5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_tensor = transform(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_tensor.shape
torch.Size([<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>])`,wrap:!1}}),cs=new u({props:{code:"b3V0cHV0JTIwJTNEJTIwbW9kZWwoaW1hZ2VfdGVuc29yLnVuc3F1ZWV6ZSgwKSklMEFvdXRwdXQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(image_tensor.unsqueeze(<span class="hljs-number">0</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>output.shape
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>])`,wrap:!1}}),hs=new u({props:{code:"cHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuc29mdG1heChvdXRwdXQlNUIwJTVEJTJDJTIwZGltJTNEMCklMEFwcm9iYWJpbGl0aWVzLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(output[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities.shape
torch.Size([<span class="hljs-number">1000</span>])`,wrap:!1}}),ds=new u({props:{code:"dmFsdWVzJTJDJTIwaW5kaWNlcyUyMCUzRCUyMHRvcmNoLnRvcGsocHJvYmFiaWxpdGllcyUyQyUyMDUpJTBBaW5kaWNlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>values, indices = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>indices
tensor([<span class="hljs-number">162</span>, <span class="hljs-number">166</span>, <span class="hljs-number">161</span>, <span class="hljs-number">164</span>, <span class="hljs-number">167</span>])`,wrap:!1}}),us=new u({props:{code:"SU1BR0VORVRfMWtfVVJMJTIwJTNEJTIwJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRmJpdF9tb2RlbHMlMkZpbHN2cmMyMDEyX3dvcmRuZXRfbGVtbWFzLnR4dCclMEFJTUFHRU5FVF8xa19MQUJFTFMlMjAlM0QlMjByZXF1ZXN0cy5nZXQoSU1BR0VORVRfMWtfVVJMKS50ZXh0LnN0cmlwKCkuc3BsaXQoJyU1Q24nKSUwQSU1QiU3QidsYWJlbCclM0ElMjBJTUFHRU5FVF8xa19MQUJFTFMlNUJpZHglNUQlMkMlMjAndmFsdWUnJTNBJTIwdmFsLml0ZW0oKSU3RCUyMGZvciUyMHZhbCUyQyUyMGlkeCUyMGluJTIwemlwKHZhbHVlcyUyQyUyMGluZGljZXMpJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>IMAGENET_1k_URL = <span class="hljs-string">&#x27;https://storage.googleapis.com/bit_models/ilsvrc2012_wordnet_lemmas.txt&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>IMAGENET_1k_LABELS = requests.get(IMAGENET_1k_URL).text.strip().split(<span class="hljs-string">&#x27;\\n&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>[{<span class="hljs-string">&#x27;label&#x27;</span>: IMAGENET_1k_LABELS[idx], <span class="hljs-string">&#x27;value&#x27;</span>: val.item()} <span class="hljs-keyword">for</span> val, idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(values, indices)]
[{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;beagle&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.8486220836639404</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Walker_hound, Walker_foxhound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.03753996267914772</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;basset, basset_hound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.024628572165966034</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;bluetick&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.010317106731235981</span>},
 {<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;English_foxhound&#x27;</span>, <span class="hljs-string">&#x27;value&#x27;</span>: <span class="hljs-number">0.006958036217838526</span>}]`,wrap:!1}}),{c(){f=p("meta"),j=n(),b=p("p"),ws=n(),r(M.$$.fragment),Ms=n(),y=p("p"),y.innerHTML=we,ys=n(),_=p("p"),_.innerHTML=Me,_s=n(),r(T.$$.fragment),Ts=n(),r(v.$$.fragment),vs=n(),J=p("p"),J.innerHTML=ye,Js=n(),W=p("p"),W.innerHTML=_e,Ws=n(),r(k.$$.fragment),ks=n(),r($.$$.fragment),Zs=n(),r(Z.$$.fragment),Cs=n(),C=p("p"),C.innerHTML=Te,Us=n(),r(U.$$.fragment),Hs=n(),H=p("p"),H.textContent=ve,Rs=n(),r(R.$$.fragment),Fs=n(),r(F.$$.fragment),Vs=n(),V=p("p"),V.textContent=Je,Ls=n(),r(L.$$.fragment),Ns=n(),N=p("p"),N.innerHTML=We,Gs=n(),r(G.$$.fragment),zs=n(),z=p("p"),z.textContent=ke,Qs=n(),Q=p("p"),Q.innerHTML=Ze,Es=n(),r(E.$$.fragment),Is=n(),r(I.$$.fragment),Bs=n(),B=p("p"),B.innerHTML=Ce,Xs=n(),X=p("p"),X.textContent=Ue,Ps=n(),r(P.$$.fragment),Ss=n(),S=p("p"),S.textContent=He,Ys=n(),Y=p("p"),Y.innerHTML=Re,As=n(),r(A.$$.fragment),Ks=n(),K=p("p"),K.innerHTML=Fe,qs=n(),r(q.$$.fragment),Ds=n(),D=p("p"),D.innerHTML=Ve,Os=n(),r(O.$$.fragment),se=n(),r(x.$$.fragment),ee=n(),r(ss.$$.fragment),te=n(),es=p("p"),es.textContent=Le,ae=n(),ts=p("p"),ts.textContent=Ne,ne=n(),r(as.$$.fragment),le=n(),ns=p("p"),ns.textContent=Ge,pe=n(),w=p("img"),ie=n(),ls=p("p"),ls.textContent=Qe,re=n(),r(ps.$$.fragment),me=n(),is=p("p"),is.textContent=Ee,ce=n(),r(rs.$$.fragment),oe=n(),ms=p("p"),ms.innerHTML=Ie,he=n(),r(cs.$$.fragment),ge=n(),os=p("p"),os.innerHTML=Be,de=n(),r(hs.$$.fragment),fe=n(),gs=p("p"),gs.innerHTML=Xe,ue=n(),r(ds.$$.fragment),je=n(),fs=p("p"),fs.textContent=Pe,be=n(),r(us.$$.fragment),$e=n(),$s=p("p"),this.h()},l(s){const e=nt("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(t),j=l(s),b=i(s,"P",{}),Ae(b).forEach(t),ws=l(s),m(M.$$.fragment,s),Ms=l(s),y=i(s,"P",{"data-svelte-h":!0}),d(y)!=="svelte-1mt2wpi"&&(y.innerHTML=we),ys=l(s),_=i(s,"P",{"data-svelte-h":!0}),d(_)!=="svelte-15vunib"&&(_.innerHTML=Me),_s=l(s),m(T.$$.fragment,s),Ts=l(s),m(v.$$.fragment,s),vs=l(s),J=i(s,"P",{"data-svelte-h":!0}),d(J)!=="svelte-18pqgp7"&&(J.innerHTML=ye),Js=l(s),W=i(s,"P",{"data-svelte-h":!0}),d(W)!=="svelte-11h2wfj"&&(W.innerHTML=_e),Ws=l(s),m(k.$$.fragment,s),ks=l(s),m($.$$.fragment,s),Zs=l(s),m(Z.$$.fragment,s),Cs=l(s),C=i(s,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1wekjjz"&&(C.innerHTML=Te),Us=l(s),m(U.$$.fragment,s),Hs=l(s),H=i(s,"P",{"data-svelte-h":!0}),d(H)!=="svelte-15bjls3"&&(H.textContent=ve),Rs=l(s),m(R.$$.fragment,s),Fs=l(s),m(F.$$.fragment,s),Vs=l(s),V=i(s,"P",{"data-svelte-h":!0}),d(V)!=="svelte-9sr7nh"&&(V.textContent=Je),Ls=l(s),m(L.$$.fragment,s),Ns=l(s),N=i(s,"P",{"data-svelte-h":!0}),d(N)!=="svelte-17jj7hb"&&(N.innerHTML=We),Gs=l(s),m(G.$$.fragment,s),zs=l(s),z=i(s,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1bs7nra"&&(z.textContent=ke),Qs=l(s),Q=i(s,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1ufypal"&&(Q.innerHTML=Ze),Es=l(s),m(E.$$.fragment,s),Is=l(s),m(I.$$.fragment,s),Bs=l(s),B=i(s,"P",{"data-svelte-h":!0}),d(B)!=="svelte-gz6owi"&&(B.innerHTML=Ce),Xs=l(s),X=i(s,"P",{"data-svelte-h":!0}),d(X)!=="svelte-14s5fqt"&&(X.textContent=Ue),Ps=l(s),m(P.$$.fragment,s),Ss=l(s),S=i(s,"P",{"data-svelte-h":!0}),d(S)!=="svelte-jniymz"&&(S.textContent=He),Ys=l(s),Y=i(s,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1qp841i"&&(Y.innerHTML=Re),As=l(s),m(A.$$.fragment,s),Ks=l(s),K=i(s,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1mhqa8m"&&(K.innerHTML=Fe),qs=l(s),m(q.$$.fragment,s),Ds=l(s),D=i(s,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1ehtbgx"&&(D.innerHTML=Ve),Os=l(s),m(O.$$.fragment,s),se=l(s),m(x.$$.fragment,s),ee=l(s),m(ss.$$.fragment,s),te=l(s),es=i(s,"P",{"data-svelte-h":!0}),d(es)!=="svelte-1vfr0rj"&&(es.textContent=Le),ae=l(s),ts=i(s,"P",{"data-svelte-h":!0}),d(ts)!=="svelte-1u7llub"&&(ts.textContent=Ne),ne=l(s),m(as.$$.fragment,s),le=l(s),ns=i(s,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-nk223p"&&(ns.textContent=Ge),pe=l(s),w=i(s,"IMG",{src:!0,alt:!0,width:!0}),ie=l(s),ls=i(s,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1lr3iea"&&(ls.textContent=Qe),re=l(s),m(ps.$$.fragment,s),me=l(s),is=i(s,"P",{"data-svelte-h":!0}),d(is)!=="svelte-8vriuk"&&(is.textContent=Ee),ce=l(s),m(rs.$$.fragment,s),oe=l(s),ms=i(s,"P",{"data-svelte-h":!0}),d(ms)!=="svelte-ql7fkr"&&(ms.innerHTML=Ie),he=l(s),m(cs.$$.fragment,s),ge=l(s),os=i(s,"P",{"data-svelte-h":!0}),d(os)!=="svelte-1sn7t3l"&&(os.innerHTML=Be),de=l(s),m(hs.$$.fragment,s),fe=l(s),gs=i(s,"P",{"data-svelte-h":!0}),d(gs)!=="svelte-1bct4ll"&&(gs.innerHTML=Xe),ue=l(s),m(ds.$$.fragment,s),je=l(s),fs=i(s,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-9q87ex"&&(fs.textContent=Pe),be=l(s),m(us.$$.fragment,s),$e=l(s),$s=i(s,"P",{}),Ae($s).forEach(t),this.h()},h(){xs(f,"name","hf:doc:metadata"),xs(f,"content",mt),st(w.src,ze="https://datasets-server.huggingface.co/assets/imagenet-1k/--/default/test/12/image/image.jpg")||xs(w,"src",ze),xs(w,"alt","An Image from a link"),xs(w,"width","300")},m(s,e){lt(document.head,f),a(s,j,e),a(s,b,e),a(s,ws,e),c(M,s,e),a(s,Ms,e),a(s,y,e),a(s,ys,e),a(s,_,e),a(s,_s,e),c(T,s,e),a(s,Ts,e),c(v,s,e),a(s,vs,e),a(s,J,e),a(s,Js,e),a(s,W,e),a(s,Ws,e),c(k,s,e),a(s,ks,e),c($,s,e),a(s,Zs,e),c(Z,s,e),a(s,Cs,e),a(s,C,e),a(s,Us,e),c(U,s,e),a(s,Hs,e),a(s,H,e),a(s,Rs,e),c(R,s,e),a(s,Fs,e),c(F,s,e),a(s,Vs,e),a(s,V,e),a(s,Ls,e),c(L,s,e),a(s,Ns,e),a(s,N,e),a(s,Gs,e),c(G,s,e),a(s,zs,e),a(s,z,e),a(s,Qs,e),a(s,Q,e),a(s,Es,e),c(E,s,e),a(s,Is,e),c(I,s,e),a(s,Bs,e),a(s,B,e),a(s,Xs,e),a(s,X,e),a(s,Ps,e),c(P,s,e),a(s,Ss,e),a(s,S,e),a(s,Ys,e),a(s,Y,e),a(s,As,e),c(A,s,e),a(s,Ks,e),a(s,K,e),a(s,qs,e),c(q,s,e),a(s,Ds,e),a(s,D,e),a(s,Os,e),c(O,s,e),a(s,se,e),c(x,s,e),a(s,ee,e),c(ss,s,e),a(s,te,e),a(s,es,e),a(s,ae,e),a(s,ts,e),a(s,ne,e),c(as,s,e),a(s,le,e),a(s,ns,e),a(s,pe,e),a(s,w,e),a(s,ie,e),a(s,ls,e),a(s,re,e),c(ps,s,e),a(s,me,e),a(s,is,e),a(s,ce,e),c(rs,s,e),a(s,oe,e),a(s,ms,e),a(s,he,e),c(cs,s,e),a(s,ge,e),a(s,os,e),a(s,de,e),c(hs,s,e),a(s,fe,e),a(s,gs,e),a(s,ue,e),c(ds,s,e),a(s,je,e),a(s,fs,e),a(s,be,e),c(us,s,e),a(s,$e,e),a(s,$s,e),xe=!0},p(s,[e]){const Se={};e&2&&(Se.$$scope={dirty:e,ctx:s}),$.$set(Se);const Ye={};e&2&&(Ye.$$scope={dirty:e,ctx:s}),x.$set(Ye)},i(s){xe||(o(M.$$.fragment,s),o(T.$$.fragment,s),o(v.$$.fragment,s),o(k.$$.fragment,s),o($.$$.fragment,s),o(Z.$$.fragment,s),o(U.$$.fragment,s),o(R.$$.fragment,s),o(F.$$.fragment,s),o(L.$$.fragment,s),o(G.$$.fragment,s),o(E.$$.fragment,s),o(I.$$.fragment,s),o(P.$$.fragment,s),o(A.$$.fragment,s),o(q.$$.fragment,s),o(O.$$.fragment,s),o(x.$$.fragment,s),o(ss.$$.fragment,s),o(as.$$.fragment,s),o(ps.$$.fragment,s),o(rs.$$.fragment,s),o(cs.$$.fragment,s),o(hs.$$.fragment,s),o(ds.$$.fragment,s),o(us.$$.fragment,s),xe=!0)},o(s){h(M.$$.fragment,s),h(T.$$.fragment,s),h(v.$$.fragment,s),h(k.$$.fragment,s),h($.$$.fragment,s),h(Z.$$.fragment,s),h(U.$$.fragment,s),h(R.$$.fragment,s),h(F.$$.fragment,s),h(L.$$.fragment,s),h(G.$$.fragment,s),h(E.$$.fragment,s),h(I.$$.fragment,s),h(P.$$.fragment,s),h(A.$$.fragment,s),h(q.$$.fragment,s),h(O.$$.fragment,s),h(x.$$.fragment,s),h(ss.$$.fragment,s),h(as.$$.fragment,s),h(ps.$$.fragment,s),h(rs.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(ds.$$.fragment,s),h(us.$$.fragment,s),xe=!1},d(s){s&&(t(j),t(b),t(ws),t(Ms),t(y),t(ys),t(_),t(_s),t(Ts),t(vs),t(J),t(Js),t(W),t(Ws),t(ks),t(Zs),t(Cs),t(C),t(Us),t(Hs),t(H),t(Rs),t(Fs),t(Vs),t(V),t(Ls),t(Ns),t(N),t(Gs),t(zs),t(z),t(Qs),t(Q),t(Es),t(Is),t(Bs),t(B),t(Xs),t(X),t(Ps),t(Ss),t(S),t(Ys),t(Y),t(As),t(Ks),t(K),t(qs),t(Ds),t(D),t(Os),t(se),t(ee),t(te),t(es),t(ae),t(ts),t(ne),t(le),t(ns),t(pe),t(w),t(ie),t(ls),t(re),t(me),t(is),t(ce),t(oe),t(ms),t(he),t(ge),t(os),t(de),t(fe),t(gs),t(ue),t(je),t(fs),t(be),t($e),t($s)),t(f),g(M,s),g(T,s),g(v,s),g(k,s),g($,s),g(Z,s),g(U,s),g(R,s),g(F,s),g(L,s),g(G,s),g(E,s),g(I,s),g(P,s),g(A,s),g(q,s),g(O,s),g(x,s),g(ss,s),g(as,s),g(ps,s),g(rs,s),g(cs,s),g(hs,s),g(ds,s),g(us,s)}}}const mt='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Load a Pretrained Model","local":"load-a-pretrained-model","sections":[],"depth":2},{"title":"List Models with Pretrained Weights","local":"list-models-with-pretrained-weights","sections":[],"depth":2},{"title":"Fine-Tune a Pretrained Model","local":"fine-tune-a-pretrained-model","sections":[],"depth":2},{"title":"Use a Pretrained Model for Feature Extraction","local":"use-a-pretrained-model-for-feature-extraction","sections":[],"depth":2},{"title":"Image Augmentation","local":"image-augmentation","sections":[],"depth":2},{"title":"Using Pretrained Models for Inference","local":"using-pretrained-models-for-inference","sections":[],"depth":2}],"depth":1}';function ct(bs){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ut extends tt{constructor(f){super(),at(this,f,ct,rt,Oe,{})}}export{ut as component};
