import{s as fe,n as we,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as be,i as Te,g as l,s as o,u as c,A as ve,h as n,f as e,c as i,j as h,v as g,y as m,k as p,o as r,a,w as d,d as M,t as u,x as y}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ue(Ft){let j,mt,at,ct,f,v,lt,$,Qt,q,zt="Deep Layer Aggregation",gt,Z,Dt="Extending  “shallow” skip connections, <strong>Dense Layer Aggregation (DLA)</strong> incorporates more depth and sharing. The authors introduce two structures for deep layer aggregation (DLA): iterative deep aggregation (IDA) and hierarchical deep aggregation (HDA). These structures are expressed through an architectural framework, independent of the choice of backbone, for compatibility with current and future networks.",dt,A,Lt="IDA focuses on fusing resolutions and scales while HDA focuses on merging features from all modules and channels. IDA follows the base hierarchy to refine resolution and aggregate scale stage-bystage. HDA assembles its own hierarchy of tree-structured connections that cross and merge stages to aggregate different levels of representation.",Mt,w,U,nt,I,Yt,K,Pt="How do I use this model on an image?",ut,E,qt="To load a pretrained model:",yt,N,jt,_,Kt="To load and preprocess the image:",ft,W,wt,B,Ot="To get the model predictions:",Jt,G,bt,X,te="To get the top-5 predictions class names:",Tt,R,vt,Q,ee="Replace the model name with the variant you want to use, e.g. <code>dla102</code>. You can find the IDs in the model summaries at the top of this page.",Ut,Y,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',xt,J,x,ot,S,St,O,ae="How do I finetune this model?",Ct,V,le="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",kt,H,$t,F,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Zt,b,C,it,z,Vt,tt,oe="How do I train this model?",At,D,ie='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',It,T,k,pt,L,Ht,et,pe="Citation",Et,P,Nt,rt,_t;return $=new ht({}),I=new ht({}),N=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RsYTEwMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),W=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new ht({}),H=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZGxhMTAyJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dla102&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new ht({}),L=new ht({}),P=new st({props:{code:"JTQwbWlzYyU3Qnl1MjAxOWRlZXAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QkRlZXAlMjBMYXllciUyMEFnZ3JlZ2F0aW9uJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRmlzaGVyJTIwWXUlMjBhbmQlMjBEZXF1YW4lMjBXYW5nJTIwYW5kJTIwRXZhbiUyMFNoZWxoYW1lciUyMGFuZCUyMFRyZXZvciUyMERhcnJlbGwlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDY0ODQlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{yu2019deep,
      title={Deep Layer Aggregation}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Fisher Yu and Dequan Wang and Evan Shelhamer and Trevor Darrell}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1707.06484}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){j=l("meta"),mt=o(),at=l("p"),ct=o(),f=l("h1"),v=l("a"),lt=l("span"),c($.$$.fragment),Qt=o(),q=l("span"),q.textContent=zt,gt=o(),Z=l("p"),Z.innerHTML=Dt,dt=o(),A=l("p"),A.textContent=Lt,Mt=o(),w=l("h2"),U=l("a"),nt=l("span"),c(I.$$.fragment),Yt=o(),K=l("span"),K.textContent=Pt,ut=o(),E=l("p"),E.textContent=qt,yt=o(),c(N.$$.fragment),jt=o(),_=l("p"),_.textContent=Kt,ft=o(),c(W.$$.fragment),wt=o(),B=l("p"),B.textContent=Ot,Jt=o(),c(G.$$.fragment),bt=o(),X=l("p"),X.textContent=te,Tt=o(),c(R.$$.fragment),vt=o(),Q=l("p"),Q.innerHTML=ee,Ut=o(),Y=l("p"),Y.innerHTML=se,xt=o(),J=l("h2"),x=l("a"),ot=l("span"),c(S.$$.fragment),St=o(),O=l("span"),O.textContent=ae,Ct=o(),V=l("p"),V.textContent=le,kt=o(),c(H.$$.fragment),$t=o(),F=l("p"),F.innerHTML=ne,Zt=o(),b=l("h2"),C=l("a"),it=l("span"),c(z.$$.fragment),Vt=o(),tt=l("span"),tt.textContent=oe,At=o(),D=l("p"),D.innerHTML=ie,It=o(),T=l("h2"),k=l("a"),pt=l("span"),c(L.$$.fragment),Ht=o(),et=l("span"),et.textContent=pe,Et=o(),c(P.$$.fragment),Nt=o(),rt=l("p"),this.h()},l(t){const s=ve("svelte-1phssyn",document.head);j=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=i(t),at=n(t,"P",{}),h(at).forEach(e),ct=i(t),f=n(t,"H1",{class:!0});var Wt=h(f);v=n(Wt,"A",{id:!0,class:!0,href:!0});var re=h(v);lt=n(re,"SPAN",{});var he=h(lt);g($.$$.fragment,he),he.forEach(e),re.forEach(e),Qt=i(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-buffmu"&&(q.textContent=zt),Wt.forEach(e),gt=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-ztimnn"&&(Z.innerHTML=Dt),dt=i(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-148crxx"&&(A.textContent=Lt),Mt=i(t),w=n(t,"H2",{class:!0});var Bt=h(w);U=n(Bt,"A",{id:!0,class:!0,href:!0});var me=h(U);nt=n(me,"SPAN",{});var ce=h(nt);g(I.$$.fragment,ce),ce.forEach(e),me.forEach(e),Yt=i(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1c1hspn"&&(K.textContent=Pt),Bt.forEach(e),ut=i(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-18ywhxh"&&(E.textContent=qt),yt=i(t),g(N.$$.fragment,t),jt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1c2ipa8"&&(_.textContent=Kt),ft=i(t),g(W.$$.fragment,t),wt=i(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1n9qsq1"&&(B.textContent=Ot),Jt=i(t),g(G.$$.fragment,t),bt=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-19cnvx1"&&(X.textContent=te),Tt=i(t),g(R.$$.fragment,t),vt=i(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-16eylps"&&(Q.innerHTML=ee),Ut=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=se),xt=i(t),J=n(t,"H2",{class:!0});var Gt=h(J);x=n(Gt,"A",{id:!0,class:!0,href:!0});var ge=h(x);ot=n(ge,"SPAN",{});var de=h(ot);g(S.$$.fragment,de),de.forEach(e),ge.forEach(e),St=i(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1viv4qv"&&(O.textContent=ae),Gt.forEach(e),Ct=i(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-9sr7nh"&&(V.textContent=le),kt=i(t),g(H.$$.fragment,t),$t=i(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1kguc51"&&(F.innerHTML=ne),Zt=i(t),b=n(t,"H2",{class:!0});var Xt=h(b);C=n(Xt,"A",{id:!0,class:!0,href:!0});var Me=h(C);it=n(Me,"SPAN",{});var ue=h(it);g(z.$$.fragment,ue),ue.forEach(e),Me.forEach(e),Vt=i(Xt),tt=n(Xt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1ce591d"&&(tt.textContent=oe),Xt.forEach(e),At=i(t),D=n(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1n0coha"&&(D.innerHTML=ie),It=i(t),T=n(t,"H2",{class:!0});var Rt=h(T);k=n(Rt,"A",{id:!0,class:!0,href:!0});var ye=h(k);pt=n(ye,"SPAN",{});var je=h(pt);g(L.$$.fragment,je),je.forEach(e),ye.forEach(e),Ht=i(Rt),et=n(Rt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-15mb3gy"&&(et.textContent=pe),Rt.forEach(e),Et=i(t),g(P.$$.fragment,t),Nt=i(t),rt=n(t,"P",{}),h(rt).forEach(e),this.h()},h(){p(j,"name","hf:doc:metadata"),p(j,"content",JSON.stringify(xe)),p(v,"id","deep-layer-aggregation"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#deep-layer-aggregation"),p(f,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(w,"class","relative group"),p(x,"id","how-do-i-finetune-this-model"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#how-do-i-finetune-this-model"),p(J,"class","relative group"),p(C,"id","how-do-i-train-this-model"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(k,"id","citation"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,j),a(t,mt,s),a(t,at,s),a(t,ct,s),a(t,f,s),r(f,v),r(v,lt),d($,lt,null),r(f,Qt),r(f,q),a(t,gt,s),a(t,Z,s),a(t,dt,s),a(t,A,s),a(t,Mt,s),a(t,w,s),r(w,U),r(U,nt),d(I,nt,null),r(w,Yt),r(w,K),a(t,ut,s),a(t,E,s),a(t,yt,s),d(N,t,s),a(t,jt,s),a(t,_,s),a(t,ft,s),d(W,t,s),a(t,wt,s),a(t,B,s),a(t,Jt,s),d(G,t,s),a(t,bt,s),a(t,X,s),a(t,Tt,s),d(R,t,s),a(t,vt,s),a(t,Q,s),a(t,Ut,s),a(t,Y,s),a(t,xt,s),a(t,J,s),r(J,x),r(x,ot),d(S,ot,null),r(J,St),r(J,O),a(t,Ct,s),a(t,V,s),a(t,kt,s),d(H,t,s),a(t,$t,s),a(t,F,s),a(t,Zt,s),a(t,b,s),r(b,C),r(C,it),d(z,it,null),r(b,Vt),r(b,tt),a(t,At,s),a(t,D,s),a(t,It,s),a(t,T,s),r(T,k),r(k,pt),d(L,pt,null),r(T,Ht),r(T,et),a(t,Et,s),d(P,t,s),a(t,Nt,s),a(t,rt,s),_t=!0},p:we,i(t){_t||(M($.$$.fragment,t),M(I.$$.fragment,t),M(N.$$.fragment,t),M(W.$$.fragment,t),M(G.$$.fragment,t),M(R.$$.fragment,t),M(S.$$.fragment,t),M(H.$$.fragment,t),M(z.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),_t=!0)},o(t){u($.$$.fragment,t),u(I.$$.fragment,t),u(N.$$.fragment,t),u(W.$$.fragment,t),u(G.$$.fragment,t),u(R.$$.fragment,t),u(S.$$.fragment,t),u(H.$$.fragment,t),u(z.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),_t=!1},d(t){t&&(e(mt),e(at),e(ct),e(f),e(gt),e(Z),e(dt),e(A),e(Mt),e(w),e(ut),e(E),e(yt),e(jt),e(_),e(ft),e(wt),e(B),e(Jt),e(bt),e(X),e(Tt),e(vt),e(Q),e(Ut),e(Y),e(xt),e(J),e(Ct),e(V),e(kt),e($t),e(F),e(Zt),e(b),e(At),e(D),e(It),e(T),e(Et),e(Nt),e(rt)),e(j),y($),y(I),y(N,t),y(W,t),y(G,t),y(R,t),y(S),y(H,t),y(z),y(L),y(P,t)}}}const xe={local:"deep-layer-aggregation",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Deep Layer Aggregation"};function Ce(Ft){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends be{constructor(j){super(),Te(this,j,Ce,Ue,fe,{})}}export{Ie as component};
