import{s as rs,n as os,o as is}from"../chunks/scheduler.85c25b89.js";import{S as ls,i as ss,g as a,s as r,r as d,A as ms,h as n,f as i,c as o,j as m,u as c,x as l,k as v,y as t,a as p,v as g,d as u,t as f,w as h}from"../chunks/index.c9837788.js";import{D as b}from"../chunks/Docstring.5c1d567f.js";import{H as j,E as ps}from"../chunks/EditOnGithub.b65eee75.js";function ds(fi){let Q,hn,tn,vn,be,bn,ye,hi="This page contains the API reference documentation for learning rate optimizers included in <code>timm</code>.",yn,_e,_n,xe,xn,y,$e,br,Lt,vi="Create an optimizer instance via timm registry.",yr,At,bi=`Creates and configures an optimizer with appropriate parameter groups and settings.
Supports automatic parameter group creation for weight decay and layer-wise learning
rates, as well as custom parameter grouping.`,_r,Tt,yi="Examples:",xr,an,nn,we,Ce,$r,zt,_i="optimizer = create_optimizer_v2(model, ‘adamw’, lr=1e-3)",wr,rn,on,Le,Ae,Cr,Dt,xi=`optimizer = create_optimizer_v2(
…     model, ‘sgd’, lr=0.1, momentum=0.9, weight_decay=1e-4
… )`,Lr,ln,sn,Te,ze,Ar,Pt,$i=`optimizer = create_optimizer_v2(
…     model, ‘adam’, lr=1e-3, layer_decay=0.7
… )`,Tr,mn,pn,De,Pe,zr,Mt,wi=`def group_fn(model):
…     return [
…         {‘params’: model.backbone.parameters(), ‘lr’: 1e-4},
…         {‘params’: model.head.parameters(), ‘lr’: 1e-3}
…     ]
optimizer = create_optimizer_v2(
…     model, ‘sgd’, param_group_fn=group_fn
… )`,Dr,kt,Ci=`Note:
Parameter group handling precedence:`,Pr,It,Li="<li>If param_group_fn is provided, it will be used exclusively</li> <li>If layer_decay is provided, layer-wise groups will be created</li> <li>If weight_decay &gt; 0 and filter_bias_and_bn is True, weight decay groups will be created</li> <li>Otherwise, all parameters will be in a single group</li>",$n,_,Me,Mr,qt,Ai="List available optimizer names, optionally filtered.",kr,Et,Ti=`List all registered optimizers, with optional filtering using wildcard patterns.
Optimizers can be filtered using include and exclude patterns, and can optionally
return descriptions with each optimizer name.`,Ir,Ot,zi="Examples:",qr,Nt,Di=`<blockquote><blockquote><p>list_optimizers()
[‘adam’, ‘adamw’, ‘sgd’, …]</p></blockquote></blockquote>`,Er,Ft,Pi=`<blockquote><blockquote><p>list_optimizers([‘la<em>’, ‘nla</em>’])  # List lamb &amp; lars
[‘lamb’, ‘lambc’, ‘larc’, ‘lars’, ‘nlarc’, ‘nlars’]</p></blockquote></blockquote>`,Or,Ht,Mi=`<blockquote><blockquote><p>list_optimizers(’<em>adam</em>’, exclude_filters=[‘bnb<em>’, ‘fused</em>’])  # Exclude bnb &amp; apex adam optimizers
[‘adam’, ‘adamax’, ‘adamp’, ‘adamw’, ‘nadam’, ‘nadamw’, ‘radam’]</p></blockquote></blockquote>`,Nr,Bt,ki=`<blockquote><blockquote><p>list_optimizers(with_description=True)  # Get descriptions
[(‘adabelief’, ‘Adapts learning rate based on gradient prediction error’),
(‘adadelta’, ‘torch.optim Adadelta, Adapts learning rates based on running windows of gradients’),
(‘adafactor’, ‘Memory-efficient implementation of Adam with factored gradients’),
…]</p></blockquote></blockquote>`,wn,L,ke,Fr,Gt,Ii="Get optimizer class by name with option to bind default arguments.",Hr,St,qi=`Retrieves the optimizer class or a partial function with default arguments bound.
This allows direct instantiation of optimizers with their default configurations
without going through the full factory.`,Br,Rt,Ei="Examples:",Gr,dn,cn,Ie,qe,Sr,Vt,Oi=`SGD = get_optimizer_class(‘sgd’)  # nesterov=True bound
opt = SGD(model.parameters(), lr=0.1, momentum=0.9)`,Rr,gn,un,Ee,Oe,Vr,Ut,Ni=`SGD = get_optimizer_class(‘sgd’)
opt = SGD(model.parameters(), lr=1e-3, momentum=0.9)`,Cn,Ne,Ln,A,Fe,Ur,Wt,Fi="Implements AdaBelief algorithm. Modified from Adam in PyTorch",Wr,jt,Hi="reference: AdaBelief Optimizer, adapting stepsizes by the belief in observed gradients, NeurIPS 2020",jr,Qt,Bi=`For a complete table of recommended hyperparameters, see <a href="https://github.com/juntang-zhuang/Adabelief-Optimizer&#39;" rel="nofollow">https://github.com/juntang-zhuang/Adabelief-Optimizer’</a>
For example train/args for EfficientNet see these gists`,Qr,Kt,Gi='<li>link to train_scipt: <a href="https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037" rel="nofollow">https://gist.github.com/juntang-zhuang/0a501dd51c02278d952cf159bc233037</a></li> <li>link to args.yaml: <a href="https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3" rel="nofollow">https://gist.github.com/juntang-zhuang/517ce3c27022b908bb93f78e4f786dc3</a></li>',Kr,Z,He,Zr,Zt,Si="Performs a single optimization step.",An,w,Be,Xr,Xt,Ri="Implements Adafactor algorithm.",Jr,Jt,Vi=`This implementation is based on: <code>Adafactor: Adaptive Learning Rates with Sublinear Memory Cost</code>
(see <a href="https://arxiv.org/abs/1804.04235" rel="nofollow">https://arxiv.org/abs/1804.04235</a>)`,Yr,Yt,Ui=`Note that this optimizer internally adjusts the learning rate depending on the
<em>scale_parameter</em>, <em>relative_step</em> and <em>warmup_init</em> options.`,eo,ea,Wi=`To use a manual (external) learning rate schedule you should set <code>scale_parameter=False</code> and
<code>relative_step=False</code>.`,to,ta,ji=`Ags:
params: iterable of parameters to optimize or dicts defining parameter groups
lr: external learning rate
eps: regularization constants for square gradient and parameter scale respectively
eps_scale: regularization constants for parameter scale respectively
clip_threshold: threshold of root-mean-square of final gradient update
decay_rate: coefficient used to compute running averages of square gradient
beta1: coefficient used for computing running averages of gradient
weight_decay: weight decay
scale_parameter: if True, learning rate is scaled by root-mean-square of parameter
warmup_init: time-dependent learning rate computation depends on whether warm-up initialization is being used`,ao,X,Ge,no,aa,Qi="Performs a single optimization step.",Tn,S,Se,ro,na,Ki="PyTorch implementation of BigVision’s Adafactor variant with both single and multi tensor implementations.",oo,ra,Zi='Adapted from <a href="https://github.com/google-research/big_vision" rel="nofollow">https://github.com/google-research/big_vision</a> by Ross Wightman',zn,T,Re,io,oa,Xi="Implements the AdaHessian algorithm from “ADAHESSIAN: An Adaptive Second OrderOptimizer for Machine Learning”",lo,J,Ve,so,ia,Ji="Gets all parameters in all param_groups with gradients",mo,Y,Ue,po,la,Yi="Computes the Hutchinson approximation of the hessian trace and accumulates it for each trainable parameter.",co,ee,We,go,sa,el="Performs a single optimization step.",uo,te,je,fo,ma,tl="Zeros out the accumalated hessian traces.",Dn,Qe,Ke,Pn,q,Ze,ho,pa,al="Implements a pytorch variant of Adan.",vo,da,nl=`Adan was proposed in Adan: Adaptive Nesterov Momentum Algorithm for Faster Optimizing Deep Models
<a href="https://arxiv.org/abs/2208.06677" rel="nofollow">https://arxiv.org/abs/2208.06677</a>`,bo,ae,Xe,yo,ca,rl="Performs a single optimization step.",Mn,R,Je,_o,ga,ol='ADOPT: Modified Adam Can Converge with Any β2 with the Optimal Rate: <a href="https://arxiv.org/abs/2411.02853" rel="nofollow">https://arxiv.org/abs/2411.02853</a>',xo,ne,Ye,$o,ua,il="Perform a single optimization step.",kn,M,et,wo,fa,ll=`Implements a pure pytorch variant of FuseLAMB (NvLamb variant) optimizer from apex.optimizers.FusedLAMB
reference: <a href="https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py" rel="nofollow">https://github.com/NVIDIA/DeepLearningExamples/blob/master/PyTorch/LanguageModeling/Transformer-XL/pytorch/lamb.py</a>`,Co,ha,sl="LAMB was proposed in:",Lo,va,ml='<li>Large Batch Optimization for Deep Learning - Training BERT in 76 minutes:  <a href="https://arxiv.org/abs/1904.00962" rel="nofollow">https://arxiv.org/abs/1904.00962</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',Ao,re,tt,To,ba,pl="Performs a single optimization step.",In,E,at,zo,ya,dl="LaProp Optimizer",Do,_a,cl='Paper: LaProp: Separating Momentum and Adaptivity in Adam, <a href="https://arxiv.org/abs/2002.04839" rel="nofollow">https://arxiv.org/abs/2002.04839</a>',Po,oe,nt,Mo,xa,gl="Performs a single optimization step.",qn,O,rt,ko,$a,ul="LARS for PyTorch",Io,wa,fl='Paper: <code>Large batch training of Convolutional Networks</code> - <a href="https://arxiv.org/pdf/1708.03888.pdf" rel="nofollow">https://arxiv.org/pdf/1708.03888.pdf</a>',qo,ie,ot,Eo,Ca,hl="Performs a single optimization step.",En,V,it,Oo,La,vl="Implements Lion algorithm.",No,le,lt,Fo,Aa,bl="Performs a single optimization step.",On,st,mt,Nn,C,pt,Ho,Ta,yl=`MADGRAD_: A Momentumized, Adaptive, Dual Averaged Gradient Method for Stochastic
Optimization.`,Bo,za,_l='.. _MADGRAD: <a href="https://arxiv.org/abs/2101.11075" rel="nofollow">https://arxiv.org/abs/2101.11075</a>',Go,Da,xl=`MADGRAD is a general purpose optimizer that can be used in place of SGD or
Adam may converge faster and generalize better. Currently GPU-only.
Typically, the same learning rate schedule that is used for SGD or Adam may
be used. The overall learning rate is not comparable to either method and
should be determined by a hyper-parameter sweep.`,So,Pa,$l=`MADGRAD requires less weight decay than other methods, often as little as
zero. Momentum values used for SGD or Adam’s beta1 should work here also.`,Ro,Ma,wl="On sparse problems both weight_decay and momentum should be set to 0.",Vo,se,dt,Uo,ka,Cl="Performs a single optimization step.",Fn,N,ct,Wo,Ia,Ll="MARS Optimizer",jo,qa,Al=`Paper: MARS: Unleashing the Power of Variance Reduction for Training Large Models
<a href="https://arxiv.org/abs/2411.10438" rel="nofollow">https://arxiv.org/abs/2411.10438</a>`,Qo,me,gt,Ko,Ea,Tl="Performs a single optimization step.",Hn,z,ut,Zo,Oa,zl="Implements NAdamW algorithm.",Xo,Na,Dl=`See Table 1 in <a href="https://arxiv.org/abs/1910.05446" rel="nofollow">https://arxiv.org/abs/1910.05446</a> for the implementation of
the NAdam algorithm (there is also a comment in the code which highlights
the only difference of NAdamW and AdamW).`,Jo,Fa,Pl="For further details regarding the algorithm we refer to",Yo,Ha,Ml='<li>Decoupled Weight Decay Regularization: <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a></li> <li>On the Convergence of Adam and Beyond: <a href="https://openreview.net/forum?id=ryQu7f-RZ" rel="nofollow">https://openreview.net/forum?id=ryQu7f-RZ</a></li>',ei,pe,ft,ti,Ba,kl="Performs a single optimization step.",Bn,U,ht,ai,Ga,Il="Implements Novograd algorithm.",ni,de,vt,ri,Sa,ql="Performs a single optimization step.",Gn,x,bt,oi,Ra,El="Implements RMSprop algorithm (TensorFlow style epsilon)",ii,Va,Ol=`NOTE: This is a direct cut-and-paste of PyTorch RMSprop with eps applied before sqrt
and a few other modifications to closer match Tensorflow for matching hyper-params.`,li,Ua,Nl="Noteworthy changes include:",si,Wa,Fl="<li>Epsilon applied inside square-root</li> <li>square_avg initialized to ones</li> <li>LR scaling of update accumulated in momentum buffer</li>",mi,ja,Hl=`Proposed by G. Hinton in his
<a href="http://www.cs.toronto.edu/~tijmen/csc321/slides/lecture_slides_lec6.pdf" rel="nofollow">course</a>.`,pi,Qa,Bl=`The centered version first appears in <a href="https://arxiv.org/pdf/1308.0850v5.pdf" rel="nofollow">Generating Sequences
With Recurrent Neural Networks</a>.`,di,ce,yt,ci,Ka,Gl="Performs a single optimization step.",Sn,_t,xt,Rn,K,$t,gi,ge,wt,ui,Za,Sl="Performs a single optimization step.",Vn,Ct,Un,fn,Wn;return be=new j({props:{title:"Optimization",local:"optimization",headingTag:"h1"}}),_e=new j({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),xe=new j({props:{title:"Factory functions",local:"timm.optim.create_optimizer_v2",headingTag:"h3"}}),$e=new b({props:{name:"timm.optim.create_optimizer_v2",anchor:"timm.optim.create_optimizer_v2",parameters:[{name:"model_or_params",val:": typing.Union[torch.nn.modules.module.Module, typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"opt",val:": str = 'sgd'"},{name:"lr",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"momentum",val:": float = 0.9"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"filter_bias_and_bn",val:": bool = True"},{name:"layer_decay",val:": typing.Optional[float] = None"},{name:"param_group_fn",val:": typing.Optional[typing.Callable[[torch.nn.modules.module.Module], typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]]] = None"},{name:"**kwargs",val:": typing.Any"}],parametersDescription:[{anchor:"timm.optim.create_optimizer_v2.model_or_params",description:`<strong>model_or_params</strong> &#x2014; A PyTorch model or an iterable of parameters/parameter groups.
If a model is provided, parameters will be automatically extracted and grouped
based on the other arguments.`,name:"model_or_params"},{anchor:"timm.optim.create_optimizer_v2.opt",description:`<strong>opt</strong> &#x2014; Name of the optimizer to create (e.g., &#x2018;adam&#x2019;, &#x2018;adamw&#x2019;, &#x2018;sgd&#x2019;).
Use list_optimizers() to see available options.`,name:"opt"},{anchor:"timm.optim.create_optimizer_v2.lr",description:"<strong>lr</strong> &#x2014; Learning rate. If None, will use the optimizer&#x2019;s default.",name:"lr"},{anchor:"timm.optim.create_optimizer_v2.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay factor. Will be used to create param groups if model_or_params is a model.",name:"weight_decay"},{anchor:"timm.optim.create_optimizer_v2.momentum",description:`<strong>momentum</strong> &#x2014; Momentum factor for optimizers that support it. Only used if the
chosen optimizer accepts a momentum parameter.`,name:"momentum"},{anchor:"timm.optim.create_optimizer_v2.foreach",description:`<strong>foreach</strong> &#x2014; Enable/disable foreach (multi-tensor) implementation if available.
If None, will use optimizer-specific defaults.`,name:"foreach"},{anchor:"timm.optim.create_optimizer_v2.filter_bias_and_bn",description:`<strong>filter_bias_and_bn</strong> &#x2014; If True, bias, norm layer parameters (all 1d params) will not have
weight decay applied. Only used when model_or_params is a model and
weight_decay &gt; 0.`,name:"filter_bias_and_bn"},{anchor:"timm.optim.create_optimizer_v2.layer_decay",description:`<strong>layer_decay</strong> &#x2014; Optional layer-wise learning rate decay factor. If provided,
learning rates will be scaled by layer_decay^(max_depth - layer_depth).
Only used when model_or_params is a model.`,name:"layer_decay"},{anchor:"timm.optim.create_optimizer_v2.param_group_fn",description:`<strong>param_group_fn</strong> &#x2014; Optional function to create custom parameter groups.
If provided, other parameter grouping options will be ignored.`,name:"param_group_fn"},{anchor:"timm.optim.create_optimizer_v2.*kwargs",description:"*<strong>*kwargs</strong> &#x2014; Additional optimizer-specific arguments (e.g., betas for Adam).",name:"*kwargs"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/_optim_factory.py#L956",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Configured optimizer instance.</p>
`}}),Ce=new j({props:{title:"Basic usage with a model",local:"basic-usage-with-a-model",headingTag:"h1"}}),Ae=new j({props:{title:"SGD with momentum and weight decay",local:"sgd-with-momentum-and-weight-decay",headingTag:"h1"}}),ze=new j({props:{title:"Adam with layer-wise learning rate decay",local:"adam-with-layer-wise-learning-rate-decay",headingTag:"h1"}}),Pe=new j({props:{title:"Custom parameter groups",local:"custom-parameter-groups",headingTag:"h1"}}),Me=new b({props:{name:"timm.optim.list_optimizers",anchor:"timm.optim.list_optimizers",parameters:[{name:"filter",val:": typing.Union[str, typing.List[str]] = ''"},{name:"exclude_filters",val:": typing.Optional[typing.List[str]] = None"},{name:"with_description",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.list_optimizers.filter",description:`<strong>filter</strong> &#x2014; Wildcard style filter string or list of filter strings
(e.g., &#x2018;adam<em>&#x2019; for all Adam variants, or [&#x2018;adam</em>&#x2019;, &#x2018;*8bit&#x2019;] for
Adam variants and 8-bit optimizers). Empty string means no filtering.`,name:"filter"},{anchor:"timm.optim.list_optimizers.exclude_filters",description:`<strong>exclude_filters</strong> &#x2014; Optional list of wildcard patterns to exclude. For example,
[&#x2019;<em>8bit&#x2019;, &#x2018;fused</em>&#x2019;] would exclude 8-bit and fused implementations.`,name:"exclude_filters"},{anchor:"timm.optim.list_optimizers.with_description",description:`<strong>with_description</strong> &#x2014; If True, returns tuples of (name, description) instead of
just names. Descriptions provide brief explanations of optimizer characteristics.`,name:"with_description"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/_optim_factory.py#L859",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of optimizer names as strings (e.g., [‘adam’, ‘adamw’, …])
If with_description is True:
List of tuples of (name, description) (e.g., [(‘adam’, ‘Adaptive Moment…’), …])</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If with_description is False</p>
`}}),ke=new b({props:{name:"timm.optim.get_optimizer_class",anchor:"timm.optim.get_optimizer_class",parameters:[{name:"name",val:": str"},{name:"bind_defaults",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.get_optimizer_class.name",description:"<strong>name</strong> &#x2014; Name of the optimizer to retrieve (e.g., &#x2018;adam&#x2019;, &#x2018;sgd&#x2019;)",name:"name"},{anchor:"timm.optim.get_optimizer_class.bind_defaults",description:`<strong>bind_defaults</strong> &#x2014; If True, returns a partial function with default arguments from OptimInfo bound.
If False, returns the raw optimizer class.`,name:"bind_defaults"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/_optim_factory.py#L919",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The optimizer class (e.g., torch.optim.Adam)
If bind_defaults is True:
A partial function with default arguments bound</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If bind_defaults is False</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> — If optimizer name is not found in registry</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code></p>
`}}),qe=new j({props:{title:"Get SGD with nesterov momentum default",local:"get-sgd-with-nesterov-momentum-default",headingTag:"h1"}}),Oe=new j({props:{title:"Get raw optimizer class",local:"get-raw-optimizer-class",headingTag:"h1"}}),Ne=new j({props:{title:"Optimizer Classes",local:"timm.optim.AdaBelief",headingTag:"h3"}}),Fe=new b({props:{name:"class timm.optim.AdaBelief",anchor:"timm.optim.AdaBelief",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-16"},{name:"weight_decay",val:" = 0"},{name:"amsgrad",val:" = False"},{name:"decoupled_decay",val:" = True"},{name:"fixed_decay",val:" = False"},{name:"rectify",val:" = True"},{name:"degenerated_to_sgd",val:" = True"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.AdaBelief.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.AdaBelief.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.AdaBelief.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-16)`,name:"eps"},{anchor:"timm.optim.AdaBelief.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.AdaBelief.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"},{anchor:"timm.optim.AdaBelief.decoupled_decay",description:`<strong>decoupled_decay</strong> (boolean, optional) &#x2014; (default: True) If set as True, then
the optimizer uses decoupled weight decay as in AdamW`,name:"decoupled_decay"},{anchor:"timm.optim.AdaBelief.fixed_decay",description:`<strong>fixed_decay</strong> (boolean, optional) &#x2014; (default: False) This is used when weight<em>decouple
is set as True.
When fixed_decay == True, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay$.
When fixed<em>decay == False, the weight decay is performed as
$W</em>{new} = W<em>{old} - W</em>{old} \\times decay \\times lr$. Note that in this case, the
weight decay ratio decreases with learning rate (lr).`,name:"fixed_decay"},{anchor:"timm.optim.AdaBelief.rectify",description:`<strong>rectify</strong> (boolean, optional) &#x2014; (default: True) If set as True, then perform the rectified
update similar to RAdam`,name:"rectify"},{anchor:"timm.optim.AdaBelief.degenerated_to_sgd",description:`<strong>degenerated_to_sgd</strong> (boolean, optional) (default &#x2014;True) If set as True, then perform SGD update
when variance of gradient is high`,name:"degenerated_to_sgd"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adabelief.py#L6"}}),He=new b({props:{name:"step",anchor:"timm.optim.AdaBelief.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.AdaBelief.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adabelief.py#L106"}}),Be=new b({props:{name:"class timm.optim.Adafactor",anchor:"timm.optim.Adafactor",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": typing.Optional[float] = None"},{name:"eps",val:": float = 1e-30"},{name:"eps_scale",val:": float = 0.001"},{name:"clip_threshold",val:": float = 1.0"},{name:"decay_rate",val:": float = -0.8"},{name:"betas",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"scale_parameter",val:": bool = True"},{name:"warmup_init",val:": bool = False"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adafactor.py#L21"}}),Ge=new b({props:{name:"step",anchor:"timm.optim.Adafactor.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adafactor.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adafactor.py#L127"}}),Se=new b({props:{name:"class timm.optim.AdafactorBigVision",anchor:"timm.optim.AdafactorBigVision",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 1.0"},{name:"min_dim_size_to_factor",val:": int = 16"},{name:"decay_rate",val:": float = 0.8"},{name:"decay_offset",val:": int = 0"},{name:"beta2_cap",val:": float = 0.999"},{name:"momentum",val:": typing.Optional[float] = 0.9"},{name:"momentum_dtype",val:": typing.Union[str, torch.dtype] = torch.bfloat16"},{name:"eps",val:": typing.Optional[float] = None"},{name:"weight_decay",val:": float = 0.0"},{name:"clipping_threshold",val:": typing.Optional[float] = None"},{name:"unscaled_wd",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adafactor_bv.py#L49"}}),Re=new b({props:{name:"class timm.optim.Adahessian",anchor:"timm.optim.Adahessian",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.1"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0.0"},{name:"hessian_power",val:" = 1.0"},{name:"update_each",val:" = 1"},{name:"n_samples",val:" = 1"},{name:"avg_conv_kernel",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Adahessian.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.Adahessian.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 0.1)",name:"lr"},{anchor:"timm.optim.Adahessian.betas",description:`<strong>betas</strong> ((float, float), optional) &#x2014; coefficients used for computing running averages of gradient and the
squared hessian trace (default: (0.9, 0.999))`,name:"betas"},{anchor:"timm.optim.Adahessian.eps",description:"<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve numerical stability (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Adahessian.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0.0)",name:"weight_decay"},{anchor:"timm.optim.Adahessian.hessian_power",description:"<strong>hessian_power</strong> (float, optional) &#x2014; exponent of the hessian trace (default: 1.0)",name:"hessian_power"},{anchor:"timm.optim.Adahessian.update_each",description:`<strong>update_each</strong> (int, optional) &#x2014; compute the hessian trace approximation only after <em>this</em> number of steps
(to save time) (default: 1)`,name:"update_each"},{anchor:"timm.optim.Adahessian.n_samples",description:"<strong>n_samples</strong> (int, optional) &#x2014; how many times to sample <code>z</code> for the approximation of the hessian trace (default: 1)",name:"n_samples"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adahessian.py#L9"}}),Ve=new b({props:{name:"get_params",anchor:"timm.optim.Adahessian.get_params",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adahessian.py#L74"}}),Ue=new b({props:{name:"set_hessian",anchor:"timm.optim.Adahessian.set_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adahessian.py#L90"}}),We=new b({props:{name:"step",anchor:"timm.optim.Adahessian.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adahessian.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; a closure that reevaluates the model and returns the loss (default &#x2014; None)",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adahessian.py#L118"}}),je=new b({props:{name:"zero_hessian",anchor:"timm.optim.Adahessian.zero_hessian",parameters:[],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adahessian.py#L81"}}),Ke=new b({props:{name:"class timm.optim.AdamP",anchor:"timm.optim.AdamP",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.9, 0.999)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"},{name:"nesterov",val:" = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adamp.py#L43"}}),Ze=new b({props:{name:"class timm.optim.Adan",anchor:"timm.optim.Adan",parameters:[{name:"params",val:""},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float, float] = (0.98, 0.92, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"no_prox",val:": bool = False"},{name:"foreach",val:": bool = True"}],parametersDescription:[{anchor:"timm.optim.Adan.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Adan.lr",description:"<strong>lr</strong> &#x2014; Learning rate.",name:"lr"},{anchor:"timm.optim.Adan.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for first- and second-order moments.",name:"betas"},{anchor:"timm.optim.Adan.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Adan.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Decoupled weight decay (L2 penalty)",name:"weight_decay"},{anchor:"timm.optim.Adan.no_prox",description:"<strong>no_prox</strong> &#x2014; How to perform the weight decay",name:"no_prox"},{anchor:"timm.optim.Adan.foreach",description:"<strong>foreach</strong> &#x2014; If True would use torch._foreach implementation. Faster but uses slightly more memory.",name:"foreach"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adan.py#L46"}}),Xe=new b({props:{name:"step",anchor:"timm.optim.Adan.step",parameters:[{name:"closure",val:" = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adan.py#L113"}}),Je=new b({props:{name:"class timm.optim.Adopt",anchor:"timm.optim.Adopt",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": typing.Union[float, torch.Tensor] = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.9999)"},{name:"eps",val:": float = 1e-06"},{name:"clip_exp",val:": typing.Optional[float] = 0.333"},{name:"weight_decay",val:": float = 0.0"},{name:"decoupled",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = False"},{name:"maximize",val:": bool = False"},{name:"capturable",val:": bool = False"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adopt.py#L55"}}),Ye=new b({props:{name:"step",anchor:"timm.optim.Adopt.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Adopt.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/adopt.py#L181"}}),et=new b({props:{name:"class timm.optim.Lamb",anchor:"timm.optim.Lamb",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"bias_correction",val:": bool = True"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.01"},{name:"grad_averaging",val:": bool = True"},{name:"max_grad_norm",val:": typing.Optional[float] = 1.0"},{name:"trust_clip",val:": bool = False"},{name:"always_adapt",val:": bool = False"},{name:"caution",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.Lamb.params",description:"<strong>params</strong> &#x2014; Iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lamb.lr",description:"<strong>lr</strong> &#x2014; Learning rate",name:"lr"},{anchor:"timm.optim.Lamb.betas",description:"<strong>betas</strong> &#x2014; Coefficients used for computing running averages of gradient and its norm.",name:"betas"},{anchor:"timm.optim.Lamb.eps",description:"<strong>eps</strong> &#x2014; Term added to the denominator to improve numerical stability.",name:"eps"},{anchor:"timm.optim.Lamb.weight_decay",description:"<strong>weight_decay</strong> &#x2014; Weight decay",name:"weight_decay"},{anchor:"timm.optim.Lamb.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; Whether apply (1-beta2) to grad when calculating running averages of gradient.",name:"grad_averaging"},{anchor:"timm.optim.Lamb.max_grad_norm",description:"<strong>max_grad_norm</strong> &#x2014; Value used to clip global grad norm.",name:"max_grad_norm"},{anchor:"timm.optim.Lamb.trust_clip",description:"<strong>trust_clip</strong> &#x2014; Enable LAMBC trust ratio clipping.",name:"trust_clip"},{anchor:"timm.optim.Lamb.always_adapt",description:"<strong>always_adapt</strong> &#x2014; Apply adaptive learning rate to 0.0 weight decay parameter.",name:"always_adapt"},{anchor:"timm.optim.Lamb.caution",description:"<strong>caution</strong> &#x2014; Apply caution.",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lamb.py#L63"}}),tt=new b({props:{name:"step",anchor:"timm.optim.Lamb.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lamb.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lamb.py#L135"}}),at=new b({props:{name:"class timm.optim.LaProp",anchor:"timm.optim.LaProp",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.0004"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-15"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/laprop.py#L23"}}),nt=new b({props:{name:"step",anchor:"timm.optim.LaProp.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.LaProp.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/laprop.py#L54"}}),rt=new b({props:{name:"class timm.optim.Lars",anchor:"timm.optim.Lars",parameters:[{name:"params",val:""},{name:"lr",val:" = 1.0"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"trust_coeff",val:" = 0.001"},{name:"eps",val:" = 1e-08"},{name:"trust_clip",val:" = False"},{name:"always_adapt",val:" = False"}],parametersDescription:[{anchor:"timm.optim.Lars.params",description:"<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining parameter groups.",name:"params"},{anchor:"timm.optim.Lars.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1.0).",name:"lr"},{anchor:"timm.optim.Lars.momentum",description:"<strong>momentum</strong> (float, optional) &#x2014; momentum factor (default: 0)",name:"momentum"},{anchor:"timm.optim.Lars.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.Lars.dampening",description:"<strong>dampening</strong> (float, optional) &#x2014; dampening for momentum (default: 0)",name:"dampening"},{anchor:"timm.optim.Lars.nesterov",description:"<strong>nesterov</strong> (bool, optional) &#x2014; enables Nesterov momentum (default: False)",name:"nesterov"},{anchor:"timm.optim.Lars.trust_coeff",description:"<strong>trust_coeff</strong> (float) &#x2014; trust coefficient for computing adaptive lr / trust_ratio (default: 0.001)",name:"trust_coeff"},{anchor:"timm.optim.Lars.eps",description:"<strong>eps</strong> (float) &#x2014; eps for division denominator (default: 1e-8)",name:"eps"},{anchor:"timm.optim.Lars.trust_clip",description:"<strong>trust_clip</strong> (bool) &#x2014; enable LARC trust ratio clipping (default: False)",name:"trust_clip"},{anchor:"timm.optim.Lars.always_adapt",description:"<strong>always_adapt</strong> (bool) &#x2014; always apply LARS LR adapt, otherwise only when group weight_decay != 0 (default: False)",name:"always_adapt"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lars.py#L17"}}),ot=new b({props:{name:"step",anchor:"timm.optim.Lars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lars.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lars.py#L75"}}),it=new b({props:{name:"class timm.optim.Lion",anchor:"timm.optim.Lion",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.0001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"weight_decay",val:": float = 0.0"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lion.py#L27"}}),lt=new b({props:{name:"step",anchor:"timm.optim.Lion.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Lion.step.closure",description:"<strong>closure</strong> &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lion.py#L73",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the loss.</p>
`}}),mt=new b({props:{name:"class timm.optim.Lookahead",anchor:"timm.optim.Lookahead",parameters:[{name:"base_optimizer",val:""},{name:"alpha",val:" = 0.5"},{name:"k",val:" = 6"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/lookahead.py#L15"}}),pt=new b({props:{name:"class timm.optim.MADGRAD",anchor:"timm.optim.MADGRAD",parameters:[{name:"params",val:": typing.Any"},{name:"lr",val:": float = 0.01"},{name:"momentum",val:": float = 0.9"},{name:"weight_decay",val:": float = 0"},{name:"eps",val:": float = 1e-06"},{name:"decoupled_decay",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.params",description:`<strong>params</strong> (iterable) &#x2014;
Iterable of parameters to optimize or dicts defining parameter groups.`,name:"params"},{anchor:"timm.optim.MADGRAD.lr",description:`<strong>lr</strong> (float) &#x2014;
Learning rate (default: 1e-2).`,name:"lr"},{anchor:"timm.optim.MADGRAD.momentum",description:`<strong>momentum</strong> (float) &#x2014;
Momentum value in  the range [0,1) (default: 0.9).`,name:"momentum"},{anchor:"timm.optim.MADGRAD.weight_decay",description:`<strong>weight_decay</strong> (float) &#x2014;
Weight decay, i.e. a L2 penalty (default: 0).`,name:"weight_decay"},{anchor:"timm.optim.MADGRAD.eps",description:`<strong>eps</strong> (float) &#x2014;
Term added to the denominator outside of the root operation to improve numerical stability. (default: 1e-6).`,name:"eps"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/madgrad.py#L24"}}),dt=new b({props:{name:"step",anchor:"timm.optim.MADGRAD.step",parameters:[{name:"closure",val:": typing.Optional[typing.Callable[[], float]] = None"}],parametersDescription:[{anchor:"timm.optim.MADGRAD.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model and returns the loss.",name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/madgrad.py#L90"}}),ct=new b({props:{name:"class timm.optim.Mars",anchor:"timm.optim.Mars",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.003"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.99)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.0"},{name:"gamma",val:": float = 0.025"},{name:"mars_type",val:": str = 'adamw'"},{name:"optimize_1d",val:": bool = False"},{name:"lr_1d_factor",val:": float = 1.0"},{name:"betas_1d",val:": typing.Optional[typing.Tuple[float, float]] = None"},{name:"caution",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/mars.py#L88"}}),gt=new b({props:{name:"step",anchor:"timm.optim.Mars.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.Mars.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/mars.py#L138"}}),ut=new b({props:{name:"class timm.optim.NAdamW",anchor:"timm.optim.NAdamW",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"betas",val:": typing.Tuple[float, float] = (0.9, 0.999)"},{name:"eps",val:": float = 1e-08"},{name:"weight_decay",val:": float = 0.01"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"capturable",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.NAdamW.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.NAdamW.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.NAdamW.betas",description:"<strong>betas</strong> &#x2014; coefficients used for computing running averages of gradient and its square",name:"betas"},{anchor:"timm.optim.NAdamW.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.NAdamW.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay coefficient",name:"weight_decay"},{anchor:"timm.optim.NAdamW.caution",description:"<strong>caution</strong> &#x2014; enable caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/nadamw.py#L17"}}),ft=new b({props:{name:"step",anchor:"timm.optim.NAdamW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NAdamW.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/nadamw.py#L81"}}),ht=new b({props:{name:"class timm.optim.NvNovoGrad",anchor:"timm.optim.NvNovoGrad",parameters:[{name:"params",val:""},{name:"lr",val:" = 0.001"},{name:"betas",val:" = (0.95, 0.98)"},{name:"eps",val:" = 1e-08"},{name:"weight_decay",val:" = 0"},{name:"grad_averaging",val:" = False"},{name:"amsgrad",val:" = False"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.params",description:`<strong>params</strong> (iterable) &#x2014; iterable of parameters to optimize or dicts defining
parameter groups`,name:"params"},{anchor:"timm.optim.NvNovoGrad.lr",description:"<strong>lr</strong> (float, optional) &#x2014; learning rate (default: 1e-3)",name:"lr"},{anchor:"timm.optim.NvNovoGrad.betas",description:`<strong>betas</strong> (Tuple[float, float], optional) &#x2014; coefficients used for computing
running averages of gradient and its square (default: (0.95, 0.98))`,name:"betas"},{anchor:"timm.optim.NvNovoGrad.eps",description:`<strong>eps</strong> (float, optional) &#x2014; term added to the denominator to improve
numerical stability (default: 1e-8)`,name:"eps"},{anchor:"timm.optim.NvNovoGrad.weight_decay",description:"<strong>weight_decay</strong> (float, optional) &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.NvNovoGrad.grad_averaging",description:"<strong>grad_averaging</strong> &#x2014; gradient averaging",name:"grad_averaging"},{anchor:"timm.optim.NvNovoGrad.amsgrad",description:`<strong>amsgrad</strong> (boolean, optional) &#x2014; whether to use the AMSGrad variant of this
algorithm from the paper <code>On the Convergence of Adam and Beyond</code>_
(default: False)`,name:"amsgrad"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/nvnovograd.py#L13"}}),vt=new b({props:{name:"step",anchor:"timm.optim.NvNovoGrad.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.NvNovoGrad.step.closure",description:"<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model",name:"closure"},{anchor:"timm.optim.NvNovoGrad.step.and",description:"<strong>and</strong> returns the loss. &#x2014;",name:"and"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/nvnovograd.py#L66"}}),bt=new b({props:{name:"class timm.optim.RMSpropTF",anchor:"timm.optim.RMSpropTF",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.01"},{name:"alpha",val:": float = 0.9"},{name:"eps",val:": float = 1e-10"},{name:"weight_decay",val:": float = 0"},{name:"momentum",val:": float = 0.0"},{name:"centered",val:": bool = False"},{name:"decoupled_decay",val:": bool = False"},{name:"lr_in_momentum",val:": bool = True"},{name:"caution",val:": bool = False"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.params",description:"<strong>params</strong> &#x2014; iterable of parameters to optimize or dicts defining parameter groups",name:"params"},{anchor:"timm.optim.RMSpropTF.lr",description:"<strong>lr</strong> &#x2014; learning rate",name:"lr"},{anchor:"timm.optim.RMSpropTF.momentum",description:"<strong>momentum</strong> &#x2014; momentum factor",name:"momentum"},{anchor:"timm.optim.RMSpropTF.alpha",description:"<strong>alpha</strong> &#x2014; smoothing (decay) constant",name:"alpha"},{anchor:"timm.optim.RMSpropTF.eps",description:"<strong>eps</strong> &#x2014; term added to the denominator to improve numerical stability",name:"eps"},{anchor:"timm.optim.RMSpropTF.centered",description:"<strong>centered</strong> &#x2014; if <code>True</code>, compute the centered RMSProp, the gradient is normalized by an estimation of its variance",name:"centered"},{anchor:"timm.optim.RMSpropTF.weight_decay",description:"<strong>weight_decay</strong> &#x2014; weight decay (L2 penalty) (default: 0)",name:"weight_decay"},{anchor:"timm.optim.RMSpropTF.decoupled_decay",description:'<strong>decoupled_decay</strong> &#x2014; decoupled weight decay as per <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">https://arxiv.org/abs/1711.05101</a>',name:"decoupled_decay"},{anchor:"timm.optim.RMSpropTF.lr_in_momentum",description:"<strong>lr_in_momentum</strong> &#x2014; learning rate scaling is included in the momentum buffer update as per defaults in Tensorflow",name:"lr_in_momentum"},{anchor:"timm.optim.RMSpropTF.caution",description:"<strong>caution</strong> &#x2014; apply caution",name:"caution"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/rmsprop_tf.py#L16"}}),yt=new b({props:{name:"step",anchor:"timm.optim.RMSpropTF.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.RMSpropTF.step.closure",description:`<strong>closure</strong> (callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/rmsprop_tf.py#L90"}}),xt=new b({props:{name:"class timm.optim.SGDP",anchor:"timm.optim.SGDP",parameters:[{name:"params",val:""},{name:"lr",val:" = <required parameter>"},{name:"momentum",val:" = 0"},{name:"dampening",val:" = 0"},{name:"weight_decay",val:" = 0"},{name:"nesterov",val:" = False"},{name:"eps",val:" = 1e-08"},{name:"delta",val:" = 0.1"},{name:"wd_ratio",val:" = 0.1"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/sgdp.py#L19"}}),$t=new b({props:{name:"class timm.optim.SGDW",anchor:"timm.optim.SGDW",parameters:[{name:"params",val:": typing.Union[typing.Iterable[torch.Tensor], typing.Iterable[typing.Dict[str, typing.Any]]]"},{name:"lr",val:": float = 0.001"},{name:"momentum",val:": float = 0.0"},{name:"dampening",val:": float = 0.0"},{name:"weight_decay",val:": float = 0.0"},{name:"nesterov",val:": bool = False"},{name:"caution",val:": bool = False"},{name:"maximize",val:": bool = False"},{name:"foreach",val:": typing.Optional[bool] = None"},{name:"differentiable",val:": bool = False"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/sgdw.py#L17"}}),wt=new b({props:{name:"step",anchor:"timm.optim.SGDW.step",parameters:[{name:"closure",val:" = None"}],parametersDescription:[{anchor:"timm.optim.SGDW.step.closure",description:`<strong>closure</strong> (Callable, optional) &#x2014; A closure that reevaluates the model
and returns the loss.`,name:"closure"}],source:"https://github.com/huggingface/pytorch-image-models/blob/v1.0.12/timm/optim/sgdw.py#L83"}}),Ct=new ps({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/reference/optimizers.mdx"}}),{c(){Q=a("meta"),hn=r(),tn=a("p"),vn=r(),d(be.$$.fragment),bn=r(),ye=a("p"),ye.innerHTML=hi,yn=r(),d(_e.$$.fragment),_n=r(),d(xe.$$.fragment),xn=r(),y=a("div"),d($e.$$.fragment),br=r(),Lt=a("p"),Lt.textContent=vi,yr=r(),At=a("p"),At.textContent=bi,_r=r(),Tt=a("p"),Tt.textContent=yi,xr=r(),an=a("blockquote"),nn=a("blockquote"),we=a("blockquote"),d(Ce.$$.fragment),$r=r(),zt=a("p"),zt.textContent=_i,wr=r(),rn=a("blockquote"),on=a("blockquote"),Le=a("blockquote"),d(Ae.$$.fragment),Cr=r(),Dt=a("p"),Dt.textContent=xi,Lr=r(),ln=a("blockquote"),sn=a("blockquote"),Te=a("blockquote"),d(ze.$$.fragment),Ar=r(),Pt=a("p"),Pt.textContent=$i,Tr=r(),mn=a("blockquote"),pn=a("blockquote"),De=a("blockquote"),d(Pe.$$.fragment),zr=r(),Mt=a("p"),Mt.textContent=wi,Dr=r(),kt=a("p"),kt.textContent=Ci,Pr=r(),It=a("ol"),It.innerHTML=Li,$n=r(),_=a("div"),d(Me.$$.fragment),Mr=r(),qt=a("p"),qt.textContent=Ai,kr=r(),Et=a("p"),Et.textContent=Ti,Ir=r(),Ot=a("p"),Ot.textContent=zi,qr=r(),Nt=a("blockquote"),Nt.innerHTML=Di,Er=r(),Ft=a("blockquote"),Ft.innerHTML=Pi,Or=r(),Ht=a("blockquote"),Ht.innerHTML=Mi,Nr=r(),Bt=a("blockquote"),Bt.innerHTML=ki,wn=r(),L=a("div"),d(ke.$$.fragment),Fr=r(),Gt=a("p"),Gt.textContent=Ii,Hr=r(),St=a("p"),St.textContent=qi,Br=r(),Rt=a("p"),Rt.textContent=Ei,Gr=r(),dn=a("blockquote"),cn=a("blockquote"),Ie=a("blockquote"),d(qe.$$.fragment),Sr=r(),Vt=a("p"),Vt.textContent=Oi,Rr=r(),gn=a("blockquote"),un=a("blockquote"),Ee=a("blockquote"),d(Oe.$$.fragment),Vr=r(),Ut=a("p"),Ut.textContent=Ni,Cn=r(),d(Ne.$$.fragment),Ln=r(),A=a("div"),d(Fe.$$.fragment),Ur=r(),Wt=a("p"),Wt.textContent=Fi,Wr=r(),jt=a("p"),jt.textContent=Hi,jr=r(),Qt=a("p"),Qt.innerHTML=Bi,Qr=r(),Kt=a("ul"),Kt.innerHTML=Gi,Kr=r(),Z=a("div"),d(He.$$.fragment),Zr=r(),Zt=a("p"),Zt.textContent=Si,An=r(),w=a("div"),d(Be.$$.fragment),Xr=r(),Xt=a("p"),Xt.textContent=Ri,Jr=r(),Jt=a("p"),Jt.innerHTML=Vi,Yr=r(),Yt=a("p"),Yt.innerHTML=Ui,eo=r(),ea=a("p"),ea.innerHTML=Wi,to=r(),ta=a("p"),ta.textContent=ji,ao=r(),X=a("div"),d(Ge.$$.fragment),no=r(),aa=a("p"),aa.textContent=Qi,Tn=r(),S=a("div"),d(Se.$$.fragment),ro=r(),na=a("p"),na.textContent=Ki,oo=r(),ra=a("p"),ra.innerHTML=Zi,zn=r(),T=a("div"),d(Re.$$.fragment),io=r(),oa=a("p"),oa.textContent=Xi,lo=r(),J=a("div"),d(Ve.$$.fragment),so=r(),ia=a("p"),ia.textContent=Ji,mo=r(),Y=a("div"),d(Ue.$$.fragment),po=r(),la=a("p"),la.textContent=Yi,co=r(),ee=a("div"),d(We.$$.fragment),go=r(),sa=a("p"),sa.textContent=el,uo=r(),te=a("div"),d(je.$$.fragment),fo=r(),ma=a("p"),ma.textContent=tl,Dn=r(),Qe=a("div"),d(Ke.$$.fragment),Pn=r(),q=a("div"),d(Ze.$$.fragment),ho=r(),pa=a("p"),pa.textContent=al,vo=r(),da=a("p"),da.innerHTML=nl,bo=r(),ae=a("div"),d(Xe.$$.fragment),yo=r(),ca=a("p"),ca.textContent=rl,Mn=r(),R=a("div"),d(Je.$$.fragment),_o=r(),ga=a("p"),ga.innerHTML=ol,xo=r(),ne=a("div"),d(Ye.$$.fragment),$o=r(),ua=a("p"),ua.textContent=il,kn=r(),M=a("div"),d(et.$$.fragment),wo=r(),fa=a("p"),fa.innerHTML=ll,Co=r(),ha=a("p"),ha.textContent=sl,Lo=r(),va=a("ul"),va.innerHTML=ml,Ao=r(),re=a("div"),d(tt.$$.fragment),To=r(),ba=a("p"),ba.textContent=pl,In=r(),E=a("div"),d(at.$$.fragment),zo=r(),ya=a("p"),ya.textContent=dl,Do=r(),_a=a("p"),_a.innerHTML=cl,Po=r(),oe=a("div"),d(nt.$$.fragment),Mo=r(),xa=a("p"),xa.textContent=gl,qn=r(),O=a("div"),d(rt.$$.fragment),ko=r(),$a=a("p"),$a.textContent=ul,Io=r(),wa=a("p"),wa.innerHTML=fl,qo=r(),ie=a("div"),d(ot.$$.fragment),Eo=r(),Ca=a("p"),Ca.textContent=hl,En=r(),V=a("div"),d(it.$$.fragment),Oo=r(),La=a("p"),La.textContent=vl,No=r(),le=a("div"),d(lt.$$.fragment),Fo=r(),Aa=a("p"),Aa.textContent=bl,On=r(),st=a("div"),d(mt.$$.fragment),Nn=r(),C=a("div"),d(pt.$$.fragment),Ho=r(),Ta=a("p"),Ta.textContent=yl,Bo=r(),za=a("p"),za.innerHTML=_l,Go=r(),Da=a("p"),Da.textContent=xl,So=r(),Pa=a("p"),Pa.textContent=$l,Ro=r(),Ma=a("p"),Ma.textContent=wl,Vo=r(),se=a("div"),d(dt.$$.fragment),Uo=r(),ka=a("p"),ka.textContent=Cl,Fn=r(),N=a("div"),d(ct.$$.fragment),Wo=r(),Ia=a("p"),Ia.textContent=Ll,jo=r(),qa=a("p"),qa.innerHTML=Al,Qo=r(),me=a("div"),d(gt.$$.fragment),Ko=r(),Ea=a("p"),Ea.textContent=Tl,Hn=r(),z=a("div"),d(ut.$$.fragment),Zo=r(),Oa=a("p"),Oa.textContent=zl,Xo=r(),Na=a("p"),Na.innerHTML=Dl,Jo=r(),Fa=a("p"),Fa.textContent=Pl,Yo=r(),Ha=a("ul"),Ha.innerHTML=Ml,ei=r(),pe=a("div"),d(ft.$$.fragment),ti=r(),Ba=a("p"),Ba.textContent=kl,Bn=r(),U=a("div"),d(ht.$$.fragment),ai=r(),Ga=a("p"),Ga.textContent=Il,ni=r(),de=a("div"),d(vt.$$.fragment),ri=r(),Sa=a("p"),Sa.textContent=ql,Gn=r(),x=a("div"),d(bt.$$.fragment),oi=r(),Ra=a("p"),Ra.textContent=El,ii=r(),Va=a("p"),Va.textContent=Ol,li=r(),Ua=a("p"),Ua.textContent=Nl,si=r(),Wa=a("ol"),Wa.innerHTML=Fl,mi=r(),ja=a("p"),ja.innerHTML=Hl,pi=r(),Qa=a("p"),Qa.innerHTML=Bl,di=r(),ce=a("div"),d(yt.$$.fragment),ci=r(),Ka=a("p"),Ka.textContent=Gl,Sn=r(),_t=a("div"),d(xt.$$.fragment),Rn=r(),K=a("div"),d($t.$$.fragment),gi=r(),ge=a("div"),d(wt.$$.fragment),ui=r(),Za=a("p"),Za.textContent=Sl,Vn=r(),d(Ct.$$.fragment),Un=r(),fn=a("p"),this.h()},l(e){const s=ms("svelte-u9bgzb",document.head);Q=n(s,"META",{name:!0,content:!0}),s.forEach(i),hn=o(e),tn=n(e,"P",{}),m(tn).forEach(i),vn=o(e),c(be.$$.fragment,e),bn=o(e),ye=n(e,"P",{"data-svelte-h":!0}),l(ye)!=="svelte-1c6qm22"&&(ye.innerHTML=hi),yn=o(e),c(_e.$$.fragment,e),_n=o(e),c(xe.$$.fragment,e),xn=o(e),y=n(e,"DIV",{class:!0});var $=m(y);c($e.$$.fragment,$),br=o($),Lt=n($,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-1330e7"&&(Lt.textContent=vi),yr=o($),At=n($,"P",{"data-svelte-h":!0}),l(At)!=="svelte-9cjiwr"&&(At.textContent=bi),_r=o($),Tt=n($,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-kvfsh7"&&(Tt.textContent=yi),xr=o($),an=n($,"BLOCKQUOTE",{});var Rl=m(an);nn=n(Rl,"BLOCKQUOTE",{});var Vl=m(nn);we=n(Vl,"BLOCKQUOTE",{});var jn=m(we);c(Ce.$$.fragment,jn),$r=o(jn),zt=n(jn,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-180ncmf"&&(zt.textContent=_i),jn.forEach(i),Vl.forEach(i),Rl.forEach(i),wr=o($),rn=n($,"BLOCKQUOTE",{});var Ul=m(rn);on=n(Ul,"BLOCKQUOTE",{});var Wl=m(on);Le=n(Wl,"BLOCKQUOTE",{});var Qn=m(Le);c(Ae.$$.fragment,Qn),Cr=o(Qn),Dt=n(Qn,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-6yrpk7"&&(Dt.textContent=xi),Qn.forEach(i),Wl.forEach(i),Ul.forEach(i),Lr=o($),ln=n($,"BLOCKQUOTE",{});var jl=m(ln);sn=n(jl,"BLOCKQUOTE",{});var Ql=m(sn);Te=n(Ql,"BLOCKQUOTE",{});var Kn=m(Te);c(ze.$$.fragment,Kn),Ar=o(Kn),Pt=n(Kn,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-1vmtu70"&&(Pt.textContent=$i),Kn.forEach(i),Ql.forEach(i),jl.forEach(i),Tr=o($),mn=n($,"BLOCKQUOTE",{});var Kl=m(mn);pn=n(Kl,"BLOCKQUOTE",{});var Zl=m(pn);De=n(Zl,"BLOCKQUOTE",{});var Zn=m(De);c(Pe.$$.fragment,Zn),zr=o(Zn),Mt=n(Zn,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-15ovmpe"&&(Mt.textContent=wi),Zn.forEach(i),Zl.forEach(i),Kl.forEach(i),Dr=o($),kt=n($,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-sgpn75"&&(kt.textContent=Ci),Pr=o($),It=n($,"OL",{"data-svelte-h":!0}),l(It)!=="svelte-psaz57"&&(It.innerHTML=Li),$.forEach(i),$n=o(e),_=n(e,"DIV",{class:!0});var D=m(_);c(Me.$$.fragment,D),Mr=o(D),qt=n(D,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-1h2sspw"&&(qt.textContent=Ai),kr=o(D),Et=n(D,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-1tapwxe"&&(Et.textContent=Ti),Ir=o(D),Ot=n(D,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-kvfsh7"&&(Ot.textContent=zi),qr=o(D),Nt=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Nt)!=="svelte-m875zf"&&(Nt.innerHTML=Di),Er=o(D),Ft=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ft)!=="svelte-1mioyvo"&&(Ft.innerHTML=Pi),Or=o(D),Ht=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Ht)!=="svelte-ji9gfr"&&(Ht.innerHTML=Mi),Nr=o(D),Bt=n(D,"BLOCKQUOTE",{"data-svelte-h":!0}),l(Bt)!=="svelte-tvmm3x"&&(Bt.innerHTML=ki),D.forEach(i),wn=o(e),L=n(e,"DIV",{class:!0});var F=m(L);c(ke.$$.fragment,F),Fr=o(F),Gt=n(F,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-1rcjgrx"&&(Gt.textContent=Ii),Hr=o(F),St=n(F,"P",{"data-svelte-h":!0}),l(St)!=="svelte-13jhmtj"&&(St.textContent=qi),Br=o(F),Rt=n(F,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-kvfsh7"&&(Rt.textContent=Ei),Gr=o(F),dn=n(F,"BLOCKQUOTE",{});var Xl=m(dn);cn=n(Xl,"BLOCKQUOTE",{});var Jl=m(cn);Ie=n(Jl,"BLOCKQUOTE",{});var Xn=m(Ie);c(qe.$$.fragment,Xn),Sr=o(Xn),Vt=n(Xn,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-1en25gb"&&(Vt.textContent=Oi),Xn.forEach(i),Jl.forEach(i),Xl.forEach(i),Rr=o(F),gn=n(F,"BLOCKQUOTE",{});var Yl=m(gn);un=n(Yl,"BLOCKQUOTE",{});var es=m(un);Ee=n(es,"BLOCKQUOTE",{});var Jn=m(Ee);c(Oe.$$.fragment,Jn),Vr=o(Jn),Ut=n(Jn,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-gfx8y2"&&(Ut.textContent=Ni),Jn.forEach(i),es.forEach(i),Yl.forEach(i),F.forEach(i),Cn=o(e),c(Ne.$$.fragment,e),Ln=o(e),A=n(e,"DIV",{class:!0});var H=m(A);c(Fe.$$.fragment,H),Ur=o(H),Wt=n(H,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1hnunr4"&&(Wt.textContent=Fi),Wr=o(H),jt=n(H,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1cjb7xo"&&(jt.textContent=Hi),jr=o(H),Qt=n(H,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-1347q2l"&&(Qt.innerHTML=Bi),Qr=o(H),Kt=n(H,"UL",{"data-svelte-h":!0}),l(Kt)!=="svelte-12x3l9q"&&(Kt.innerHTML=Gi),Kr=o(H),Z=n(H,"DIV",{class:!0});var Yn=m(Z);c(He.$$.fragment,Yn),Zr=o(Yn),Zt=n(Yn,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-1gr03w4"&&(Zt.textContent=Si),Yn.forEach(i),H.forEach(i),An=o(e),w=n(e,"DIV",{class:!0});var k=m(w);c(Be.$$.fragment,k),Xr=o(k),Xt=n(k,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-1j9mkxe"&&(Xt.textContent=Ri),Jr=o(k),Jt=n(k,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-1xvyiun"&&(Jt.innerHTML=Vi),Yr=o(k),Yt=n(k,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-1i7ubkr"&&(Yt.innerHTML=Ui),eo=o(k),ea=n(k,"P",{"data-svelte-h":!0}),l(ea)!=="svelte-96f97i"&&(ea.innerHTML=Wi),to=o(k),ta=n(k,"P",{"data-svelte-h":!0}),l(ta)!=="svelte-1q67fqp"&&(ta.textContent=ji),ao=o(k),X=n(k,"DIV",{class:!0});var er=m(X);c(Ge.$$.fragment,er),no=o(er),aa=n(er,"P",{"data-svelte-h":!0}),l(aa)!=="svelte-1gr03w4"&&(aa.textContent=Qi),er.forEach(i),k.forEach(i),Tn=o(e),S=n(e,"DIV",{class:!0});var Xa=m(S);c(Se.$$.fragment,Xa),ro=o(Xa),na=n(Xa,"P",{"data-svelte-h":!0}),l(na)!=="svelte-19t8yzj"&&(na.textContent=Ki),oo=o(Xa),ra=n(Xa,"P",{"data-svelte-h":!0}),l(ra)!=="svelte-aajaln"&&(ra.innerHTML=Zi),Xa.forEach(i),zn=o(e),T=n(e,"DIV",{class:!0});var B=m(T);c(Re.$$.fragment,B),io=o(B),oa=n(B,"P",{"data-svelte-h":!0}),l(oa)!=="svelte-1cuo0rh"&&(oa.textContent=Xi),lo=o(B),J=n(B,"DIV",{class:!0});var tr=m(J);c(Ve.$$.fragment,tr),so=o(tr),ia=n(tr,"P",{"data-svelte-h":!0}),l(ia)!=="svelte-1jz1hl7"&&(ia.textContent=Ji),tr.forEach(i),mo=o(B),Y=n(B,"DIV",{class:!0});var ar=m(Y);c(Ue.$$.fragment,ar),po=o(ar),la=n(ar,"P",{"data-svelte-h":!0}),l(la)!=="svelte-1y1oyzd"&&(la.textContent=Yi),ar.forEach(i),co=o(B),ee=n(B,"DIV",{class:!0});var nr=m(ee);c(We.$$.fragment,nr),go=o(nr),sa=n(nr,"P",{"data-svelte-h":!0}),l(sa)!=="svelte-1gr03w4"&&(sa.textContent=el),nr.forEach(i),uo=o(B),te=n(B,"DIV",{class:!0});var rr=m(te);c(je.$$.fragment,rr),fo=o(rr),ma=n(rr,"P",{"data-svelte-h":!0}),l(ma)!=="svelte-4lvf5h"&&(ma.textContent=tl),rr.forEach(i),B.forEach(i),Dn=o(e),Qe=n(e,"DIV",{class:!0});var ts=m(Qe);c(Ke.$$.fragment,ts),ts.forEach(i),Pn=o(e),q=n(e,"DIV",{class:!0});var ue=m(q);c(Ze.$$.fragment,ue),ho=o(ue),pa=n(ue,"P",{"data-svelte-h":!0}),l(pa)!=="svelte-1vdc41k"&&(pa.textContent=al),vo=o(ue),da=n(ue,"P",{"data-svelte-h":!0}),l(da)!=="svelte-1vkysjq"&&(da.innerHTML=nl),bo=o(ue),ae=n(ue,"DIV",{class:!0});var or=m(ae);c(Xe.$$.fragment,or),yo=o(or),ca=n(or,"P",{"data-svelte-h":!0}),l(ca)!=="svelte-1gr03w4"&&(ca.textContent=rl),or.forEach(i),ue.forEach(i),Mn=o(e),R=n(e,"DIV",{class:!0});var Ja=m(R);c(Je.$$.fragment,Ja),_o=o(Ja),ga=n(Ja,"P",{"data-svelte-h":!0}),l(ga)!=="svelte-bxurot"&&(ga.innerHTML=ol),xo=o(Ja),ne=n(Ja,"DIV",{class:!0});var ir=m(ne);c(Ye.$$.fragment,ir),$o=o(ir),ua=n(ir,"P",{"data-svelte-h":!0}),l(ua)!=="svelte-1siu6mf"&&(ua.textContent=il),ir.forEach(i),Ja.forEach(i),kn=o(e),M=n(e,"DIV",{class:!0});var W=m(M);c(et.$$.fragment,W),wo=o(W),fa=n(W,"P",{"data-svelte-h":!0}),l(fa)!=="svelte-d5zqgn"&&(fa.innerHTML=ll),Co=o(W),ha=n(W,"P",{"data-svelte-h":!0}),l(ha)!=="svelte-9itjiu"&&(ha.textContent=sl),Lo=o(W),va=n(W,"UL",{"data-svelte-h":!0}),l(va)!=="svelte-ylo4gl"&&(va.innerHTML=ml),Ao=o(W),re=n(W,"DIV",{class:!0});var lr=m(re);c(tt.$$.fragment,lr),To=o(lr),ba=n(lr,"P",{"data-svelte-h":!0}),l(ba)!=="svelte-1gr03w4"&&(ba.textContent=pl),lr.forEach(i),W.forEach(i),In=o(e),E=n(e,"DIV",{class:!0});var fe=m(E);c(at.$$.fragment,fe),zo=o(fe),ya=n(fe,"P",{"data-svelte-h":!0}),l(ya)!=="svelte-1ky75u7"&&(ya.textContent=dl),Do=o(fe),_a=n(fe,"P",{"data-svelte-h":!0}),l(_a)!=="svelte-ee3cwp"&&(_a.innerHTML=cl),Po=o(fe),oe=n(fe,"DIV",{class:!0});var sr=m(oe);c(nt.$$.fragment,sr),Mo=o(sr),xa=n(sr,"P",{"data-svelte-h":!0}),l(xa)!=="svelte-1gr03w4"&&(xa.textContent=gl),sr.forEach(i),fe.forEach(i),qn=o(e),O=n(e,"DIV",{class:!0});var he=m(O);c(rt.$$.fragment,he),ko=o(he),$a=n(he,"P",{"data-svelte-h":!0}),l($a)!=="svelte-vzcsb8"&&($a.textContent=ul),Io=o(he),wa=n(he,"P",{"data-svelte-h":!0}),l(wa)!=="svelte-euart9"&&(wa.innerHTML=fl),qo=o(he),ie=n(he,"DIV",{class:!0});var mr=m(ie);c(ot.$$.fragment,mr),Eo=o(mr),Ca=n(mr,"P",{"data-svelte-h":!0}),l(Ca)!=="svelte-1gr03w4"&&(Ca.textContent=hl),mr.forEach(i),he.forEach(i),En=o(e),V=n(e,"DIV",{class:!0});var Ya=m(V);c(it.$$.fragment,Ya),Oo=o(Ya),La=n(Ya,"P",{"data-svelte-h":!0}),l(La)!=="svelte-pwyp7b"&&(La.textContent=vl),No=o(Ya),le=n(Ya,"DIV",{class:!0});var pr=m(le);c(lt.$$.fragment,pr),Fo=o(pr),Aa=n(pr,"P",{"data-svelte-h":!0}),l(Aa)!=="svelte-1gr03w4"&&(Aa.textContent=bl),pr.forEach(i),Ya.forEach(i),On=o(e),st=n(e,"DIV",{class:!0});var as=m(st);c(mt.$$.fragment,as),as.forEach(i),Nn=o(e),C=n(e,"DIV",{class:!0});var I=m(C);c(pt.$$.fragment,I),Ho=o(I),Ta=n(I,"P",{"data-svelte-h":!0}),l(Ta)!=="svelte-wmmdpx"&&(Ta.textContent=yl),Bo=o(I),za=n(I,"P",{"data-svelte-h":!0}),l(za)!=="svelte-12dyngi"&&(za.innerHTML=_l),Go=o(I),Da=n(I,"P",{"data-svelte-h":!0}),l(Da)!=="svelte-qjjdis"&&(Da.textContent=xl),So=o(I),Pa=n(I,"P",{"data-svelte-h":!0}),l(Pa)!=="svelte-rosfou"&&(Pa.textContent=$l),Ro=o(I),Ma=n(I,"P",{"data-svelte-h":!0}),l(Ma)!=="svelte-hlwvkn"&&(Ma.textContent=wl),Vo=o(I),se=n(I,"DIV",{class:!0});var dr=m(se);c(dt.$$.fragment,dr),Uo=o(dr),ka=n(dr,"P",{"data-svelte-h":!0}),l(ka)!=="svelte-1gr03w4"&&(ka.textContent=Cl),dr.forEach(i),I.forEach(i),Fn=o(e),N=n(e,"DIV",{class:!0});var ve=m(N);c(ct.$$.fragment,ve),Wo=o(ve),Ia=n(ve,"P",{"data-svelte-h":!0}),l(Ia)!=="svelte-yn9hq2"&&(Ia.textContent=Ll),jo=o(ve),qa=n(ve,"P",{"data-svelte-h":!0}),l(qa)!=="svelte-1l0d0b"&&(qa.innerHTML=Al),Qo=o(ve),me=n(ve,"DIV",{class:!0});var cr=m(me);c(gt.$$.fragment,cr),Ko=o(cr),Ea=n(cr,"P",{"data-svelte-h":!0}),l(Ea)!=="svelte-1gr03w4"&&(Ea.textContent=Tl),cr.forEach(i),ve.forEach(i),Hn=o(e),z=n(e,"DIV",{class:!0});var G=m(z);c(ut.$$.fragment,G),Zo=o(G),Oa=n(G,"P",{"data-svelte-h":!0}),l(Oa)!=="svelte-3mtxcr"&&(Oa.textContent=zl),Xo=o(G),Na=n(G,"P",{"data-svelte-h":!0}),l(Na)!=="svelte-1kok3gr"&&(Na.innerHTML=Dl),Jo=o(G),Fa=n(G,"P",{"data-svelte-h":!0}),l(Fa)!=="svelte-1usqxsj"&&(Fa.textContent=Pl),Yo=o(G),Ha=n(G,"UL",{"data-svelte-h":!0}),l(Ha)!=="svelte-xfb8g2"&&(Ha.innerHTML=Ml),ei=o(G),pe=n(G,"DIV",{class:!0});var gr=m(pe);c(ft.$$.fragment,gr),ti=o(gr),Ba=n(gr,"P",{"data-svelte-h":!0}),l(Ba)!=="svelte-1gr03w4"&&(Ba.textContent=kl),gr.forEach(i),G.forEach(i),Bn=o(e),U=n(e,"DIV",{class:!0});var en=m(U);c(ht.$$.fragment,en),ai=o(en),Ga=n(en,"P",{"data-svelte-h":!0}),l(Ga)!=="svelte-5vv99d"&&(Ga.textContent=Il),ni=o(en),de=n(en,"DIV",{class:!0});var ur=m(de);c(vt.$$.fragment,ur),ri=o(ur),Sa=n(ur,"P",{"data-svelte-h":!0}),l(Sa)!=="svelte-1gr03w4"&&(Sa.textContent=ql),ur.forEach(i),en.forEach(i),Gn=o(e),x=n(e,"DIV",{class:!0});var P=m(x);c(bt.$$.fragment,P),oi=o(P),Ra=n(P,"P",{"data-svelte-h":!0}),l(Ra)!=="svelte-1tqv0s5"&&(Ra.textContent=El),ii=o(P),Va=n(P,"P",{"data-svelte-h":!0}),l(Va)!=="svelte-g10xv4"&&(Va.textContent=Ol),li=o(P),Ua=n(P,"P",{"data-svelte-h":!0}),l(Ua)!=="svelte-1acg3vg"&&(Ua.textContent=Nl),si=o(P),Wa=n(P,"OL",{"data-svelte-h":!0}),l(Wa)!=="svelte-15y6o6y"&&(Wa.innerHTML=Fl),mi=o(P),ja=n(P,"P",{"data-svelte-h":!0}),l(ja)!=="svelte-1yvkj2h"&&(ja.innerHTML=Hl),pi=o(P),Qa=n(P,"P",{"data-svelte-h":!0}),l(Qa)!=="svelte-53x1ow"&&(Qa.innerHTML=Bl),di=o(P),ce=n(P,"DIV",{class:!0});var fr=m(ce);c(yt.$$.fragment,fr),ci=o(fr),Ka=n(fr,"P",{"data-svelte-h":!0}),l(Ka)!=="svelte-1gr03w4"&&(Ka.textContent=Gl),fr.forEach(i),P.forEach(i),Sn=o(e),_t=n(e,"DIV",{class:!0});var ns=m(_t);c(xt.$$.fragment,ns),ns.forEach(i),Rn=o(e),K=n(e,"DIV",{class:!0});var hr=m(K);c($t.$$.fragment,hr),gi=o(hr),ge=n(hr,"DIV",{class:!0});var vr=m(ge);c(wt.$$.fragment,vr),ui=o(vr),Za=n(vr,"P",{"data-svelte-h":!0}),l(Za)!=="svelte-1gr03w4"&&(Za.textContent=Sl),vr.forEach(i),hr.forEach(i),Vn=o(e),c(Ct.$$.fragment,e),Un=o(e),fn=n(e,"P",{}),m(fn).forEach(i),this.h()},h(){v(Q,"name","hf:doc:metadata"),v(Q,"content",cs),v(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,Q),p(e,hn,s),p(e,tn,s),p(e,vn,s),g(be,e,s),p(e,bn,s),p(e,ye,s),p(e,yn,s),g(_e,e,s),p(e,_n,s),g(xe,e,s),p(e,xn,s),p(e,y,s),g($e,y,null),t(y,br),t(y,Lt),t(y,yr),t(y,At),t(y,_r),t(y,Tt),t(y,xr),t(y,an),t(an,nn),t(nn,we),g(Ce,we,null),t(we,$r),t(we,zt),t(y,wr),t(y,rn),t(rn,on),t(on,Le),g(Ae,Le,null),t(Le,Cr),t(Le,Dt),t(y,Lr),t(y,ln),t(ln,sn),t(sn,Te),g(ze,Te,null),t(Te,Ar),t(Te,Pt),t(y,Tr),t(y,mn),t(mn,pn),t(pn,De),g(Pe,De,null),t(De,zr),t(De,Mt),t(y,Dr),t(y,kt),t(y,Pr),t(y,It),p(e,$n,s),p(e,_,s),g(Me,_,null),t(_,Mr),t(_,qt),t(_,kr),t(_,Et),t(_,Ir),t(_,Ot),t(_,qr),t(_,Nt),t(_,Er),t(_,Ft),t(_,Or),t(_,Ht),t(_,Nr),t(_,Bt),p(e,wn,s),p(e,L,s),g(ke,L,null),t(L,Fr),t(L,Gt),t(L,Hr),t(L,St),t(L,Br),t(L,Rt),t(L,Gr),t(L,dn),t(dn,cn),t(cn,Ie),g(qe,Ie,null),t(Ie,Sr),t(Ie,Vt),t(L,Rr),t(L,gn),t(gn,un),t(un,Ee),g(Oe,Ee,null),t(Ee,Vr),t(Ee,Ut),p(e,Cn,s),g(Ne,e,s),p(e,Ln,s),p(e,A,s),g(Fe,A,null),t(A,Ur),t(A,Wt),t(A,Wr),t(A,jt),t(A,jr),t(A,Qt),t(A,Qr),t(A,Kt),t(A,Kr),t(A,Z),g(He,Z,null),t(Z,Zr),t(Z,Zt),p(e,An,s),p(e,w,s),g(Be,w,null),t(w,Xr),t(w,Xt),t(w,Jr),t(w,Jt),t(w,Yr),t(w,Yt),t(w,eo),t(w,ea),t(w,to),t(w,ta),t(w,ao),t(w,X),g(Ge,X,null),t(X,no),t(X,aa),p(e,Tn,s),p(e,S,s),g(Se,S,null),t(S,ro),t(S,na),t(S,oo),t(S,ra),p(e,zn,s),p(e,T,s),g(Re,T,null),t(T,io),t(T,oa),t(T,lo),t(T,J),g(Ve,J,null),t(J,so),t(J,ia),t(T,mo),t(T,Y),g(Ue,Y,null),t(Y,po),t(Y,la),t(T,co),t(T,ee),g(We,ee,null),t(ee,go),t(ee,sa),t(T,uo),t(T,te),g(je,te,null),t(te,fo),t(te,ma),p(e,Dn,s),p(e,Qe,s),g(Ke,Qe,null),p(e,Pn,s),p(e,q,s),g(Ze,q,null),t(q,ho),t(q,pa),t(q,vo),t(q,da),t(q,bo),t(q,ae),g(Xe,ae,null),t(ae,yo),t(ae,ca),p(e,Mn,s),p(e,R,s),g(Je,R,null),t(R,_o),t(R,ga),t(R,xo),t(R,ne),g(Ye,ne,null),t(ne,$o),t(ne,ua),p(e,kn,s),p(e,M,s),g(et,M,null),t(M,wo),t(M,fa),t(M,Co),t(M,ha),t(M,Lo),t(M,va),t(M,Ao),t(M,re),g(tt,re,null),t(re,To),t(re,ba),p(e,In,s),p(e,E,s),g(at,E,null),t(E,zo),t(E,ya),t(E,Do),t(E,_a),t(E,Po),t(E,oe),g(nt,oe,null),t(oe,Mo),t(oe,xa),p(e,qn,s),p(e,O,s),g(rt,O,null),t(O,ko),t(O,$a),t(O,Io),t(O,wa),t(O,qo),t(O,ie),g(ot,ie,null),t(ie,Eo),t(ie,Ca),p(e,En,s),p(e,V,s),g(it,V,null),t(V,Oo),t(V,La),t(V,No),t(V,le),g(lt,le,null),t(le,Fo),t(le,Aa),p(e,On,s),p(e,st,s),g(mt,st,null),p(e,Nn,s),p(e,C,s),g(pt,C,null),t(C,Ho),t(C,Ta),t(C,Bo),t(C,za),t(C,Go),t(C,Da),t(C,So),t(C,Pa),t(C,Ro),t(C,Ma),t(C,Vo),t(C,se),g(dt,se,null),t(se,Uo),t(se,ka),p(e,Fn,s),p(e,N,s),g(ct,N,null),t(N,Wo),t(N,Ia),t(N,jo),t(N,qa),t(N,Qo),t(N,me),g(gt,me,null),t(me,Ko),t(me,Ea),p(e,Hn,s),p(e,z,s),g(ut,z,null),t(z,Zo),t(z,Oa),t(z,Xo),t(z,Na),t(z,Jo),t(z,Fa),t(z,Yo),t(z,Ha),t(z,ei),t(z,pe),g(ft,pe,null),t(pe,ti),t(pe,Ba),p(e,Bn,s),p(e,U,s),g(ht,U,null),t(U,ai),t(U,Ga),t(U,ni),t(U,de),g(vt,de,null),t(de,ri),t(de,Sa),p(e,Gn,s),p(e,x,s),g(bt,x,null),t(x,oi),t(x,Ra),t(x,ii),t(x,Va),t(x,li),t(x,Ua),t(x,si),t(x,Wa),t(x,mi),t(x,ja),t(x,pi),t(x,Qa),t(x,di),t(x,ce),g(yt,ce,null),t(ce,ci),t(ce,Ka),p(e,Sn,s),p(e,_t,s),g(xt,_t,null),p(e,Rn,s),p(e,K,s),g($t,K,null),t(K,gi),t(K,ge),g(wt,ge,null),t(ge,ui),t(ge,Za),p(e,Vn,s),g(Ct,e,s),p(e,Un,s),p(e,fn,s),Wn=!0},p:os,i(e){Wn||(u(be.$$.fragment,e),u(_e.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ce.$$.fragment,e),u(Ae.$$.fragment,e),u(ze.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),u(qe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ne.$$.fragment,e),u(Fe.$$.fragment,e),u(He.$$.fragment,e),u(Be.$$.fragment,e),u(Ge.$$.fragment,e),u(Se.$$.fragment,e),u(Re.$$.fragment,e),u(Ve.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(je.$$.fragment,e),u(Ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Xe.$$.fragment,e),u(Je.$$.fragment,e),u(Ye.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(at.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(ot.$$.fragment,e),u(it.$$.fragment,e),u(lt.$$.fragment,e),u(mt.$$.fragment,e),u(pt.$$.fragment,e),u(dt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ft.$$.fragment,e),u(ht.$$.fragment,e),u(vt.$$.fragment,e),u(bt.$$.fragment,e),u(yt.$$.fragment,e),u(xt.$$.fragment,e),u($t.$$.fragment,e),u(wt.$$.fragment,e),u(Ct.$$.fragment,e),Wn=!0)},o(e){f(be.$$.fragment,e),f(_e.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(Pe.$$.fragment,e),f(Me.$$.fragment,e),f(ke.$$.fragment,e),f(qe.$$.fragment,e),f(Oe.$$.fragment,e),f(Ne.$$.fragment,e),f(Fe.$$.fragment,e),f(He.$$.fragment,e),f(Be.$$.fragment,e),f(Ge.$$.fragment,e),f(Se.$$.fragment,e),f(Re.$$.fragment,e),f(Ve.$$.fragment,e),f(Ue.$$.fragment,e),f(We.$$.fragment,e),f(je.$$.fragment,e),f(Ke.$$.fragment,e),f(Ze.$$.fragment,e),f(Xe.$$.fragment,e),f(Je.$$.fragment,e),f(Ye.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(rt.$$.fragment,e),f(ot.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ht.$$.fragment,e),f(vt.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(xt.$$.fragment,e),f($t.$$.fragment,e),f(wt.$$.fragment,e),f(Ct.$$.fragment,e),Wn=!1},d(e){e&&(i(hn),i(tn),i(vn),i(bn),i(ye),i(yn),i(_n),i(xn),i(y),i($n),i(_),i(wn),i(L),i(Cn),i(Ln),i(A),i(An),i(w),i(Tn),i(S),i(zn),i(T),i(Dn),i(Qe),i(Pn),i(q),i(Mn),i(R),i(kn),i(M),i(In),i(E),i(qn),i(O),i(En),i(V),i(On),i(st),i(Nn),i(C),i(Fn),i(N),i(Hn),i(z),i(Bn),i(U),i(Gn),i(x),i(Sn),i(_t),i(Rn),i(K),i(Vn),i(Un),i(fn)),i(Q),h(be,e),h(_e,e),h(xe,e),h($e),h(Ce),h(Ae),h(ze),h(Pe),h(Me),h(ke),h(qe),h(Oe),h(Ne,e),h(Fe),h(He),h(Be),h(Ge),h(Se),h(Re),h(Ve),h(Ue),h(We),h(je),h(Ke),h(Ze),h(Xe),h(Je),h(Ye),h(et),h(tt),h(at),h(nt),h(rt),h(ot),h(it),h(lt),h(mt),h(pt),h(dt),h(ct),h(gt),h(ut),h(ft),h(ht),h(vt),h(bt),h(yt),h(xt),h($t),h(wt),h(Ct,e)}}}const cs='{"title":"Optimization","local":"optimization","sections":[{"title":"Optimizers","local":"optimizers","sections":[{"title":"Factory functions","local":"timm.optim.create_optimizer_v2","sections":[],"depth":3}],"depth":2}],"depth":1}';function gs(fi){return is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ls{constructor(Q){super(),ss(this,Q,gs,ds,rs,{})}}export{bs as component};
