import{s as Q,n as V,o as z}from"../chunks/scheduler.7c46a39e.js";import{S as D,i as O,g as n,s,r as P,A as K,h as r,f as a,c as l,j as S,u as C,x as T,k as q,y as ee,a as o,v as F,d as H,t as k,w as B}from"../chunks/index.fa0f2890.js";import{C as te}from"../chunks/CodeBlock.337ba03c.js";import{H as E}from"../chunks/Heading.36c897de.js";function ae(A){let i,_,w,g,d,J,p,U="Normally, it is not possible to mix different adapter types in 🤗 PEFT. For example, even though it is possible to create a PEFT model that has two different LoRA adapters (that can have different config options), it is not possible to combine a LoRA adapter with a LoHa adapter. However, by using a mixed model, this works as long as the adapter types are compatible.",$,m,v,f,G="To load different adapter types into a PEFT model, proceed the same as if you were loading two adapters of the same type, but use <code>PeftMixedModel</code> instead of <code>PeftModel</code>:",x,c,Z,h,X="The last line is necessary if you want to activate both adapters, otherwise, only the first adapter would be active. Of course, you can add more different adapters by calling <code>add_adapter</code> repeatedly.",j,u,Y="Currently, the main purpose of mixed adapter types is to combine trained adapters for inference. Although it is technically also possible to train a mixed adapter model, this has not been tested and is not recommended.",R,y,L,b,N="<li>Not all adapter types can be combined. See <code>peft.tuners.mixed.COMPATIBLE_TUNER_TYPES</code> for a list of compatible types. An error will be raised if you are trying to combine incompatible adapter types.</li> <li>It is possible to mix multiple adapters of the same type. This can be useful to combine adapters with very different configs.</li> <li>If you want to combine a lot of different adapters, it is most performant to add the same types of adapters consecutively. E.g., add LoRA1, LoRA2, LoHa1, LoHa2 in this order, instead of LoRA1, LoHa1, LoRA2, LoHa2. The order will make a difference for the outcome in most cases, but since no order is better a priori, it is best to choose the order that is most performant.</li>",I,M,W;return d=new E({props:{title:"Working with mixed adapter types",local:"working-with-mixed-adapter-types",headingTag:"h1"}}),m=new E({props:{title:"Loading different adapter types into a PEFT model",local:"loading-different-adapter-types-into-a-peft-model",headingTag:"h2"}}),c=new te({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TWl4ZWRNb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjAuLi4lMjAlMjAlMjMlMjBsb2FkJTIwdGhlJTIwYmFzZSUyMG1vZGVsJTJDJTIwZS5nLiUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMEElMjMlMjBsb2FkJTIwZmlyc3QlMjBhZGFwdGVyJTJDJTIwd2hpY2glMjB3aWxsJTIwYmUlMjBjYWxsZWQlMjAlMjJkZWZhdWx0JTIyJTBBcGVmdF9tb2RlbCUyMCUzRCUyMFBlZnRNaXhlZE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwJTNDcGF0aF90b19hZGFwdGVyMSUzRSklMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoX3RvX2FkYXB0ZXIyJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyb3RoZXIlMjIpJTBBcGVmdF9tb2RlbC5zZXRfYWRhcHRlciglNUIlMjJkZWZhdWx0JTIyJTJDJTIwJTIyb3RoZXIlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftMixedModel

base_model = ...  <span class="hljs-comment"># load the base model, e.g. from transformers</span>
<span class="hljs-comment"># load first adapter, which will be called &quot;default&quot;</span>
peft_model = PeftMixedModel.from_pretrained(base_model, &lt;path_to_adapter1&gt;)
peft_model.load_adapter(&lt;path_to_adapter2&gt;, adapter_name=<span class="hljs-string">&quot;other&quot;</span>)
peft_model.set_adapter([<span class="hljs-string">&quot;default&quot;</span>, <span class="hljs-string">&quot;other&quot;</span>])`,wrap:!1}}),y=new E({props:{title:"Tips",local:"tips",headingTag:"h2"}}),{c(){i=n("meta"),_=s(),w=n("p"),g=s(),P(d.$$.fragment),J=s(),p=n("p"),p.textContent=U,$=s(),P(m.$$.fragment),v=s(),f=n("p"),f.innerHTML=G,x=s(),P(c.$$.fragment),Z=s(),h=n("p"),h.innerHTML=X,j=s(),u=n("p"),u.textContent=Y,R=s(),P(y.$$.fragment),L=s(),b=n("ul"),b.innerHTML=N,I=s(),M=n("p"),this.h()},l(e){const t=K("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(a),_=l(e),w=r(e,"P",{}),S(w).forEach(a),g=l(e),C(d.$$.fragment,e),J=l(e),p=r(e,"P",{"data-svelte-h":!0}),T(p)!=="svelte-12o0ap7"&&(p.textContent=U),$=l(e),C(m.$$.fragment,e),v=l(e),f=r(e,"P",{"data-svelte-h":!0}),T(f)!=="svelte-1q8zbvz"&&(f.innerHTML=G),x=l(e),C(c.$$.fragment,e),Z=l(e),h=r(e,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1wxldvj"&&(h.innerHTML=X),j=l(e),u=r(e,"P",{"data-svelte-h":!0}),T(u)!=="svelte-c9vm0i"&&(u.textContent=Y),R=l(e),C(y.$$.fragment,e),L=l(e),b=r(e,"UL",{"data-svelte-h":!0}),T(b)!=="svelte-1yo05jc"&&(b.innerHTML=N),I=l(e),M=r(e,"P",{}),S(M).forEach(a),this.h()},h(){q(i,"name","hf:doc:metadata"),q(i,"content",oe)},m(e,t){ee(document.head,i),o(e,_,t),o(e,w,t),o(e,g,t),F(d,e,t),o(e,J,t),o(e,p,t),o(e,$,t),F(m,e,t),o(e,v,t),o(e,f,t),o(e,x,t),F(c,e,t),o(e,Z,t),o(e,h,t),o(e,j,t),o(e,u,t),o(e,R,t),F(y,e,t),o(e,L,t),o(e,b,t),o(e,I,t),o(e,M,t),W=!0},p:V,i(e){W||(H(d.$$.fragment,e),H(m.$$.fragment,e),H(c.$$.fragment,e),H(y.$$.fragment,e),W=!0)},o(e){k(d.$$.fragment,e),k(m.$$.fragment,e),k(c.$$.fragment,e),k(y.$$.fragment,e),W=!1},d(e){e&&(a(_),a(w),a(g),a(J),a(p),a($),a(v),a(f),a(x),a(Z),a(h),a(j),a(u),a(R),a(L),a(b),a(I),a(M)),a(i),B(d,e),B(m,e),B(c,e),B(y,e)}}}const oe='{"title":"Working with mixed adapter types","local":"working-with-mixed-adapter-types","sections":[{"title":"Loading different adapter types into a PEFT model","local":"loading-different-adapter-types-into-a-peft-model","sections":[],"depth":2},{"title":"Tips","local":"tips","sections":[],"depth":2}],"depth":1}';function se(A){return z(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class de extends D{constructor(i){super(),O(this,i,se,ae,Q,{})}}export{de as component};
