import{s as es,n as ls,o as ts}from"../chunks/scheduler.7c46a39e.js";import{S as ss,i as as,g as i,s as a,r as o,A as ns,h as p,f as t,c as n,j as Ot,u as r,x as m,k as yt,y as is,a as s,v as M,d as c,t as y,w as d}from"../chunks/index.fa0f2890.js";import{C as h}from"../chunks/CodeBlock.337ba03c.js";import{H as J}from"../chunks/Heading.36c897de.js";function ps(dt){let u,Re,Ne,Ee,f,Ae,T,ht=`This guide demonstrates how to use LoRA, a low-rank approximation technique, to fine-tune an image classification model.
By using LoRA from 🤗 PEFT, we can reduce the number of trainable parameters in the model to only 0.77% of the original.`,ze,b,Jt=`LoRA achieves this reduction by adding low-rank “update matrices” to specific blocks of the model, such as the attention
blocks. During fine-tuning, only these matrices are trained, while the original model parameters are left unchanged.
At inference time, the update matrices are merged with the original model parameters to produce the final classification result.`,He,U,ut='For more information on LoRA, please refer to the <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">original LoRA paper</a>.',Se,j,qe,g,wt="Install the libraries required for model training:",Le,I,Pe,C,ft="Check the versions of all required libraries to make sure you are up to date:",De,Z,Ke,W,Oe,$,Tt=`To share the fine-tuned model at the end of the training with the community, authenticate using your 🤗 token.
You can obtain your token from your <a href="https://huggingface.co/settings/token" rel="nofollow">account settings</a>.`,el,B,ll,_,tl,v,bt=`Choose a model checkpoint from any of the model architectures supported for <a href="https://huggingface.co/models?pipeline_tag=image-classification&amp;sort=downloads" rel="nofollow">image classification</a>. When in doubt, refer to
the <a href="https://huggingface.co/docs/transformers/v4.27.2/en/tasks/image_classification" rel="nofollow">image classification task guide</a> in
🤗 Transformers documentation.`,sl,k,al,X,nl,G,Ut='To keep this example’s runtime short, let’s only load the first 5000 instances from the training set of the <a href="https://huggingface.co/datasets/food101" rel="nofollow">Food-101 dataset</a>:',il,x,pl,Y,ol,V,jt=`To prepare the dataset for training and evaluation, create <code>label2id</code> and <code>id2label</code> dictionaries. These will come in
handy when performing inference and for metadata information:`,rl,Q,ml,N,gt="Next, load the image processor of the model you’re fine-tuning:",Ml,F,cl,R,It=`The <code>image_processor</code> contains useful information on which size the training and evaluation images should be resized
to, as well as values that should be used to normalize the pixel values. Using the <code>image_processor</code>, prepare transformation
functions for the datasets. These functions will include data augmentation and pixel scaling:`,yl,E,dl,A,Ct="Split the dataset into training and validation sets:",hl,z,Jl,H,Zt="Finally, set the transformation functions for the datasets accordingly:",ul,S,wl,q,fl,L,Wt=`Before loading the model, let’s define a helper function to check the total number of parameters a model has, as well
as how many of them are trainable.`,Tl,P,bl,D,$t=`It’s important to initialize the original model correctly as it will be used as a base to create the <code>PeftModel</code> you’ll
actually fine-tune. Specify the <code>label2id</code> and <code>id2label</code> so that <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForImageClassification" rel="nofollow">AutoModelForImageClassification</a> can append a classification
head to the underlying model, adapted for this dataset. You should see the following output:`,Ul,K,jl,O,gl,ee,Bt="Before creating a <code>PeftModel</code>, you can check the number of trainable parameters in the original model:",Il,le,Cl,te,_t="Next, use <code>get_peft_model</code> to wrap the base model so that “update” matrices are added to the respective places.",Zl,se,Wl,ae,vt=`Let’s unpack what’s going on here.
To use LoRA, you need to specify the target modules in <code>LoraConfig</code> so that <code>get_peft_model()</code> knows which modules
inside our model need to be amended with LoRA matrices. In this example, we’re only interested in targeting the query and
value matrices of the attention blocks of the base model. Since the parameters corresponding to these matrices are “named”
“query” and “value” respectively, we specify them accordingly in the <code>target_modules</code> argument of <code>LoraConfig</code>.`,$l,ne,kt=`We also specify <code>modules_to_save</code>. After wrapping the base model with <code>get_peft_model()</code> along with the <code>config</code>, we get
a new model where only the LoRA parameters are trainable (so-called “update matrices”) while the pre-trained parameters
are kept frozen. However, we want the classifier parameters to be trained too when fine-tuning the base model on our
custom dataset. To ensure that the classifier parameters are also trained, we specify <code>modules_to_save</code>. This also
ensures that these modules are serialized alongside the LoRA trainable parameters when using utilities like <code>save_pretrained()</code>
and <code>push_to_hub()</code>.`,Bl,ie,Xt="Here’s what the other parameters mean:",_l,pe,Gt="<li><code>r</code>: The dimension used by the LoRA update matrices.</li> <li><code>alpha</code>: Scaling factor.</li> <li><code>bias</code>: Specifies if the <code>bias</code> parameters should be trained. <code>None</code> denotes none of the <code>bias</code> parameters will be trained.</li>",vl,oe,xt=`<code>r</code> and <code>alpha</code> together control the total number of final trainable parameters when using LoRA, giving you the flexibility
to balance a trade-off between end performance and compute efficiency.`,kl,re,Yt=`By looking at the number of trainable parameters, you can see how many parameters we’re actually training. Since the goal is
to achieve parameter-efficient fine-tuning, you should expect to see fewer trainable parameters in the <code>lora_model</code>
in comparison to the original model, which is indeed the case here.`,Xl,me,Gl,Me,Vt=`For model fine-tuning, use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a>. It accepts
several arguments which you can wrap using <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,xl,ce,Yl,ye,Qt=`Compared to non-PEFT methods, you can use a larger batch size since there are fewer parameters to train.
You can also set a larger learning rate than the normal (1e-5 for example).`,Vl,de,Nt="This can potentially also reduce the need to conduct expensive hyperparameter tuning experiments.",Ql,he,Nl,Je,Fl,ue,Ft=`The <code>compute_metrics</code> function takes a named tuple as input: <code>predictions</code>, which are the logits of the model as Numpy arrays,
and <code>label_ids</code>, which are the ground-truth labels as Numpy arrays.`,Rl,we,El,fe,Rt=`A collation function is used by <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> to gather a batch of training and evaluation examples and prepare them in a
format that is acceptable by the underlying model.`,Al,Te,zl,be,Hl,Ue,Et="Bring everything together - model, training arguments, data, collation function, etc. Then, start the training!",Sl,je,ql,ge,At=`In just a few minutes, the fine-tuned model shows 96% validation accuracy even on this small
subset of the training dataset.`,Ll,Ie,Pl,Ce,Dl,Ze,zt="Once the fine-tuning is done, share the LoRA parameters with the community like so:",Kl,We,Ol,$e,Ht=`When calling <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> on the <code>lora_model</code>, only the LoRA parameters along with any modules specified in <code>modules_to_save</code>
are saved. Take a look at the <a href="https://huggingface.co/sayakpaul/vit-base-patch16-224-in21k-finetuned-lora-food101/blob/main/adapter_model.bin" rel="nofollow">trained LoRA parameters</a>.
You’ll see that it’s only 2.6 MB! This greatly helps with portability, especially when using a very large model to fine-tune (such as <a href="https://huggingface.co/bigscience/bloom" rel="nofollow">BLOOM</a>).`,et,Be,St=`Next, let’s see how to load the LoRA updated parameters along with our base model for inference. When you wrap a base model
with <code>PeftModel</code>, modifications are done <em>in-place</em>. To mitigate any concerns that might stem from in-place modifications,
initialize the base model just like you did earlier and construct the inference model.`,lt,_e,tt,ve,qt="Let’s now fetch an example image for inference.",st,ke,at,w,Lt='<img src="https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg" alt="image of beignets"/>',nt,Xe,Pt="First, instantiate an <code>image_processor</code> from the underlying model repo.",it,Ge,pt,xe,Dt="Then, prepare the example for inference.",ot,Ye,rt,Ve,Kt="Finally, run inference!",mt,Qe,Mt,Fe,ct;return f=new J({props:{title:"Image classification using LoRA",local:"image-classification-using-lora",headingTag:"h1"}}),j=new J({props:{title:"Install dependencies",local:"install-dependencies",headingTag:"h2"}}),I=new h({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwZXZhbHVhdGUlMjBkYXRhc2V0cyUyMHBlZnQlMjAtcQ==",highlighted:"!pip install transformers accelerate evaluate datasets peft -q",wrap:!1}}),Z=new h({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBaW1wb3J0JTIwYWNjZWxlcmF0ZSUwQWltcG9ydCUyMHBlZnQlMEElMEFwcmludChmJTIyVHJhbnNmb3JtZXJzJTIwdmVyc2lvbiUzQSUyMCU3QnRyYW5zZm9ybWVycy5fX3ZlcnNpb25fXyU3RCUyMiklMEFwcmludChmJTIyQWNjZWxlcmF0ZSUyMHZlcnNpb24lM0ElMjAlN0JhY2NlbGVyYXRlLl9fdmVyc2lvbl9fJTdEJTIyKSUwQXByaW50KGYlMjJQRUZUJTIwdmVyc2lvbiUzQSUyMCU3QnBlZnQuX192ZXJzaW9uX18lN0QlMjIpJTBBJTIyVHJhbnNmb3JtZXJzJTIwdmVyc2lvbiUzQSUyMDQuMjcuNCUyMiUwQSUyMkFjY2VsZXJhdGUlMjB2ZXJzaW9uJTNBJTIwMC4xOC4wJTIyJTBBJTIyUEVGVCUyMHZlcnNpb24lM0ElMjAwLjIuMCUyMg==",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">import</span> accelerate
<span class="hljs-keyword">import</span> peft

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Transformers version: <span class="hljs-subst">{transformers.__version__}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Accelerate version: <span class="hljs-subst">{accelerate.__version__}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;PEFT version: <span class="hljs-subst">{peft.__version__}</span>&quot;</span>)
<span class="hljs-string">&quot;Transformers version: 4.27.4&quot;</span>
<span class="hljs-string">&quot;Accelerate version: 0.18.0&quot;</span>
<span class="hljs-string">&quot;PEFT version: 0.2.0&quot;</span>`,wrap:!1}}),W=new J({props:{title:"Authenticate to share your model",local:"authenticate-to-share-your-model",headingTag:"h2"}}),B=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new J({props:{title:"Select a model checkpoint to fine-tune",local:"select-a-model-checkpoint-to-fine-tune",headingTag:"h2"}}),k=new h({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LWluMjFrJTIy",highlighted:'model_checkpoint = <span class="hljs-string">&quot;google/vit-base-patch16-224-in21k&quot;</span>',wrap:!1}}),X=new J({props:{title:"Load a dataset",local:"load-a-dataset",headingTag:"h2"}}),x=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTUwMDAlNUQlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train[:5000]&quot;</span>)`,wrap:!1}}),Y=new J({props:{title:"Dataset preparation",local:"dataset-preparation",headingTag:"h2"}}),Q=new h({props:{code:"bGFiZWxzJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVELm5hbWVzJTBBbGFiZWwyaWQlMkMlMjBpZDJsYWJlbCUyMCUzRCUyMGRpY3QoKSUyQyUyMGRpY3QoKSUwQWZvciUyMGklMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKGxhYmVscyklM0ElMEElMjAlMjAlMjAlMjBsYWJlbDJpZCU1QmxhYmVsJTVEJTIwJTNEJTIwaSUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTVCaSU1RCUyMCUzRCUyMGxhYmVsJTBBJTBBaWQybGFiZWwlNUIyJTVEJTBBJTIyYmFrbGF2YSUyMg==",highlighted:`labels = dataset.features[<span class="hljs-string">&quot;label&quot;</span>].names
label2id, id2label = <span class="hljs-built_in">dict</span>(), <span class="hljs-built_in">dict</span>()
<span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(labels):
    label2id[label] = i
    id2label[i] = label

id2label[<span class="hljs-number">2</span>]
<span class="hljs-string">&quot;baklava&quot;</span>`,wrap:!1}}),F=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),E=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
    CenterCrop,
    Compose,
    Normalize,
    RandomHorizontalFlip,
    RandomResizedCrop,
    Resize,
    ToTensor,
)

normalize = Normalize(mean=image_processor.image_mean, std=image_processor.image_std)
train_transforms = Compose(
    [
        RandomResizedCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        RandomHorizontalFlip(),
        ToTensor(),
        normalize,
    ]
)

val_transforms = Compose(
    [
        Resize(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        CenterCrop(image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]),
        ToTensor(),
        normalize,
    ]
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">example_batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Apply train_transforms across a batch.&quot;&quot;&quot;</span>
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [train_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_val</span>(<span class="hljs-params">example_batch</span>):
    <span class="hljs-string">&quot;&quot;&quot;Apply val_transforms across a batch.&quot;&quot;&quot;</span>
    example_batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = [val_transforms(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    <span class="hljs-keyword">return</span> example_batch`,wrap:!1}}),z=new h({props:{code:"c3BsaXRzJTIwJTNEJTIwZGF0YXNldC50cmFpbl90ZXN0X3NwbGl0KHRlc3Rfc2l6ZSUzRDAuMSklMEF0cmFpbl9kcyUyMCUzRCUyMHNwbGl0cyU1QiUyMnRyYWluJTIyJTVEJTBBdmFsX2RzJTIwJTNEJTIwc3BsaXRzJTVCJTIydGVzdCUyMiU1RA==",highlighted:`splits = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)
train_ds = splits[<span class="hljs-string">&quot;train&quot;</span>]
val_ds = splits[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),S=new h({props:{code:"dHJhaW5fZHMuc2V0X3RyYW5zZm9ybShwcmVwcm9jZXNzX3RyYWluKSUwQXZhbF9kcy5zZXRfdHJhbnNmb3JtKHByZXByb2Nlc3NfdmFsKQ==",highlighted:`train_ds.set_transform(preprocess_train)
val_ds.set_transform(preprocess_val)`,wrap:!1}}),q=new J({props:{title:"Load and prepare a model",local:"load-and-prepare-a-model",headingTag:"h2"}}),P=new h({props:{code:"ZGVmJTIwcHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5hYmxlX3BhcmFtcyUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjBhbGxfcGFyYW0lMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwZm9yJTIwXyUyQyUyMHBhcmFtJTIwaW4lMjBtb2RlbC5uYW1lZF9wYXJhbWV0ZXJzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGxfcGFyYW0lMjAlMkIlM0QlMjBwYXJhbS5udW1lbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBwYXJhbS5yZXF1aXJlc19ncmFkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5hYmxlX3BhcmFtcyUyMCUyQiUzRCUyMHBhcmFtLm51bWVsKCklMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwJTdCdHJhaW5hYmxlX3BhcmFtcyU3RCUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMCU3QmFsbF9wYXJhbSU3RCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMCU3QjEwMCUyMColMjB0cmFpbmFibGVfcGFyYW1zJTIwJTJGJTIwYWxsX3BhcmFtJTNBLjJmJTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_trainable_parameters</span>(<span class="hljs-params">model</span>):
    trainable_params = <span class="hljs-number">0</span>
    all_param = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> _, param <span class="hljs-keyword">in</span> model.named_parameters():
        all_param += param.numel()
        <span class="hljs-keyword">if</span> param.requires_grad:
            trainable_params += param.numel()
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;trainable params: <span class="hljs-subst">{trainable_params}</span> || all params: <span class="hljs-subst">{all_param}</span> || trainable%: <span class="hljs-subst">{<span class="hljs-number">100</span> * trainable_params / all_param:<span class="hljs-number">.2</span>f}</span>&quot;</span>
    )`,wrap:!1}}),K=new h({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFZpVEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjB3ZXJlJTIwbm90JTIwaW5pdGlhbGl6ZWQlMjBmcm9tJTIwdGhlJTIwbW9kZWwlMjBjaGVja3BvaW50JTIwYXQlMjBnb29nbGUlMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1pbjIxayUyMGFuZCUyMGFyZSUyMG5ld2x5JTIwaW5pdGlhbGl6ZWQlM0ElMjAlNUInY2xhc3NpZmllci53ZWlnaHQnJTJDJTIwJ2NsYXNzaWZpZXIuYmlhcyclNUQ=",highlighted:'<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> ViTForImageClassification were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at google/vit-base-patch16<span class="hljs-number">-224</span>-in21k <span class="hljs-keyword">and</span> are newly initialized: [<span class="hljs-string">&#x27;classifier.weight&#x27;</span>, <span class="hljs-string">&#x27;classifier.bias&#x27;</span>]',wrap:!1}}),O=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMkMlMjBUcmFpbmluZ0FyZ3VtZW50cyUyQyUyMFRyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2NoZWNrcG9pbnQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbDJpZCUzRGxhYmVsMmlkJTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGlnbm9yZV9taXNtYXRjaGVkX3NpemVzJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMHByb3ZpZGUlMjB0aGlzJTIwaW4lMjBjYXNlJTIweW91J3JlJTIwcGxhbm5pbmclMjB0byUyMGZpbmUtdHVuZSUyMGFuJTIwYWxyZWFkeSUyMGZpbmUtdHVuZWQlMjBjaGVja3BvaW50JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, TrainingArguments, Trainer

model = AutoModelForImageClassification.from_pretrained(
    model_checkpoint,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
)`,wrap:!1}}),le=new h({props:{code:"cHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMobW9kZWwpJTBBJTIydHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwODU4NzYzMjUlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NTg3NjMyNSUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEwMC4wMCUyMg==",highlighted:`print_trainable_parameters(model)
<span class="hljs-string">&quot;trainable params: 85876325 || all params: 85876325 || trainable%: 100.00&quot;</span>`,wrap:!1}}),se=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyY2xhc3NpZmllciUyMiU1RCUyQyUwQSklMEFsb3JhX21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMobG9yYV9tb2RlbCklMEElMjJ0cmFpbmFibGUlMjBwYXJhbXMlM0ElMjA2Njc0OTMlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA4NjQ2NjE0OSUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDAuNzclMjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">16</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>],
    lora_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)
lora_model = get_peft_model(model, config)
print_trainable_parameters(lora_model)
<span class="hljs-string">&quot;trainable params: 667493 || all params: 86466149 || trainable%: 0.77&quot;</span>`,wrap:!1}}),me=new J({props:{title:"Define training arguments",local:"define-training-arguments",headingTag:"h2"}}),ce=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBtb2RlbF9jaGVja3BvaW50LnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQWJhdGNoX3NpemUlMjAlM0QlMjAxMjglMEElMEFhcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwZiUyMiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLWxvcmEtZm9vZDEwMSUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTMlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGZwMTYlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDUlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMmFjY3VyYWN5JTIyJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbmFtZXMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer


model_name = model_checkpoint.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
batch_size = <span class="hljs-number">128</span>

args = TrainingArguments(
    <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-lora-food101&quot;</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    learning_rate=<span class="hljs-number">5e-3</span>,
    per_device_train_batch_size=batch_size,
    gradient_accumulation_steps=<span class="hljs-number">4</span>,
    per_device_eval_batch_size=batch_size,
    fp16=<span class="hljs-literal">True</span>,
    num_train_epochs=<span class="hljs-number">5</span>,
    logging_steps=<span class="hljs-number">10</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
)`,wrap:!1}}),he=new J({props:{title:"Prepare evaluation metric",local:"prepare-evaluation-metric",headingTag:"h2"}}),Je=new h({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29tcHV0ZXMlMjBhY2N1cmFjeSUyMG9uJTIwYSUyMGJhdGNoJTIwb2YlMjBwcmVkaWN0aW9ucyUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KGV2YWxfcHJlZC5wcmVkaWN0aW9ucyUyQyUyMGF4aXMlM0QxKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZXZhbF9wcmVkLmxhYmVsX2lkcyk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    <span class="hljs-string">&quot;&quot;&quot;Computes accuracy on a batch of predictions&quot;&quot;&quot;</span>
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),we=new J({props:{title:"Define collation function",local:"define-collation-function",headingTag:"h2"}}),Te=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFkZWYlMjBjb2xsYXRlX2ZuKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QmV4YW1wbGUlNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCZXhhbXBsZSU1QiUyMmxhYmVsJTIyJTVEJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwcGl4ZWxfdmFsdWVzJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwbGFiZWxzJTdE",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    pixel_values = torch.stack([example[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),be=new J({props:{title:"Train and evaluate",local:"train-and-evaluate",headingTag:"h2"}}),je=new h({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbG9yYV9tb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZHMlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R2YWxfZHMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0RpbWFnZV9wcm9jZXNzb3IlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSklMEF0cmFpbl9yZXN1bHRzJTIwJTNEJTIwdHJhaW5lci50cmFpbigp",highlighted:`trainer = Trainer(
    lora_model,
    args,
    train_dataset=train_ds,
    eval_dataset=val_ds,
    tokenizer=image_processor,
    compute_metrics=compute_metrics,
    data_collator=collate_fn,
)
train_results = trainer.train()`,wrap:!1}}),Ie=new h({props:{code:"dHJhaW5lci5ldmFsdWF0ZSh2YWxfZHMpJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIyZXZhbF9sb3NzJTIyJTNBJTIwMC4xNDQ3NTg1NTIzMTI4NTA5NSUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfYWNjdXJhY3klMjIlM0ElMjAwLjk2JTJDJTBBJTIwJTIwJTIwJTIwJTIyZXZhbF9ydW50aW1lJTIyJTNBJTIwMy41NzI1JTJDJTBBJTIwJTIwJTIwJTIwJTIyZXZhbF9zYW1wbGVzX3Blcl9zZWNvbmQlMjIlM0ElMjAxMzkuOTU4JTJDJTBBJTIwJTIwJTIwJTIwJTIyZXZhbF9zdGVwc19wZXJfc2Vjb25kJTIyJTNBJTIwMS4xMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVwb2NoJTIyJTNBJTIwNS4wJTJDJTBBJTdE",highlighted:`trainer.evaluate(val_ds)
{
    <span class="hljs-string">&quot;eval_loss&quot;</span>: <span class="hljs-number">0.14475855231285095</span>,
    <span class="hljs-string">&quot;eval_accuracy&quot;</span>: <span class="hljs-number">0.96</span>,
    <span class="hljs-string">&quot;eval_runtime&quot;</span>: <span class="hljs-number">3.5725</span>,
    <span class="hljs-string">&quot;eval_samples_per_second&quot;</span>: <span class="hljs-number">139.958</span>,
    <span class="hljs-string">&quot;eval_steps_per_second&quot;</span>: <span class="hljs-number">1.12</span>,
    <span class="hljs-string">&quot;epoch&quot;</span>: <span class="hljs-number">5.0</span>,
}`,wrap:!1}}),Ce=new J({props:{title:"Share your model and run inference",local:"share-your-model-and-run-inference",headingTag:"h2"}}),We=new h({props:{code:"cmVwb19uYW1lJTIwJTNEJTIwZiUyMnNheWFrcGF1bCUyRiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLWxvcmEtZm9vZDEwMSUyMiUwQWxvcmFfbW9kZWwucHVzaF90b19odWIocmVwb19uYW1lKQ==",highlighted:`repo_name = <span class="hljs-string">f&quot;sayakpaul/<span class="hljs-subst">{model_name}</span>-finetuned-lora-food101&quot;</span>
lora_model.push_to_hub(repo_name)`,wrap:!1}}),_e=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0Q29uZmlnJTJDJTIwUGVmdE1vZGVsJTBBJTBBJTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocmVwb19uYW1lKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwY29uZmlnLmJhc2VfbW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMjAlMjAlMjMlMjBwcm92aWRlJTIwdGhpcyUyMGluJTIwY2FzZSUyMHlvdSdyZSUyMHBsYW5uaW5nJTIwdG8lMjBmaW5lLXR1bmUlMjBhbiUyMGFscmVhZHklMjBmaW5lLXR1bmVkJTIwY2hlY2twb2ludCUwQSklMEElMjMlMjBMb2FkJTIwdGhlJTIwTG9SQSUyMG1vZGVsJTBBaW5mZXJlbmNlX21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMHJlcG9fbmFtZSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftConfig, PeftModel


config = PeftConfig.from_pretrained(repo_name)
model = AutoModelForImageClassification.from_pretrained(
    config.base_model_name_or_path,
    label2id=label2id,
    id2label=id2label,
    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
)
<span class="hljs-comment"># Load the LoRA model</span>
inference_model = PeftModel.from_pretrained(model, repo_name)`,wrap:!1}}),ke=new h({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRmJlaWduZXRzLmpwZWclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/beignets.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),Ge=new h({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChyZXBvX25hbWUp",highlighted:"image_processor = AutoImageProcessor.from_pretrained(repo_name)",wrap:!1}}),Ye=new h({props:{code:"ZW5jb2RpbmclMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'encoding = image_processor(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Qe=new h({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBpbmZlcmVuY2VfbW9kZWwoKiplbmNvZGluZyklMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMGluZmVyZW5jZV9tb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfY2xhc3NfaWR4JTVEKSUwQSUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIwYmVpZ25ldHMlMjI=",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = inference_model(**encoding)
    logits = outputs.logits

predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, inference_model.config.id2label[predicted_class_idx])
<span class="hljs-string">&quot;Predicted class: beignets&quot;</span>`,wrap:!1}}),{c(){u=i("meta"),Re=a(),Ne=i("p"),Ee=a(),o(f.$$.fragment),Ae=a(),T=i("p"),T.textContent=ht,ze=a(),b=i("p"),b.textContent=Jt,He=a(),U=i("p"),U.innerHTML=ut,Se=a(),o(j.$$.fragment),qe=a(),g=i("p"),g.textContent=wt,Le=a(),o(I.$$.fragment),Pe=a(),C=i("p"),C.textContent=ft,De=a(),o(Z.$$.fragment),Ke=a(),o(W.$$.fragment),Oe=a(),$=i("p"),$.innerHTML=Tt,el=a(),o(B.$$.fragment),ll=a(),o(_.$$.fragment),tl=a(),v=i("p"),v.innerHTML=bt,sl=a(),o(k.$$.fragment),al=a(),o(X.$$.fragment),nl=a(),G=i("p"),G.innerHTML=Ut,il=a(),o(x.$$.fragment),pl=a(),o(Y.$$.fragment),ol=a(),V=i("p"),V.innerHTML=jt,rl=a(),o(Q.$$.fragment),ml=a(),N=i("p"),N.textContent=gt,Ml=a(),o(F.$$.fragment),cl=a(),R=i("p"),R.innerHTML=It,yl=a(),o(E.$$.fragment),dl=a(),A=i("p"),A.textContent=Ct,hl=a(),o(z.$$.fragment),Jl=a(),H=i("p"),H.textContent=Zt,ul=a(),o(S.$$.fragment),wl=a(),o(q.$$.fragment),fl=a(),L=i("p"),L.textContent=Wt,Tl=a(),o(P.$$.fragment),bl=a(),D=i("p"),D.innerHTML=$t,Ul=a(),o(K.$$.fragment),jl=a(),o(O.$$.fragment),gl=a(),ee=i("p"),ee.innerHTML=Bt,Il=a(),o(le.$$.fragment),Cl=a(),te=i("p"),te.innerHTML=_t,Zl=a(),o(se.$$.fragment),Wl=a(),ae=i("p"),ae.innerHTML=vt,$l=a(),ne=i("p"),ne.innerHTML=kt,Bl=a(),ie=i("p"),ie.textContent=Xt,_l=a(),pe=i("ul"),pe.innerHTML=Gt,vl=a(),oe=i("p"),oe.innerHTML=xt,kl=a(),re=i("p"),re.innerHTML=Yt,Xl=a(),o(me.$$.fragment),Gl=a(),Me=i("p"),Me.innerHTML=Vt,xl=a(),o(ce.$$.fragment),Yl=a(),ye=i("p"),ye.textContent=Qt,Vl=a(),de=i("p"),de.textContent=Nt,Ql=a(),o(he.$$.fragment),Nl=a(),o(Je.$$.fragment),Fl=a(),ue=i("p"),ue.innerHTML=Ft,Rl=a(),o(we.$$.fragment),El=a(),fe=i("p"),fe.innerHTML=Rt,Al=a(),o(Te.$$.fragment),zl=a(),o(be.$$.fragment),Hl=a(),Ue=i("p"),Ue.textContent=Et,Sl=a(),o(je.$$.fragment),ql=a(),ge=i("p"),ge.textContent=At,Ll=a(),o(Ie.$$.fragment),Pl=a(),o(Ce.$$.fragment),Dl=a(),Ze=i("p"),Ze.textContent=zt,Kl=a(),o(We.$$.fragment),Ol=a(),$e=i("p"),$e.innerHTML=Ht,et=a(),Be=i("p"),Be.innerHTML=St,lt=a(),o(_e.$$.fragment),tt=a(),ve=i("p"),ve.textContent=qt,st=a(),o(ke.$$.fragment),at=a(),w=i("div"),w.innerHTML=Lt,nt=a(),Xe=i("p"),Xe.innerHTML=Pt,it=a(),o(Ge.$$.fragment),pt=a(),xe=i("p"),xe.textContent=Dt,ot=a(),o(Ye.$$.fragment),rt=a(),Ve=i("p"),Ve.textContent=Kt,mt=a(),o(Qe.$$.fragment),Mt=a(),Fe=i("p"),this.h()},l(e){const l=ns("svelte-u9bgzb",document.head);u=p(l,"META",{name:!0,content:!0}),l.forEach(t),Re=n(e),Ne=p(e,"P",{}),Ot(Ne).forEach(t),Ee=n(e),r(f.$$.fragment,e),Ae=n(e),T=p(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1u144i3"&&(T.textContent=ht),ze=n(e),b=p(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1q529js"&&(b.textContent=Jt),He=n(e),U=p(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-e5fkf5"&&(U.innerHTML=ut),Se=n(e),r(j.$$.fragment,e),qe=n(e),g=p(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1hz22x2"&&(g.textContent=wt),Le=n(e),r(I.$$.fragment,e),Pe=n(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1stn34r"&&(C.textContent=ft),De=n(e),r(Z.$$.fragment,e),Ke=n(e),r(W.$$.fragment,e),Oe=n(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-18wc95j"&&($.innerHTML=Tt),el=n(e),r(B.$$.fragment,e),ll=n(e),r(_.$$.fragment,e),tl=n(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1txdixu"&&(v.innerHTML=bt),sl=n(e),r(k.$$.fragment,e),al=n(e),r(X.$$.fragment,e),nl=n(e),G=p(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-nfbivu"&&(G.innerHTML=Ut),il=n(e),r(x.$$.fragment,e),pl=n(e),r(Y.$$.fragment,e),ol=n(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-rpv4zv"&&(V.innerHTML=jt),rl=n(e),r(Q.$$.fragment,e),ml=n(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1jp78mf"&&(N.textContent=gt),Ml=n(e),r(F.$$.fragment,e),cl=n(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1b2m298"&&(R.innerHTML=It),yl=n(e),r(E.$$.fragment,e),dl=n(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-v3a4as"&&(A.textContent=Ct),hl=n(e),r(z.$$.fragment,e),Jl=n(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-k5a4bq"&&(H.textContent=Zt),ul=n(e),r(S.$$.fragment,e),wl=n(e),r(q.$$.fragment,e),fl=n(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-lmmzq"&&(L.textContent=Wt),Tl=n(e),r(P.$$.fragment,e),bl=n(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1sp5d8a"&&(D.innerHTML=$t),Ul=n(e),r(K.$$.fragment,e),jl=n(e),r(O.$$.fragment,e),gl=n(e),ee=p(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-1ez48do"&&(ee.innerHTML=Bt),Il=n(e),r(le.$$.fragment,e),Cl=n(e),te=p(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-wkppti"&&(te.innerHTML=_t),Zl=n(e),r(se.$$.fragment,e),Wl=n(e),ae=p(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-q6mejx"&&(ae.innerHTML=vt),$l=n(e),ne=p(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-7y27bh"&&(ne.innerHTML=kt),Bl=n(e),ie=p(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-j5msxy"&&(ie.textContent=Xt),_l=n(e),pe=p(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-1m2rv79"&&(pe.innerHTML=Gt),vl=n(e),oe=p(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-v2eh0"&&(oe.innerHTML=xt),kl=n(e),re=p(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-bwxiph"&&(re.innerHTML=Yt),Xl=n(e),r(me.$$.fragment,e),Gl=n(e),Me=p(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-132w99p"&&(Me.innerHTML=Vt),xl=n(e),r(ce.$$.fragment,e),Yl=n(e),ye=p(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-1b1k1gd"&&(ye.textContent=Qt),Vl=n(e),de=p(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-15s8rfp"&&(de.textContent=Nt),Ql=n(e),r(he.$$.fragment,e),Nl=n(e),r(Je.$$.fragment,e),Fl=n(e),ue=p(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-csgsx6"&&(ue.innerHTML=Ft),Rl=n(e),r(we.$$.fragment,e),El=n(e),fe=p(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-vp0cw5"&&(fe.innerHTML=Rt),Al=n(e),r(Te.$$.fragment,e),zl=n(e),r(be.$$.fragment,e),Hl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-ewvpbn"&&(Ue.textContent=Et),Sl=n(e),r(je.$$.fragment,e),ql=n(e),ge=p(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-156715e"&&(ge.textContent=At),Ll=n(e),r(Ie.$$.fragment,e),Pl=n(e),r(Ce.$$.fragment,e),Dl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-1nwbsod"&&(Ze.textContent=zt),Kl=n(e),r(We.$$.fragment,e),Ol=n(e),$e=p(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1yy7agj"&&($e.innerHTML=Ht),et=n(e),Be=p(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1sywq05"&&(Be.innerHTML=St),lt=n(e),r(_e.$$.fragment,e),tt=n(e),ve=p(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-143jykz"&&(ve.textContent=qt),st=n(e),r(ke.$$.fragment,e),at=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-1y4h4v8"&&(w.innerHTML=Lt),nt=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-snna81"&&(Xe.innerHTML=Pt),it=n(e),r(Ge.$$.fragment,e),pt=n(e),xe=p(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-oy7q59"&&(xe.textContent=Dt),ot=n(e),r(Ye.$$.fragment,e),rt=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1u4plry"&&(Ve.textContent=Kt),mt=n(e),r(Qe.$$.fragment,e),Mt=n(e),Fe=p(e,"P",{}),Ot(Fe).forEach(t),this.h()},h(){yt(u,"name","hf:doc:metadata"),yt(u,"content",os),yt(w,"class","flex justify-center")},m(e,l){is(document.head,u),s(e,Re,l),s(e,Ne,l),s(e,Ee,l),M(f,e,l),s(e,Ae,l),s(e,T,l),s(e,ze,l),s(e,b,l),s(e,He,l),s(e,U,l),s(e,Se,l),M(j,e,l),s(e,qe,l),s(e,g,l),s(e,Le,l),M(I,e,l),s(e,Pe,l),s(e,C,l),s(e,De,l),M(Z,e,l),s(e,Ke,l),M(W,e,l),s(e,Oe,l),s(e,$,l),s(e,el,l),M(B,e,l),s(e,ll,l),M(_,e,l),s(e,tl,l),s(e,v,l),s(e,sl,l),M(k,e,l),s(e,al,l),M(X,e,l),s(e,nl,l),s(e,G,l),s(e,il,l),M(x,e,l),s(e,pl,l),M(Y,e,l),s(e,ol,l),s(e,V,l),s(e,rl,l),M(Q,e,l),s(e,ml,l),s(e,N,l),s(e,Ml,l),M(F,e,l),s(e,cl,l),s(e,R,l),s(e,yl,l),M(E,e,l),s(e,dl,l),s(e,A,l),s(e,hl,l),M(z,e,l),s(e,Jl,l),s(e,H,l),s(e,ul,l),M(S,e,l),s(e,wl,l),M(q,e,l),s(e,fl,l),s(e,L,l),s(e,Tl,l),M(P,e,l),s(e,bl,l),s(e,D,l),s(e,Ul,l),M(K,e,l),s(e,jl,l),M(O,e,l),s(e,gl,l),s(e,ee,l),s(e,Il,l),M(le,e,l),s(e,Cl,l),s(e,te,l),s(e,Zl,l),M(se,e,l),s(e,Wl,l),s(e,ae,l),s(e,$l,l),s(e,ne,l),s(e,Bl,l),s(e,ie,l),s(e,_l,l),s(e,pe,l),s(e,vl,l),s(e,oe,l),s(e,kl,l),s(e,re,l),s(e,Xl,l),M(me,e,l),s(e,Gl,l),s(e,Me,l),s(e,xl,l),M(ce,e,l),s(e,Yl,l),s(e,ye,l),s(e,Vl,l),s(e,de,l),s(e,Ql,l),M(he,e,l),s(e,Nl,l),M(Je,e,l),s(e,Fl,l),s(e,ue,l),s(e,Rl,l),M(we,e,l),s(e,El,l),s(e,fe,l),s(e,Al,l),M(Te,e,l),s(e,zl,l),M(be,e,l),s(e,Hl,l),s(e,Ue,l),s(e,Sl,l),M(je,e,l),s(e,ql,l),s(e,ge,l),s(e,Ll,l),M(Ie,e,l),s(e,Pl,l),M(Ce,e,l),s(e,Dl,l),s(e,Ze,l),s(e,Kl,l),M(We,e,l),s(e,Ol,l),s(e,$e,l),s(e,et,l),s(e,Be,l),s(e,lt,l),M(_e,e,l),s(e,tt,l),s(e,ve,l),s(e,st,l),M(ke,e,l),s(e,at,l),s(e,w,l),s(e,nt,l),s(e,Xe,l),s(e,it,l),M(Ge,e,l),s(e,pt,l),s(e,xe,l),s(e,ot,l),M(Ye,e,l),s(e,rt,l),s(e,Ve,l),s(e,mt,l),M(Qe,e,l),s(e,Mt,l),s(e,Fe,l),ct=!0},p:ls,i(e){ct||(c(f.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(_.$$.fragment,e),c(k.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(E.$$.fragment,e),c(z.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(Je.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(be.$$.fragment,e),c(je.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(We.$$.fragment,e),c(_e.$$.fragment,e),c(ke.$$.fragment,e),c(Ge.$$.fragment,e),c(Ye.$$.fragment,e),c(Qe.$$.fragment,e),ct=!0)},o(e){y(f.$$.fragment,e),y(j.$$.fragment,e),y(I.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(B.$$.fragment,e),y(_.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(x.$$.fragment,e),y(Y.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(me.$$.fragment,e),y(ce.$$.fragment,e),y(he.$$.fragment,e),y(Je.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(be.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(We.$$.fragment,e),y(_e.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(Ye.$$.fragment,e),y(Qe.$$.fragment,e),ct=!1},d(e){e&&(t(Re),t(Ne),t(Ee),t(Ae),t(T),t(ze),t(b),t(He),t(U),t(Se),t(qe),t(g),t(Le),t(Pe),t(C),t(De),t(Ke),t(Oe),t($),t(el),t(ll),t(tl),t(v),t(sl),t(al),t(nl),t(G),t(il),t(pl),t(ol),t(V),t(rl),t(ml),t(N),t(Ml),t(cl),t(R),t(yl),t(dl),t(A),t(hl),t(Jl),t(H),t(ul),t(wl),t(fl),t(L),t(Tl),t(bl),t(D),t(Ul),t(jl),t(gl),t(ee),t(Il),t(Cl),t(te),t(Zl),t(Wl),t(ae),t($l),t(ne),t(Bl),t(ie),t(_l),t(pe),t(vl),t(oe),t(kl),t(re),t(Xl),t(Gl),t(Me),t(xl),t(Yl),t(ye),t(Vl),t(de),t(Ql),t(Nl),t(Fl),t(ue),t(Rl),t(El),t(fe),t(Al),t(zl),t(Hl),t(Ue),t(Sl),t(ql),t(ge),t(Ll),t(Pl),t(Dl),t(Ze),t(Kl),t(Ol),t($e),t(et),t(Be),t(lt),t(tt),t(ve),t(st),t(at),t(w),t(nt),t(Xe),t(it),t(pt),t(xe),t(ot),t(rt),t(Ve),t(mt),t(Mt),t(Fe)),t(u),d(f,e),d(j,e),d(I,e),d(Z,e),d(W,e),d(B,e),d(_,e),d(k,e),d(X,e),d(x,e),d(Y,e),d(Q,e),d(F,e),d(E,e),d(z,e),d(S,e),d(q,e),d(P,e),d(K,e),d(O,e),d(le,e),d(se,e),d(me,e),d(ce,e),d(he,e),d(Je,e),d(we,e),d(Te,e),d(be,e),d(je,e),d(Ie,e),d(Ce,e),d(We,e),d(_e,e),d(ke,e),d(Ge,e),d(Ye,e),d(Qe,e)}}}const os='{"title":"Image classification using LoRA","local":"image-classification-using-lora","sections":[{"title":"Install dependencies","local":"install-dependencies","sections":[],"depth":2},{"title":"Authenticate to share your model","local":"authenticate-to-share-your-model","sections":[],"depth":2},{"title":"Select a model checkpoint to fine-tune","local":"select-a-model-checkpoint-to-fine-tune","sections":[],"depth":2},{"title":"Load a dataset","local":"load-a-dataset","sections":[],"depth":2},{"title":"Dataset preparation","local":"dataset-preparation","sections":[],"depth":2},{"title":"Load and prepare a model","local":"load-and-prepare-a-model","sections":[],"depth":2},{"title":"Define training arguments","local":"define-training-arguments","sections":[],"depth":2},{"title":"Prepare evaluation metric","local":"prepare-evaluation-metric","sections":[],"depth":2},{"title":"Define collation function","local":"define-collation-function","sections":[],"depth":2},{"title":"Train and evaluate","local":"train-and-evaluate","sections":[],"depth":2},{"title":"Share your model and run inference","local":"share-your-model-and-run-inference","sections":[],"depth":2}],"depth":1}';function rs(dt){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends ss{constructor(u){super(),as(this,u,rs,ps,es,{})}}export{ds as component};
