import{s as Wt,o as Zt,n as Lt}from"../chunks/scheduler.7c46a39e.js";import{S as vt,i as Gt,g as o,s as n,r,A as _t,h as i,f as l,c as a,j as Ut,u as c,x as m,k as Ct,y as $t,a as s,v as M,d as y,t as u,w as d}from"../chunks/index.fa0f2890.js";import{T as It}from"../chunks/Tip.ab69995a.js";import{C as h}from"../chunks/CodeBlock.337ba03c.js";import{H as Oe}from"../chunks/Heading.36c897de.js";function Rt(pe){let p,J=`For this toy example, we choose an exceedingly large number of hidden units to highlight the efficiency gains
from PEFT, but those gains are in line with more realistic examples.`;return{c(){p=o("p"),p.textContent=J},l(b){p=i(b,"P",{"data-svelte-h":!0}),m(p)!=="svelte-7te1s3"&&(p.textContent=J)},m(b,ie){s(b,p,ie)},p:Lt,d(b){b&&l(p)}}}function At(pe){let p,J,b,ie,f,re,j,et=`Some fine-tuning techniques, such as prompt tuning, are specific to language models. That means in 🤗 PEFT, it is
assumed a 🤗 Transformers model is being used. However, other fine-tuning techniques - like
<a href="../conceptual_guides/lora">LoRA</a> - are not restricted to specific model types.`,ce,T,tt='In this guide, we will see how LoRA can be applied to a multilayer perceptron and a computer vision model from the <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library.',Me,k,ye,g,lt="Let’s assume that we want to fine-tune a multilayer perceptron with LoRA. Here is the definition:",ue,x,de,U,st="This is a straightforward multilayer perceptron with an input layer, a hidden layer, and an output layer.",he,w,be,C,nt=`There are a few linear layers in this model that could be tuned with LoRA. When working with common 🤗 Transformers
models, PEFT will know which layers to apply LoRA to, but in this case, it is up to us as a user to choose the layers.
To determine the names of the layers to tune:`,we,W,Je,Z,at="This should print:",fe,L,je,v,ot=`Let’s say we want to apply LoRA to the input layer and to the hidden layer, those are <code>&#39;seq.0&#39;</code> and <code>&#39;seq.2&#39;</code>. Moreover,
let’s assume we want to update the output layer without LoRA, that would be <code>&#39;seq.4&#39;</code>. The corresponding config would
be:`,Te,G,ke,_,it="With that, we can create our PEFT model and check the fraction of parameters trained:",ge,$,xe,I,mt="Finally, we can use any training framework we like, or write our own fit loop, to train the <code>peft_model</code>.",Ue,R,pt='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/multilayer_perceptron/multilayer_perceptron_lora.ipynb" rel="nofollow">this notebook</a>.',Ce,A,We,B,rt=`The <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a> library contains a large number of pretrained computer vision models.
Those can also be fine-tuned with PEFT. Let’s check out how this works in practice.`,Ze,V,ct="To start, ensure that timm is installed in the Python environment:",Le,E,ve,N,Mt="Next we load a timm model for an image classification task:",Ge,Y,_e,X,yt=`Again, we need to make a decision about what layers to apply LoRA to. Since LoRA supports 2D conv layers, and since
those are a major building block of this model, we should apply LoRA to the 2D conv layers. To identify the names of
those layers, let’s look at all the layer names:`,$e,S,Ie,Q,ut="This will print a very long list, we’ll only show the first few:",Re,F,Ae,H,dt=`Upon closer inspection, we see that the 2D conv layers have names such as <code>&quot;stages.0.blocks.0.mlp.fc1&quot;</code> and
<code>&quot;stages.0.blocks.0.mlp.fc2&quot;</code>. How can we match those layer names specifically? You can write a <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular
expressions</a> to match the layer names. For our case, the regex
<code>r&quot;.*\\.mlp\\.fc\\d&quot;</code> should do the job.`,Be,z,ht=`Furthermore, as in the first example, we should ensure that the output layer, in this case the classification head, is
also updated. Looking at the end of the list printed above, we can see that it’s named <code>&#39;head.fc&#39;</code>. With that in mind,
here is our LoRA config:`,Ve,q,Ee,D,bt="Then we only need to create the PEFT model by passing our base model and the config to <code>get_peft_model</code>:",Ne,P,Ye,K,wt="This shows us that we only need to train less than 2% of all parameters, which is a huge efficiency gain.",Xe,O,Jt='For a complete example, check out <a href="https://github.com/huggingface/peft/blob/main/examples/image_classification/image_classification_timm_peft_lora.ipynb" rel="nofollow">this notebook</a>.',Se,ee,Qe,te,ft="When new popular transformers architectures are released, we do our best to quickly add them to PEFT. If you come across a transformers model that is not supported out of the box, don’t worry, it will most likely still work if the config is set correctly. Specifically, you have to identify the layers that should be adapted and set them correctly when initializing the corresponding config class, e.g. <code>LoraConfig</code>. Here are some tips to help with this.",Fe,le,jt='As a first step, it is a good idea is to check the existing models for inspiration. You can find them inside of <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> in the PEFT repository. Often, you’ll find a similar architecture that uses the same names. For example, if the new model architecture is a variation of the “mistral” model and you want to apply LoRA, you can see that the entry for “mistral” in <code>TRANSFORMERS_MODELS_TO_LORA_TARGET_MODULES_MAPPING</code> contains <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>. This tells you that for “mistral” models, the <code>target_modules</code> for LoRA should be <code>[&quot;q_proj&quot;, &quot;v_proj&quot;]</code>:',He,se,ze,ne,Tt="If that doesn’t help, check the existing modules in your model architecture with the <code>named_modules</code> method and try to identify the attention layers, especially the key, query, and value layers. Those will often have names such as <code>c_attn</code>, <code>query</code>, <code>q_proj</code>, etc. The key layer is not always adapted, and ideally, you should check whether including it results in better performance.",qe,ae,kt='Additionally, linear layers are common targets to be adapted (e.g. in <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">QLoRA paper</a>, authors suggest to adapt them as well). Their names will often contain the strings <code>fc</code> or <code>dense</code>.',De,oe,gt='If you want to add a new model to PEFT, please create an entry in <a href="https://github.com/huggingface/peft/blob/main/src/peft/utils/constants.py" rel="nofollow">constants.py</a> and open a pull request on the <a href="https://github.com/huggingface/peft/pulls" rel="nofollow">repository</a>. Don’t forget to update the <a href="https://github.com/huggingface/peft#models-support-matrix" rel="nofollow">README</a> as well.',Pe,me,Ke;return f=new Oe({props:{title:"Working with custom models",local:"working-with-custom-models",headingTag:"h1"}}),k=new Oe({props:{title:"Multilayer perceptron",local:"multilayer-perceptron",headingTag:"h2"}}),x=new h({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyME1MUChubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG51bV91bml0c19oaWRkZW4lM0QyMDAwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2VxJTIwJTNEJTIwbm4uU2VxdWVudGlhbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIoMjAlMkMlMjBudW1fdW5pdHNfaGlkZGVuKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLlJlTFUoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5uLkxpbmVhcihudW1fdW5pdHNfaGlkZGVuJTJDJTIwbnVtX3VuaXRzX2hpZGRlbiklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5SZUxVKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBubi5MaW5lYXIobnVtX3VuaXRzX2hpZGRlbiUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm4uTG9nU29mdG1heChkaW0lM0QtMSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwWCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLnNlcShYKQ==",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MLP</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_units_hidden=<span class="hljs-number">2000</span></span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.seq = nn.Sequential(
            nn.Linear(<span class="hljs-number">20</span>, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, num_units_hidden),
            nn.ReLU(),
            nn.Linear(num_units_hidden, <span class="hljs-number">2</span>),
            nn.LogSoftmax(dim=-<span class="hljs-number">1</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, X</span>):
        <span class="hljs-keyword">return</span> self.seq(X)`,wrap:!1}}),w=new It({props:{$$slots:{default:[Rt]},$$scope:{ctx:pe}}}),W=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),L=new h({props:{code:"JTVCKCcnJTJDJTIwX19tYWluX18uTUxQKSUyQyUwQSUyMCgnc2VxJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuY29udGFpbmVyLlNlcXVlbnRpYWwpJTJDJTBBJTIwKCdzZXEuMCclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmxpbmVhci5MaW5lYXIpJTJDJTBBJTIwKCdzZXEuMSclMkMlMjB0b3JjaC5ubi5tb2R1bGVzLmFjdGl2YXRpb24uUmVMVSklMkMlMEElMjAoJ3NlcS4yJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMubGluZWFyLkxpbmVhciklMkMlMEElMjAoJ3NlcS4zJyUyQyUyMHRvcmNoLm5uLm1vZHVsZXMuYWN0aXZhdGlvbi5SZUxVKSUyQyUwQSUyMCgnc2VxLjQnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5saW5lYXIuTGluZWFyKSUyQyUwQSUyMCgnc2VxLjUnJTJDJTIwdG9yY2gubm4ubW9kdWxlcy5hY3RpdmF0aW9uLkxvZ1NvZnRtYXgpJTVE",highlighted:`[(&#x27;&#x27;, __main__.MLP),
 (<span class="hljs-symbol">&#x27;seq</span>&#x27;, torch.nn.modules.container.Sequential),
 (<span class="hljs-symbol">&#x27;seq.0</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.1</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.2</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.3</span>&#x27;, torch.nn.modules.activation.ReLU),
 (<span class="hljs-symbol">&#x27;seq.4</span>&#x27;, torch.nn.modules.linear.Linear),
 (<span class="hljs-symbol">&#x27;seq.5</span>&#x27;, torch.nn.modules.activation.LogSoftmax)]`,wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnNlcS4wJTIyJTJDJTIwJTIyc2VxLjIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJzZXEuNCUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;seq.0&quot;</span>, <span class="hljs-string">&quot;seq.2&quot;</span>],
    modules_to_save=[<span class="hljs-string">&quot;seq.4&quot;</span>],
)`,wrap:!1}}),$=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwTUxQKCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcpJTBBcGVmdF9tb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIzJTIwcHJpbnRzJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwNTYlMkMxNjQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA0JTJDMTAwJTJDMTY0JTIwJTdDJTdDJTIwdHJhaW5hYmxlJTI1JTNBJTIwMS4zNjk3OTg4NjY1ODE5MjI=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = MLP()
peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 56,164 || all params: 4,100,164 || trainable%: 1.369798866581922</span>`,wrap:!1}}),A=new Oe({props:{title:"timm models",local:"timm-models",headingTag:"h2"}}),E=new h({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0aW1t",highlighted:"python -m pip install -U timm",wrap:!1}}),Y=new h({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQW51bV9jbGFzc2VzJTIwJTNEJTIwLi4uJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJ0aW1tJTJGcG9vbGZvcm1lcl9tMzYuc2FpbF9pbjFrJTIyJTBBbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbChtb2RlbF9pZCUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fY2xhc3Nlcyk=",highlighted:`<span class="hljs-keyword">import</span> timm

num_classes = ...
model_id = <span class="hljs-string">&quot;timm/poolformer_m36.sail_in1k&quot;</span>
model = timm.create_model(model_id, pretrained=<span class="hljs-literal">True</span>, num_classes=num_classes)`,wrap:!1}}),S=new h({props:{code:"cHJpbnQoJTVCKG4lMkMlMjB0eXBlKG0pKSUyMGZvciUyMG4lMkMlMjBtJTIwaW4lMjBNTFAoKS5uYW1lZF9tb2R1bGVzKCklNUQp",highlighted:'<span class="hljs-built_in">print</span>([(n, <span class="hljs-built_in">type</span>(m)) <span class="hljs-keyword">for</span> n, m <span class="hljs-keyword">in</span> MLP().named_modules()])',wrap:!1}}),F=new h({props:{code:"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",highlighted:`[(<span class="hljs-string">&#x27;&#x27;</span>, timm.models.metaformer.MetaFormer),
 (<span class="hljs-string">&#x27;stem&#x27;</span>, timm.models.metaformer.Stem),
 (<span class="hljs-string">&#x27;stem.conv&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stem.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0&#x27;</span>, timm.models.metaformer.MetaFormerStage),
 (<span class="hljs-string">&#x27;stages.0.downsample&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.container.Sequential),
 (<span class="hljs-string">&#x27;stages.0.blocks.0&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale1&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.norm2&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp&#x27;</span>, timm.layers.mlp.Mlp),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.act&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.activation.GELU),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop1&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.norm&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.fc2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.conv.Conv2d),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.mlp.drop2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.dropout.Dropout),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.drop_path2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.layer_scale2&#x27;</span>, timm.models.metaformer.Scale),
 (<span class="hljs-string">&#x27;stages.0.blocks.0.res_scale2&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;stages.0.blocks.1&#x27;</span>, timm.models.metaformer.MetaFormerBlock),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.norm1&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.GroupNorm1),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer&#x27;</span>, timm.models.metaformer.Pooling),
 (<span class="hljs-string">&#x27;stages.0.blocks.1.token_mixer.pool&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.pooling.AvgPool2d),
 ...
 (<span class="hljs-string">&#x27;head.global_pool.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.norm&#x27;</span>, timm.layers.<span class="hljs-keyword">norm</span>.LayerNorm2d),
 (<span class="hljs-string">&#x27;head.flatten&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.flatten.Flatten),
 (<span class="hljs-string">&#x27;head.drop&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Identity),
 (<span class="hljs-string">&#x27;head.fc&#x27;</span>, torch.<span class="hljs-keyword">nn</span>.modules.linear.Linear)]
 ]`,wrap:!1}}),q=new h({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRHIlMjIuKiU1Qy5tbHAlNUMuZmMlNUNkJTIyJTJDJTIwbW9kdWxlc190b19zYXZlJTNEJTVCJTIyaGVhZC5mYyUyMiU1RCk=",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">r&quot;.*\\.mlp\\.fc\\d&quot;</span>, modules_to_save=[<span class="hljs-string">&quot;head.fc&quot;</span>])',wrap:!1}}),P=new h({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKSUwQXBlZnRfbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMyUyMHByaW50cyUyMHRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDElMkMwNjQlMkM0NTQlMjAlN0MlN0MlMjBhbGwlMjBwYXJhbXMlM0ElMjA1NiUyQzQ2NyUyQzk3NCUyMCU3QyU3QyUyMHRyYWluYWJsZSUyNSUzQSUyMDEuODg1MDU3ODkxMzk4NzY=",highlighted:`peft_model = get_peft_model(model, config)
peft_model.print_trainable_parameters()
<span class="hljs-comment"># prints trainable params: 1,064,454 || all params: 56,467,974 || trainable%: 1.88505789139876</span>`,wrap:!1}}),ee=new Oe({props:{title:"New transformers architectures",local:"new-transformers-architectures",headingTag:"h2"}}),se=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFteV9taXN0cmFsX21vZGVsJTIwJTNEJTIwLi4uJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMnFfcHJvaiUyMiUyQyUyMCUyMnZfcHJvaiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMC4uLiUyQyUyMCUyMCUyMyUyMG90aGVyJTIwTG9SQSUyMGFyZ3VtZW50cyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobXlfbWlzdHJhbF9tb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

my_mistral_model = ...
config = LoraConfig(
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>],
    ...,  <span class="hljs-comment"># other LoRA arguments</span>
)
peft_model = get_peft_model(my_mistral_model, config)`,wrap:!1}}),{c(){p=o("meta"),J=n(),b=o("p"),ie=n(),r(f.$$.fragment),re=n(),j=o("p"),j.innerHTML=et,ce=n(),T=o("p"),T.innerHTML=tt,Me=n(),r(k.$$.fragment),ye=n(),g=o("p"),g.textContent=lt,ue=n(),r(x.$$.fragment),de=n(),U=o("p"),U.textContent=st,he=n(),r(w.$$.fragment),be=n(),C=o("p"),C.textContent=nt,we=n(),r(W.$$.fragment),Je=n(),Z=o("p"),Z.textContent=at,fe=n(),r(L.$$.fragment),je=n(),v=o("p"),v.innerHTML=ot,Te=n(),r(G.$$.fragment),ke=n(),_=o("p"),_.textContent=it,ge=n(),r($.$$.fragment),xe=n(),I=o("p"),I.innerHTML=mt,Ue=n(),R=o("p"),R.innerHTML=pt,Ce=n(),r(A.$$.fragment),We=n(),B=o("p"),B.innerHTML=rt,Ze=n(),V=o("p"),V.textContent=ct,Le=n(),r(E.$$.fragment),ve=n(),N=o("p"),N.textContent=Mt,Ge=n(),r(Y.$$.fragment),_e=n(),X=o("p"),X.textContent=yt,$e=n(),r(S.$$.fragment),Ie=n(),Q=o("p"),Q.textContent=ut,Re=n(),r(F.$$.fragment),Ae=n(),H=o("p"),H.innerHTML=dt,Be=n(),z=o("p"),z.innerHTML=ht,Ve=n(),r(q.$$.fragment),Ee=n(),D=o("p"),D.innerHTML=bt,Ne=n(),r(P.$$.fragment),Ye=n(),K=o("p"),K.textContent=wt,Xe=n(),O=o("p"),O.innerHTML=Jt,Se=n(),r(ee.$$.fragment),Qe=n(),te=o("p"),te.innerHTML=ft,Fe=n(),le=o("p"),le.innerHTML=jt,He=n(),r(se.$$.fragment),ze=n(),ne=o("p"),ne.innerHTML=Tt,qe=n(),ae=o("p"),ae.innerHTML=kt,De=n(),oe=o("p"),oe.innerHTML=gt,Pe=n(),me=o("p"),this.h()},l(e){const t=_t("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),b=i(e,"P",{}),Ut(b).forEach(l),ie=a(e),c(f.$$.fragment,e),re=a(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1twj2ga"&&(j.innerHTML=et),ce=a(e),T=i(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-1xbl0bq"&&(T.innerHTML=tt),Me=a(e),c(k.$$.fragment,e),ye=a(e),g=i(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1vzm18b"&&(g.textContent=lt),ue=a(e),c(x.$$.fragment,e),de=a(e),U=i(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-o052zc"&&(U.textContent=st),he=a(e),c(w.$$.fragment,e),be=a(e),C=i(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-19hnh19"&&(C.textContent=nt),we=a(e),c(W.$$.fragment,e),Je=a(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-47m0b6"&&(Z.textContent=at),fe=a(e),c(L.$$.fragment,e),je=a(e),v=i(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-hvbljg"&&(v.innerHTML=ot),Te=a(e),c(G.$$.fragment,e),ke=a(e),_=i(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-12m4713"&&(_.textContent=it),ge=a(e),c($.$$.fragment,e),xe=a(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-3iyeuu"&&(I.innerHTML=mt),Ue=a(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-12a8po"&&(R.innerHTML=pt),Ce=a(e),c(A.$$.fragment,e),We=a(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1el2qhw"&&(B.innerHTML=rt),Ze=a(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-132k8n8"&&(V.textContent=ct),Le=a(e),c(E.$$.fragment,e),ve=a(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1i7knza"&&(N.textContent=Mt),Ge=a(e),c(Y.$$.fragment,e),_e=a(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-66d7qt"&&(X.textContent=yt),$e=a(e),c(S.$$.fragment,e),Ie=a(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-132x2pj"&&(Q.textContent=ut),Re=a(e),c(F.$$.fragment,e),Ae=a(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-odd6w6"&&(H.innerHTML=dt),Be=a(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vtvaop"&&(z.innerHTML=ht),Ve=a(e),c(q.$$.fragment,e),Ee=a(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1ym7j5n"&&(D.innerHTML=bt),Ne=a(e),c(P.$$.fragment,e),Ye=a(e),K=i(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1a6hk12"&&(K.textContent=wt),Xe=a(e),O=i(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13ceymq"&&(O.innerHTML=Jt),Se=a(e),c(ee.$$.fragment,e),Qe=a(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-zh7y7t"&&(te.innerHTML=ft),Fe=a(e),le=i(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-foxae4"&&(le.innerHTML=jt),He=a(e),c(se.$$.fragment,e),ze=a(e),ne=i(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-tkcysf"&&(ne.innerHTML=Tt),qe=a(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-8q7t0u"&&(ae.innerHTML=kt),De=a(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-485c9z"&&(oe.innerHTML=gt),Pe=a(e),me=i(e,"P",{}),Ut(me).forEach(l),this.h()},h(){Ct(p,"name","hf:doc:metadata"),Ct(p,"content",Bt)},m(e,t){$t(document.head,p),s(e,J,t),s(e,b,t),s(e,ie,t),M(f,e,t),s(e,re,t),s(e,j,t),s(e,ce,t),s(e,T,t),s(e,Me,t),M(k,e,t),s(e,ye,t),s(e,g,t),s(e,ue,t),M(x,e,t),s(e,de,t),s(e,U,t),s(e,he,t),M(w,e,t),s(e,be,t),s(e,C,t),s(e,we,t),M(W,e,t),s(e,Je,t),s(e,Z,t),s(e,fe,t),M(L,e,t),s(e,je,t),s(e,v,t),s(e,Te,t),M(G,e,t),s(e,ke,t),s(e,_,t),s(e,ge,t),M($,e,t),s(e,xe,t),s(e,I,t),s(e,Ue,t),s(e,R,t),s(e,Ce,t),M(A,e,t),s(e,We,t),s(e,B,t),s(e,Ze,t),s(e,V,t),s(e,Le,t),M(E,e,t),s(e,ve,t),s(e,N,t),s(e,Ge,t),M(Y,e,t),s(e,_e,t),s(e,X,t),s(e,$e,t),M(S,e,t),s(e,Ie,t),s(e,Q,t),s(e,Re,t),M(F,e,t),s(e,Ae,t),s(e,H,t),s(e,Be,t),s(e,z,t),s(e,Ve,t),M(q,e,t),s(e,Ee,t),s(e,D,t),s(e,Ne,t),M(P,e,t),s(e,Ye,t),s(e,K,t),s(e,Xe,t),s(e,O,t),s(e,Se,t),M(ee,e,t),s(e,Qe,t),s(e,te,t),s(e,Fe,t),s(e,le,t),s(e,He,t),M(se,e,t),s(e,ze,t),s(e,ne,t),s(e,qe,t),s(e,ae,t),s(e,De,t),s(e,oe,t),s(e,Pe,t),s(e,me,t),Ke=!0},p(e,[t]){const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),w.$set(xt)},i(e){Ke||(y(f.$$.fragment,e),y(k.$$.fragment,e),y(x.$$.fragment,e),y(w.$$.fragment,e),y(W.$$.fragment,e),y(L.$$.fragment,e),y(G.$$.fragment,e),y($.$$.fragment,e),y(A.$$.fragment,e),y(E.$$.fragment,e),y(Y.$$.fragment,e),y(S.$$.fragment,e),y(F.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),Ke=!0)},o(e){u(f.$$.fragment,e),u(k.$$.fragment,e),u(x.$$.fragment,e),u(w.$$.fragment,e),u(W.$$.fragment,e),u(L.$$.fragment,e),u(G.$$.fragment,e),u($.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(P.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),Ke=!1},d(e){e&&(l(J),l(b),l(ie),l(re),l(j),l(ce),l(T),l(Me),l(ye),l(g),l(ue),l(de),l(U),l(he),l(be),l(C),l(we),l(Je),l(Z),l(fe),l(je),l(v),l(Te),l(ke),l(_),l(ge),l(xe),l(I),l(Ue),l(R),l(Ce),l(We),l(B),l(Ze),l(V),l(Le),l(ve),l(N),l(Ge),l(_e),l(X),l($e),l(Ie),l(Q),l(Re),l(Ae),l(H),l(Be),l(z),l(Ve),l(Ee),l(D),l(Ne),l(Ye),l(K),l(Xe),l(O),l(Se),l(Qe),l(te),l(Fe),l(le),l(He),l(ze),l(ne),l(qe),l(ae),l(De),l(oe),l(Pe),l(me)),l(p),d(f,e),d(k,e),d(x,e),d(w,e),d(W,e),d(L,e),d(G,e),d($,e),d(A,e),d(E,e),d(Y,e),d(S,e),d(F,e),d(q,e),d(P,e),d(ee,e),d(se,e)}}}const Bt='{"title":"Working with custom models","local":"working-with-custom-models","sections":[{"title":"Multilayer perceptron","local":"multilayer-perceptron","sections":[],"depth":2},{"title":"timm models","local":"timm-models","sections":[],"depth":2},{"title":"New transformers architectures","local":"new-transformers-architectures","sections":[],"depth":2}],"depth":1}';function Vt(pe){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends vt{constructor(p){super(),Gt(this,p,Vt,At,Wt,{})}}export{Qt as component};
