import{s as Ca,f as Nl,n as ma,o as ha}from"../chunks/scheduler.37c15a92.js";import{S as ua,i as ba,g as n,s as e,r as U,A as Aa,h as t,f as s,c as y,j as ds,u as j,x as J,k as c,y as Za,a,v as w,d as T,t as p,w as I}from"../chunks/index.7cb9c9b8.js";import{C as d}from"../chunks/CodeBlock.a6d3f852.js";import{C as Ba}from"../chunks/CourseFloatingBanner.2c4a7381.js";import{H as i}from"../chunks/Heading.d3928e2a.js";function Ga(rs){let r,ql,Hl,xl,m,Ll,h,Kl,u,Cs="Now that we studied the theory behind PPO, the best way to understand how it works <strong>is to implement it from scratch.</strong>",Dl,b,ms="Implementing an architecture from scratch is the best way to understand it, and it’s a good habit. We have already done it for a value-based method with Q-Learning and a Policy-based method with Reinforce.",$l,A,hs="So, to be able to code it, we’re going to use two resources:",Pl,Z,us='<li>A tutorial made by <a href="https://github.com/vwxyzjn" rel="nofollow">Costa Huang</a>. Costa is behind <a href="https://github.com/vwxyzjn/cleanrl" rel="nofollow">CleanRL</a>, a Deep Reinforcement Learning library that provides high-quality single-file implementation with research-friendly features.</li> <li>In addition to the tutorial, to go deeper, you can read the 13 core implementation details: <a href="https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/" rel="nofollow">https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/</a></li>',Ol,B,bs="Then, to test its robustness, we’re going to train it in:",lM,G,As='<li><a href="https://www.gymlibrary.ml/environments/box2d/lunar_lander/" rel="nofollow">LunarLander-v2</a></li>',MM,C,Zs='<video alt="LunarLander" style="max-width: 70%; margin: auto;" autoplay="" loop="" autobuffer="" muted="" playsinline=""><source src="assets/63_deep_rl_intro/lunarlander.mp4" type="video/mp4"/></video>',sM,W,Bs="And finally, we will push the trained model to the Hub to evaluate and visualize your agent playing.",aM,X,Gs="LunarLander-v2 is the first environment you used when you started this course. At that time, you didn’t know how it worked, and now you can code it from scratch and train it. <strong>How incredible is that 🤩.</strong>",eM,o,Ws,g,Xs='<a href="https://giphy.com/gifs/the-office-michael-heartbreak-pynZagVcYxVUk">via GIPHY</a>',yM,k,gs="Let’s get started! 🚀",nM,_,ks="The colab notebook:",tM,R,_s='<a href="https://colab.research.google.com/github/huggingface/deep-rl-class/blob/master/notebooks/unit8/unit8_part1.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',JM,v,UM,Y,Rs,jM,f,vs="In this notebook, you’ll learn to <strong>code your PPO agent from scratch with PyTorch using CleanRL implementation as model</strong>.",wM,Q,Ys="To test its robustness, we’re going to train it in:",TM,V,fs='<li><a href="https://www.gymlibrary.dev/environments/box2d/lunar_lander/" rel="nofollow">LunarLander-v2 🚀</a></li>',pM,S,Qs='We’re constantly trying to improve our tutorials, so <strong>if you find some issues in this notebook</strong>, please <a href="https://github.com/huggingface/deep-rl-class/issues" rel="nofollow">open an issue on the GitHub Repo</a>.',IM,E,cM,F,Vs="At the end of the notebook, you will:",oM,N,Ss="<li>Be able to <strong>code your PPO agent from scratch using PyTorch</strong>.</li> <li>Be able to <strong>push your trained agent and the code to the Hub</strong> with a nice video replay and an evaluation score 🔥.</li>",iM,H,dM,z,Es="Before diving into the notebook, you need to:",rM,q,Fs='🔲 📚 Study <a href="https://huggingface.co/deep-rl-course/unit8/introduction" rel="nofollow">PPO by reading Unit 8</a> 🤗',CM,x,Ns='To validate this hands-on for the <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">certification process</a>, you need to push one model, we don’t ask for a minimal result but we <strong>advise you to try different hyperparameters settings to get better results</strong>.',mM,L,Hs="If you don’t find your model, <strong>go to the bottom of the page and click on the refresh button</strong>",hM,K,zs='For more information about the certification process, check this section 👉 <a href="https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process" rel="nofollow">https://huggingface.co/deep-rl-course/en/unit0/introduction#certification-process</a>',uM,D,bM,$,qs="<li>To <strong>accelerate the agent’s training, we’ll use a GPU</strong>. To do that, go to <code>Runtime &gt; Change Runtime type</code></li>",AM,P,xs,ZM,O,Ls="<li><code>Hardware Accelerator &gt; GPU</code></li>",BM,ll,Ks,GM,Ml,WM,sl,Ds="During the notebook, we’ll need to generate a replay video. To do so, with colab, <strong>we need to have a virtual screen to be able to render the environment</strong> (and thus record the frames).",XM,al,$s="Hence the following cell will install the librairies and create and run a virtual screen 🖥",gM,el,kM,yl,_M,nl,RM,tl,Ps="For this exercise, we use <code>gym==0.21</code> because the video was recorded with Gym.",vM,Jl,YM,Ul,fM,jl,Os='<li>For the core implementation of PPO we’re going to use the excellent <a href="https://costa.sh/" rel="nofollow">Costa Huang</a> tutorial.</li> <li>In addition to the tutorial, to go deeper you can read the 37 core implementation details: <a href="https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/" rel="nofollow">https://iclr-blog-track.github.io/2022/03/25/ppo-implementation-details/</a></li>',QM,wl,la='👉 The video tutorial: <a href="https://youtu.be/MEt6rrxH8W4" rel="nofollow">https://youtu.be/MEt6rrxH8W4</a>',VM,Tl,SM,pl,EM,Il,Ma="<li><p>In order to push our model to the Hub, we need to define a function <code>package_to_hub</code></p></li> <li><p>Add dependencies we need to push our model to the Hub</p></li>",FM,cl,NM,ol,sa="<li>Add new argument in <code>parse_args()</code> function to define the repo-id where we want to push the model.</li>",HM,il,zM,dl,aa="<li><p>Next, we add the methods needed to push the model to the Hub</p></li> <li><p>These methods will:</p> <ul><li><code>_evalutate_agent()</code>: evaluate the agent.</li> <li><code>_generate_model_card()</code>: generate the model card of your agent.</li> <li><code>_record_video()</code>: record a video of your agent.</li></ul></li>",qM,rl,xM,Cl,ea="<li>Finally, we call this function at the end of the PPO training</li>",LM,ml,KM,hl,ya="<li>Here’s what the final ppo.py file looks like:</li>",DM,ul,$M,bl,na="To be able to share your model with the community there are three more steps to follow:",PM,Al,ta='1️⃣ (If it’s not already done) create an account to HF ➡ <a href="https://huggingface.co/join" rel="nofollow">https://huggingface.co/join</a>',OM,Zl,Ja="2️⃣ Sign in and get your authentication token from the Hugging Face website.",ls,Bl,Ua='<li>Create a new token (<a href="https://huggingface.co/settings/tokens" rel="nofollow">https://huggingface.co/settings/tokens</a>) <strong>with write role</strong></li>',Ms,Gl,ja,ss,Wl,wa="<li>Copy the token</li> <li>Run the cell below and paste the token</li>",as,Xl,es,gl,Ta="If you don’t want to use Google Colab or a Jupyter Notebook, you need to use this command instead: <code>huggingface-cli login</code>",ys,kl,ns,_l,pa="⚠️ ⚠️ ⚠️  Don’t use <strong>the same repo id with the one you used for the Unit 1</strong>",ts,Rl,Ia="<li><p>Now that you’ve coded PPO from scratch and added the Hugging Face Integration, we’re ready to start the training 🔥</p></li> <li><p>First, you need to copy all your code to a file you create called <code>ppo.py</code></p></li>",Js,vl,ca,Us,Yl,oa,js,fl,ia="<li><p>Now we just need to run this python script using <code>python &lt;name-of-python-script&gt;.py</code> with the additional parameters we defined using <code>argparse</code></p></li> <li><p>You should modify more hyperparameters otherwise the training will not be super stable.</p></li>",ws,Ql,Ts,Vl,ps,Sl,da="The best way to learn <strong>is to try things on your own</strong>! Why not try another environment? Or why not trying to modify the implementation to work with Gymnasium?",Is,El,ra="See you in Unit 8, part 2 where we’re going to train agents to play Doom 🔥",cs,Fl,os,zl,is;return m=new i({props:{title:"Hands-on",local:"hands-on",headingTag:"h1"}}),h=new Ba({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/deep-rl-class/blob/main/notebooks/unit8/unit8_part1.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),v=new i({props:{title:"Unit 8: Proximal Policy Gradient (PPO) with PyTorch 🤖",local:"unit-8-proximal-policy-gradient-ppo-with-pytorch-",headingTag:"h1"}}),E=new i({props:{title:"Objectives of this notebook 🏆",local:"objectives-of-this-notebook-",headingTag:"h2"}}),H=new i({props:{title:"Prerequisites 🏗️",local:"prerequisites-",headingTag:"h2"}}),D=new i({props:{title:"Set the GPU 💪",local:"set-the-gpu-",headingTag:"h2"}}),Ml=new i({props:{title:"Create a virtual display 🔽",local:"create-a-virtual-display-",headingTag:"h2"}}),el=new d({props:{code:"YXB0JTIwaW5zdGFsbCUyMHB5dGhvbi1vcGVuZ2wlMEFhcHQlMjBpbnN0YWxsJTIwZmZtcGVnJTBBYXB0JTIwaW5zdGFsbCUyMHh2ZmIlMEFwaXAlMjBpbnN0YWxsJTIwcHlnbGV0JTNEJTNEMS41JTBBcGlwJTIwaW5zdGFsbCUyMHB5dmlydHVhbGRpc3BsYXk=",highlighted:`apt install python-opengl
apt install ffmpeg
apt install xvfb
pip install pyglet==<span class="hljs-number">1.5</span>
pip install pyvirtualdisplay`,wrap:!1}}),yl=new d({props:{code:"JTIzJTIwVmlydHVhbCUyMGRpc3BsYXklMEFmcm9tJTIwcHl2aXJ0dWFsZGlzcGxheSUyMGltcG9ydCUyMERpc3BsYXklMEElMEF2aXJ0dWFsX2Rpc3BsYXklMjAlM0QlMjBEaXNwbGF5KHZpc2libGUlM0QwJTJDJTIwc2l6ZSUzRCgxNDAwJTJDJTIwOTAwKSklMEF2aXJ0dWFsX2Rpc3BsYXkuc3RhcnQoKQ==",highlighted:`<span class="hljs-comment"># Virtual display</span>
<span class="hljs-keyword">from</span> pyvirtualdisplay <span class="hljs-keyword">import</span> Display

virtual_display = Display(visible=<span class="hljs-number">0</span>, size=(<span class="hljs-number">1400</span>, <span class="hljs-number">900</span>))
virtual_display.start()`,wrap:!1}}),nl=new i({props:{title:"Install dependencies 🔽",local:"install-dependencies-",headingTag:"h2"}}),Jl=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGd5bSUzRCUzRDAuMjIlMEFwaXAlMjBpbnN0YWxsJTIwaW1hZ2Vpby1mZm1wZWclMEFwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHViJTBBcGlwJTIwaW5zdGFsbCUyMGd5bSU1QmJveDJkJTVEJTNEJTNEMC4yMg==",highlighted:`pip install gym==<span class="hljs-number">0.22</span>
pip install imageio-ffmpeg
pip install huggingface_hub
pip install gym[box2d]==<span class="hljs-number">0.22</span>`,wrap:!1}}),Ul=new i({props:{title:"Let’s code PPO from scratch with Costa Huang’s tutorial",local:"lets-code-ppo-from-scratch-with-costa-huangs-tutorial",headingTag:"h2"}}),Tl=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEhUTUwlMEElMEFIVE1MKCUwQSUyMCUyMCUyMCUyMCclM0NpZnJhbWUlMjB3aWR0aCUzRCUyMjU2MCUyMiUyMGhlaWdodCUzRCUyMjMxNSUyMiUyMHNyYyUzRCUyMmh0dHBzJTNBJTJGJTJGd3d3LnlvdXR1YmUuY29tJTJGZW1iZWQlMkZNRXQ2cnJ4SDhXNCUyMiUyMHRpdGxlJTNEJTIyWW91VHViZSUyMHZpZGVvJTIwcGxheWVyJTIyJTIwZnJhbWVib3JkZXIlM0QlMjIwJTIyJTIwYWxsb3clM0QlMjJhY2NlbGVyb21ldGVyJTNCJTIwYXV0b3BsYXklM0IlMjBjbGlwYm9hcmQtd3JpdGUlM0IlMjBlbmNyeXB0ZWQtbWVkaWElM0IlMjBneXJvc2NvcGUlM0IlMjBwaWN0dXJlLWluLXBpY3R1cmUlMjIlMjBhbGxvd2Z1bGxzY3JlZW4lM0UlM0MlMkZpZnJhbWUlM0UnJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> HTML

HTML(
    <span class="hljs-string">&#x27;&lt;iframe width=&quot;560&quot; height=&quot;315&quot; src=&quot;https://www.youtube.com/embed/MEt6rrxH8W4&quot; title=&quot;YouTube video player&quot; frameborder=&quot;0&quot; allow=&quot;accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture&quot; allowfullscreen&gt;&lt;/iframe&gt;&#x27;</span>
)`,wrap:!1}}),pl=new i({props:{title:"Add the Hugging Face Integration 🤗",local:"add-the-hugging-face-integration-",headingTag:"h2"}}),cl=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwdXBsb2FkX2ZvbGRlciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIucmVwb2NhcmQlMjBpbXBvcnQlMjBtZXRhZGF0YV9ldmFsX3Jlc3VsdCUyQyUyMG1ldGFkYXRhX3NhdmUlMEElMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjBkYXRldGltZSUwQWltcG9ydCUyMHRlbXBmaWxlJTBBaW1wb3J0JTIwanNvbiUwQWltcG9ydCUyMHNodXRpbCUwQWltcG9ydCUyMGltYWdlaW8lMEElMEFmcm9tJTIwd2FzYWJpJTIwaW1wb3J0JTIwUHJpbnRlciUwQSUwQW1zZyUyMCUzRCUyMFByaW50ZXIoKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, upload_folder
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> tempfile
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> shutil
<span class="hljs-keyword">import</span> imageio

<span class="hljs-keyword">from</span> wasabi <span class="hljs-keyword">import</span> Printer

msg = Printer()`,wrap:!1}}),il=new d({props:{code:"JTIzJTIwQWRkaW5nJTIwSHVnZ2luZ0ZhY2UlMjBhcmd1bWVudCUwQXBhcnNlci5hZGRfYXJndW1lbnQoJTBBJTIwJTIwJTIwJTIwJTIyLS1yZXBvLWlkJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRHN0ciUyQyUwQSUyMCUyMCUyMCUyMGRlZmF1bHQlM0QlMjJUaG9tYXNTaW1vbmluaSUyRnBwby1DYXJ0UG9sZS12MSUyMiUyQyUwQSUyMCUyMCUyMCUyMGhlbHAlM0QlMjJpZCUyMG9mJTIwdGhlJTIwbW9kZWwlMjByZXBvc2l0b3J5JTIwZnJvbSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwJTdCdXNlcm5hbWUlMkZyZXBvX25hbWUlN0QlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Adding HuggingFace argument</span>
parser.add_argument(
    <span class="hljs-string">&quot;--repo-id&quot;</span>,
    <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>,
    default=<span class="hljs-string">&quot;ThomasSimonini/ppo-CartPole-v1&quot;</span>,
    <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;id of the model repository from the Hugging Face Hub {username/repo_name}&quot;</span>,
)`,wrap:!1}}),rl=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">package_to_hub</span>(<span class="hljs-params">
    repo_id,
    model,
    hyperparameters,
    eval_env,
    video_fps=<span class="hljs-number">30</span>,
    commit_message=<span class="hljs-string">&quot;Push agent to the Hub&quot;</span>,
    token=<span class="hljs-literal">None</span>,
    logs=<span class="hljs-literal">None</span>,
</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate, Generate a video and Upload a model to Hugging Face Hub.
    This method does the complete pipeline:
    - It evaluates the model
    - It generates the model card
    - It generates a replay video of the agent
    - It pushes everything to the hub
    :param repo_id: id of the model repository from the Hugging Face Hub
    :param model: trained model
    :param eval_env: environment used to evaluate the agent
    :param fps: number of fps for rendering the video
    :param commit_message: commit message
    :param logs: directory on local machine of tensorboard logs you&#x27;d like to upload
    &quot;&quot;&quot;</span>
    msg.info(
        <span class="hljs-string">&quot;This function will save, evaluate, generate a video of your agent, &quot;</span>
        <span class="hljs-string">&quot;create a model card and push everything to the hub. &quot;</span>
        <span class="hljs-string">&quot;It might take up to 1min. \\n &quot;</span>
        <span class="hljs-string">&quot;This is a work in progress: if you encounter a bug, please open an issue.&quot;</span>
    )
    <span class="hljs-comment"># Step 1: Clone or create the repo</span>
    repo_url = HfApi().create_repo(
        repo_id=repo_id,
        token=token,
        private=<span class="hljs-literal">False</span>,
        exist_ok=<span class="hljs-literal">True</span>,
    )

    <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdirname:
        tmpdirname = Path(tmpdirname)

        <span class="hljs-comment"># Step 2: Save the model</span>
        torch.save(model.state_dict(), tmpdirname / <span class="hljs-string">&quot;model.pt&quot;</span>)

        <span class="hljs-comment"># Step 3: Evaluate the model and build JSON</span>
        mean_reward, std_reward = _evaluate_agent(eval_env, <span class="hljs-number">10</span>, model)

        <span class="hljs-comment"># First get datetime</span>
        eval_datetime = datetime.datetime.now()
        eval_form_datetime = eval_datetime.isoformat()

        evaluate_data = {
            <span class="hljs-string">&quot;env_id&quot;</span>: hyperparameters.env_id,
            <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
            <span class="hljs-string">&quot;std_reward&quot;</span>: std_reward,
            <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;eval_datetime&quot;</span>: eval_form_datetime,
        }

        <span class="hljs-comment"># Write a JSON file</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(tmpdirname / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
            json.dump(evaluate_data, outfile)

        <span class="hljs-comment"># Step 4: Generate a video</span>
        video_path = tmpdirname / <span class="hljs-string">&quot;replay.mp4&quot;</span>
        record_video(eval_env, model, video_path, video_fps)

        <span class="hljs-comment"># Step 5: Generate the model card</span>
        generated_model_card, metadata = _generate_model_card(
            <span class="hljs-string">&quot;PPO&quot;</span>, hyperparameters.env_id, mean_reward, std_reward, hyperparameters
        )
        _save_model_card(tmpdirname, generated_model_card, metadata)

        <span class="hljs-comment"># Step 6: Add logs if needed</span>
        <span class="hljs-keyword">if</span> logs:
            _add_logdir(tmpdirname, Path(logs))

        msg.info(<span class="hljs-string">f&quot;Pushing repo <span class="hljs-subst">{repo_id}</span> to the Hugging Face Hub&quot;</span>)

        repo_url = upload_folder(
            repo_id=repo_id,
            folder_path=tmpdirname,
            path_in_repo=<span class="hljs-string">&quot;&quot;</span>,
            commit_message=commit_message,
            token=token,
        )

        msg.info(<span class="hljs-string">f&quot;Your model is pushed to the Hub. You can view your model here: <span class="hljs-subst">{repo_url}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> repo_url


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_evaluate_agent</span>(<span class="hljs-params">env, n_eval_episodes, policy</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param policy: The agent
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_eval_episodes):
        state = env.reset()
        step = <span class="hljs-number">0</span>
        done = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">while</span> done <span class="hljs-keyword">is</span> <span class="hljs-literal">False</span>:
            state = torch.Tensor(state).to(device)
            action, _, _, _ = policy.get_action_and_value(state)
            new_state, reward, done, info = env.step(action.cpu().numpy())
            total_rewards_ep += reward
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward


<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, policy, out_directory, fps=<span class="hljs-number">30</span></span>):
    images = []
    done = <span class="hljs-literal">False</span>
    state = env.reset()
    img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        state = torch.Tensor(state).to(device)
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action, _, _, _ = policy.get_action_and_value(state)
        state, reward, done, info = env.step(
            action.cpu().numpy()
        )  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_model_card</span>(<span class="hljs-params">model_name, env_id, mean_reward, std_reward, hyperparameters</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate the model card for the Hub
    :param model_name: name of the model
    :env_id: name of the environment
    :mean_reward: mean reward of the agent
    :std_reward: standard deviation of the mean reward of the agent
    :hyperparameters: training arguments
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Step 1: Select the tags</span>
    metadata = generate_metadata(model_name, env_id, mean_reward, std_reward)

    <span class="hljs-comment"># Transform the hyperparams namespace to string</span>
    converted_dict = <span class="hljs-built_in">vars</span>(hyperparameters)
    converted_str = <span class="hljs-built_in">str</span>(converted_dict)
    converted_str = converted_str.split(<span class="hljs-string">&quot;, &quot;</span>)
    converted_str = <span class="hljs-string">&quot;\\n&quot;</span>.join(converted_str)

    <span class="hljs-comment"># Step 2: Generate the model card</span>
    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # PPO Agent Playing <span class="hljs-subst">{env_id}</span>

  This is a trained model of a PPO agent playing <span class="hljs-subst">{env_id}</span>.

  # Hyperparameters
  &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> model_card, metadata


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_metadata</span>(<span class="hljs-params">model_name, env_id, mean_reward, std_reward</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Define the tags for the model card
    :param model_name: name of the model
    :param env_id: name of the environment
    :mean_reward: mean reward of the agent
    :std_reward: standard deviation of the mean reward of the agent
    &quot;&quot;&quot;</span>
    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [
        env_id,
        <span class="hljs-string">&quot;ppo&quot;</span>,
        <span class="hljs-string">&quot;deep-reinforcement-learning&quot;</span>,
        <span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        <span class="hljs-string">&quot;custom-implementation&quot;</span>,
        <span class="hljs-string">&quot;deep-rl-course&quot;</span>,
    ]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=model_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_id,
        dataset_id=env_id,
    )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    <span class="hljs-keyword">return</span> metadata


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_model_card</span>(<span class="hljs-params">local_path, generated_model_card, metadata</span>):
    <span class="hljs-string">&quot;&quot;&quot;Saves a model card for the repository.
    :param local_path: repository directory
    :param generated_model_card: model card generated by _generate_model_card()
    :param metadata: metadata
    &quot;&quot;&quot;</span>
    readme_path = local_path / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
            readme = f.read()
    <span class="hljs-keyword">else</span>:
        readme = generated_model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_add_logdir</span>(<span class="hljs-params">local_path: Path, logdir: Path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Adds a logdir to the repository.
    :param local_path: repository directory
    :param logdir: logdir directory
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> logdir.exists() <span class="hljs-keyword">and</span> logdir.is_dir():
        <span class="hljs-comment"># Add the logdir to the repository under new dir called logs</span>
        repo_logdir = local_path / <span class="hljs-string">&quot;logs&quot;</span>

        <span class="hljs-comment"># Delete current logs if they exist</span>
        <span class="hljs-keyword">if</span> repo_logdir.exists():
            shutil.rmtree(repo_logdir)

        <span class="hljs-comment"># Copy logdir into repo logdir</span>
        shutil.copytree(logdir, repo_logdir)`,wrap:!1}}),ml=new d({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZXZhbHVhdGlvbiUyMGVudmlyb25tZW50JTBBZXZhbF9lbnYlMjAlM0QlMjBneW0ubWFrZShhcmdzLmVudl9pZCklMEElMEFwYWNrYWdlX3RvX2h1YiglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEYXJncy5yZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RhZ2VudCUyQyUyMCUyMCUyMyUyMFRoZSUyMG1vZGVsJTIwd2UlMjB3YW50JTIwdG8lMjBzYXZlJTBBJTIwJTIwJTIwJTIwaHlwZXJwYXJhbWV0ZXJzJTNEYXJncyUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZW52JTNEZ3ltLm1ha2UoYXJncy5lbnZfaWQpJTJDJTBBJTIwJTIwJTIwJTIwbG9ncyUzRGYlMjJydW5zJTJGJTdCcnVuX25hbWUlN0QlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Create the evaluation environment</span>
eval_env = gym.make(args.env_id)

package_to_hub(
    repo_id=args.repo_id,
    model=agent,  <span class="hljs-comment"># The model we want to save</span>
    hyperparameters=args,
    eval_env=gym.make(args.env_id),
    logs=<span class="hljs-string">f&quot;runs/<span class="hljs-subst">{run_name}</span>&quot;</span>,
)`,wrap:!1}}),ul=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># docs and experiment results can be found at https://docs.cleanrl.dev/rl-algorithms/ppo/#ppopy</span>

<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> distutils.util <span class="hljs-keyword">import</span> strtobool

<span class="hljs-keyword">import</span> gym
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> torch.optim <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> torch.distributions.categorical <span class="hljs-keyword">import</span> Categorical
<span class="hljs-keyword">from</span> torch.utils.tensorboard <span class="hljs-keyword">import</span> SummaryWriter

<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, upload_folder
<span class="hljs-keyword">from</span> huggingface_hub.repocard <span class="hljs-keyword">import</span> metadata_eval_result, metadata_save

<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> tempfile
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">import</span> shutil
<span class="hljs-keyword">import</span> imageio

<span class="hljs-keyword">from</span> wasabi <span class="hljs-keyword">import</span> Printer

msg = Printer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">parse_args</span>():
    <span class="hljs-comment"># fmt: off</span>
    parser = argparse.ArgumentParser()
    parser.add_argument(<span class="hljs-string">&quot;--exp-name&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.path.basename(__file__).rstrip(<span class="hljs-string">&quot;.py&quot;</span>),
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the name of this experiment&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--seed&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">1</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;seed of the experiment&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--torch-deterministic&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;if toggled, \`torch.backends.cudnn.deterministic=False\`&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--cuda&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;if toggled, cuda will be enabled by default&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--track&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">False</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;if toggled, this experiment will be tracked with Weights and Biases&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--wandb-project-name&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=<span class="hljs-string">&quot;cleanRL&quot;</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the wandb&#x27;s project name&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--wandb-entity&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=<span class="hljs-literal">None</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the entity (team) of wandb&#x27;s project&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--capture-video&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">False</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;weather to capture videos of the agent performances (check out \`videos\` folder)&quot;</span>)

    <span class="hljs-comment"># Algorithm specific arguments</span>
    parser.add_argument(<span class="hljs-string">&quot;--env-id&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=<span class="hljs-string">&quot;CartPole-v1&quot;</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the id of the environment&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--total-timesteps&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">50000</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;total timesteps of the experiments&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--learning-rate&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">2.5e-4</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the learning rate of the optimizer&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--num-envs&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">4</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the number of parallel game environments&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--num-steps&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">128</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the number of steps to run in each environment per policy rollout&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--anneal-lr&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Toggle learning rate annealing for policy and value networks&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--gae&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Use GAE for advantage computation&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--gamma&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.99</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the discount factor gamma&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--gae-lambda&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.95</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the lambda for the general advantage estimation&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--num-minibatches&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">4</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the number of mini-batches&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--update-epochs&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">4</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the K epochs to update the policy&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--norm-adv&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Toggles advantages normalization&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--clip-coef&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.2</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the surrogate clipping coefficient&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--clip-vloss&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">bool</span>(strtobool(x)), default=<span class="hljs-literal">True</span>, nargs=<span class="hljs-string">&quot;?&quot;</span>, const=<span class="hljs-literal">True</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;Toggles whether or not to use a clipped loss for the value function, as per the paper.&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--ent-coef&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.01</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;coefficient of the entropy&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--vf-coef&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.5</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;coefficient of the value function&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--max-grad-norm&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-number">0.5</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the maximum norm for the gradient clipping&quot;</span>)
    parser.add_argument(<span class="hljs-string">&quot;--target-kl&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">float</span>, default=<span class="hljs-literal">None</span>,
        <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;the target KL divergence threshold&quot;</span>)

    <span class="hljs-comment"># Adding HuggingFace argument</span>
    parser.add_argument(<span class="hljs-string">&quot;--repo-id&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=<span class="hljs-string">&quot;ThomasSimonini/ppo-CartPole-v1&quot;</span>, <span class="hljs-built_in">help</span>=<span class="hljs-string">&quot;id of the model repository from the Hugging Face Hub {username/repo_name}&quot;</span>)

    args = parser.parse_args()
    args.batch_size = <span class="hljs-built_in">int</span>(args.num_envs * args.num_steps)
    args.minibatch_size = <span class="hljs-built_in">int</span>(args.batch_size // args.num_minibatches)
    <span class="hljs-comment"># fmt: on</span>
    <span class="hljs-keyword">return</span> args


<span class="hljs-keyword">def</span> <span class="hljs-title function_">package_to_hub</span>(<span class="hljs-params">
    repo_id,
    model,
    hyperparameters,
    eval_env,
    video_fps=<span class="hljs-number">30</span>,
    commit_message=<span class="hljs-string">&quot;Push agent to the Hub&quot;</span>,
    token=<span class="hljs-literal">None</span>,
    logs=<span class="hljs-literal">None</span>,
</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate, Generate a video and Upload a model to Hugging Face Hub.
    This method does the complete pipeline:
    - It evaluates the model
    - It generates the model card
    - It generates a replay video of the agent
    - It pushes everything to the hub
    :param repo_id: id of the model repository from the Hugging Face Hub
    :param model: trained model
    :param eval_env: environment used to evaluate the agent
    :param fps: number of fps for rendering the video
    :param commit_message: commit message
    :param logs: directory on local machine of tensorboard logs you&#x27;d like to upload
    &quot;&quot;&quot;</span>
    msg.info(
        <span class="hljs-string">&quot;This function will save, evaluate, generate a video of your agent, &quot;</span>
        <span class="hljs-string">&quot;create a model card and push everything to the hub. &quot;</span>
        <span class="hljs-string">&quot;It might take up to 1min. \\n &quot;</span>
        <span class="hljs-string">&quot;This is a work in progress: if you encounter a bug, please open an issue.&quot;</span>
    )
    <span class="hljs-comment"># Step 1: Clone or create the repo</span>
    repo_url = HfApi().create_repo(
        repo_id=repo_id,
        token=token,
        private=<span class="hljs-literal">False</span>,
        exist_ok=<span class="hljs-literal">True</span>,
    )

    <span class="hljs-keyword">with</span> tempfile.TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdirname:
        tmpdirname = Path(tmpdirname)

        <span class="hljs-comment"># Step 2: Save the model</span>
        torch.save(model.state_dict(), tmpdirname / <span class="hljs-string">&quot;model.pt&quot;</span>)

        <span class="hljs-comment"># Step 3: Evaluate the model and build JSON</span>
        mean_reward, std_reward = _evaluate_agent(eval_env, <span class="hljs-number">10</span>, model)

        <span class="hljs-comment"># First get datetime</span>
        eval_datetime = datetime.datetime.now()
        eval_form_datetime = eval_datetime.isoformat()

        evaluate_data = {
            <span class="hljs-string">&quot;env_id&quot;</span>: hyperparameters.env_id,
            <span class="hljs-string">&quot;mean_reward&quot;</span>: mean_reward,
            <span class="hljs-string">&quot;std_reward&quot;</span>: std_reward,
            <span class="hljs-string">&quot;n_evaluation_episodes&quot;</span>: <span class="hljs-number">10</span>,
            <span class="hljs-string">&quot;eval_datetime&quot;</span>: eval_form_datetime,
        }

        <span class="hljs-comment"># Write a JSON file</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(tmpdirname / <span class="hljs-string">&quot;results.json&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> outfile:
            json.dump(evaluate_data, outfile)

        <span class="hljs-comment"># Step 4: Generate a video</span>
        video_path = tmpdirname / <span class="hljs-string">&quot;replay.mp4&quot;</span>
        record_video(eval_env, model, video_path, video_fps)

        <span class="hljs-comment"># Step 5: Generate the model card</span>
        generated_model_card, metadata = _generate_model_card(
            <span class="hljs-string">&quot;PPO&quot;</span>, hyperparameters.env_id, mean_reward, std_reward, hyperparameters
        )
        _save_model_card(tmpdirname, generated_model_card, metadata)

        <span class="hljs-comment"># Step 6: Add logs if needed</span>
        <span class="hljs-keyword">if</span> logs:
            _add_logdir(tmpdirname, Path(logs))

        msg.info(<span class="hljs-string">f&quot;Pushing repo <span class="hljs-subst">{repo_id}</span> to the Hugging Face Hub&quot;</span>)

        repo_url = upload_folder(
            repo_id=repo_id,
            folder_path=tmpdirname,
            path_in_repo=<span class="hljs-string">&quot;&quot;</span>,
            commit_message=commit_message,
            token=token,
        )

        msg.info(<span class="hljs-string">f&quot;Your model is pushed to the Hub. You can view your model here: <span class="hljs-subst">{repo_url}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> repo_url


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_evaluate_agent</span>(<span class="hljs-params">env, n_eval_episodes, policy</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Evaluate the agent for \`\`n_eval_episodes\`\` episodes and returns average reward and std of reward.
    :param env: The evaluation environment
    :param n_eval_episodes: Number of episode to evaluate the agent
    :param policy: The agent
    &quot;&quot;&quot;</span>
    episode_rewards = []
    <span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_eval_episodes):
        state = env.reset()
        step = <span class="hljs-number">0</span>
        done = <span class="hljs-literal">False</span>
        total_rewards_ep = <span class="hljs-number">0</span>

        <span class="hljs-keyword">while</span> done <span class="hljs-keyword">is</span> <span class="hljs-literal">False</span>:
            state = torch.Tensor(state).to(device)
            action, _, _, _ = policy.get_action_and_value(state)
            new_state, reward, done, info = env.step(action.cpu().numpy())
            total_rewards_ep += reward
            <span class="hljs-keyword">if</span> done:
                <span class="hljs-keyword">break</span>
            state = new_state
        episode_rewards.append(total_rewards_ep)
    mean_reward = np.mean(episode_rewards)
    std_reward = np.std(episode_rewards)

    <span class="hljs-keyword">return</span> mean_reward, std_reward


<span class="hljs-keyword">def</span> <span class="hljs-title function_">record_video</span>(<span class="hljs-params">env, policy, out_directory, fps=<span class="hljs-number">30</span></span>):
    images = []
    done = <span class="hljs-literal">False</span>
    state = env.reset()
    img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
    images.append(img)
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        state = torch.Tensor(state).to(device)
        <span class="hljs-comment"># Take the action (index) that have the maximum expected future reward given that state</span>
        action, _, _, _ = policy.get_action_and_value(state)
        state, reward, done, info = env.step(
            action.cpu().numpy()
        )  <span class="hljs-comment"># We directly put next_state = state for recording logic</span>
        img = env.render(mode=<span class="hljs-string">&quot;rgb_array&quot;</span>)
        images.append(img)
    imageio.mimsave(out_directory, [np.array(img) <span class="hljs-keyword">for</span> i, img <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(images)], fps=fps)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_generate_model_card</span>(<span class="hljs-params">model_name, env_id, mean_reward, std_reward, hyperparameters</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Generate the model card for the Hub
    :param model_name: name of the model
    :env_id: name of the environment
    :mean_reward: mean reward of the agent
    :std_reward: standard deviation of the mean reward of the agent
    :hyperparameters: training arguments
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Step 1: Select the tags</span>
    metadata = generate_metadata(model_name, env_id, mean_reward, std_reward)

    <span class="hljs-comment"># Transform the hyperparams namespace to string</span>
    converted_dict = <span class="hljs-built_in">vars</span>(hyperparameters)
    converted_str = <span class="hljs-built_in">str</span>(converted_dict)
    converted_str = converted_str.split(<span class="hljs-string">&quot;, &quot;</span>)
    converted_str = <span class="hljs-string">&quot;\\n&quot;</span>.join(converted_str)

    <span class="hljs-comment"># Step 2: Generate the model card</span>
    model_card = <span class="hljs-string">f&quot;&quot;&quot;
  # PPO Agent Playing <span class="hljs-subst">{env_id}</span>

  This is a trained model of a PPO agent playing <span class="hljs-subst">{env_id}</span>.

  # Hyperparameters
  &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> model_card, metadata


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_metadata</span>(<span class="hljs-params">model_name, env_id, mean_reward, std_reward</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Define the tags for the model card
    :param model_name: name of the model
    :param env_id: name of the environment
    :mean_reward: mean reward of the agent
    :std_reward: standard deviation of the mean reward of the agent
    &quot;&quot;&quot;</span>
    metadata = {}
    metadata[<span class="hljs-string">&quot;tags&quot;</span>] = [
        env_id,
        <span class="hljs-string">&quot;ppo&quot;</span>,
        <span class="hljs-string">&quot;deep-reinforcement-learning&quot;</span>,
        <span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        <span class="hljs-string">&quot;custom-implementation&quot;</span>,
        <span class="hljs-string">&quot;deep-rl-course&quot;</span>,
    ]

    <span class="hljs-comment"># Add metrics</span>
    <span class="hljs-built_in">eval</span> = metadata_eval_result(
        model_pretty_name=model_name,
        task_pretty_name=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        task_id=<span class="hljs-string">&quot;reinforcement-learning&quot;</span>,
        metrics_pretty_name=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_id=<span class="hljs-string">&quot;mean_reward&quot;</span>,
        metrics_value=<span class="hljs-string">f&quot;<span class="hljs-subst">{mean_reward:<span class="hljs-number">.2</span>f}</span> +/- <span class="hljs-subst">{std_reward:<span class="hljs-number">.2</span>f}</span>&quot;</span>,
        dataset_pretty_name=env_id,
        dataset_id=env_id,
    )

    <span class="hljs-comment"># Merges both dictionaries</span>
    metadata = {**metadata, **<span class="hljs-built_in">eval</span>}

    <span class="hljs-keyword">return</span> metadata


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_model_card</span>(<span class="hljs-params">local_path, generated_model_card, metadata</span>):
    <span class="hljs-string">&quot;&quot;&quot;Saves a model card for the repository.
    :param local_path: repository directory
    :param generated_model_card: model card generated by _generate_model_card()
    :param metadata: metadata
    &quot;&quot;&quot;</span>
    readme_path = local_path / <span class="hljs-string">&quot;README.md&quot;</span>
    readme = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> readme_path.exists():
        <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;r&quot;</span>, encoding=<span class="hljs-string">&quot;utf8&quot;</span>) <span class="hljs-keyword">as</span> f:
            readme = f.read()
    <span class="hljs-keyword">else</span>:
        readme = generated_model_card

    <span class="hljs-keyword">with</span> readme_path.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
        f.write(readme)

    <span class="hljs-comment"># Save our metrics to Readme metadata</span>
    metadata_save(readme_path, metadata)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_add_logdir</span>(<span class="hljs-params">local_path: Path, logdir: Path</span>):
    <span class="hljs-string">&quot;&quot;&quot;Adds a logdir to the repository.
    :param local_path: repository directory
    :param logdir: logdir directory
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> logdir.exists() <span class="hljs-keyword">and</span> logdir.is_dir():
        <span class="hljs-comment"># Add the logdir to the repository under new dir called logs</span>
        repo_logdir = local_path / <span class="hljs-string">&quot;logs&quot;</span>

        <span class="hljs-comment"># Delete current logs if they exist</span>
        <span class="hljs-keyword">if</span> repo_logdir.exists():
            shutil.rmtree(repo_logdir)

        <span class="hljs-comment"># Copy logdir into repo logdir</span>
        shutil.copytree(logdir, repo_logdir)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_env</span>(<span class="hljs-params">env_id, seed, idx, capture_video, run_name</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">thunk</span>():
        env = gym.make(env_id)
        env = gym.wrappers.RecordEpisodeStatistics(env)
        <span class="hljs-keyword">if</span> capture_video:
            <span class="hljs-keyword">if</span> idx == <span class="hljs-number">0</span>:
                env = gym.wrappers.RecordVideo(env, <span class="hljs-string">f&quot;videos/<span class="hljs-subst">{run_name}</span>&quot;</span>)
        env.seed(seed)
        env.action_space.seed(seed)
        env.observation_space.seed(seed)
        <span class="hljs-keyword">return</span> env

    <span class="hljs-keyword">return</span> thunk


<span class="hljs-keyword">def</span> <span class="hljs-title function_">layer_init</span>(<span class="hljs-params">layer, std=np.sqrt(<span class="hljs-params"><span class="hljs-number">2</span></span>), bias_const=<span class="hljs-number">0.0</span></span>):
    torch.nn.init.orthogonal_(layer.weight, std)
    torch.nn.init.constant_(layer.bias, bias_const)
    <span class="hljs-keyword">return</span> layer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Agent</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, envs</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.critic = nn.Sequential(
            layer_init(nn.Linear(np.array(envs.single_observation_space.shape).prod(), <span class="hljs-number">64</span>)),
            nn.Tanh(),
            layer_init(nn.Linear(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>)),
            nn.Tanh(),
            layer_init(nn.Linear(<span class="hljs-number">64</span>, <span class="hljs-number">1</span>), std=<span class="hljs-number">1.0</span>),
        )
        self.actor = nn.Sequential(
            layer_init(nn.Linear(np.array(envs.single_observation_space.shape).prod(), <span class="hljs-number">64</span>)),
            nn.Tanh(),
            layer_init(nn.Linear(<span class="hljs-number">64</span>, <span class="hljs-number">64</span>)),
            nn.Tanh(),
            layer_init(nn.Linear(<span class="hljs-number">64</span>, envs.single_action_space.n), std=<span class="hljs-number">0.01</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_value</span>(<span class="hljs-params">self, x</span>):
        <span class="hljs-keyword">return</span> self.critic(x)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_action_and_value</span>(<span class="hljs-params">self, x, action=<span class="hljs-literal">None</span></span>):
        logits = self.actor(x)
        probs = Categorical(logits=logits)
        <span class="hljs-keyword">if</span> action <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
            action = probs.sample()
        <span class="hljs-keyword">return</span> action, probs.log_prob(action), probs.entropy(), self.critic(x)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    args = parse_args()
    run_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{args.env_id}</span>__<span class="hljs-subst">{args.exp_name}</span>__<span class="hljs-subst">{args.seed}</span>__<span class="hljs-subst">{<span class="hljs-built_in">int</span>(time.time())}</span>&quot;</span>
    <span class="hljs-keyword">if</span> args.track:
        <span class="hljs-keyword">import</span> wandb

        wandb.init(
            project=args.wandb_project_name,
            entity=args.wandb_entity,
            sync_tensorboard=<span class="hljs-literal">True</span>,
            config=<span class="hljs-built_in">vars</span>(args),
            name=run_name,
            monitor_gym=<span class="hljs-literal">True</span>,
            save_code=<span class="hljs-literal">True</span>,
        )
    writer = SummaryWriter(<span class="hljs-string">f&quot;runs/<span class="hljs-subst">{run_name}</span>&quot;</span>)
    writer.add_text(
        <span class="hljs-string">&quot;hyperparameters&quot;</span>,
        <span class="hljs-string">&quot;|param|value|\\n|-|-|\\n%s&quot;</span> % (<span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;|<span class="hljs-subst">{key}</span>|<span class="hljs-subst">{value}</span>|&quot;</span> <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> <span class="hljs-built_in">vars</span>(args).items()])),
    )

    <span class="hljs-comment"># TRY NOT TO MODIFY: seeding</span>
    random.seed(args.seed)
    np.random.seed(args.seed)
    torch.manual_seed(args.seed)
    torch.backends.cudnn.deterministic = args.torch_deterministic

    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">and</span> args.cuda <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

    <span class="hljs-comment"># env setup</span>
    envs = gym.vector.SyncVectorEnv(
        [make_env(args.env_id, args.seed + i, i, args.capture_video, run_name) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(args.num_envs)]
    )
    <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(envs.single_action_space, gym.spaces.Discrete), <span class="hljs-string">&quot;only discrete action space is supported&quot;</span>

    agent = Agent(envs).to(device)
    optimizer = optim.Adam(agent.parameters(), lr=args.learning_rate, eps=<span class="hljs-number">1e-5</span>)

    <span class="hljs-comment"># ALGO Logic: Storage setup</span>
    obs = torch.zeros((args.num_steps, args.num_envs) + envs.single_observation_space.shape).to(device)
    actions = torch.zeros((args.num_steps, args.num_envs) + envs.single_action_space.shape).to(device)
    logprobs = torch.zeros((args.num_steps, args.num_envs)).to(device)
    rewards = torch.zeros((args.num_steps, args.num_envs)).to(device)
    dones = torch.zeros((args.num_steps, args.num_envs)).to(device)
    values = torch.zeros((args.num_steps, args.num_envs)).to(device)

    <span class="hljs-comment"># TRY NOT TO MODIFY: start the game</span>
    global_step = <span class="hljs-number">0</span>
    start_time = time.time()
    next_obs = torch.Tensor(envs.reset()).to(device)
    next_done = torch.zeros(args.num_envs).to(device)
    num_updates = args.total_timesteps // args.batch_size

    <span class="hljs-keyword">for</span> update <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, num_updates + <span class="hljs-number">1</span>):
        <span class="hljs-comment"># Annealing the rate if instructed to do so.</span>
        <span class="hljs-keyword">if</span> args.anneal_lr:
            frac = <span class="hljs-number">1.0</span> - (update - <span class="hljs-number">1.0</span>) / num_updates
            lrnow = frac * args.learning_rate
            optimizer.param_groups[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;lr&quot;</span>] = lrnow

        <span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, args.num_steps):
            global_step += <span class="hljs-number">1</span> * args.num_envs
            obs[step] = next_obs
            dones[step] = next_done

            <span class="hljs-comment"># ALGO LOGIC: action logic</span>
            <span class="hljs-keyword">with</span> torch.no_grad():
                action, logprob, _, value = agent.get_action_and_value(next_obs)
                values[step] = value.flatten()
            actions[step] = action
            logprobs[step] = logprob

            <span class="hljs-comment"># TRY NOT TO MODIFY: execute the game and log data.</span>
            next_obs, reward, done, info = envs.step(action.cpu().numpy())
            rewards[step] = torch.tensor(reward).to(device).view(-<span class="hljs-number">1</span>)
            next_obs, next_done = torch.Tensor(next_obs).to(device), torch.Tensor(done).to(device)

            <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> info:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;episode&quot;</span> <span class="hljs-keyword">in</span> item.keys():
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;global_step=<span class="hljs-subst">{global_step}</span>, episodic_return=<span class="hljs-subst">{item[<span class="hljs-string">&#x27;episode&#x27;</span>][<span class="hljs-string">&#x27;r&#x27;</span>]}</span>&quot;</span>)
                    writer.add_scalar(<span class="hljs-string">&quot;charts/episodic_return&quot;</span>, item[<span class="hljs-string">&quot;episode&quot;</span>][<span class="hljs-string">&quot;r&quot;</span>], global_step)
                    writer.add_scalar(<span class="hljs-string">&quot;charts/episodic_length&quot;</span>, item[<span class="hljs-string">&quot;episode&quot;</span>][<span class="hljs-string">&quot;l&quot;</span>], global_step)
                    <span class="hljs-keyword">break</span>

        <span class="hljs-comment"># bootstrap value if not done</span>
        <span class="hljs-keyword">with</span> torch.no_grad():
            next_value = agent.get_value(next_obs).reshape(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)
            <span class="hljs-keyword">if</span> args.gae:
                advantages = torch.zeros_like(rewards).to(device)
                lastgaelam = <span class="hljs-number">0</span>
                <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">reversed</span>(<span class="hljs-built_in">range</span>(args.num_steps)):
                    <span class="hljs-keyword">if</span> t == args.num_steps - <span class="hljs-number">1</span>:
                        nextnonterminal = <span class="hljs-number">1.0</span> - next_done
                        nextvalues = next_value
                    <span class="hljs-keyword">else</span>:
                        nextnonterminal = <span class="hljs-number">1.0</span> - dones[t + <span class="hljs-number">1</span>]
                        nextvalues = values[t + <span class="hljs-number">1</span>]
                    delta = rewards[t] + args.gamma * nextvalues * nextnonterminal - values[t]
                    advantages[t] = lastgaelam = delta + args.gamma * args.gae_lambda * nextnonterminal * lastgaelam
                returns = advantages + values
            <span class="hljs-keyword">else</span>:
                returns = torch.zeros_like(rewards).to(device)
                <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> <span class="hljs-built_in">reversed</span>(<span class="hljs-built_in">range</span>(args.num_steps)):
                    <span class="hljs-keyword">if</span> t == args.num_steps - <span class="hljs-number">1</span>:
                        nextnonterminal = <span class="hljs-number">1.0</span> - next_done
                        next_return = next_value
                    <span class="hljs-keyword">else</span>:
                        nextnonterminal = <span class="hljs-number">1.0</span> - dones[t + <span class="hljs-number">1</span>]
                        next_return = returns[t + <span class="hljs-number">1</span>]
                    returns[t] = rewards[t] + args.gamma * nextnonterminal * next_return
                advantages = returns - values

        <span class="hljs-comment"># flatten the batch</span>
        b_obs = obs.reshape((-<span class="hljs-number">1</span>,) + envs.single_observation_space.shape)
        b_logprobs = logprobs.reshape(-<span class="hljs-number">1</span>)
        b_actions = actions.reshape((-<span class="hljs-number">1</span>,) + envs.single_action_space.shape)
        b_advantages = advantages.reshape(-<span class="hljs-number">1</span>)
        b_returns = returns.reshape(-<span class="hljs-number">1</span>)
        b_values = values.reshape(-<span class="hljs-number">1</span>)

        <span class="hljs-comment"># Optimizing the policy and value network</span>
        b_inds = np.arange(args.batch_size)
        clipfracs = []
        <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(args.update_epochs):
            np.random.shuffle(b_inds)
            <span class="hljs-keyword">for</span> start <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, args.batch_size, args.minibatch_size):
                end = start + args.minibatch_size
                mb_inds = b_inds[start:end]

                _, newlogprob, entropy, newvalue = agent.get_action_and_value(
                    b_obs[mb_inds], b_actions.long()[mb_inds]
                )
                logratio = newlogprob - b_logprobs[mb_inds]
                ratio = logratio.exp()

                <span class="hljs-keyword">with</span> torch.no_grad():
                    <span class="hljs-comment"># calculate approx_kl http://joschu.net/blog/kl-approx.html</span>
                    old_approx_kl = (-logratio).mean()
                    approx_kl = ((ratio - <span class="hljs-number">1</span>) - logratio).mean()
                    clipfracs += [((ratio - <span class="hljs-number">1.0</span>).<span class="hljs-built_in">abs</span>() &gt; args.clip_coef).<span class="hljs-built_in">float</span>().mean().item()]

                mb_advantages = b_advantages[mb_inds]
                <span class="hljs-keyword">if</span> args.norm_adv:
                    mb_advantages = (mb_advantages - mb_advantages.mean()) / (mb_advantages.std() + <span class="hljs-number">1e-8</span>)

                <span class="hljs-comment"># Policy loss</span>
                pg_loss1 = -mb_advantages * ratio
                pg_loss2 = -mb_advantages * torch.clamp(ratio, <span class="hljs-number">1</span> - args.clip_coef, <span class="hljs-number">1</span> + args.clip_coef)
                pg_loss = torch.<span class="hljs-built_in">max</span>(pg_loss1, pg_loss2).mean()

                <span class="hljs-comment"># Value loss</span>
                newvalue = newvalue.view(-<span class="hljs-number">1</span>)
                <span class="hljs-keyword">if</span> args.clip_vloss:
                    v_loss_unclipped = (newvalue - b_returns[mb_inds]) ** <span class="hljs-number">2</span>
                    v_clipped = b_values[mb_inds] + torch.clamp(
                        newvalue - b_values[mb_inds],
                        -args.clip_coef,
                        args.clip_coef,
                    )
                    v_loss_clipped = (v_clipped - b_returns[mb_inds]) ** <span class="hljs-number">2</span>
                    v_loss_max = torch.<span class="hljs-built_in">max</span>(v_loss_unclipped, v_loss_clipped)
                    v_loss = <span class="hljs-number">0.5</span> * v_loss_max.mean()
                <span class="hljs-keyword">else</span>:
                    v_loss = <span class="hljs-number">0.5</span> * ((newvalue - b_returns[mb_inds]) ** <span class="hljs-number">2</span>).mean()

                entropy_loss = entropy.mean()
                loss = pg_loss - args.ent_coef * entropy_loss + v_loss * args.vf_coef

                optimizer.zero_grad()
                loss.backward()
                nn.utils.clip_grad_norm_(agent.parameters(), args.max_grad_norm)
                optimizer.step()

            <span class="hljs-keyword">if</span> args.target_kl <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                <span class="hljs-keyword">if</span> approx_kl &gt; args.target_kl:
                    <span class="hljs-keyword">break</span>

        y_pred, y_true = b_values.cpu().numpy(), b_returns.cpu().numpy()
        var_y = np.var(y_true)
        explained_var = np.nan <span class="hljs-keyword">if</span> var_y == <span class="hljs-number">0</span> <span class="hljs-keyword">else</span> <span class="hljs-number">1</span> - np.var(y_true - y_pred) / var_y

        <span class="hljs-comment"># TRY NOT TO MODIFY: record rewards for plotting purposes</span>
        writer.add_scalar(<span class="hljs-string">&quot;charts/learning_rate&quot;</span>, optimizer.param_groups[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;lr&quot;</span>], global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/value_loss&quot;</span>, v_loss.item(), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/policy_loss&quot;</span>, pg_loss.item(), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/entropy&quot;</span>, entropy_loss.item(), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/old_approx_kl&quot;</span>, old_approx_kl.item(), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/approx_kl&quot;</span>, approx_kl.item(), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/clipfrac&quot;</span>, np.mean(clipfracs), global_step)
        writer.add_scalar(<span class="hljs-string">&quot;losses/explained_variance&quot;</span>, explained_var, global_step)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;SPS:&quot;</span>, <span class="hljs-built_in">int</span>(global_step / (time.time() - start_time)))
        writer.add_scalar(<span class="hljs-string">&quot;charts/SPS&quot;</span>, <span class="hljs-built_in">int</span>(global_step / (time.time() - start_time)), global_step)

    envs.close()
    writer.close()

    <span class="hljs-comment"># Create the evaluation environment</span>
    eval_env = gym.make(args.env_id)

    package_to_hub(
        repo_id=args.repo_id,
        model=agent,  <span class="hljs-comment"># The model we want to save</span>
        hyperparameters=args,
        eval_env=gym.make(args.env_id),
        logs=<span class="hljs-string">f&quot;runs/<span class="hljs-subst">{run_name}</span>&quot;</span>,
    )`,wrap:!1}}),Xl=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKSUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
notebook_login()
!git config --<span class="hljs-keyword">global</span> credential.helper store`,wrap:!1}}),kl=new i({props:{title:"Let’s start the training 🔥",local:"lets-start-the-training-",headingTag:"h2"}}),Ql=new d({props:{code:"IXB5dGhvbiUyMHBwby5weSUyMC0tZW52LWlkJTNEJTIyTHVuYXJMYW5kZXItdjIlMjIlMjAtLXJlcG8taWQlM0QlMjJZT1VSX1JFUE9fSUQlMjIlMjAtLXRvdGFsLXRpbWVzdGVwcyUzRDUwMDAw",highlighted:'!python ppo.py --env-<span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;LunarLander-v2&quot;</span> --repo-<span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;YOUR_REPO_ID&quot;</span> --total-timesteps=<span class="hljs-number">50000</span>',wrap:!1}}),Vl=new i({props:{title:"Some additional challenges 🏆",local:"some-additional-challenges-",headingTag:"h2"}}),Fl=new i({props:{title:"Keep learning, stay awesome 🤗",local:"keep-learning-stay-awesome-",headingTag:"h2"}}),{c(){r=n("meta"),ql=e(),Hl=n("p"),xl=e(),U(m.$$.fragment),Ll=e(),U(h.$$.fragment),Kl=e(),u=n("p"),u.innerHTML=Cs,Dl=e(),b=n("p"),b.textContent=ms,$l=e(),A=n("p"),A.textContent=hs,Pl=e(),Z=n("ul"),Z.innerHTML=us,Ol=e(),B=n("p"),B.textContent=bs,lM=e(),G=n("ul"),G.innerHTML=As,MM=e(),C=n("figure"),C.innerHTML=Zs,sM=e(),W=n("p"),W.textContent=Bs,aM=e(),X=n("p"),X.innerHTML=Gs,eM=e(),o=n("iframe"),g=n("p"),g.innerHTML=Xs,yM=e(),k=n("p"),k.textContent=gs,nM=e(),_=n("p"),_.textContent=ks,tM=e(),R=n("p"),R.innerHTML=_s,JM=e(),U(v.$$.fragment),UM=e(),Y=n("img"),jM=e(),f=n("p"),f.innerHTML=vs,wM=e(),Q=n("p"),Q.textContent=Ys,TM=e(),V=n("ul"),V.innerHTML=fs,pM=e(),S=n("p"),S.innerHTML=Qs,IM=e(),U(E.$$.fragment),cM=e(),F=n("p"),F.textContent=Vs,oM=e(),N=n("ul"),N.innerHTML=Ss,iM=e(),U(H.$$.fragment),dM=e(),z=n("p"),z.textContent=Es,rM=e(),q=n("p"),q.innerHTML=Fs,CM=e(),x=n("p"),x.innerHTML=Ns,mM=e(),L=n("p"),L.innerHTML=Hs,hM=e(),K=n("p"),K.innerHTML=zs,uM=e(),U(D.$$.fragment),bM=e(),$=n("ul"),$.innerHTML=qs,AM=e(),P=n("img"),ZM=e(),O=n("ul"),O.innerHTML=Ls,BM=e(),ll=n("img"),GM=e(),U(Ml.$$.fragment),WM=e(),sl=n("p"),sl.innerHTML=Ds,XM=e(),al=n("p"),al.textContent=$s,gM=e(),U(el.$$.fragment),kM=e(),U(yl.$$.fragment),_M=e(),U(nl.$$.fragment),RM=e(),tl=n("p"),tl.innerHTML=Ps,vM=e(),U(Jl.$$.fragment),YM=e(),U(Ul.$$.fragment),fM=e(),jl=n("ul"),jl.innerHTML=Os,QM=e(),wl=n("p"),wl.innerHTML=la,VM=e(),U(Tl.$$.fragment),SM=e(),U(pl.$$.fragment),EM=e(),Il=n("ul"),Il.innerHTML=Ma,FM=e(),U(cl.$$.fragment),NM=e(),ol=n("ul"),ol.innerHTML=sa,HM=e(),U(il.$$.fragment),zM=e(),dl=n("ul"),dl.innerHTML=aa,qM=e(),U(rl.$$.fragment),xM=e(),Cl=n("ul"),Cl.innerHTML=ea,LM=e(),U(ml.$$.fragment),KM=e(),hl=n("ul"),hl.innerHTML=ya,DM=e(),U(ul.$$.fragment),$M=e(),bl=n("p"),bl.textContent=na,PM=e(),Al=n("p"),Al.innerHTML=ta,OM=e(),Zl=n("p"),Zl.textContent=Ja,ls=e(),Bl=n("ul"),Bl.innerHTML=Ua,Ms=e(),Gl=n("img"),ss=e(),Wl=n("ul"),Wl.innerHTML=wa,as=e(),U(Xl.$$.fragment),es=e(),gl=n("p"),gl.innerHTML=Ta,ys=e(),U(kl.$$.fragment),ns=e(),_l=n("p"),_l.innerHTML=pa,ts=e(),Rl=n("ul"),Rl.innerHTML=Ia,Js=e(),vl=n("img"),Us=e(),Yl=n("img"),js=e(),fl=n("ul"),fl.innerHTML=ia,ws=e(),U(Ql.$$.fragment),Ts=e(),U(Vl.$$.fragment),ps=e(),Sl=n("p"),Sl.innerHTML=da,Is=e(),El=n("p"),El.textContent=ra,cs=e(),U(Fl.$$.fragment),os=e(),zl=n("p"),this.h()},l(l){const M=Aa("svelte-u9bgzb",document.head);r=t(M,"META",{name:!0,content:!0}),M.forEach(s),ql=y(l),Hl=t(l,"P",{}),ds(Hl).forEach(s),xl=y(l),j(m.$$.fragment,l),Ll=y(l),j(h.$$.fragment,l),Kl=y(l),u=t(l,"P",{"data-svelte-h":!0}),J(u)!=="svelte-2owoae"&&(u.innerHTML=Cs),Dl=y(l),b=t(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-1c7rcci"&&(b.textContent=ms),$l=y(l),A=t(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1x1mz24"&&(A.textContent=hs),Pl=y(l),Z=t(l,"UL",{"data-svelte-h":!0}),J(Z)!=="svelte-11hn9qr"&&(Z.innerHTML=us),Ol=y(l),B=t(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-i13sx"&&(B.textContent=bs),lM=y(l),G=t(l,"UL",{"data-svelte-h":!0}),J(G)!=="svelte-10th4nk"&&(G.innerHTML=As),MM=y(l),C=t(l,"FIGURE",{class:!0,"data-svelte-h":!0}),J(C)!=="svelte-7zu1n"&&(C.innerHTML=Zs),sM=y(l),W=t(l,"P",{"data-svelte-h":!0}),J(W)!=="svelte-1jrklsr"&&(W.textContent=Bs),aM=y(l),X=t(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-4q9zma"&&(X.innerHTML=Gs),eM=y(l),o=t(l,"IFRAME",{src:!0,width:!0,height:!0,frameborder:!0,class:!0}),ds(o).forEach(s),g=t(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-17tx960"&&(g.innerHTML=Xs),yM=y(l),k=t(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-147h8es"&&(k.textContent=gs),nM=y(l),_=t(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-524btn"&&(_.textContent=ks),tM=y(l),R=t(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-1aw3kao"&&(R.innerHTML=_s),JM=y(l),j(v.$$.fragment,l),UM=y(l),Y=t(l,"IMG",{src:!0,alt:!0}),jM=y(l),f=t(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-18t4url"&&(f.innerHTML=vs),wM=y(l),Q=t(l,"P",{"data-svelte-h":!0}),J(Q)!=="svelte-rwcvj0"&&(Q.textContent=Ys),TM=y(l),V=t(l,"UL",{"data-svelte-h":!0}),J(V)!=="svelte-ixlcvf"&&(V.innerHTML=fs),pM=y(l),S=t(l,"P",{"data-svelte-h":!0}),J(S)!=="svelte-qqj2y4"&&(S.innerHTML=Qs),IM=y(l),j(E.$$.fragment,l),cM=y(l),F=t(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-nsjs09"&&(F.textContent=Vs),oM=y(l),N=t(l,"UL",{"data-svelte-h":!0}),J(N)!=="svelte-1w7k4lq"&&(N.innerHTML=Ss),iM=y(l),j(H.$$.fragment,l),dM=y(l),z=t(l,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1v25wk6"&&(z.textContent=Es),rM=y(l),q=t(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-1rt9qg2"&&(q.innerHTML=Fs),CM=y(l),x=t(l,"P",{"data-svelte-h":!0}),J(x)!=="svelte-lemop9"&&(x.innerHTML=Ns),mM=y(l),L=t(l,"P",{"data-svelte-h":!0}),J(L)!=="svelte-19noeh0"&&(L.innerHTML=Hs),hM=y(l),K=t(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-1qkxyrx"&&(K.innerHTML=zs),uM=y(l),j(D.$$.fragment,l),bM=y(l),$=t(l,"UL",{"data-svelte-h":!0}),J($)!=="svelte-1funvfi"&&($.innerHTML=qs),AM=y(l),P=t(l,"IMG",{src:!0,alt:!0}),ZM=y(l),O=t(l,"UL",{"data-svelte-h":!0}),J(O)!=="svelte-1cge6gn"&&(O.innerHTML=Ls),BM=y(l),ll=t(l,"IMG",{src:!0,alt:!0}),GM=y(l),j(Ml.$$.fragment,l),WM=y(l),sl=t(l,"P",{"data-svelte-h":!0}),J(sl)!=="svelte-pdx5k3"&&(sl.innerHTML=Ds),XM=y(l),al=t(l,"P",{"data-svelte-h":!0}),J(al)!=="svelte-2fclea"&&(al.textContent=$s),gM=y(l),j(el.$$.fragment,l),kM=y(l),j(yl.$$.fragment,l),_M=y(l),j(nl.$$.fragment,l),RM=y(l),tl=t(l,"P",{"data-svelte-h":!0}),J(tl)!=="svelte-ndtk69"&&(tl.innerHTML=Ps),vM=y(l),j(Jl.$$.fragment,l),YM=y(l),j(Ul.$$.fragment,l),fM=y(l),jl=t(l,"UL",{"data-svelte-h":!0}),J(jl)!=="svelte-1gb5ne2"&&(jl.innerHTML=Os),QM=y(l),wl=t(l,"P",{"data-svelte-h":!0}),J(wl)!=="svelte-1mmp06f"&&(wl.innerHTML=la),VM=y(l),j(Tl.$$.fragment,l),SM=y(l),j(pl.$$.fragment,l),EM=y(l),Il=t(l,"UL",{"data-svelte-h":!0}),J(Il)!=="svelte-bnsqm1"&&(Il.innerHTML=Ma),FM=y(l),j(cl.$$.fragment,l),NM=y(l),ol=t(l,"UL",{"data-svelte-h":!0}),J(ol)!=="svelte-irn6t8"&&(ol.innerHTML=sa),HM=y(l),j(il.$$.fragment,l),zM=y(l),dl=t(l,"UL",{"data-svelte-h":!0}),J(dl)!=="svelte-11wm6j9"&&(dl.innerHTML=aa),qM=y(l),j(rl.$$.fragment,l),xM=y(l),Cl=t(l,"UL",{"data-svelte-h":!0}),J(Cl)!=="svelte-p0138m"&&(Cl.innerHTML=ea),LM=y(l),j(ml.$$.fragment,l),KM=y(l),hl=t(l,"UL",{"data-svelte-h":!0}),J(hl)!=="svelte-1nlpr0d"&&(hl.innerHTML=ya),DM=y(l),j(ul.$$.fragment,l),$M=y(l),bl=t(l,"P",{"data-svelte-h":!0}),J(bl)!=="svelte-6k9qpu"&&(bl.textContent=na),PM=y(l),Al=t(l,"P",{"data-svelte-h":!0}),J(Al)!=="svelte-932u9c"&&(Al.innerHTML=ta),OM=y(l),Zl=t(l,"P",{"data-svelte-h":!0}),J(Zl)!=="svelte-adopwf"&&(Zl.textContent=Ja),ls=y(l),Bl=t(l,"UL",{"data-svelte-h":!0}),J(Bl)!=="svelte-19b5tev"&&(Bl.innerHTML=Ua),Ms=y(l),Gl=t(l,"IMG",{src:!0,alt:!0}),ss=y(l),Wl=t(l,"UL",{"data-svelte-h":!0}),J(Wl)!=="svelte-mbo7r4"&&(Wl.innerHTML=wa),as=y(l),j(Xl.$$.fragment,l),es=y(l),gl=t(l,"P",{"data-svelte-h":!0}),J(gl)!=="svelte-1gq4mmb"&&(gl.innerHTML=Ta),ys=y(l),j(kl.$$.fragment,l),ns=y(l),_l=t(l,"P",{"data-svelte-h":!0}),J(_l)!=="svelte-1r8x9sb"&&(_l.innerHTML=pa),ts=y(l),Rl=t(l,"UL",{"data-svelte-h":!0}),J(Rl)!=="svelte-1y1q5d4"&&(Rl.innerHTML=Ia),Js=y(l),vl=t(l,"IMG",{src:!0,alt:!0}),Us=y(l),Yl=t(l,"IMG",{src:!0,alt:!0}),js=y(l),fl=t(l,"UL",{"data-svelte-h":!0}),J(fl)!=="svelte-1n0kte7"&&(fl.innerHTML=ia),ws=y(l),j(Ql.$$.fragment,l),Ts=y(l),j(Vl.$$.fragment,l),ps=y(l),Sl=t(l,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-mqshk9"&&(Sl.innerHTML=da),Is=y(l),El=t(l,"P",{"data-svelte-h":!0}),J(El)!=="svelte-19wlx3g"&&(El.textContent=ra),cs=y(l),j(Fl.$$.fragment,l),os=y(l),zl=t(l,"P",{}),ds(zl).forEach(s),this.h()},h(){c(r,"name","hf:doc:metadata"),c(r,"content",Wa),c(C,"class","image table text-center m-0 w-full"),Nl(o.src,Ws="https://giphy.com/embed/pynZagVcYxVUk")||c(o,"src",Ws),c(o,"width","480"),c(o,"height","480"),c(o,"frameborder","0"),c(o,"class","giphy-embed"),o.allowFullscreen=!0,Nl(Y.src,Rs="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/thumbnail.png")||c(Y,"src",Rs),c(Y,"alt","Unit 8"),Nl(P.src,xs="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step1.jpg")||c(P,"src",xs),c(P,"alt","GPU Step 1"),Nl(ll.src,Ks="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/gpu-step2.jpg")||c(ll,"src",Ks),c(ll,"alt","GPU Step 2"),Nl(Gl.src,ja="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/notebooks/create-token.jpg")||c(Gl,"src",ja),c(Gl,"alt","Create HF Token"),Nl(vl.src,ca="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/step1.png")||c(vl,"src",ca),c(vl,"alt","PPO"),Nl(Yl.src,oa="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/step2.png")||c(Yl,"src",oa),c(Yl,"alt","PPO")},m(l,M){Za(document.head,r),a(l,ql,M),a(l,Hl,M),a(l,xl,M),w(m,l,M),a(l,Ll,M),w(h,l,M),a(l,Kl,M),a(l,u,M),a(l,Dl,M),a(l,b,M),a(l,$l,M),a(l,A,M),a(l,Pl,M),a(l,Z,M),a(l,Ol,M),a(l,B,M),a(l,lM,M),a(l,G,M),a(l,MM,M),a(l,C,M),a(l,sM,M),a(l,W,M),a(l,aM,M),a(l,X,M),a(l,eM,M),a(l,o,M),a(l,g,M),a(l,yM,M),a(l,k,M),a(l,nM,M),a(l,_,M),a(l,tM,M),a(l,R,M),a(l,JM,M),w(v,l,M),a(l,UM,M),a(l,Y,M),a(l,jM,M),a(l,f,M),a(l,wM,M),a(l,Q,M),a(l,TM,M),a(l,V,M),a(l,pM,M),a(l,S,M),a(l,IM,M),w(E,l,M),a(l,cM,M),a(l,F,M),a(l,oM,M),a(l,N,M),a(l,iM,M),w(H,l,M),a(l,dM,M),a(l,z,M),a(l,rM,M),a(l,q,M),a(l,CM,M),a(l,x,M),a(l,mM,M),a(l,L,M),a(l,hM,M),a(l,K,M),a(l,uM,M),w(D,l,M),a(l,bM,M),a(l,$,M),a(l,AM,M),a(l,P,M),a(l,ZM,M),a(l,O,M),a(l,BM,M),a(l,ll,M),a(l,GM,M),w(Ml,l,M),a(l,WM,M),a(l,sl,M),a(l,XM,M),a(l,al,M),a(l,gM,M),w(el,l,M),a(l,kM,M),w(yl,l,M),a(l,_M,M),w(nl,l,M),a(l,RM,M),a(l,tl,M),a(l,vM,M),w(Jl,l,M),a(l,YM,M),w(Ul,l,M),a(l,fM,M),a(l,jl,M),a(l,QM,M),a(l,wl,M),a(l,VM,M),w(Tl,l,M),a(l,SM,M),w(pl,l,M),a(l,EM,M),a(l,Il,M),a(l,FM,M),w(cl,l,M),a(l,NM,M),a(l,ol,M),a(l,HM,M),w(il,l,M),a(l,zM,M),a(l,dl,M),a(l,qM,M),w(rl,l,M),a(l,xM,M),a(l,Cl,M),a(l,LM,M),w(ml,l,M),a(l,KM,M),a(l,hl,M),a(l,DM,M),w(ul,l,M),a(l,$M,M),a(l,bl,M),a(l,PM,M),a(l,Al,M),a(l,OM,M),a(l,Zl,M),a(l,ls,M),a(l,Bl,M),a(l,Ms,M),a(l,Gl,M),a(l,ss,M),a(l,Wl,M),a(l,as,M),w(Xl,l,M),a(l,es,M),a(l,gl,M),a(l,ys,M),w(kl,l,M),a(l,ns,M),a(l,_l,M),a(l,ts,M),a(l,Rl,M),a(l,Js,M),a(l,vl,M),a(l,Us,M),a(l,Yl,M),a(l,js,M),a(l,fl,M),a(l,ws,M),w(Ql,l,M),a(l,Ts,M),w(Vl,l,M),a(l,ps,M),a(l,Sl,M),a(l,Is,M),a(l,El,M),a(l,cs,M),w(Fl,l,M),a(l,os,M),a(l,zl,M),is=!0},p:ma,i(l){is||(T(m.$$.fragment,l),T(h.$$.fragment,l),T(v.$$.fragment,l),T(E.$$.fragment,l),T(H.$$.fragment,l),T(D.$$.fragment,l),T(Ml.$$.fragment,l),T(el.$$.fragment,l),T(yl.$$.fragment,l),T(nl.$$.fragment,l),T(Jl.$$.fragment,l),T(Ul.$$.fragment,l),T(Tl.$$.fragment,l),T(pl.$$.fragment,l),T(cl.$$.fragment,l),T(il.$$.fragment,l),T(rl.$$.fragment,l),T(ml.$$.fragment,l),T(ul.$$.fragment,l),T(Xl.$$.fragment,l),T(kl.$$.fragment,l),T(Ql.$$.fragment,l),T(Vl.$$.fragment,l),T(Fl.$$.fragment,l),is=!0)},o(l){p(m.$$.fragment,l),p(h.$$.fragment,l),p(v.$$.fragment,l),p(E.$$.fragment,l),p(H.$$.fragment,l),p(D.$$.fragment,l),p(Ml.$$.fragment,l),p(el.$$.fragment,l),p(yl.$$.fragment,l),p(nl.$$.fragment,l),p(Jl.$$.fragment,l),p(Ul.$$.fragment,l),p(Tl.$$.fragment,l),p(pl.$$.fragment,l),p(cl.$$.fragment,l),p(il.$$.fragment,l),p(rl.$$.fragment,l),p(ml.$$.fragment,l),p(ul.$$.fragment,l),p(Xl.$$.fragment,l),p(kl.$$.fragment,l),p(Ql.$$.fragment,l),p(Vl.$$.fragment,l),p(Fl.$$.fragment,l),is=!1},d(l){l&&(s(ql),s(Hl),s(xl),s(Ll),s(Kl),s(u),s(Dl),s(b),s($l),s(A),s(Pl),s(Z),s(Ol),s(B),s(lM),s(G),s(MM),s(C),s(sM),s(W),s(aM),s(X),s(eM),s(o),s(g),s(yM),s(k),s(nM),s(_),s(tM),s(R),s(JM),s(UM),s(Y),s(jM),s(f),s(wM),s(Q),s(TM),s(V),s(pM),s(S),s(IM),s(cM),s(F),s(oM),s(N),s(iM),s(dM),s(z),s(rM),s(q),s(CM),s(x),s(mM),s(L),s(hM),s(K),s(uM),s(bM),s($),s(AM),s(P),s(ZM),s(O),s(BM),s(ll),s(GM),s(WM),s(sl),s(XM),s(al),s(gM),s(kM),s(_M),s(RM),s(tl),s(vM),s(YM),s(fM),s(jl),s(QM),s(wl),s(VM),s(SM),s(EM),s(Il),s(FM),s(NM),s(ol),s(HM),s(zM),s(dl),s(qM),s(xM),s(Cl),s(LM),s(KM),s(hl),s(DM),s($M),s(bl),s(PM),s(Al),s(OM),s(Zl),s(ls),s(Bl),s(Ms),s(Gl),s(ss),s(Wl),s(as),s(es),s(gl),s(ys),s(ns),s(_l),s(ts),s(Rl),s(Js),s(vl),s(Us),s(Yl),s(js),s(fl),s(ws),s(Ts),s(ps),s(Sl),s(Is),s(El),s(cs),s(os),s(zl)),s(r),I(m,l),I(h,l),I(v,l),I(E,l),I(H,l),I(D,l),I(Ml,l),I(el,l),I(yl,l),I(nl,l),I(Jl,l),I(Ul,l),I(Tl,l),I(pl,l),I(cl,l),I(il,l),I(rl,l),I(ml,l),I(ul,l),I(Xl,l),I(kl,l),I(Ql,l),I(Vl,l),I(Fl,l)}}}const Wa='{"title":"Hands-on","local":"hands-on","sections":[],"depth":1}';function Xa(rs){return ha(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ya extends ua{constructor(r){super(),ba(this,r,Xa,Ga,Ca,{})}}export{Ya as component};
