import{s as St,o as At,n as Pt}from"../chunks/scheduler.9bc65507.js";import{S as Kt,i as Dt,g as i,s as l,r as p,A as Ot,h as o,f as s,c as n,j as Yt,u as m,x as r,k as ft,y as es,a,v as d,d as u,t as c,w as g}from"../chunks/index.707bf1b6.js";import{T as ts}from"../chunks/Tip.c2ecdbf4.js";import{C as T}from"../chunks/CodeBlock.54a9f38d.js";import{D as ss}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as y}from"../chunks/Heading.342b1fa6.js";function as(Me){let h,j='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){h=i("p"),h.innerHTML=j},l(f){h=o(f,"P",{"data-svelte-h":!0}),r(h)!=="svelte-rerqg6"&&(h.innerHTML=j)},m(f,fe){a(f,h,fe)},p:Pt,d(f){f&&s(h)}}}function ls(Me){let h,j,f,fe,J,be,v,we,k,yt="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",Te,U,Mt='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',je,_,bt="This tutorial will show you how to:",Je,Z,wt="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",ve,$,Tt="Before you begin, make sure you have all the necessary libraries installed:",ke,G,Ue,x,_e,I,jt='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',Ze,M,Jt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',$e,C,vt="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",Ge,b,kt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',xe,W,Ut="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",Ie,V,_t='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',Ce,L,Zt="Let’s talk code!",We,w,Ve,X,$t="First, you need to load the model.",Le,R,Xe,z,Gt="You’ll notice two flags in the <code>from_pretrained</code> call:",Re,B,xt='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',ze,H,It="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",Be,F,Ct='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',He,q,Fe,Q,Wt='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',qe,E,Vt='Finally, call the <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens, which should be converted to text before printing.',Qe,N,Ee,Y,Lt="And that’s it! In a few lines of code, you can harness the power of an LLM.",Ne,S,Ye,A,Xt='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',Se,P,Ae,K,Pe,D,Rt='If not specified in the <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',Ke,O,De,ee,Oe,te,zt='By default, and unless specified in the <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',et,se,tt,ae,st,le,Bt='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',at,ne,lt,ie,nt,oe,Ht="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",it,re,ot,pe,Ft='<li><a href="generation_strategies">Guide</a> on how to control different generation methods, how to set up the generation configuration file, and how to stream the output;</li> <li>API reference on <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/v4.34.1/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>.</li>',rt,me,pt,de,qt='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',mt,ue,dt,ce,Qt='<li><a href="main_classes/quantization">Guide</a> on dynamic quantization, which shows you how to drastically reduce your memory requirements.</li>',ut,ge,ct,he,Et='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices.</li>',gt,ye,ht;return J=new y({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),v=new ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),G=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),x=new y({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),w=new ts({props:{$$slots:{default:[as]},$$scope:{ctx:Me}}}),R=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyb3BlbmxtLXJlc2VhcmNoJTJGb3Blbl9sbGFtYV83YiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),N=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, black, white, and brown&#x27;</span>`,wrap:!1}}),S=new y({props:{title:"Common pitfalls",local:"common-pitfalls",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBMbGFtYSUyMGhhcyUyMG5vJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVubG0tcmVzZWFyY2glMkZvcGVuX2xsYW1hXzdiJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),K=new y({props:{title:"Generated output is too short/long",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),O=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),ee=new y({props:{title:"Incorrect generation mode",local:"incorrect-generation-mode",headingTag:"h3"}}),se=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCgwKSUwQSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJJJTIwYW0lMjBhJTIwY2F0LiUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwTExNJTIwJTJCJTIwZ3JlZWR5JTIwZGVjb2RpbmclMjAlM0QlMjByZXBldGl0aXZlJTJDJTIwYm9yaW5nJTIwb3V0cHV0JTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBiZWNvbWVzJTIwbW9yZSUyMGNyZWF0aXZlISUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.\\nI just need to be. I am always.\\nEvery time&#x27;</span>`,wrap:!1}}),ae=new y({props:{title:"Wrong padding side",local:"wrong-padding-side",headingTag:"h3"}}),ne=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscy4lMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5sbS1yZXNlYXJjaCUyRm9wZW5fbGxhbWFfN2IlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTGxhbWElMjBoYXMlMjBubyUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUyMjElMkMlMjAyJTJDJTIwMyUyMiUyQyUyMCUyMkElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMkMlMjBFJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openlm-research/open_llama_7b&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Llama has no pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),ie=new y({props:{title:"Further resources",local:"further-resources",headingTag:"h2"}}),re=new y({props:{title:"Advanced generate usage",local:"advanced-generate-usage",headingTag:"h3"}}),me=new y({props:{title:"LLM leaderboards",local:"llm-leaderboards",headingTag:"h3"}}),ue=new y({props:{title:"Latency and throughput",local:"latency-and-throughput",headingTag:"h3"}}),ge=new y({props:{title:"Related libraries",local:"related-libraries",headingTag:"h3"}}),{c(){h=i("meta"),j=l(),f=i("p"),fe=l(),p(J.$$.fragment),be=l(),p(v.$$.fragment),we=l(),k=i("p"),k.textContent=yt,Te=l(),U=i("p"),U.innerHTML=Mt,je=l(),_=i("p"),_.textContent=bt,Je=l(),Z=i("ul"),Z.innerHTML=wt,ve=l(),$=i("p"),$.textContent=Tt,ke=l(),p(G.$$.fragment),Ue=l(),p(x.$$.fragment),_e=l(),I=i("p"),I.innerHTML=jt,Ze=l(),M=i("figure"),M.innerHTML=Jt,$e=l(),C=i("p"),C.textContent=vt,Ge=l(),b=i("figure"),b.innerHTML=kt,xe=l(),W=i("p"),W.innerHTML=Ut,Ie=l(),V=i("p"),V.innerHTML=_t,Ce=l(),L=i("p"),L.textContent=Zt,We=l(),p(w.$$.fragment),Ve=l(),X=i("p"),X.textContent=$t,Le=l(),p(R.$$.fragment),Xe=l(),z=i("p"),z.innerHTML=Gt,Re=l(),B=i("ul"),B.innerHTML=xt,ze=l(),H=i("p"),H.textContent=It,Be=l(),F=i("p"),F.innerHTML=Ct,He=l(),p(q.$$.fragment),Fe=l(),Q=i("p"),Q.innerHTML=Wt,qe=l(),E=i("p"),E.innerHTML=Vt,Qe=l(),p(N.$$.fragment),Ee=l(),Y=i("p"),Y.textContent=Lt,Ne=l(),p(S.$$.fragment),Ye=l(),A=i("p"),A.innerHTML=Xt,Se=l(),p(P.$$.fragment),Ae=l(),p(K.$$.fragment),Pe=l(),D=i("p"),D.innerHTML=Rt,Ke=l(),p(O.$$.fragment),De=l(),p(ee.$$.fragment),Oe=l(),te=i("p"),te.innerHTML=zt,et=l(),p(se.$$.fragment),tt=l(),p(ae.$$.fragment),st=l(),le=i("p"),le.innerHTML=Bt,at=l(),p(ne.$$.fragment),lt=l(),p(ie.$$.fragment),nt=l(),oe=i("p"),oe.textContent=Ht,it=l(),p(re.$$.fragment),ot=l(),pe=i("ol"),pe.innerHTML=Ft,rt=l(),p(me.$$.fragment),pt=l(),de=i("ol"),de.innerHTML=qt,mt=l(),p(ue.$$.fragment),dt=l(),ce=i("ol"),ce.innerHTML=Qt,ut=l(),p(ge.$$.fragment),ct=l(),he=i("ol"),he.innerHTML=Et,gt=l(),ye=i("p"),this.h()},l(e){const t=Ot("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(s),j=n(e),f=o(e,"P",{}),Yt(f).forEach(s),fe=n(e),m(J.$$.fragment,e),be=n(e),m(v.$$.fragment,e),we=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tihwde"&&(k.textContent=yt),Te=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-100d2rz"&&(U.innerHTML=Mt),je=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1g5tmp7"&&(_.textContent=bt),Je=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-jbjjoq"&&(Z.innerHTML=wt),ve=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1c9nexd"&&($.textContent=Tt),ke=n(e),m(G.$$.fragment,e),Ue=n(e),m(x.$$.fragment,e),_e=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-e3t4o0"&&(I.innerHTML=jt),Ze=n(e),M=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-hjgddv"&&(M.innerHTML=Jt),$e=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1qja5m9"&&(C.textContent=vt),Ge=n(e),b=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1uqc9hk"&&(b.innerHTML=kt),xe=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-pprvht"&&(W.innerHTML=Ut),Ie=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1achluh"&&(V.innerHTML=_t),Ce=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1wpt61n"&&(L.textContent=Zt),We=n(e),m(w.$$.fragment,e),Ve=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-17lmqvk"&&(X.textContent=$t),Le=n(e),m(R.$$.fragment,e),Xe=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ibsgq1"&&(z.innerHTML=Gt),Re=n(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1ut1fuh"&&(B.innerHTML=xt),ze=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14llc8d"&&(H.textContent=It),Be=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-9uk3l0"&&(F.innerHTML=Ct),He=n(e),m(q.$$.fragment,e),Fe=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-lw94r7"&&(Q.innerHTML=Wt),qe=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-y3t14u"&&(E.innerHTML=Vt),Qe=n(e),m(N.$$.fragment,e),Ee=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-wj0v9f"&&(Y.textContent=Lt),Ne=n(e),m(S.$$.fragment,e),Ye=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1h0ongv"&&(A.innerHTML=Xt),Se=n(e),m(P.$$.fragment,e),Ae=n(e),m(K.$$.fragment,e),Pe=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-v0wg8w"&&(D.innerHTML=Rt),Ke=n(e),m(O.$$.fragment,e),De=n(e),m(ee.$$.fragment,e),Oe=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1nsja6u"&&(te.innerHTML=zt),et=n(e),m(se.$$.fragment,e),tt=n(e),m(ae.$$.fragment,e),st=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1n0cu3a"&&(le.innerHTML=Bt),at=n(e),m(ne.$$.fragment,e),lt=n(e),m(ie.$$.fragment,e),nt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1w0my5d"&&(oe.textContent=Ht),it=n(e),m(re.$$.fragment,e),ot=n(e),pe=o(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-1qevd5i"&&(pe.innerHTML=Ft),rt=n(e),m(me.$$.fragment,e),pt=n(e),de=o(e,"OL",{"data-svelte-h":!0}),r(de)!=="svelte-x6edjm"&&(de.innerHTML=qt),mt=n(e),m(ue.$$.fragment,e),dt=n(e),ce=o(e,"OL",{"data-svelte-h":!0}),r(ce)!=="svelte-1i949qg"&&(ce.innerHTML=Qt),ut=n(e),m(ge.$$.fragment,e),ct=n(e),he=o(e,"OL",{"data-svelte-h":!0}),r(he)!=="svelte-e8l3du"&&(he.innerHTML=Et),gt=n(e),ye=o(e,"P",{}),Yt(ye).forEach(s),this.h()},h(){ft(h,"name","hf:doc:metadata"),ft(h,"content",ns),ft(M,"class","image table text-center m-0 w-full"),ft(b,"class","image table text-center m-0 w-full")},m(e,t){es(document.head,h),a(e,j,t),a(e,f,t),a(e,fe,t),d(J,e,t),a(e,be,t),d(v,e,t),a(e,we,t),a(e,k,t),a(e,Te,t),a(e,U,t),a(e,je,t),a(e,_,t),a(e,Je,t),a(e,Z,t),a(e,ve,t),a(e,$,t),a(e,ke,t),d(G,e,t),a(e,Ue,t),d(x,e,t),a(e,_e,t),a(e,I,t),a(e,Ze,t),a(e,M,t),a(e,$e,t),a(e,C,t),a(e,Ge,t),a(e,b,t),a(e,xe,t),a(e,W,t),a(e,Ie,t),a(e,V,t),a(e,Ce,t),a(e,L,t),a(e,We,t),d(w,e,t),a(e,Ve,t),a(e,X,t),a(e,Le,t),d(R,e,t),a(e,Xe,t),a(e,z,t),a(e,Re,t),a(e,B,t),a(e,ze,t),a(e,H,t),a(e,Be,t),a(e,F,t),a(e,He,t),d(q,e,t),a(e,Fe,t),a(e,Q,t),a(e,qe,t),a(e,E,t),a(e,Qe,t),d(N,e,t),a(e,Ee,t),a(e,Y,t),a(e,Ne,t),d(S,e,t),a(e,Ye,t),a(e,A,t),a(e,Se,t),d(P,e,t),a(e,Ae,t),d(K,e,t),a(e,Pe,t),a(e,D,t),a(e,Ke,t),d(O,e,t),a(e,De,t),d(ee,e,t),a(e,Oe,t),a(e,te,t),a(e,et,t),d(se,e,t),a(e,tt,t),d(ae,e,t),a(e,st,t),a(e,le,t),a(e,at,t),d(ne,e,t),a(e,lt,t),d(ie,e,t),a(e,nt,t),a(e,oe,t),a(e,it,t),d(re,e,t),a(e,ot,t),a(e,pe,t),a(e,rt,t),d(me,e,t),a(e,pt,t),a(e,de,t),a(e,mt,t),d(ue,e,t),a(e,dt,t),a(e,ce,t),a(e,ut,t),d(ge,e,t),a(e,ct,t),a(e,he,t),a(e,gt,t),a(e,ye,t),ht=!0},p(e,[t]){const Nt={};t&2&&(Nt.$$scope={dirty:t,ctx:e}),w.$set(Nt)},i(e){ht||(u(J.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(x.$$.fragment,e),u(w.$$.fragment,e),u(R.$$.fragment,e),u(q.$$.fragment,e),u(N.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),ht=!0)},o(e){c(J.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(x.$$.fragment,e),c(w.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(N.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(ge.$$.fragment,e),ht=!1},d(e){e&&(s(j),s(f),s(fe),s(be),s(we),s(k),s(Te),s(U),s(je),s(_),s(Je),s(Z),s(ve),s($),s(ke),s(Ue),s(_e),s(I),s(Ze),s(M),s($e),s(C),s(Ge),s(b),s(xe),s(W),s(Ie),s(V),s(Ce),s(L),s(We),s(Ve),s(X),s(Le),s(Xe),s(z),s(Re),s(B),s(ze),s(H),s(Be),s(F),s(He),s(Fe),s(Q),s(qe),s(E),s(Qe),s(Ee),s(Y),s(Ne),s(Ye),s(A),s(Se),s(Ae),s(Pe),s(D),s(Ke),s(De),s(Oe),s(te),s(et),s(tt),s(st),s(le),s(at),s(lt),s(nt),s(oe),s(it),s(ot),s(pe),s(rt),s(pt),s(de),s(mt),s(dt),s(ce),s(ut),s(ct),s(he),s(gt),s(ye)),s(h),g(J,e),g(v,e),g(G,e),g(x,e),g(w,e),g(R,e),g(q,e),g(N,e),g(S,e),g(P,e),g(K,e),g(O,e),g(ee,e),g(se,e),g(ae,e),g(ne,e),g(ie,e),g(re,e),g(me,e),g(ue,e),g(ge,e)}}}const ns='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Generate text","local":"generate-text","sections":[],"depth":2},{"title":"Common pitfalls","local":"common-pitfalls","sections":[{"title":"Generated output is too short/long","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"Incorrect generation mode","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"Wrong padding side","local":"wrong-padding-side","sections":[],"depth":3}],"depth":2},{"title":"Further resources","local":"further-resources","sections":[{"title":"Advanced generate usage","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM leaderboards","local":"llm-leaderboards","sections":[],"depth":3},{"title":"Latency and throughput","local":"latency-and-throughput","sections":[],"depth":3},{"title":"Related libraries","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function is(Me){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Kt{constructor(h){super(),Dt(this,h,is,ls,St,{})}}export{cs as component};
