import{s as hi,f as di,o as mi,n as yi}from"../chunks/scheduler.65852ee5.js";import{S as wi,i as fi,g as s,s as a,r as p,A as Ji,h as o,f as l,c as i,j as Vt,u,x as r,k as G,y as v,a as n,v as c,d,t as M,w as y}from"../chunks/index.aa74147d.js";import{T as Mi}from"../chunks/Tip.bb8ccac8.js";import{D as Ti,C as m}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as f,E as bi}from"../chunks/EditOnGithub.4eda6a96.js";function gi($t){let h,J='Also check out <code>Interface</code>’s <a href="https://www.gradio.app/docs/gradio/interface#interface-from_pipeline" rel="nofollow">from_pipeline</a> constructor which will directly build the <code>Interface</code> from a <code>pipeline</code>.';return{c(){h=s("p"),h.innerHTML=J},l(w){h=o(w,"P",{"data-svelte-h":!0}),r(h)!=="svelte-e72r3l"&&(h.innerHTML=J)},m(w,T){n(w,h,T)},p:yi,d(w){w&&l(h)}}}function Ui($t){let h,J="The output that we get from the call above is a made-up meeting that was generated by the LLM that we are using for text organization. This is because the sample input file isn’t an actual meeting recording. You can tweak the LLM’s prompt to handle this case.";return{c(){h=s("p"),h.textContent=J},l(w){h=o(w,"P",{"data-svelte-h":!0}),r(h)!=="svelte-avohft"&&(h.textContent=J)},m(w,T){n(w,h,T)},p:yi,d(w){w&&l(h)}}}function Ii($t){let h,J,w,T,B,Xt,Z,Rt,C,Nn='<em>Authored by: <a href="https://huggingface.co/dmaniloff" rel="nofollow">Diego Maniloff</a></em>',Yt,W,_t,$,An='In this notebook we will demonstrate how to bring any machine learning model to life using <a href="https://www.gradio.app/" rel="nofollow">Gradio</a>, a library that allows you to create a web demo from any Python function and share it with the world 🌎!',St,x,En="📚 This notebook covers:",zt,H,qn="<li>Building a <code>Hello, World!</code> demo: The basics of Gradio</li> <li>Moving your demo to Hugging Face Spaces</li> <li>Making it interesting: a real-world example that leverages the 🤗 Hub</li> <li>Some of the cool “batteries included” features that come with Gradio</li>",Ft,k,Pn="⏭️ At the end of this notebook you will find a <code>Further Reading</code> list with links to keep going on your own.",Qt,V,Lt,X,Dn="To get started install the <code>gradio</code> library along with <code>transformers</code>.",Nt,R,At,Y,Et,_,qt,S,Kn="At its core, Gradio turns any Python function into a web interface.",Pt,z,On="Say we have a simple function that takes <code>name</code> and <code>intensity</code> as parameters, and returns a string like so:",Dt,F,Kt,Q,ea="If you run this function for the name ‘Diego’ you will get an output string that looks like this:",Ot,L,el,N,ta=`Hello, Diego!!!
`,tl,A,la="With Gradio, we can build an interface for this function via the <code>gr.Interface</code> class. All we need to do is pass in the <code>greet</code> function we created above, and the kinds of inputs and outputs that our function expects:",ll,E,nl,q,na='Notice how we passed in <code>[&quot;text&quot;, &quot;slider&quot;]</code> as inputs and <code>[&quot;text&quot;]</code> as outputs — these are called <a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">Components</a> in Gradio.',al,P,aa="That’s all we need for our first demo. Go ahead and try it out 👇🏼! Type your name into the <code>name</code> textbox, slide the intensity that you want, and click <code>Submit</code>.",il,D,sl,K,ol,O,ia=`At this point you understand how to take a basic Python function and turn it into
a web-ready demo. However, we only did this for a function that is very simple, a bit boring even!`,rl,ee,sa="Let’s consider a more interesting example that highlights the very thing that Gradio was built for: demoing cutting-edge machine learning models. A good friend of mine recently asked me for help with an audio recording of an interview she had done. She needed to convert the audio file into a well-organized text summary. How did I help her? I built a Gradio app!",pl,te,oa="Let’s walk through the steps to build the meeting transcription tool. We can think of the process as two parts:",ul,le,ra="<li>Transcribe the audio file into text</li> <li>Organize the text into sections, paragraphs, lists, etc. We could include summarization here too.</li>",cl,ne,dl,ae,pa="In this part we will build a demo that handles the first step of the meeting transcription tool: converting audio into text.",Ml,ie,ua="As we learned, the key ingredient to building a Gradio demo is to have a Python function that executes the logic we are trying to showcase. For the audio-to-text conversion, we will build our function using the awesome <code>transformers</code> library and its <code>pipeline</code> utility to use a popular audio-to-text model called <code>distil-whisper/distil-large-v3</code>.",yl,se,ca="The result is the following <code>transcribe</code> function, which takes as input the audio that we want to convert:",hl,oe,ml,re,da='Now that we have our Python function, we can demo that by passing it into <code>gr.Interface</code>. Notice how in this case the input that the function expects is the audio that we want to convert. Gradio includes a ton useful components, one of which is <a href="https://www.gradio.app/docs/gradio/audio" rel="nofollow">Audio</a>, exactly what we need for our demo 🎶 😎.',wl,pe,fl,ue,Ma="Go ahead and try it out 👆! You can upload an <code>.mp3</code> file or hit the 🎤 button to record your own voice.",Jl,ce,ya='For a sample file with an actual meeting recording, you can check out the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio" rel="nofollow">MeetingBank_Audio dataset</a> which is a dataset of meetings from city councils of 6 major U.S. cities. For my own testing, I tried out a couple of the <a href="https://huggingface.co/datasets/huuuyeah/MeetingBank_Audio/blob/main/Denver/mp3/Denver-21.zip" rel="nofollow">Denver meetings</a>.',Tl,b,bl,de,gl,Me,ha="For part 2 of the meeting transcription tool, we need to organize the transcribed text from the previous step.",Ul,ye,ma='Once again, to build a Gradio demo we need the Python function with the logic that we care about. For text organization and summarization, we will use an “instruction-tuned” model that is trained to follow a broad range of tasks. There are many options to pick from such as <a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-8B-Instruct</a> or <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.3" rel="nofollow">mistralai/Mistral-7B-Instruct-v0.3</a>. For our example we are going to use <a href="https://huggingface.co/microsoft/Phi-3-mini-4k-instruct" rel="nofollow">microsoft/Phi-3-mini-4k-instruct</a>.',Il,he,wa='Just like for part 1, we could leverage the <code>pipeline</code> utility within <code>transformers</code> to do this, but instead we will take this opportunity to showcase the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a>, which is an API within the Hugging Face Hub that allows us to use thousands of publicly accessible (or your own privately permissioned) machine learning models <strong><em>for free</em></strong>! Check out the cookbook section of the Serverless Inferfence API <a href="https://huggingface.co/learn/cookbook/en/enterprise_hub_serverless_inference_api" rel="nofollow">here</a>.',jl,me,fa='Using the Serverless Inferfence API means that instead of calling a model via a pipeline (like we did for the audio conversion part), we will call it from the <code>InferenceClient</code>, which is part of the <code>huggingface_hub</code> library (<a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a>). And in turn, to use the <code>InferenceClient</code>, we need to log into the 🤗 Hub using <code>notebook_login()</code>, which will produce a dialog box asking for your User Access Token to authenticate with the Hub.',Gl,we,Ja='You can manage your tokens from your <a href="https://huggingface.co/settings/tokens" rel="nofollow">personal settings page</a>, and please remember to use <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">fine-grained</a> tokens as much as possible for enhanced security.',vl,fe,Bl,Je,Ta="Now that we are logged into the Hub, we can write our text processing function using the Serverless Inference API via <code>InferenceClient</code>.",Zl,Te,ba="The code for this part will be structured into two functions:",Cl,be,ga="<li><code>build_messages</code>, to format the message prompt into the LLM;</li> <li><code>organize_text</code>, to actually pass the raw meeting text into the LLM for organization (and summarization, depending on the prompt we provide).</li>",Wl,ge,$l,Ue,xl,Ie,Ua="And now that we have our text organization function <code>organize_text</code>, we can build a demo for it as well:",Hl,je,kl,Ge,Ia="Go ahead and try it out 👆! If you hit “Submit” in the demo above, you will see that the output text is a much clearer and organized version of the transcript, with a title and sections for the different parts of the meeting.",Vl,ve,ja="See if you can get a summary by playing around with the <code>user_input</code> variable that controls the LLM prompt.",Xl,Be,Rl,Ze,Ga="At this point we have a function for each of the two steps we want out meeting transcription tool to do:",Yl,Ce,va="<li>convert the audio into a text file, and</li> <li>organize that text file into a nicely-formatted meeting document.</li>",_l,We,Ba="All we have to do next is stitch these two functions together and build a demo for the combined steps. In other words, our complete meeting transcription tool is just a new function (which we’ll creatively call <code>meeting_transcript_tool</code> 😀) that takes the output of <code>transcribe</code> and passes it into <code>organize_text</code>:",Sl,$e,zl,xe,Za="Go ahead and try it out 👆! This is now the full demo of our transcript tool. If you give it an audio file, the output will be the already-organized (and potentially summarized) version of the meeting. Super cool 😎.",Fl,He,Ql,ke,Ca="If you made it this far, now you know the basics of how to create a demo of your machine learning model using Gradio 👏!",Ll,Ve,Wa="Up next we are going to show you how to take your brand new demo to Hugging Face Spaces. On top of the ease of use and powerful features of Gradio, moving your demo to 🤗 Spaces gives you the benefit of permanent hosting, ease of deployment each time you update your app, and the ability to share your work with anyone! Do keep in mind that your Space will go to sleep after a while unless you are using it or making changes to it.",Nl,Xe,$a='The first step is to head over to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>, select “Gradio” from the templates, and leave the rest of the options as default for now (you can change these later):',Al,g,xa,El,Re,Ha='This will result in a newly created Space that you can populate with your demo code. As an example for you to follow, I created the 🤗 Space <code>dmaniloff/meeting-transcript-tool</code>, which you can access <a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool" rel="nofollow">here</a>.',ql,Ye,ka="There are two files we need to edit:",Pl,U,_e,xt,Va="<code>app.py</code> — This is where the demo code lives. It should look something like this:",Fn,Se,Qn,ze,Ht,Xa="<code>requirements.txt</code> — This is where we tell our Space about the libraries it will need. It should look something like this:",Ln,Fe,Dl,Qe,Kl,Le,Ra="Gradio comes with lots of cool functionality right out of the box. We won’t be able to cover all of it in this notebook, but here’s 3 that we will check out:",Ol,Ne,Ya="<li>Access as an API</li> <li>Sharing via public URL</li> <li>Flagging</li>",en,Ae,tn,Ee,_a="One of the benefits of building your web demos with Gradio is that you automatically get an API 🙌! This means that you can access the functionality of your Python function using a standard HTTP client like <code>curl</code> or the Python <code>requests</code> library.",ln,qe,Sa='If you look closely at the demos we created above, you will see at the bottom there is a link that says “Use via API”. If you click on it in the Space I created (<a href="https://huggingface.co/spaces/dmaniloff/meeting-transcript-tool/blob/main/app.py" rel="nofollow">dmaniloff/meeting-transcript-tool</a>), you will see the following:',nn,I,za,an,Pe,Fa="Let’s go ahead and copy-paste that code below to use our Space as an API:",sn,De,on,Ke,rn,Oe,Qa=`Loaded as API: https://dmaniloff-meeting-transcript-tool.hf.space ✔
Certainly! Below is an organized version of a hypothetical meeting transcript. Since the original transcript you've provided is quite minimal, I'll create a more detailed and structured example featuring a meeting summary.

---

# Meeting Transcript: Project Alpha Kickoff

**Date:** April 7, 2023

**Location:** Conference Room B, TechCorp Headquarters


**Attendees:**

- John Smith (Project Manager)

- Emily Johnson (Lead Developer)

- Michael Brown (Marketing Lead)

- Lisa Green (Design Lead)


**Meeting Duration:** 1 hour 30 minutes


## Opening Remarks

**John Smith:**

Good morning everyone, and thank you for joining this kickoff meeting for Project Alpha. Today, we'll discuss our project vision, milestones, and roles. Let's get started.


## Vision and Goals

**Emily Johnson:**

The main goal of Project Alpha is to
`,pn,et,La="Wow! What happened there? Let’s break it down:",un,tt,Na="<li>We installed the <code>gradio_client</code>, which is a package that is specifically designed to interact with APIs built with Gradio.</li> <li>We instantiated the client by providing the name of the 🤗 Space that we want to query.</li> <li>We called the <code>predict</code> method of the client and passed in a sample audio file to it.</li>",cn,lt,Aa="The Gradio client takes care of making the HTTP POST for us, and it also provides functionality like reading the input audio file that our meeting transcript tool will process (via the function <code>handle_file</code>).",dn,nt,Ea="Again, using this client is a choice, and you can just as well run a <code>curl -X POST https://dmaniloff-meeting-transcript-tool.hf.space/call/predict [...]</code> and pass in all the parameters needed in the request.",Mn,j,yn,at,hn,it,qa="Another cool feature built into Gradio is that even if you build your demo on your local computer (before you move it into a 🤗 Space) you can still share this with anyone in the world by passing in <code>share=True</code> into <code>launch</code> like so:",mn,st,wn,ot,Pa="You might have noticed that in this Google Colab environment that behaviour is enabled by default, and so the previous demos that we created already had a public URL that you can share 🌎. Go back ⬆ and look at the logs for <code>Running on public URL:</code> to find it 🔎!",fn,rt,Jn,pt,Da='<a href="https://www.gradio.app/guides/using-flagging" rel="nofollow">Flagging</a> is a feature built into Gradio that allows the users of your demo to provide feedback. You might have noticed that the first demo we created had a <code>Flag</code> button at the bottom.',Tn,ut,Ka="Under the default options, if a user clicks that button then the input and output samples are saved into a CSV log file that you can review later. If the demo involves audio (like in our case), these are saved separately in a parallel directory and the paths to these files are saved in the CSV file.",bn,ct,Oa="Go back and play with our first demo once more, and then click the <code>Flag</code> button. You will see that a new log file is created in the <code>flagged</code> directory:",gn,dt,Un,Mt,ei=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
`,In,yt,ti="In this case I set inputs to <code>name=diego</code> and <code>intensity=29</code>, which I then flagged. You can see that the log file includes the inputs to the function, the output <code>&quot;Hello, diego!!!!!!!!!!!!!!!!!!!!!!!!!!!!!&quot;</code>, and also a timestamp.",jn,ht,li="While a list of inputs and outputs that your users found problematic is better than nothing, Gradio’s flagging feature allows you to do much more. For example, you can provide a <code>flagging_options</code> parameter that lets you customize the kind of feedback or errors that you can receive, such as <code>[&quot;Incorrect&quot;, &quot;Ambiguous&quot;]</code>. Note that this requires that <code>allow_flagging</code> is set to <code>&quot;manual&quot;</code>:",Gn,mt,vn,wt,ni="Go ahead and try it out 👆! You can see that the flagging buttons now are <code>Flag as Incorrect</code> and <code>Flag as Ambiguous</code>, and the new log file will reflect those options:",Bn,ft,Zn,Jt,ai=`name,intensity,output,flag,username,timestamp
Diego,4,"Hello, Diego!!!!",,,2024-06-29 22:07:50.242707
Diego,5,"Hello, Diego!!!!!",Ambiguous,,2024-06-29 22:08:04.281030
`,Cn,Tt,Wn,bt,ii="In this notebook we learned how to demo any machine learning model using Gradio.",$n,gt,si="First, we learned the basics of setting up an interface for a simple Python function; and second, we covered Gradio’s true strength: building demos for machine learning models.",xn,Ut,oi="For this, we learned how easy it is to leverage models in the 🤗 Hub via the <code>transformers</code> library and its <code>pipeline</code> function, and how to use multimedia inputs like <code>gr.Audio</code>.",Hn,It,ri="Third, we covered how to host your Gradio demo on 🤗 Spaces, which lets you keep your demo running in the cloud and gives you flexibility in terms of the compute requirements for your demo.",kn,jt,pi="Finally, we showcased a few of the super cool batteries included that come with Gradio such as API access, public URLs, and Flagging.",Vn,Gt,ui="For next steps, check out the <code>Further Reading</code> links at the end of each section.",Xn,vt,Rn,Bt,ci='<li><a href="https://www.gradio.app/guides/quickstart#building-your-first-demo" rel="nofollow">Your first demo with gradio</a></li> <li><a href="https://www.gradio.app/docs/gradio/introduction" rel="nofollow">Gradio Components</a></li> <li><a href="https://huggingface.co/docs/transformers/en/index" rel="nofollow">The transformers library</a></li> <li><a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">The pipeline function</a></li> <li><a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/login" rel="nofollow">Hub Python Library</a></li> <li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Serverless Inference API</a></li> <li><a href="https://huggingface.co/spaces" rel="nofollow">🤗 Spaces</a></li> <li><a href="https://huggingface.co/docs/hub/spaces" rel="nofollow">Spaces documentation</a></li>',Yn,Zt,_n,kt,Sn;return B=new Ti({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_gradio.ipynb"}]}}),Z=new f({props:{title:"Creating Demos with Spaces and Gradio",local:"creating-demos-with-spaces-and-gradio",headingTag:"h1"}}),W=new f({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),V=new f({props:{title:"Setup",local:"setup",headingTag:"h2"}}),R=new m({props:{code:"IXBpcCUyMC1xJTIwaW5zdGFsbCUyMGdyYWRpbyUzRCUzRDQuMzYuMSUwQSFwaXAlMjAtcSUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlM0QlM0Q0LjQxLjI=",highlighted:`!pip -q install gradio==<span class="hljs-number">4.36</span><span class="hljs-number">.1</span>
!pip -q install transformers==<span class="hljs-number">4.41</span><span class="hljs-number">.2</span>`,wrap:!1}}),Y=new m({props:{code:"JTIzJTIwdGhlJTIwdXN1YWwlMjBzaG9ydGhhbmQlMjBpcyUyMHRvJTIwaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3I=",highlighted:`<span class="hljs-comment"># the usual shorthand is to import gradio as gr</span>
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr`,wrap:!1}}),_=new f({props:{title:"Your first demo: the basics of Gradio",local:"your-first-demo-the-basics-of-gradio",headingTag:"h2"}}),F=new m({props:{code:"ZGVmJTIwZ3JlZXQobmFtZSUzQSUyMHN0ciUyQyUyMGludGVuc2l0eSUzQSUyMGludCklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIySGVsbG8lMkMlMjAlMjIlMjAlMkIlMjBuYW1lJTIwJTJCJTIwJTIyISUyMiUyMColMjBpbnQoaW50ZW5zaXR5KQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">greet</span>(<span class="hljs-params">name: <span class="hljs-built_in">str</span>, intensity: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Hello, &quot;</span> + name + <span class="hljs-string">&quot;!&quot;</span> * <span class="hljs-built_in">int</span>(intensity)`,wrap:!1}}),L=new m({props:{code:"cHJpbnQoZ3JlZXQoJTIyRGllZ28lMjIlMkMlMjAzKSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(greet(<span class="hljs-string">&quot;Diego&quot;</span>, <span class="hljs-number">3</span>))',wrap:!1}}),E=new m({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSk=",highlighted:`demo = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>],  <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># the output is a text box</span>
)`,wrap:!1}}),D=new m({props:{code:"JTIzJTIwdGhlJTIwbGF1bmNoJTIwbWV0aG9kJTIwd2lsbCUyMGZpcmUlMjB1cCUyMHRoZSUyMGludGVyZmFjZSUyMHdlJTIwanVzdCUyMGNyZWF0ZWQlMEFkZW1vLmxhdW5jaCgp",highlighted:`<span class="hljs-comment"># the launch method will fire up the interface we just created</span>
demo.launch()`,wrap:!1}}),K=new f({props:{title:"Let’s make it interesting: a meeting transcription tool",local:"lets-make-it-interesting-a-meeting-transcription-tool",headingTag:"h2"}}),ne=new f({props:{title:"Audio-to-text",local:"audio-to-text",headingTag:"h3"}}),oe=new m({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0ZW1wZmlsZSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQWRldmljZSUyMCUzRCUyMDAlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyJTBBJTBBQVVESU9fTU9ERUxfTkFNRSUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJkaXN0aWwtd2hpc3BlciUyRmRpc3RpbC1sYXJnZS12MyUyMiUyMCUyMCUyMyUyMGZhc3RlciUyMGFuZCUyMHZlcnklMjBjbG9zZSUyMGluJTIwcGVyZm9ybWFuY2UlMjB0byUyMHRoZSUyMGZ1bGwtc2l6ZSUyMCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjMlMjIlMEEpJTBBQkFUQ0hfU0laRSUyMCUzRCUyMDglMEElMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREFVRElPX01PREVMX05BTUUlMkMlMEElMjAlMjAlMjAlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTNEZGV2aWNlJTJDJTBBKSUwQSUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyRnVuY3Rpb24lMjB0byUyMGNvbnZlcnQlMjBhdWRpbyUyMHRvJTIwdGV4dC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMGF1ZGlvX2lucHV0JTIwaXMlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBnci5FcnJvciglMjJObyUyMGF1ZGlvJTIwZmlsZSUyMHN1Ym1pdHRlZCElMjIpJTBBJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwcGlwZShhdWRpb19pbnB1dCUyQyUyMGJhdGNoX3NpemUlM0RCQVRDSF9TSVpFJTJDJTIwZ2VuZXJhdGVfa3dhcmdzJTNEJTdCJTIydGFzayUyMiUzQSUyMCUyMnRyYW5zY3JpYmUlMjIlN0QlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0JTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> tempfile

<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-number">0</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

AUDIO_MODEL_NAME = (
    <span class="hljs-string">&quot;distil-whisper/distil-large-v3&quot;</span>  <span class="hljs-comment"># faster and very close in performance to the full-size &quot;openai/whisper-large-v3&quot;</span>
)
BATCH_SIZE = <span class="hljs-number">8</span>


pipe = pipeline(
    task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
    model=AUDIO_MODEL_NAME,
    chunk_length_s=<span class="hljs-number">30</span>,
    device=device,
)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">audio_input</span>):
    <span class="hljs-string">&quot;&quot;&quot;Function to convert audio to text.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> audio_input <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">raise</span> gr.Error(<span class="hljs-string">&quot;No audio file submitted!&quot;</span>)

    output = pipe(audio_input, batch_size=BATCH_SIZE, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;transcribe&quot;</span>}, return_timestamps=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">return</span> output[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),pe=new m({props:{code:"cGFydF8xX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0R0cmFuc2NyaWJlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8odHlwZSUzRCUyMmZpbGVwYXRoJTIyKSUyQyUyMCUyMCUyMyUyMCUyMmZpbGVwYXRoJTIyJTIwcGFzc2VzJTIwYSUyMHN0ciUyMHBhdGglMjB0byUyMGElMjB0ZW1wb3JhcnklMjBmaWxlJTIwY29udGFpbmluZyUyMHRoZSUyMGF1ZGlvJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTIwJTIwJTIzJTIwZ2l2ZSUyMHVzZXJzJTIwdGhlJTIwb3B0aW9uJTIwdG8lMjBjb3B5JTIwdGhlJTIwcmVzdWx0cyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyVHJhbnNjcmliZSUyMEF1ZGlvJTIwdG8lMjBUZXh0JTIyJTJDJTIwJTIwJTIzJTIwZ2l2ZSUyMG91ciUyMGRlbW8lMjBhJTIwdGl0bGUlMjAlM0EpJTBBKSUwQSUwQXBhcnRfMV9kZW1vLmxhdW5jaCgp",highlighted:`part_1_demo = gr.Interface(
    fn=transcribe,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),  <span class="hljs-comment"># &quot;filepath&quot; passes a str path to a temporary file containing the audio</span>
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),  <span class="hljs-comment"># give users the option to copy the results</span>
    title=<span class="hljs-string">&quot;Transcribe Audio to Text&quot;</span>,  <span class="hljs-comment"># give our demo a title :)</span>
)

part_1_demo.launch()`,wrap:!1}}),b=new Mi({props:{warning:!1,$$slots:{default:[gi]},$$scope:{ctx:$t}}}),de=new f({props:{title:"Organize & summarize text",local:"organize--summarize-text",headingTag:"h3"}}),fe=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTJDJTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBJTIzJTIwcnVubmluZyUyMHRoaXMlMjB3aWxsJTIwcHJvbXB0JTIweW91JTIwdG8lMjBlbnRlciUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMGNyZWRlbnRpYWxzJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, InferenceClient

<span class="hljs-comment"># running this will prompt you to enter your Hugging Face credentials</span>
notebook_login()`,wrap:!1}}),ge=new m({props:{code:"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",highlighted:`<span class="hljs-comment"># sample meeting transcript from huuuyeah/MeetingBank_Audio</span>
<span class="hljs-comment"># this is just a copy-paste from the output of part 1 using one of the Denver meetings</span>
sample_transcript = <span class="hljs-string">&quot;&quot;&quot;
 Good evening. Welcome to the Denver City Council meeting of Monday, May 8, 2017. My name is Kelly Velez. I&#x27;m your Council Secretary. According to our rules of procedure, when our Council President, Albus Brooks, and Council President Pro Tem, JoLynn Clark, are both absent, the Council Secretary calls the meeting to order. Please rise and join Councilman Herndon in the Pledge of Allegiance. Madam Secretary, roll call. Roll call. Here. Mark. Espinosa. Here. Platt. Delmar. Here. Here. Here. Here. We have five members present. There is not a quorum this evening. Many of the council members are participating in an urban exploration trip in Portland, Oregon, pursuant to Section 3.3.4 of the city charter. Because there is not a quorum of seven council members present, all of tonight&#x27;s business will move to next week, to Monday, May 15th. Seeing no other business before this body except to wish Councilwoman Keniche a very happy birthday this meeting is adjourned Thank you. A standard model and an energy efficient model likely will be returned to you in energy savings many times during its lifespan. Now, what size do you need? Air conditioners are not a one-size-or-type fits all. Before you buy an air conditioner, you need to consider the size of your home and the cost to operate the unit per hour. Do you want a room air conditioner, which costs less but cools a smaller area, or do you want a central air conditioner, which cools your entire house but costs more? Do your homework. Now, let&#x27;s discuss evaporative coolers. In low humidity areas, evaporating water into the air provides a natural and energy efficient means of cooling. Evaporative coolers, also called swamp coolers, cool outdoor air by passing it over water saturated pads, causing the water to evaporate into it. Evaporative coolers cost about one half as much to install as central air conditioners and use about one-quarter as much energy. However, they require more frequent maintenance than refrigerated air conditioners, and they&#x27;re suitable only for areas with low humidity. Watch the maintenance tips at the end of this segment to learn more. And finally, fans. When air moves around in your home, it creates a wind chill effect. A mere two-mile-an-hour breeze will make your home feel four degrees cooler and therefore you can set your thermostat a bit higher. Ceiling fans and portable oscillating fans are cheap to run and they make your house feel cooler. You can also install a whole house fan to draw the hot air out of your home. A whole house fan draws cool outdoor air inside through open windows and exhausts hot room air through the attic to the outside. The result is excellent ventilation, lower indoor temperatures, and improved evaporative cooling. But remember, there are many low-cost, no-cost ways that you can keep your home cool. You should focus on these long before you turn on your AC or even before you purchase an AC. But if you are going to purchase a new cooling system, remember to get one that&#x27;s energy efficient and the correct size for your home. Wait, wait, don&#x27;t go away, there&#x27;s more. After this segment of the presentation is over, you&#x27;re going to be given the option to view maintenance tips about air conditioners and evaporative coolers. Now all of these tips are brought to you by the people at Xcel Energy. Thanks for watching.
&quot;&quot;&quot;</span>`,wrap:!1}}),Ue=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQVRFWFRfTU9ERUxfTkFNRSUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktNGstaW5zdHJ1Y3QlMjIlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQSUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQobWVldGluZ190cmFuc2NyaXB0KSUzQSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1vZGVsJTNEVEVYVF9NT0RFTF9OQU1FJTJDJTIwbWF4X3Rva2VucyUzRDI1MCUyQyUyMHNlZWQlM0Q0MzApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS5jb250ZW50JTBBJTBBJTBBZGVmJTIwYnVpbGRfbWVzc2FnZXMobWVldGluZ190cmFuc2NyaXB0KSUyMC0lM0UlMjBsaXN0JTNBJTBBJTIwJTIwJTIwJTIwc3lzdGVtX2lucHV0JTIwJTNEJTIwJTIyWW91JTIwYXJlJTIwYW4lMjBhc3NpdGFudCUyMHRoYXQlMjBvcmdhbml6ZXMlMjBtZWV0aW5nJTIwbWludXRlcy4lMjIlMEElMjAlMjAlMjAlMjB1c2VyX2lucHV0JTIwJTNEJTIwJTIyJTIyJTIyVGFrZSUyMHRoaXMlMjByYXclMjBtZWV0aW5nJTIwdHJhbnNjcmlwdCUyMGFuZCUyMHJldHVybiUyMGFuJTIwb3JnYW5pemVkJTIwdmVyc2lvbi4lMEElMjAlMjAlMjAlMjBIZXJlJTIwaXMlMjB0aGUlMjB0cmFuc2NyaXB0JTNBJTBBJTIwJTIwJTIwJTIwJTdCbWVldGluZ190cmFuc2NyaXB0JTdEJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyLmZvcm1hdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZWV0aW5nX3RyYW5zY3JpcHQlM0RtZWV0aW5nX3RyYW5zY3JpcHQlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHN5c3RlbV9pbnB1dCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMHVzZXJfaW5wdXQlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBtZXNzYWdlcw==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

TEXT_MODEL_NAME = <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>

client = InferenceClient()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">meeting_transcript</span>):
    messages = build_messages(meeting_transcript)
    response = client.chat_completion(messages, model=TEXT_MODEL_NAME, max_tokens=<span class="hljs-number">250</span>, seed=<span class="hljs-number">430</span>)
    <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


<span class="hljs-keyword">def</span> <span class="hljs-title function_">build_messages</span>(<span class="hljs-params">meeting_transcript</span>) -&gt; <span class="hljs-built_in">list</span>:
    system_input = <span class="hljs-string">&quot;You are an assitant that organizes meeting minutes.&quot;</span>
    user_input = <span class="hljs-string">&quot;&quot;&quot;Take this raw meeting transcript and return an organized version.
    Here is the transcript:
    {meeting_transcript}
    &quot;&quot;&quot;</span>.<span class="hljs-built_in">format</span>(
        meeting_transcript=meeting_transcript
    )

    messages = [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: system_input},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: user_input},
    ]
    <span class="hljs-keyword">return</span> messages`,wrap:!1}}),je=new m({props:{code:"cGFydF8yX2RlbW8lMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0Rvcmdhbml6ZV90ZXh0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuVGV4dGJveCh2YWx1ZSUzRHNhbXBsZV90cmFuc2NyaXB0KSUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0Rnci5UZXh0Ym94KHNob3dfY29weV9idXR0b24lM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQ2xlYW4lMjBVcCUyMFRyYW5zY3JpcHQlMjBUZXh0JTIyJTJDJTBBKSUwQXBhcnRfMl9kZW1vLmxhdW5jaCgp",highlighted:`part_2_demo = gr.Interface(
    fn=organize_text,
    inputs=gr.Textbox(value=sample_transcript),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;Clean Up Transcript Text&quot;</span>,
)
part_2_demo.launch()`,wrap:!1}}),Be=new f({props:{title:"Putting it all together",local:"putting-it-all-together",headingTag:"h3"}}),$e=new m({props:{code:"ZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woYXVkaW9faW5wdXQpJTNBJTBBJTIwJTIwJTIwJTIwbWVldGluZ190ZXh0JTIwJTNEJTIwdHJhbnNjcmliZShhdWRpb19pbnB1dCklMEElMjAlMjAlMjAlMjBvcmdhbml6ZWRfdGV4dCUyMCUzRCUyMG9yZ2FuaXplX3RleHQobWVldGluZ190ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZ2FuaXplZF90ZXh0JTBBJTBBJTBBZnVsbF9kZW1vJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEbWVldGluZ190cmFuc2NyaXB0X3Rvb2wlMkMlMEElMjAlMjAlMjAlMjBpbnB1dHMlM0Rnci5BdWRpbyh0eXBlJTNEJTIyZmlsZXBhdGglMjIpJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLlRleHRib3goc2hvd19jb3B5X2J1dHRvbiUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJUaGUlMjBDb21wbGV0ZSUyME1lZXRpbmclMjBUcmFuc2NyaXB0aW9uJTIwVG9vbCUyMiUyQyUwQSklMEFmdWxsX2RlbW8ubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">audio_input</span>):
    meeting_text = transcribe(audio_input)
    organized_text = organize_text(meeting_text)
    <span class="hljs-keyword">return</span> organized_text


full_demo = gr.Interface(
    fn=meeting_transcript_tool,
    inputs=gr.Audio(<span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Textbox(show_copy_button=<span class="hljs-literal">True</span>),
    title=<span class="hljs-string">&quot;The Complete Meeting Transcription Tool&quot;</span>,
)
full_demo.launch()`,wrap:!1}}),He=new f({props:{title:"Move your demo into 🤗 Spaces",local:"move-your-demo-into--spaces",headingTag:"h2"}}),Se=new m({props:{code:"JTIzJTIwb3V0bGluZSUyMG9mJTIwYXBwLnB5JTNBJTBBJTBBZGVmJTIwbWVldGluZ190cmFuc2NyaXB0X3Rvb2woLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMHRyYW5zY3JpYmUoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQSUwQWRlZiUyMG9yZ2FuaXplX3RleHQoLi4uKSUzQSUwQSUyMCUyMCUyMC4uLiUwQQ==",highlighted:`<span class="hljs-comment"># outline of app.py:</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">meeting_transcript_tool</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">transcribe</span>(<span class="hljs-params">...</span>):
   ...

<span class="hljs-keyword">def</span> <span class="hljs-title function_">organize_text</span>(<span class="hljs-params">...</span>):
   ...
`,wrap:!1}}),Fe=new m({props:{code:"JTIzJTIwY29udGVudHMlMjBvZiUyMHJlcXVpcmVtZW50cy50eHQlM0ElMEF0b3JjaCUwQXRyYW5zZm9ybWVycw==",highlighted:`<span class="hljs-comment"># contents of requirements.txt:</span>
<span class="hljs-attribute">torch</span>
transformers`,wrap:!1}}),Qe=new f({props:{title:"Gradio comes with batteries included 🔋",local:"gradio-comes-with-batteries-included-",headingTag:"h2"}}),Ae=new f({props:{title:"Access as an API",local:"access-as-an-api",headingTag:"h3"}}),De=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjBncmFkaW9fY2xpZW50",highlighted:"!pip install gradio_client",wrap:!1}}),Ke=new m({props:{code:"ZnJvbSUyMGdyYWRpb19jbGllbnQlMjBpbXBvcnQlMjBDbGllbnQlMkMlMjBoYW5kbGVfZmlsZSUwQSUwQWNsaWVudCUyMCUzRCUyMENsaWVudCglMjJkbWFuaWxvZmYlMkZtZWV0aW5nLXRyYW5zY3JpcHQtdG9vbCUyMiklMEFyZXN1bHQlMjAlM0QlMjBjbGllbnQucHJlZGljdCglMEElMjAlMjAlMjAlMjBhdWRpb19pbnB1dCUzRGhhbmRsZV9maWxlKCUyMmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmdyYWRpby1hcHAlMkZncmFkaW8lMkZyYXclMkZtYWluJTJGdGVzdCUyRnRlc3RfZmlsZXMlMkZhdWRpb19zYW1wbGUud2F2JTIyKSUyQyUwQSUyMCUyMCUyMCUyMGFwaV9uYW1lJTNEJTIyJTJGcHJlZGljdCUyMiUyQyUwQSklMEFwcmludChyZXN1bHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> gradio_client <span class="hljs-keyword">import</span> Client, handle_file

<span class="hljs-meta">&gt;&gt;&gt; </span>client = Client(<span class="hljs-string">&quot;dmaniloff/meeting-transcript-tool&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = client.predict(
<span class="hljs-meta">... </span>    audio_input=handle_file(<span class="hljs-string">&quot;https://github.com/gradio-app/gradio/raw/main/test/test_files/audio_sample.wav&quot;</span>),
<span class="hljs-meta">... </span>    api_name=<span class="hljs-string">&quot;/predict&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)`,wrap:!1}}),j=new Mi({props:{warning:!1,$$slots:{default:[Ui]},$$scope:{ctx:$t}}}),at=new f({props:{title:"Share via public URL",local:"share-via-public-url",headingTag:"h3"}}),st=new m({props:{code:"JTIwZGVtby5sYXVuY2goc2hhcmUlM0RUcnVlKQ==",highlighted:' demo.launch(share=<span class="hljs-literal">True</span>)',wrap:!1}}),rt=new f({props:{title:"Flagging",local:"flagging",headingTag:"h3"}}),dt=new m({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),mt=new m({props:{code:"ZGVtb193aXRoX2N1c3RvbV9mbGFnZ2luZyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRGdyZWV0JTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnNsaWRlciUyMiU1RCUyQyUyMCUyMCUyMyUyMHRoZSUyMGlucHV0cyUyMGFyZSUyMGElMjB0ZXh0JTIwYm94JTIwYW5kJTIwYSUyMHNsaWRlciUyMCglMjJ0ZXh0JTIyJTIwYW5kJTIwJTIyc2xpZGVyJTIyJTIwYXJlJTIwY29tcG9uZW50cyUyMGluJTIwR3JhZGlvKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlM0QlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwJTIwJTIzJTIwdGhlJTIwb3V0cHV0JTIwaXMlMjBhJTIwdGV4dCUyMGJveCUwQSUyMCUyMCUyMCUyMGFsbG93X2ZsYWdnaW5nJTNEJTIybWFudWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ2dpbmdfb3B0aW9ucyUzRCU1QiUyMkluY29ycmVjdCUyMiUyQyUyMCUyMkFtYmlndW91cyUyMiU1RCUyQyUwQSklMEFkZW1vX3dpdGhfY3VzdG9tX2ZsYWdnaW5nLmxhdW5jaCgp",highlighted:`demo_with_custom_flagging = gr.Interface(
    fn=greet,
    inputs=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;slider&quot;</span>],  <span class="hljs-comment"># the inputs are a text box and a slider (&quot;text&quot; and &quot;slider&quot; are components in Gradio)</span>
    outputs=[<span class="hljs-string">&quot;text&quot;</span>],  <span class="hljs-comment"># the output is a text box</span>
    allow_flagging=<span class="hljs-string">&quot;manual&quot;</span>,
    flagging_options=[<span class="hljs-string">&quot;Incorrect&quot;</span>, <span class="hljs-string">&quot;Ambiguous&quot;</span>],
)
demo_with_custom_flagging.launch()`,wrap:!1}}),ft=new m({props:{code:"IWNhdCUyMGZsYWdnZWQlMkZsb2cuY3N2",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!cat flagged/log.csv',wrap:!1}}),Tt=new f({props:{title:"Wrap up & Next Steps",local:"wrap-up--next-steps",headingTag:"h2"}}),vt=new f({props:{title:"⏭️ Further reading",local:"-further-reading",headingTag:"h2"}}),Zt=new bi({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/enterprise_cookbook_gradio.md"}}),{c(){h=s("meta"),J=a(),w=s("p"),T=a(),p(B.$$.fragment),Xt=a(),p(Z.$$.fragment),Rt=a(),C=s("p"),C.innerHTML=Nn,Yt=a(),p(W.$$.fragment),_t=a(),$=s("p"),$.innerHTML=An,St=a(),x=s("p"),x.textContent=En,zt=a(),H=s("ul"),H.innerHTML=qn,Ft=a(),k=s("p"),k.innerHTML=Pn,Qt=a(),p(V.$$.fragment),Lt=a(),X=s("p"),X.innerHTML=Dn,Nt=a(),p(R.$$.fragment),At=a(),p(Y.$$.fragment),Et=a(),p(_.$$.fragment),qt=a(),S=s("p"),S.textContent=Kn,Pt=a(),z=s("p"),z.innerHTML=On,Dt=a(),p(F.$$.fragment),Kt=a(),Q=s("p"),Q.textContent=ea,Ot=a(),p(L.$$.fragment),el=a(),N=s("pre"),N.textContent=ta,tl=a(),A=s("p"),A.innerHTML=la,ll=a(),p(E.$$.fragment),nl=a(),q=s("p"),q.innerHTML=na,al=a(),P=s("p"),P.innerHTML=aa,il=a(),p(D.$$.fragment),sl=a(),p(K.$$.fragment),ol=a(),O=s("p"),O.textContent=ia,rl=a(),ee=s("p"),ee.textContent=sa,pl=a(),te=s("p"),te.textContent=oa,ul=a(),le=s("ol"),le.innerHTML=ra,cl=a(),p(ne.$$.fragment),dl=a(),ae=s("p"),ae.textContent=pa,Ml=a(),ie=s("p"),ie.innerHTML=ua,yl=a(),se=s("p"),se.innerHTML=ca,hl=a(),p(oe.$$.fragment),ml=a(),re=s("p"),re.innerHTML=da,wl=a(),p(pe.$$.fragment),fl=a(),ue=s("p"),ue.innerHTML=Ma,Jl=a(),ce=s("p"),ce.innerHTML=ya,Tl=a(),p(b.$$.fragment),bl=a(),p(de.$$.fragment),gl=a(),Me=s("p"),Me.textContent=ha,Ul=a(),ye=s("p"),ye.innerHTML=ma,Il=a(),he=s("p"),he.innerHTML=wa,jl=a(),me=s("p"),me.innerHTML=fa,Gl=a(),we=s("p"),we.innerHTML=Ja,vl=a(),p(fe.$$.fragment),Bl=a(),Je=s("p"),Je.innerHTML=Ta,Zl=a(),Te=s("p"),Te.textContent=ba,Cl=a(),be=s("ul"),be.innerHTML=ga,Wl=a(),p(ge.$$.fragment),$l=a(),p(Ue.$$.fragment),xl=a(),Ie=s("p"),Ie.innerHTML=Ua,Hl=a(),p(je.$$.fragment),kl=a(),Ge=s("p"),Ge.textContent=Ia,Vl=a(),ve=s("p"),ve.innerHTML=ja,Xl=a(),p(Be.$$.fragment),Rl=a(),Ze=s("p"),Ze.textContent=Ga,Yl=a(),Ce=s("ol"),Ce.innerHTML=va,_l=a(),We=s("p"),We.innerHTML=Ba,Sl=a(),p($e.$$.fragment),zl=a(),xe=s("p"),xe.textContent=Za,Fl=a(),p(He.$$.fragment),Ql=a(),ke=s("p"),ke.textContent=Ca,Ll=a(),Ve=s("p"),Ve.textContent=Wa,Nl=a(),Xe=s("p"),Xe.innerHTML=$a,Al=a(),g=s("img"),El=a(),Re=s("p"),Re.innerHTML=Ha,ql=a(),Ye=s("p"),Ye.textContent=ka,Pl=a(),U=s("ul"),_e=s("li"),xt=s("p"),xt.innerHTML=Va,Fn=a(),p(Se.$$.fragment),Qn=a(),ze=s("li"),Ht=s("p"),Ht.innerHTML=Xa,Ln=a(),p(Fe.$$.fragment),Dl=a(),p(Qe.$$.fragment),Kl=a(),Le=s("p"),Le.textContent=Ra,Ol=a(),Ne=s("ul"),Ne.innerHTML=Ya,en=a(),p(Ae.$$.fragment),tn=a(),Ee=s("p"),Ee.innerHTML=_a,ln=a(),qe=s("p"),qe.innerHTML=Sa,nn=a(),I=s("img"),an=a(),Pe=s("p"),Pe.textContent=Fa,sn=a(),p(De.$$.fragment),on=a(),p(Ke.$$.fragment),rn=a(),Oe=s("pre"),Oe.textContent=Qa,pn=a(),et=s("p"),et.textContent=La,un=a(),tt=s("ul"),tt.innerHTML=Na,cn=a(),lt=s("p"),lt.innerHTML=Aa,dn=a(),nt=s("p"),nt.innerHTML=Ea,Mn=a(),p(j.$$.fragment),yn=a(),p(at.$$.fragment),hn=a(),it=s("p"),it.innerHTML=qa,mn=a(),p(st.$$.fragment),wn=a(),ot=s("p"),ot.innerHTML=Pa,fn=a(),p(rt.$$.fragment),Jn=a(),pt=s("p"),pt.innerHTML=Da,Tn=a(),ut=s("p"),ut.textContent=Ka,bn=a(),ct=s("p"),ct.innerHTML=Oa,gn=a(),p(dt.$$.fragment),Un=a(),Mt=s("pre"),Mt.textContent=ei,In=a(),yt=s("p"),yt.innerHTML=ti,jn=a(),ht=s("p"),ht.innerHTML=li,Gn=a(),p(mt.$$.fragment),vn=a(),wt=s("p"),wt.innerHTML=ni,Bn=a(),p(ft.$$.fragment),Zn=a(),Jt=s("pre"),Jt.textContent=ai,Cn=a(),p(Tt.$$.fragment),Wn=a(),bt=s("p"),bt.textContent=ii,$n=a(),gt=s("p"),gt.textContent=si,xn=a(),Ut=s("p"),Ut.innerHTML=oi,Hn=a(),It=s("p"),It.textContent=ri,kn=a(),jt=s("p"),jt.textContent=pi,Vn=a(),Gt=s("p"),Gt.innerHTML=ui,Xn=a(),p(vt.$$.fragment),Rn=a(),Bt=s("ul"),Bt.innerHTML=ci,Yn=a(),p(Zt.$$.fragment),_n=a(),kt=s("p"),this.h()},l(e){const t=Ji("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=i(e),w=o(e,"P",{}),Vt(w).forEach(l),T=i(e),u(B.$$.fragment,e),Xt=i(e),u(Z.$$.fragment,e),Rt=i(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-jo227l"&&(C.innerHTML=Nn),Yt=i(e),u(W.$$.fragment,e),_t=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-tfh72r"&&($.innerHTML=An),St=i(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-18fq2ds"&&(x.textContent=En),zt=i(e),H=o(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-yc80xa"&&(H.innerHTML=qn),Ft=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-dsdcpw"&&(k.innerHTML=Pn),Qt=i(e),u(V.$$.fragment,e),Lt=i(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-ndetzi"&&(X.innerHTML=Dn),Nt=i(e),u(R.$$.fragment,e),At=i(e),u(Y.$$.fragment,e),Et=i(e),u(_.$$.fragment,e),qt=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-imykz0"&&(S.textContent=Kn),Pt=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-ck34qj"&&(z.innerHTML=On),Dt=i(e),u(F.$$.fragment,e),Kt=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-i6af0b"&&(Q.textContent=ea),Ot=i(e),u(L.$$.fragment,e),el=i(e),N=o(e,"PRE",{"data-svelte-h":!0}),r(N)!=="svelte-1d8bxpj"&&(N.textContent=ta),tl=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ao31px"&&(A.innerHTML=la),ll=i(e),u(E.$$.fragment,e),nl=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1srjwy5"&&(q.innerHTML=na),al=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-idgyqj"&&(P.innerHTML=aa),il=i(e),u(D.$$.fragment,e),sl=i(e),u(K.$$.fragment,e),ol=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-17laqx2"&&(O.textContent=ia),rl=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1yo8y7n"&&(ee.textContent=sa),pl=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-ekm3wd"&&(te.textContent=oa),ul=i(e),le=o(e,"OL",{"data-svelte-h":!0}),r(le)!=="svelte-86ps6"&&(le.innerHTML=ra),cl=i(e),u(ne.$$.fragment,e),dl=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-16t2jma"&&(ae.textContent=pa),Ml=i(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-oonzuh"&&(ie.innerHTML=ua),yl=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-mzfgq9"&&(se.innerHTML=ca),hl=i(e),u(oe.$$.fragment,e),ml=i(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-2mbqop"&&(re.innerHTML=da),wl=i(e),u(pe.$$.fragment,e),fl=i(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-qv5xew"&&(ue.innerHTML=Ma),Jl=i(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1yvhatv"&&(ce.innerHTML=ya),Tl=i(e),u(b.$$.fragment,e),bl=i(e),u(de.$$.fragment,e),gl=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1pk54pa"&&(Me.textContent=ha),Ul=i(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-121gwix"&&(ye.innerHTML=ma),Il=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-rn2c0"&&(he.innerHTML=wa),jl=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1ytrw7h"&&(me.innerHTML=fa),Gl=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-eig0yh"&&(we.innerHTML=Ja),vl=i(e),u(fe.$$.fragment,e),Bl=i(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1nuljlf"&&(Je.innerHTML=Ta),Zl=i(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1t4rfuz"&&(Te.textContent=ba),Cl=i(e),be=o(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-590jvf"&&(be.innerHTML=ga),Wl=i(e),u(ge.$$.fragment,e),$l=i(e),u(Ue.$$.fragment,e),xl=i(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1y7r0u"&&(Ie.innerHTML=Ua),Hl=i(e),u(je.$$.fragment,e),kl=i(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1qiucww"&&(Ge.textContent=Ia),Vl=i(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-l930ml"&&(ve.innerHTML=ja),Xl=i(e),u(Be.$$.fragment,e),Rl=i(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-su8pwm"&&(Ze.textContent=Ga),Yl=i(e),Ce=o(e,"OL",{"data-svelte-h":!0}),r(Ce)!=="svelte-jraobi"&&(Ce.innerHTML=va),_l=i(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-97jp0s"&&(We.innerHTML=Ba),Sl=i(e),u($e.$$.fragment,e),zl=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-ug6zdj"&&(xe.textContent=Za),Fl=i(e),u(He.$$.fragment,e),Ql=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1f1og5o"&&(ke.textContent=Ca),Ll=i(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-18it3mz"&&(Ve.textContent=Wa),Nl=i(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-7nl279"&&(Xe.innerHTML=$a),Al=i(e),g=o(e,"IMG",{src:!0,width:!0,alt:!0}),El=i(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-112s0s1"&&(Re.innerHTML=Ha),ql=i(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-t0rmiw"&&(Ye.textContent=ka),Pl=i(e),U=o(e,"UL",{});var Ct=Vt(U);_e=o(Ct,"LI",{});var Wt=Vt(_e);xt=o(Wt,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1rhlgw4"&&(xt.innerHTML=Va),Fn=i(Wt),u(Se.$$.fragment,Wt),Wt.forEach(l),Qn=i(Ct),ze=o(Ct,"LI",{});var zn=Vt(ze);Ht=o(zn,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-qc8pgv"&&(Ht.innerHTML=Xa),Ln=i(zn),u(Fe.$$.fragment,zn),zn.forEach(l),Ct.forEach(l),Dl=i(e),u(Qe.$$.fragment,e),Kl=i(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-8s6vsh"&&(Le.textContent=Ra),Ol=i(e),Ne=o(e,"UL",{"data-svelte-h":!0}),r(Ne)!=="svelte-1vr4ngb"&&(Ne.innerHTML=Ya),en=i(e),u(Ae.$$.fragment,e),tn=i(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-7qbjz7"&&(Ee.innerHTML=_a),ln=i(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1ydqs3k"&&(qe.innerHTML=Sa),nn=i(e),I=o(e,"IMG",{src:!0,width:!0,alt:!0}),an=i(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-853jwi"&&(Pe.textContent=Fa),sn=i(e),u(De.$$.fragment,e),on=i(e),u(Ke.$$.fragment,e),rn=i(e),Oe=o(e,"PRE",{"data-svelte-h":!0}),r(Oe)!=="svelte-1f419gx"&&(Oe.textContent=Qa),pn=i(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-7n3hrv"&&(et.textContent=La),un=i(e),tt=o(e,"UL",{"data-svelte-h":!0}),r(tt)!=="svelte-8wzody"&&(tt.innerHTML=Na),cn=i(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-edepwe"&&(lt.innerHTML=Aa),dn=i(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-czm7yu"&&(nt.innerHTML=Ea),Mn=i(e),u(j.$$.fragment,e),yn=i(e),u(at.$$.fragment,e),hn=i(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-bmr5of"&&(it.innerHTML=qa),mn=i(e),u(st.$$.fragment,e),wn=i(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-6zs2wg"&&(ot.innerHTML=Pa),fn=i(e),u(rt.$$.fragment,e),Jn=i(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-j019a0"&&(pt.innerHTML=Da),Tn=i(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-byl69c"&&(ut.textContent=Ka),bn=i(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-qd0749"&&(ct.innerHTML=Oa),gn=i(e),u(dt.$$.fragment,e),Un=i(e),Mt=o(e,"PRE",{"data-svelte-h":!0}),r(Mt)!=="svelte-t58374"&&(Mt.textContent=ei),In=i(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1f1ercz"&&(yt.innerHTML=ti),jn=i(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1kvyfsz"&&(ht.innerHTML=li),Gn=i(e),u(mt.$$.fragment,e),vn=i(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-n67zfm"&&(wt.innerHTML=ni),Bn=i(e),u(ft.$$.fragment,e),Zn=i(e),Jt=o(e,"PRE",{"data-svelte-h":!0}),r(Jt)!=="svelte-p76wiz"&&(Jt.textContent=ai),Cn=i(e),u(Tt.$$.fragment,e),Wn=i(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-s3ahdf"&&(bt.textContent=ii),$n=i(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1c8mrg"&&(gt.textContent=si),xn=i(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-1ef1i7i"&&(Ut.innerHTML=oi),Hn=i(e),It=o(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-v4dtnd"&&(It.textContent=ri),kn=i(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-thjo29"&&(jt.textContent=pi),Vn=i(e),Gt=o(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-3wup7e"&&(Gt.innerHTML=ui),Xn=i(e),u(vt.$$.fragment,e),Rn=i(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-pif45z"&&(Bt.innerHTML=ci),Yn=i(e),u(Zt.$$.fragment,e),_n=i(e),kt=o(e,"P",{}),Vt(kt).forEach(l),this.h()},h(){G(h,"name","hf:doc:metadata"),G(h,"content",ji),di(g.src,xa="https://github.com/dmaniloff/public-screenshots/blob/main/create-new-space.png?raw=true")||G(g,"src",xa),G(g,"width","350"),G(g,"alt","image description"),di(I.src,za="https://github.com/dmaniloff/public-screenshots/blob/main/gradio-as-api.png?raw=true")||G(I,"src",za),G(I,"width","750"),G(I,"alt","image description")},m(e,t){v(document.head,h),n(e,J,t),n(e,w,t),n(e,T,t),c(B,e,t),n(e,Xt,t),c(Z,e,t),n(e,Rt,t),n(e,C,t),n(e,Yt,t),c(W,e,t),n(e,_t,t),n(e,$,t),n(e,St,t),n(e,x,t),n(e,zt,t),n(e,H,t),n(e,Ft,t),n(e,k,t),n(e,Qt,t),c(V,e,t),n(e,Lt,t),n(e,X,t),n(e,Nt,t),c(R,e,t),n(e,At,t),c(Y,e,t),n(e,Et,t),c(_,e,t),n(e,qt,t),n(e,S,t),n(e,Pt,t),n(e,z,t),n(e,Dt,t),c(F,e,t),n(e,Kt,t),n(e,Q,t),n(e,Ot,t),c(L,e,t),n(e,el,t),n(e,N,t),n(e,tl,t),n(e,A,t),n(e,ll,t),c(E,e,t),n(e,nl,t),n(e,q,t),n(e,al,t),n(e,P,t),n(e,il,t),c(D,e,t),n(e,sl,t),c(K,e,t),n(e,ol,t),n(e,O,t),n(e,rl,t),n(e,ee,t),n(e,pl,t),n(e,te,t),n(e,ul,t),n(e,le,t),n(e,cl,t),c(ne,e,t),n(e,dl,t),n(e,ae,t),n(e,Ml,t),n(e,ie,t),n(e,yl,t),n(e,se,t),n(e,hl,t),c(oe,e,t),n(e,ml,t),n(e,re,t),n(e,wl,t),c(pe,e,t),n(e,fl,t),n(e,ue,t),n(e,Jl,t),n(e,ce,t),n(e,Tl,t),c(b,e,t),n(e,bl,t),c(de,e,t),n(e,gl,t),n(e,Me,t),n(e,Ul,t),n(e,ye,t),n(e,Il,t),n(e,he,t),n(e,jl,t),n(e,me,t),n(e,Gl,t),n(e,we,t),n(e,vl,t),c(fe,e,t),n(e,Bl,t),n(e,Je,t),n(e,Zl,t),n(e,Te,t),n(e,Cl,t),n(e,be,t),n(e,Wl,t),c(ge,e,t),n(e,$l,t),c(Ue,e,t),n(e,xl,t),n(e,Ie,t),n(e,Hl,t),c(je,e,t),n(e,kl,t),n(e,Ge,t),n(e,Vl,t),n(e,ve,t),n(e,Xl,t),c(Be,e,t),n(e,Rl,t),n(e,Ze,t),n(e,Yl,t),n(e,Ce,t),n(e,_l,t),n(e,We,t),n(e,Sl,t),c($e,e,t),n(e,zl,t),n(e,xe,t),n(e,Fl,t),c(He,e,t),n(e,Ql,t),n(e,ke,t),n(e,Ll,t),n(e,Ve,t),n(e,Nl,t),n(e,Xe,t),n(e,Al,t),n(e,g,t),n(e,El,t),n(e,Re,t),n(e,ql,t),n(e,Ye,t),n(e,Pl,t),n(e,U,t),v(U,_e),v(_e,xt),v(_e,Fn),c(Se,_e,null),v(U,Qn),v(U,ze),v(ze,Ht),v(ze,Ln),c(Fe,ze,null),n(e,Dl,t),c(Qe,e,t),n(e,Kl,t),n(e,Le,t),n(e,Ol,t),n(e,Ne,t),n(e,en,t),c(Ae,e,t),n(e,tn,t),n(e,Ee,t),n(e,ln,t),n(e,qe,t),n(e,nn,t),n(e,I,t),n(e,an,t),n(e,Pe,t),n(e,sn,t),c(De,e,t),n(e,on,t),c(Ke,e,t),n(e,rn,t),n(e,Oe,t),n(e,pn,t),n(e,et,t),n(e,un,t),n(e,tt,t),n(e,cn,t),n(e,lt,t),n(e,dn,t),n(e,nt,t),n(e,Mn,t),c(j,e,t),n(e,yn,t),c(at,e,t),n(e,hn,t),n(e,it,t),n(e,mn,t),c(st,e,t),n(e,wn,t),n(e,ot,t),n(e,fn,t),c(rt,e,t),n(e,Jn,t),n(e,pt,t),n(e,Tn,t),n(e,ut,t),n(e,bn,t),n(e,ct,t),n(e,gn,t),c(dt,e,t),n(e,Un,t),n(e,Mt,t),n(e,In,t),n(e,yt,t),n(e,jn,t),n(e,ht,t),n(e,Gn,t),c(mt,e,t),n(e,vn,t),n(e,wt,t),n(e,Bn,t),c(ft,e,t),n(e,Zn,t),n(e,Jt,t),n(e,Cn,t),c(Tt,e,t),n(e,Wn,t),n(e,bt,t),n(e,$n,t),n(e,gt,t),n(e,xn,t),n(e,Ut,t),n(e,Hn,t),n(e,It,t),n(e,kn,t),n(e,jt,t),n(e,Vn,t),n(e,Gt,t),n(e,Xn,t),c(vt,e,t),n(e,Rn,t),n(e,Bt,t),n(e,Yn,t),c(Zt,e,t),n(e,_n,t),n(e,kt,t),Sn=!0},p(e,[t]){const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),b.$set(Ct);const Wt={};t&2&&(Wt.$$scope={dirty:t,ctx:e}),j.$set(Wt)},i(e){Sn||(d(B.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(Y.$$.fragment,e),d(_.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(E.$$.fragment,e),d(D.$$.fragment,e),d(K.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(b.$$.fragment,e),d(de.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(Be.$$.fragment,e),d($e.$$.fragment,e),d(He.$$.fragment,e),d(Se.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(Ae.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(j.$$.fragment,e),d(at.$$.fragment,e),d(st.$$.fragment,e),d(rt.$$.fragment,e),d(dt.$$.fragment,e),d(mt.$$.fragment,e),d(ft.$$.fragment,e),d(Tt.$$.fragment,e),d(vt.$$.fragment,e),d(Zt.$$.fragment,e),Sn=!0)},o(e){M(B.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(V.$$.fragment,e),M(R.$$.fragment,e),M(Y.$$.fragment,e),M(_.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(E.$$.fragment,e),M(D.$$.fragment,e),M(K.$$.fragment,e),M(ne.$$.fragment,e),M(oe.$$.fragment,e),M(pe.$$.fragment,e),M(b.$$.fragment,e),M(de.$$.fragment,e),M(fe.$$.fragment,e),M(ge.$$.fragment,e),M(Ue.$$.fragment,e),M(je.$$.fragment,e),M(Be.$$.fragment,e),M($e.$$.fragment,e),M(He.$$.fragment,e),M(Se.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(Ae.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(j.$$.fragment,e),M(at.$$.fragment,e),M(st.$$.fragment,e),M(rt.$$.fragment,e),M(dt.$$.fragment,e),M(mt.$$.fragment,e),M(ft.$$.fragment,e),M(Tt.$$.fragment,e),M(vt.$$.fragment,e),M(Zt.$$.fragment,e),Sn=!1},d(e){e&&(l(J),l(w),l(T),l(Xt),l(Rt),l(C),l(Yt),l(_t),l($),l(St),l(x),l(zt),l(H),l(Ft),l(k),l(Qt),l(Lt),l(X),l(Nt),l(At),l(Et),l(qt),l(S),l(Pt),l(z),l(Dt),l(Kt),l(Q),l(Ot),l(el),l(N),l(tl),l(A),l(ll),l(nl),l(q),l(al),l(P),l(il),l(sl),l(ol),l(O),l(rl),l(ee),l(pl),l(te),l(ul),l(le),l(cl),l(dl),l(ae),l(Ml),l(ie),l(yl),l(se),l(hl),l(ml),l(re),l(wl),l(fl),l(ue),l(Jl),l(ce),l(Tl),l(bl),l(gl),l(Me),l(Ul),l(ye),l(Il),l(he),l(jl),l(me),l(Gl),l(we),l(vl),l(Bl),l(Je),l(Zl),l(Te),l(Cl),l(be),l(Wl),l($l),l(xl),l(Ie),l(Hl),l(kl),l(Ge),l(Vl),l(ve),l(Xl),l(Rl),l(Ze),l(Yl),l(Ce),l(_l),l(We),l(Sl),l(zl),l(xe),l(Fl),l(Ql),l(ke),l(Ll),l(Ve),l(Nl),l(Xe),l(Al),l(g),l(El),l(Re),l(ql),l(Ye),l(Pl),l(U),l(Dl),l(Kl),l(Le),l(Ol),l(Ne),l(en),l(tn),l(Ee),l(ln),l(qe),l(nn),l(I),l(an),l(Pe),l(sn),l(on),l(rn),l(Oe),l(pn),l(et),l(un),l(tt),l(cn),l(lt),l(dn),l(nt),l(Mn),l(yn),l(hn),l(it),l(mn),l(wn),l(ot),l(fn),l(Jn),l(pt),l(Tn),l(ut),l(bn),l(ct),l(gn),l(Un),l(Mt),l(In),l(yt),l(jn),l(ht),l(Gn),l(vn),l(wt),l(Bn),l(Zn),l(Jt),l(Cn),l(Wn),l(bt),l($n),l(gt),l(xn),l(Ut),l(Hn),l(It),l(kn),l(jt),l(Vn),l(Gt),l(Xn),l(Rn),l(Bt),l(Yn),l(_n),l(kt)),l(h),y(B,e),y(Z,e),y(W,e),y(V,e),y(R,e),y(Y,e),y(_,e),y(F,e),y(L,e),y(E,e),y(D,e),y(K,e),y(ne,e),y(oe,e),y(pe,e),y(b,e),y(de,e),y(fe,e),y(ge,e),y(Ue,e),y(je,e),y(Be,e),y($e,e),y(He,e),y(Se),y(Fe),y(Qe,e),y(Ae,e),y(De,e),y(Ke,e),y(j,e),y(at,e),y(st,e),y(rt,e),y(dt,e),y(mt,e),y(ft,e),y(Tt,e),y(vt,e),y(Zt,e)}}}const ji='{"title":"Creating Demos with Spaces and Gradio","local":"creating-demos-with-spaces-and-gradio","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Your first demo: the basics of Gradio","local":"your-first-demo-the-basics-of-gradio","sections":[],"depth":2},{"title":"Let’s make it interesting: a meeting transcription tool","local":"lets-make-it-interesting-a-meeting-transcription-tool","sections":[{"title":"Audio-to-text","local":"audio-to-text","sections":[],"depth":3},{"title":"Organize & summarize text","local":"organize--summarize-text","sections":[],"depth":3},{"title":"Putting it all together","local":"putting-it-all-together","sections":[],"depth":3}],"depth":2},{"title":"Move your demo into 🤗 Spaces","local":"move-your-demo-into--spaces","sections":[],"depth":2},{"title":"Gradio comes with batteries included 🔋","local":"gradio-comes-with-batteries-included-","sections":[{"title":"Access as an API","local":"access-as-an-api","sections":[],"depth":3},{"title":"Share via public URL","local":"share-via-public-url","sections":[],"depth":3},{"title":"Flagging","local":"flagging","sections":[],"depth":3}],"depth":2},{"title":"Wrap up & Next Steps","local":"wrap-up--next-steps","sections":[],"depth":2},{"title":"⏭️ Further reading","local":"-further-reading","sections":[],"depth":2}],"depth":1}';function Gi($t){return mi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $i extends wi{constructor(h){super(),fi(this,h,Gi,Ii,hi,{})}}export{$i as component};
