import{s as Oe,n as qe,o as Ke}from"../chunks/scheduler.7da89386.js";import{S as et,i as tt,g as s,s as i,r,A as lt,h as o,f as l,c as a,j as Pe,u as p,x as m,k as Be,y as nt,a as n,v as u,d,t as h,w as f}from"../chunks/index.0b7befd3.js";import{C as P}from"../chunks/CodeBlock.c5b6371f.js";import{H as M,E as it}from"../chunks/getInferenceSnippets.4d490e77.js";function at(Ze){let c,O,D,q,T,K,_,Le="Using several Gaudi servers to perform multi-node training can be done easily. This guide shows how to:",ee,g,xe="<li>set up several Gaudi instances</li> <li>set up your computing environment</li> <li>launch a multi-node run</li>",te,y,le,J,Re="Two types of configurations are possible:",ne,$,Ae="<li>scale-out using Gaudi NICs or Host NICs (on-premises)</li> <li>scale-out using Intel® Tiber™ AI Cloud instances</li>",ie,U,ae,b,Se='To set up your servers on premises, check out the <a href="https://docs.habana.ai/en/latest/Installation_Guide/Bare_Metal_Fresh_OS.html" rel="nofollow">installation</a> and <a href="https://docs.habana.ai/en/latest/PyTorch/PyTorch_Scaling_Guide/index.html" rel="nofollow">distributed training</a> pages of Intel® Gaudi® AI Accelerator’s documentation.',se,I,oe,v,We='Follow the steps on <a href="https://docs.habana.ai/en/latest/Intel_DevCloud_Quick_Start/Intel_DevCloud_Quick_Start.html#creating-an-account-and-getting-an-instance" rel="nofollow">creating an account and getting an instance</a> pages of Intel® Gaudi® AI Accelerator’s documentation.',me,C,re,X,Ge='Once your Intel Gaudi instances are ready, follow the steps for <a href="https://docs.habana.ai/en/latest/Intel_DevCloud_Quick_Start/Intel_DevCloud_Quick_Start.html#setting-up-a-multi-server-environment" rel="nofollow">setting up a multi-server environment</a> pages of Intel® Gaudi® AI Accelerator’s documentation.',pe,j,He="Finally, there are two possible ways to run your training script on several nodes:",ue,B,Ve='<li>With the <a href="https://github.com/huggingface/optimum-habana/blob/main/examples/gaudi_spawn.py" rel="nofollow"><code>gaudi_spawn.py</code></a> script, you can run the following command:</li>',de,Z,he,L,ke="where <code>--argX</code> is an argument of the script to run.",fe,w,Fe="<li>With the <code>DistributedRunner</code>, you can add this code snippet to a script:</li>",ce,x,we,R,Me,A,Ee='If you need to set environment variables for all nodes, you can specify them in a <a href="https://www.deepspeed.ai/getting-started/#multi-node-environment-variables" rel="nofollow"><code>.deepspeed_env</code></a> file which should be located in the local path you are executing from or in your home directory. The format is the following:',Te,S,_e,W,ge,G,Ye='<li>It is strongly recommended to use gradient checkpointing for multi-node runs to get the highest speedups. You can enable it with <code>--gradient_checkpointing</code> in <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">these examples</a> or with <code>gradient_checkpointing=True</code> in your <code>GaudiTrainingArguments</code>.</li> <li>Larger batch sizes should lead to higher speedups.</li> <li>Multi-node inference is not recommended and can provide inconsistent results.</li> <li>On Intel Tiber AI Cloud instances, run your Docker containers with the <code>--privileged</code> flag so that EFA devices are visible.</li>',ye,H,Je,V,Qe=`In this example, we fine-tune a pre-trained GPT2-XL model on the <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText dataset</a>.
We are going to use the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples/language-modeling#gpt-2gpt-and-causal-language-modeling" rel="nofollow">causal language modeling example which is given in the Github repository</a>.`,$e,k,ze="The first step consists in training the model on several nodes with this command:",Ue,F,be,E,De="Evaluation is not performed in the same command because we do not recommend performing multi-node inference at the moment.",Ie,Y,Ne=`Once the model is trained, we can evaluate it with the following command.
The argument <code>--model_name_or_path</code> should be equal to the argument <code>--output_dir</code> of the previous command.`,ve,Q,Ce,z,Xe,N,je;return T=new M({props:{title:"Multi-node Training",local:"multi-node-training",headingTag:"h1"}}),y=new M({props:{title:"Setting up several Gaudi instances",local:"setting-up-several-gaudi-instances",headingTag:"h2"}}),U=new M({props:{title:"On premises",local:"on-premises",headingTag:"h3"}}),I=new M({props:{title:"Intel Tiber AI Cloud instances",local:"intel-tiber-ai-cloud-instances",headingTag:"h3"}}),C=new M({props:{title:"Launching a Multi-node Run",local:"launching-a-multi-node-run",headingTag:"h2"}}),Z=new P({props:{code:"cHl0aG9uJTIwZ2F1ZGlfc3Bhd24ucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLWhvc3RmaWxlJTIwcGF0aF90b19teV9ob3N0ZmlsZSUyMC0tdXNlX2RlZXBzcGVlZCUyMCU1QyUwQSUyMCUyMCUyMCUyMHBhdGhfdG9fbXlfc2NyaXB0LnB5JTIwLS1hcmdzMSUyMC0tYXJnczIlMjAuLi4lMjAtLWFyZ3NOJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kZWVwc3BlZWQlMjBwYXRoX3RvX215X2RlZXBzcGVlZF9jb25maWc=",highlighted:`python gaudi_spawn.py \\
    --hostfile path_to_my_hostfile --use_deepspeed \\
    path_to_my_script.py --args1 --args2 ... --argsN \\
    --deepspeed path_to_my_deepspeed_config`,wrap:!1}}),x=new P({props:{code:"ZnJvbSUyMG9wdGltdW0uaGFiYW5hLmRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwRGlzdHJpYnV0ZWRSdW5uZXIlMEElMEFkaXN0cmlidXRlZF9ydW5uZXIlMjAlM0QlMjBEaXN0cmlidXRlZFJ1bm5lciglMEElMjAlMjAlMjAlMjBjb21tYW5kX2xpc3QlM0QlNUIlMjJwYXRoX3RvX215X3NjcmlwdC5weSUyMC0tYXJnczElMjAtLWFyZ3MyJTIwLi4uJTIwLS1hcmdzTiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGhvc3RmaWxlJTNEcGF0aF90b19teV9ob3N0ZmlsZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9kZWVwc3BlZWQlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.habana.distributed <span class="hljs-keyword">import</span> DistributedRunner

distributed_runner = DistributedRunner(
    command_list=[<span class="hljs-string">&quot;path_to_my_script.py --args1 --args2 ... --argsN&quot;</span>],
    hostfile=path_to_my_hostfile,
    use_deepspeed=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),R=new M({props:{title:"Environment Variables",local:"environment-variables",headingTag:"h2"}}),S=new P({props:{code:"ZW52X3ZhcmlhYmxlXzFfbmFtZSUzRHZhbHVlJTBBZW52X3ZhcmlhYmxlXzJfbmFtZSUzRHZhbHVlJTBBLi4u",highlighted:`<span class="hljs-attribute">env_variable_1_name</span>=value
<span class="hljs-attribute">env_variable_2_name</span>=value
<span class="hljs-built_in">..</span>.`,wrap:!1}}),W=new M({props:{title:"Recommendations",local:"recommendations",headingTag:"h2"}}),H=new M({props:{title:"Example",local:"example",headingTag:"h2"}}),F=new P({props:{code:"UFRfSFBVX0xBWllfTU9ERSUzRDElMjBweXRob24lMjAuLiUyRmdhdWRpX3NwYXduLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ob3N0ZmlsZSUyMHBhdGhfdG9faG9zdGZpbGUlMjAtLXVzZV9kZWVwc3BlZWQlMjBydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBncHQyLXhsJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1nYXVkaV9jb25maWdfbmFtZSUyMEhhYmFuYSUyRmdwdDIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGZ3B0Ml94bF9tdWx0aV9ub2RlJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTIwNGUtMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlX2hhYmFuYSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlX2xhenlfbW9kZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGhyb3VnaHB1dF93YXJtdXBfc3RlcHMlMjAzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kZWVwc3BlZWQlMjBwYXRoX3RvX2RlZXBzcGVlZF9jb25maWc=",highlighted:`PT_HPU_LAZY_MODE=1 python ../gaudi_spawn.py \\
    --hostfile path_to_hostfile --use_deepspeed run_clm.py \\
    --model_name_or_path gpt2-xl \\
    --gaudi_config_name Habana/gpt2 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --output_dir /tmp/gpt2_xl_multi_node \\
    --learning_rate 4e-04 \\
    --per_device_train_batch_size 16 \\
    --gradient_checkpointing \\
    --num_train_epochs 1 \\
    --use_habana \\
    --use_lazy_mode \\
    --throughput_warmup_steps 3 \\
    --deepspeed path_to_deepspeed_config`,wrap:!1}}),Q=new P({props:{code:"UFRfSFBVX0xBWllfTU9ERSUzRDElMjBweXRob24lMjBydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjAlMkZ0bXAlMkZncHQyX3hsX211bHRpX25vZGUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdhdWRpX2NvbmZpZ19uYW1lJTIwSGFiYW5hJTJGZ3B0MiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZG9fZXZhbCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRmdwdDJfeGxfbXVsdGlfbm9kZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlMjA4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11c2VfaGFiYW5hJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11c2VfbGF6eV9tb2Rl",highlighted:`PT_HPU_LAZY_MODE=1 python run_clm.py \\
    --model_name_or_path /tmp/gpt2_xl_multi_node \\
    --gaudi_config_name Habana/gpt2 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_eval \\
    --output_dir /tmp/gpt2_xl_multi_node \\
    --per_device_eval_batch_size 8 \\
    --use_habana \\
    --use_lazy_mode`,wrap:!1}}),z=new it({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/multi_node_training.mdx"}}),{c(){c=s("meta"),O=i(),D=s("p"),q=i(),r(T.$$.fragment),K=i(),_=s("p"),_.textContent=Le,ee=i(),g=s("ul"),g.innerHTML=xe,te=i(),r(y.$$.fragment),le=i(),J=s("p"),J.textContent=Re,ne=i(),$=s("ul"),$.innerHTML=Ae,ie=i(),r(U.$$.fragment),ae=i(),b=s("p"),b.innerHTML=Se,se=i(),r(I.$$.fragment),oe=i(),v=s("p"),v.innerHTML=We,me=i(),r(C.$$.fragment),re=i(),X=s("p"),X.innerHTML=Ge,pe=i(),j=s("p"),j.textContent=He,ue=i(),B=s("ol"),B.innerHTML=Ve,de=i(),r(Z.$$.fragment),he=i(),L=s("p"),L.innerHTML=ke,fe=i(),w=s("ol"),w.innerHTML=Fe,ce=i(),r(x.$$.fragment),we=i(),r(R.$$.fragment),Me=i(),A=s("p"),A.innerHTML=Ee,Te=i(),r(S.$$.fragment),_e=i(),r(W.$$.fragment),ge=i(),G=s("ul"),G.innerHTML=Ye,ye=i(),r(H.$$.fragment),Je=i(),V=s("p"),V.innerHTML=Qe,$e=i(),k=s("p"),k.textContent=ze,Ue=i(),r(F.$$.fragment),be=i(),E=s("p"),E.textContent=De,Ie=i(),Y=s("p"),Y.innerHTML=Ne,ve=i(),r(Q.$$.fragment),Ce=i(),r(z.$$.fragment),Xe=i(),N=s("p"),this.h()},l(e){const t=lt("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),O=a(e),D=o(e,"P",{}),Pe(D).forEach(l),q=a(e),p(T.$$.fragment,e),K=a(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-qp9xqj"&&(_.textContent=Le),ee=a(e),g=o(e,"UL",{"data-svelte-h":!0}),m(g)!=="svelte-rop6rm"&&(g.innerHTML=xe),te=a(e),p(y.$$.fragment,e),le=a(e),J=o(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-se31mi"&&(J.textContent=Re),ne=a(e),$=o(e,"UL",{"data-svelte-h":!0}),m($)!=="svelte-1ei7enr"&&($.innerHTML=Ae),ie=a(e),p(U.$$.fragment,e),ae=a(e),b=o(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1vji76k"&&(b.innerHTML=Se),se=a(e),p(I.$$.fragment,e),oe=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1dltmt2"&&(v.innerHTML=We),me=a(e),p(C.$$.fragment,e),re=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-idgjfb"&&(X.innerHTML=Ge),pe=a(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-ce1e0i"&&(j.textContent=He),ue=a(e),B=o(e,"OL",{"data-svelte-h":!0}),m(B)!=="svelte-2kg0w5"&&(B.innerHTML=Ve),de=a(e),p(Z.$$.fragment,e),he=a(e),L=o(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-nmkk8f"&&(L.innerHTML=ke),fe=a(e),w=o(e,"OL",{start:!0,"data-svelte-h":!0}),m(w)!=="svelte-1sdtmds"&&(w.innerHTML=Fe),ce=a(e),p(x.$$.fragment,e),we=a(e),p(R.$$.fragment,e),Me=a(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1vzj3zu"&&(A.innerHTML=Ee),Te=a(e),p(S.$$.fragment,e),_e=a(e),p(W.$$.fragment,e),ge=a(e),G=o(e,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-1vk061t"&&(G.innerHTML=Ye),ye=a(e),p(H.$$.fragment,e),Je=a(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1ww31kw"&&(V.innerHTML=Qe),$e=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1y1hqcv"&&(k.textContent=ze),Ue=a(e),p(F.$$.fragment,e),be=a(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-472z3o"&&(E.textContent=De),Ie=a(e),Y=o(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1lr4pmk"&&(Y.innerHTML=Ne),ve=a(e),p(Q.$$.fragment,e),Ce=a(e),p(z.$$.fragment,e),Xe=a(e),N=o(e,"P",{}),Pe(N).forEach(l),this.h()},h(){Be(c,"name","hf:doc:metadata"),Be(c,"content",st),Be(w,"start","2")},m(e,t){nt(document.head,c),n(e,O,t),n(e,D,t),n(e,q,t),u(T,e,t),n(e,K,t),n(e,_,t),n(e,ee,t),n(e,g,t),n(e,te,t),u(y,e,t),n(e,le,t),n(e,J,t),n(e,ne,t),n(e,$,t),n(e,ie,t),u(U,e,t),n(e,ae,t),n(e,b,t),n(e,se,t),u(I,e,t),n(e,oe,t),n(e,v,t),n(e,me,t),u(C,e,t),n(e,re,t),n(e,X,t),n(e,pe,t),n(e,j,t),n(e,ue,t),n(e,B,t),n(e,de,t),u(Z,e,t),n(e,he,t),n(e,L,t),n(e,fe,t),n(e,w,t),n(e,ce,t),u(x,e,t),n(e,we,t),u(R,e,t),n(e,Me,t),n(e,A,t),n(e,Te,t),u(S,e,t),n(e,_e,t),u(W,e,t),n(e,ge,t),n(e,G,t),n(e,ye,t),u(H,e,t),n(e,Je,t),n(e,V,t),n(e,$e,t),n(e,k,t),n(e,Ue,t),u(F,e,t),n(e,be,t),n(e,E,t),n(e,Ie,t),n(e,Y,t),n(e,ve,t),u(Q,e,t),n(e,Ce,t),u(z,e,t),n(e,Xe,t),n(e,N,t),je=!0},p:qe,i(e){je||(d(T.$$.fragment,e),d(y.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(Z.$$.fragment,e),d(x.$$.fragment,e),d(R.$$.fragment,e),d(S.$$.fragment,e),d(W.$$.fragment,e),d(H.$$.fragment,e),d(F.$$.fragment,e),d(Q.$$.fragment,e),d(z.$$.fragment,e),je=!0)},o(e){h(T.$$.fragment,e),h(y.$$.fragment,e),h(U.$$.fragment,e),h(I.$$.fragment,e),h(C.$$.fragment,e),h(Z.$$.fragment,e),h(x.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),h(H.$$.fragment,e),h(F.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),je=!1},d(e){e&&(l(O),l(D),l(q),l(K),l(_),l(ee),l(g),l(te),l(le),l(J),l(ne),l($),l(ie),l(ae),l(b),l(se),l(oe),l(v),l(me),l(re),l(X),l(pe),l(j),l(ue),l(B),l(de),l(he),l(L),l(fe),l(w),l(ce),l(we),l(Me),l(A),l(Te),l(_e),l(ge),l(G),l(ye),l(Je),l(V),l($e),l(k),l(Ue),l(be),l(E),l(Ie),l(Y),l(ve),l(Ce),l(Xe),l(N)),l(c),f(T,e),f(y,e),f(U,e),f(I,e),f(C,e),f(Z,e),f(x,e),f(R,e),f(S,e),f(W,e),f(H,e),f(F,e),f(Q,e),f(z,e)}}}const st='{"title":"Multi-node Training","local":"multi-node-training","sections":[{"title":"Setting up several Gaudi instances","local":"setting-up-several-gaudi-instances","sections":[{"title":"On premises","local":"on-premises","sections":[],"depth":3},{"title":"Intel Tiber AI Cloud instances","local":"intel-tiber-ai-cloud-instances","sections":[],"depth":3}],"depth":2},{"title":"Launching a Multi-node Run","local":"launching-a-multi-node-run","sections":[],"depth":2},{"title":"Environment Variables","local":"environment-variables","sections":[],"depth":2},{"title":"Recommendations","local":"recommendations","sections":[],"depth":2},{"title":"Example","local":"example","sections":[],"depth":2}],"depth":1}';function ot(Ze){return Ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dt extends et{constructor(c){super(),tt(this,c,ot,at,Oe,{})}}export{dt as component};
