import{s as ht,n as ut,o as ct}from"../chunks/scheduler.7da89386.js";import{S as dt,i as $t,g as l,s as n,r as p,A as bt,h as m,f as s,c as a,j as rt,u as o,x as c,k as ft,y as gt,a as i,v as r,d as f,t as h,w as u}from"../chunks/index.0b7befd3.js";import{C as F}from"../chunks/CodeBlock.c5b6371f.js";import{H as d,E as yt}from"../chunks/getInferenceSnippets.4d490e77.js";function Mt(De){let $,K,Y,O,b,ee,g,Ke="This article demonstrates how to benchmark and compare the performance of the Habana Processing Unit (HPU)-optimized <code>safe_softmax</code> operation against the native PyTorch implementation. The provided Python script guides you through the process step-by-step, with detailed explanations for each part. Additionally, we will provide some context about <code>safe_softmax</code>, its purpose, and its use cases.",te,se,ie,y,ne,M,Oe="The <code>safe_softmax</code> operation works out-of-the-box in PyTorch. When running your code on Habana hardware, the HPU-optimized implementation is automatically utilized without any additional configuration. This seamless integration allows you to benefit from performance improvements without modifying your existing code.",ae,le,me,w,pe,T,et="The <code>softmax</code> function is a common operation in machine learning, particularly in classification tasks. It converts raw logits into probabilities by applying the exponential function and normalizing the results. However, the standard <code>softmax</code> can encounter numerical instability when dealing with very large or very small values in the input tensor, leading to overflow or underflow issues.",oe,x,tt="To address this, <code>safe_softmax</code> is implemented. It stabilizes the computation by subtracting the maximum value in each row (or along the specified dimension) from the logits before applying the exponential function. This ensures that the largest value in the exponent is zero, preventing overflow.",re,U,fe,_,st="<li><strong>Numerical Stability</strong>: Prevents overflow/underflow issues during computation.</li> <li><strong>Widely Used</strong>: Commonly used in neural networks, especially in the final layer for classification tasks.</li> <li><strong>Efficiency</strong>: Optimized implementations can significantly improve performance on specialized hardware like GPUs or HPUs.</li>",he,ue,ce,v,de,j,$e,H,be,J,it="<li><strong><code>torch</code></strong>: The core PyTorch library for tensor operations.</li> <li><strong><code>timeit</code></strong>: A Python module for measuring execution time.</li> <li><strong><code>habana_frameworks.torch</code></strong>: Provides support for Habana hardware (HPUs).</li> <li><strong><code>safe_softmax</code></strong>: The native PyTorch implementation of <code>safe_softmax</code> is imported for comparison.</li>",ge,ye,Me,C,we,k,Te,z,nt="<li>The HPU-optimized version of <code>safe_softmax</code> is accessed via the <code>torch.ops.aten</code> namespace. This implementation is specifically designed to leverage the Habana hardware for faster execution.</li>",xe,Ue,_e,I,ve,Z,je,W,at="<li>A 2D tensor is created with some typical values, including <code>-inf</code> to simulate edge cases.</li> <li>The tensor is moved to the HPU device using <code>.to(&quot;hpu&quot;)</code>.</li>",He,Je,Ce,G,ke,P,ze,N,lt="<li>Both the HPU-optimized and native implementations are executed once before benchmarking. This ensures that any initialization overhead is excluded from the timing measurements.</li> <li><code>ht.hpu.synchronize()</code> ensures that all HPU operations are completed before proceeding.</li>",Ie,Ze,We,L,Ge,E,Pe,B,mt="<li>The <code>timeit</code> module is used to measure the execution time of each implementation over 10,000 iterations.</li> <li>The <code>globals=globals()</code> argument allows the <code>timeit</code> module to access the defined variables and functions in the script.</li>",Ne,Le,Ee,V,Be,R,Ve,X,pt="<li>The execution times for both implementations are printed, allowing for a direct comparison of their performance.</li>",Re,Xe,Qe,Q,Se,S,ot="After running the script, you might see output similar to the following (lower is better):",qe,q,Ae,A,Fe,D,Ye;return b=new d({props:{title:"Comparing HPU-Optimized safe_softmax with Native PyTorch safe_softmax",local:"comparing-hpu-optimized-safesoftmax-with-native-pytorch-safesoftmax",headingTag:"h1"}}),y=new d({props:{title:"Important Note: No Special Setup Required",local:"important-note-no-special-setup-required",headingTag:"h2"}}),w=new d({props:{title:"What is safe_softmax ?",local:"what-is-safesoftmax-",headingTag:"h2"}}),U=new d({props:{title:"Why is safe_softmax important?",local:"why-is-safesoftmax-important",headingTag:"h3"}}),v=new d({props:{title:"Step-by-Step Explanation of the Code",local:"step-by-step-explanation-of-the-code",headingTag:"h2"}}),j=new d({props:{title:"1. Importing Required Libraries",local:"1-importing-required-libraries",headingTag:"h3"}}),H=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1laXQlMEFpbXBvcnQlMjBoYWJhbmFfZnJhbWV3b3Jrcy50b3JjaCUyMGFzJTIwaHQlMEFmcm9tJTIwdG9yY2guX2RlY29tcC5kZWNvbXBvc2l0aW9ucyUyMGltcG9ydCUyMHNhZmVfc29mdG1heCUyMGFzJTIwbmF0aXZlX3NhZmVfc29mdG1heA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> timeit
<span class="hljs-keyword">import</span> habana_frameworks.torch <span class="hljs-keyword">as</span> ht
<span class="hljs-keyword">from</span> torch._decomp.decompositions <span class="hljs-keyword">import</span> safe_softmax <span class="hljs-keyword">as</span> native_safe_softmax`,wrap:!1}}),C=new d({props:{title:"2. Defining the HPU-Optimized safe_softmax",local:"2-defining-the-hpu-optimized-safesoftmax",headingTag:"h3"}}),k=new F({props:{code:"aHB1X3NhZmVfc29mdG1heCUyMCUzRCUyMHRvcmNoLm9wcy5hdGVuLl9zYWZlX3NvZnRtYXguZGVmYXVsdA==",highlighted:"hpu_safe_softmax = torch.ops.aten._safe_softmax.default",wrap:!1}}),I=new d({props:{title:"3. Preparing the Input Tensor",local:"3-preparing-the-input-tensor",headingTag:"h3"}}),Z=new F({props:{code:"aW5wdXRfdGVuc29yJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QiU1QjEuMCUyQyUyMDIuMCUyQyUyMGZsb2F0KCUyMi1pbmYlMjIpJTVEJTJDJTIwJTVCMy4wJTJDJTIwNC4wJTJDJTIwNS4wJTVEJTVEKS50byglMjJocHUlMjIp",highlighted:'input_tensor = torch.tensor([[<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>)], [<span class="hljs-number">3.0</span>, <span class="hljs-number">4.0</span>, <span class="hljs-number">5.0</span>]]).to(<span class="hljs-string">&quot;hpu&quot;</span>)',wrap:!1}}),G=new d({props:{title:"4. Warmup for Fair Benchmarking",local:"4-warmup-for-fair-benchmarking",headingTag:"h3"}}),P=new F({props:{code:"aHB1X3NhZmVfc29mdG1heChpbnB1dF90ZW5zb3IlMkMlMjBkaW0lM0QxKSUzQiUyMGh0LmhwdS5zeW5jaHJvbml6ZSgpJTBBbmF0aXZlX3NhZmVfc29mdG1heChpbnB1dF90ZW5zb3IlMkMlMjBkaW0lM0QxKSUzQiUyMGh0LmhwdS5zeW5jaHJvbml6ZSgp",highlighted:`hpu_safe_softmax(input_tensor, dim=<span class="hljs-number">1</span>); ht.hpu.synchronize()
native_safe_softmax(input_tensor, dim=<span class="hljs-number">1</span>); ht.hpu.synchronize()`,wrap:!1}}),L=new d({props:{title:"5. Benchmarking the Implementations",local:"5-benchmarking-the-implementations",headingTag:"h3"}}),E=new F({props:{code:"bnVtX2l0ZXJhdGlvbnMlMjAlM0QlMjAxMDAwMCUwQWhwdV90aW1lJTIwJTNEJTIwdGltZWl0LnRpbWVpdCglMEElMjAlMjAlMjAlMjAlMjJocHVfc2FmZV9zb2Z0bWF4KGlucHV0X3RlbnNvciUyQyUyMGRpbSUzRDEpJTNCJTIwaHQuaHB1LnN5bmNocm9uaXplKCklMjIlMkMlMEElMjAlMjAlMjAlMjBnbG9iYWxzJTNEZ2xvYmFscygpJTJDJTBBJTIwJTIwJTIwJTIwbnVtYmVyJTNEbnVtX2l0ZXJhdGlvbnMlMEEpJTBBbmF0aXZlX3RpbWUlMjAlM0QlMjB0aW1laXQudGltZWl0KCUwQSUyMCUyMCUyMCUyMCUyMm5hdGl2ZV9zYWZlX3NvZnRtYXgoaW5wdXRfdGVuc29yJTJDJTIwZGltJTNEMSklM0IlMjBodC5ocHUuc3luY2hyb25pemUoKSUyMiUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbHMlM0RnbG9iYWxzKCklMkMlMEElMjAlMjAlMjAlMjBudW1iZXIlM0RudW1faXRlcmF0aW9ucyUwQSk=",highlighted:`num_iterations = <span class="hljs-number">10000</span>
hpu_time = timeit.timeit(
    <span class="hljs-string">&quot;hpu_safe_softmax(input_tensor, dim=1); ht.hpu.synchronize()&quot;</span>,
    <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>(),
    number=num_iterations
)
native_time = timeit.timeit(
    <span class="hljs-string">&quot;native_safe_softmax(input_tensor, dim=1); ht.hpu.synchronize()&quot;</span>,
    <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>(),
    number=num_iterations
)`,wrap:!1}}),V=new d({props:{title:"6. Printing the Results",local:"6-printing-the-results",headingTag:"h3"}}),R=new F({props:{code:"cHJpbnQoZiUyMlBlcmZvcm1hbmNlJTIwY29tcGFyaXNvbiUyMG92ZXIlMjAlN0JudW1faXRlcmF0aW9ucyU3RCUyMGl0ZXJhdGlvbnMlM0ElMjIpJTBBcHJpbnQoZiUyMk5hdGl2ZSUyMHNhZmVfc29mdG1heCUzQSUyMCU3Qm5hdGl2ZV90aW1lJTNBLjZmJTdEJTIwc2Vjb25kcyUyMiklMEFwcmludChmJTIySFBVJTIwc2FmZV9zb2Z0bWF4JTNBJTIwJTdCaHB1X3RpbWUlM0EuNmYlN0QlMjBzZWNvbmRzJTIyKQ==",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Performance comparison over <span class="hljs-subst">{num_iterations}</span> iterations:&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Native safe_softmax: <span class="hljs-subst">{native_time:<span class="hljs-number">.6</span>f}</span> seconds&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;HPU safe_softmax: <span class="hljs-subst">{hpu_time:<span class="hljs-number">.6</span>f}</span> seconds&quot;</span>)`,wrap:!1}}),Q=new d({props:{title:"Example Output",local:"example-output",headingTag:"h2"}}),q=new F({props:{code:"UGVyZm9ybWFuY2UlMjBjb21wYXJpc29uJTIwb3ZlciUyMDEwMDAwJTIwaXRlcmF0aW9ucyUzQSUwQU5hdGl2ZSUyMHNhZmVfc29mdG1heCUzQSUyMDEuMDA0MDU3JTIwc2Vjb25kcyUwQUhQVSUyMHNhZmVfc29mdG1heCUzQSUyMDAuMTA0MDA0JTIwc2Vjb25kcw==",highlighted:`<span class="hljs-attribute">Performance</span> comparison over <span class="hljs-number">10000</span> iterations:
<span class="hljs-attribute">Native</span> safe_softmax: <span class="hljs-number">1</span>.<span class="hljs-number">004057</span> seconds
<span class="hljs-attribute">HPU</span> safe_softmax: <span class="hljs-number">0</span>.<span class="hljs-number">104004</span> seconds`,wrap:!1}}),A=new yt({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/usage_guides/safe_softmax.mdx"}}),{c(){$=l("meta"),K=n(),Y=l("p"),O=n(),p(b.$$.fragment),ee=n(),g=l("p"),g.innerHTML=Ke,te=n(),se=l("hr"),ie=n(),p(y.$$.fragment),ne=n(),M=l("p"),M.innerHTML=Oe,ae=n(),le=l("hr"),me=n(),p(w.$$.fragment),pe=n(),T=l("p"),T.innerHTML=et,oe=n(),x=l("p"),x.innerHTML=tt,re=n(),p(U.$$.fragment),fe=n(),_=l("ul"),_.innerHTML=st,he=n(),ue=l("hr"),ce=n(),p(v.$$.fragment),de=n(),p(j.$$.fragment),$e=n(),p(H.$$.fragment),be=n(),J=l("ul"),J.innerHTML=it,ge=n(),ye=l("hr"),Me=n(),p(C.$$.fragment),we=n(),p(k.$$.fragment),Te=n(),z=l("ul"),z.innerHTML=nt,xe=n(),Ue=l("hr"),_e=n(),p(I.$$.fragment),ve=n(),p(Z.$$.fragment),je=n(),W=l("ul"),W.innerHTML=at,He=n(),Je=l("hr"),Ce=n(),p(G.$$.fragment),ke=n(),p(P.$$.fragment),ze=n(),N=l("ul"),N.innerHTML=lt,Ie=n(),Ze=l("hr"),We=n(),p(L.$$.fragment),Ge=n(),p(E.$$.fragment),Pe=n(),B=l("ul"),B.innerHTML=mt,Ne=n(),Le=l("hr"),Ee=n(),p(V.$$.fragment),Be=n(),p(R.$$.fragment),Ve=n(),X=l("ul"),X.innerHTML=pt,Re=n(),Xe=l("hr"),Qe=n(),p(Q.$$.fragment),Se=n(),S=l("p"),S.textContent=ot,qe=n(),p(q.$$.fragment),Ae=n(),p(A.$$.fragment),Fe=n(),D=l("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);$=m(t,"META",{name:!0,content:!0}),t.forEach(s),K=a(e),Y=m(e,"P",{}),rt(Y).forEach(s),O=a(e),o(b.$$.fragment,e),ee=a(e),g=m(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-qkhhtt"&&(g.innerHTML=Ke),te=a(e),se=m(e,"HR",{}),ie=a(e),o(y.$$.fragment,e),ne=a(e),M=m(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-1d70kfu"&&(M.innerHTML=Oe),ae=a(e),le=m(e,"HR",{}),me=a(e),o(w.$$.fragment,e),pe=a(e),T=m(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-sy3qnf"&&(T.innerHTML=et),oe=a(e),x=m(e,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1ja0ojh"&&(x.innerHTML=tt),re=a(e),o(U.$$.fragment,e),fe=a(e),_=m(e,"UL",{"data-svelte-h":!0}),c(_)!=="svelte-1m1cn17"&&(_.innerHTML=st),he=a(e),ue=m(e,"HR",{}),ce=a(e),o(v.$$.fragment,e),de=a(e),o(j.$$.fragment,e),$e=a(e),o(H.$$.fragment,e),be=a(e),J=m(e,"UL",{"data-svelte-h":!0}),c(J)!=="svelte-ycc5xw"&&(J.innerHTML=it),ge=a(e),ye=m(e,"HR",{}),Me=a(e),o(C.$$.fragment,e),we=a(e),o(k.$$.fragment,e),Te=a(e),z=m(e,"UL",{"data-svelte-h":!0}),c(z)!=="svelte-1vmnn5g"&&(z.innerHTML=nt),xe=a(e),Ue=m(e,"HR",{}),_e=a(e),o(I.$$.fragment,e),ve=a(e),o(Z.$$.fragment,e),je=a(e),W=m(e,"UL",{"data-svelte-h":!0}),c(W)!=="svelte-1dm3d7p"&&(W.innerHTML=at),He=a(e),Je=m(e,"HR",{}),Ce=a(e),o(G.$$.fragment,e),ke=a(e),o(P.$$.fragment,e),ze=a(e),N=m(e,"UL",{"data-svelte-h":!0}),c(N)!=="svelte-iqiv15"&&(N.innerHTML=lt),Ie=a(e),Ze=m(e,"HR",{}),We=a(e),o(L.$$.fragment,e),Ge=a(e),o(E.$$.fragment,e),Pe=a(e),B=m(e,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-fhgher"&&(B.innerHTML=mt),Ne=a(e),Le=m(e,"HR",{}),Ee=a(e),o(V.$$.fragment,e),Be=a(e),o(R.$$.fragment,e),Ve=a(e),X=m(e,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-1ebbosp"&&(X.innerHTML=pt),Re=a(e),Xe=m(e,"HR",{}),Qe=a(e),o(Q.$$.fragment,e),Se=a(e),S=m(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-16gysxd"&&(S.textContent=ot),qe=a(e),o(q.$$.fragment,e),Ae=a(e),o(A.$$.fragment,e),Fe=a(e),D=m(e,"P",{}),rt(D).forEach(s),this.h()},h(){ft($,"name","hf:doc:metadata"),ft($,"content",wt)},m(e,t){gt(document.head,$),i(e,K,t),i(e,Y,t),i(e,O,t),r(b,e,t),i(e,ee,t),i(e,g,t),i(e,te,t),i(e,se,t),i(e,ie,t),r(y,e,t),i(e,ne,t),i(e,M,t),i(e,ae,t),i(e,le,t),i(e,me,t),r(w,e,t),i(e,pe,t),i(e,T,t),i(e,oe,t),i(e,x,t),i(e,re,t),r(U,e,t),i(e,fe,t),i(e,_,t),i(e,he,t),i(e,ue,t),i(e,ce,t),r(v,e,t),i(e,de,t),r(j,e,t),i(e,$e,t),r(H,e,t),i(e,be,t),i(e,J,t),i(e,ge,t),i(e,ye,t),i(e,Me,t),r(C,e,t),i(e,we,t),r(k,e,t),i(e,Te,t),i(e,z,t),i(e,xe,t),i(e,Ue,t),i(e,_e,t),r(I,e,t),i(e,ve,t),r(Z,e,t),i(e,je,t),i(e,W,t),i(e,He,t),i(e,Je,t),i(e,Ce,t),r(G,e,t),i(e,ke,t),r(P,e,t),i(e,ze,t),i(e,N,t),i(e,Ie,t),i(e,Ze,t),i(e,We,t),r(L,e,t),i(e,Ge,t),r(E,e,t),i(e,Pe,t),i(e,B,t),i(e,Ne,t),i(e,Le,t),i(e,Ee,t),r(V,e,t),i(e,Be,t),r(R,e,t),i(e,Ve,t),i(e,X,t),i(e,Re,t),i(e,Xe,t),i(e,Qe,t),r(Q,e,t),i(e,Se,t),i(e,S,t),i(e,qe,t),r(q,e,t),i(e,Ae,t),r(A,e,t),i(e,Fe,t),i(e,D,t),Ye=!0},p:ut,i(e){Ye||(f(b.$$.fragment,e),f(y.$$.fragment,e),f(w.$$.fragment,e),f(U.$$.fragment,e),f(v.$$.fragment,e),f(j.$$.fragment,e),f(H.$$.fragment,e),f(C.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(Z.$$.fragment,e),f(G.$$.fragment,e),f(P.$$.fragment,e),f(L.$$.fragment,e),f(E.$$.fragment,e),f(V.$$.fragment,e),f(R.$$.fragment,e),f(Q.$$.fragment,e),f(q.$$.fragment,e),f(A.$$.fragment,e),Ye=!0)},o(e){h(b.$$.fragment,e),h(y.$$.fragment,e),h(w.$$.fragment,e),h(U.$$.fragment,e),h(v.$$.fragment,e),h(j.$$.fragment,e),h(H.$$.fragment,e),h(C.$$.fragment,e),h(k.$$.fragment,e),h(I.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h(P.$$.fragment,e),h(L.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(A.$$.fragment,e),Ye=!1},d(e){e&&(s(K),s(Y),s(O),s(ee),s(g),s(te),s(se),s(ie),s(ne),s(M),s(ae),s(le),s(me),s(pe),s(T),s(oe),s(x),s(re),s(fe),s(_),s(he),s(ue),s(ce),s(de),s($e),s(be),s(J),s(ge),s(ye),s(Me),s(we),s(Te),s(z),s(xe),s(Ue),s(_e),s(ve),s(je),s(W),s(He),s(Je),s(Ce),s(ke),s(ze),s(N),s(Ie),s(Ze),s(We),s(Ge),s(Pe),s(B),s(Ne),s(Le),s(Ee),s(Be),s(Ve),s(X),s(Re),s(Xe),s(Qe),s(Se),s(S),s(qe),s(Ae),s(Fe),s(D)),s($),u(b,e),u(y,e),u(w,e),u(U,e),u(v,e),u(j,e),u(H,e),u(C,e),u(k,e),u(I,e),u(Z,e),u(G,e),u(P,e),u(L,e),u(E,e),u(V,e),u(R,e),u(Q,e),u(q,e),u(A,e)}}}const wt='{"title":"Comparing HPU-Optimized safe_softmax with Native PyTorch safe_softmax","local":"comparing-hpu-optimized-safesoftmax-with-native-pytorch-safesoftmax","sections":[{"title":"Important Note: No Special Setup Required","local":"important-note-no-special-setup-required","sections":[],"depth":2},{"title":"What is safe_softmax ?","local":"what-is-safesoftmax-","sections":[{"title":"Why is safe_softmax important?","local":"why-is-safesoftmax-important","sections":[],"depth":3}],"depth":2},{"title":"Step-by-Step Explanation of the Code","local":"step-by-step-explanation-of-the-code","sections":[{"title":"1. Importing Required Libraries","local":"1-importing-required-libraries","sections":[],"depth":3},{"title":"2. Defining the HPU-Optimized safe_softmax","local":"2-defining-the-hpu-optimized-safesoftmax","sections":[],"depth":3},{"title":"3. Preparing the Input Tensor","local":"3-preparing-the-input-tensor","sections":[],"depth":3},{"title":"4. Warmup for Fair Benchmarking","local":"4-warmup-for-fair-benchmarking","sections":[],"depth":3},{"title":"5. Benchmarking the Implementations","local":"5-benchmarking-the-implementations","sections":[],"depth":3},{"title":"6. Printing the Results","local":"6-printing-the-results","sections":[],"depth":3}],"depth":2},{"title":"Example Output","local":"example-output","sections":[],"depth":2}],"depth":1}';function Tt(De){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends dt{constructor($){super(),$t(this,$,Tt,Mt,ht,{})}}export{jt as component};
