import{s as tn,o as on,n as rn}from"../chunks/scheduler.7da89386.js";import{S as ln,i as sn,g as r,s as t,r as p,m as an,A as mn,h as l,f as n,c as o,j as v,u as d,x as f,n as nn,k as y,y as a,a as s,v as c,d as g,t as u,w as _}from"../chunks/index.0b7befd3.js";import{T as en}from"../chunks/Tip.1e71740f.js";import{D as T}from"../chunks/Docstring.ce44ea0d.js";import{C as pn}from"../chunks/CodeBlock.c5b6371f.js";import{H as Ae,E as dn}from"../chunks/getInferenceSnippets.4d490e77.js";function cn(ce){let h,w='The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> class is optimized for 🤗 Transformers models running on Intel Gaudi.';return{c(){h=r("p"),h.innerHTML=w},l(x){h=l(x,"P",{"data-svelte-h":!0}),f(h)!=="svelte-1stpso7"&&(h.innerHTML=w)},m(x,ge){s(x,h,ge)},p:rn,d(x){x&&n(h)}}}function gn(ce){let h;return{c(){h=an(`If your predictions or labels have different sequence lengths (for instance because you're doing dynamic
padding in a token classification task) the predictions will be padded (on the right) to allow for
concatenation into one array. The padding index is -100.`)},l(w){h=nn(w,`If your predictions or labels have different sequence lengths (for instance because you're doing dynamic
padding in a token classification task) the predictions will be padded (on the right) to allow for
concatenation into one array. The padding index is -100.`)},m(w,x){s(w,h,x)},d(w){w&&n(h)}}}function un(ce){let h,w,x,ge,z,Ce,L,Ia='The <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> class provides an extended API for the feature-complete <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Transformers Trainer</a>. It is used in all the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">example scripts</a>.',Je,D,Aa='Before instantiating your <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a>, create a <a href="/docs/optimum.habana/main/en/package_reference/trainer#optimum.habana.GaudiTrainingArguments">GaudiTrainingArguments</a> object to access all the points of customization during training.',He,S,je,P,Ca='Here is an example of how to customize <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> to use a weighted loss (useful when you have an unbalanced training set):',ze,E,Le,R,Ja='Another way to customize the training loop behavior for the PyTorch <a href="https://huggingface.co/docs/optimum/habana/package_reference/trainer#optimum.habana.GaudiTrainer" rel="nofollow"><code>GaudiTrainer</code></a> is to use <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">callbacks</a> that can inspect the training loop state (for progress reporting, logging on TensorBoard or other ML platforms…) and take decisions (like early stopping).',De,W,Pe,m,B,ra,ue,Ha=`GaudiTrainer is built on top of the tranformers’ Trainer to enable
deployment on Habana’s Gaudi.`,la,k,V,sa,_e,ja='From <a href="https://github.com/huggingface/transformers/blob/v4.38.2/src/transformers/trainer.py#L3162" rel="nofollow">https://github.com/huggingface/transformers/blob/v4.38.2/src/transformers/trainer.py#L3162</a> with the following modification',ma,he,za="<li>use throughput_warmup_steps in evaluation throughput calculation</li>",pa,q,Z,da,be,La=`Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.
Works both with or without labels.`,ca,F,X,ga,fe,Da='From <a href="https://github.com/huggingface/transformers/blob/v4.45.2/src/transformers/trainer.py#L3904" rel="nofollow">https://github.com/huggingface/transformers/blob/v4.45.2/src/transformers/trainer.py#L3904</a> with the following modification',ua,ve,Pa="<li>comment out TPU related</li> <li>use throughput_warmup_steps in evaluation throughput calculation</li>",_a,I,Y,ha,ye,Ea=`Perform an evaluation step on <code>model</code> using <code>inputs</code>.
Subclass and override to inject custom behavior.`,ba,A,Q,fa,Te,Ra=`Will save the model, so you can reload it using <code>from_pretrained()</code>.
Will only save from the main process.`,va,C,K,ya,we,Wa="Main training entry point.",Ta,M,ee,wa,xe,Ba="Perform a training step on a batch of inputs.",xa,Ne,Va="Subclass and override to inject custom behavior.",Ee,ae,Re,N,ne,Na,J,te,Oa,Oe,Za=`Run evaluation and returns metrics.
The calling script will be responsible for providing a method to compute metrics, as they are task-dependent
(pass it to the init <code>compute_metrics</code> argument).
You can also subclass and override this method to inject custom behavior.`,$a,O,oe,ka,$e,Xa=`Run prediction and returns predictions and potential metrics.
Depending on the dataset and your use case, your test dataset may contain labels. In that case, this method
will also return metrics, like in <code>evaluate()</code>.`,Fa,H,Ma,We,ie,Be,G,re,Ga,ke,Ya=`GaudiTrainingArguments is built on top of the Tranformers’ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>
to enable deployment on Habana’s Gaudi.`,Ve,le,Ze,$,se,Ua,Fe,Qa=`GaudiSeq2SeqTrainingArguments is built on top of the Tranformers’ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">Seq2SeqTrainingArguments</a>
to enable deployment on Habana’s Gaudi.`,Sa,j,me,qa,Me,Ka=`Serializes this instance while replace <code>Enum</code> by their values and <code>GaudiGenerationConfig</code> by dictionaries (for JSON
serialization support). It obfuscates the token values by removing their value.`,Xe,pe,Ye,Ie,Qe;return z=new Ae({props:{title:"GaudiTrainer",local:"gauditrainer",headingTag:"h1"}}),S=new en({props:{warning:!0,$$slots:{default:[cn]},$$scope:{ctx:ce}}}),E=new pn({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMEElMEElMEFjbGFzcyUyMEN1c3RvbUdhdWRpVHJhaW5lcihHYXVkaVRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwaW5wdXRzLmdldCglMjJsYWJlbHMlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5nZXQoJTIybG9naXRzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBjdXN0b20lMjBsb3NzJTIwKHN1cHBvc2UlMjBvbmUlMjBoYXMlMjAzJTIwbGFiZWxzJTIwd2l0aCUyMGRpZmZlcmVudCUyMHdlaWdodHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zc19mY3QlMjAlM0QlMjBubi5Dcm9zc0VudHJvcHlMb3NzKHdlaWdodCUzRHRvcmNoLnRlbnNvciglNUIxLjAlMkMlMjAyLjAlMkMlMjAzLjAlNUQpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2ZjdChsb2dpdHMudmlldygtMSUyQyUyMHNlbGYubW9kZWwuY29uZmlnLm51bV9sYWJlbHMpJTJDJTIwbGFiZWxzLnZpZXcoLTEpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMChsb3NzJTJDJTIwb3V0cHV0cyklMjBpZiUyMHJldHVybl9vdXRwdXRzJTIwZWxzZSUyMGxvc3M=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> optimum.habana <span class="hljs-keyword">import</span> GaudiTrainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomGaudiTrainer</span>(<span class="hljs-title class_ inherited__">GaudiTrainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.get(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>]))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),W=new Ae({props:{title:"GaudiTrainer",local:"optimum.habana.GaudiTrainer",headingTag:"h2"}}),B=new T({props:{name:"class optimum.habana.GaudiTrainer",anchor:"optimum.habana.GaudiTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, NoneType] = None"},{name:"gaudi_config",val:": GaudiConfig = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"train_dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, torch.utils.data.dataset.IterableDataset, ForwardRef('datasets.Dataset'), NoneType] = None"},{name:"eval_dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, dict[str, torch.utils.data.dataset.Dataset], ForwardRef('datasets.Dataset'), NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"compute_loss_func",val:": typing.Optional[typing.Callable] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalPrediction], dict]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"optimizer_cls_and_kwargs",val:": typing.Optional[tuple[type[torch.optim.optimizer.Optimizer], dict[str, typing.Any]]] = None"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L215"}}),V=new T({props:{name:"evaluate",anchor:"optimum.habana.GaudiTrainer.evaluate",parameters:[{name:"eval_dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, dict[str, torch.utils.data.dataset.Dataset], NoneType] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L1858"}}),Z=new T({props:{name:"evaluation_loop",anchor:"optimum.habana.GaudiTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L1979"}}),X=new T({props:{name:"predict",anchor:"optimum.habana.GaudiTrainer.predict",parameters:[{name:"test_dataset",val:": Dataset"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'test'"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L1934"}}),Y=new T({props:{name:"prediction_step",anchor:"optimum.habana.GaudiTrainer.prediction_step",parameters:[{name:"model",val:": Module"},{name:"inputs",val:": dict"},{name:"prediction_loss_only",val:": bool"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.prediction_step.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to evaluate.`,name:"model"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.inputs",description:`<strong>inputs</strong> (<code>dict[str, Union[torch.Tensor, Any]]</code>) &#x2014;
The inputs and targets of the model.
The dictionary will be unpacked before being fed to the model. Most models expect the targets under the
argument <code>labels</code>. Check your model&#x2019;s documentation for all accepted arguments.`,name:"inputs"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.prediction_loss_only",description:`<strong>prediction_loss_only</strong> (<code>bool</code>) &#x2014;
Whether or not to return the loss only.`,name:"prediction_loss_only"},{anchor:"optimum.habana.GaudiTrainer.prediction_step.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L2246",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple with the loss,
logits and labels (each being optional).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>tuple[Optional[torch.Tensor], Optional[torch.Tensor], Optional[torch.Tensor]]</p>
`}}),Q=new T({props:{name:"save_model",anchor:"optimum.habana.GaudiTrainer.save_model",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"_internal_call",val:": bool = False"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L1761"}}),K=new T({props:{name:"train",anchor:"optimum.habana.GaudiTrainer.train",parameters:[{name:"resume_from_checkpoint",val:": typing.Union[str, bool, NoneType] = None"},{name:"trial",val:": typing.Union[ForwardRef('optuna.Trial'), dict[str, typing.Any], NoneType] = None"},{name:"ignore_keys_for_eval",val:": typing.Optional[list[str]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.train.resume_from_checkpoint",description:`<strong>resume_from_checkpoint</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
If a <code>str</code>, local path to a saved checkpoint as saved by a previous instance of <code>Trainer</code>. If a
<code>bool</code> and equals <code>True</code>, load the last checkpoint in <em>args.output_dir</em> as saved by a previous instance
of <code>Trainer</code>. If present, training will resume from the model/optimizer/scheduler states loaded here.`,name:"resume_from_checkpoint"},{anchor:"optimum.habana.GaudiTrainer.train.trial",description:`<strong>trial</strong> (<code>optuna.Trial</code> or <code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
The trial run or the hyperparameter dictionary for hyperparameter search.`,name:"trial"},{anchor:"optimum.habana.GaudiTrainer.train.ignore_keys_for_eval",description:`<strong>ignore_keys_for_eval</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions for evaluation during the training.`,name:"ignore_keys_for_eval"},{anchor:"optimum.habana.GaudiTrainer.train.kwargs",description:`<strong>kwargs</strong> (<code>dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments used to hide deprecated arguments`,name:"kwargs"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L518"}}),ee=new T({props:{name:"training_step",anchor:"optimum.habana.GaudiTrainer.training_step",parameters:[{name:"model",val:": Module"},{name:"inputs",val:": dict"},{name:"num_items_in_batch",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainer.training_step.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to train.`,name:"model"},{anchor:"optimum.habana.GaudiTrainer.training_step.inputs",description:`<strong>inputs</strong> (<code>dict[str, Union[torch.Tensor, Any]]</code>) &#x2014;
The inputs and targets of the model.</p>
<p>The dictionary will be unpacked before being fed to the model. Most models expect the targets under the
argument <code>labels</code>. Check your model&#x2019;s documentation for all accepted arguments.`,name:"inputs"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer.py#L1681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tensor with training loss on this batch.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ae=new Ae({props:{title:"GaudiSeq2SeqTrainer",local:"optimum.habana.GaudiSeq2SeqTrainer",headingTag:"h2"}}),ne=new T({props:{name:"class optimum.habana.GaudiSeq2SeqTrainer",anchor:"optimum.habana.GaudiSeq2SeqTrainer",parameters:[{name:"model",val:": typing.Union[ForwardRef('PreTrainedModel'), torch.nn.modules.module.Module] = None"},{name:"gaudi_config",val:": GaudiConfig = None"},{name:"args",val:": GaudiTrainingArguments = None"},{name:"data_collator",val:": typing.Optional[ForwardRef('DataCollator')] = None"},{name:"train_dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, ForwardRef('IterableDataset'), ForwardRef('datasets.Dataset'), NoneType] = None"},{name:"eval_dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, dict[str, torch.utils.data.dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[ForwardRef('PreTrainedTokenizerBase'), ForwardRef('BaseImageProcessor'), ForwardRef('FeatureExtractionMixin'), ForwardRef('ProcessorMixin'), NoneType] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], ForwardRef('PreTrainedModel')]] = None"},{name:"compute_loss_func",val:": typing.Optional[typing.Callable] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[ForwardRef('EvalPrediction')], dict]] = None"},{name:"callbacks",val:": typing.Optional[list['TrainerCallback']] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer_seq2seq.py#L57"}}),te=new T({props:{name:"evaluate",anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate",parameters:[{name:"eval_dataset",val:": typing.Optional[torch.utils.data.dataset.Dataset] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"},{name:"**gen_kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.eval_dataset",description:`<strong>eval_dataset</strong> (<code>Dataset</code>, <em>optional</em>) &#x2014;
Pass a dataset if you wish to override <code>self.eval_dataset</code>. If it is an <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns
not accepted by the <code>model.forward()</code> method are automatically removed. It must implement the <code>__len__</code>
method.`,name:"eval_dataset"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.metric_key_prefix",description:`<strong>metric_key_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;eval&quot;</code>) &#x2014;
An optional prefix to be used as the metrics key prefix. For example the metrics &#x201C;bleu&#x201D; will be named
&#x201C;eval_bleu&#x201D; if the prefix is <code>&quot;eval&quot;</code> (default)`,name:"metric_key_prefix"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum target length to use when predicting with the generate method.`,name:"max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams for beam search that will be used when predicting with the generate method. 1 means no
beam search.`,name:"num_beams"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.evaluate.gen_kwargs",description:`<strong>gen_kwargs</strong> &#x2014;
Additional <code>generate</code> specific kwargs.`,name:"gen_kwargs"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer_seq2seq.py#L143",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the evaluation loss and the potential metrics computed from the predictions. The
dictionary also contains the epoch number which comes from the training state.</p>
`}}),oe=new T({props:{name:"predict",anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict",parameters:[{name:"test_dataset",val:": Dataset"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'test'"},{name:"**gen_kwargs",val:""}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.test_dataset",description:`<strong>test_dataset</strong> (<code>Dataset</code>) &#x2014;
Dataset to run the predictions on. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted by the
<code>model.forward()</code> method are automatically removed. Has to implement the method <code>__len__</code>`,name:"test_dataset"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.ignore_keys",description:`<strong>ignore_keys</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
A list of keys in the output of your model (if it is a dictionary) that should be ignored when
gathering predictions.`,name:"ignore_keys"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.metric_key_prefix",description:`<strong>metric_key_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;eval&quot;</code>) &#x2014;
An optional prefix to be used as the metrics key prefix. For example the metrics &#x201C;bleu&#x201D; will be named
&#x201C;eval_bleu&#x201D; if the prefix is <code>&quot;eval&quot;</code> (default)`,name:"metric_key_prefix"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum target length to use when predicting with the generate method.`,name:"max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams for beam search that will be used when predicting with the generate method. 1 means no
beam search.`,name:"num_beams"},{anchor:"optimum.habana.GaudiSeq2SeqTrainer.predict.gen_kwargs",description:`<strong>gen_kwargs</strong> &#x2014;
Additional <code>generate</code> specific kwargs.`,name:"gen_kwargs"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/trainer_seq2seq.py#L195"}}),H=new en({props:{$$slots:{default:[gn]},$$scope:{ctx:ce}}}),ie=new Ae({props:{title:"GaudiTrainingArguments",local:"optimum.habana.GaudiTrainingArguments",headingTag:"h2"}}),re=new T({props:{name:"class optimum.habana.GaudiTrainingArguments",anchor:"optimum.habana.GaudiTrainingArguments",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": typing.Optional[float] = 1e-06"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict[str, typing.Any], str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": str = 'passive'"},{name:"log_level_replica",val:": str = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": typing.Optional[bool] = False"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'hpu_amp'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, list[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[list[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[list[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict[str, typing.Any], str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str, NoneType] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = False"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = 230"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"hub_revision",val:": typing.Optional[str] = None"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict[str, typing.Any], str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": list = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": int = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"liger_kernel_config",val:": typing.Optional[dict[str, bool]] = None"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = True"},{name:"use_habana",val:": typing.Optional[bool] = False"},{name:"gaudi_config_name",val:": typing.Optional[str] = None"},{name:"use_lazy_mode",val:": typing.Optional[bool] = True"},{name:"use_hpu_graphs",val:": typing.Optional[bool] = False"},{name:"use_hpu_graphs_for_inference",val:": typing.Optional[bool] = False"},{name:"use_hpu_graphs_for_training",val:": typing.Optional[bool] = False"},{name:"use_compiled_autograd",val:": typing.Optional[bool] = False"},{name:"compile_from_sec_iteration",val:": typing.Optional[bool] = False"},{name:"compile_dynamic",val:": typing.Optional[bool] = None"},{name:"use_zero3_leaf_promotion",val:": typing.Optional[bool] = False"},{name:"cache_size_limit",val:": typing.Optional[int] = None"},{name:"use_regional_compilation",val:": typing.Optional[bool] = False"},{name:"inline_inbuilt_nn_modules",val:": typing.Optional[bool] = None"},{name:"allow_unspec_int_on_nn_module",val:": typing.Optional[bool] = None"},{name:"disable_tensor_cache_hpu_graphs",val:": typing.Optional[bool] = False"},{name:"max_hpu_graphs",val:": typing.Optional[int] = None"},{name:"distribution_strategy",val:": typing.Optional[str] = 'ddp'"},{name:"context_parallel_size",val:": typing.Optional[int] = 1"},{name:"minimize_memory",val:": typing.Optional[bool] = False"},{name:"throughput_warmup_steps",val:": typing.Optional[int] = 0"},{name:"adjust_throughput",val:": bool = False"},{name:"pipelining_fwd_bwd",val:": typing.Optional[bool] = False"},{name:"ignore_eos",val:": typing.Optional[bool] = True"},{name:"non_blocking_data_copy",val:": typing.Optional[bool] = False"},{name:"profiling_warmup_steps",val:": typing.Optional[int] = 0"},{name:"profiling_steps",val:": typing.Optional[int] = 0"},{name:"profiling_warmup_steps_eval",val:": typing.Optional[int] = 0"},{name:"profiling_steps_eval",val:": typing.Optional[int] = 0"},{name:"profiling_record_shapes",val:": typing.Optional[bool] = True"},{name:"profiling_with_stack",val:": typing.Optional[bool] = False"},{name:"attn_implementation",val:": typing.Optional[str] = 'eager'"},{name:"sdp_on_bf16",val:": bool = False"},{name:"fp8",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"optimum.habana.GaudiTrainingArguments.use_habana",description:`<strong>use_habana</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Habana&#x2019;s HPU for running the model.`,name:"use_habana"},{anchor:"optimum.habana.GaudiTrainingArguments.gaudi_config_name",description:`<strong>gaudi_config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pretrained Gaudi config name or path.`,name:"gaudi_config_name"},{anchor:"optimum.habana.GaudiTrainingArguments.use_lazy_mode",description:`<strong>use_lazy_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use lazy mode for running the model.`,name:"use_lazy_mode"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs",description:`<strong>use_hpu_graphs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Deprecated, use <code>use_hpu_graphs_for_inference</code> instead. Whether to use HPU graphs for performing inference.`,name:"use_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs_for_inference",description:`<strong>use_hpu_graphs_for_inference</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use HPU graphs for performing inference. It will speed up latency but may not be compatible with some operations.`,name:"use_hpu_graphs_for_inference"},{anchor:"optimum.habana.GaudiTrainingArguments.use_hpu_graphs_for_training",description:`<strong>use_hpu_graphs_for_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use HPU graphs for performing inference. It will speed up training but may not be compatible with some operations.`,name:"use_hpu_graphs_for_training"},{anchor:"optimum.habana.GaudiTrainingArguments.use_compiled_autograd",description:`<strong>use_compiled_autograd</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use compiled autograd for training. Currently only for summarization models.`,name:"use_compiled_autograd"},{anchor:"optimum.habana.GaudiTrainingArguments.compile_from_sec_iteration",description:`<strong>compile_from_sec_iteration</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to torch.compile from the second training iteration.`,name:"compile_from_sec_iteration"},{anchor:"optimum.habana.GaudiTrainingArguments.compile_dynamic",description:`<strong>compile_dynamic</strong> (<code>bool|None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Set value of &#x2018;dynamic&#x2019; parameter for torch.compile.`,name:"compile_dynamic"},{anchor:"optimum.habana.GaudiTrainingArguments.use_regional_compilation",description:`<strong>use_regional_compilation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use regional compile with deepspeed`,name:"use_regional_compilation"},{anchor:"optimum.habana.GaudiTrainingArguments.inline_inbuilt_nn_modules",description:`<strong>inline_inbuilt_nn_modules</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Set value of &#x2018;inline_inbuilt_nn_modules&#x2019; parameter for torch._dynamo.config. Currently, disabling this parameter improves the performance of the ALBERT model.`,name:"inline_inbuilt_nn_modules"},{anchor:"optimum.habana.GaudiTrainingArguments.cache_size_limit(int,",description:`<strong>cache_size_limit(<code>int</code>,</strong> <em>optional</em>, defaults to &#x2018;None&#x2019;) &#x2014;
Set value of &#x2018;cache_size_limit&#x2019; parameter for torch._dynamo.config`,name:"cache_size_limit(int,"},{anchor:"optimum.habana.GaudiTrainingArguments.allow_unspec_int_on_nn_module",description:`<strong>allow_unspec_int_on_nn_module</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Set value of &#x2018;allow_unspec_int_on_nn_module&#x2019; parameter for torch._dynamo.config.`,name:"allow_unspec_int_on_nn_module"},{anchor:"optimum.habana.GaudiTrainingArguments.disable_tensor_cache_hpu_graphs",description:`<strong>disable_tensor_cache_hpu_graphs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to disable tensor cache when using hpu graphs. If True, tensors won&#x2019;t be cached in hpu graph and memory can be saved.`,name:"disable_tensor_cache_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.max_hpu_graphs",description:`<strong>max_hpu_graphs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of hpu graphs to be cached. Reduce to save device memory.`,name:"max_hpu_graphs"},{anchor:"optimum.habana.GaudiTrainingArguments.distribution_strategy",description:`<strong>distribution_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>ddp</code>) &#x2014;
Determines how data parallel distributed training is achieved. May be: <code>ddp</code> or <code>fast_ddp</code>.`,name:"distribution_strategy"},{anchor:"optimum.habana.GaudiTrainingArguments.throughput_warmup_steps",description:`<strong>throughput_warmup_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of steps to ignore for throughput calculation. For example, with <code>throughput_warmup_steps=N</code>,
the first N steps will not be considered in the calculation of the throughput. This is especially
useful in lazy mode where the first two or three iterations typically take longer.`,name:"throughput_warmup_steps"},{anchor:"optimum.habana.GaudiTrainingArguments.adjust_throughput",description:`<strong>adjust_throughput</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to remove the time taken for logging, evaluating and saving from throughput calculation.`,name:"adjust_throughput"},{anchor:"optimum.habana.GaudiTrainingArguments.pipelining_fwd_bwd",description:`<strong>pipelining_fwd_bwd</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an additional <code>mark_step</code> between forward and backward for pipelining
host backward building and HPU forward computing.`,name:"pipelining_fwd_bwd"},{anchor:"optimum.habana.GaudiTrainingArguments.non_blocking_data_copy",description:`<strong>non_blocking_data_copy</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to enable async data copy when preparing inputs.`,name:"non_blocking_data_copy"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_warmup_steps",description:`<strong>profiling_warmup_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of training steps to ignore for profiling.`,name:"profiling_warmup_steps"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_steps",description:`<strong>profiling_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of training steps to be captured when enabling profiling.`,name:"profiling_steps"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_warmup_steps_eval",description:`<strong>profiling_warmup_steps_eval</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of eval steps to ignore for profiling.`,name:"profiling_warmup_steps_eval"},{anchor:"optimum.habana.GaudiTrainingArguments.profiling_steps_eval",description:`<strong>profiling_steps_eval</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of eval steps to be captured when enabling profiling.`,name:"profiling_steps_eval"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/training_args.py#L87"}}),le=new Ae({props:{title:"GaudiSeq2SeqTrainingArguments",local:"optimum.habana.GaudiSeq2SeqTrainingArguments",headingTag:"h2"}}),se=new T({props:{name:"class optimum.habana.GaudiSeq2SeqTrainingArguments",anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": typing.Optional[float] = 1e-06"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict[str, typing.Any], str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": str = 'passive'"},{name:"log_level_replica",val:": str = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": typing.Optional[bool] = False"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'hpu_amp'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, list[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[list[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[list[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict[str, typing.Any], str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str, NoneType] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = False"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = 230"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"hub_revision",val:": typing.Optional[str] = None"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict[str, typing.Any], str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": list = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": int = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"liger_kernel_config",val:": typing.Optional[dict[str, bool]] = None"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = True"},{name:"use_habana",val:": typing.Optional[bool] = False"},{name:"gaudi_config_name",val:": typing.Optional[str] = None"},{name:"use_lazy_mode",val:": typing.Optional[bool] = True"},{name:"use_hpu_graphs",val:": typing.Optional[bool] = False"},{name:"use_hpu_graphs_for_inference",val:": typing.Optional[bool] = False"},{name:"use_hpu_graphs_for_training",val:": typing.Optional[bool] = False"},{name:"use_compiled_autograd",val:": typing.Optional[bool] = False"},{name:"compile_from_sec_iteration",val:": typing.Optional[bool] = False"},{name:"compile_dynamic",val:": typing.Optional[bool] = None"},{name:"use_zero3_leaf_promotion",val:": typing.Optional[bool] = False"},{name:"cache_size_limit",val:": typing.Optional[int] = None"},{name:"use_regional_compilation",val:": typing.Optional[bool] = False"},{name:"inline_inbuilt_nn_modules",val:": typing.Optional[bool] = None"},{name:"allow_unspec_int_on_nn_module",val:": typing.Optional[bool] = None"},{name:"disable_tensor_cache_hpu_graphs",val:": typing.Optional[bool] = False"},{name:"max_hpu_graphs",val:": typing.Optional[int] = None"},{name:"distribution_strategy",val:": typing.Optional[str] = 'ddp'"},{name:"context_parallel_size",val:": typing.Optional[int] = 1"},{name:"minimize_memory",val:": typing.Optional[bool] = False"},{name:"throughput_warmup_steps",val:": typing.Optional[int] = 0"},{name:"adjust_throughput",val:": bool = False"},{name:"pipelining_fwd_bwd",val:": typing.Optional[bool] = False"},{name:"ignore_eos",val:": typing.Optional[bool] = True"},{name:"non_blocking_data_copy",val:": typing.Optional[bool] = False"},{name:"profiling_warmup_steps",val:": typing.Optional[int] = 0"},{name:"profiling_steps",val:": typing.Optional[int] = 0"},{name:"profiling_warmup_steps_eval",val:": typing.Optional[int] = 0"},{name:"profiling_steps_eval",val:": typing.Optional[int] = 0"},{name:"profiling_record_shapes",val:": typing.Optional[bool] = True"},{name:"profiling_with_stack",val:": typing.Optional[bool] = False"},{name:"attn_implementation",val:": typing.Optional[str] = 'eager'"},{name:"sdp_on_bf16",val:": bool = False"},{name:"fp8",val:": typing.Optional[bool] = False"},{name:"sortish_sampler",val:": bool = False"},{name:"predict_with_generate",val:": bool = False"},{name:"generation_max_length",val:": typing.Optional[int] = None"},{name:"generation_num_beams",val:": typing.Optional[int] = None"},{name:"generation_config",val:": typing.Union[str, pathlib.Path, optimum.habana.transformers.generation.configuration_utils.GaudiGenerationConfig, NoneType] = None"}],parametersDescription:[{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.predict_with_generate",description:`<strong>predict_with_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use generate to calculate generative metrics (ROUGE, BLEU).`,name:"predict_with_generate"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_max_length",description:`<strong>generation_max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The <code>max_length</code> to use on each evaluation loop when <code>predict_with_generate=True</code>. Will default to the
<code>max_length</code> value of the model configuration.`,name:"generation_max_length"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_num_beams",description:`<strong>generation_num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The <code>num_beams</code> to use on each evaluation loop when <code>predict_with_generate=True</code>. Will default to the
<code>num_beams</code> value of the model configuration.`,name:"generation_num_beams"},{anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.generation_config",description:`<strong>generation_config</strong> (<code>str</code> or <code>Path</code> or <code>transformers.generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
Allows to load a <code>transformers.generation.GenerationConfig</code> from the <code>from_pretrained</code> method. This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained" rel="nofollow">transformers.GenerationConfig.save_pretrained</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a <code>transformers.generation.GenerationConfig</code> object.</li>
</ul>`,name:"generation_config"}],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/training_args_seq2seq.py#L30"}}),me=new T({props:{name:"to_dict",anchor:"optimum.habana.GaudiSeq2SeqTrainingArguments.to_dict",parameters:[],source:"https://github.com/huggingface/optimum-habana/blob/main/optimum/habana/transformers/training_args_seq2seq.py#L83"}}),pe=new dn({props:{source:"https://github.com/huggingface/optimum-habana/blob/main/docs/source/package_reference/trainer.mdx"}}),{c(){h=r("meta"),w=t(),x=r("p"),ge=t(),p(z.$$.fragment),Ce=t(),L=r("p"),L.innerHTML=Ia,Je=t(),D=r("p"),D.innerHTML=Aa,He=t(),p(S.$$.fragment),je=t(),P=r("p"),P.innerHTML=Ca,ze=t(),p(E.$$.fragment),Le=t(),R=r("p"),R.innerHTML=Ja,De=t(),p(W.$$.fragment),Pe=t(),m=r("div"),p(B.$$.fragment),ra=t(),ue=r("p"),ue.textContent=Ha,la=t(),k=r("div"),p(V.$$.fragment),sa=t(),_e=r("p"),_e.innerHTML=ja,ma=t(),he=r("ol"),he.innerHTML=za,pa=t(),q=r("div"),p(Z.$$.fragment),da=t(),be=r("p"),be.innerHTML=La,ca=t(),F=r("div"),p(X.$$.fragment),ga=t(),fe=r("p"),fe.innerHTML=Da,ua=t(),ve=r("ol"),ve.innerHTML=Pa,_a=t(),I=r("div"),p(Y.$$.fragment),ha=t(),ye=r("p"),ye.innerHTML=Ea,ba=t(),A=r("div"),p(Q.$$.fragment),fa=t(),Te=r("p"),Te.innerHTML=Ra,va=t(),C=r("div"),p(K.$$.fragment),ya=t(),we=r("p"),we.textContent=Wa,Ta=t(),M=r("div"),p(ee.$$.fragment),wa=t(),xe=r("p"),xe.textContent=Ba,xa=t(),Ne=r("p"),Ne.textContent=Va,Ee=t(),p(ae.$$.fragment),Re=t(),N=r("div"),p(ne.$$.fragment),Na=t(),J=r("div"),p(te.$$.fragment),Oa=t(),Oe=r("p"),Oe.innerHTML=Za,$a=t(),O=r("div"),p(oe.$$.fragment),ka=t(),$e=r("p"),$e.innerHTML=Xa,Fa=t(),p(H.$$.fragment),Ma=an("\nReturns: *NamedTuple* A namedtuple with the following keys:\n- predictions (`np.ndarray`): The predictions on `test_dataset`.\n- label_ids (`np.ndarray`, *optional*): The labels (if the dataset contained some).\n- metrics (`Dict[str, float]`, *optional*): The potential dictionary of metrics (if the dataset contained\n  labels)."),We=t(),p(ie.$$.fragment),Be=t(),G=r("div"),p(re.$$.fragment),Ga=t(),ke=r("p"),ke.innerHTML=Ya,Ve=t(),p(le.$$.fragment),Ze=t(),$=r("div"),p(se.$$.fragment),Ua=t(),Fe=r("p"),Fe.innerHTML=Qa,Sa=t(),j=r("div"),p(me.$$.fragment),qa=t(),Me=r("p"),Me.innerHTML=Ka,Xe=t(),p(pe.$$.fragment),Ye=t(),Ie=r("p"),this.h()},l(e){const i=mn("svelte-u9bgzb",document.head);h=l(i,"META",{name:!0,content:!0}),i.forEach(n),w=o(e),x=l(e,"P",{}),v(x).forEach(n),ge=o(e),d(z.$$.fragment,e),Ce=o(e),L=l(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1vnhui8"&&(L.innerHTML=Ia),Je=o(e),D=l(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-om2fwb"&&(D.innerHTML=Aa),He=o(e),d(S.$$.fragment,e),je=o(e),P=l(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-1jtax1u"&&(P.innerHTML=Ca),ze=o(e),d(E.$$.fragment,e),Le=o(e),R=l(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-lfoibw"&&(R.innerHTML=Ja),De=o(e),d(W.$$.fragment,e),Pe=o(e),m=l(e,"DIV",{class:!0});var b=v(m);d(B.$$.fragment,b),ra=o(b),ue=l(b,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1j23w6z"&&(ue.textContent=Ha),la=o(b),k=l(b,"DIV",{class:!0});var U=v(k);d(V.$$.fragment,U),sa=o(U),_e=l(U,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-vxpl2h"&&(_e.innerHTML=ja),ma=o(U),he=l(U,"OL",{"data-svelte-h":!0}),f(he)!=="svelte-2ian0d"&&(he.innerHTML=za),U.forEach(n),pa=o(b),q=l(b,"DIV",{class:!0});var Ke=v(q);d(Z.$$.fragment,Ke),da=o(Ke),be=l(Ke,"P",{"data-svelte-h":!0}),f(be)!=="svelte-1379lme"&&(be.innerHTML=La),Ke.forEach(n),ca=o(b),F=l(b,"DIV",{class:!0});var Ge=v(F);d(X.$$.fragment,Ge),ga=o(Ge),fe=l(Ge,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1vedoc1"&&(fe.innerHTML=Da),ua=o(Ge),ve=l(Ge,"OL",{"data-svelte-h":!0}),f(ve)!=="svelte-vzrmm3"&&(ve.innerHTML=Pa),Ge.forEach(n),_a=o(b),I=l(b,"DIV",{class:!0});var ea=v(I);d(Y.$$.fragment,ea),ha=o(ea),ye=l(ea,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-qt0zbt"&&(ye.innerHTML=Ea),ea.forEach(n),ba=o(b),A=l(b,"DIV",{class:!0});var aa=v(A);d(Q.$$.fragment,aa),fa=o(aa),Te=l(aa,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-45fu3d"&&(Te.innerHTML=Ra),aa.forEach(n),va=o(b),C=l(b,"DIV",{class:!0});var na=v(C);d(K.$$.fragment,na),ya=o(na),we=l(na,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1cilnet"&&(we.textContent=Wa),na.forEach(n),Ta=o(b),M=l(b,"DIV",{class:!0});var Ue=v(M);d(ee.$$.fragment,Ue),wa=o(Ue),xe=l(Ue,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-4qplkw"&&(xe.textContent=Ba),xa=o(Ue),Ne=l(Ue,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-qjfexy"&&(Ne.textContent=Va),Ue.forEach(n),b.forEach(n),Ee=o(e),d(ae.$$.fragment,e),Re=o(e),N=l(e,"DIV",{class:!0});var Se=v(N);d(ne.$$.fragment,Se),Na=o(Se),J=l(Se,"DIV",{class:!0});var ta=v(J);d(te.$$.fragment,ta),Oa=o(ta),Oe=l(ta,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-1pw2jj7"&&(Oe.innerHTML=Za),ta.forEach(n),$a=o(Se),O=l(Se,"DIV",{class:!0});var de=v(O);d(oe.$$.fragment,de),ka=o(de),$e=l(de,"P",{"data-svelte-h":!0}),f($e)!=="svelte-12trqag"&&($e.innerHTML=Xa),Fa=o(de),d(H.$$.fragment,de),Ma=nn(de,"\nReturns: *NamedTuple* A namedtuple with the following keys:\n- predictions (`np.ndarray`): The predictions on `test_dataset`.\n- label_ids (`np.ndarray`, *optional*): The labels (if the dataset contained some).\n- metrics (`Dict[str, float]`, *optional*): The potential dictionary of metrics (if the dataset contained\n  labels)."),de.forEach(n),Se.forEach(n),We=o(e),d(ie.$$.fragment,e),Be=o(e),G=l(e,"DIV",{class:!0});var oa=v(G);d(re.$$.fragment,oa),Ga=o(oa),ke=l(oa,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1pjgb0w"&&(ke.innerHTML=Ya),oa.forEach(n),Ve=o(e),d(le.$$.fragment,e),Ze=o(e),$=l(e,"DIV",{class:!0});var qe=v($);d(se.$$.fragment,qe),Ua=o(qe),Fe=l(qe,"P",{"data-svelte-h":!0}),f(Fe)!=="svelte-1bpl5s2"&&(Fe.innerHTML=Qa),Sa=o(qe),j=l(qe,"DIV",{class:!0});var ia=v(j);d(me.$$.fragment,ia),qa=o(ia),Me=l(ia,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-1cdlr91"&&(Me.innerHTML=Ka),ia.forEach(n),qe.forEach(n),Xe=o(e),d(pe.$$.fragment,e),Ye=o(e),Ie=l(e,"P",{}),v(Ie).forEach(n),this.h()},h(){y(h,"name","hf:doc:metadata"),y(h,"content",_n),y(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){a(document.head,h),s(e,w,i),s(e,x,i),s(e,ge,i),c(z,e,i),s(e,Ce,i),s(e,L,i),s(e,Je,i),s(e,D,i),s(e,He,i),c(S,e,i),s(e,je,i),s(e,P,i),s(e,ze,i),c(E,e,i),s(e,Le,i),s(e,R,i),s(e,De,i),c(W,e,i),s(e,Pe,i),s(e,m,i),c(B,m,null),a(m,ra),a(m,ue),a(m,la),a(m,k),c(V,k,null),a(k,sa),a(k,_e),a(k,ma),a(k,he),a(m,pa),a(m,q),c(Z,q,null),a(q,da),a(q,be),a(m,ca),a(m,F),c(X,F,null),a(F,ga),a(F,fe),a(F,ua),a(F,ve),a(m,_a),a(m,I),c(Y,I,null),a(I,ha),a(I,ye),a(m,ba),a(m,A),c(Q,A,null),a(A,fa),a(A,Te),a(m,va),a(m,C),c(K,C,null),a(C,ya),a(C,we),a(m,Ta),a(m,M),c(ee,M,null),a(M,wa),a(M,xe),a(M,xa),a(M,Ne),s(e,Ee,i),c(ae,e,i),s(e,Re,i),s(e,N,i),c(ne,N,null),a(N,Na),a(N,J),c(te,J,null),a(J,Oa),a(J,Oe),a(N,$a),a(N,O),c(oe,O,null),a(O,ka),a(O,$e),a(O,Fa),c(H,O,null),a(O,Ma),s(e,We,i),c(ie,e,i),s(e,Be,i),s(e,G,i),c(re,G,null),a(G,Ga),a(G,ke),s(e,Ve,i),c(le,e,i),s(e,Ze,i),s(e,$,i),c(se,$,null),a($,Ua),a($,Fe),a($,Sa),a($,j),c(me,j,null),a(j,qa),a(j,Me),s(e,Xe,i),c(pe,e,i),s(e,Ye,i),s(e,Ie,i),Qe=!0},p(e,[i]){const b={};i&2&&(b.$$scope={dirty:i,ctx:e}),S.$set(b);const U={};i&2&&(U.$$scope={dirty:i,ctx:e}),H.$set(U)},i(e){Qe||(g(z.$$.fragment,e),g(S.$$.fragment,e),g(E.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(V.$$.fragment,e),g(Z.$$.fragment,e),g(X.$$.fragment,e),g(Y.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(ae.$$.fragment,e),g(ne.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(H.$$.fragment,e),g(ie.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(se.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),Qe=!0)},o(e){u(z.$$.fragment,e),u(S.$$.fragment,e),u(E.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(H.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),Qe=!1},d(e){e&&(n(w),n(x),n(ge),n(Ce),n(L),n(Je),n(D),n(He),n(je),n(P),n(ze),n(Le),n(R),n(De),n(Pe),n(m),n(Ee),n(Re),n(N),n(We),n(Be),n(G),n(Ve),n(Ze),n($),n(Xe),n(Ye),n(Ie)),n(h),_(z,e),_(S,e),_(E,e),_(W,e),_(B),_(V),_(Z),_(X),_(Y),_(Q),_(K),_(ee),_(ae,e),_(ne),_(te),_(oe),_(H),_(ie,e),_(re),_(le,e),_(se),_(me),_(pe,e)}}}const _n='{"title":"GaudiTrainer","local":"gauditrainer","sections":[{"title":"GaudiTrainer","local":"optimum.habana.GaudiTrainer","sections":[],"depth":2},{"title":"GaudiSeq2SeqTrainer","local":"optimum.habana.GaudiSeq2SeqTrainer","sections":[],"depth":2},{"title":"GaudiTrainingArguments","local":"optimum.habana.GaudiTrainingArguments","sections":[],"depth":2},{"title":"GaudiSeq2SeqTrainingArguments","local":"optimum.habana.GaudiSeq2SeqTrainingArguments","sections":[],"depth":2}],"depth":1}';function hn(ce){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xn extends ln{constructor(h){super(),sn(this,h,hn,un,tn,{})}}export{xn as component};
