import{s as Ut,n as Zt,o as $t}from"../chunks/scheduler.85c25b89.js";import{S as It,i as Ct,g as p,s as e,r as i,A as xt,h as m,f as l,c as n,j as bt,u as o,x as g,k as ft,y as Bt,a,v as c,d as r,t as M,w as h}from"../chunks/index.c9bcf812.js";import{C as X}from"../chunks/CodeBlock.94efc595.js";import{H as Q}from"../chunks/Heading.3c6e5b17.js";function Wt(rt){let j,A,R,_,J,Y,d,Mt='<strong>Rank Expansion Networks</strong> (ReXNets) follow a set of new design principles for designing bottlenecks in image classification models. Authors refine each layer by 1) expanding the input channel size of the convolution layer and 2) replacing the <a href="https://www.paperswithcode.com/method/relu6" rel="nofollow">ReLU6s</a>.',H,w,z,y,ht="To load a pretrained model:",S,u,F,T,gt="To load and preprocess the image:",L,b,D,f,jt="To get the model predictions:",q,U,P,Z,Jt="To get the top-5 predictions class names:",K,$,O,I,dt="Replace the model name with the variant you want to use, e.g. <code>rexnet_100</code>. You can find the IDs in the model summaries at the top of this page.",tt,C,wt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,x,lt,B,yt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,W,et,k,ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,N,pt,v,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,G,it,E,ot,V,ct;return J=new Q({props:{title:"RexNet",local:"rexnet",headingTag:"h1"}}),w=new Q({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3JleG5ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new Q({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmV4bmV0XzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;rexnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),N=new Q({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new Q({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new X({props:{code:"JTQwbWlzYyU3QmhhbjIwMjByZXhuZXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlJlWE5ldCUzQSUyMERpbWluaXNoaW5nJTIwUmVwcmVzZW50YXRpb25hbCUyMEJvdHRsZW5lY2slMjBvbiUyMENvbnZvbHV0aW9uYWwlMjBOZXVyYWwlMjBOZXR3b3JrJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCRG9uZ3lvb24lMjBIYW4lMjBhbmQlMjBTYW5nZG9vJTIwWXVuJTIwYW5kJTIwQnllb25naG8lMjBIZW8lMjBhbmQlMjBZb3VuZ0pvb24lMjBZb28lN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIwMDcuMDA5OTIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{han2020rexnet,
      title={ReXNet: Diminishing Representational Bottleneck on Convolutional Neural Network}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Dongyoon Han and Sangdoo Yun and Byeongho Heo and YoungJoon Yoo}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2020}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{2007.00992}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){j=p("meta"),A=e(),R=p("p"),_=e(),i(J.$$.fragment),Y=e(),d=p("p"),d.innerHTML=Mt,H=e(),i(w.$$.fragment),z=e(),y=p("p"),y.textContent=ht,S=e(),i(u.$$.fragment),F=e(),T=p("p"),T.textContent=gt,L=e(),i(b.$$.fragment),D=e(),f=p("p"),f.textContent=jt,q=e(),i(U.$$.fragment),P=e(),Z=p("p"),Z.textContent=Jt,K=e(),i($.$$.fragment),O=e(),I=p("p"),I.innerHTML=dt,tt=e(),C=p("p"),C.innerHTML=wt,st=e(),i(x.$$.fragment),lt=e(),B=p("p"),B.textContent=yt,at=e(),i(W.$$.fragment),et=e(),k=p("p"),k.innerHTML=ut,nt=e(),i(N.$$.fragment),pt=e(),v=p("p"),v.innerHTML=Tt,mt=e(),i(G.$$.fragment),it=e(),i(E.$$.fragment),ot=e(),V=p("p"),this.h()},l(t){const s=xt("svelte-u9bgzb",document.head);j=m(s,"META",{name:!0,content:!0}),s.forEach(l),A=n(t),R=m(t,"P",{}),bt(R).forEach(l),_=n(t),o(J.$$.fragment,t),Y=n(t),d=m(t,"P",{"data-svelte-h":!0}),g(d)!=="svelte-1inhb52"&&(d.innerHTML=Mt),H=n(t),o(w.$$.fragment,t),z=n(t),y=m(t,"P",{"data-svelte-h":!0}),g(y)!=="svelte-18ywhxh"&&(y.textContent=ht),S=n(t),o(u.$$.fragment,t),F=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=gt),L=n(t),o(b.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1n9qsq1"&&(f.textContent=jt),q=n(t),o(U.$$.fragment,t),P=n(t),Z=m(t,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-19cnvx1"&&(Z.textContent=Jt),K=n(t),o($.$$.fragment,t),O=n(t),I=m(t,"P",{"data-svelte-h":!0}),g(I)!=="svelte-kmyudm"&&(I.innerHTML=dt),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1wmi3ea"&&(C.innerHTML=wt),st=n(t),o(x.$$.fragment,t),lt=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-9sr7nh"&&(B.textContent=yt),at=n(t),o(W.$$.fragment,t),et=n(t),k=m(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1kguc51"&&(k.innerHTML=ut),nt=n(t),o(N.$$.fragment,t),pt=n(t),v=m(t,"P",{"data-svelte-h":!0}),g(v)!=="svelte-1n0coha"&&(v.innerHTML=Tt),mt=n(t),o(G.$$.fragment,t),it=n(t),o(E.$$.fragment,t),ot=n(t),V=m(t,"P",{}),bt(V).forEach(l),this.h()},h(){ft(j,"name","hf:doc:metadata"),ft(j,"content",kt)},m(t,s){Bt(document.head,j),a(t,A,s),a(t,R,s),a(t,_,s),c(J,t,s),a(t,Y,s),a(t,d,s),a(t,H,s),c(w,t,s),a(t,z,s),a(t,y,s),a(t,S,s),c(u,t,s),a(t,F,s),a(t,T,s),a(t,L,s),c(b,t,s),a(t,D,s),a(t,f,s),a(t,q,s),c(U,t,s),a(t,P,s),a(t,Z,s),a(t,K,s),c($,t,s),a(t,O,s),a(t,I,s),a(t,tt,s),a(t,C,s),a(t,st,s),c(x,t,s),a(t,lt,s),a(t,B,s),a(t,at,s),c(W,t,s),a(t,et,s),a(t,k,s),a(t,nt,s),c(N,t,s),a(t,pt,s),a(t,v,s),a(t,mt,s),c(G,t,s),a(t,it,s),c(E,t,s),a(t,ot,s),a(t,V,s),ct=!0},p:Zt,i(t){ct||(r(J.$$.fragment,t),r(w.$$.fragment,t),r(u.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r($.$$.fragment,t),r(x.$$.fragment,t),r(W.$$.fragment,t),r(N.$$.fragment,t),r(G.$$.fragment,t),r(E.$$.fragment,t),ct=!0)},o(t){M(J.$$.fragment,t),M(w.$$.fragment,t),M(u.$$.fragment,t),M(b.$$.fragment,t),M(U.$$.fragment,t),M($.$$.fragment,t),M(x.$$.fragment,t),M(W.$$.fragment,t),M(N.$$.fragment,t),M(G.$$.fragment,t),M(E.$$.fragment,t),ct=!1},d(t){t&&(l(A),l(R),l(_),l(Y),l(d),l(H),l(z),l(y),l(S),l(F),l(T),l(L),l(D),l(f),l(q),l(P),l(Z),l(K),l(O),l(I),l(tt),l(C),l(st),l(lt),l(B),l(at),l(et),l(k),l(nt),l(pt),l(v),l(mt),l(it),l(ot),l(V)),l(j),h(J,t),h(w,t),h(u,t),h(b,t),h(U,t),h($,t),h(x,t),h(W,t),h(N,t),h(G,t),h(E,t)}}}const kt='{"title":"RexNet","local":"rexnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Nt(rt){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends It{constructor(j){super(),Ct(this,j,Nt,Wt,Ut,{})}}export{Rt as component};
