import{s as Nt,n as xt,o as Gt}from"../chunks/scheduler.85c25b89.js";import{S as It,i as Wt,g as p,s as a,r as m,A as Bt,h as i,f as e,c as n,j as kt,u as o,x as y,k as Zt,y as Et,a as l,v as r,d as h,t as c,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Qt}from"../chunks/getInferenceSnippets.b020ba4f.js";function vt(gt){let g,A,_,H,d,S,j,dt='A <strong>Dual Path Network (DPN)</strong> is a convolutional neural network which presents a new topology of connection paths internally. The intuition is that <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> enables feature re-usage while DenseNet enables new feature exploration, and both are important for learning good representations. To enjoy the benefits from both path topologies, Dual Path Networks share common features while maintaining the flexibility to explore new features through dual path architectures.',z,u,jt='The principal building block is an <a href="https://paperswithcode.com/method/dpn-block" rel="nofollow">DPN Block</a>.',F,w,D,J,ut="To load a pretrained model:",P,f,L,b,wt="To load and preprocess the image:",q,T,K,U,Jt="To get the model predictions:",O,C,tt,$,ft="To get the top-5 predictions class names:",st,k,et,Z,bt="Replace the model name with the variant you want to use, e.g. <code>dpn107</code>. You can find the IDs in the model summaries at the top of this page.",lt,N,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,x,nt,G,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,I,it,W,Ct=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,B,ot,E,$t='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',rt,Q,ht,v,ct,R,Mt,V,yt;return d=new Y({props:{title:"Dual Path Network (DPN)",local:"dual-path-network-dpn",headingTag:"h1"}}),w=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RwbjEwNyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),k=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),x=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),I=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZHBuMTA3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new X({props:{code:"JTQwbWlzYyU3QmNoZW4yMDE3ZHVhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRHVhbCUyMFBhdGglMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qll1bnBlbmclMjBDaGVuJTIwYW5kJTIwSmlhbmFuJTIwTGklMjBhbmQlMjBIdWF4aW4lMjBYaWFvJTIwYW5kJTIwWGlhb2ppZSUyMEppbiUyMGFuZCUyMFNodWljaGVuZyUyMFlhbiUyMGFuZCUyMEppYXNoaSUyMEZlbmclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDE2MjklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{chen2017dual,
      title={Dual Path Networks}, 
      author={Yunpeng Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jianan </span>Li <span class="hljs-keyword">and </span>Huaxin Xiao <span class="hljs-keyword">and </span>Xiaojie <span class="hljs-keyword">Jin </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Shuicheng </span>Yan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiashi </span>Feng},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">01629</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),R=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/dpn.mdx"}}),{c(){g=p("meta"),A=a(),_=p("p"),H=a(),m(d.$$.fragment),S=a(),j=p("p"),j.innerHTML=dt,z=a(),u=p("p"),u.innerHTML=jt,F=a(),m(w.$$.fragment),D=a(),J=p("p"),J.textContent=ut,P=a(),m(f.$$.fragment),L=a(),b=p("p"),b.textContent=wt,q=a(),m(T.$$.fragment),K=a(),U=p("p"),U.textContent=Jt,O=a(),m(C.$$.fragment),tt=a(),$=p("p"),$.textContent=ft,st=a(),m(k.$$.fragment),et=a(),Z=p("p"),Z.innerHTML=bt,lt=a(),N=p("p"),N.innerHTML=Tt,at=a(),m(x.$$.fragment),nt=a(),G=p("p"),G.textContent=Ut,pt=a(),m(I.$$.fragment),it=a(),W=p("p"),W.innerHTML=Ct,mt=a(),m(B.$$.fragment),ot=a(),E=p("p"),E.innerHTML=$t,rt=a(),m(Q.$$.fragment),ht=a(),m(v.$$.fragment),ct=a(),m(R.$$.fragment),Mt=a(),V=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(e),A=n(t),_=i(t,"P",{}),kt(_).forEach(e),H=n(t),o(d.$$.fragment,t),S=n(t),j=i(t,"P",{"data-svelte-h":!0}),y(j)!=="svelte-1vp7kec"&&(j.innerHTML=dt),z=n(t),u=i(t,"P",{"data-svelte-h":!0}),y(u)!=="svelte-34uoom"&&(u.innerHTML=jt),F=n(t),o(w.$$.fragment,t),D=n(t),J=i(t,"P",{"data-svelte-h":!0}),y(J)!=="svelte-18ywhxh"&&(J.textContent=ut),P=n(t),o(f.$$.fragment,t),L=n(t),b=i(t,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1c2ipa8"&&(b.textContent=wt),q=n(t),o(T.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1n9qsq1"&&(U.textContent=Jt),O=n(t),o(C.$$.fragment,t),tt=n(t),$=i(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-19cnvx1"&&($.textContent=ft),st=n(t),o(k.$$.fragment,t),et=n(t),Z=i(t,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1lx1824"&&(Z.innerHTML=bt),lt=n(t),N=i(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1wmi3ea"&&(N.innerHTML=Tt),at=n(t),o(x.$$.fragment,t),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-9sr7nh"&&(G.textContent=Ut),pt=n(t),o(I.$$.fragment,t),it=n(t),W=i(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1kguc51"&&(W.innerHTML=Ct),mt=n(t),o(B.$$.fragment,t),ot=n(t),E=i(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-xtxxu6"&&(E.innerHTML=$t),rt=n(t),o(Q.$$.fragment,t),ht=n(t),o(v.$$.fragment,t),ct=n(t),o(R.$$.fragment,t),Mt=n(t),V=i(t,"P",{}),kt(V).forEach(e),this.h()},h(){Zt(g,"name","hf:doc:metadata"),Zt(g,"content",Rt)},m(t,s){Et(document.head,g),l(t,A,s),l(t,_,s),l(t,H,s),r(d,t,s),l(t,S,s),l(t,j,s),l(t,z,s),l(t,u,s),l(t,F,s),r(w,t,s),l(t,D,s),l(t,J,s),l(t,P,s),r(f,t,s),l(t,L,s),l(t,b,s),l(t,q,s),r(T,t,s),l(t,K,s),l(t,U,s),l(t,O,s),r(C,t,s),l(t,tt,s),l(t,$,s),l(t,st,s),r(k,t,s),l(t,et,s),l(t,Z,s),l(t,lt,s),l(t,N,s),l(t,at,s),r(x,t,s),l(t,nt,s),l(t,G,s),l(t,pt,s),r(I,t,s),l(t,it,s),l(t,W,s),l(t,mt,s),r(B,t,s),l(t,ot,s),l(t,E,s),l(t,rt,s),r(Q,t,s),l(t,ht,s),r(v,t,s),l(t,ct,s),r(R,t,s),l(t,Mt,s),l(t,V,s),yt=!0},p:xt,i(t){yt||(h(d.$$.fragment,t),h(w.$$.fragment,t),h(f.$$.fragment,t),h(T.$$.fragment,t),h(C.$$.fragment,t),h(k.$$.fragment,t),h(x.$$.fragment,t),h(I.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(v.$$.fragment,t),h(R.$$.fragment,t),yt=!0)},o(t){c(d.$$.fragment,t),c(w.$$.fragment,t),c(f.$$.fragment,t),c(T.$$.fragment,t),c(C.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(I.$$.fragment,t),c(B.$$.fragment,t),c(Q.$$.fragment,t),c(v.$$.fragment,t),c(R.$$.fragment,t),yt=!1},d(t){t&&(e(A),e(_),e(H),e(S),e(j),e(z),e(u),e(F),e(D),e(J),e(P),e(L),e(b),e(q),e(K),e(U),e(O),e(tt),e($),e(st),e(et),e(Z),e(lt),e(N),e(at),e(nt),e(G),e(pt),e(it),e(W),e(mt),e(ot),e(E),e(rt),e(ht),e(ct),e(Mt),e(V)),e(g),M(d,t),M(w,t),M(f,t),M(T,t),M(C,t),M(k,t),M(x,t),M(I,t),M(B,t),M(Q,t),M(v,t),M(R,t)}}}const Rt='{"title":"Dual Path Network (DPN)","local":"dual-path-network-dpn","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(gt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends It{constructor(g){super(),Wt(this,g,Xt,vt,Nt,{})}}export{Ht as component};
