import{s as Wt,n as Zt,o as xt}from"../chunks/scheduler.85c25b89.js";import{S as Gt,i as Nt,g as p,s as a,r as i,A as Bt,h as m,f as e,c as n,j as It,u as o,x as y,k as kt,y as Et,a as l,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as X}from"../chunks/CodeBlock.e573519b.js";import{H as S,E as Qt}from"../chunks/getInferenceSnippets.b020ba4f.js";function Vt(gt){let g,Y,v,z,d,F,w,dt='A <strong>SENet</strong> is a convolutional neural network architecture that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',H,J,wt="The weights from this model were ported from Gluon.",A,u,L,j,Jt="To load a pretrained model:",q,T,D,f,ut="To load and preprocess the image:",P,b,K,U,jt="To get the model predictions:",O,$,tt,C,Tt="To get the top-5 predictions class names:",st,I,et,k,ft="Replace the model name with the variant you want to use, e.g. <code>legacy_senet154</code>. You can find the IDs in the model summaries at the top of this page.",lt,W,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,Z,nt,x,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,G,mt,N,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,B,ot,E,Ct='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,Q,rt,V,ht,_,Mt,R,yt;return d=new S({props:{title:"(Legacy) SENet",local:"legacy-senet",headingTag:"h1"}}),u=new S({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new X({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZW5ldDE1NCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_senet154&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new X({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new X({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new X({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new S({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new X({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlbmV0MTU0JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_senet154&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new S({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new S({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new X({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),_=new Qt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/legacy-senet.mdx"}}),{c(){g=p("meta"),Y=a(),v=p("p"),z=a(),i(d.$$.fragment),F=a(),w=p("p"),w.innerHTML=dt,H=a(),J=p("p"),J.textContent=wt,A=a(),i(u.$$.fragment),L=a(),j=p("p"),j.textContent=Jt,q=a(),i(T.$$.fragment),D=a(),f=p("p"),f.textContent=ut,P=a(),i(b.$$.fragment),K=a(),U=p("p"),U.textContent=jt,O=a(),i($.$$.fragment),tt=a(),C=p("p"),C.textContent=Tt,st=a(),i(I.$$.fragment),et=a(),k=p("p"),k.innerHTML=ft,lt=a(),W=p("p"),W.innerHTML=bt,at=a(),i(Z.$$.fragment),nt=a(),x=p("p"),x.textContent=Ut,pt=a(),i(G.$$.fragment),mt=a(),N=p("p"),N.innerHTML=$t,it=a(),i(B.$$.fragment),ot=a(),E=p("p"),E.innerHTML=Ct,ct=a(),i(Q.$$.fragment),rt=a(),i(V.$$.fragment),ht=a(),i(_.$$.fragment),Mt=a(),R=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);g=m(s,"META",{name:!0,content:!0}),s.forEach(e),Y=n(t),v=m(t,"P",{}),It(v).forEach(e),z=n(t),o(d.$$.fragment,t),F=n(t),w=m(t,"P",{"data-svelte-h":!0}),y(w)!=="svelte-71ax7y"&&(w.innerHTML=dt),H=n(t),J=m(t,"P",{"data-svelte-h":!0}),y(J)!=="svelte-1zilmt"&&(J.textContent=wt),A=n(t),o(u.$$.fragment,t),L=n(t),j=m(t,"P",{"data-svelte-h":!0}),y(j)!=="svelte-18ywhxh"&&(j.textContent=Jt),q=n(t),o(T.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),y(f)!=="svelte-1c2ipa8"&&(f.textContent=ut),P=n(t),o(b.$$.fragment,t),K=n(t),U=m(t,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1n9qsq1"&&(U.textContent=jt),O=n(t),o($.$$.fragment,t),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),y(C)!=="svelte-19cnvx1"&&(C.textContent=Tt),st=n(t),o(I.$$.fragment,t),et=n(t),k=m(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-fdf605"&&(k.innerHTML=ft),lt=n(t),W=m(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1wmi3ea"&&(W.innerHTML=bt),at=n(t),o(Z.$$.fragment,t),nt=n(t),x=m(t,"P",{"data-svelte-h":!0}),y(x)!=="svelte-9sr7nh"&&(x.textContent=Ut),pt=n(t),o(G.$$.fragment,t),mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1kguc51"&&(N.innerHTML=$t),it=n(t),o(B.$$.fragment,t),ot=n(t),E=m(t,"P",{"data-svelte-h":!0}),y(E)!=="svelte-xtxxu6"&&(E.innerHTML=Ct),ct=n(t),o(Q.$$.fragment,t),rt=n(t),o(V.$$.fragment,t),ht=n(t),o(_.$$.fragment,t),Mt=n(t),R=m(t,"P",{}),It(R).forEach(e),this.h()},h(){kt(g,"name","hf:doc:metadata"),kt(g,"content",_t)},m(t,s){Et(document.head,g),l(t,Y,s),l(t,v,s),l(t,z,s),c(d,t,s),l(t,F,s),l(t,w,s),l(t,H,s),l(t,J,s),l(t,A,s),c(u,t,s),l(t,L,s),l(t,j,s),l(t,q,s),c(T,t,s),l(t,D,s),l(t,f,s),l(t,P,s),c(b,t,s),l(t,K,s),l(t,U,s),l(t,O,s),c($,t,s),l(t,tt,s),l(t,C,s),l(t,st,s),c(I,t,s),l(t,et,s),l(t,k,s),l(t,lt,s),l(t,W,s),l(t,at,s),c(Z,t,s),l(t,nt,s),l(t,x,s),l(t,pt,s),c(G,t,s),l(t,mt,s),l(t,N,s),l(t,it,s),c(B,t,s),l(t,ot,s),l(t,E,s),l(t,ct,s),c(Q,t,s),l(t,rt,s),c(V,t,s),l(t,ht,s),c(_,t,s),l(t,Mt,s),l(t,R,s),yt=!0},p:Zt,i(t){yt||(r(d.$$.fragment,t),r(u.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(I.$$.fragment,t),r(Z.$$.fragment,t),r(G.$$.fragment,t),r(B.$$.fragment,t),r(Q.$$.fragment,t),r(V.$$.fragment,t),r(_.$$.fragment,t),yt=!0)},o(t){h(d.$$.fragment,t),h(u.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(G.$$.fragment,t),h(B.$$.fragment,t),h(Q.$$.fragment,t),h(V.$$.fragment,t),h(_.$$.fragment,t),yt=!1},d(t){t&&(e(Y),e(v),e(z),e(F),e(w),e(H),e(J),e(A),e(L),e(j),e(q),e(D),e(f),e(P),e(K),e(U),e(O),e(tt),e(C),e(st),e(et),e(k),e(lt),e(W),e(at),e(nt),e(x),e(pt),e(mt),e(N),e(it),e(ot),e(E),e(ct),e(rt),e(ht),e(Mt),e(R)),e(g),M(d,t),M(u,t),M(T,t),M(b,t),M($,t),M(I,t),M(Z,t),M(G,t),M(B,t),M(Q,t),M(V,t),M(_,t)}}}const _t='{"title":"(Legacy) SENet","local":"legacy-senet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Xt(gt){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Gt{constructor(g){super(),Nt(this,g,Xt,Vt,Wt,{})}}export{zt as component};
