import{s as Il,n as Al,o as Zl}from"../chunks/scheduler.85c25b89.js";import{S as kl,i as Bl,g as M,s as e,r as m,A as $l,h as p,f as t,c as n,j as Cl,u as i,x as r,k as fl,y as Nl,a,v as o,d as j,t as y,w as c}from"../chunks/index.c9837788.js";import{C as v}from"../chunks/CodeBlock.e573519b.js";import{H as V,E as Wl}from"../chunks/getInferenceSnippets.b020ba4f.js";function Gl(cl){let h,X,Y,_,J,S,w,rl='<strong>MobileNetV3</strong> is a convolutional neural network that is designed for mobile phone CPUs. The network design includes the use of a <a href="https://paperswithcode.com/method/hard-swish" rel="nofollow">hard swish activation</a> and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation</a> modules in the <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">MBConv blocks</a>.',z,d,F,T,hl="To load a pretrained model:",H,U,D,g,Jl="To load and preprocess the image:",L,b,q,u,wl="To get the model predictions:",P,C,K,f,dl="To get the top-5 predictions class names:",O,I,ll,A,Tl="Replace the model name with the variant you want to use, e.g. <code>mobilenetv3_large_100</code>. You can find the IDs in the model summaries at the top of this page.",sl,Z,Ul='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',tl,k,al,B,gl="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",el,$,nl,N,bl=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Ml,W,pl,G,ul='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ml,E,il,Q,ol,x,jl,R,yl;return J=new V({props:{title:"MobileNet v3",local:"mobilenet-v3",headingTag:"h1"}}),d=new V({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new v({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYzX2xhcmdlXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new v({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new v({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new v({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new V({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),$=new v({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djNfbGFyZ2VfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv3_large_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new V({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new V({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new v({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1905-02244,</span>
  author    = {Andrew Howard <span class="hljs-keyword">and</span>
               Mark Sandler <span class="hljs-keyword">and</span>
               Grace Chu <span class="hljs-keyword">and</span>
               Liang{-}Chieh Chen <span class="hljs-keyword">and</span>
               Bo Chen <span class="hljs-keyword">and</span>
               Mingxing Tan <span class="hljs-keyword">and</span>
               Weijun Wang <span class="hljs-keyword">and</span>
               Yukun Zhu <span class="hljs-keyword">and</span>
               Ruoming Pang <span class="hljs-keyword">and</span>
               Vijay Vasudevan <span class="hljs-keyword">and</span>
               Quoc V. Le <span class="hljs-keyword">and</span>
               Hartwig Adam},
  title     = {Searching for MobileNetV3},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  year      = {<span class="hljs-number">2019</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1905.02244},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1905</span>.<span class="hljs-number">02244</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1905-02244.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`,wrap:!1}}),x=new Wl({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mobilenet-v3.mdx"}}),{c(){h=M("meta"),X=e(),Y=M("p"),_=e(),m(J.$$.fragment),S=e(),w=M("p"),w.innerHTML=rl,z=e(),m(d.$$.fragment),F=e(),T=M("p"),T.textContent=hl,H=e(),m(U.$$.fragment),D=e(),g=M("p"),g.textContent=Jl,L=e(),m(b.$$.fragment),q=e(),u=M("p"),u.textContent=wl,P=e(),m(C.$$.fragment),K=e(),f=M("p"),f.textContent=dl,O=e(),m(I.$$.fragment),ll=e(),A=M("p"),A.innerHTML=Tl,sl=e(),Z=M("p"),Z.innerHTML=Ul,tl=e(),m(k.$$.fragment),al=e(),B=M("p"),B.textContent=gl,el=e(),m($.$$.fragment),nl=e(),N=M("p"),N.innerHTML=bl,Ml=e(),m(W.$$.fragment),pl=e(),G=M("p"),G.innerHTML=ul,ml=e(),m(E.$$.fragment),il=e(),m(Q.$$.fragment),ol=e(),m(x.$$.fragment),jl=e(),R=M("p"),this.h()},l(l){const s=$l("svelte-u9bgzb",document.head);h=p(s,"META",{name:!0,content:!0}),s.forEach(t),X=n(l),Y=p(l,"P",{}),Cl(Y).forEach(t),_=n(l),i(J.$$.fragment,l),S=n(l),w=p(l,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1xpy3t9"&&(w.innerHTML=rl),z=n(l),i(d.$$.fragment,l),F=n(l),T=p(l,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ywhxh"&&(T.textContent=hl),H=n(l),i(U.$$.fragment,l),D=n(l),g=p(l,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1c2ipa8"&&(g.textContent=Jl),L=n(l),i(b.$$.fragment,l),q=n(l),u=p(l,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1n9qsq1"&&(u.textContent=wl),P=n(l),i(C.$$.fragment,l),K=n(l),f=p(l,"P",{"data-svelte-h":!0}),r(f)!=="svelte-19cnvx1"&&(f.textContent=dl),O=n(l),i(I.$$.fragment,l),ll=n(l),A=p(l,"P",{"data-svelte-h":!0}),r(A)!=="svelte-w2zjew"&&(A.innerHTML=Tl),sl=n(l),Z=p(l,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1wmi3ea"&&(Z.innerHTML=Ul),tl=n(l),i(k.$$.fragment,l),al=n(l),B=p(l,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=gl),el=n(l),i($.$$.fragment,l),nl=n(l),N=p(l,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1kguc51"&&(N.innerHTML=bl),Ml=n(l),i(W.$$.fragment,l),pl=n(l),G=p(l,"P",{"data-svelte-h":!0}),r(G)!=="svelte-xtxxu6"&&(G.innerHTML=ul),ml=n(l),i(E.$$.fragment,l),il=n(l),i(Q.$$.fragment,l),ol=n(l),i(x.$$.fragment,l),jl=n(l),R=p(l,"P",{}),Cl(R).forEach(t),this.h()},h(){fl(h,"name","hf:doc:metadata"),fl(h,"content",El)},m(l,s){Nl(document.head,h),a(l,X,s),a(l,Y,s),a(l,_,s),o(J,l,s),a(l,S,s),a(l,w,s),a(l,z,s),o(d,l,s),a(l,F,s),a(l,T,s),a(l,H,s),o(U,l,s),a(l,D,s),a(l,g,s),a(l,L,s),o(b,l,s),a(l,q,s),a(l,u,s),a(l,P,s),o(C,l,s),a(l,K,s),a(l,f,s),a(l,O,s),o(I,l,s),a(l,ll,s),a(l,A,s),a(l,sl,s),a(l,Z,s),a(l,tl,s),o(k,l,s),a(l,al,s),a(l,B,s),a(l,el,s),o($,l,s),a(l,nl,s),a(l,N,s),a(l,Ml,s),o(W,l,s),a(l,pl,s),a(l,G,s),a(l,ml,s),o(E,l,s),a(l,il,s),o(Q,l,s),a(l,ol,s),o(x,l,s),a(l,jl,s),a(l,R,s),yl=!0},p:Al,i(l){yl||(j(J.$$.fragment,l),j(d.$$.fragment,l),j(U.$$.fragment,l),j(b.$$.fragment,l),j(C.$$.fragment,l),j(I.$$.fragment,l),j(k.$$.fragment,l),j($.$$.fragment,l),j(W.$$.fragment,l),j(E.$$.fragment,l),j(Q.$$.fragment,l),j(x.$$.fragment,l),yl=!0)},o(l){y(J.$$.fragment,l),y(d.$$.fragment,l),y(U.$$.fragment,l),y(b.$$.fragment,l),y(C.$$.fragment,l),y(I.$$.fragment,l),y(k.$$.fragment,l),y($.$$.fragment,l),y(W.$$.fragment,l),y(E.$$.fragment,l),y(Q.$$.fragment,l),y(x.$$.fragment,l),yl=!1},d(l){l&&(t(X),t(Y),t(_),t(S),t(w),t(z),t(F),t(T),t(H),t(D),t(g),t(L),t(q),t(u),t(P),t(K),t(f),t(O),t(ll),t(A),t(sl),t(Z),t(tl),t(al),t(B),t(el),t(nl),t(N),t(Ml),t(pl),t(G),t(ml),t(il),t(ol),t(jl),t(R)),t(h),c(J,l),c(d,l),c(U,l),c(b,l),c(C,l),c(I,l),c(k,l),c($,l),c(W,l),c(E,l),c(Q,l),c(x,l)}}}const El='{"title":"MobileNet v3","local":"mobilenet-v3","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ql(cl){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vl extends kl{constructor(h){super(),Bl(this,h,Ql,Gl,Il,{})}}export{Vl as component};
