import{s as Is,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Ws,g as p,s as a,r as i,A as Ns,h as m,f as e,c as n,j as fs,u as o,x as y,k as Cs,y as xs,a as l,v as r,d as M,t as c,w as h}from"../chunks/index.c9837788.js";import{C as A}from"../chunks/CodeBlock.e573519b.js";import{H as _,E as Bs}from"../chunks/getInferenceSnippets.b020ba4f.js";function Rs(hs){let j,X,v,Y,J,z,d,ys='<strong>Wide Residual Networks</strong> are a variant on <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> where we decrease depth and increase the width of residual networks. This is achieved through the use of <a href="https://paperswithcode.com/method/wide-residual-block" rel="nofollow">wide residual blocks</a>.',H,g,S,w,js="To load a pretrained model:",F,T,D,u,Js="To load and preprocess the image:",L,b,q,U,ds="To get the model predictions:",P,f,K,C,gs="To get the top-5 predictions class names:",O,I,ss,Z,ws="Replace the model name with the variant you want to use, e.g. <code>wide_resnet101_2</code>. You can find the IDs in the model summaries at the top of this page.",ts,$,Ts='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',es,k,ls,W,us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,N,ns,x,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,B,ms,R,Us='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,G,os,E,rs,Q,Ms,V,cs;return J=new _({props:{title:"Wide ResNet",local:"wide-resnet",headingTag:"h1"}}),g=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new A({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3dpZGVfcmVzbmV0MTAxXzInJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new A({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new A({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new A({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnd2lkZV9yZXNuZXQxMDFfMiclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;wide_resnet101_2&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new A({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZaYWdvcnV5a29LMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTZXJnZXklMjBaYWdvcnV5a28lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOaWtvcyUyMEtvbW9kYWtpcyU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCV2lkZSUyMFJlc2lkdWFsJTIwTmV0d29ya3MlN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE2MDUuMDcxNDYlN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxNiU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxNjA1LjA3MTQ2JTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTYwNS4wNzE0NiU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3Qk1vbiUyQyUyMDEzJTIwQXVnJTIwMjAxOCUyMDE2JTNBNDYlM0E0MiUyMCUyQjAyMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGWmFnb3J1eWtvSzE2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16,
  author    = {Sergey Zagoruyko and
               Nikos Komodakis},
  title     = {Wide Residual Networks},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1605.07146</span>},
  year      = {<span class="hljs-number">2016</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1605.07146</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1605.07146</span>},
  timestamp = {Mon, <span class="hljs-number">13</span> Aug <span class="hljs-number">2018</span> <span class="hljs-number">16</span>:<span class="hljs-number">46</span>:<span class="hljs-number">42</span> +<span class="hljs-number">0200</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>ZagoruykoK16.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),Q=new Bs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/wide-resnet.mdx"}}),{c(){j=p("meta"),X=a(),v=p("p"),Y=a(),i(J.$$.fragment),z=a(),d=p("p"),d.innerHTML=ys,H=a(),i(g.$$.fragment),S=a(),w=p("p"),w.textContent=js,F=a(),i(T.$$.fragment),D=a(),u=p("p"),u.textContent=Js,L=a(),i(b.$$.fragment),q=a(),U=p("p"),U.textContent=ds,P=a(),i(f.$$.fragment),K=a(),C=p("p"),C.textContent=gs,O=a(),i(I.$$.fragment),ss=a(),Z=p("p"),Z.innerHTML=ws,ts=a(),$=p("p"),$.innerHTML=Ts,es=a(),i(k.$$.fragment),ls=a(),W=p("p"),W.textContent=us,as=a(),i(N.$$.fragment),ns=a(),x=p("p"),x.innerHTML=bs,ps=a(),i(B.$$.fragment),ms=a(),R=p("p"),R.innerHTML=Us,is=a(),i(G.$$.fragment),os=a(),i(E.$$.fragment),rs=a(),i(Q.$$.fragment),Ms=a(),V=p("p"),this.h()},l(s){const t=Ns("svelte-u9bgzb",document.head);j=m(t,"META",{name:!0,content:!0}),t.forEach(e),X=n(s),v=m(s,"P",{}),fs(v).forEach(e),Y=n(s),o(J.$$.fragment,s),z=n(s),d=m(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-k7y9u3"&&(d.innerHTML=ys),H=n(s),o(g.$$.fragment,s),S=n(s),w=m(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-18ywhxh"&&(w.textContent=js),F=n(s),o(T.$$.fragment,s),D=n(s),u=m(s,"P",{"data-svelte-h":!0}),y(u)!=="svelte-1c2ipa8"&&(u.textContent=Js),L=n(s),o(b.$$.fragment,s),q=n(s),U=m(s,"P",{"data-svelte-h":!0}),y(U)!=="svelte-1n9qsq1"&&(U.textContent=ds),P=n(s),o(f.$$.fragment,s),K=n(s),C=m(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-19cnvx1"&&(C.textContent=gs),O=n(s),o(I.$$.fragment,s),ss=n(s),Z=m(s,"P",{"data-svelte-h":!0}),y(Z)!=="svelte-1x7kcxy"&&(Z.innerHTML=ws),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),y($)!=="svelte-1wmi3ea"&&($.innerHTML=Ts),es=n(s),o(k.$$.fragment,s),ls=n(s),W=m(s,"P",{"data-svelte-h":!0}),y(W)!=="svelte-9sr7nh"&&(W.textContent=us),as=n(s),o(N.$$.fragment,s),ns=n(s),x=m(s,"P",{"data-svelte-h":!0}),y(x)!=="svelte-1kguc51"&&(x.innerHTML=bs),ps=n(s),o(B.$$.fragment,s),ms=n(s),R=m(s,"P",{"data-svelte-h":!0}),y(R)!=="svelte-xtxxu6"&&(R.innerHTML=Us),is=n(s),o(G.$$.fragment,s),os=n(s),o(E.$$.fragment,s),rs=n(s),o(Q.$$.fragment,s),Ms=n(s),V=m(s,"P",{}),fs(V).forEach(e),this.h()},h(){Cs(j,"name","hf:doc:metadata"),Cs(j,"content",Gs)},m(s,t){xs(document.head,j),l(s,X,t),l(s,v,t),l(s,Y,t),r(J,s,t),l(s,z,t),l(s,d,t),l(s,H,t),r(g,s,t),l(s,S,t),l(s,w,t),l(s,F,t),r(T,s,t),l(s,D,t),l(s,u,t),l(s,L,t),r(b,s,t),l(s,q,t),l(s,U,t),l(s,P,t),r(f,s,t),l(s,K,t),l(s,C,t),l(s,O,t),r(I,s,t),l(s,ss,t),l(s,Z,t),l(s,ts,t),l(s,$,t),l(s,es,t),r(k,s,t),l(s,ls,t),l(s,W,t),l(s,as,t),r(N,s,t),l(s,ns,t),l(s,x,t),l(s,ps,t),r(B,s,t),l(s,ms,t),l(s,R,t),l(s,is,t),r(G,s,t),l(s,os,t),r(E,s,t),l(s,rs,t),r(Q,s,t),l(s,Ms,t),l(s,V,t),cs=!0},p:Zs,i(s){cs||(M(J.$$.fragment,s),M(g.$$.fragment,s),M(T.$$.fragment,s),M(b.$$.fragment,s),M(f.$$.fragment,s),M(I.$$.fragment,s),M(k.$$.fragment,s),M(N.$$.fragment,s),M(B.$$.fragment,s),M(G.$$.fragment,s),M(E.$$.fragment,s),M(Q.$$.fragment,s),cs=!0)},o(s){c(J.$$.fragment,s),c(g.$$.fragment,s),c(T.$$.fragment,s),c(b.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(N.$$.fragment,s),c(B.$$.fragment,s),c(G.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),cs=!1},d(s){s&&(e(X),e(v),e(Y),e(z),e(d),e(H),e(S),e(w),e(F),e(D),e(u),e(L),e(q),e(U),e(P),e(K),e(C),e(O),e(ss),e(Z),e(ts),e($),e(es),e(ls),e(W),e(as),e(ns),e(x),e(ps),e(ms),e(R),e(is),e(os),e(rs),e(Ms),e(V)),e(j),h(J,s),h(g,s),h(T,s),h(b,s),h(f,s),h(I,s),h(k,s),h(N,s),h(B,s),h(G,s),h(E,s),h(Q,s)}}}const Gs='{"title":"Wide ResNet","local":"wide-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Es(hs){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _s extends ks{constructor(j){super(),Ws(this,j,Es,Rs,Is,{})}}export{_s as component};
