import{s as ge,n as Je,o as fe}from"../chunks/scheduler.85c25b89.js";import{S as be,i as Te,g as a,s as o,u as c,A as ve,h as n,f as e,c as i,j as h,v as d,y as m,k as p,o as r,a as l,w as M,d as u,t as w,x as j}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ue(Ht){let y,mt,lt,ct,g,v,at,Z,Xt,q,zt="FBNet",dt,N,Pt='<strong>FBNet</strong> is a type of convolutional neural architectures discovered through <a href="https://paperswithcode.com/method/dnas" rel="nofollow">DNAS</a> neural architecture search. It utilises a basic type of image model block inspired by <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetv2</a> that utilises depthwise convolutions and an inverted residual structure (see components).',Mt,$,Lt='The principal building block is the <a href="https://paperswithcode.com/method/fbnet-block" rel="nofollow">FBNet Block</a>.',ut,J,U,nt,x,Yt,K,Dt="How do I use this model on an image?",wt,W,qt="To load a pretrained model:",jt,B,yt,E,Kt="To load and preprocess the image:",gt,_,Jt,G,Ot="To get the model predictions:",ft,A,bt,V,te="To get the top-5 predictions class names:",Tt,Q,vt,X,ee="Replace the model name with the variant you want to use, e.g. <code>fbnetc_100</code>. You can find the IDs in the model summaries at the top of this page.",Ut,Y,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',kt,f,k,ot,S,St,O,le="How do I finetune this model?",It,R,ae="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ct,F,Zt,H,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Nt,b,I,it,z,Rt,tt,oe="How do I train this model?",$t,P,ie='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',xt,T,C,pt,L,Ft,et,pe="Citation",Wt,D,Bt,rt,Et;return Z=new ht({}),x=new ht({}),B=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2ZibmV0Y18xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),_=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new ht({}),F=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZmJuZXRjXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;fbnetc_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new ht({}),L=new ht({}),D=new st({props:{code:"JTQwbWlzYyU3Qnd1MjAxOWZibmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JGQk5ldCUzQSUyMEhhcmR3YXJlLUF3YXJlJTIwRWZmaWNpZW50JTIwQ29udk5ldCUyMERlc2lnbiUyMHZpYSUyMERpZmZlcmVudGlhYmxlJTIwTmV1cmFsJTIwQXJjaGl0ZWN0dXJlJTIwU2VhcmNoJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCQmljaGVuJTIwV3UlMjBhbmQlMjBYaWFvbGlhbmclMjBEYWklMjBhbmQlMjBQZWl6aGFvJTIwWmhhbmclMjBhbmQlMjBZYW5naGFuJTIwV2FuZyUyMGFuZCUyMEZlaSUyMFN1biUyMGFuZCUyMFlpbWluZyUyMFd1JTIwYW5kJTIwWXVhbmRvbmclMjBUaWFuJTIwYW5kJTIwUGV0ZXIlMjBWYWpkYSUyMGFuZCUyMFlhbmdxaW5nJTIwSmlhJTIwYW5kJTIwS3VydCUyMEtldXR6ZXIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxOSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE4MTIuMDM0NDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{wu<span class="hljs-symbol">2019f</span>bnet,
      title={FBNet: Hardware-Aware Efficient ConvNet Design via <span class="hljs-keyword">Differentiable </span>Neural Architecture Search}, 
      author={<span class="hljs-keyword">Bichen </span>Wu <span class="hljs-keyword">and </span>Xiaoliang Dai <span class="hljs-keyword">and </span>Peizhao Zhang <span class="hljs-keyword">and </span>Yanghan Wang <span class="hljs-keyword">and </span>Fei Sun <span class="hljs-keyword">and </span>Yiming Wu <span class="hljs-keyword">and </span>Yuandong Tian <span class="hljs-keyword">and </span>Peter Vajda <span class="hljs-keyword">and </span>Yangqing <span class="hljs-keyword">Jia </span><span class="hljs-keyword">and </span>Kurt Keutzer},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1812</span>.<span class="hljs-number">03443</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){y=a("meta"),mt=o(),lt=a("p"),ct=o(),g=a("h1"),v=a("a"),at=a("span"),c(Z.$$.fragment),Xt=o(),q=a("span"),q.textContent=zt,dt=o(),N=a("p"),N.innerHTML=Pt,Mt=o(),$=a("p"),$.innerHTML=Lt,ut=o(),J=a("h2"),U=a("a"),nt=a("span"),c(x.$$.fragment),Yt=o(),K=a("span"),K.textContent=Dt,wt=o(),W=a("p"),W.textContent=qt,jt=o(),c(B.$$.fragment),yt=o(),E=a("p"),E.textContent=Kt,gt=o(),c(_.$$.fragment),Jt=o(),G=a("p"),G.textContent=Ot,ft=o(),c(A.$$.fragment),bt=o(),V=a("p"),V.textContent=te,Tt=o(),c(Q.$$.fragment),vt=o(),X=a("p"),X.innerHTML=ee,Ut=o(),Y=a("p"),Y.innerHTML=se,kt=o(),f=a("h2"),k=a("a"),ot=a("span"),c(S.$$.fragment),St=o(),O=a("span"),O.textContent=le,It=o(),R=a("p"),R.textContent=ae,Ct=o(),c(F.$$.fragment),Zt=o(),H=a("p"),H.innerHTML=ne,Nt=o(),b=a("h2"),I=a("a"),it=a("span"),c(z.$$.fragment),Rt=o(),tt=a("span"),tt.textContent=oe,$t=o(),P=a("p"),P.innerHTML=ie,xt=o(),T=a("h2"),C=a("a"),pt=a("span"),c(L.$$.fragment),Ft=o(),et=a("span"),et.textContent=pe,Wt=o(),c(D.$$.fragment),Bt=o(),rt=a("p"),this.h()},l(t){const s=ve("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=i(t),lt=n(t,"P",{}),h(lt).forEach(e),ct=i(t),g=n(t,"H1",{class:!0});var _t=h(g);v=n(_t,"A",{id:!0,class:!0,href:!0});var re=h(v);at=n(re,"SPAN",{});var he=h(at);d(Z.$$.fragment,he),he.forEach(e),re.forEach(e),Xt=i(_t),q=n(_t,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-16yvb1k"&&(q.textContent=zt),_t.forEach(e),dt=i(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-112qqgm"&&(N.innerHTML=Pt),Mt=i(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-u55bao"&&($.innerHTML=Lt),ut=i(t),J=n(t,"H2",{class:!0});var Gt=h(J);U=n(Gt,"A",{id:!0,class:!0,href:!0});var me=h(U);nt=n(me,"SPAN",{});var ce=h(nt);d(x.$$.fragment,ce),ce.forEach(e),me.forEach(e),Yt=i(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1c1hspn"&&(K.textContent=Dt),Gt.forEach(e),wt=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=qt),jt=i(t),d(B.$$.fragment,t),yt=i(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Kt),gt=i(t),d(_.$$.fragment,t),Jt=i(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Ot),ft=i(t),d(A.$$.fragment,t),bt=i(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-19cnvx1"&&(V.textContent=te),Tt=i(t),d(Q.$$.fragment,t),vt=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-18ctdhs"&&(X.innerHTML=ee),Ut=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-1wmi3ea"&&(Y.innerHTML=se),kt=i(t),f=n(t,"H2",{class:!0});var At=h(f);k=n(At,"A",{id:!0,class:!0,href:!0});var de=h(k);ot=n(de,"SPAN",{});var Me=h(ot);d(S.$$.fragment,Me),Me.forEach(e),de.forEach(e),St=i(At),O=n(At,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1viv4qv"&&(O.textContent=le),At.forEach(e),It=i(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-9sr7nh"&&(R.textContent=ae),Ct=i(t),d(F.$$.fragment,t),Zt=i(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=ne),Nt=i(t),b=n(t,"H2",{class:!0});var Vt=h(b);I=n(Vt,"A",{id:!0,class:!0,href:!0});var ue=h(I);it=n(ue,"SPAN",{});var we=h(it);d(z.$$.fragment,we),we.forEach(e),ue.forEach(e),Rt=i(Vt),tt=n(Vt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1ce591d"&&(tt.textContent=oe),Vt.forEach(e),$t=i(t),P=n(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1n0coha"&&(P.innerHTML=ie),xt=i(t),T=n(t,"H2",{class:!0});var Qt=h(T);C=n(Qt,"A",{id:!0,class:!0,href:!0});var je=h(C);pt=n(je,"SPAN",{});var ye=h(pt);d(L.$$.fragment,ye),ye.forEach(e),je.forEach(e),Ft=i(Qt),et=n(Qt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-15mb3gy"&&(et.textContent=pe),Qt.forEach(e),Wt=i(t),d(D.$$.fragment,t),Bt=i(t),rt=n(t,"P",{}),h(rt).forEach(e),this.h()},h(){p(y,"name","hf:doc:metadata"),p(y,"content",JSON.stringify(ke)),p(v,"id","fbnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#fbnet"),p(g,"class","relative group"),p(U,"id","how-do-i-use-this-model-on-an-image"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-use-this-model-on-an-image"),p(J,"class","relative group"),p(k,"id","how-do-i-finetune-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-finetune-this-model"),p(f,"class","relative group"),p(I,"id","how-do-i-train-this-model"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-train-this-model"),p(b,"class","relative group"),p(C,"id","citation"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#citation"),p(T,"class","relative group")},m(t,s){r(document.head,y),l(t,mt,s),l(t,lt,s),l(t,ct,s),l(t,g,s),r(g,v),r(v,at),M(Z,at,null),r(g,Xt),r(g,q),l(t,dt,s),l(t,N,s),l(t,Mt,s),l(t,$,s),l(t,ut,s),l(t,J,s),r(J,U),r(U,nt),M(x,nt,null),r(J,Yt),r(J,K),l(t,wt,s),l(t,W,s),l(t,jt,s),M(B,t,s),l(t,yt,s),l(t,E,s),l(t,gt,s),M(_,t,s),l(t,Jt,s),l(t,G,s),l(t,ft,s),M(A,t,s),l(t,bt,s),l(t,V,s),l(t,Tt,s),M(Q,t,s),l(t,vt,s),l(t,X,s),l(t,Ut,s),l(t,Y,s),l(t,kt,s),l(t,f,s),r(f,k),r(k,ot),M(S,ot,null),r(f,St),r(f,O),l(t,It,s),l(t,R,s),l(t,Ct,s),M(F,t,s),l(t,Zt,s),l(t,H,s),l(t,Nt,s),l(t,b,s),r(b,I),r(I,it),M(z,it,null),r(b,Rt),r(b,tt),l(t,$t,s),l(t,P,s),l(t,xt,s),l(t,T,s),r(T,C),r(C,pt),M(L,pt,null),r(T,Ft),r(T,et),l(t,Wt,s),M(D,t,s),l(t,Bt,s),l(t,rt,s),Et=!0},p:Je,i(t){Et||(u(Z.$$.fragment,t),u(x.$$.fragment,t),u(B.$$.fragment,t),u(_.$$.fragment,t),u(A.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(F.$$.fragment,t),u(z.$$.fragment,t),u(L.$$.fragment,t),u(D.$$.fragment,t),Et=!0)},o(t){w(Z.$$.fragment,t),w(x.$$.fragment,t),w(B.$$.fragment,t),w(_.$$.fragment,t),w(A.$$.fragment,t),w(Q.$$.fragment,t),w(S.$$.fragment,t),w(F.$$.fragment,t),w(z.$$.fragment,t),w(L.$$.fragment,t),w(D.$$.fragment,t),Et=!1},d(t){t&&(e(mt),e(lt),e(ct),e(g),e(dt),e(N),e(Mt),e($),e(ut),e(J),e(wt),e(W),e(jt),e(yt),e(E),e(gt),e(Jt),e(G),e(ft),e(bt),e(V),e(Tt),e(vt),e(X),e(Ut),e(Y),e(kt),e(f),e(It),e(R),e(Ct),e(Zt),e(H),e(Nt),e(b),e($t),e(P),e(xt),e(T),e(Wt),e(Bt),e(rt)),e(y),j(Z),j(x),j(B,t),j(_,t),j(A,t),j(Q,t),j(S),j(F,t),j(z),j(L),j(D,t)}}}const ke={local:"fbnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"FBNet"};function Ie(Ht){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends be{constructor(y){super(),Te(this,y,Ie,Ue,ge,{})}}export{xe as component};
