import{s as we,n as Me,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as ye,i as je,g as l,s as p,u as c,A as fe,h as n,f as e,c as o,j as h,v as d,y as m,k as i,o as r,a,w as g,d as u,t as w,x as M}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as et}from"../chunks/CodeBlock.00597c71.js";function Te(Yt){let J,ht,st,mt,y,v,at,C,Qt,q,Ht="SK-ResNeXt",ct,$,zt='<strong>SK ResNeXt</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnext" rel="nofollow">ResNeXt</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNext are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',dt,j,x,lt,N,Vt,D,Ft="How do I use this model on an image?",gt,Z,Pt="To load a pretrained model:",ut,W,wt,E,Lt="To load and preprocess the image:",Mt,_,Jt,B,qt="To get the model predictions:",yt,G,jt,A,Dt="To get the top-5 predictions class names:",ft,Q,Tt,V,Kt="Replace the model name with the variant you want to use, e.g. <code>skresnext50_32x4d</code>. You can find the IDs in the model summaries at the top of this page.",bt,S,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,f,U,nt,X,St,K,te="How do I finetune this model?",xt,R,ee="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ut,Y,It,H,se=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,kt,T,I,pt,z,Xt,O,ae="How do I train this model?",Ct,F,le='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,b,k,ot,P,Rt,tt,ne="Citation",Nt,L,Zt,it,Wt;return C=new rt({}),N=new rt({}),W=new et({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV4dDUwXzMyeDRkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),_=new et({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new et({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new et({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),X=new rt({}),Y=new et({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXh0NTBfMzJ4NGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnext50_32x4d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new et({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`}}),{c(){J=l("meta"),ht=p(),st=l("p"),mt=p(),y=l("h1"),v=l("a"),at=l("span"),c(C.$$.fragment),Qt=p(),q=l("span"),q.textContent=Ht,ct=p(),$=l("p"),$.innerHTML=zt,dt=p(),j=l("h2"),x=l("a"),lt=l("span"),c(N.$$.fragment),Vt=p(),D=l("span"),D.textContent=Ft,gt=p(),Z=l("p"),Z.textContent=Pt,ut=p(),c(W.$$.fragment),wt=p(),E=l("p"),E.textContent=Lt,Mt=p(),c(_.$$.fragment),Jt=p(),B=l("p"),B.textContent=qt,yt=p(),c(G.$$.fragment),jt=p(),A=l("p"),A.textContent=Dt,ft=p(),c(Q.$$.fragment),Tt=p(),V=l("p"),V.innerHTML=Kt,bt=p(),S=l("p"),S.innerHTML=Ot,vt=p(),f=l("h2"),U=l("a"),nt=l("span"),c(X.$$.fragment),St=p(),K=l("span"),K.textContent=te,xt=p(),R=l("p"),R.textContent=ee,Ut=p(),c(Y.$$.fragment),It=p(),H=l("p"),H.innerHTML=se,kt=p(),T=l("h2"),I=l("a"),pt=l("span"),c(z.$$.fragment),Xt=p(),O=l("span"),O.textContent=ae,Ct=p(),F=l("p"),F.innerHTML=le,$t=p(),b=l("h2"),k=l("a"),ot=l("span"),c(P.$$.fragment),Rt=p(),tt=l("span"),tt.textContent=ne,Nt=p(),c(L.$$.fragment),Zt=p(),it=l("p"),this.h()},l(t){const s=fe("svelte-1phssyn",document.head);J=n(s,"META",{name:!0,content:!0}),s.forEach(e),ht=o(t),st=n(t,"P",{}),h(st).forEach(e),mt=o(t),y=n(t,"H1",{class:!0});var Et=h(y);v=n(Et,"A",{id:!0,class:!0,href:!0});var pe=h(v);at=n(pe,"SPAN",{});var oe=h(at);d(C.$$.fragment,oe),oe.forEach(e),pe.forEach(e),Qt=o(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1wczqu5"&&(q.textContent=Ht),Et.forEach(e),ct=o(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1kqotlt"&&($.innerHTML=zt),dt=o(t),j=n(t,"H2",{class:!0});var _t=h(j);x=n(_t,"A",{id:!0,class:!0,href:!0});var ie=h(x);lt=n(ie,"SPAN",{});var re=h(lt);d(N.$$.fragment,re),re.forEach(e),ie.forEach(e),Vt=o(_t),D=n(_t,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-1c1hspn"&&(D.textContent=Ft),_t.forEach(e),gt=o(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18ywhxh"&&(Z.textContent=Pt),ut=o(t),d(W.$$.fragment,t),wt=o(t),E=n(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-1c2ipa8"&&(E.textContent=Lt),Mt=o(t),d(_.$$.fragment,t),Jt=o(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1n9qsq1"&&(B.textContent=qt),yt=o(t),d(G.$$.fragment,t),jt=o(t),A=n(t,"P",{"data-svelte-h":!0}),m(A)!=="svelte-19cnvx1"&&(A.textContent=Dt),ft=o(t),d(Q.$$.fragment,t),Tt=o(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-44hawi"&&(V.innerHTML=Kt),bt=o(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1wmi3ea"&&(S.innerHTML=Ot),vt=o(t),f=n(t,"H2",{class:!0});var Bt=h(f);U=n(Bt,"A",{id:!0,class:!0,href:!0});var he=h(U);nt=n(he,"SPAN",{});var me=h(nt);d(X.$$.fragment,me),me.forEach(e),he.forEach(e),St=o(Bt),K=n(Bt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=te),Bt.forEach(e),xt=o(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-9sr7nh"&&(R.textContent=ee),Ut=o(t),d(Y.$$.fragment,t),It=o(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=se),kt=o(t),T=n(t,"H2",{class:!0});var Gt=h(T);I=n(Gt,"A",{id:!0,class:!0,href:!0});var ce=h(I);pt=n(ce,"SPAN",{});var de=h(pt);d(z.$$.fragment,de),de.forEach(e),ce.forEach(e),Xt=o(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=ae),Gt.forEach(e),Ct=o(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=le),$t=o(t),b=n(t,"H2",{class:!0});var At=h(b);k=n(At,"A",{id:!0,class:!0,href:!0});var ge=h(k);ot=n(ge,"SPAN",{});var ue=h(ot);d(P.$$.fragment,ue),ue.forEach(e),ge.forEach(e),Rt=o(At),tt=n(At,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ne),At.forEach(e),Nt=o(t),d(L.$$.fragment,t),Zt=o(t),it=n(t,"P",{}),h(it).forEach(e),this.h()},h(){i(J,"name","hf:doc:metadata"),i(J,"content",JSON.stringify(be)),i(v,"id","skresnext"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#skresnext"),i(y,"class","relative group"),i(x,"id","how-do-i-use-this-model-on-an-image"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#how-do-i-use-this-model-on-an-image"),i(j,"class","relative group"),i(U,"id","how-do-i-finetune-this-model"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-finetune-this-model"),i(f,"class","relative group"),i(I,"id","how-do-i-train-this-model"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#how-do-i-train-this-model"),i(T,"class","relative group"),i(k,"id","citation"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#citation"),i(b,"class","relative group")},m(t,s){r(document.head,J),a(t,ht,s),a(t,st,s),a(t,mt,s),a(t,y,s),r(y,v),r(v,at),g(C,at,null),r(y,Qt),r(y,q),a(t,ct,s),a(t,$,s),a(t,dt,s),a(t,j,s),r(j,x),r(x,lt),g(N,lt,null),r(j,Vt),r(j,D),a(t,gt,s),a(t,Z,s),a(t,ut,s),g(W,t,s),a(t,wt,s),a(t,E,s),a(t,Mt,s),g(_,t,s),a(t,Jt,s),a(t,B,s),a(t,yt,s),g(G,t,s),a(t,jt,s),a(t,A,s),a(t,ft,s),g(Q,t,s),a(t,Tt,s),a(t,V,s),a(t,bt,s),a(t,S,s),a(t,vt,s),a(t,f,s),r(f,U),r(U,nt),g(X,nt,null),r(f,St),r(f,K),a(t,xt,s),a(t,R,s),a(t,Ut,s),g(Y,t,s),a(t,It,s),a(t,H,s),a(t,kt,s),a(t,T,s),r(T,I),r(I,pt),g(z,pt,null),r(T,Xt),r(T,O),a(t,Ct,s),a(t,F,s),a(t,$t,s),a(t,b,s),r(b,k),r(k,ot),g(P,ot,null),r(b,Rt),r(b,tt),a(t,Nt,s),g(L,t,s),a(t,Zt,s),a(t,it,s),Wt=!0},p:Me,i(t){Wt||(u(C.$$.fragment,t),u(N.$$.fragment,t),u(W.$$.fragment,t),u(_.$$.fragment,t),u(G.$$.fragment,t),u(Q.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(z.$$.fragment,t),u(P.$$.fragment,t),u(L.$$.fragment,t),Wt=!0)},o(t){w(C.$$.fragment,t),w(N.$$.fragment,t),w(W.$$.fragment,t),w(_.$$.fragment,t),w(G.$$.fragment,t),w(Q.$$.fragment,t),w(X.$$.fragment,t),w(Y.$$.fragment,t),w(z.$$.fragment,t),w(P.$$.fragment,t),w(L.$$.fragment,t),Wt=!1},d(t){t&&(e(ht),e(st),e(mt),e(y),e(ct),e($),e(dt),e(j),e(gt),e(Z),e(ut),e(wt),e(E),e(Mt),e(Jt),e(B),e(yt),e(jt),e(A),e(ft),e(Tt),e(V),e(bt),e(S),e(vt),e(f),e(xt),e(R),e(Ut),e(It),e(H),e(kt),e(T),e(Ct),e(F),e($t),e(b),e(Nt),e(Zt),e(it)),e(J),M(C),M(N),M(W,t),M(_,t),M(G,t),M(Q,t),M(X),M(Y,t),M(z),M(P),M(L,t)}}}const be={local:"skresnext",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"SK-ResNeXt"};function ve(Yt){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ce extends ye{constructor(J){super(),je(this,J,ve,Te,we,{})}}export{Ce as component};
