import{s as Vs,o as qs,n as Q}from"../chunks/scheduler.22bf70d2.js";import{S as As,i as Ds,g as i,s as l,r as g,A as Ls,h as p,f as d,c as r,j as v,u as f,x as u,k as x,y as a,a as $,v as M,d as y,t as b,w}from"../chunks/index.59178e06.js";import{D as B}from"../chunks/Docstring.282623f1.js";import{C as W}from"../chunks/CodeBlock.f7047b13.js";import{E as P}from"../chunks/ExampleCodeBlock.6ab40c26.js";import{H as Ks,E as Os}from"../chunks/EditOnGithub.86314611.js";function ea(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBJbml0UHJvY2Vzc0dyb3VwS3dhcmdzJTBBJTBBJTIzJTIwVG8lMjBpbmNsdWRlJTIwJTYwSW5pdFByb2Nlc3NHcm91cEt3YXJncyU2MCUyQyUyMGluaXQlMjB0aGVuJTIwY2FsbCUyMCU2MC50b19rd2FyZ3MoKSU2MCUwQWt3YXJncyUyMCUzRCUyMEluaXRQcm9jZXNzR3JvdXBLd2FyZ3MoLi4uKS50b19rd2FyZ3MoKSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCoqa3dhcmdzKQ==",highlighted:'<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> InitProcessGroupKwargs\n\n<span class="hljs-comment"># To include `InitProcessGroupKwargs`, init then call `.to_kwargs()`</span>\nkwargs = InitProcessGroupKwargs(...).to_kwargs()\nstate = PartialState(**kwargs)',wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ta(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBd2l0aCUyMHN0YXRlLmxvY2FsX21haW5fcHJvY2Vzc19maXJzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBmaXJzdCUyMGJ5JTIwbG9jYWwlMjBwcm9jZXNzJTIwMCUyMHRoZW4lMjBpbiUyMGElMjBzZWVtaW5nbHklMEElMjAlMjAlMjAlMjAlMjMlMjByYW5kb20lMjBvcmRlciUyMGJ5JTIwdGhlJTIwb3RoZXIlMjBwcm9jZXNzZXMuJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwJTdCc3RhdGUubG9jYWxfcHJvY2Vzc19pbmRleCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> state.local_main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by local process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{state.local_process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function sa(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQXdpdGglMjBhY2NlbGVyYXRvci5tYWluX3Byb2Nlc3NfZmlyc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwZmlyc3QlMjBieSUyMHByb2Nlc3MlMjAwJTIwdGhlbiUyMGluJTIwYSUyMHNlZW1pbmdseSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJhbmRvbSUyMG9yZGVyJTIwYnklMjB0aGUlMjBvdGhlciUyMHByb2Nlc3Nlcy4lMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAlN0JhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4JTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function aa(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9sYXN0X3Byb2Nlc3MlMEFkZWYlMjBwcmludF9zb21ldGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwJTdCc3RhdGUucHJvY2Vzc19pbmRleCU3RCUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAzJTIy",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_last_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 3&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function na(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbG9jYWxfbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIwb24lMjBlYWNoJTIwc2VydmVyLiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMyUyME9uJTIwc2VydmVyJTIwMSUzQSUwQSUyMlRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwYnklMjBwcm9jZXNzJTIwMCUyMG9ubHklMjIlMEElMjMlMjBPbiUyMHNlcnZlciUyMDIlM0ElMEElMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_local_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only on each server.&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function la(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX2xvY2FsX3Byb2Nlc3MobG9jYWxfcHJvY2Vzc19pbmRleCUzRDIpJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjMlMjBPbiUyMHNlcnZlciUyMDElM0ElMEElMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwMiUyMiUwQSUyMyUyME9uJTIwc2VydmVyJTIwMiUzQSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAyJTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_local_process(<span class="hljs-params">local_process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.local_process_index}</span>&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ra(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBJTBBJTBBJTQwc3RhdGUub25fbWFpbl9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5LiUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()


<span class="hljs-meta">&gt;&gt;&gt; </span>@state.on_main_process
<span class="hljs-meta">... </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>print_something()
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function oa(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEElMEElMEElNDBzdGF0ZS5vbl9wcm9jZXNzKHByb2Nlc3NfaW5kZXglM0QyKSUwQWRlZiUyMHByaW50X3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAlN0JzdGF0ZS5wcm9jZXNzX2luZGV4JTdEJTIyKSUwQSUwQSUwQXByaW50X3NvbWV0aGluZygpJTBBJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMDIlMjI=",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

state = PartialState()


<span class="hljs-meta">@state.on_process(<span class="hljs-params">process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{state.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ca(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQSUwQXN0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEKSUyMGFzJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoaW5wdXRzKSUwQSUyMyUyMFByb2Nlc3MlMjAwJTBBJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlNUQlMEElMjMlMjBQcm9jZXNzJTIwMSUwQSU1QiUyMkMlMjIlNUQlMEElMEF3aXRoJTIwc3RhdGUuc3BsaXRfYmV0d2Vlbl9wcm9jZXNzZXMoJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlMkMlMjAlMjJDJTIyJTVEJTJDJTIwYXBwbHlfcGFkZGluZyUzRFRydWUpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiUyQyUyMCUyMkMlMjIlNUQ=",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState

state = PartialState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function ia(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBHUFUlMjBwcm9jZXNzZXMlMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMGFjY2VsZXJhdGUuc3RhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMFBhcnRpYWxTdGF0ZSgpJTBBaWYlMjBzdGF0ZS5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjB0aW1lLnNsZWVwKDIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkknbSUyMHdhaXRpbmclMjBmb3IlMjB0aGUlMjBtYWluJTIwcHJvY2VzcyUyMHRvJTIwZmluaXNoJTIwaXRzJTIwc2xlZXAuLi4lMjIpJTBBc3RhdGUud2FpdF9mb3JfZXZlcnlvbmUoKSUwQSUyMyUyMFNob3VsZCUyMHByaW50JTIwb24lMjBldmVyeSUyMHByb2Nlc3MlMjBhdCUyMHRoZSUyMHNhbWUlMjB0aW1lJTBBcHJpbnQoJTIyRXZlcnlvbmUlMjBpcyUyMGhlcmUlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two GPU processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> PartialState

<span class="hljs-meta">&gt;&gt;&gt; </span>state = PartialState()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> state.is_main_process:
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I&#x27;m waiting for the main process to finish its sleep...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>state.wait_for_everyone()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Should print on every process at the same time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Everyone is here&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function pa(J){let s,j="Example:",c,n,o;return n=new W({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZS5zdGF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yU3RhdGUlMEElMEFzdGF0ZSUyMCUzRCUyMEFjY2VsZXJhdG9yU3RhdGUoKSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQpJTIwYXMlMjBpbnB1dHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChpbnB1dHMpJTBBJTIzJTIwUHJvY2VzcyUyMDAlMEElNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiU1RCUwQSUyMyUyMFByb2Nlc3MlMjAxJTBBJTVCJTIyQyUyMiU1RCUwQSUwQXdpdGglMjBzdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJBJTIyJTJDJTIwJTIyQiUyMiUyQyUyMCUyMkMlMjIlNUQlMkMlMjBhcHBseV9wYWRkaW5nJTNEVHJ1ZSklMjBhcyUyMGlucHV0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGlucHV0cyklMEElMjMlMjBQcm9jZXNzJTIwMCUwQSU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTIzJTIwUHJvY2VzcyUyMDElMEElNUIlMjJDJTIyJTJDJTIwJTIyQyUyMiU1RA==",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate.state <span class="hljs-keyword">import</span> AcceleratorState

state = AcceleratorState()
<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> state.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){s=i("p"),s.textContent=j,c=l(),g(n.$$.fragment)},l(e){s=p(e,"P",{"data-svelte-h":!0}),u(s)!=="svelte-11lpom8"&&(s.textContent=j),c=r(e),f(n.$$.fragment,e)},m(e,m){$(e,s,m),$(e,c,m),M(n,e,m),o=!0},p:Q,i(e){o||(y(n.$$.fragment,e),o=!0)},o(e){b(n.$$.fragment,e),o=!1},d(e){e&&(d(s),d(c)),w(n,e)}}}function da(J){let s,j,c,n,o,e,m,Ms=`Below are variations of a <a href="https://en.wikipedia.org/wiki/Singleton_pattern" rel="nofollow">singleton class</a> in the sense that all
instances share the same state, which is initialized on the first instantiation.`,mt,fe,ys=`These classes are immutable and store information about certain configurations or
states.`,ht,_,Me,bt,Ee,bs=`Singleton class that has information about the current training environment and functions to help with process
control. Designed to be used when only process control and device execution states are needed. Does <em>not</em> need to
be initialized from <code>Accelerator</code>.`,wt,Ze,ws="<strong>Available attributes:</strong>",$t,Ne,$s=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,jt,se,_t,S,ye,Ut,Xe,js="Lets the local main process go inside a with block.",Jt,Pe,_s="The other processes will enter the with block after the main process exits.",Tt,ae,vt,G,be,xt,Qe,Us="Lets the main process go first inside a with block.",Bt,We,Js="The other processes will enter the with block after the main process exits.",Ct,ne,It,z,we,St,ze,Ts="Decorator that only runs the decorated function on the last process.",Gt,le,kt,F,$e,Et,Fe,vs="Decorator that only runs the decorated function on the local main process.",Zt,re,Nt,H,je,Xt,He,xs="Decorator that only runs the decorated function on the process with the given index on the current node.",Pt,oe,Qt,Y,_e,Wt,Ye,Bs="Decorator that only runs the decorated function on the main process.",zt,ce,Ft,R,Ue,Ht,Re,Cs="Decorator that only runs the decorated function on the process with the given index.",Yt,ie,Rt,pe,Je,Vt,Ve,Is="Sets the device in <code>self.device</code> to the current distributed environment.",qt,k,Te,At,qe,Ss=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,Dt,Ae,Gs="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",Lt,de,Kt,V,ve,Ot,De,ks=`Will stop the execution of the current process until every other process has reached that point (so this does
nothing when the script is only run in one process). Useful to do before saving a model.`,es,me,ut,T,xe,ts,Le,Es="Singleton class that has information about the current training environment.",ss,Ke,Zs="<strong>Available attributes:</strong>",as,Oe,Ns=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The type of distributed environment currently
in use.</li> <li><strong>initialized</strong> (<code>bool</code>) — Whether or not the <code>AcceleratorState</code> has been initialized from <code>Accelerator</code>.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The index of the current process on the current server.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — Whether or not the current script will use mixed precision, and if so the type
of mixed precision being performed. (Choose from ‘no’,‘fp16’,‘bf16 or ‘fp8’).</li> <li><strong>num_processes</strong> (<code>int</code>) — The number of processes currently launched in parallel.</li> <li><strong>process_index</strong> (<code>int</code>) — The index of the current process.</li> <li><strong>is_last_process</strong> (<code>bool</code>) — Whether or not the current process is the last one.</li> <li><strong>is_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one.</li> <li><strong>is_local_main_process</strong> (<code>bool</code>) — Whether or not the current process is the main one on the local node.</li> <li><strong>debug</strong> (<code>bool</code>) — Whether or not the current script is being run in debug mode.</li>`,ns,q,Be,ls,et,Xs="Lets the local main process go inside a with block.",rs,tt,Ps="The other processes will enter the with block after the main process exits.",os,A,Ce,cs,st,Qs="Lets the main process go first inside a with block.",is,at,Ws="The other processes will enter the with block after the main process exits.",ps,E,Ie,ds,nt,zs=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,ms,lt,Fs="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",hs,he,gt,I,Se,us,rt,Hs="Singleton class that has information related to gradient synchronization for gradient accumulation",gs,ot,Ys="<strong>Available attributes:</strong>",fs,ct,Rs=`<li><strong>end_of_dataloader</strong> (<code>bool</code>) — Whether we have reached the end the current dataloader</li> <li><strong>remainder</strong> (<code>int</code>) — The number of extra samples that were added from padding the dataloader</li> <li><strong>sync_gradients</strong> (<code>bool</code>) — Whether the gradients should be synced across all devices</li> <li><strong>active_dataloader</strong> (<code>Optional[DataLoader]</code>) — The dataloader that is currently being iterated over</li> <li><strong>dataloader_references</strong> (<code>List[Optional[DataLoader]]</code>) — A list of references to the dataloaders that are
being iterated over</li> <li><strong>num_steps</strong> (<code>int</code>) — The number of steps to accumulate over</li> <li><strong>adjust_scheduler</strong> (<code>bool</code>) — Whether the scheduler should be adjusted to account for the gradient
accumulation</li> <li><strong>sync_with_dataloader</strong> (<code>bool</code>) — Whether the gradients should be synced at the end of the dataloader
iteration and the number of total steps reset</li> <li><strong>is_xla_gradients_synced</strong> (<code>bool</code>) — Whether the XLA gradients have been synchronized. It is initialized
as false. Once gradients have been reduced before the optimizer step, this flag is set to true. Subsequently,
after each step, the flag is reset to false. FSDP will always synchronize the gradients, hence
is_xla_gradients_synced is always true.</li>`,ft,Ge,Mt,dt,yt;return o=new Ks({props:{title:"Stateful Classes",local:"accelerate.PartialState",headingTag:"h1"}}),Me=new B({props:{name:"class accelerate.PartialState",anchor:"accelerate.PartialState",parameters:[{name:"cpu",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"accelerate.PartialState.cpu",description:`<strong>cpu</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to force the script to execute on CPU. Will ignore any accelerators available if set to
<code>True</code> and force the execution on the CPU.`,name:"cpu"},{anchor:"accelerate.PartialState.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the relevent <code>init_process_group</code> function. Valid <code>kwargs</code> can be
found in <a href="/docs/accelerate/main/en/package_reference/kwargs#accelerate.InitProcessGroupKwargs">utils.InitProcessGroupKwargs</a>. See the example section for detailed usage.`,name:"kwargs"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L110"}}),se=new P({props:{anchor:"accelerate.PartialState.example",$$slots:{default:[ea]},$$scope:{ctx:J}}}),ye=new B({props:{name:"local_main_process_first",anchor:"accelerate.PartialState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L501"}}),ae=new P({props:{anchor:"accelerate.PartialState.local_main_process_first.example",$$slots:{default:[ta]},$$scope:{ctx:J}}}),be=new B({props:{name:"main_process_first",anchor:"accelerate.PartialState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L480"}}),ne=new P({props:{anchor:"accelerate.PartialState.main_process_first.example",$$slots:{default:[sa]},$$scope:{ctx:J}}}),we=new B({props:{name:"on_last_process",anchor:"accelerate.PartialState.on_last_process",parameters:[{name:"function",val:": Callable[..., Any]"}],parametersDescription:[{anchor:"accelerate.PartialState.on_last_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L583"}}),le=new P({props:{anchor:"accelerate.PartialState.on_last_process.example",$$slots:{default:[aa]},$$scope:{ctx:J}}}),$e=new B({props:{name:"on_local_main_process",anchor:"accelerate.PartialState.on_local_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L552"}}),re=new P({props:{anchor:"accelerate.PartialState.on_local_main_process.example",$$slots:{default:[na]},$$scope:{ctx:J}}}),je=new B({props:{name:"on_local_process",anchor:"accelerate.PartialState.on_local_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"local_process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_local_process.function",description:`<strong>function</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_local_process.local_process_index",description:`<strong>local_process_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the local process on which to run the function.`,name:"local_process_index"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L644"}}),oe=new P({props:{anchor:"accelerate.PartialState.on_local_process.example",$$slots:{default:[la]},$$scope:{ctx:J}}}),_e=new B({props:{name:"on_main_process",anchor:"accelerate.PartialState.on_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L522"}}),ce=new P({props:{anchor:"accelerate.PartialState.on_main_process.example",$$slots:{default:[ra]},$$scope:{ctx:J}}}),Ue=new B({props:{name:"on_process",anchor:"accelerate.PartialState.on_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.PartialState.on_process.function",description:`<strong>function</strong> (<code>Callable</code>, <code>optional</code>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.PartialState.on_process.process_index",description:`<strong>process_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The index of the process on which to run the function.`,name:"process_index"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L611"}}),ie=new P({props:{anchor:"accelerate.PartialState.on_process.example",$$slots:{default:[oa]},$$scope:{ctx:J}}}),Je=new B({props:{name:"set_device",anchor:"accelerate.PartialState.set_device",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L762"}}),Te=new B({props:{name:"split_between_processes",anchor:"accelerate.PartialState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.PartialState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>, or <code>datasets.Dataset</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.PartialState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L391"}}),de=new P({props:{anchor:"accelerate.PartialState.split_between_processes.example",$$slots:{default:[ca]},$$scope:{ctx:J}}}),ve=new B({props:{name:"wait_for_everyone",anchor:"accelerate.PartialState.wait_for_everyone",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L347"}}),me=new P({props:{anchor:"accelerate.PartialState.wait_for_everyone.example",$$slots:{default:[ia]},$$scope:{ctx:J}}}),xe=new B({props:{name:"class accelerate.state.AcceleratorState",anchor:"accelerate.state.AcceleratorState",parameters:[{name:"mixed_precision",val:": str = None"},{name:"cpu",val:": bool = False"},{name:"dynamo_plugin",val:" = None"},{name:"deepspeed_plugin",val:" = None"},{name:"fsdp_plugin",val:" = None"},{name:"megatron_lm_plugin",val:" = None"},{name:"_from_accelerator",val:": bool = False"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L805"}}),Be=new B({props:{name:"local_main_process_first",anchor:"accelerate.state.AcceleratorState.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L1056"}}),Ce=new B({props:{name:"main_process_first",anchor:"accelerate.state.AcceleratorState.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L1046"}}),Ie=new B({props:{name:"split_between_processes",anchor:"accelerate.state.AcceleratorState.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.state.AcceleratorState.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, or <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.state.AcceleratorState.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>gather()</code> on the outputs or passing
in less inputs than there are processes. If so, just remember to drop the padded elements afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L1004"}}),he=new P({props:{anchor:"accelerate.state.AcceleratorState.split_between_processes.example",$$slots:{default:[pa]},$$scope:{ctx:J}}}),Se=new B({props:{name:"class accelerate.state.GradientState",anchor:"accelerate.state.GradientState",parameters:[{name:"gradient_accumulation_plugin",val:": Optional[GradientAccumulationPlugin] = None"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/state.py#L1082"}}),Ge=new Os({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/package_reference/state.md"}}),{c(){s=i("meta"),j=l(),c=i("p"),n=l(),g(o.$$.fragment),e=l(),m=i("p"),m.innerHTML=Ms,mt=l(),fe=i("p"),fe.textContent=ys,ht=l(),_=i("div"),g(Me.$$.fragment),bt=l(),Ee=i("p"),Ee.innerHTML=bs,wt=l(),Ze=i("p"),Ze.innerHTML=ws,$t=l(),Ne=i("ul"),Ne.innerHTML=$s,jt=l(),g(se.$$.fragment),_t=l(),S=i("div"),g(ye.$$.fragment),Ut=l(),Xe=i("p"),Xe.textContent=js,Jt=l(),Pe=i("p"),Pe.textContent=_s,Tt=l(),g(ae.$$.fragment),vt=l(),G=i("div"),g(be.$$.fragment),xt=l(),Qe=i("p"),Qe.textContent=Us,Bt=l(),We=i("p"),We.textContent=Js,Ct=l(),g(ne.$$.fragment),It=l(),z=i("div"),g(we.$$.fragment),St=l(),ze=i("p"),ze.textContent=Ts,Gt=l(),g(le.$$.fragment),kt=l(),F=i("div"),g($e.$$.fragment),Et=l(),Fe=i("p"),Fe.textContent=vs,Zt=l(),g(re.$$.fragment),Nt=l(),H=i("div"),g(je.$$.fragment),Xt=l(),He=i("p"),He.textContent=xs,Pt=l(),g(oe.$$.fragment),Qt=l(),Y=i("div"),g(_e.$$.fragment),Wt=l(),Ye=i("p"),Ye.textContent=Bs,zt=l(),g(ce.$$.fragment),Ft=l(),R=i("div"),g(Ue.$$.fragment),Ht=l(),Re=i("p"),Re.textContent=Cs,Yt=l(),g(ie.$$.fragment),Rt=l(),pe=i("div"),g(Je.$$.fragment),Vt=l(),Ve=i("p"),Ve.innerHTML=Is,qt=l(),k=i("div"),g(Te.$$.fragment),At=l(),qe=i("p"),qe.innerHTML=Ss,Dt=l(),Ae=i("p"),Ae.innerHTML=Gs,Lt=l(),g(de.$$.fragment),Kt=l(),V=i("div"),g(ve.$$.fragment),Ot=l(),De=i("p"),De.textContent=ks,es=l(),g(me.$$.fragment),ut=l(),T=i("div"),g(xe.$$.fragment),ts=l(),Le=i("p"),Le.textContent=Es,ss=l(),Ke=i("p"),Ke.innerHTML=Zs,as=l(),Oe=i("ul"),Oe.innerHTML=Ns,ns=l(),q=i("div"),g(Be.$$.fragment),ls=l(),et=i("p"),et.textContent=Xs,rs=l(),tt=i("p"),tt.textContent=Ps,os=l(),A=i("div"),g(Ce.$$.fragment),cs=l(),st=i("p"),st.textContent=Qs,is=l(),at=i("p"),at.textContent=Ws,ps=l(),E=i("div"),g(Ie.$$.fragment),ds=l(),nt=i("p"),nt.innerHTML=zs,ms=l(),lt=i("p"),lt.innerHTML=Fs,hs=l(),g(he.$$.fragment),gt=l(),I=i("div"),g(Se.$$.fragment),us=l(),rt=i("p"),rt.textContent=Hs,gs=l(),ot=i("p"),ot.innerHTML=Ys,fs=l(),ct=i("ul"),ct.innerHTML=Rs,ft=l(),g(Ge.$$.fragment),Mt=l(),dt=i("p"),this.h()},l(t){const h=Ls("svelte-u9bgzb",document.head);s=p(h,"META",{name:!0,content:!0}),h.forEach(d),j=r(t),c=p(t,"P",{}),v(c).forEach(d),n=r(t),f(o.$$.fragment,t),e=r(t),m=p(t,"P",{"data-svelte-h":!0}),u(m)!=="svelte-6w5h2d"&&(m.innerHTML=Ms),mt=r(t),fe=p(t,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-n5bwiq"&&(fe.textContent=ys),ht=r(t),_=p(t,"DIV",{class:!0});var U=v(_);f(Me.$$.fragment,U),bt=r(U),Ee=p(U,"P",{"data-svelte-h":!0}),u(Ee)!=="svelte-b0lfuj"&&(Ee.innerHTML=bs),wt=r(U),Ze=p(U,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-17v1xbv"&&(Ze.innerHTML=ws),$t=r(U),Ne=p(U,"UL",{"data-svelte-h":!0}),u(Ne)!=="svelte-18rbzsd"&&(Ne.innerHTML=$s),jt=r(U),f(se.$$.fragment,U),_t=r(U),S=p(U,"DIV",{class:!0});var Z=v(S);f(ye.$$.fragment,Z),Ut=r(Z),Xe=p(Z,"P",{"data-svelte-h":!0}),u(Xe)!=="svelte-1xrqyx2"&&(Xe.textContent=js),Jt=r(Z),Pe=p(Z,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-144ycie"&&(Pe.textContent=_s),Tt=r(Z),f(ae.$$.fragment,Z),Z.forEach(d),vt=r(U),G=p(U,"DIV",{class:!0});var N=v(G);f(be.$$.fragment,N),xt=r(N),Qe=p(N,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-f40x3x"&&(Qe.textContent=Us),Bt=r(N),We=p(N,"P",{"data-svelte-h":!0}),u(We)!=="svelte-144ycie"&&(We.textContent=Js),Ct=r(N),f(ne.$$.fragment,N),N.forEach(d),It=r(U),z=p(U,"DIV",{class:!0});var D=v(z);f(we.$$.fragment,D),St=r(D),ze=p(D,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-15mu2x9"&&(ze.textContent=Ts),Gt=r(D),f(le.$$.fragment,D),D.forEach(d),kt=r(U),F=p(U,"DIV",{class:!0});var L=v(F);f($e.$$.fragment,L),Et=r(L),Fe=p(L,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-10pbn0p"&&(Fe.textContent=vs),Zt=r(L),f(re.$$.fragment,L),L.forEach(d),Nt=r(U),H=p(U,"DIV",{class:!0});var K=v(H);f(je.$$.fragment,K),Xt=r(K),He=p(K,"P",{"data-svelte-h":!0}),u(He)!=="svelte-3g0as"&&(He.textContent=xs),Pt=r(K),f(oe.$$.fragment,K),K.forEach(d),Qt=r(U),Y=p(U,"DIV",{class:!0});var O=v(Y);f(_e.$$.fragment,O),Wt=r(O),Ye=p(O,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-1dr4vmg"&&(Ye.textContent=Bs),zt=r(O),f(ce.$$.fragment,O),O.forEach(d),Ft=r(U),R=p(U,"DIV",{class:!0});var ee=v(R);f(Ue.$$.fragment,ee),Ht=r(ee),Re=p(ee,"P",{"data-svelte-h":!0}),u(Re)!=="svelte-1uajfn5"&&(Re.textContent=Cs),Yt=r(ee),f(ie.$$.fragment,ee),ee.forEach(d),Rt=r(U),pe=p(U,"DIV",{class:!0});var ke=v(pe);f(Je.$$.fragment,ke),Vt=r(ke),Ve=p(ke,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-1ylvgoj"&&(Ve.innerHTML=Is),ke.forEach(d),qt=r(U),k=p(U,"DIV",{class:!0});var X=v(k);f(Te.$$.fragment,X),At=r(X),qe=p(X,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-xr05jy"&&(qe.innerHTML=Ss),Dt=r(X),Ae=p(X,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-hvuw2l"&&(Ae.innerHTML=Gs),Lt=r(X),f(de.$$.fragment,X),X.forEach(d),Kt=r(U),V=p(U,"DIV",{class:!0});var te=v(V);f(ve.$$.fragment,te),Ot=r(te),De=p(te,"P",{"data-svelte-h":!0}),u(De)!=="svelte-tmafbn"&&(De.textContent=ks),es=r(te),f(me.$$.fragment,te),te.forEach(d),U.forEach(d),ut=r(t),T=p(t,"DIV",{class:!0});var C=v(T);f(xe.$$.fragment,C),ts=r(C),Le=p(C,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-x2ar5c"&&(Le.textContent=Es),ss=r(C),Ke=p(C,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-17v1xbv"&&(Ke.innerHTML=Zs),as=r(C),Oe=p(C,"UL",{"data-svelte-h":!0}),u(Oe)!=="svelte-1hqqd7a"&&(Oe.innerHTML=Ns),ns=r(C),q=p(C,"DIV",{class:!0});var it=v(q);f(Be.$$.fragment,it),ls=r(it),et=p(it,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1xrqyx2"&&(et.textContent=Xs),rs=r(it),tt=p(it,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-144ycie"&&(tt.textContent=Ps),it.forEach(d),os=r(C),A=p(C,"DIV",{class:!0});var pt=v(A);f(Ce.$$.fragment,pt),cs=r(pt),st=p(pt,"P",{"data-svelte-h":!0}),u(st)!=="svelte-f40x3x"&&(st.textContent=Qs),is=r(pt),at=p(pt,"P",{"data-svelte-h":!0}),u(at)!=="svelte-144ycie"&&(at.textContent=Ws),pt.forEach(d),ps=r(C),E=p(C,"DIV",{class:!0});var ue=v(E);f(Ie.$$.fragment,ue),ds=r(ue),nt=p(ue,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-xr05jy"&&(nt.innerHTML=zs),ms=r(ue),lt=p(ue,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-hvuw2l"&&(lt.innerHTML=Fs),hs=r(ue),f(he.$$.fragment,ue),ue.forEach(d),C.forEach(d),gt=r(t),I=p(t,"DIV",{class:!0});var ge=v(I);f(Se.$$.fragment,ge),us=r(ge),rt=p(ge,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-1pw2ldw"&&(rt.textContent=Hs),gs=r(ge),ot=p(ge,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-17v1xbv"&&(ot.innerHTML=Ys),fs=r(ge),ct=p(ge,"UL",{"data-svelte-h":!0}),u(ct)!=="svelte-kdkw1r"&&(ct.innerHTML=Rs),ge.forEach(d),ft=r(t),f(Ge.$$.fragment,t),Mt=r(t),dt=p(t,"P",{}),v(dt).forEach(d),this.h()},h(){x(s,"name","hf:doc:metadata"),x(s,"content",ma),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,h){a(document.head,s),$(t,j,h),$(t,c,h),$(t,n,h),M(o,t,h),$(t,e,h),$(t,m,h),$(t,mt,h),$(t,fe,h),$(t,ht,h),$(t,_,h),M(Me,_,null),a(_,bt),a(_,Ee),a(_,wt),a(_,Ze),a(_,$t),a(_,Ne),a(_,jt),M(se,_,null),a(_,_t),a(_,S),M(ye,S,null),a(S,Ut),a(S,Xe),a(S,Jt),a(S,Pe),a(S,Tt),M(ae,S,null),a(_,vt),a(_,G),M(be,G,null),a(G,xt),a(G,Qe),a(G,Bt),a(G,We),a(G,Ct),M(ne,G,null),a(_,It),a(_,z),M(we,z,null),a(z,St),a(z,ze),a(z,Gt),M(le,z,null),a(_,kt),a(_,F),M($e,F,null),a(F,Et),a(F,Fe),a(F,Zt),M(re,F,null),a(_,Nt),a(_,H),M(je,H,null),a(H,Xt),a(H,He),a(H,Pt),M(oe,H,null),a(_,Qt),a(_,Y),M(_e,Y,null),a(Y,Wt),a(Y,Ye),a(Y,zt),M(ce,Y,null),a(_,Ft),a(_,R),M(Ue,R,null),a(R,Ht),a(R,Re),a(R,Yt),M(ie,R,null),a(_,Rt),a(_,pe),M(Je,pe,null),a(pe,Vt),a(pe,Ve),a(_,qt),a(_,k),M(Te,k,null),a(k,At),a(k,qe),a(k,Dt),a(k,Ae),a(k,Lt),M(de,k,null),a(_,Kt),a(_,V),M(ve,V,null),a(V,Ot),a(V,De),a(V,es),M(me,V,null),$(t,ut,h),$(t,T,h),M(xe,T,null),a(T,ts),a(T,Le),a(T,ss),a(T,Ke),a(T,as),a(T,Oe),a(T,ns),a(T,q),M(Be,q,null),a(q,ls),a(q,et),a(q,rs),a(q,tt),a(T,os),a(T,A),M(Ce,A,null),a(A,cs),a(A,st),a(A,is),a(A,at),a(T,ps),a(T,E),M(Ie,E,null),a(E,ds),a(E,nt),a(E,ms),a(E,lt),a(E,hs),M(he,E,null),$(t,gt,h),$(t,I,h),M(Se,I,null),a(I,us),a(I,rt),a(I,gs),a(I,ot),a(I,fs),a(I,ct),$(t,ft,h),M(Ge,t,h),$(t,Mt,h),$(t,dt,h),yt=!0},p(t,[h]){const U={};h&2&&(U.$$scope={dirty:h,ctx:t}),se.$set(U);const Z={};h&2&&(Z.$$scope={dirty:h,ctx:t}),ae.$set(Z);const N={};h&2&&(N.$$scope={dirty:h,ctx:t}),ne.$set(N);const D={};h&2&&(D.$$scope={dirty:h,ctx:t}),le.$set(D);const L={};h&2&&(L.$$scope={dirty:h,ctx:t}),re.$set(L);const K={};h&2&&(K.$$scope={dirty:h,ctx:t}),oe.$set(K);const O={};h&2&&(O.$$scope={dirty:h,ctx:t}),ce.$set(O);const ee={};h&2&&(ee.$$scope={dirty:h,ctx:t}),ie.$set(ee);const ke={};h&2&&(ke.$$scope={dirty:h,ctx:t}),de.$set(ke);const X={};h&2&&(X.$$scope={dirty:h,ctx:t}),me.$set(X);const te={};h&2&&(te.$$scope={dirty:h,ctx:t}),he.$set(te)},i(t){yt||(y(o.$$.fragment,t),y(Me.$$.fragment,t),y(se.$$.fragment,t),y(ye.$$.fragment,t),y(ae.$$.fragment,t),y(be.$$.fragment,t),y(ne.$$.fragment,t),y(we.$$.fragment,t),y(le.$$.fragment,t),y($e.$$.fragment,t),y(re.$$.fragment,t),y(je.$$.fragment,t),y(oe.$$.fragment,t),y(_e.$$.fragment,t),y(ce.$$.fragment,t),y(Ue.$$.fragment,t),y(ie.$$.fragment,t),y(Je.$$.fragment,t),y(Te.$$.fragment,t),y(de.$$.fragment,t),y(ve.$$.fragment,t),y(me.$$.fragment,t),y(xe.$$.fragment,t),y(Be.$$.fragment,t),y(Ce.$$.fragment,t),y(Ie.$$.fragment,t),y(he.$$.fragment,t),y(Se.$$.fragment,t),y(Ge.$$.fragment,t),yt=!0)},o(t){b(o.$$.fragment,t),b(Me.$$.fragment,t),b(se.$$.fragment,t),b(ye.$$.fragment,t),b(ae.$$.fragment,t),b(be.$$.fragment,t),b(ne.$$.fragment,t),b(we.$$.fragment,t),b(le.$$.fragment,t),b($e.$$.fragment,t),b(re.$$.fragment,t),b(je.$$.fragment,t),b(oe.$$.fragment,t),b(_e.$$.fragment,t),b(ce.$$.fragment,t),b(Ue.$$.fragment,t),b(ie.$$.fragment,t),b(Je.$$.fragment,t),b(Te.$$.fragment,t),b(de.$$.fragment,t),b(ve.$$.fragment,t),b(me.$$.fragment,t),b(xe.$$.fragment,t),b(Be.$$.fragment,t),b(Ce.$$.fragment,t),b(Ie.$$.fragment,t),b(he.$$.fragment,t),b(Se.$$.fragment,t),b(Ge.$$.fragment,t),yt=!1},d(t){t&&(d(j),d(c),d(n),d(e),d(m),d(mt),d(fe),d(ht),d(_),d(ut),d(T),d(gt),d(I),d(ft),d(Mt),d(dt)),d(s),w(o,t),w(Me),w(se),w(ye),w(ae),w(be),w(ne),w(we),w(le),w($e),w(re),w(je),w(oe),w(_e),w(ce),w(Ue),w(ie),w(Je),w(Te),w(de),w(ve),w(me),w(xe),w(Be),w(Ce),w(Ie),w(he),w(Se),w(Ge,t)}}}const ma='{"title":"Stateful Classes","local":"accelerate.PartialState","sections":[],"depth":1}';function ha(J){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends As{constructor(s){super(),Ds(this,s,ha,da,Vs,{})}}export{wa as component};
