import{s as At,o as Wt,n as nt}from"../chunks/scheduler.22bf70d2.js";import{S as Xt,i as Rt,g as $,s as c,r as f,A as Yt,h as g,f as a,c as n,j as Gt,u,x as b,k as Zt,y as Ht,a as l,v as h,d as y,t as M,w}from"../chunks/index.59178e06.js";import{T as it}from"../chunks/Tip.75d940ba.js";import{C as k}from"../chunks/CodeBlock.f7047b13.js";import{H as C,E as Vt}from"../chunks/EditOnGithub.86314611.js";import{H as Bt,a as It}from"../chunks/HfOption.04cc3620.js";function zt(j){let r,T="Accelerate only prepares objects that inherit from their respective PyTorch classes such as <code>torch.optim.Optimizer</code>.";return{c(){r=$("p"),r.innerHTML=T},l(o){r=g(o,"P",{"data-svelte-h":!0}),b(r)!=="svelte-1oh2ah6"&&(r.innerHTML=T)},m(o,m){l(o,r,m)},p:nt,d(o){o&&a(r)}}}function xt(j){let r,T='Accelerate enables automatic mixed precision, so <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> is only needed if there are other mixed precision operations besides those performed on loss by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> which already handles the scaling.';return{c(){r=$("p"),r.innerHTML=T},l(o){r=g(o,"P",{"data-svelte-h":!0}),b(r)!=="svelte-17p4of7"&&(r.innerHTML=T)},m(o,m){l(o,r,m)},p:nt,d(o){o&&a(r)}}}function Ft(j){let r,T='For models from the <a href="https://hf.co/docs/transformers/index" rel="nofollow">Transformers</a> library, save the model with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> method so that it can be reloaded with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method.',o,m,i;return m=new k({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQXVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEF1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnBhdGglMkZ0byUyRm15X21vZGVsX2RpcmVjdG9yeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),{c(){r=$("p"),r.innerHTML=T,o=c(),f(m.$$.fragment)},l(p){r=g(p,"P",{"data-svelte-h":!0}),b(r)!=="svelte-y3y63b"&&(r.innerHTML=T),o=n(p),u(m.$$.fragment,p)},m(p,U){l(p,r,U),l(p,o,U),h(m,p,U),i=!0},p:nt,i(p){i||(y(m.$$.fragment,p),i=!0)},o(p){M(m.$$.fragment,p),i=!1},d(p){p&&(a(r),a(o)),w(m,p)}}}function Qt(j){let r,T,o,m,i,p='To load your weights, use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method to unwrap the model first before loading the weights. All model parameters are references to tensors, so this loads your weights inside <code>model</code>.',U,J,_;return r=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory)`,wrap:!1}}),o=new it({props:{$$slots:{default:[Ft]},$$scope:{ctx:j}}}),J=new k({props:{code:"dW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXBhdGhfdG9fY2hlY2twb2ludCUyMCUzRCUyMG9zLnBhdGguam9pbihzYXZlX2RpcmVjdG9yeSUyQyUyMnB5dG9yY2hfbW9kZWwuYmluJTIyKSUwQXVud3JhcHBlZF9tb2RlbC5sb2FkX3N0YXRlX2RpY3QodG9yY2gubG9hZChwYXRoX3RvX2NoZWNrcG9pbnQpKQ==",highlighted:`unwrapped_model = accelerator.unwrap_model(model)
path_to_checkpoint = os.path.join(save_directory,<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
unwrapped_model.load_state_dict(torch.load(path_to_checkpoint))`,wrap:!1}}),{c(){f(r.$$.fragment),T=c(),f(o.$$.fragment),m=c(),i=$("p"),i.innerHTML=p,U=c(),f(J.$$.fragment)},l(s){u(r.$$.fragment,s),T=n(s),u(o.$$.fragment,s),m=n(s),i=g(s,"P",{"data-svelte-h":!0}),b(i)!=="svelte-js2qkb"&&(i.innerHTML=p),U=n(s),u(J.$$.fragment,s)},m(s,d){h(r,s,d),l(s,T,d),h(o,s,d),l(s,m,d),l(s,i,d),l(s,U,d),h(J,s,d),_=!0},p(s,d){const v={};d&2&&(v.$$scope={dirty:d,ctx:s}),o.$set(v)},i(s){_||(y(r.$$.fragment,s),y(o.$$.fragment,s),y(J.$$.fragment,s),_=!0)},o(s){M(r.$$.fragment,s),M(o.$$.fragment,s),M(J.$$.fragment,s),_=!1},d(s){s&&(a(T),a(m),a(i),a(U)),w(r,s),w(o,s),w(J,s)}}}function St(j){let r,T="Set <code>safe_serialization=True</code> to save the model in the safetensor format.",o,m,i,p,U='To load a sharded checkpoint or a safetensor formatted checkpoint, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> method. This method allows you to load a checkpoint onto a specific device.',J,_,s;return m=new k({props:{code:"YWNjZWxlcmF0b3Iud2FpdF9mb3JfZXZlcnlvbmUoKSUwQWFjY2VsZXJhdG9yLnNhdmVfbW9kZWwobW9kZWwlMkMlMjBzYXZlX2RpcmVjdG9yeSUyQyUyMG1heF9zaGFyZF9zaXplJTNEJTIyMUdCJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNEVHJ1ZSk=",highlighted:`accelerator.wait_for_everyone()
accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new k({props:{code:"bG9hZF9jaGVja3BvaW50X2luX21vZGVsKHVud3JhcHBlZF9tb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwZGV2aWNlX21hcCUzRCU3QiUyMiUyMiUzQWRldmljZSU3RCk=",highlighted:'load_checkpoint_in_model(unwrapped_model, save_directory, device_map={<span class="hljs-string">&quot;&quot;</span>:device})',wrap:!1}}),{c(){r=$("p"),r.innerHTML=T,o=c(),f(m.$$.fragment),i=c(),p=$("p"),p.innerHTML=U,J=c(),f(_.$$.fragment)},l(d){r=g(d,"P",{"data-svelte-h":!0}),b(r)!=="svelte-jahj75"&&(r.innerHTML=T),o=n(d),u(m.$$.fragment,d),i=n(d),p=g(d,"P",{"data-svelte-h":!0}),b(p)!=="svelte-1f8c9zt"&&(p.innerHTML=U),J=n(d),u(_.$$.fragment,d)},m(d,v){l(d,r,v),l(d,o,v),h(m,d,v),l(d,i,v),l(d,p,v),l(d,J,v),h(_,d,v),s=!0},p:nt,i(d){s||(y(m.$$.fragment,d),y(_.$$.fragment,d),s=!0)},o(d){M(m.$$.fragment,d),M(_.$$.fragment,d),s=!1},d(d){d&&(a(r),a(o),a(i),a(p),a(J)),w(m,d),w(_,d)}}}function Nt(j){let r,T,o,m;return r=new It({props:{id:"save",option:"single checkpoint",$$slots:{default:[Qt]},$$scope:{ctx:j}}}),o=new It({props:{id:"save",option:"sharded checkpoint",$$slots:{default:[St]},$$scope:{ctx:j}}}),{c(){f(r.$$.fragment),T=c(),f(o.$$.fragment)},l(i){u(r.$$.fragment,i),T=n(i),u(o.$$.fragment,i)},m(i,p){h(r,i,p),l(i,T,p),h(o,i,p),m=!0},p(i,p){const U={};p&2&&(U.$$scope={dirty:p,ctx:i}),r.$set(U);const J={};p&2&&(J.$$scope={dirty:p,ctx:i}),o.$set(J)},i(i){m||(y(r.$$.fragment,i),y(o.$$.fragment,i),m=!0)},o(i){M(r.$$.fragment,i),M(o.$$.fragment,i),m=!1},d(i){i&&a(T),w(r,i),w(o,i)}}}function Lt(j){let r,T,o,m,i,p,U,J="Each distributed training framework has their own way of doing things which can require writing a lot of custom code to adapt it to your PyTorch training code and training environment. Accelerate offers a friendly way to interface with these distributed training frameworks without having to learn the specific details of each one. Accelerate takes care of those details for you, so you can focus on the training code and scale it to any distributed training environment.",_,s,d="In this tutorial, you’ll learn how to adapt your existing PyTorch code with Accelerate and get you on your way toward training on distributed systems with ease! You’ll start with a basic PyTorch training loop (it assumes all the training objects like <code>model</code> and <code>optimizer</code> have been setup already) and progressively integrate Accelerate into it.",v,A,we,W,$e,X,ot='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class for adapting your code to work with Accelerate. It knows about the distributed setup you’re using such as the number of different processes and your hardware type. This class also provides access to many of the necessary methods for enabling your PyTorch code to work in any distributed training environment and for managing and executing processes across devices.',ge,R,st='That’s why you should always start by importing and creating an <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> instance in your script.',be,Y,Te,H,pt='The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> also knows which device to move your PyTorch objects to, so it is recommended to let Accelerate handle this for you.',Ue,V,Je,B,_e,z,dt='Next, you need to prepare your PyTorch objects (model, optimizer, scheduler, etc.) for distributed training. The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method takes care of placing your model in the appropriate container (like single GPU or multi-GPU) for your training setup, adapting the optimizer and scheduler to use Accelerate’s <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.optimizer.AcceleratedOptimizer">AcceleratedOptimizer</a> and <a href="/docs/accelerate/main/en/package_reference/torch_wrappers#accelerate.scheduler.AcceleratedScheduler">AcceleratedScheduler</a>, and creating a new dataloader that can be sharded across processes.',ve,G,je,x,mt="The PyTorch objects are returned in the same order they’re sent.",ke,F,Ce,Q,Ge,S,ft='Finally, remove the <code>to(device)</code> calls to the inputs and targets in the training loop because Accelerate’s DataLoader classes automatically places them on the right device. You should also replace the usual <code>backward()</code> pass with Accelerate’s <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a> method which scales the gradients for you and uses the appropriate <code>backward()</code> method depending on your distributed setup (for example, DeepSpeed or Megatron).',Ze,N,Ie,L,ut="Put everything together and your new Accelerate training loop should now look like this!",Ae,E,We,P,Xe,K,ht="Accelerate offers additional features - like gradient accumulation, gradient clipping, mixed precision training and more - you can add to your script to improve your training run. Let’s explore these three features.",Re,q,Ye,D,yt='Gradient accumulation enables you to train on larger batch sizes by accumulating the gradients over multiple batches before updating the weights. This can be useful for getting around memory limitations. To enable this feature in Accelerate, specify the <code>gradient_accumulation_steps</code> parameter in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> class and add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager to your script.',He,O,Ve,ee,Be,te,Mt="Gradient clipping is a technique to prevent “exploding gradients”, and Accelerate offers:",ze,ae,wt='<li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> to clip gradients to a minimum and maximum value</li> <li><a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> for normalizing gradients to a certain value</li>',xe,le,Fe,re,$t="Mixed precision accelerates training by using a lower precision data type like fp16 (half-precision) to calculate the gradients. For the best performance with Accelerate, the loss should be computed inside your model (like in Transformers models) because computations outside of the model are computed in full precision.",Qe,ce,gt='Set the mixed precision type to use in the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, and then use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.autocast">autocast()</a> context manager to automatically cast the values to the specified data type.',Se,Z,Ne,ne,Le,ie,Ee,oe,bt="Accelerate can also save and load a <em>model</em> once training is complete or you can also save the model and optimizer <em>state</em> which could be useful for resuming training.",Pe,se,Ke,pe,Tt='Once all processes are complete, unwrap the model with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.unwrap_model">unwrap_model()</a> method before saving it because the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method wrapped your model into the proper interface for distributed training. If you don’t unwrap the model, saving the model state dictionary also saves any potential extra layers from the larger model and you won’t be able to load the weights back into your base model.',qe,de,Ut='You should use the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> method to unwrap and save the model state dictionary. This method can also save a model into sharded checkpoints or into the <a href="https://hf.co/docs/safetensors/index" rel="nofollow">safetensors</a> format.',De,I,Oe,me,et,fe,Jt='During training, you may want to save the current state of the model, optimizer, random generators, and potentially learning rate schedulers so they can be restored in the <em>same script</em>. You should add the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> methods to your script to save and load states.',tt,ue,_t='To further customize where and how states are saved through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a>, use the <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class. For example, if <code>automatic_checkpoint_naming</code> is enabled, each saved checkpoint is stored at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.',at,he,vt='Any other stateful items to be stored should be registered with the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a> method so they can be saved and loaded. Every object passed to this method to be stored must have a <code>load_state_dict</code> and <code>state_dict</code> function.',lt,ye,rt,Me,ct;return i=new C({props:{title:"Add Accelerate to your code",local:"add-accelerate-to-your-code",headingTag:"h1"}}),A=new k({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0cyUyMCUzRCUyMHRhcmdldHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss.backward()
    optimizer.step()
    scheduler.step()`,wrap:!1}}),W=new C({props:{title:"Accelerator",local:"accelerator",headingTag:"h2"}}),Y=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()`,wrap:!1}}),V=new k({props:{code:"LSUyMGRldmljZSUyMCUzRCUyMCUyMmN1ZGElMjIlMEElMkIlMjBkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEElMjAlMjBtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-deletion">- device = &quot;cuda&quot;</span>
<span class="hljs-addition">+ device = accelerator.device</span>
  model.to(device)`,wrap:!1}}),B=new C({props:{title:"Prepare PyTorch objects",local:"prepare-pytorch-objects",headingTag:"h2"}}),G=new it({props:{warning:!1,$$slots:{default:[zt]},$$scope:{ctx:j}}}),F=new k({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMEEp",highlighted:`model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)`,wrap:!1}}),Q=new C({props:{title:"Training loop",local:"training-loop",headingTag:"h2"}}),N=new k({props:{code:"LSUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy50byhkZXZpY2UpJTBBLSUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQS0lMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMkIlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKQ==",highlighted:`<span class="hljs-deletion">-   inputs = inputs.to(device)</span>
<span class="hljs-deletion">-   targets = targets.to(device)</span>
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
<span class="hljs-deletion">-   loss.backward()</span>
<span class="hljs-addition">+   accelerator.backward(loss)</span>`,wrap:!1}}),E=new k({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQWRldmljZSUyMCUzRCUyMGFjY2VsZXJhdG9yLmRldmljZSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBKSUwQSUwQWZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjBzY2hlZHVsZXIuc3RlcCgp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator()

device = accelerator.device
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)

<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    optimizer.zero_grad()
    inputs, targets = batch
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    accelerator.backward(loss)
    optimizer.step()
    scheduler.step()`,wrap:!1}}),P=new C({props:{title:"Training features",local:"training-features",headingTag:"h2"}}),q=new C({props:{title:"Gradient accumulation",local:"gradient-accumulation",headingTag:"h3"}}),O=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QyKSUwQSUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMCUyMGZvciUyMGlucHV0JTJDJTIwbGFiZWwlMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>
  model, optimizer, training_dataloader = accelerator.prepare(model, optimizer, training_dataloader)

  for input, label in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, label)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),ee=new C({props:{title:"Gradient clipping",local:"gradient-clipping",headingTag:"h3"}}),le=new C({props:{title:"Mixed precision",local:"mixed-precision",headingTag:"h3"}}),Z=new it({props:{warning:!0,$$slots:{default:[xt]},$$scope:{ctx:j}}}),ne=new k({props:{code:"JTJCJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyKSUwQSUyQiUyMHdpdGglMjBhY2NlbGVyYXRvci5hdXRvY2FzdCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNvbXBsZXhfbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0KSUzQQ==",highlighted:`<span class="hljs-addition">+ accelerator = Accelerator(mixed_precision=&quot;fp16&quot;)</span>
<span class="hljs-addition">+ with accelerator.autocast():</span>
      loss = complex_loss_function(outputs, target):`,wrap:!1}}),ie=new C({props:{title:"Save and load",local:"save-and-load",headingTag:"h2"}}),se=new C({props:{title:"Model",local:"model",headingTag:"h3"}}),I=new Bt({props:{id:"save",options:["single checkpoint","sharded checkpoint"],$$slots:{default:[Nt]},$$scope:{ctx:j}}}),me=new C({props:{title:"State",local:"state",headingTag:"h3"}}),ye=new Vt({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/migration.md"}}),{c(){r=$("meta"),T=c(),o=$("p"),m=c(),f(i.$$.fragment),p=c(),U=$("p"),U.textContent=J,_=c(),s=$("p"),s.innerHTML=d,v=c(),f(A.$$.fragment),we=c(),f(W.$$.fragment),$e=c(),X=$("p"),X.innerHTML=ot,ge=c(),R=$("p"),R.innerHTML=st,be=c(),f(Y.$$.fragment),Te=c(),H=$("p"),H.innerHTML=pt,Ue=c(),f(V.$$.fragment),Je=c(),f(B.$$.fragment),_e=c(),z=$("p"),z.innerHTML=dt,ve=c(),f(G.$$.fragment),je=c(),x=$("p"),x.textContent=mt,ke=c(),f(F.$$.fragment),Ce=c(),f(Q.$$.fragment),Ge=c(),S=$("p"),S.innerHTML=ft,Ze=c(),f(N.$$.fragment),Ie=c(),L=$("p"),L.textContent=ut,Ae=c(),f(E.$$.fragment),We=c(),f(P.$$.fragment),Xe=c(),K=$("p"),K.textContent=ht,Re=c(),f(q.$$.fragment),Ye=c(),D=$("p"),D.innerHTML=yt,He=c(),f(O.$$.fragment),Ve=c(),f(ee.$$.fragment),Be=c(),te=$("p"),te.textContent=Mt,ze=c(),ae=$("ul"),ae.innerHTML=wt,xe=c(),f(le.$$.fragment),Fe=c(),re=$("p"),re.textContent=$t,Qe=c(),ce=$("p"),ce.innerHTML=gt,Se=c(),f(Z.$$.fragment),Ne=c(),f(ne.$$.fragment),Le=c(),f(ie.$$.fragment),Ee=c(),oe=$("p"),oe.innerHTML=bt,Pe=c(),f(se.$$.fragment),Ke=c(),pe=$("p"),pe.innerHTML=Tt,qe=c(),de=$("p"),de.innerHTML=Ut,De=c(),f(I.$$.fragment),Oe=c(),f(me.$$.fragment),et=c(),fe=$("p"),fe.innerHTML=Jt,tt=c(),ue=$("p"),ue.innerHTML=_t,at=c(),he=$("p"),he.innerHTML=vt,lt=c(),f(ye.$$.fragment),rt=c(),Me=$("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);r=g(t,"META",{name:!0,content:!0}),t.forEach(a),T=n(e),o=g(e,"P",{}),Gt(o).forEach(a),m=n(e),u(i.$$.fragment,e),p=n(e),U=g(e,"P",{"data-svelte-h":!0}),b(U)!=="svelte-19zbp5z"&&(U.textContent=J),_=n(e),s=g(e,"P",{"data-svelte-h":!0}),b(s)!=="svelte-1lmjen8"&&(s.innerHTML=d),v=n(e),u(A.$$.fragment,e),we=n(e),u(W.$$.fragment,e),$e=n(e),X=g(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1dn1lk2"&&(X.innerHTML=ot),ge=n(e),R=g(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-zcqlut"&&(R.innerHTML=st),be=n(e),u(Y.$$.fragment,e),Te=n(e),H=g(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1csx4md"&&(H.innerHTML=pt),Ue=n(e),u(V.$$.fragment,e),Je=n(e),u(B.$$.fragment,e),_e=n(e),z=g(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-wqk9uz"&&(z.innerHTML=dt),ve=n(e),u(G.$$.fragment,e),je=n(e),x=g(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-l5v2wx"&&(x.textContent=mt),ke=n(e),u(F.$$.fragment,e),Ce=n(e),u(Q.$$.fragment,e),Ge=n(e),S=g(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-i5xqdp"&&(S.innerHTML=ft),Ze=n(e),u(N.$$.fragment,e),Ie=n(e),L=g(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-1b6tm11"&&(L.textContent=ut),Ae=n(e),u(E.$$.fragment,e),We=n(e),u(P.$$.fragment,e),Xe=n(e),K=g(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-1ef6475"&&(K.textContent=ht),Re=n(e),u(q.$$.fragment,e),Ye=n(e),D=g(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1nruvdz"&&(D.innerHTML=yt),He=n(e),u(O.$$.fragment,e),Ve=n(e),u(ee.$$.fragment,e),Be=n(e),te=g(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-bg95gl"&&(te.textContent=Mt),ze=n(e),ae=g(e,"UL",{"data-svelte-h":!0}),b(ae)!=="svelte-3kii7l"&&(ae.innerHTML=wt),xe=n(e),u(le.$$.fragment,e),Fe=n(e),re=g(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-81s14c"&&(re.textContent=$t),Qe=n(e),ce=g(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-mmotdg"&&(ce.innerHTML=gt),Se=n(e),u(Z.$$.fragment,e),Ne=n(e),u(ne.$$.fragment,e),Le=n(e),u(ie.$$.fragment,e),Ee=n(e),oe=g(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-dqdivd"&&(oe.innerHTML=bt),Pe=n(e),u(se.$$.fragment,e),Ke=n(e),pe=g(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-nvfiz9"&&(pe.innerHTML=Tt),qe=n(e),de=g(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-56aoja"&&(de.innerHTML=Ut),De=n(e),u(I.$$.fragment,e),Oe=n(e),u(me.$$.fragment,e),et=n(e),fe=g(e,"P",{"data-svelte-h":!0}),b(fe)!=="svelte-qzsquh"&&(fe.innerHTML=Jt),tt=n(e),ue=g(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-cf1uwy"&&(ue.innerHTML=_t),at=n(e),he=g(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-uuw2iq"&&(he.innerHTML=vt),lt=n(e),u(ye.$$.fragment,e),rt=n(e),Me=g(e,"P",{}),Gt(Me).forEach(a),this.h()},h(){Zt(r,"name","hf:doc:metadata"),Zt(r,"content",Et)},m(e,t){Ht(document.head,r),l(e,T,t),l(e,o,t),l(e,m,t),h(i,e,t),l(e,p,t),l(e,U,t),l(e,_,t),l(e,s,t),l(e,v,t),h(A,e,t),l(e,we,t),h(W,e,t),l(e,$e,t),l(e,X,t),l(e,ge,t),l(e,R,t),l(e,be,t),h(Y,e,t),l(e,Te,t),l(e,H,t),l(e,Ue,t),h(V,e,t),l(e,Je,t),h(B,e,t),l(e,_e,t),l(e,z,t),l(e,ve,t),h(G,e,t),l(e,je,t),l(e,x,t),l(e,ke,t),h(F,e,t),l(e,Ce,t),h(Q,e,t),l(e,Ge,t),l(e,S,t),l(e,Ze,t),h(N,e,t),l(e,Ie,t),l(e,L,t),l(e,Ae,t),h(E,e,t),l(e,We,t),h(P,e,t),l(e,Xe,t),l(e,K,t),l(e,Re,t),h(q,e,t),l(e,Ye,t),l(e,D,t),l(e,He,t),h(O,e,t),l(e,Ve,t),h(ee,e,t),l(e,Be,t),l(e,te,t),l(e,ze,t),l(e,ae,t),l(e,xe,t),h(le,e,t),l(e,Fe,t),l(e,re,t),l(e,Qe,t),l(e,ce,t),l(e,Se,t),h(Z,e,t),l(e,Ne,t),h(ne,e,t),l(e,Le,t),h(ie,e,t),l(e,Ee,t),l(e,oe,t),l(e,Pe,t),h(se,e,t),l(e,Ke,t),l(e,pe,t),l(e,qe,t),l(e,de,t),l(e,De,t),h(I,e,t),l(e,Oe,t),h(me,e,t),l(e,et,t),l(e,fe,t),l(e,tt,t),l(e,ue,t),l(e,at,t),l(e,he,t),l(e,lt,t),h(ye,e,t),l(e,rt,t),l(e,Me,t),ct=!0},p(e,[t]){const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),G.$set(jt);const kt={};t&2&&(kt.$$scope={dirty:t,ctx:e}),Z.$set(kt);const Ct={};t&2&&(Ct.$$scope={dirty:t,ctx:e}),I.$set(Ct)},i(e){ct||(y(i.$$.fragment,e),y(A.$$.fragment,e),y(W.$$.fragment,e),y(Y.$$.fragment,e),y(V.$$.fragment,e),y(B.$$.fragment,e),y(G.$$.fragment,e),y(F.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(ee.$$.fragment,e),y(le.$$.fragment,e),y(Z.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(se.$$.fragment,e),y(I.$$.fragment,e),y(me.$$.fragment,e),y(ye.$$.fragment,e),ct=!0)},o(e){M(i.$$.fragment,e),M(A.$$.fragment,e),M(W.$$.fragment,e),M(Y.$$.fragment,e),M(V.$$.fragment,e),M(B.$$.fragment,e),M(G.$$.fragment,e),M(F.$$.fragment,e),M(Q.$$.fragment,e),M(N.$$.fragment,e),M(E.$$.fragment,e),M(P.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(Z.$$.fragment,e),M(ne.$$.fragment,e),M(ie.$$.fragment,e),M(se.$$.fragment,e),M(I.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),ct=!1},d(e){e&&(a(T),a(o),a(m),a(p),a(U),a(_),a(s),a(v),a(we),a($e),a(X),a(ge),a(R),a(be),a(Te),a(H),a(Ue),a(Je),a(_e),a(z),a(ve),a(je),a(x),a(ke),a(Ce),a(Ge),a(S),a(Ze),a(Ie),a(L),a(Ae),a(We),a(Xe),a(K),a(Re),a(Ye),a(D),a(He),a(Ve),a(Be),a(te),a(ze),a(ae),a(xe),a(Fe),a(re),a(Qe),a(ce),a(Se),a(Ne),a(Le),a(Ee),a(oe),a(Pe),a(Ke),a(pe),a(qe),a(de),a(De),a(Oe),a(et),a(fe),a(tt),a(ue),a(at),a(he),a(lt),a(rt),a(Me)),a(r),w(i,e),w(A,e),w(W,e),w(Y,e),w(V,e),w(B,e),w(G,e),w(F,e),w(Q,e),w(N,e),w(E,e),w(P,e),w(q,e),w(O,e),w(ee,e),w(le,e),w(Z,e),w(ne,e),w(ie,e),w(se,e),w(I,e),w(me,e),w(ye,e)}}}const Et='{"title":"Add Accelerate to your code","local":"add-accelerate-to-your-code","sections":[{"title":"Accelerator","local":"accelerator","sections":[],"depth":2},{"title":"Prepare PyTorch objects","local":"prepare-pytorch-objects","sections":[],"depth":2},{"title":"Training loop","local":"training-loop","sections":[],"depth":2},{"title":"Training features","local":"training-features","sections":[{"title":"Gradient accumulation","local":"gradient-accumulation","sections":[],"depth":3},{"title":"Gradient clipping","local":"gradient-clipping","sections":[],"depth":3},{"title":"Mixed precision","local":"mixed-precision","sections":[],"depth":3}],"depth":2},{"title":"Save and load","local":"save-and-load","sections":[{"title":"Model","local":"model","sections":[],"depth":3},{"title":"State","local":"state","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pt(j){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class aa extends Xt{constructor(r){super(),Rt(this,r,Pt,Lt,At,{})}}export{aa as component};
