import{s as It,n as Ct,o as kt}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as Wt,g as p,s as a,r as i,A as Nt,h as m,f as e,c as n,j as Ut,u as o,x as g,k as $t,y as Bt,a as l,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as R}from"../chunks/CodeBlock.52fa569e.js";import{H as v,E as xt}from"../chunks/EditOnGithub.b65eee75.js";function Gt(Mt){let y,S,X,Y,d,z,w,gt='<strong>SE ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',F,J,H,j,yt="To load a pretrained model:",A,u,L,T,dt="To load and preprocess the image:",q,f,D,b,wt="To get the model predictions:",P,U,K,$,Jt="To get the top-5 predictions class names:",O,I,tt,C,jt="Replace the model name with the variant you want to use, e.g. <code>legacy_seresnet101</code>. You can find the IDs in the model summaries at the top of this page.",st,k,ut='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,Z,lt,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,N,nt,B,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,x,mt,G,bt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',it,E,ot,V,ct,Q,rt,_,ht;return d=new v({props:{title:"(Legacy) SE-ResNet",local:"legacy-se-resnet",headingTag:"h1"}}),J=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZXJlc25ldDEwMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlcmVzbmV0MTAxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new R({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),Q=new xt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/legacy-se-resnet.mdx"}}),{c(){y=p("meta"),S=a(),X=p("p"),Y=a(),i(d.$$.fragment),z=a(),w=p("p"),w.innerHTML=gt,F=a(),i(J.$$.fragment),H=a(),j=p("p"),j.textContent=yt,A=a(),i(u.$$.fragment),L=a(),T=p("p"),T.textContent=dt,q=a(),i(f.$$.fragment),D=a(),b=p("p"),b.textContent=wt,P=a(),i(U.$$.fragment),K=a(),$=p("p"),$.textContent=Jt,O=a(),i(I.$$.fragment),tt=a(),C=p("p"),C.innerHTML=jt,st=a(),k=p("p"),k.innerHTML=ut,et=a(),i(Z.$$.fragment),lt=a(),W=p("p"),W.textContent=Tt,at=a(),i(N.$$.fragment),nt=a(),B=p("p"),B.innerHTML=ft,pt=a(),i(x.$$.fragment),mt=a(),G=p("p"),G.innerHTML=bt,it=a(),i(E.$$.fragment),ot=a(),i(V.$$.fragment),ct=a(),i(Q.$$.fragment),rt=a(),_=p("p"),this.h()},l(t){const s=Nt("svelte-u9bgzb",document.head);y=m(s,"META",{name:!0,content:!0}),s.forEach(e),S=n(t),X=m(t,"P",{}),Ut(X).forEach(e),Y=n(t),o(d.$$.fragment,t),z=n(t),w=m(t,"P",{"data-svelte-h":!0}),g(w)!=="svelte-1b8qp0g"&&(w.innerHTML=gt),F=n(t),o(J.$$.fragment,t),H=n(t),j=m(t,"P",{"data-svelte-h":!0}),g(j)!=="svelte-18ywhxh"&&(j.textContent=yt),A=n(t),o(u.$$.fragment,t),L=n(t),T=m(t,"P",{"data-svelte-h":!0}),g(T)!=="svelte-1c2ipa8"&&(T.textContent=dt),q=n(t),o(f.$$.fragment,t),D=n(t),b=m(t,"P",{"data-svelte-h":!0}),g(b)!=="svelte-1n9qsq1"&&(b.textContent=wt),P=n(t),o(U.$$.fragment,t),K=n(t),$=m(t,"P",{"data-svelte-h":!0}),g($)!=="svelte-19cnvx1"&&($.textContent=Jt),O=n(t),o(I.$$.fragment,t),tt=n(t),C=m(t,"P",{"data-svelte-h":!0}),g(C)!=="svelte-ez0uq1"&&(C.innerHTML=jt),st=n(t),k=m(t,"P",{"data-svelte-h":!0}),g(k)!=="svelte-1wmi3ea"&&(k.innerHTML=ut),et=n(t),o(Z.$$.fragment,t),lt=n(t),W=m(t,"P",{"data-svelte-h":!0}),g(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),at=n(t),o(N.$$.fragment,t),nt=n(t),B=m(t,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1kguc51"&&(B.innerHTML=ft),pt=n(t),o(x.$$.fragment,t),mt=n(t),G=m(t,"P",{"data-svelte-h":!0}),g(G)!=="svelte-1n0coha"&&(G.innerHTML=bt),it=n(t),o(E.$$.fragment,t),ot=n(t),o(V.$$.fragment,t),ct=n(t),o(Q.$$.fragment,t),rt=n(t),_=m(t,"P",{}),Ut(_).forEach(e),this.h()},h(){$t(y,"name","hf:doc:metadata"),$t(y,"content",Et)},m(t,s){Bt(document.head,y),l(t,S,s),l(t,X,s),l(t,Y,s),c(d,t,s),l(t,z,s),l(t,w,s),l(t,F,s),c(J,t,s),l(t,H,s),l(t,j,s),l(t,A,s),c(u,t,s),l(t,L,s),l(t,T,s),l(t,q,s),c(f,t,s),l(t,D,s),l(t,b,s),l(t,P,s),c(U,t,s),l(t,K,s),l(t,$,s),l(t,O,s),c(I,t,s),l(t,tt,s),l(t,C,s),l(t,st,s),l(t,k,s),l(t,et,s),c(Z,t,s),l(t,lt,s),l(t,W,s),l(t,at,s),c(N,t,s),l(t,nt,s),l(t,B,s),l(t,pt,s),c(x,t,s),l(t,mt,s),l(t,G,s),l(t,it,s),c(E,t,s),l(t,ot,s),c(V,t,s),l(t,ct,s),c(Q,t,s),l(t,rt,s),l(t,_,s),ht=!0},p:Ct,i(t){ht||(r(d.$$.fragment,t),r(J.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(I.$$.fragment,t),r(Z.$$.fragment,t),r(N.$$.fragment,t),r(x.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),r(Q.$$.fragment,t),ht=!0)},o(t){h(d.$$.fragment,t),h(J.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(I.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),h(Q.$$.fragment,t),ht=!1},d(t){t&&(e(S),e(X),e(Y),e(z),e(w),e(F),e(H),e(j),e(A),e(L),e(T),e(q),e(D),e(b),e(P),e(K),e($),e(O),e(tt),e(C),e(st),e(k),e(et),e(lt),e(W),e(at),e(nt),e(B),e(pt),e(mt),e(G),e(it),e(ot),e(ct),e(rt),e(_)),e(y),M(d,t),M(J,t),M(u,t),M(f,t),M(U,t),M(I,t),M(Z,t),M(N,t),M(x,t),M(E,t),M(V,t),M(Q,t)}}}const Et='{"title":"(Legacy) SE-ResNet","local":"legacy-se-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Vt(Mt){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends Zt{constructor(y){super(),Wt(this,y,Vt,Gt,It,{})}}export{vt as component};
