import{s as Ji,o as wi,n as Tn}from"../chunks/scheduler.6062bdaf.js";import{S as di,i as Ui,g as s,s as M,r as y,A as ji,h as n,f as l,c as i,j as T,u as r,x as c,k as o,y as h,a,v as J,d as w,t as d,w as U}from"../chunks/index.4bca734e.js";import{T as cn}from"../chunks/Tip.b9ac1f03.js";import{I}from"../chunks/IconCopyLink.68a13644.js";import{C as f}from"../chunks/CodeBlock.f213e6a5.js";function pi(F){let j,u=`<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a> is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!`;return{c(){j=s("p"),j.innerHTML=u},l(p){j=n(p,"P",{"data-svelte-h":!0}),c(j)!=="svelte-h6eer8"&&(j.innerHTML=u)},m(p,m){a(p,j,m)},p:Tn,d(p){p&&l(j)}}}function Ii(F){let j,u=`Revision hashes are unique across all repositories. This means you don’t need to
provide any <code>repo_id</code> or <code>repo_type</code> when removing revisions.`;return{c(){j=s("p"),j.innerHTML=u},l(p){j=n(p,"P",{"data-svelte-h":!0}),c(j)!=="svelte-pge9b4"&&(j.innerHTML=u)},m(p,m){a(p,j,m)},p:Tn,d(p){p&&l(j)}}}function fi(F){let j,u=`If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.`;return{c(){j=s("p"),j.innerHTML=u},l(p){j=n(p,"P",{"data-svelte-h":!0}),c(j)!=="svelte-24rtm8"&&(j.innerHTML=u)},m(p,m){a(p,j,m)},p:Tn,d(p){p&&l(j)}}}function mi(F){let j,u,p,m,dt,re,Fs,Xl,yn="Manage <code>huggingface_hub</code> cache-system",$t,C,D,Ut,Je,Ds,Pl,rn="Understand caching",Rt,we,Jn=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,_t,de,wn="The caching system is designed as follows:",Et,Ue,Bt,je,dn=`The <code>&lt;CACHE_DIR&gt;</code> is usually your user’s home directory. However, it is customizable with the
<code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or
<code>HUGGINGFACE_HUB_CACHE</code> environment variable.`,Ft,pe,Un=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,Dt,Ie,Vt,fe,jn=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,Qt,me,pn="In order to achieve this, all folders contain the same skeleton:",Ot,ue,zt,Ce,In="Each folder is designed to contain the following:",Ht,b,V,jt,be,Vs,ql,fn="Refs",Xt,Ae,mn=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,Pt,ge,un="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",qt,ve,Cn=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,Kt,A,Q,pt,Ze,Qs,Kl,bn="Blobs",ea,ke,An="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",la,g,O,It,Ne,Os,et,gn="Snapshots",ta,Ye,vn=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,aa,Se,Zn=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,sa,Ge,kn=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,na,We,Ma,xe,Nn="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",ia,Le,Yn=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,oa,v,z,ft,$e,zs,lt,Sn=".no_exist (advanced)",ha,Re,Gn=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,ca,_e,Ta,Ee,Wn=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable is term of disk usage.`,ya,Be,xn=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exists (and
which doesn’t) to make the loading time faster for the next initializations.`,ra,Fe,Ln=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,Ja,De,wa,Z,H,mt,Ve,Hs,tt,$n="In practice",da,Qe,Rn="In practice, your cache should look like the following tree:",Ua,Oe,ja,k,X,ut,ze,Xs,at,_n="Limitations",pa,He,En=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,Ia,Xe,Bn=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,fa,Pe,Fn=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,ma,N,P,Ct,qe,Ps,st,Dn="Caching assets",ua,Ke,Vn=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,Ca,el,ba,q,Aa,Y,K,bt,ll,qs,nt,Qn="Assets in practice",ga,tl,On="In practice, your assets cache should look like the following tree:",va,al,Za,S,ee,At,sl,Ks,Mt,zn="Scan your cache",ka,nl,Hn=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to scan your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides an helper to
do so that can be used via <code>huggingface-cli</code> or in a python script.`,Na,G,le,gt,Ml,en,it,Xn="Scan cache from the terminal",Ya,il,Pn=`The easiest way to scan your HF cache-system is to use the <code>scan-cache</code> command from
<code>huggingface-cli</code> tool. This command scans the cache and prints a report with information
like repo id, repo type, disk usage, refs and full local path.`,Sa,ol,qn=`The snippet below shows a scan report in a folder in which 4 models and 2 datasets are
cached.`,Ga,hl,Wa,cl,Kn=`To get a more detailed report, use the <code>--verbose</code> option. For each repo, you get a
list of all revisions that have been downloaded. As explained above, the files that don’t
change between 2 revisions are shared thanks to the symlinks. This means that the size of
the repo on disk is expected to be less than the sum of the size of each of its revisions.
For example, here <code>bert-base-cased</code> has 2 revisions of 1.4G and 1.5G but the total disk
usage is only 1.9G.`,xa,Tl,La,W,te,vt,yl,ln,ot,eM="Grep example",$a,rl,lM=`Since the output is in tabular format, you can combine it with any <code>grep</code>-like tools to
filter the entries. Here is an example to filter only revisions from the “t5-small”
model on a Unix-based machine.`,Ra,Jl,_a,x,ae,Zt,wl,tn,ht,tM="Scan cache from Python",Ea,dl,aM=`For a more advanced usage, use <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,Ba,Ul,sM="You can use it to get a detailed report structured around 4 dataclasses:",Fa,jl,nM='<li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',Da,pl,MM="Here is a simple usage example. See reference for details.",Va,Il,Qa,L,se,kt,fl,an,ct,iM="Clean your cache",Oa,ml,oM=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>delete-cache</code> CLI command. One can also programmatically use the
<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,za,$,ne,Nt,ul,sn,Tt,hM="Delete strategy",Ha,Cl,cM=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,Xa,bl,TM="The strategy to delete revisions is the following:",Pa,Al,yM="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",qa,Me,Ka,ie,es,R,oe,Yt,gl,nn,yt,rM="Clean cache from the terminal",ls,vl,JM=`The easiest way to delete some revisions from your HF cache-system is to use the
<code>delete-cache</code> command from <code>huggingface-cli</code> tool. The command has two modes. By
default, a TUI (Terminal User Interface) is displayed to the user to select which
revisions to delete. This TUI is currently in beta as it has not been tested on all
platforms. If the TUI doesn’t work on your machine, you can disable it using the
<code>--disable-tui</code> flag.`,ts,_,he,St,Zl,Mn,rt,wM="Using the TUI",as,kl,dM=`This is the default mode. To use it, you first need to install extra dependencies by
running the following command:`,ss,Nl,ns,Yl,UM="Then run the command:",Ms,Sl,is,Gl,jM="You should now see a list of revisions that you can select/deselect:",os,ce,pM='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/delete-cache-tui.png"/>',hs,Wl,IM="Instructions:",cs,xl,fM=`<li>Press keyboard arrow keys <code>&lt;up&gt;</code> and <code>&lt;down&gt;</code> to move the cursor.</li> <li>Press <code>&lt;space&gt;</code> to toggle (select/unselect) an item.</li> <li>When a revision is selected, the first line is updated to show you how much space
will be freed.</li> <li>Press <code>&lt;enter&gt;</code> to confirm your selection.</li> <li>If you want to cancel the operation and quit, you can select the first item
(“None of the following”). If this item is selected, the delete process will be
cancelled, no matter what other items are selected. Otherwise you can also press
<code>&lt;ctrl+c&gt;</code> to quit the TUI.</li>`,Ts,Ll,mM=`Once you’ve selected the revisions you want to delete and pressed <code>&lt;enter&gt;</code>, a last
confirmation message will be prompted. Press <code>&lt;enter&gt;</code> again and the deletion will be
effective. If you want to cancel, enter <code>n</code>.`,ys,$l,rs,E,Te,Gt,Rl,on,Jt,uM="Without TUI",Js,_l,CM=`As mentioned above, the TUI mode is currently in beta and is optional. It may be the
case that it doesn’t work on your machine or that you don’t find it convenient.`,ws,El,bM=`Another approach is to use the <code>--disable-tui</code> flag. The process is very similar as you
will be asked to manually review the list of revisions to delete. However, this manual
step will not take place in the terminal directly but in a temporary file generated on
the fly and that you can manually edit.`,ds,Bl,AM=`This file has all the instructions you need in the header. Open it in your favorite text
editor. To select/deselect a revision, simply comment/uncomment it with a <code>#</code>. Once the
manual review is done and the file is edited, you can save it. Go back to your terminal
and press <code>&lt;enter&gt;</code>. By default it will compute how much space would be freed with the
updated list of revisions. You can continue to edit the file or confirm with <code>&quot;y&quot;</code>.`,Us,Fl,js,Dl,gM="Example of command file:",ps,Vl,Is,B,ye,Wt,Ql,hn,wt,vM="Clean cache from Python",fs,Ol,ZM=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,ms,zl,us;return re=new I({}),Je=new I({}),Ue=new f({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`}}),Ie=new f({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`}}),ue=new f({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`}}),be=new I({}),Ze=new I({}),Ne=new I({}),We=new f({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md'}}),$e=new I({}),_e=new f({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json'}}),De=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`}}),Ve=new I({}),Oe=new f({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`}}),ze=new I({}),qe=new I({}),el=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`}}),q=new cn({props:{$$slots:{default:[pi]},$$scope:{ctx:F}}}),ll=new I({}),al=new f({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`}}),sl=new I({}),Ml=new I({}),hl=new f({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache
REPO ID                     REPO TYPE SIZE ON DISK NB FILES LAST_ACCESSED LAST_MODIFIED REFS                LOCAL PATH
--------------------------- --------- ------------ -------- ------------- ------------- ------------------- -------------------------------------------------------------------------
glue                        dataset         116.3K       15 4 days ago    4 days ago    2.4.0, main, 1.17.0 /home/wauplin/.cache/huggingface/hub/datasets--glue
google/fleurs               dataset          64.9M        6 1 week ago    1 week ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs
Jean-Baptiste/camembert-ner model           441.0M        7 2 weeks ago   16 hours ago  main                /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner
bert-base-cased             model             1.9G       13 1 week ago    2 years ago                       /home/wauplin/.cache/huggingface/hub/models--bert-base-cased
t5-base                     model            10.1K        3 3 months ago  3 months ago  main                /home/wauplin/.cache/huggingface/hub/models--t5-base
t5-small                    model           970.7M       11 3 days ago    3 days ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/models--t5-small

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`}}),Tl=new f({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache -v
REPO ID                     REPO TYPE REVISION                                 SIZE ON DISK NB FILES LAST_MODIFIED REFS        LOCAL PATH
--------------------------- --------- ---------------------------------------- ------------ -------- ------------- ----------- ----------------------------------------------------------------------------------------------------------------------------
glue                        dataset   9338f7b671827df886678df2bdd7cc7b4f36dffd        97.7K       14 4 days ago    main, 2.4.0 /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/9338f7b671827df886678df2bdd7cc7b4f36dffd
glue                        dataset   f021ae41c879fcabcf823648ec685e3fead91fe7        97.8K       14 1 week ago    1.17.0      /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/f021ae41c879fcabcf823648ec685e3fead91fe7
google/fleurs               dataset   129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8        25.4K        3 2 weeks ago   refs/pr/1   /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8
google/fleurs               dataset   24f85a01eb955224ca3946e70050869c56446805        64.9M        4 1 week ago    main        /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/24f85a01eb955224ca3946e70050869c56446805
Jean-Baptiste/camembert-ner model     dbec8489a1c44ecad9da8a9185115bccabd799fe       441.0M        7 16 hours ago  main        /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner/snapshots/dbec8489a1c44ecad9da8a9185115bccabd799fe
bert-base-cased             model     378aa1bda6387fd00e824948ebe3488630ad8565         1.5G        9 2 years ago               /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/378aa1bda6387fd00e824948ebe3488630ad8565
bert-base-cased             model     a8d257ba9925ef39f3036bfc338acf5283c512d9         1.4G        9 3 days ago    main        /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/a8d257ba9925ef39f3036bfc338acf5283c512d9
t5-base                     model     23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9        10.1K        3 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-base/snapshots/23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`}}),yl=new I({}),Jl=new f({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmh1Z2dpbmdmYWNlLWNsaSUyMHNjYW4tY2FjaGUlMjAtdiUyMiUyMCU3QyUyMGdyZXAlMjAlMjJ0NS1zbWFsbCUyMiUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjA5OGZmZWJiYjI3MzQwZWMxYjFhYmQ3YzQ1ZGExMmMyNTNlZTE4ODJhJTIwJTIwJTIwJTIwJTIwJTIwJTIwNzI2LjJNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwcmVmcyUyRnByJTJGMSUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGOThmZmViYmIyNzM0MGVjMWIxYWJkN2M0NWRhMTJjMjUzZWUxODgyYSUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkMGExMTllZWRiMzcxOGUzNGM2NDhlNTk0Mzk0NDc0Y2Y5NWUwNjE3JTIwJTIwJTIwJTIwJTIwJTIwJTIwNDg1LjhNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDQlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDBhMTE5ZWVkYjM3MThlMzRjNjQ4ZTU5NDM5NDQ3NGNmOTVlMDYxNyUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkNzhhZWExM2ZhN2VjZDA2YzI5ZTNlNDYxOTVkNjM0MTI1NTA2NWQ1JTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwbWFpbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDc4YWVhMTNmYTdlY2QwNmMyOWUzZTQ2MTk1ZDYzNDEyNTUwNjVkNQ==",highlighted:`➜ eval &quot;huggingface-cli scan-cache -v&quot; | grep &quot;t5-small&quot;
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5`}}),wl=new I({}),Il=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`}}),fl=new I({}),ul=new I({}),Me=new cn({props:{$$slots:{default:[Ii]},$$scope:{ctx:F}}}),ie=new cn({props:{warning:!0,$$slots:{default:[fi]},$$scope:{ctx:F}}}),gl=new I({}),Zl=new I({}),Nl=new f({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiU1QiUyMmNsaSUyMiU1RA==",highlighted:'pip <span class="hljs-keyword">install</span> huggingface_hub[<span class="hljs-string">&quot;cli&quot;</span>]'}}),Sl=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hl",highlighted:'huggingface-cli <span class="hljs-keyword">delete</span>-<span class="hljs-keyword">cache</span>'}}),$l=new f({props:{code:"JUUyJTlDJTk3JTIwaHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXIlMjB+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMEElM0YlMjBTZWxlY3QlMjByZXZpc2lvbnMlMjB0byUyMGRlbGV0ZSUzQSUyMDIlMjByZXZpc2lvbihzKSUyMHNlbGVjdGVkLiUwQSUzRiUyMDIlMjByZXZpc2lvbnMlMjBzZWxlY3RlZCUyMGNvdW50aW5nJTIwZm9yJTIwMy4xRy4lMjBDb25maXJtJTIwZGVsZXRpb24lMjAlM0YlMjBZZXMlMEFTdGFydCUyMGRlbGV0aW9uLiUwQURvbmUuJTIwRGVsZXRlZCUyMDElMjByZXBvKHMpJTIwYW5kJTIwMCUyMHJldmlzaW9uKHMpJTIwZm9yJTIwYSUyMHRvdGFsJTIwb2YlMjAzLjFHLg==",highlighted:`✗ huggingface-cli delete-cache --dir ~/.cache/huggingface/hub
? Select revisions to delete: 2 revision(s) selected.
? 2 revisions selected counting for 3.1G. Confirm deletion ? Yes
Start deletion.
Done. Deleted 1 repo(s) and 0 revision(s) for a total of 3.1G.`}}),Rl=new I({}),Fl=new f({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXNhYmxlLXR1aQ==",highlighted:"huggingface-cli delete-cache --disable-tui"}}),Vl=new f({props:{code:"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",highlighted:`# INSTRUCTIONS
# ------------
# This is a temporary file created by running \`huggingface-cli delete-cache\` with the
# \`--disable-tui\` option. It contains a set of revisions that can be deleted from your
# local cache directory.
#
# Please manually review the revisions you want to delete:
#   - Revision hashes can be commented out with &#x27;#&#x27;.
#   - Only non-commented revisions in this file will be deleted.
#   - Revision hashes that are removed from this file are ignored as well.
#   - If \`CANCEL_DELETION\` line is uncommented, the all cache deletion is cancelled and
#     no changes will be applied.
#
# Once you&#x27;ve manually reviewed this file, please confirm deletion in the terminal. This
# file will be automatically removed once done.
# ------------

# KILL SWITCH
# ------------
# Un-comment following line to completely cancel the deletion process
# CANCEL_DELETION
# ------------

# REVISIONS
# ------------
# Dataset chrisjay/crowd-speech-africa (761.7M, used 5 days ago)
    ebedcd8c55c90d39fd27126d29d8484566cd27ca # Refs: main # modified 5 days ago

# Dataset oscar (3.3M, used 4 days ago)
#    916f956518279c5e60c63902ebdf3ddf9fa9d629 # Refs: main # modified 4 days ago

# Dataset wikiann (804.1K, used 2 weeks ago)
    89d089624b6323d69dcd9e5eb2def0551887a73a # Refs: main # modified 2 weeks ago

# Dataset z-uo/male-LJSpeech-italian (5.5G, used 5 days ago)
#    9cfa5647b32c0a30d0adfca06bf198d82192a0d1 # Refs: main # modified 5 days ago`}}),Ql=new I({}),zl=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`}}),{c(){j=s("meta"),u=M(),p=s("h1"),m=s("a"),dt=s("span"),y(re.$$.fragment),Fs=M(),Xl=s("span"),Xl.innerHTML=yn,$t=M(),C=s("h2"),D=s("a"),Ut=s("span"),y(Je.$$.fragment),Ds=M(),Pl=s("span"),Pl.textContent=rn,Rt=M(),we=s("p"),we.textContent=Jn,_t=M(),de=s("p"),de.textContent=wn,Et=M(),y(Ue.$$.fragment),Bt=M(),je=s("p"),je.innerHTML=dn,Ft=M(),pe=s("p"),pe.textContent=Un,Dt=M(),y(Ie.$$.fragment),Vt=M(),fe=s("p"),fe.textContent=jn,Qt=M(),me=s("p"),me.textContent=pn,Ot=M(),y(ue.$$.fragment),zt=M(),Ce=s("p"),Ce.textContent=In,Ht=M(),b=s("h3"),V=s("a"),jt=s("span"),y(be.$$.fragment),Vs=M(),ql=s("span"),ql.textContent=fn,Xt=M(),Ae=s("p"),Ae.innerHTML=mn,Pt=M(),ge=s("p"),ge.innerHTML=un,qt=M(),ve=s("p"),ve.innerHTML=Cn,Kt=M(),A=s("h3"),Q=s("a"),pt=s("span"),y(Ze.$$.fragment),Qs=M(),Kl=s("span"),Kl.textContent=bn,ea=M(),ke=s("p"),ke.innerHTML=An,la=M(),g=s("h3"),O=s("a"),It=s("span"),y(Ne.$$.fragment),Os=M(),et=s("span"),et.textContent=gn,ta=M(),Ye=s("p"),Ye.innerHTML=vn,aa=M(),Se=s("p"),Se.innerHTML=Zn,sa=M(),Ge=s("p"),Ge.innerHTML=kn,na=M(),y(We.$$.fragment),Ma=M(),xe=s("p"),xe.innerHTML=Nn,ia=M(),Le=s("p"),Le.innerHTML=Yn,oa=M(),v=s("h3"),z=s("a"),ft=s("span"),y($e.$$.fragment),zs=M(),lt=s("span"),lt.textContent=Sn,ha=M(),Re=s("p"),Re.innerHTML=Gn,ca=M(),y(_e.$$.fragment),Ta=M(),Ee=s("p"),Ee.innerHTML=Wn,ya=M(),Be=s("p"),Be.innerHTML=xn,ra=M(),Fe=s("p"),Fe.innerHTML=Ln,Ja=M(),y(De.$$.fragment),wa=M(),Z=s("h3"),H=s("a"),mt=s("span"),y(Ve.$$.fragment),Hs=M(),tt=s("span"),tt.textContent=$n,da=M(),Qe=s("p"),Qe.textContent=Rn,Ua=M(),y(Oe.$$.fragment),ja=M(),k=s("h3"),X=s("a"),ut=s("span"),y(ze.$$.fragment),Xs=M(),at=s("span"),at.textContent=_n,pa=M(),He=s("p"),He.innerHTML=En,Ia=M(),Xe=s("p"),Xe.innerHTML=Bn,fa=M(),Pe=s("p"),Pe.innerHTML=Fn,ma=M(),N=s("h2"),P=s("a"),Ct=s("span"),y(qe.$$.fragment),Ps=M(),st=s("span"),st.textContent=Dn,ua=M(),Ke=s("p"),Ke.innerHTML=Vn,Ca=M(),y(el.$$.fragment),ba=M(),y(q.$$.fragment),Aa=M(),Y=s("h3"),K=s("a"),bt=s("span"),y(ll.$$.fragment),qs=M(),nt=s("span"),nt.textContent=Qn,ga=M(),tl=s("p"),tl.textContent=On,va=M(),y(al.$$.fragment),Za=M(),S=s("h2"),ee=s("a"),At=s("span"),y(sl.$$.fragment),Ks=M(),Mt=s("span"),Mt.textContent=zn,ka=M(),nl=s("p"),nl.innerHTML=Hn,Na=M(),G=s("h3"),le=s("a"),gt=s("span"),y(Ml.$$.fragment),en=M(),it=s("span"),it.textContent=Xn,Ya=M(),il=s("p"),il.innerHTML=Pn,Sa=M(),ol=s("p"),ol.textContent=qn,Ga=M(),y(hl.$$.fragment),Wa=M(),cl=s("p"),cl.innerHTML=Kn,xa=M(),y(Tl.$$.fragment),La=M(),W=s("h4"),te=s("a"),vt=s("span"),y(yl.$$.fragment),ln=M(),ot=s("span"),ot.textContent=eM,$a=M(),rl=s("p"),rl.innerHTML=lM,Ra=M(),y(Jl.$$.fragment),_a=M(),x=s("h3"),ae=s("a"),Zt=s("span"),y(wl.$$.fragment),tn=M(),ht=s("span"),ht.textContent=tM,Ea=M(),dl=s("p"),dl.innerHTML=aM,Ba=M(),Ul=s("p"),Ul.textContent=sM,Fa=M(),jl=s("ul"),jl.innerHTML=nM,Da=M(),pl=s("p"),pl.textContent=MM,Va=M(),y(Il.$$.fragment),Qa=M(),L=s("h2"),se=s("a"),kt=s("span"),y(fl.$$.fragment),an=M(),ct=s("span"),ct.textContent=iM,Oa=M(),ml=s("p"),ml.innerHTML=oM,za=M(),$=s("h3"),ne=s("a"),Nt=s("span"),y(ul.$$.fragment),sn=M(),Tt=s("span"),Tt.textContent=hM,Ha=M(),Cl=s("p"),Cl.innerHTML=cM,Xa=M(),bl=s("p"),bl.textContent=TM,Pa=M(),Al=s("ul"),Al.innerHTML=yM,qa=M(),y(Me.$$.fragment),Ka=M(),y(ie.$$.fragment),es=M(),R=s("h3"),oe=s("a"),Yt=s("span"),y(gl.$$.fragment),nn=M(),yt=s("span"),yt.textContent=rM,ls=M(),vl=s("p"),vl.innerHTML=JM,ts=M(),_=s("h4"),he=s("a"),St=s("span"),y(Zl.$$.fragment),Mn=M(),rt=s("span"),rt.textContent=wM,as=M(),kl=s("p"),kl.textContent=dM,ss=M(),y(Nl.$$.fragment),ns=M(),Yl=s("p"),Yl.textContent=UM,Ms=M(),y(Sl.$$.fragment),is=M(),Gl=s("p"),Gl.textContent=jM,os=M(),ce=s("div"),ce.innerHTML=pM,hs=M(),Wl=s("p"),Wl.textContent=IM,cs=M(),xl=s("ul"),xl.innerHTML=fM,Ts=M(),Ll=s("p"),Ll.innerHTML=mM,ys=M(),y($l.$$.fragment),rs=M(),E=s("h4"),Te=s("a"),Gt=s("span"),y(Rl.$$.fragment),on=M(),Jt=s("span"),Jt.textContent=uM,Js=M(),_l=s("p"),_l.textContent=CM,ws=M(),El=s("p"),El.innerHTML=bM,ds=M(),Bl=s("p"),Bl.innerHTML=AM,Us=M(),y(Fl.$$.fragment),js=M(),Dl=s("p"),Dl.textContent=gM,ps=M(),y(Vl.$$.fragment),Is=M(),B=s("h3"),ye=s("a"),Wt=s("span"),y(Ql.$$.fragment),hn=M(),wt=s("span"),wt.textContent=vM,fs=M(),Ol=s("p"),Ol.innerHTML=ZM,ms=M(),y(zl.$$.fragment),this.h()},l(e){const t=ji("svelte-1phssyn",document.head);j=n(t,"META",{name:!0,content:!0}),t.forEach(l),u=i(e),p=n(e,"H1",{class:!0});var Hl=T(p);m=n(Hl,"A",{id:!0,class:!0,href:!0});var xt=T(m);dt=n(xt,"SPAN",{});var Lt=T(dt);r(re.$$.fragment,Lt),Lt.forEach(l),xt.forEach(l),Fs=i(Hl),Xl=n(Hl,"SPAN",{"data-svelte-h":!0}),c(Xl)!=="svelte-1dpajyl"&&(Xl.innerHTML=yn),Hl.forEach(l),$t=i(e),C=n(e,"H2",{class:!0});var Cs=T(C);D=n(Cs,"A",{id:!0,class:!0,href:!0});var kM=T(D);Ut=n(kM,"SPAN",{});var NM=T(Ut);r(Je.$$.fragment,NM),NM.forEach(l),kM.forEach(l),Ds=i(Cs),Pl=n(Cs,"SPAN",{"data-svelte-h":!0}),c(Pl)!=="svelte-q8mcd4"&&(Pl.textContent=rn),Cs.forEach(l),Rt=i(e),we=n(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-7434pt"&&(we.textContent=Jn),_t=i(e),de=n(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-bm5pxs"&&(de.textContent=wn),Et=i(e),r(Ue.$$.fragment,e),Bt=i(e),je=n(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-k0iadd"&&(je.innerHTML=dn),Ft=i(e),pe=n(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1xsylbb"&&(pe.textContent=Un),Dt=i(e),r(Ie.$$.fragment,e),Vt=i(e),fe=n(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-smirw4"&&(fe.textContent=jn),Qt=i(e),me=n(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-hxzvg9"&&(me.textContent=pn),Ot=i(e),r(ue.$$.fragment,e),zt=i(e),Ce=n(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-1o80jr1"&&(Ce.textContent=In),Ht=i(e),b=n(e,"H3",{class:!0});var bs=T(b);V=n(bs,"A",{id:!0,class:!0,href:!0});var YM=T(V);jt=n(YM,"SPAN",{});var SM=T(jt);r(be.$$.fragment,SM),SM.forEach(l),YM.forEach(l),Vs=i(bs),ql=n(bs,"SPAN",{"data-svelte-h":!0}),c(ql)!=="svelte-1452fkj"&&(ql.textContent=fn),bs.forEach(l),Xt=i(e),Ae=n(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-z6cr2z"&&(Ae.innerHTML=mn),Pt=i(e),ge=n(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-15cx8ge"&&(ge.innerHTML=un),qt=i(e),ve=n(e,"P",{"data-svelte-h":!0}),c(ve)!=="svelte-1u7b6sn"&&(ve.innerHTML=Cn),Kt=i(e),A=n(e,"H3",{class:!0});var As=T(A);Q=n(As,"A",{id:!0,class:!0,href:!0});var GM=T(Q);pt=n(GM,"SPAN",{});var WM=T(pt);r(Ze.$$.fragment,WM),WM.forEach(l),GM.forEach(l),Qs=i(As),Kl=n(As,"SPAN",{"data-svelte-h":!0}),c(Kl)!=="svelte-2v4vrb"&&(Kl.textContent=bn),As.forEach(l),ea=i(e),ke=n(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-9jec47"&&(ke.innerHTML=An),la=i(e),g=n(e,"H3",{class:!0});var gs=T(g);O=n(gs,"A",{id:!0,class:!0,href:!0});var xM=T(O);It=n(xM,"SPAN",{});var LM=T(It);r(Ne.$$.fragment,LM),LM.forEach(l),xM.forEach(l),Os=i(gs),et=n(gs,"SPAN",{"data-svelte-h":!0}),c(et)!=="svelte-iips9y"&&(et.textContent=gn),gs.forEach(l),ta=i(e),Ye=n(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-1mswky"&&(Ye.innerHTML=vn),aa=i(e),Se=n(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-1f9g1u2"&&(Se.innerHTML=Zn),sa=i(e),Ge=n(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-1ezxfdw"&&(Ge.innerHTML=kn),na=i(e),r(We.$$.fragment,e),Ma=i(e),xe=n(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-7nae39"&&(xe.innerHTML=Nn),ia=i(e),Le=n(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-sjd8l1"&&(Le.innerHTML=Yn),oa=i(e),v=n(e,"H3",{class:!0});var vs=T(v);z=n(vs,"A",{id:!0,class:!0,href:!0});var $M=T(z);ft=n($M,"SPAN",{});var RM=T(ft);r($e.$$.fragment,RM),RM.forEach(l),$M.forEach(l),zs=i(vs),lt=n(vs,"SPAN",{"data-svelte-h":!0}),c(lt)!=="svelte-18awpdf"&&(lt.textContent=Sn),vs.forEach(l),ha=i(e),Re=n(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-dxew1x"&&(Re.innerHTML=Gn),ca=i(e),r(_e.$$.fragment,e),Ta=i(e),Ee=n(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-1m1e4x3"&&(Ee.innerHTML=Wn),ya=i(e),Be=n(e,"P",{"data-svelte-h":!0}),c(Be)!=="svelte-1jb25aj"&&(Be.innerHTML=xn),ra=i(e),Fe=n(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-16ewkn1"&&(Fe.innerHTML=Ln),Ja=i(e),r(De.$$.fragment,e),wa=i(e),Z=n(e,"H3",{class:!0});var Zs=T(Z);H=n(Zs,"A",{id:!0,class:!0,href:!0});var _M=T(H);mt=n(_M,"SPAN",{});var EM=T(mt);r(Ve.$$.fragment,EM),EM.forEach(l),_M.forEach(l),Hs=i(Zs),tt=n(Zs,"SPAN",{"data-svelte-h":!0}),c(tt)!=="svelte-q6v35f"&&(tt.textContent=$n),Zs.forEach(l),da=i(e),Qe=n(e,"P",{"data-svelte-h":!0}),c(Qe)!=="svelte-1cw24ss"&&(Qe.textContent=Rn),Ua=i(e),r(Oe.$$.fragment,e),ja=i(e),k=n(e,"H3",{class:!0});var ks=T(k);X=n(ks,"A",{id:!0,class:!0,href:!0});var BM=T(X);ut=n(BM,"SPAN",{});var FM=T(ut);r(ze.$$.fragment,FM),FM.forEach(l),BM.forEach(l),Xs=i(ks),at=n(ks,"SPAN",{"data-svelte-h":!0}),c(at)!=="svelte-z4yr6i"&&(at.textContent=_n),ks.forEach(l),pa=i(e),He=n(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-1foktgq"&&(He.innerHTML=En),Ia=i(e),Xe=n(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-x8ev9q"&&(Xe.innerHTML=Bn),fa=i(e),Pe=n(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-1ue61z6"&&(Pe.innerHTML=Fn),ma=i(e),N=n(e,"H2",{class:!0});var Ns=T(N);P=n(Ns,"A",{id:!0,class:!0,href:!0});var DM=T(P);Ct=n(DM,"SPAN",{});var VM=T(Ct);r(qe.$$.fragment,VM),VM.forEach(l),DM.forEach(l),Ps=i(Ns),st=n(Ns,"SPAN",{"data-svelte-h":!0}),c(st)!=="svelte-18ek69b"&&(st.textContent=Dn),Ns.forEach(l),ua=i(e),Ke=n(e,"P",{"data-svelte-h":!0}),c(Ke)!=="svelte-110pmjd"&&(Ke.innerHTML=Vn),Ca=i(e),r(el.$$.fragment,e),ba=i(e),r(q.$$.fragment,e),Aa=i(e),Y=n(e,"H3",{class:!0});var Ys=T(Y);K=n(Ys,"A",{id:!0,class:!0,href:!0});var QM=T(K);bt=n(QM,"SPAN",{});var OM=T(bt);r(ll.$$.fragment,OM),OM.forEach(l),QM.forEach(l),qs=i(Ys),nt=n(Ys,"SPAN",{"data-svelte-h":!0}),c(nt)!=="svelte-13xoyy"&&(nt.textContent=Qn),Ys.forEach(l),ga=i(e),tl=n(e,"P",{"data-svelte-h":!0}),c(tl)!=="svelte-1lsljsl"&&(tl.textContent=On),va=i(e),r(al.$$.fragment,e),Za=i(e),S=n(e,"H2",{class:!0});var Ss=T(S);ee=n(Ss,"A",{id:!0,class:!0,href:!0});var zM=T(ee);At=n(zM,"SPAN",{});var HM=T(At);r(sl.$$.fragment,HM),HM.forEach(l),zM.forEach(l),Ks=i(Ss),Mt=n(Ss,"SPAN",{"data-svelte-h":!0}),c(Mt)!=="svelte-fihg2h"&&(Mt.textContent=zn),Ss.forEach(l),ka=i(e),nl=n(e,"P",{"data-svelte-h":!0}),c(nl)!=="svelte-1ppewq"&&(nl.innerHTML=Hn),Na=i(e),G=n(e,"H3",{class:!0});var Gs=T(G);le=n(Gs,"A",{id:!0,class:!0,href:!0});var XM=T(le);gt=n(XM,"SPAN",{});var PM=T(gt);r(Ml.$$.fragment,PM),PM.forEach(l),XM.forEach(l),en=i(Gs),it=n(Gs,"SPAN",{"data-svelte-h":!0}),c(it)!=="svelte-ebzyrf"&&(it.textContent=Xn),Gs.forEach(l),Ya=i(e),il=n(e,"P",{"data-svelte-h":!0}),c(il)!=="svelte-18l68mc"&&(il.innerHTML=Pn),Sa=i(e),ol=n(e,"P",{"data-svelte-h":!0}),c(ol)!=="svelte-1ss2857"&&(ol.textContent=qn),Ga=i(e),r(hl.$$.fragment,e),Wa=i(e),cl=n(e,"P",{"data-svelte-h":!0}),c(cl)!=="svelte-2cqqt0"&&(cl.innerHTML=Kn),xa=i(e),r(Tl.$$.fragment,e),La=i(e),W=n(e,"H4",{class:!0});var Ws=T(W);te=n(Ws,"A",{id:!0,class:!0,href:!0});var qM=T(te);vt=n(qM,"SPAN",{});var KM=T(vt);r(yl.$$.fragment,KM),KM.forEach(l),qM.forEach(l),ln=i(Ws),ot=n(Ws,"SPAN",{"data-svelte-h":!0}),c(ot)!=="svelte-1k97flf"&&(ot.textContent=eM),Ws.forEach(l),$a=i(e),rl=n(e,"P",{"data-svelte-h":!0}),c(rl)!=="svelte-1h7dpll"&&(rl.innerHTML=lM),Ra=i(e),r(Jl.$$.fragment,e),_a=i(e),x=n(e,"H3",{class:!0});var xs=T(x);ae=n(xs,"A",{id:!0,class:!0,href:!0});var ei=T(ae);Zt=n(ei,"SPAN",{});var li=T(Zt);r(wl.$$.fragment,li),li.forEach(l),ei.forEach(l),tn=i(xs),ht=n(xs,"SPAN",{"data-svelte-h":!0}),c(ht)!=="svelte-gil39y"&&(ht.textContent=tM),xs.forEach(l),Ea=i(e),dl=n(e,"P",{"data-svelte-h":!0}),c(dl)!=="svelte-foqcg4"&&(dl.innerHTML=aM),Ba=i(e),Ul=n(e,"P",{"data-svelte-h":!0}),c(Ul)!=="svelte-83019z"&&(Ul.textContent=sM),Fa=i(e),jl=n(e,"UL",{"data-svelte-h":!0}),c(jl)!=="svelte-obduih"&&(jl.innerHTML=nM),Da=i(e),pl=n(e,"P",{"data-svelte-h":!0}),c(pl)!=="svelte-xp69b3"&&(pl.textContent=MM),Va=i(e),r(Il.$$.fragment,e),Qa=i(e),L=n(e,"H2",{class:!0});var Ls=T(L);se=n(Ls,"A",{id:!0,class:!0,href:!0});var ti=T(se);kt=n(ti,"SPAN",{});var ai=T(kt);r(fl.$$.fragment,ai),ai.forEach(l),ti.forEach(l),an=i(Ls),ct=n(Ls,"SPAN",{"data-svelte-h":!0}),c(ct)!=="svelte-13p3i57"&&(ct.textContent=iM),Ls.forEach(l),Oa=i(e),ml=n(e,"P",{"data-svelte-h":!0}),c(ml)!=="svelte-33b34v"&&(ml.innerHTML=oM),za=i(e),$=n(e,"H3",{class:!0});var $s=T($);ne=n($s,"A",{id:!0,class:!0,href:!0});var si=T(ne);Nt=n(si,"SPAN",{});var ni=T(Nt);r(ul.$$.fragment,ni),ni.forEach(l),si.forEach(l),sn=i($s),Tt=n($s,"SPAN",{"data-svelte-h":!0}),c(Tt)!=="svelte-16mlxer"&&(Tt.textContent=hM),$s.forEach(l),Ha=i(e),Cl=n(e,"P",{"data-svelte-h":!0}),c(Cl)!=="svelte-14bavev"&&(Cl.innerHTML=cM),Xa=i(e),bl=n(e,"P",{"data-svelte-h":!0}),c(bl)!=="svelte-19y0r7c"&&(bl.textContent=TM),Pa=i(e),Al=n(e,"UL",{"data-svelte-h":!0}),c(Al)!=="svelte-o7nsmh"&&(Al.innerHTML=yM),qa=i(e),r(Me.$$.fragment,e),Ka=i(e),r(ie.$$.fragment,e),es=i(e),R=n(e,"H3",{class:!0});var Rs=T(R);oe=n(Rs,"A",{id:!0,class:!0,href:!0});var Mi=T(oe);Yt=n(Mi,"SPAN",{});var ii=T(Yt);r(gl.$$.fragment,ii),ii.forEach(l),Mi.forEach(l),nn=i(Rs),yt=n(Rs,"SPAN",{"data-svelte-h":!0}),c(yt)!=="svelte-2r42d1"&&(yt.textContent=rM),Rs.forEach(l),ls=i(e),vl=n(e,"P",{"data-svelte-h":!0}),c(vl)!=="svelte-1arrz5p"&&(vl.innerHTML=JM),ts=i(e),_=n(e,"H4",{class:!0});var _s=T(_);he=n(_s,"A",{id:!0,class:!0,href:!0});var oi=T(he);St=n(oi,"SPAN",{});var hi=T(St);r(Zl.$$.fragment,hi),hi.forEach(l),oi.forEach(l),Mn=i(_s),rt=n(_s,"SPAN",{"data-svelte-h":!0}),c(rt)!=="svelte-1mzfi9m"&&(rt.textContent=wM),_s.forEach(l),as=i(e),kl=n(e,"P",{"data-svelte-h":!0}),c(kl)!=="svelte-yr0mit"&&(kl.textContent=dM),ss=i(e),r(Nl.$$.fragment,e),ns=i(e),Yl=n(e,"P",{"data-svelte-h":!0}),c(Yl)!=="svelte-gq4pgy"&&(Yl.textContent=UM),Ms=i(e),r(Sl.$$.fragment,e),is=i(e),Gl=n(e,"P",{"data-svelte-h":!0}),c(Gl)!=="svelte-20gxv"&&(Gl.textContent=jM),os=i(e),ce=n(e,"DIV",{class:!0,"data-svelte-h":!0}),c(ce)!=="svelte-1xyeqk1"&&(ce.innerHTML=pM),hs=i(e),Wl=n(e,"P",{"data-svelte-h":!0}),c(Wl)!=="svelte-7awvfp"&&(Wl.textContent=IM),cs=i(e),xl=n(e,"UL",{"data-svelte-h":!0}),c(xl)!=="svelte-76obk"&&(xl.innerHTML=fM),Ts=i(e),Ll=n(e,"P",{"data-svelte-h":!0}),c(Ll)!=="svelte-aoo47g"&&(Ll.innerHTML=mM),ys=i(e),r($l.$$.fragment,e),rs=i(e),E=n(e,"H4",{class:!0});var Es=T(E);Te=n(Es,"A",{id:!0,class:!0,href:!0});var ci=T(Te);Gt=n(ci,"SPAN",{});var Ti=T(Gt);r(Rl.$$.fragment,Ti),Ti.forEach(l),ci.forEach(l),on=i(Es),Jt=n(Es,"SPAN",{"data-svelte-h":!0}),c(Jt)!=="svelte-hd59bl"&&(Jt.textContent=uM),Es.forEach(l),Js=i(e),_l=n(e,"P",{"data-svelte-h":!0}),c(_l)!=="svelte-ymcz12"&&(_l.textContent=CM),ws=i(e),El=n(e,"P",{"data-svelte-h":!0}),c(El)!=="svelte-u5k7vk"&&(El.innerHTML=bM),ds=i(e),Bl=n(e,"P",{"data-svelte-h":!0}),c(Bl)!=="svelte-1baaith"&&(Bl.innerHTML=AM),Us=i(e),r(Fl.$$.fragment,e),js=i(e),Dl=n(e,"P",{"data-svelte-h":!0}),c(Dl)!=="svelte-15nmp2q"&&(Dl.textContent=gM),ps=i(e),r(Vl.$$.fragment,e),Is=i(e),B=n(e,"H3",{class:!0});var Bs=T(B);ye=n(Bs,"A",{id:!0,class:!0,href:!0});var yi=T(ye);Wt=n(yi,"SPAN",{});var ri=T(Wt);r(Ql.$$.fragment,ri),ri.forEach(l),yi.forEach(l),hn=i(Bs),wt=n(Bs,"SPAN",{"data-svelte-h":!0}),c(wt)!=="svelte-14yha8a"&&(wt.textContent=vM),Bs.forEach(l),fs=i(e),Ol=n(e,"P",{"data-svelte-h":!0}),c(Ol)!=="svelte-3upg4q"&&(Ol.innerHTML=ZM),ms=i(e),r(zl.$$.fragment,e),this.h()},h(){o(j,"name","hf:doc:metadata"),o(j,"content",JSON.stringify(ui)),o(m,"id","manage-huggingfacehub-cachesystem"),o(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(m,"href","#manage-huggingfacehub-cachesystem"),o(p,"class","relative group"),o(D,"id","understand-caching"),o(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(D,"href","#understand-caching"),o(C,"class","relative group"),o(V,"id","refs"),o(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(V,"href","#refs"),o(b,"class","relative group"),o(Q,"id","blobs"),o(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Q,"href","#blobs"),o(A,"class","relative group"),o(O,"id","snapshots"),o(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(O,"href","#snapshots"),o(g,"class","relative group"),o(z,"id","noexist-advanced"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#noexist-advanced"),o(v,"class","relative group"),o(H,"id","in-practice"),o(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(H,"href","#in-practice"),o(Z,"class","relative group"),o(X,"id","limitations"),o(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(X,"href","#limitations"),o(k,"class","relative group"),o(P,"id","caching-assets"),o(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(P,"href","#caching-assets"),o(N,"class","relative group"),o(K,"id","assets-in-practice"),o(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(K,"href","#assets-in-practice"),o(Y,"class","relative group"),o(ee,"id","scan-your-cache"),o(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ee,"href","#scan-your-cache"),o(S,"class","relative group"),o(le,"id","scan-cache-from-the-terminal"),o(le,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(le,"href","#scan-cache-from-the-terminal"),o(G,"class","relative group"),o(te,"id","grep-example"),o(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(te,"href","#grep-example"),o(W,"class","relative group"),o(ae,"id","scan-cache-from-python"),o(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ae,"href","#scan-cache-from-python"),o(x,"class","relative group"),o(se,"id","clean-your-cache"),o(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(se,"href","#clean-your-cache"),o(L,"class","relative group"),o(ne,"id","delete-strategy"),o(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ne,"href","#delete-strategy"),o($,"class","relative group"),o(oe,"id","clean-cache-from-the-terminal"),o(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(oe,"href","#clean-cache-from-the-terminal"),o(R,"class","relative group"),o(he,"id","using-the-tui"),o(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(he,"href","#using-the-tui"),o(_,"class","relative group"),o(ce,"class","flex justify-center"),o(Te,"id","without-tui"),o(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Te,"href","#without-tui"),o(E,"class","relative group"),o(ye,"id","clean-cache-from-python"),o(ye,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(ye,"href","#clean-cache-from-python"),o(B,"class","relative group")},m(e,t){h(document.head,j),a(e,u,t),a(e,p,t),h(p,m),h(m,dt),J(re,dt,null),h(p,Fs),h(p,Xl),a(e,$t,t),a(e,C,t),h(C,D),h(D,Ut),J(Je,Ut,null),h(C,Ds),h(C,Pl),a(e,Rt,t),a(e,we,t),a(e,_t,t),a(e,de,t),a(e,Et,t),J(Ue,e,t),a(e,Bt,t),a(e,je,t),a(e,Ft,t),a(e,pe,t),a(e,Dt,t),J(Ie,e,t),a(e,Vt,t),a(e,fe,t),a(e,Qt,t),a(e,me,t),a(e,Ot,t),J(ue,e,t),a(e,zt,t),a(e,Ce,t),a(e,Ht,t),a(e,b,t),h(b,V),h(V,jt),J(be,jt,null),h(b,Vs),h(b,ql),a(e,Xt,t),a(e,Ae,t),a(e,Pt,t),a(e,ge,t),a(e,qt,t),a(e,ve,t),a(e,Kt,t),a(e,A,t),h(A,Q),h(Q,pt),J(Ze,pt,null),h(A,Qs),h(A,Kl),a(e,ea,t),a(e,ke,t),a(e,la,t),a(e,g,t),h(g,O),h(O,It),J(Ne,It,null),h(g,Os),h(g,et),a(e,ta,t),a(e,Ye,t),a(e,aa,t),a(e,Se,t),a(e,sa,t),a(e,Ge,t),a(e,na,t),J(We,e,t),a(e,Ma,t),a(e,xe,t),a(e,ia,t),a(e,Le,t),a(e,oa,t),a(e,v,t),h(v,z),h(z,ft),J($e,ft,null),h(v,zs),h(v,lt),a(e,ha,t),a(e,Re,t),a(e,ca,t),J(_e,e,t),a(e,Ta,t),a(e,Ee,t),a(e,ya,t),a(e,Be,t),a(e,ra,t),a(e,Fe,t),a(e,Ja,t),J(De,e,t),a(e,wa,t),a(e,Z,t),h(Z,H),h(H,mt),J(Ve,mt,null),h(Z,Hs),h(Z,tt),a(e,da,t),a(e,Qe,t),a(e,Ua,t),J(Oe,e,t),a(e,ja,t),a(e,k,t),h(k,X),h(X,ut),J(ze,ut,null),h(k,Xs),h(k,at),a(e,pa,t),a(e,He,t),a(e,Ia,t),a(e,Xe,t),a(e,fa,t),a(e,Pe,t),a(e,ma,t),a(e,N,t),h(N,P),h(P,Ct),J(qe,Ct,null),h(N,Ps),h(N,st),a(e,ua,t),a(e,Ke,t),a(e,Ca,t),J(el,e,t),a(e,ba,t),J(q,e,t),a(e,Aa,t),a(e,Y,t),h(Y,K),h(K,bt),J(ll,bt,null),h(Y,qs),h(Y,nt),a(e,ga,t),a(e,tl,t),a(e,va,t),J(al,e,t),a(e,Za,t),a(e,S,t),h(S,ee),h(ee,At),J(sl,At,null),h(S,Ks),h(S,Mt),a(e,ka,t),a(e,nl,t),a(e,Na,t),a(e,G,t),h(G,le),h(le,gt),J(Ml,gt,null),h(G,en),h(G,it),a(e,Ya,t),a(e,il,t),a(e,Sa,t),a(e,ol,t),a(e,Ga,t),J(hl,e,t),a(e,Wa,t),a(e,cl,t),a(e,xa,t),J(Tl,e,t),a(e,La,t),a(e,W,t),h(W,te),h(te,vt),J(yl,vt,null),h(W,ln),h(W,ot),a(e,$a,t),a(e,rl,t),a(e,Ra,t),J(Jl,e,t),a(e,_a,t),a(e,x,t),h(x,ae),h(ae,Zt),J(wl,Zt,null),h(x,tn),h(x,ht),a(e,Ea,t),a(e,dl,t),a(e,Ba,t),a(e,Ul,t),a(e,Fa,t),a(e,jl,t),a(e,Da,t),a(e,pl,t),a(e,Va,t),J(Il,e,t),a(e,Qa,t),a(e,L,t),h(L,se),h(se,kt),J(fl,kt,null),h(L,an),h(L,ct),a(e,Oa,t),a(e,ml,t),a(e,za,t),a(e,$,t),h($,ne),h(ne,Nt),J(ul,Nt,null),h($,sn),h($,Tt),a(e,Ha,t),a(e,Cl,t),a(e,Xa,t),a(e,bl,t),a(e,Pa,t),a(e,Al,t),a(e,qa,t),J(Me,e,t),a(e,Ka,t),J(ie,e,t),a(e,es,t),a(e,R,t),h(R,oe),h(oe,Yt),J(gl,Yt,null),h(R,nn),h(R,yt),a(e,ls,t),a(e,vl,t),a(e,ts,t),a(e,_,t),h(_,he),h(he,St),J(Zl,St,null),h(_,Mn),h(_,rt),a(e,as,t),a(e,kl,t),a(e,ss,t),J(Nl,e,t),a(e,ns,t),a(e,Yl,t),a(e,Ms,t),J(Sl,e,t),a(e,is,t),a(e,Gl,t),a(e,os,t),a(e,ce,t),a(e,hs,t),a(e,Wl,t),a(e,cs,t),a(e,xl,t),a(e,Ts,t),a(e,Ll,t),a(e,ys,t),J($l,e,t),a(e,rs,t),a(e,E,t),h(E,Te),h(Te,Gt),J(Rl,Gt,null),h(E,on),h(E,Jt),a(e,Js,t),a(e,_l,t),a(e,ws,t),a(e,El,t),a(e,ds,t),a(e,Bl,t),a(e,Us,t),J(Fl,e,t),a(e,js,t),a(e,Dl,t),a(e,ps,t),J(Vl,e,t),a(e,Is,t),a(e,B,t),h(B,ye),h(ye,Wt),J(Ql,Wt,null),h(B,hn),h(B,wt),a(e,fs,t),a(e,Ol,t),a(e,ms,t),J(zl,e,t),us=!0},p(e,[t]){const Hl={};t&2&&(Hl.$$scope={dirty:t,ctx:e}),q.$set(Hl);const xt={};t&2&&(xt.$$scope={dirty:t,ctx:e}),Me.$set(xt);const Lt={};t&2&&(Lt.$$scope={dirty:t,ctx:e}),ie.$set(Lt)},i(e){us||(w(re.$$.fragment,e),w(Je.$$.fragment,e),w(Ue.$$.fragment,e),w(Ie.$$.fragment,e),w(ue.$$.fragment,e),w(be.$$.fragment,e),w(Ze.$$.fragment,e),w(Ne.$$.fragment,e),w(We.$$.fragment,e),w($e.$$.fragment,e),w(_e.$$.fragment,e),w(De.$$.fragment,e),w(Ve.$$.fragment,e),w(Oe.$$.fragment,e),w(ze.$$.fragment,e),w(qe.$$.fragment,e),w(el.$$.fragment,e),w(q.$$.fragment,e),w(ll.$$.fragment,e),w(al.$$.fragment,e),w(sl.$$.fragment,e),w(Ml.$$.fragment,e),w(hl.$$.fragment,e),w(Tl.$$.fragment,e),w(yl.$$.fragment,e),w(Jl.$$.fragment,e),w(wl.$$.fragment,e),w(Il.$$.fragment,e),w(fl.$$.fragment,e),w(ul.$$.fragment,e),w(Me.$$.fragment,e),w(ie.$$.fragment,e),w(gl.$$.fragment,e),w(Zl.$$.fragment,e),w(Nl.$$.fragment,e),w(Sl.$$.fragment,e),w($l.$$.fragment,e),w(Rl.$$.fragment,e),w(Fl.$$.fragment,e),w(Vl.$$.fragment,e),w(Ql.$$.fragment,e),w(zl.$$.fragment,e),us=!0)},o(e){d(re.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(ue.$$.fragment,e),d(be.$$.fragment,e),d(Ze.$$.fragment,e),d(Ne.$$.fragment,e),d(We.$$.fragment,e),d($e.$$.fragment,e),d(_e.$$.fragment,e),d(De.$$.fragment,e),d(Ve.$$.fragment,e),d(Oe.$$.fragment,e),d(ze.$$.fragment,e),d(qe.$$.fragment,e),d(el.$$.fragment,e),d(q.$$.fragment,e),d(ll.$$.fragment,e),d(al.$$.fragment,e),d(sl.$$.fragment,e),d(Ml.$$.fragment,e),d(hl.$$.fragment,e),d(Tl.$$.fragment,e),d(yl.$$.fragment,e),d(Jl.$$.fragment,e),d(wl.$$.fragment,e),d(Il.$$.fragment,e),d(fl.$$.fragment,e),d(ul.$$.fragment,e),d(Me.$$.fragment,e),d(ie.$$.fragment,e),d(gl.$$.fragment,e),d(Zl.$$.fragment,e),d(Nl.$$.fragment,e),d(Sl.$$.fragment,e),d($l.$$.fragment,e),d(Rl.$$.fragment,e),d(Fl.$$.fragment,e),d(Vl.$$.fragment,e),d(Ql.$$.fragment,e),d(zl.$$.fragment,e),us=!1},d(e){e&&(l(u),l(p),l($t),l(C),l(Rt),l(we),l(_t),l(de),l(Et),l(Bt),l(je),l(Ft),l(pe),l(Dt),l(Vt),l(fe),l(Qt),l(me),l(Ot),l(zt),l(Ce),l(Ht),l(b),l(Xt),l(Ae),l(Pt),l(ge),l(qt),l(ve),l(Kt),l(A),l(ea),l(ke),l(la),l(g),l(ta),l(Ye),l(aa),l(Se),l(sa),l(Ge),l(na),l(Ma),l(xe),l(ia),l(Le),l(oa),l(v),l(ha),l(Re),l(ca),l(Ta),l(Ee),l(ya),l(Be),l(ra),l(Fe),l(Ja),l(wa),l(Z),l(da),l(Qe),l(Ua),l(ja),l(k),l(pa),l(He),l(Ia),l(Xe),l(fa),l(Pe),l(ma),l(N),l(ua),l(Ke),l(Ca),l(ba),l(Aa),l(Y),l(ga),l(tl),l(va),l(Za),l(S),l(ka),l(nl),l(Na),l(G),l(Ya),l(il),l(Sa),l(ol),l(Ga),l(Wa),l(cl),l(xa),l(La),l(W),l($a),l(rl),l(Ra),l(_a),l(x),l(Ea),l(dl),l(Ba),l(Ul),l(Fa),l(jl),l(Da),l(pl),l(Va),l(Qa),l(L),l(Oa),l(ml),l(za),l($),l(Ha),l(Cl),l(Xa),l(bl),l(Pa),l(Al),l(qa),l(Ka),l(es),l(R),l(ls),l(vl),l(ts),l(_),l(as),l(kl),l(ss),l(ns),l(Yl),l(Ms),l(is),l(Gl),l(os),l(ce),l(hs),l(Wl),l(cs),l(xl),l(Ts),l(Ll),l(ys),l(rs),l(E),l(Js),l(_l),l(ws),l(El),l(ds),l(Bl),l(Us),l(js),l(Dl),l(ps),l(Is),l(B),l(fs),l(Ol),l(ms)),l(j),U(re),U(Je),U(Ue,e),U(Ie,e),U(ue,e),U(be),U(Ze),U(Ne),U(We,e),U($e),U(_e,e),U(De,e),U(Ve),U(Oe,e),U(ze),U(qe),U(el,e),U(q,e),U(ll),U(al,e),U(sl),U(Ml),U(hl,e),U(Tl,e),U(yl),U(Jl,e),U(wl),U(Il,e),U(fl),U(ul),U(Me,e),U(ie,e),U(gl),U(Zl),U(Nl,e),U(Sl,e),U($l,e),U(Rl),U(Fl,e),U(Vl,e),U(Ql),U(zl,e)}}}const ui={local:"manage-huggingfacehub-cachesystem",sections:[{local:"understand-caching",sections:[{local:"refs",title:"Refs"},{local:"blobs",title:"Blobs"},{local:"snapshots",title:"Snapshots"},{local:"noexist-advanced",title:".no_exist (advanced)"},{local:"in-practice",title:"In practice"},{local:"limitations",title:"Limitations"}],title:"Understand caching"},{local:"caching-assets",sections:[{local:"assets-in-practice",title:"Assets in practice"}],title:"Caching assets"},{local:"scan-your-cache",sections:[{local:"scan-cache-from-the-terminal",sections:[{local:"grep-example",title:"Grep example"}],title:"Scan cache from the terminal"},{local:"scan-cache-from-python",title:"Scan cache from Python"}],title:"Scan your cache"},{local:"clean-your-cache",sections:[{local:"delete-strategy",title:"Delete strategy"},{local:"clean-cache-from-the-terminal",sections:[{local:"using-the-tui",title:"Using the TUI"},{local:"without-tui",title:"Without TUI"}],title:"Clean cache from the terminal"},{local:"clean-cache-from-python",title:"Clean cache from Python"}],title:"Clean your cache"}],title:"Manage `huggingface_hub` cache-system"};function Ci(F){return wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ki extends di{constructor(j){super(),Ui(this,j,Ci,mi,Ji,{})}}export{ki as component};
