import{s as mt,o as rt,n as pt}from"../chunks/scheduler.182ea377.js";import{S as ct,i as dt,g as a,s as n,r as c,A as ut,h as p,f as l,c as o,j as st,u as d,x as m,k as te,y as ft,a as i,v as u,d as f,t as y,w as h}from"../chunks/index.1ea56653.js";import{H as He,g as yt}from"../chunks/Heading.71ac6e9f.js";import{T as at}from"../chunks/Tip.67abc998.js";import{C as M}from"../chunks/CodeBlock.82c2494b.js";import{D as ht}from"../chunks/DocNotebookDropdown.b1496a40.js";function bt(ee){let s,b="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){s=a("p"),s.textContent=b},l(r){s=p(r,"P",{"data-svelte-h":!0}),m(s)!=="svelte-154jbq5"&&(s.textContent=b)},m(r,w){i(r,s,w)},p:pt,d(r){r&&l(s)}}}function Mt(ee){let s,b='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){s=a("p"),s.innerHTML=b},l(r){s=p(r,"P",{"data-svelte-h":!0}),m(s)!=="svelte-ptu9pr"&&(s.innerHTML=b)},m(r,w){i(r,s,w)},p:pt,d(r){r&&l(s)}}}function wt(ee){let s,b,r,w,v,ie,V,ne,$,oe,C,Ne='Community pipelines are any <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',se,j,Ee='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',ae,k,Xe='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',pe,T,me,W,re,x,Qe='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',ce,G,de,I,Se='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',ue,B,fe,R,Le="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",ye,H,ze="This section shows how users should use community components to build a community pipeline.",he,N,Fe='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example. So, let’s start loading the components:',be,E,Pe="<li>Import and load the text encoder from Transformers:</li>",Me,X,we,U,Ye="<li>Load a scheduler:</li>",Te,Q,Ue,g,qe="<li>Load an image processor:</li>",ge,S,_e,_,Je,J,De='<li>Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in the <code>showone_unet_3d_condition.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">script</a> for your convenience. You’ll notice the <code>UNet3DConditionModel</code> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/main/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in the <code>showone_unet_3d_condition.py</code> script.</li>',Ze,L,Ae="Once this is done, you can initialize the UNet:",ve,z,Ve,Z,Oe='<li>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in the <code>pipeline_t2v_base_pixel.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">script</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in the <code>pipeline_t2v_base_pixel.py</code> script.</li>',$e,F,Ke="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",Ce,P,je,Y,et="Push the pipeline to the Hub to share with the community!",ke,q,We,D,tt="After the pipeline is successfully pushed, you need a couple of changes:",xe,A,lt='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow"><code>model_index.json</code></a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li>',Ge,O,it="To run inference, simply add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",Ie,K,Be,le,Re;return v=new He({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),V=new ht({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),$=new He({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),T=new at({props:{warning:!0,$$slots:{default:[bt]},$$scope:{ctx:ee}}}),W=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),B=new He({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),X=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),Q=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),_=new at({props:{warning:!0,$$slots:{default:[Mt]},$$scope:{ctx:ee}}}),z=new M({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),P=new M({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),q=new M({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),K=new M({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),{c(){s=a("meta"),b=n(),r=a("p"),w=n(),c(v.$$.fragment),ie=n(),c(V.$$.fragment),ne=n(),c($.$$.fragment),oe=n(),C=a("p"),C.innerHTML=Ne,se=n(),j=a("p"),j.innerHTML=Ee,ae=n(),k=a("p"),k.innerHTML=Xe,pe=n(),c(T.$$.fragment),me=n(),c(W.$$.fragment),re=n(),x=a("p"),x.innerHTML=Qe,ce=n(),c(G.$$.fragment),de=n(),I=a("p"),I.innerHTML=Se,ue=n(),c(B.$$.fragment),fe=n(),R=a("p"),R.textContent=Le,ye=n(),H=a("p"),H.textContent=ze,he=n(),N=a("p"),N.innerHTML=Fe,be=n(),E=a("ol"),E.innerHTML=Pe,Me=n(),c(X.$$.fragment),we=n(),U=a("ol"),U.innerHTML=Ye,Te=n(),c(Q.$$.fragment),Ue=n(),g=a("ol"),g.innerHTML=qe,ge=n(),c(S.$$.fragment),_e=n(),c(_.$$.fragment),Je=n(),J=a("ol"),J.innerHTML=De,Ze=n(),L=a("p"),L.textContent=Ae,ve=n(),c(z.$$.fragment),Ve=n(),Z=a("ol"),Z.innerHTML=Oe,$e=n(),F=a("p"),F.innerHTML=Ke,Ce=n(),c(P.$$.fragment),je=n(),Y=a("p"),Y.textContent=et,ke=n(),c(q.$$.fragment),We=n(),D=a("p"),D.textContent=tt,xe=n(),A=a("ol"),A.innerHTML=lt,Ge=n(),O=a("p"),O.innerHTML=it,Ie=n(),c(K.$$.fragment),Be=n(),le=a("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);s=p(t,"META",{name:!0,content:!0}),t.forEach(l),b=o(e),r=p(e,"P",{}),st(r).forEach(l),w=o(e),d(v.$$.fragment,e),ie=o(e),d(V.$$.fragment,e),ne=o(e),d($.$$.fragment,e),oe=o(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1yn8qeb"&&(C.innerHTML=Ne),se=o(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-10en0rk"&&(j.innerHTML=Ee),ae=o(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-1mmnk2f"&&(k.innerHTML=Xe),pe=o(e),d(T.$$.fragment,e),me=o(e),d(W.$$.fragment,e),re=o(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1yyre8w"&&(x.innerHTML=Qe),ce=o(e),d(G.$$.fragment,e),de=o(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1ho2g1z"&&(I.innerHTML=Se),ue=o(e),d(B.$$.fragment,e),fe=o(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-1vh7uou"&&(R.textContent=Le),ye=o(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-phpvnj"&&(H.textContent=ze),he=o(e),N=p(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-7sknw0"&&(N.innerHTML=Fe),be=o(e),E=p(e,"OL",{"data-svelte-h":!0}),m(E)!=="svelte-8ccbl9"&&(E.innerHTML=Pe),Me=o(e),d(X.$$.fragment,e),we=o(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-1rtkhjg"&&(U.innerHTML=Ye),Te=o(e),d(Q.$$.fragment,e),Ue=o(e),g=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(g)!=="svelte-o9t4x9"&&(g.innerHTML=qe),ge=o(e),d(S.$$.fragment,e),_e=o(e),d(_.$$.fragment,e),Je=o(e),J=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(J)!=="svelte-2m7lmo"&&(J.innerHTML=De),Ze=o(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-4yol19"&&(L.textContent=Ae),ve=o(e),d(z.$$.fragment,e),Ve=o(e),Z=p(e,"OL",{start:!0,"data-svelte-h":!0}),m(Z)!=="svelte-1m9qhhm"&&(Z.innerHTML=Oe),$e=o(e),F=p(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1jpprmd"&&(F.innerHTML=Ke),Ce=o(e),d(P.$$.fragment,e),je=o(e),Y=p(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-14lz5yb"&&(Y.textContent=et),ke=o(e),d(q.$$.fragment,e),We=o(e),D=p(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-azdq2p"&&(D.textContent=tt),xe=o(e),A=p(e,"OL",{"data-svelte-h":!0}),m(A)!=="svelte-7wsjmh"&&(A.innerHTML=lt),Ge=o(e),O=p(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-xpz58c"&&(O.innerHTML=it),Ie=o(e),d(K.$$.fragment,e),Be=o(e),le=p(e,"P",{}),st(le).forEach(l),this.h()},h(){te(s,"name","hf:doc:metadata"),te(s,"content",Tt),te(U,"start","2"),te(g,"start","3"),te(J,"start","4"),te(Z,"start","5")},m(e,t){ft(document.head,s),i(e,b,t),i(e,r,t),i(e,w,t),u(v,e,t),i(e,ie,t),u(V,e,t),i(e,ne,t),u($,e,t),i(e,oe,t),i(e,C,t),i(e,se,t),i(e,j,t),i(e,ae,t),i(e,k,t),i(e,pe,t),u(T,e,t),i(e,me,t),u(W,e,t),i(e,re,t),i(e,x,t),i(e,ce,t),u(G,e,t),i(e,de,t),i(e,I,t),i(e,ue,t),u(B,e,t),i(e,fe,t),i(e,R,t),i(e,ye,t),i(e,H,t),i(e,he,t),i(e,N,t),i(e,be,t),i(e,E,t),i(e,Me,t),u(X,e,t),i(e,we,t),i(e,U,t),i(e,Te,t),u(Q,e,t),i(e,Ue,t),i(e,g,t),i(e,ge,t),u(S,e,t),i(e,_e,t),u(_,e,t),i(e,Je,t),i(e,J,t),i(e,Ze,t),i(e,L,t),i(e,ve,t),u(z,e,t),i(e,Ve,t),i(e,Z,t),i(e,$e,t),i(e,F,t),i(e,Ce,t),u(P,e,t),i(e,je,t),i(e,Y,t),i(e,ke,t),u(q,e,t),i(e,We,t),i(e,D,t),i(e,xe,t),i(e,A,t),i(e,Ge,t),i(e,O,t),i(e,Ie,t),u(K,e,t),i(e,Be,t),i(e,le,t),Re=!0},p(e,[t]){const nt={};t&2&&(nt.$$scope={dirty:t,ctx:e}),T.$set(nt);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),_.$set(ot)},i(e){Re||(f(v.$$.fragment,e),f(V.$$.fragment,e),f($.$$.fragment,e),f(T.$$.fragment,e),f(W.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(X.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(_.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),Re=!0)},o(e){y(v.$$.fragment,e),y(V.$$.fragment,e),y($.$$.fragment,e),y(T.$$.fragment,e),y(W.$$.fragment,e),y(G.$$.fragment,e),y(B.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(S.$$.fragment,e),y(_.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),Re=!1},d(e){e&&(l(b),l(r),l(w),l(ie),l(ne),l(oe),l(C),l(se),l(j),l(ae),l(k),l(pe),l(me),l(re),l(x),l(ce),l(de),l(I),l(ue),l(fe),l(R),l(ye),l(H),l(he),l(N),l(be),l(E),l(Me),l(we),l(U),l(Te),l(Ue),l(g),l(ge),l(_e),l(Je),l(J),l(Ze),l(L),l(ve),l(Ve),l(Z),l($e),l(F),l(Ce),l(je),l(Y),l(ke),l(We),l(D),l(xe),l(A),l(Ge),l(O),l(Ie),l(Be),l(le)),l(s),h(v,e),h(V,e),h($,e),h(T,e),h(W,e),h(G,e),h(B,e),h(X,e),h(Q,e),h(S,e),h(_,e),h(z,e),h(P,e),h(q,e),h(K,e)}}}const Tt='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function Ut(ee){return rt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=yt}),[]}class $t extends ct{constructor(s){super(),dt(this,s,Ut,wt,mt,{})}}export{$t as component};
