import{s as jn,o as Zn,n as Un}from"../chunks/scheduler.182ea377.js";import{S as In,i as xn,g as l,s,r as f,A as Wn,h as o,f as n,c as a,j as w,u,x as p,k as T,y as r,a as i,v as h,d as g,t as M,w as b}from"../chunks/index.1ea56653.js";import{H as Z,g as $n}from"../chunks/Heading.71ac6e9f.js";import{T as vn}from"../chunks/Tip.67abc998.js";import{D as U}from"../chunks/Docstring.59aaf0cd.js";import{C as Ut}from"../chunks/CodeBlock.82c2494b.js";function kn(ve){let c,J="AnimateDiff tends to work better with finetuned Stable Diffusion models. If you plan on using a scheduler that can clip samples, make sure to disable it by setting <code>clip_sample=False</code> in the scheduler as this can also have an adverse effect on generated samples.";return{c(){c=l("p"),c.innerHTML=J},l(y){c=o(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-lcbq6f"&&(c.innerHTML=J)},m(y,I){i(y,c,I)},p:Un,d(y){y&&n(c)}}}function An(ve){let c,J='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){c=l("p"),c.innerHTML=J},l(y){c=o(y,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1wmc0l4"&&(c.innerHTML=J)},m(y,I){i(y,c,I)},p:Un,d(y){y&&n(c)}}}function Cn(ve){let c,J,y,I,B,Re,R,Xe,X,zt='<a href="https://arxiv.org/abs/2307.04725" rel="nofollow">AnimateDiff: Animate Your Personalized Text-to-Image Diffusion Models without Specific Tuning</a> by Yuwei Guo, Ceyuan Yang, Anyi Rao, Yaohui Wang, Yu Qiao, Dahua Lin, Bo Dai.',Se,S,Qt="The abstract of the paper is the following:",Ee,E,Ht='<em>With the advance of text-to-image models (e.g., Stable Diffusion) and corresponding personalization techniques such as DreamBooth and LoRA, everyone can manifest their imagination into high-quality images at an affordable cost. Subsequently, there is a great demand for image animation techniques to further combine generated static images with motion dynamics. In this report, we propose a practical framework to animate most of the existing personalized text-to-image models once and for all, saving efforts in model-specific tuning. At the core of the proposed framework is to insert a newly initialized motion modeling module into the frozen text-to-image model and train it on video clips to distill reasonable motion priors. Once trained, by simply injecting this motion modeling module, all personalized versions derived from the same base T2I readily become text-driven models that produce diverse and personalized animated images. We conduct our evaluation on several public representative personalized text-to-image models across anime pictures and realistic photographs, and demonstrate that our proposed framework helps these models generate temporally smooth animation clips while preserving the domain and diversity of their outputs. Code and pre-trained weights will be publicly available at <a href="https://animatediff.github.io/" rel="nofollow">this https URL</a>.</em>',Fe,F,Ye,Y,Lt='<thead><tr><th>Pipeline</th> <th>Tasks</th> <th align="center">Demo</th></tr></thead> <tbody><tr><td><a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py" rel="nofollow">AnimateDiffPipeline</a></td> <td><em>Text-to-Video Generation with AnimateDiff</em></td> <td align="center"></td></tr></tbody>',Ne,N,Pe,P,qt='Motion Adapter checkpoints can be found under <a href="https://huggingface.co/guoyww/" rel="nofollow">guoyww</a>. These checkpoints are meant to work with any model based on Stable Diffusion 1.4/1.5.',ze,z,Qe,Q,Ot="AnimateDiff works with a MotionAdapter checkpoint and a Stable Diffusion model checkpoint. The MotionAdapter is a collection of Motion Modules that are responsible for adding coherent motion across image frames. These modules are applied after the Resnet and Attention blocks in Stable Diffusion UNet.",He,H,Kt="The following example demonstrates how to use a <em>MotionAdapter</em> checkpoint with Diffusers for inference based on StableDiffusion-1.4/1.5.",Le,L,qe,q,en="Here are some sample outputs:",Oe,O,tn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-realistic-doc.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,Ke,x,et,K,tt,ee,nn="Motion LoRAs are a collection of LoRAs that work with the <code>guoyww/animatediff-motion-adapter-v1-5-2</code> checkpoint. These LoRAs are responsible for adding specific types of motion to the animations.",nt,te,it,ne,sn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,st,ie,at,se,an='You can also leverage the <a href="https://github.com/huggingface/peft" rel="nofollow">PEFT</a> backend to combine Motion LoRA’s and create more complex animations.',lt,ae,ln="First install PEFT with",ot,le,rt,oe,on="Then you can use the following code to combine Motion LoRAs.",pt,re,dt,pe,rn=`<tbody><tr><td><center>masterpiece, bestquality, sunset.
        <br/> <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/animatediff-zoom-out-pan-left-lora.gif" alt="masterpiece, bestquality, sunset" style="width: 300px;"/></center></td></tr></tbody>`,ct,W,mt,de,ft,d,ce,jt,Ue,pn="Pipeline for text-to-video generation.",Zt,je,dn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,It,v,me,xt,Ze,cn="The call function to the pipeline for generation.",Wt,Ie,mn="Examples:",$t,$,fe,kt,xe,fn="Disables the FreeU mechanism if enabled.",At,k,ue,Ct,We,un=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Dt,A,he,Gt,$e,hn=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Vt,_,ge,Bt,ke,gn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Rt,Ae,Mn="The suffixes after the scaling factors represent the stages where they are being applied.",Xt,Ce,bn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,St,C,Me,Et,De,yn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ft,D,be,Yt,Ge,_n=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Nt,G,ye,Pt,Ve,wn="Encodes the prompt into text encoder hidden states.",ut,_e,Tn="<li>enable_freeu</li> <li>disable_freeu</li> <li>enable_vae_slicing</li> <li>disable_vae_slicing</li> <li>enable_vae_tiling</li> <li>disable_vae_tiling</li>",ht,we,gt,Te,Je,Mt,Be,bt;return B=new Z({props:{title:"Text-to-Video Generation with AnimateDiff",local:"text-to-video-generation-with-animatediff",headingTag:"h1"}}),R=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),F=new Z({props:{title:"Available Pipelines",local:"available-pipelines",headingTag:"h2"}}),N=new Z({props:{title:"Available checkpoints",local:"available-checkpoints",headingTag:"h2"}}),z=new Z({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),L=new Ut({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter)
scheduler = DDIMScheduler.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>, clip_sample=<span class="hljs-literal">False</span>, timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>, steps_offset=<span class="hljs-number">1</span>
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),x=new vn({props:{$$slots:{default:[kn]},$$scope:{ctx:ve}}}),K=new Z({props:{title:"Using Motion LoRAs",local:"using-motion-loras",headingTag:"h2"}}),te=new Ut({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)

scheduler = DDIMScheduler.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>, clip_sample=<span class="hljs-literal">False</span>, timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>, steps_offset=<span class="hljs-number">1</span>
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ie=new Z({props:{title:"Using Motion LoRAs with PEFT",local:"using-motion-loras-with-peft",headingTag:"h2"}}),le=new Ut({props:{code:"cGlwJTIwaW5zdGFsbCUyMHBlZnQ=",highlighted:"pip install peft",wrap:!1}}),re=new Ut({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

<span class="hljs-comment"># Load the motion adapter</span>
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>)
<span class="hljs-comment"># load SD 1.5 based finetuned model</span>
model_id = <span class="hljs-string">&quot;SG161222/Realistic_Vision_V5.1_noVAE&quot;</span>
pipe = AnimateDiffPipeline.from_pretrained(model_id, motion_adapter=adapter)

pipe.load_lora_weights(<span class="hljs-string">&quot;diffusers/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;diffusers/animatediff-motion-lora-pan-left&quot;</span>, adapter_name=<span class="hljs-string">&quot;pan-left&quot;</span>)
pipe.set_adapters([<span class="hljs-string">&quot;zoom-out&quot;</span>, <span class="hljs-string">&quot;pan-left&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>])

scheduler = DDIMScheduler.from_pretrained(
    model_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>, clip_sample=<span class="hljs-literal">False</span>, timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>, steps_offset=<span class="hljs-number">1</span>
)
pipe.scheduler = scheduler

<span class="hljs-comment"># enable memory savings</span>
pipe.enable_vae_slicing()
pipe.enable_model_cpu_offload()

output = pipe(
    prompt=(
        <span class="hljs-string">&quot;masterpiece, bestquality, highlydetailed, ultradetailed, sunset, &quot;</span>
        <span class="hljs-string">&quot;orange sky, warm lighting, fishing boats, ocean waves seagulls, &quot;</span>
        <span class="hljs-string">&quot;rippling water, wharf, silhouette, serene atmosphere, dusk, evening glow, &quot;</span>
        <span class="hljs-string">&quot;golden hour, coastal landscape, seaside scenery&quot;</span>
    ),
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">42</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),W=new vn({props:{$$slots:{default:[An]},$$scope:{ctx:ve}}}),de=new Z({props:{title:"AnimateDiffPipeline",local:"diffusers.AnimateDiffPipeline",headingTag:"h2"}}),ce=new U({props:{name:"class diffusers.AnimateDiffPipeline",anchor:"diffusers.AnimateDiffPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"motion_adapter",val:": MotionAdapter"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim.DDIMScheduler, diffusers.schedulers.scheduling_pndm.PNDMScheduler, diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler, diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler, diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler]"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AnimateDiffPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.AnimateDiffPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.AnimateDiffPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetMotionModel to denoise the encoded video latents.`,name:"unet"},{anchor:"diffusers.AnimateDiffPipeline.motion_adapter",description:`<strong>motion_adapter</strong> (<code>MotionAdapter</code>) &#x2014;
A <code>MotionAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded video latents.`,name:"motion_adapter"},{anchor:"diffusers.AnimateDiffPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L80"}}),me=new U({props:{name:"__call__",anchor:"diffusers.AnimateDiffPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[int] = 16"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": typing.Union[typing.Callable[[int, int, torch.FloatTensor], NoneType], NoneType] = None"},{name:"callback_steps",val:": typing.Optional[int] = 1"},{name:"cross_attention_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated video.`,name:"height"},{anchor:"diffusers.AnimateDiffPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated video.`,name:"width"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of video frames that are generated. Defaults to 16 frames which at 8 frames per seconds
amounts to 2 seconds of video.`,name:"num_frames"},{anchor:"diffusers.AnimateDiffPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality videos at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AnimateDiffPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AnimateDiffPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for video
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>. Latents should be of shape
<code>(batch_size, num_channel, num_frames, height, width)</code>.`,name:"latents"},{anchor:"diffusers.AnimateDiffPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated video. Choose between <code>torch.FloatTensor</code>, <code>PIL.Image</code> or
<code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.AnimateDiffPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput">TextToVideoSDPipelineOutput</a> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AnimateDiffPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AnimateDiffPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AnimateDiffPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated frames.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/text_to_video#diffusers.pipelines.text_to_video_synthesis.TextToVideoSDPipelineOutput"
>TextToVideoSDPipelineOutput</a> or <code>tuple</code></p>
`}}),fe=new U({props:{name:"disable_freeu",anchor:"diffusers.AnimateDiffPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L397"}}),ue=new U({props:{name:"disable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L349"}}),he=new U({props:{name:"disable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L366"}}),ge=new U({props:{name:"enable_freeu",anchor:"diffusers.AnimateDiffPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.AnimateDiffPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L374"}}),Me=new U({props:{name:"enable_vae_slicing",anchor:"diffusers.AnimateDiffPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L341"}}),be=new U({props:{name:"enable_vae_tiling",anchor:"diffusers.AnimateDiffPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L357"}}),ye=new U({props:{name:"encode_prompt",anchor:"diffusers.AnimateDiffPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.AnimateDiffPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L135"}}),we=new Z({props:{title:"AnimateDiffPipelineOutput",local:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",headingTag:"h2"}}),Je=new U({props:{name:"class diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",anchor:"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput",parameters:[{name:"frames",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/animatediff/pipeline_animatediff.py#L76"}}),{c(){c=l("meta"),J=s(),y=l("p"),I=s(),f(B.$$.fragment),Re=s(),f(R.$$.fragment),Xe=s(),X=l("p"),X.innerHTML=zt,Se=s(),S=l("p"),S.textContent=Qt,Ee=s(),E=l("p"),E.innerHTML=Ht,Fe=s(),f(F.$$.fragment),Ye=s(),Y=l("table"),Y.innerHTML=Lt,Ne=s(),f(N.$$.fragment),Pe=s(),P=l("p"),P.innerHTML=qt,ze=s(),f(z.$$.fragment),Qe=s(),Q=l("p"),Q.textContent=Ot,He=s(),H=l("p"),H.innerHTML=Kt,Le=s(),f(L.$$.fragment),qe=s(),q=l("p"),q.textContent=en,Oe=s(),O=l("table"),O.innerHTML=tn,Ke=s(),f(x.$$.fragment),et=s(),f(K.$$.fragment),tt=s(),ee=l("p"),ee.innerHTML=nn,nt=s(),f(te.$$.fragment),it=s(),ne=l("table"),ne.innerHTML=sn,st=s(),f(ie.$$.fragment),at=s(),se=l("p"),se.innerHTML=an,lt=s(),ae=l("p"),ae.textContent=ln,ot=s(),f(le.$$.fragment),rt=s(),oe=l("p"),oe.textContent=on,pt=s(),f(re.$$.fragment),dt=s(),pe=l("table"),pe.innerHTML=rn,ct=s(),f(W.$$.fragment),mt=s(),f(de.$$.fragment),ft=s(),d=l("div"),f(ce.$$.fragment),jt=s(),Ue=l("p"),Ue.textContent=pn,Zt=s(),je=l("p"),je.innerHTML=dn,It=s(),v=l("div"),f(me.$$.fragment),xt=s(),Ze=l("p"),Ze.textContent=cn,Wt=s(),Ie=l("p"),Ie.textContent=mn,$t=s(),$=l("div"),f(fe.$$.fragment),kt=s(),xe=l("p"),xe.textContent=fn,At=s(),k=l("div"),f(ue.$$.fragment),Ct=s(),We=l("p"),We.innerHTML=un,Dt=s(),A=l("div"),f(he.$$.fragment),Gt=s(),$e=l("p"),$e.innerHTML=hn,Vt=s(),_=l("div"),f(ge.$$.fragment),Bt=s(),ke=l("p"),ke.innerHTML=gn,Rt=s(),Ae=l("p"),Ae.textContent=Mn,Xt=s(),Ce=l("p"),Ce.innerHTML=bn,St=s(),C=l("div"),f(Me.$$.fragment),Et=s(),De=l("p"),De.textContent=yn,Ft=s(),D=l("div"),f(be.$$.fragment),Yt=s(),Ge=l("p"),Ge.textContent=_n,Nt=s(),G=l("div"),f(ye.$$.fragment),Pt=s(),Ve=l("p"),Ve.textContent=wn,ut=s(),_e=l("ul"),_e.innerHTML=Tn,ht=s(),f(we.$$.fragment),gt=s(),Te=l("div"),f(Je.$$.fragment),Mt=s(),Be=l("p"),this.h()},l(e){const t=Wn("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(n),J=a(e),y=o(e,"P",{}),w(y).forEach(n),I=a(e),u(B.$$.fragment,e),Re=a(e),u(R.$$.fragment,e),Xe=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1heixsu"&&(X.innerHTML=zt),Se=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-wu27l3"&&(S.textContent=Qt),Ee=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-17654bv"&&(E.innerHTML=Ht),Fe=a(e),u(F.$$.fragment,e),Ye=a(e),Y=o(e,"TABLE",{"data-svelte-h":!0}),p(Y)!=="svelte-1es4wyd"&&(Y.innerHTML=Lt),Ne=a(e),u(N.$$.fragment,e),Pe=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1eu5pwh"&&(P.innerHTML=qt),ze=a(e),u(z.$$.fragment,e),Qe=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-q9bvzo"&&(Q.textContent=Ot),He=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-o3l8n4"&&(H.innerHTML=Kt),Le=a(e),u(L.$$.fragment,e),qe=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1pxzje"&&(q.textContent=en),Oe=a(e),O=o(e,"TABLE",{"data-svelte-h":!0}),p(O)!=="svelte-5250wa"&&(O.innerHTML=tn),Ke=a(e),u(x.$$.fragment,e),et=a(e),u(K.$$.fragment,e),tt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-u1dwwg"&&(ee.innerHTML=nn),nt=a(e),u(te.$$.fragment,e),it=a(e),ne=o(e,"TABLE",{"data-svelte-h":!0}),p(ne)!=="svelte-16prig"&&(ne.innerHTML=sn),st=a(e),u(ie.$$.fragment,e),at=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1gecok3"&&(se.innerHTML=an),lt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-26fcye"&&(ae.textContent=ln),ot=a(e),u(le.$$.fragment,e),rt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1e37vkb"&&(oe.textContent=on),pt=a(e),u(re.$$.fragment,e),dt=a(e),pe=o(e,"TABLE",{"data-svelte-h":!0}),p(pe)!=="svelte-3p6096"&&(pe.innerHTML=rn),ct=a(e),u(W.$$.fragment,e),mt=a(e),u(de.$$.fragment,e),ft=a(e),d=o(e,"DIV",{class:!0});var m=w(d);u(ce.$$.fragment,m),jt=a(m),Ue=o(m,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-19ipoo4"&&(Ue.textContent=pn),Zt=a(m),je=o(m,"P",{"data-svelte-h":!0}),p(je)!=="svelte-496sm0"&&(je.innerHTML=dn),It=a(m),v=o(m,"DIV",{class:!0});var j=w(v);u(me.$$.fragment,j),xt=a(j),Ze=o(j,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-50j04k"&&(Ze.textContent=cn),Wt=a(j),Ie=o(j,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-kvfsh7"&&(Ie.textContent=mn),j.forEach(n),$t=a(m),$=o(m,"DIV",{class:!0});var yt=w($);u(fe.$$.fragment,yt),kt=a(yt),xe=o(yt,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-psupw6"&&(xe.textContent=fn),yt.forEach(n),At=a(m),k=o(m,"DIV",{class:!0});var _t=w(k);u(ue.$$.fragment,_t),Ct=a(_t),We=o(_t,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1s3c06i"&&(We.innerHTML=un),_t.forEach(n),Dt=a(m),A=o(m,"DIV",{class:!0});var wt=w(A);u(he.$$.fragment,wt),Gt=a(wt),$e=o(wt,"P",{"data-svelte-h":!0}),p($e)!=="svelte-pkn4ui"&&($e.innerHTML=hn),wt.forEach(n),Vt=a(m),_=o(m,"DIV",{class:!0});var V=w(_);u(ge.$$.fragment,V),Bt=a(V),ke=o(V,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1f3tmq1"&&(ke.innerHTML=gn),Rt=a(V),Ae=o(V,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-xjijlp"&&(Ae.textContent=Mn),Xt=a(V),Ce=o(V,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-hy0nzs"&&(Ce.innerHTML=bn),V.forEach(n),St=a(m),C=o(m,"DIV",{class:!0});var Tt=w(C);u(Me.$$.fragment,Tt),Et=a(Tt),De=o(Tt,"P",{"data-svelte-h":!0}),p(De)!=="svelte-14bnrb6"&&(De.textContent=yn),Tt.forEach(n),Ft=a(m),D=o(m,"DIV",{class:!0});var Jt=w(D);u(be.$$.fragment,Jt),Yt=a(Jt),Ge=o(Jt,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1xwrf7t"&&(Ge.textContent=_n),Jt.forEach(n),Nt=a(m),G=o(m,"DIV",{class:!0});var vt=w(G);u(ye.$$.fragment,vt),Pt=a(vt),Ve=o(vt,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-16q0ax1"&&(Ve.textContent=wn),vt.forEach(n),m.forEach(n),ut=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-17fwsy1"&&(_e.innerHTML=Tn),ht=a(e),u(we.$$.fragment,e),gt=a(e),Te=o(e,"DIV",{class:!0});var Jn=w(Te);u(Je.$$.fragment,Jn),Jn.forEach(n),Mt=a(e),Be=o(e,"P",{}),w(Be).forEach(n),this.h()},h(){T(c,"name","hf:doc:metadata"),T(c,"content",Dn),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,c),i(e,J,t),i(e,y,t),i(e,I,t),h(B,e,t),i(e,Re,t),h(R,e,t),i(e,Xe,t),i(e,X,t),i(e,Se,t),i(e,S,t),i(e,Ee,t),i(e,E,t),i(e,Fe,t),h(F,e,t),i(e,Ye,t),i(e,Y,t),i(e,Ne,t),h(N,e,t),i(e,Pe,t),i(e,P,t),i(e,ze,t),h(z,e,t),i(e,Qe,t),i(e,Q,t),i(e,He,t),i(e,H,t),i(e,Le,t),h(L,e,t),i(e,qe,t),i(e,q,t),i(e,Oe,t),i(e,O,t),i(e,Ke,t),h(x,e,t),i(e,et,t),h(K,e,t),i(e,tt,t),i(e,ee,t),i(e,nt,t),h(te,e,t),i(e,it,t),i(e,ne,t),i(e,st,t),h(ie,e,t),i(e,at,t),i(e,se,t),i(e,lt,t),i(e,ae,t),i(e,ot,t),h(le,e,t),i(e,rt,t),i(e,oe,t),i(e,pt,t),h(re,e,t),i(e,dt,t),i(e,pe,t),i(e,ct,t),h(W,e,t),i(e,mt,t),h(de,e,t),i(e,ft,t),i(e,d,t),h(ce,d,null),r(d,jt),r(d,Ue),r(d,Zt),r(d,je),r(d,It),r(d,v),h(me,v,null),r(v,xt),r(v,Ze),r(v,Wt),r(v,Ie),r(d,$t),r(d,$),h(fe,$,null),r($,kt),r($,xe),r(d,At),r(d,k),h(ue,k,null),r(k,Ct),r(k,We),r(d,Dt),r(d,A),h(he,A,null),r(A,Gt),r(A,$e),r(d,Vt),r(d,_),h(ge,_,null),r(_,Bt),r(_,ke),r(_,Rt),r(_,Ae),r(_,Xt),r(_,Ce),r(d,St),r(d,C),h(Me,C,null),r(C,Et),r(C,De),r(d,Ft),r(d,D),h(be,D,null),r(D,Yt),r(D,Ge),r(d,Nt),r(d,G),h(ye,G,null),r(G,Pt),r(G,Ve),i(e,ut,t),i(e,_e,t),i(e,ht,t),h(we,e,t),i(e,gt,t),i(e,Te,t),h(Je,Te,null),i(e,Mt,t),i(e,Be,t),bt=!0},p(e,[t]){const m={};t&2&&(m.$$scope={dirty:t,ctx:e}),x.$set(m);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),W.$set(j)},i(e){bt||(g(B.$$.fragment,e),g(R.$$.fragment,e),g(F.$$.fragment,e),g(N.$$.fragment,e),g(z.$$.fragment,e),g(L.$$.fragment,e),g(x.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ie.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(W.$$.fragment,e),g(de.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(fe.$$.fragment,e),g(ue.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Je.$$.fragment,e),bt=!0)},o(e){M(B.$$.fragment,e),M(R.$$.fragment,e),M(F.$$.fragment,e),M(N.$$.fragment,e),M(z.$$.fragment,e),M(L.$$.fragment,e),M(x.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ie.$$.fragment,e),M(le.$$.fragment,e),M(re.$$.fragment,e),M(W.$$.fragment,e),M(de.$$.fragment,e),M(ce.$$.fragment,e),M(me.$$.fragment,e),M(fe.$$.fragment,e),M(ue.$$.fragment,e),M(he.$$.fragment,e),M(ge.$$.fragment,e),M(Me.$$.fragment,e),M(be.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),bt=!1},d(e){e&&(n(J),n(y),n(I),n(Re),n(Xe),n(X),n(Se),n(S),n(Ee),n(E),n(Fe),n(Ye),n(Y),n(Ne),n(Pe),n(P),n(ze),n(Qe),n(Q),n(He),n(H),n(Le),n(qe),n(q),n(Oe),n(O),n(Ke),n(et),n(tt),n(ee),n(nt),n(it),n(ne),n(st),n(at),n(se),n(lt),n(ae),n(ot),n(rt),n(oe),n(pt),n(dt),n(pe),n(ct),n(mt),n(ft),n(d),n(ut),n(_e),n(ht),n(gt),n(Te),n(Mt),n(Be)),n(c),b(B,e),b(R,e),b(F,e),b(N,e),b(z,e),b(L,e),b(x,e),b(K,e),b(te,e),b(ie,e),b(le,e),b(re,e),b(W,e),b(de,e),b(ce),b(me),b(fe),b(ue),b(he),b(ge),b(Me),b(be),b(ye),b(we,e),b(Je)}}}const Dn='{"title":"Text-to-Video Generation with AnimateDiff","local":"text-to-video-generation-with-animatediff","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Available Pipelines","local":"available-pipelines","sections":[],"depth":2},{"title":"Available checkpoints","local":"available-checkpoints","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Using Motion LoRAs","local":"using-motion-loras","sections":[],"depth":2},{"title":"Using Motion LoRAs with PEFT","local":"using-motion-loras-with-peft","sections":[],"depth":2},{"title":"AnimateDiffPipeline","local":"diffusers.AnimateDiffPipeline","sections":[],"depth":2},{"title":"AnimateDiffPipelineOutput","local":"diffusers.pipelines.animatediff.AnimateDiffPipelineOutput","sections":[],"depth":2}],"depth":1}';function Gn(ve){return Zn(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=$n}),[]}class Fn extends In{constructor(c){super(),xn(this,c,Gn,Cn,jn,{})}}export{Fn as component};
