import{s as ct,o as Mt,n as ot}from"../chunks/scheduler.6e0d5ff7.js";import{S as ut,i as ft,g as i,s as n,r as c,E as dt,h as p,f as e,c as a,j as at,u as M,x as o,k as it,y as rt,a as t,v as u,d as f,t as d,w as r}from"../chunks/index.d7c1b260.js";import{H as U,g as yt}from"../chunks/Heading.2be73954.js";import{T as pt}from"../chunks/Tip.c000e27b.js";import{C as J}from"../chunks/CodeBlock.09a08494.js";function Jt(Al){let y,T='💡 <code>DiffusionPipeline</code> 클래스가 동작하는 방식에 보다 자세한 내용이 궁금하다면,  <a href="#diffusionpipeline%EC%97%90-%EB%8C%80%ED%95%B4-%EC%95%8C%EC%95%84%EB%B3%B4%EA%B8%B0">DiffusionPipeline explained</a> 섹션을 확인해보세요.';return{c(){y=i("p"),y.innerHTML=T},l(m){y=p(m,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1ad0zc6"&&(y.innerHTML=T)},m(m,j){t(m,y,j)},p:ot,d(m){m&&e(y)}}}function mt(Al){let y,T="💡 모델 구조는 동일하지만 서로 다른 학습 환경에서 서로 다른 데이터셋으로 학습된 체크포인트들이 있을 경우, 해당 체크포인트들은 variant 단계가 아닌 리포지토리 단계에서 분리되어 관리되어야 합니다. (즉, 해당 체크포인트들은 서로 다른 리포지토리에서 따로 관리되어야 합니다. 예시: <code>stable-diffusion-v1-4</code>, <code>stable-diffusion-v1-5</code>).";return{c(){y=i("p"),y.innerHTML=T},l(m){y=p(m,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1nvgb72"&&(y.innerHTML=T)},m(m,j){t(m,y,j)},p:ot,d(m){m&&e(y)}}}function Tt(Al){let y,T,m,j,h,Dl,w,Je="기본적으로 diffusion 모델은 다양한 컴포넌트들(모델, 토크나이저, 스케줄러) 간의 복잡한 상호작용을 기반으로 동작합니다. 디퓨저스(Diffusers)는 이러한 diffusion 모델을 보다 쉽고 간편한 API로 제공하는 것을 목표로 설계되었습니다. <code>DiffusionPipeline</code>은 diffusion 모델이 갖는 복잡성을 하나의 파이프라인 API로 통합하고, 동시에 이를 구성하는 각각의 컴포넌트들을 태스크에 맞춰 유연하게 커스터마이징할 수 있도록 지원하고 있습니다.",zl,C,me="diffusion 모델의 훈련과 추론에 필요한 모든 것은 <code>DiffusionPipeline.from_pretrained()</code> 메서드를 통해 접근할 수 있습니다. (이 말의 의미는 다음 단락에서 보다 자세하게 다뤄보도록 하겠습니다.)",Yl,I,Te="이 문서에서는 설명할 내용은 다음과 같습니다.",Ll,W,Ue="<li><p>허브를 통해 혹은 로컬로 파이프라인을 불러오는 법</p></li> <li><p>파이프라인에 다른 컴포넌트들을 적용하는 법</p></li> <li><p>오리지널 체크포인트가 아닌 variant를 불러오는 법  (variant란 기본으로 설정된 <code>fp32</code>가 아닌 다른  부동 소수점 타입(예: <code>fp16</code>)을 사용하거나 Non-EMA 가중치를 사용하는 체크포인트들을 의미합니다.)</p></li> <li><p>모델과 스케줄러를 불러오는 법</p></li>",Fl,V,Pl,Z,Ol,k,je='<code>DiffusionPipeline</code> 클래스는 diffusion 모델을 <a href="https://huggingface.co/models?library=diffusers" rel="nofollow">허브</a>로부터 불러오는 가장 심플하면서 보편적인 방식입니다. <code>DiffusionPipeline.from_pretrained()</code> 메서드는 적합한 파이프라인 클래스를 자동으로 탐지하고, 필요한 구성요소(configuration)와 가중치(weight) 파일들을 다운로드하고 캐싱한 다음, 해당 파이프라인 인스턴스를 반환합니다.',Kl,v,ls,$,Ze="물론 <code>DiffusionPipeline</code> 클래스를 사용하지 않고, 명시적으로 직접 해당 파이프라인 클래스를 불러오는 것도 가능합니다. 아래 예시 코드는 위 예시와 동일한 인스턴스를 반환합니다.",ss,R,es,B,be='<a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow">CompVis/stable-diffusion-v1-4</a>이나 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> 같은 체크포인트들의 경우, 하나 이상의 다양한 태스크에 활용될 수 있습니다. (예를 들어 위의 두 체크포인트의 경우, text-to-image와 image-to-image에 모두 활용될 수 있습니다.)  만약 이러한 체크포인트들을 기본 설정 태스크가 아닌 다른 태스크에 활용하고자 한다면, 해당 태스크에 대응되는 파이프라인(task-specific pipeline)을 사용해야 합니다.',ts,G,ns,g,as,N,he="파이프라인을 로컬로 불러오고자 한다면, <code>git-lfs</code>를 사용하여 직접 체크포인트를 로컬 디스크에 다운로드 받아야 합니다. 아래의 명령어를 실행하면 <code>./stable-diffusion-v1-5</code>란 이름으로 폴더가 로컬디스크에 생성됩니다.",is,_,ps,E,we="그런 다음 해당 로컬 경로를 <code>from_pretrained()</code> 메서드에 전달합니다.",os,Q,cs,q,Ce="위의 예시코드처럼 만약 <code>repo_id</code>가 로컬 패스(local path)라면, <code>from_pretrained()</code> 메서드는 이를 자동으로 감지하여 허브에서 파일을 다운로드하지 않습니다. 만약 로컬 디스크에 저장된 파이프라인 체크포인트가 최신 버전이 아닐 경우에도, 최신 버전을 다운로드하지 않고 기존 로컬 디스크에 저장된 체크포인트를 사용한다는 것을 의미합니다.",Ms,X,us,S,Ie="파이프라인 내부의 컴포넌트들은 호환 가능한 다른 컴포넌트로 교체될 수 있습니다. 이와 같은 컴포넌트 교체가 중요한 이유는 다음과 같습니다.",fs,H,We="<li>어떤 스케줄러를 사용할 것인가는 생성속도와 생성품질 간의 트레이드오프를 정의하는 중요한 요소입니다.</li> <li>diffusion 모델 내부의 컴포넌트들은 일반적으로 각각 독립적으로 훈련되기 때문에, 더 좋은 성능을 보여주는 컴포넌트가 있다면 그걸로 교체하는 식으로 성능을 향상시킬 수 있습니다.</li> <li>파인 튜닝 단계에서는 일반적으로 UNet 혹은 텍스트 인코더와 같은 일부 컴포넌트들만 훈련하게 됩니다.</li>",ds,A,Ve="어떤 스케줄러들이 호환가능한지는 <code>compatibles</code> 속성을 통해 확인할 수 있습니다.",rs,x,ys,D,ke='이번에는 <code>SchedulerMixin.from_pretrained()</code> 메서드를 사용해서, 기존 기본 스케줄러였던 <code>PNDMScheduler</code>를 보다 우수한 성능의 <code>EulerDiscreteScheduler</code>로 바꿔봅시다. 스케줄러를 로드할 때는 <code>subfolder</code> 인자를 통해, 해당 파이프라인의 리포지토리에서 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">스케줄러에 관한 하위폴더</a>를  명시해주어야 합니다.',Js,z,ve="그 다음 새롭게 생성한 <code>EulerDiscreteScheduler</code> 인스턴스를 <code>DiffusionPipeline</code>의 <code>scheduler</code> 인자에 전달합니다.",ms,Y,Ts,L,Us,F,$e='스테이블 diffusion과 같은 diffusion 모델들은 유해한 이미지를 생성할 수도 있습니다. 이를 예방하기 위해 디퓨저스는 생성된 이미지의 유해성을 판단하는 <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">세이프티 체커(safety checker)</a> 기능을 지원하고 있습니다. 만약 세이프티 체커의 사용을 원하지 않는다면, <code>safety_checker</code> 인자에 <code>None</code>을 전달해주시면 됩니다.',js,P,Zs,O,bs,K,Re="복수의 파이프라인에 동일한 모델이 반복적으로 사용한다면, 굳이 해당 모델의 동일한 가중치를 중복으로 RAM에 불러올 필요는 없을 것입니다.  <code>components</code> 속성을 통해 파이프라인 내부의 컴포넌트들을 참조할 수 있는데, 이번 단락에서는 이를 통해 동일한 모델 가중치를 RAM에 중복으로 불러오는 것을 방지하는 법에 대해 알아보겠습니다.",hs,ll,ws,sl,Be="그 다음 위 예시 코드에서 선언한 <code>components</code> 변수를 다른 파이프라인에 전달함으로써, 모델의 가중치를 중복으로 RAM에 로딩하지 않고, 동일한 컴포넌트를 재사용할 수 있습니다.",Cs,el,Is,tl,Ge="물론 각각의 컴포넌트들을 따로 따로 파이프라인에 전달할 수도 있습니다.  예를 들어 <code>stable_diffusion_txt2img</code> 파이프라인 안의 컴포넌트들 가운데서 세이프티 체커(<code>safety_checker</code>)와 피쳐 익스트랙터(<code>feature_extractor</code>)를 제외한 컴포넌트들만 <code>stable_diffusion_img2img</code> 파이프라인에서 재사용하는 방식 역시 가능합니다.",Ws,nl,Vs,al,ks,il,ge="Variant란 일반적으로 다음과 같은 체크포인트들을 의미합니다.",vs,pl,Ne="<li><code>torch.float16</code>과 같이 정밀도는 더 낮지만, 용량 역시 더 작은 부동소수점 타입의 가중치를 사용하는 체크포인트. <em>(다만 이와 같은 variant의 경우, 추가적인 훈련과 CPU환경에서의 구동이 불가능합니다.)</em></li> <li>Non-EMA 가중치를 사용하는 체크포인트. <em>(Non-EMA 가중치의 경우, 파인 튜닝 단계에서 사용하는 것이 권장되는데, 추론 단계에선 사용하지 않는 것이 권장됩니다.)</em></li>",$s,b,Rs,ol,_e="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",Bs,cl,Ee="variant를 로드할 때 2개의 중요한 argument가 있습니다.",Gs,Ml,Qe='<li><code>torch_dtype</code>은 불러올 체크포인트의 부동소수점을 정의합니다. 예를 들어 <code>torch_dtype=torch.float16</code>을 명시함으로써 가중치의 부동소수점 타입을 <code>fl16</code>으로 변환할 수 있습니다. (만약 따로 설정하지 않을 경우, 기본값으로 <code>fp32</code> 타입의 가중치가 로딩됩니다.) 또한 <code>variant</code> 인자를 명시하지 않은 채로 체크포인트를 불러온 다음, 해당 체크포인트를 <code>torch_dtype=torch.float16</code> 인자를 통해 <code>fp16</code> 타입으로 변환하는 것 역시 가능합니다. 이 경우 기본으로 설정된 <code>fp32</code> 가중치가 먼저 다운로드되고, 해당 가중치들을 불러온 다음 <code>fp16</code> 타입으로 변환하게 됩니다.</li> <li><code>variant</code> 인자는 리포지토리에서 어떤 variant를 불러올 것인가를 정의합니다. 가령  <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> 리포지토리로부터 <code>non_ema</code> 체크포인트를 불러오고자 한다면, <code>variant=&quot;non_ema&quot;</code> 인자를 전달해야 합니다.</li>',gs,ul,Ns,fl,qe="다른 부동소수점 타입의 가중치 혹은 non-EMA 가중치를 사용하는 체크포인트를 저장하기 위해서는, <code>DiffusionPipeline.save_pretrained()</code> 메서드를 사용해야 하며, 이 때 <code>variant</code> 인자를 명시해줘야 합니다. 원래의 체크포인트와 동일한 폴더에 variant를 저장해야 하며, 이렇게 하면 동일한 폴더에서 오리지널 체크포인트과 variant를 모두 불러올 수 있습니다.",_s,dl,Es,rl,Xe="만약 variant를 기존 폴더에 저장하지 않을 경우, <code>variant</code> 인자를 반드시 명시해야 합니다. 그렇게 하지 않을 경우 원래의 오리지널 체크포인트를 찾을 수 없게 되기 때문에 에러가 발생합니다.",Qs,yl,qs,Jl,Xs,ml,Se="모델들은 <code>ModelMixin.from_pretrained()</code> 메서드를 통해 불러올 수 있습니다. 해당 메서드는 최신 버전의 모델 가중치 파일과 설정 파일(configurations)을 다운로드하고 캐싱합니다. 만약 이러한 파일들이 최신 버전으로 로컬 캐시에 저장되어 있다면, <code>ModelMixin.from_pretrained()</code>는 굳이 해당 파일들을 다시 다운로드하지 않으며, 그저 캐시에 있는 최신 파일들을 재사용합니다.",Ss,Tl,He='모델은 <code>subfolder</code> 인자에 명시된 하위 폴더로부터 로드됩니다. 예를 들어 <code>runwayml/stable-diffusion-v1-5</code>의 UNet 모델의 가중치는 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> 폴더에 저장되어 있습니다.',Hs,Ul,As,jl,Ae='혹은 <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">해당 모델의 리포지토리</a>로부터 다이렉트로 가져오는 것 역시 가능합니다.',xs,Zl,Ds,bl,xe="또한 앞서 봤던 <code>variant</code> 인자를 명시함으로써, Non-EMA나 <code>fp16</code>의 가중치를 가져오는 것 역시 가능합니다.",zs,hl,Ys,wl,Ls,Cl,De="스케줄러들은 <code>SchedulerMixin.from_pretrained()</code> 메서드를 통해 불러올 수 있습니다. 모델과 달리 스케줄러는 별도의 가중치를 갖지 않으며, 따라서 당연히 별도의 학습과정을 요구하지 않습니다. 이러한 스케줄러들은 (해당 스케줄러 하위폴더의) configration 파일을 통해 정의됩니다.",Fs,Il,ze="여러개의 스케줄러를 불러온다고 해서 많은 메모리를 소모하는 것은 아니며, 다양한 스케줄러들에 동일한 스케줄러 configration을  적용하는 것 역시 가능합니다. 다음 예시 코드에서 불러오는 스케줄러들은 모두 <code>StableDiffusionPipeline</code>과 호환되는데, 이는 곧 해당 스케줄러들에 동일한 스케줄러 configration 파일을 적용할 수 있음을 의미합니다.",Ps,Wl,Os,Vl,Ks,kl,Ye="클래스 메서드로서  <code>DiffusionPipeline.from_pretrained()</code>은 2가지를 담당합니다.",le,vl,Le="<li>첫째로, <code>from_pretrained</code> 메서드는 최신 버전의 파이프라인을 다운로드하고, 캐시에 저장합니다. 이미 로컬 캐시에 최신 버전의 파이프라인이 저장되어 있다면, <code>DiffusionPipeline.from_pretrained()</code>은 해당 파일들을 다시 다운로드하지 않고, 로컬 캐시에 저장되어 있는 파이프라인을 불러옵니다.</li> <li><code>model_index.json</code> 파일을 통해 체크포인트에 대응되는 적합한 파이프라인 클래스로 불러옵니다.</li>",se,$l,Fe='파이프라인의 폴더 구조는 해당 파이프라인 클래스의 구조와 직접적으로 일치합니다. 예를 들어 <code>StableDiffusionPipeline</code> 클래스는 <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> 리포지토리와 대응되는 구조를 갖습니다.',ee,Rl,te,Bl,Pe="위의 코드 출력 결과를 확인해보면, <code>pipeline</code>은 <code>StableDiffusionPipeline</code>의 인스턴스이며, 다음과 같이 총 7개의 컴포넌트로 구성된다는 것을 알 수 있습니다.",ne,Gl,Oe='<li><code>&quot;feature_extractor&quot;</code>: <code>CLIPFeatureExtractor</code>의 인스턴스</li> <li><code>&quot;safety_checker&quot;</code>: 유해한 컨텐츠를 스크리닝하기 위한 <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">컴포넌트</a></li> <li><code>&quot;scheduler&quot;</code>: <code>PNDMScheduler</code>의 인스턴스</li> <li><code>&quot;text_encoder&quot;</code>: <code>CLIPTextModel</code>의 인스턴스</li> <li><code>&quot;tokenizer&quot;</code>: a <code>CLIPTokenizer</code>의 인스턴스</li> <li><code>&quot;unet&quot;</code>: <code>UNet2DConditionModel</code>의 인스턴스</li> <li><code>&quot;vae&quot;</code> <code>AutoencoderKL</code>의 인스턴스</li>',ae,gl,ie,Nl,Ke='파이프라인 인스턴스의 컴포넌트들을  <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>의 폴더 구조와 비교해볼 경우, 각각의 컴포넌트마다 별도의 폴더가 있음을 확인할 수 있습니다.',pe,_l,oe,El,lt="또한 각각의 컴포넌트들을 파이프라인 인스턴스의 속성으로써 참조할 수 있습니다.",ce,Ql,Me,ql,ue,Xl,st="모든 파이프라인은 <code>model_index.json</code> 파일을 통해 <code>DiffusionPipeline</code>에 다음과 같은 정보를 전달합니다.",fe,Sl,et="<li><code>_class_name</code> 는 어떤 파이프라인 클래스를 사용해야 하는지에 대해 알려줍니다.</li> <li><code>_diffusers_version</code>는 어떤 버전의 디퓨저스로 파이프라인 안의 모델들이 만들어졌는지를 알려줍니다.</li> <li>그 다음은 각각의 컴포넌트들이 어떤 라이브러리의 어떤 클래스로 만들어졌는지에 대해 알려줍니다. (아래 예시에서 <code>&quot;feature_extractor&quot; : [&quot;transformers&quot;, &quot;CLIPImageProcessor&quot;]</code>의 경우, <code>feature_extractor</code> 컴포넌트는 <code>transformers</code> 라이브러리의 <code>CLIPImageProcessor</code> 클래스를 통해 만들어졌다는 것을 의미합니다.)</li>",de,Hl,re,xl,ye;return h=new U({props:{title:"파이프라인, 모델, 스케줄러 불러오기",local:"파이프라인-모델-스케줄러-불러오기",headingTag:"h1"}}),V=new U({props:{title:"Diffusion 파이프라인",local:"diffusion-파이프라인",headingTag:"h2"}}),Z=new pt({props:{$$slots:{default:[Jt]},$$scope:{ctx:Al}}}),v=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),R=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),G=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),g=new U({props:{title:"로컬 파이프라인",local:"로컬-파이프라인",headingTag:"h3"}}),_=new J({props:{code:"Z2l0JTIwbGZzJTIwaW5zdGFsbCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01",highlighted:`git lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),Q=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id)`,wrap:!1}}),X=new U({props:{title:"파이프라인 내부의 컴포넌트 교체하기",local:"파이프라인-내부의-컴포넌트-교체하기",headingTag:"h3"}}),x=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkKSUwQXN0YWJsZV9kaWZmdXNpb24uc2NoZWR1bGVyLmNvbXBhdGlibGVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler, DPMSolverMultistepScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler)`,wrap:!1}}),L=new U({props:{title:"세이프티 체커",local:"세이프티-체커",headingTag:"h3"}}),P=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>)`,wrap:!1}}),O=new U({props:{title:"컴포넌트 재사용",local:"컴포넌트-재사용",headingTag:"h3"}}),ll=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFjb21wb25lbnRzJTIwJTNEJTIwc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLmNvbXBvbmVudHM=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id)

components = stable_diffusion_txt2img.components`,wrap:!1}}),el=new J({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),nl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFzdGFibGVfZGlmZnVzaW9uX2ltZzJpbWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdmFlJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnZhZSUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy50ZXh0X2VuY29kZXIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdW5ldCUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy51bmV0JTJDJTBBJTIwJTIwJTIwJTIwc2NoZWR1bGVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMHNhZmV0eV9jaGVja2VyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHJlcXVpcmVzX3NhZmV0eV9jaGVja2VyJTNERmFsc2UlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),al=new U({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),b=new pt({props:{$$slots:{default:[mt]},$$scope:{ctx:Al}}}),ul=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwbG9hZCUyMGZwMTYlMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),dl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),yl=new J({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMjMlMjAlRjAlOUYlOTElOEQlMjB0aGlzJTIwd29ya3MlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSk=",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
)`,wrap:!1}}),Jl=new U({props:{title:"모델 불러오기",local:"모델-불러오기",headingTag:"h3"}}),Ul=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),Zl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id)`,wrap:!1}}),hl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbi1lbWElMjIpJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZsb2NhbC11bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbi1lbWElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non-ema&quot;</span>)`,wrap:!1}}),wl=new U({props:{title:"스케줄러",local:"스케줄러",headingTag:"h3"}}),Wl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm)`,wrap:!1}}),Vl=new U({props:{title:"DiffusionPipeline에 대해 알아보기",local:"diffusionpipeline에-대해-알아보기",headingTag:"h3"}}),Rl=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCklMEFwcmludChwaXBlbGluZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),gl=new J({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_l=new J({props:{code:"LiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGZlYXR1cmVfZXh0cmFjdG9yJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHJlcHJvY2Vzc29yX2NvbmZpZy5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwbW9kZWxfaW5kZXguanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNhZmV0eV9jaGVja2VyJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBweXRvcmNoX21vZGVsLmJpbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlciUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHNjaGVkdWxlcl9jb25maWcuanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRleHRfZW5jb2RlciUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwcHl0b3JjaF9tb2RlbC5iaW4lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXIlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBtZXJnZXMudHh0JTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc3BlY2lhbF90b2tlbnNfbWFwLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0b2tlbml6ZXJfY29uZmlnLmpzb24lMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB2b2NhYi5qc29uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwdW5ldCUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGNvbmZpZy5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGlmZnVzaW9uX3B5dG9yY2hfbW9kZWwuYmluJTBBJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwdmFlJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnLmpzb24lMEElMjAlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBkaWZmdXNpb25fcHl0b3JjaF9tb2RlbC5iaW4=",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.<span class="hljs-keyword">json
</span>├── model_index.<span class="hljs-keyword">json
</span>├── safety_checker
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── <span class="hljs-keyword">scheduler
</span>│   └── <span class="hljs-keyword">scheduler_config.json
</span>├── text_encoder
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   └── pytorch_model.<span class="hljs-keyword">bin
</span>├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.<span class="hljs-keyword">json
</span>│   ├── tokenizer_config.<span class="hljs-keyword">json
</span>│   └── vocab.<span class="hljs-keyword">json
</span>├── unet
│   ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>│   ├── <span class="hljs-keyword">diffusion_pytorch_model.bin
</span>└── vae
    ├── <span class="hljs-built_in">config</span>.<span class="hljs-keyword">json
</span>    ├── <span class="hljs-keyword">diffusion_pytorch_model.bin</span>`,wrap:!1}}),Ql=new J({props:{code:"cGlwZWxpbmUudG9rZW5pemVy",highlighted:"pipeline.tokenizer",wrap:!1}}),ql=new J({props:{code:"Q0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
)`,wrap:!1}}),Hl=new J({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){y=i("meta"),T=n(),m=i("p"),j=n(),c(h.$$.fragment),Dl=n(),w=i("p"),w.innerHTML=Je,zl=n(),C=i("p"),C.innerHTML=me,Yl=n(),I=i("p"),I.textContent=Te,Ll=n(),W=i("ul"),W.innerHTML=Ue,Fl=n(),c(V.$$.fragment),Pl=n(),c(Z.$$.fragment),Ol=n(),k=i("p"),k.innerHTML=je,Kl=n(),c(v.$$.fragment),ls=n(),$=i("p"),$.innerHTML=Ze,ss=n(),c(R.$$.fragment),es=n(),B=i("p"),B.innerHTML=be,ts=n(),c(G.$$.fragment),ns=n(),c(g.$$.fragment),as=n(),N=i("p"),N.innerHTML=he,is=n(),c(_.$$.fragment),ps=n(),E=i("p"),E.innerHTML=we,os=n(),c(Q.$$.fragment),cs=n(),q=i("p"),q.innerHTML=Ce,Ms=n(),c(X.$$.fragment),us=n(),S=i("p"),S.textContent=Ie,fs=n(),H=i("ul"),H.innerHTML=We,ds=n(),A=i("p"),A.innerHTML=Ve,rs=n(),c(x.$$.fragment),ys=n(),D=i("p"),D.innerHTML=ke,Js=n(),z=i("p"),z.innerHTML=ve,ms=n(),c(Y.$$.fragment),Ts=n(),c(L.$$.fragment),Us=n(),F=i("p"),F.innerHTML=$e,js=n(),c(P.$$.fragment),Zs=n(),c(O.$$.fragment),bs=n(),K=i("p"),K.innerHTML=Re,hs=n(),c(ll.$$.fragment),ws=n(),sl=i("p"),sl.innerHTML=Be,Cs=n(),c(el.$$.fragment),Is=n(),tl=i("p"),tl.innerHTML=Ge,Ws=n(),c(nl.$$.fragment),Vs=n(),c(al.$$.fragment),ks=n(),il=i("p"),il.textContent=ge,vs=n(),pl=i("ul"),pl.innerHTML=Ne,$s=n(),c(b.$$.fragment),Rs=n(),ol=i("table"),ol.innerHTML=_e,Bs=n(),cl=i("p"),cl.textContent=Ee,Gs=n(),Ml=i("ul"),Ml.innerHTML=Qe,gs=n(),c(ul.$$.fragment),Ns=n(),fl=i("p"),fl.innerHTML=qe,_s=n(),c(dl.$$.fragment),Es=n(),rl=i("p"),rl.innerHTML=Xe,Qs=n(),c(yl.$$.fragment),qs=n(),c(Jl.$$.fragment),Xs=n(),ml=i("p"),ml.innerHTML=Se,Ss=n(),Tl=i("p"),Tl.innerHTML=He,Hs=n(),c(Ul.$$.fragment),As=n(),jl=i("p"),jl.innerHTML=Ae,xs=n(),c(Zl.$$.fragment),Ds=n(),bl=i("p"),bl.innerHTML=xe,zs=n(),c(hl.$$.fragment),Ys=n(),c(wl.$$.fragment),Ls=n(),Cl=i("p"),Cl.innerHTML=De,Fs=n(),Il=i("p"),Il.innerHTML=ze,Ps=n(),c(Wl.$$.fragment),Os=n(),c(Vl.$$.fragment),Ks=n(),kl=i("p"),kl.innerHTML=Ye,le=n(),vl=i("ul"),vl.innerHTML=Le,se=n(),$l=i("p"),$l.innerHTML=Fe,ee=n(),c(Rl.$$.fragment),te=n(),Bl=i("p"),Bl.innerHTML=Pe,ne=n(),Gl=i("ul"),Gl.innerHTML=Oe,ae=n(),c(gl.$$.fragment),ie=n(),Nl=i("p"),Nl.innerHTML=Ke,pe=n(),c(_l.$$.fragment),oe=n(),El=i("p"),El.textContent=lt,ce=n(),c(Ql.$$.fragment),Me=n(),c(ql.$$.fragment),ue=n(),Xl=i("p"),Xl.innerHTML=st,fe=n(),Sl=i("ul"),Sl.innerHTML=et,de=n(),c(Hl.$$.fragment),re=n(),xl=i("p"),this.h()},l(l){const s=dt("svelte-u9bgzb",document.head);y=p(s,"META",{name:!0,content:!0}),s.forEach(e),T=a(l),m=p(l,"P",{}),at(m).forEach(e),j=a(l),M(h.$$.fragment,l),Dl=a(l),w=p(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1iglxvj"&&(w.innerHTML=Je),zl=a(l),C=p(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-sykc41"&&(C.innerHTML=me),Yl=a(l),I=p(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1qc8l60"&&(I.textContent=Te),Ll=a(l),W=p(l,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-1wwzf1i"&&(W.innerHTML=Ue),Fl=a(l),M(V.$$.fragment,l),Pl=a(l),M(Z.$$.fragment,l),Ol=a(l),k=p(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1mpandj"&&(k.innerHTML=je),Kl=a(l),M(v.$$.fragment,l),ls=a(l),$=p(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1czbgfz"&&($.innerHTML=Ze),ss=a(l),M(R.$$.fragment,l),es=a(l),B=p(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1dxl2rq"&&(B.innerHTML=be),ts=a(l),M(G.$$.fragment,l),ns=a(l),M(g.$$.fragment,l),as=a(l),N=p(l,"P",{"data-svelte-h":!0}),o(N)!=="svelte-as0lxn"&&(N.innerHTML=he),is=a(l),M(_.$$.fragment,l),ps=a(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1h76dl8"&&(E.innerHTML=we),os=a(l),M(Q.$$.fragment,l),cs=a(l),q=p(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-tfqrd7"&&(q.innerHTML=Ce),Ms=a(l),M(X.$$.fragment,l),us=a(l),S=p(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-15u7ee8"&&(S.textContent=Ie),fs=a(l),H=p(l,"UL",{"data-svelte-h":!0}),o(H)!=="svelte-82p6pl"&&(H.innerHTML=We),ds=a(l),A=p(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1pepgag"&&(A.innerHTML=Ve),rs=a(l),M(x.$$.fragment,l),ys=a(l),D=p(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1ij1ihe"&&(D.innerHTML=ke),Js=a(l),z=p(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1lidbe0"&&(z.innerHTML=ve),ms=a(l),M(Y.$$.fragment,l),Ts=a(l),M(L.$$.fragment,l),Us=a(l),F=p(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1n7a5c5"&&(F.innerHTML=$e),js=a(l),M(P.$$.fragment,l),Zs=a(l),M(O.$$.fragment,l),bs=a(l),K=p(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1dfvcjh"&&(K.innerHTML=Re),hs=a(l),M(ll.$$.fragment,l),ws=a(l),sl=p(l,"P",{"data-svelte-h":!0}),o(sl)!=="svelte-1scbzg6"&&(sl.innerHTML=Be),Cs=a(l),M(el.$$.fragment,l),Is=a(l),tl=p(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-1a93gqn"&&(tl.innerHTML=Ge),Ws=a(l),M(nl.$$.fragment,l),Vs=a(l),M(al.$$.fragment,l),ks=a(l),il=p(l,"P",{"data-svelte-h":!0}),o(il)!=="svelte-1k13zzw"&&(il.textContent=ge),vs=a(l),pl=p(l,"UL",{"data-svelte-h":!0}),o(pl)!=="svelte-1shttzu"&&(pl.innerHTML=Ne),$s=a(l),M(b.$$.fragment,l),Rs=a(l),ol=p(l,"TABLE",{"data-svelte-h":!0}),o(ol)!=="svelte-1e3wdtx"&&(ol.innerHTML=_e),Bs=a(l),cl=p(l,"P",{"data-svelte-h":!0}),o(cl)!=="svelte-ca126c"&&(cl.textContent=Ee),Gs=a(l),Ml=p(l,"UL",{"data-svelte-h":!0}),o(Ml)!=="svelte-1w04sbb"&&(Ml.innerHTML=Qe),gs=a(l),M(ul.$$.fragment,l),Ns=a(l),fl=p(l,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-tbk23x"&&(fl.innerHTML=qe),_s=a(l),M(dl.$$.fragment,l),Es=a(l),rl=p(l,"P",{"data-svelte-h":!0}),o(rl)!=="svelte-16u45h8"&&(rl.innerHTML=Xe),Qs=a(l),M(yl.$$.fragment,l),qs=a(l),M(Jl.$$.fragment,l),Xs=a(l),ml=p(l,"P",{"data-svelte-h":!0}),o(ml)!=="svelte-113i68p"&&(ml.innerHTML=Se),Ss=a(l),Tl=p(l,"P",{"data-svelte-h":!0}),o(Tl)!=="svelte-63zvmt"&&(Tl.innerHTML=He),Hs=a(l),M(Ul.$$.fragment,l),As=a(l),jl=p(l,"P",{"data-svelte-h":!0}),o(jl)!=="svelte-h9u277"&&(jl.innerHTML=Ae),xs=a(l),M(Zl.$$.fragment,l),Ds=a(l),bl=p(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1ruaz7v"&&(bl.innerHTML=xe),zs=a(l),M(hl.$$.fragment,l),Ys=a(l),M(wl.$$.fragment,l),Ls=a(l),Cl=p(l,"P",{"data-svelte-h":!0}),o(Cl)!=="svelte-1y2locf"&&(Cl.innerHTML=De),Fs=a(l),Il=p(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-1m0or8s"&&(Il.innerHTML=ze),Ps=a(l),M(Wl.$$.fragment,l),Os=a(l),M(Vl.$$.fragment,l),Ks=a(l),kl=p(l,"P",{"data-svelte-h":!0}),o(kl)!=="svelte-1afe7fa"&&(kl.innerHTML=Ye),le=a(l),vl=p(l,"UL",{"data-svelte-h":!0}),o(vl)!=="svelte-1nokmbb"&&(vl.innerHTML=Le),se=a(l),$l=p(l,"P",{"data-svelte-h":!0}),o($l)!=="svelte-7j289c"&&($l.innerHTML=Fe),ee=a(l),M(Rl.$$.fragment,l),te=a(l),Bl=p(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-12sqgdm"&&(Bl.innerHTML=Pe),ne=a(l),Gl=p(l,"UL",{"data-svelte-h":!0}),o(Gl)!=="svelte-1yan39k"&&(Gl.innerHTML=Oe),ae=a(l),M(gl.$$.fragment,l),ie=a(l),Nl=p(l,"P",{"data-svelte-h":!0}),o(Nl)!=="svelte-gs8jhn"&&(Nl.innerHTML=Ke),pe=a(l),M(_l.$$.fragment,l),oe=a(l),El=p(l,"P",{"data-svelte-h":!0}),o(El)!=="svelte-1igvsg7"&&(El.textContent=lt),ce=a(l),M(Ql.$$.fragment,l),Me=a(l),M(ql.$$.fragment,l),ue=a(l),Xl=p(l,"P",{"data-svelte-h":!0}),o(Xl)!=="svelte-md3cg7"&&(Xl.innerHTML=st),fe=a(l),Sl=p(l,"UL",{"data-svelte-h":!0}),o(Sl)!=="svelte-1ezuhwq"&&(Sl.innerHTML=et),de=a(l),M(Hl.$$.fragment,l),re=a(l),xl=p(l,"P",{}),at(xl).forEach(e),this.h()},h(){it(y,"name","hf:doc:metadata"),it(y,"content",Ut)},m(l,s){rt(document.head,y),t(l,T,s),t(l,m,s),t(l,j,s),u(h,l,s),t(l,Dl,s),t(l,w,s),t(l,zl,s),t(l,C,s),t(l,Yl,s),t(l,I,s),t(l,Ll,s),t(l,W,s),t(l,Fl,s),u(V,l,s),t(l,Pl,s),u(Z,l,s),t(l,Ol,s),t(l,k,s),t(l,Kl,s),u(v,l,s),t(l,ls,s),t(l,$,s),t(l,ss,s),u(R,l,s),t(l,es,s),t(l,B,s),t(l,ts,s),u(G,l,s),t(l,ns,s),u(g,l,s),t(l,as,s),t(l,N,s),t(l,is,s),u(_,l,s),t(l,ps,s),t(l,E,s),t(l,os,s),u(Q,l,s),t(l,cs,s),t(l,q,s),t(l,Ms,s),u(X,l,s),t(l,us,s),t(l,S,s),t(l,fs,s),t(l,H,s),t(l,ds,s),t(l,A,s),t(l,rs,s),u(x,l,s),t(l,ys,s),t(l,D,s),t(l,Js,s),t(l,z,s),t(l,ms,s),u(Y,l,s),t(l,Ts,s),u(L,l,s),t(l,Us,s),t(l,F,s),t(l,js,s),u(P,l,s),t(l,Zs,s),u(O,l,s),t(l,bs,s),t(l,K,s),t(l,hs,s),u(ll,l,s),t(l,ws,s),t(l,sl,s),t(l,Cs,s),u(el,l,s),t(l,Is,s),t(l,tl,s),t(l,Ws,s),u(nl,l,s),t(l,Vs,s),u(al,l,s),t(l,ks,s),t(l,il,s),t(l,vs,s),t(l,pl,s),t(l,$s,s),u(b,l,s),t(l,Rs,s),t(l,ol,s),t(l,Bs,s),t(l,cl,s),t(l,Gs,s),t(l,Ml,s),t(l,gs,s),u(ul,l,s),t(l,Ns,s),t(l,fl,s),t(l,_s,s),u(dl,l,s),t(l,Es,s),t(l,rl,s),t(l,Qs,s),u(yl,l,s),t(l,qs,s),u(Jl,l,s),t(l,Xs,s),t(l,ml,s),t(l,Ss,s),t(l,Tl,s),t(l,Hs,s),u(Ul,l,s),t(l,As,s),t(l,jl,s),t(l,xs,s),u(Zl,l,s),t(l,Ds,s),t(l,bl,s),t(l,zs,s),u(hl,l,s),t(l,Ys,s),u(wl,l,s),t(l,Ls,s),t(l,Cl,s),t(l,Fs,s),t(l,Il,s),t(l,Ps,s),u(Wl,l,s),t(l,Os,s),u(Vl,l,s),t(l,Ks,s),t(l,kl,s),t(l,le,s),t(l,vl,s),t(l,se,s),t(l,$l,s),t(l,ee,s),u(Rl,l,s),t(l,te,s),t(l,Bl,s),t(l,ne,s),t(l,Gl,s),t(l,ae,s),u(gl,l,s),t(l,ie,s),t(l,Nl,s),t(l,pe,s),u(_l,l,s),t(l,oe,s),t(l,El,s),t(l,ce,s),u(Ql,l,s),t(l,Me,s),u(ql,l,s),t(l,ue,s),t(l,Xl,s),t(l,fe,s),t(l,Sl,s),t(l,de,s),u(Hl,l,s),t(l,re,s),t(l,xl,s),ye=!0},p(l,[s]){const tt={};s&2&&(tt.$$scope={dirty:s,ctx:l}),Z.$set(tt);const nt={};s&2&&(nt.$$scope={dirty:s,ctx:l}),b.$set(nt)},i(l){ye||(f(h.$$.fragment,l),f(V.$$.fragment,l),f(Z.$$.fragment,l),f(v.$$.fragment,l),f(R.$$.fragment,l),f(G.$$.fragment,l),f(g.$$.fragment,l),f(_.$$.fragment,l),f(Q.$$.fragment,l),f(X.$$.fragment,l),f(x.$$.fragment,l),f(Y.$$.fragment,l),f(L.$$.fragment,l),f(P.$$.fragment,l),f(O.$$.fragment,l),f(ll.$$.fragment,l),f(el.$$.fragment,l),f(nl.$$.fragment,l),f(al.$$.fragment,l),f(b.$$.fragment,l),f(ul.$$.fragment,l),f(dl.$$.fragment,l),f(yl.$$.fragment,l),f(Jl.$$.fragment,l),f(Ul.$$.fragment,l),f(Zl.$$.fragment,l),f(hl.$$.fragment,l),f(wl.$$.fragment,l),f(Wl.$$.fragment,l),f(Vl.$$.fragment,l),f(Rl.$$.fragment,l),f(gl.$$.fragment,l),f(_l.$$.fragment,l),f(Ql.$$.fragment,l),f(ql.$$.fragment,l),f(Hl.$$.fragment,l),ye=!0)},o(l){d(h.$$.fragment,l),d(V.$$.fragment,l),d(Z.$$.fragment,l),d(v.$$.fragment,l),d(R.$$.fragment,l),d(G.$$.fragment,l),d(g.$$.fragment,l),d(_.$$.fragment,l),d(Q.$$.fragment,l),d(X.$$.fragment,l),d(x.$$.fragment,l),d(Y.$$.fragment,l),d(L.$$.fragment,l),d(P.$$.fragment,l),d(O.$$.fragment,l),d(ll.$$.fragment,l),d(el.$$.fragment,l),d(nl.$$.fragment,l),d(al.$$.fragment,l),d(b.$$.fragment,l),d(ul.$$.fragment,l),d(dl.$$.fragment,l),d(yl.$$.fragment,l),d(Jl.$$.fragment,l),d(Ul.$$.fragment,l),d(Zl.$$.fragment,l),d(hl.$$.fragment,l),d(wl.$$.fragment,l),d(Wl.$$.fragment,l),d(Vl.$$.fragment,l),d(Rl.$$.fragment,l),d(gl.$$.fragment,l),d(_l.$$.fragment,l),d(Ql.$$.fragment,l),d(ql.$$.fragment,l),d(Hl.$$.fragment,l),ye=!1},d(l){l&&(e(T),e(m),e(j),e(Dl),e(w),e(zl),e(C),e(Yl),e(I),e(Ll),e(W),e(Fl),e(Pl),e(Ol),e(k),e(Kl),e(ls),e($),e(ss),e(es),e(B),e(ts),e(ns),e(as),e(N),e(is),e(ps),e(E),e(os),e(cs),e(q),e(Ms),e(us),e(S),e(fs),e(H),e(ds),e(A),e(rs),e(ys),e(D),e(Js),e(z),e(ms),e(Ts),e(Us),e(F),e(js),e(Zs),e(bs),e(K),e(hs),e(ws),e(sl),e(Cs),e(Is),e(tl),e(Ws),e(Vs),e(ks),e(il),e(vs),e(pl),e($s),e(Rs),e(ol),e(Bs),e(cl),e(Gs),e(Ml),e(gs),e(Ns),e(fl),e(_s),e(Es),e(rl),e(Qs),e(qs),e(Xs),e(ml),e(Ss),e(Tl),e(Hs),e(As),e(jl),e(xs),e(Ds),e(bl),e(zs),e(Ys),e(Ls),e(Cl),e(Fs),e(Il),e(Ps),e(Os),e(Ks),e(kl),e(le),e(vl),e(se),e($l),e(ee),e(te),e(Bl),e(ne),e(Gl),e(ae),e(ie),e(Nl),e(pe),e(oe),e(El),e(ce),e(Me),e(ue),e(Xl),e(fe),e(Sl),e(de),e(re),e(xl)),e(y),r(h,l),r(V,l),r(Z,l),r(v,l),r(R,l),r(G,l),r(g,l),r(_,l),r(Q,l),r(X,l),r(x,l),r(Y,l),r(L,l),r(P,l),r(O,l),r(ll,l),r(el,l),r(nl,l),r(al,l),r(b,l),r(ul,l),r(dl,l),r(yl,l),r(Jl,l),r(Ul,l),r(Zl,l),r(hl,l),r(wl,l),r(Wl,l),r(Vl,l),r(Rl,l),r(gl,l),r(_l,l),r(Ql,l),r(ql,l),r(Hl,l)}}}const Ut='{"title":"파이프라인, 모델, 스케줄러 불러오기","local":"파이프라인-모델-스케줄러-불러오기","sections":[{"title":"Diffusion 파이프라인","local":"diffusion-파이프라인","sections":[{"title":"로컬 파이프라인","local":"로컬-파이프라인","sections":[],"depth":3},{"title":"파이프라인 내부의 컴포넌트 교체하기","local":"파이프라인-내부의-컴포넌트-교체하기","sections":[],"depth":3},{"title":"세이프티 체커","local":"세이프티-체커","sections":[],"depth":3},{"title":"컴포넌트 재사용","local":"컴포넌트-재사용","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[{"title":"모델 불러오기","local":"모델-불러오기","sections":[],"depth":3},{"title":"스케줄러","local":"스케줄러","sections":[],"depth":3},{"title":"DiffusionPipeline에 대해 알아보기","local":"diffusionpipeline에-대해-알아보기","sections":[],"depth":3}],"depth":2}],"depth":1}';function jt(Al){return Mt(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=yt}),[]}class It extends ut{constructor(y){super(),ft(this,y,jt,Tt,ct,{})}}export{It as component};
