import{s as Al,n as xl,o as vl}from"../chunks/scheduler.85c25b89.js";import{S as Bl,i as Gl,g as o,s as n,r as p,m as Cl,A as Zl,h as i,f as l,c as a,j as fl,u as m,x as M,n as bl,k as gl,y as Wl,a as s,v as r,d as y,t as w,w as h}from"../chunks/index.c9bcf812.js";import{C as u}from"../chunks/CodeBlock.c004bd26.js";import{H as fe}from"../chunks/getInferenceSnippets.d9278495.js";function kl(Wt){let J,be,Ie,ge,T,Ae,c,kt='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/llama2-13b-chatbot.ipynb" rel="nofollow">here</a></em>.',xe,j,$t="This guide will detail how to export, deploy and run a <strong>LLama-2 13B</strong> chat model on AWS inferentia.",ve,U,Ht="You will learn how to:",Be,d,_t="<li>export the Llama-2 model to the Neuron format,</li> <li>push the exported model to the Hugging Face Hub,</li> <li>deploy the model and use it in a chat application.</li>",Ge,I,Xt="Note: This tutorial was created on a inf2.48xlarge AWS EC2 Instance.",Ze,C,We,f,Vt='For this guide, we will use the non-gated <a href="https://huggingface.co/NousResearch/Llama-2-13b-chat-hf" rel="nofollow">NousResearch/Llama-2-13b-chat-hf</a> model, which is functionally equivalent to the original <a href="https://huggingface.co/meta-llama/Llama-2-13b-chat-hf" rel="nofollow">meta-llama/Llama-2-13b-chat-hf</a>.',ke,b,zt=`This model is part of the <strong>Llama 2</strong> family of models, and has been tuned to recognize chat interactions
between a <em>user</em> and an <em>assistant</em> (more on that later).`,$e,g,St=`As explained in the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model#exporting-llm-models-to-neuron" rel="nofollow">optimum-neuron documentation</a>
, models need to be compiled and exported to a serialized format before running them on Neuron devices.`,He,A,Nt="When exporting the model, we will specify two sets of parameters:",_e,x,Qt=`<li>using <em>compiler_args</em>, we specify on how many cores we want the model to be deployed (each neuron device has two cores), and with which precision (here <em>float16</em>),</li> <li>using <em>input_shapes</em>, we set the static input and output dimensions of the model. All model compilers require static shapes, and neuron makes no exception. Note that the
<em>sequence_length</em> not only constrains the length of the input context, but also the length of the Key/Value cache, and thus, the output length.</li>`,Xe,v,Et="Depending on your choice of parameters and inferentia host, this may take from a few minutes to more than an hour.",Ve,B,Yt="For your convenience, we host a pre-compiled version of that model on the Hugging Face hub, so you can skip the export and start using the model immediately in section 2.",ze,G,Se,Z,Lt="This will probably take a while.",Ne,W,Rt="Fortunately, you will need to do this only once because you can save your model and reload it later.",Qe,k,Ee,$,Ft='Even better, you can push it to the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face hub</a>.',Ye,H,qt='For that, you need to be logged in to a <a href="https://huggingface.co/join" rel="nofollow">HuggingFace account</a>.',Le,_,Pt="In the terminal, just type the following command and paste your Hugging Face token when requested:",Re,X,Fe,V,Kt="By default, the model will be uploaded to your account (organization equal to your user name).",qe,z,Dt='Feel free to edit the code below if you want to upload the model to a specific <a href="https://huggingface.co/docs/hub/organizations" rel="nofollow">Hugging Face organization</a>.',Pe,S,Ke,N,De,Q,Ot="The minimum memory required to load a model can be computed with:",Oe,E,et,Y,el="The <strong>Llama 2 13B</strong> model uses <em>float16</em> weights (stored on 2 bytes) and has 13 billion parameters, which means it requires at least 2 * 13B or ~26GB of memory to store its weights.",tt,L,tl="Each NeuronCore has 16GB of memory which means that a 26GB model cannot fit on a single NeuronCore.",lt,R,ll=`In reality, the total space required is much greater than just the number of parameters due to caching attention layer projections (KV caching).
This caching mechanism grows memory allocations linearly with sequence length and batch size.`,st,F,sl="Here we set the <em>batch_size</em> to 1, meaning that we can only process one input prompt in parallel. We set the <em>sequence_length</em> to 2048, which corresponds to half the model maximum capacity (4096).",nt,q,nl="The formula to evaluate the size of the KV cache is more involved as it also depends on parameters related to the model architecture, such as the width of the embeddings and the number of decoder blocks.",at,P,al="Bottom-line is, to get very large language models to fit, tensor parallelism is used to split weights, data, and compute across multiple NeuronCores, keeping in mind that the memory on each core cannot exceed 16GB.",ot,K,ol=`Note that increasing the number of cores beyond the minimum requirement almost always results in a faster model.
Increasing the tensor parallelism degree improves memory bandwidth which improves model performance.`,it,D,il="To optimize performance it’s recommended to use all cores available on the instance.",Mt,O,Ml=`In this guide we use all the 24 cores of the <em>inf2.48xlarge</em>, but this should be changed to 12 if you are
using a <em>inf2.24xlarge</em> instance.`,pt,ee,mt,te,pl='Once your model has been exported, you can generate text using the transformers library, as it has been described in <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">detail in this post</a>.',rt,le,ml="If as suggested you skipped the first section, don’t worry: we will use a precompiled model already present on the hub instead.",yt,se,wt,ne,rl="We will need a <em>Llama 2</em> tokenizer to convert the prompt strings to text tokens.",ht,ae,ut,oe,yl="The following generation strategies are supported:",Jt,ie,wl="<li>greedy search,</li> <li>multinomial sampling with top-k and top-p (with temperature).</li>",Tt,Me,hl="Most logits pre-processing/filters (such as repetition penalty) are supported.",ct,pe,jt,me,Ut,re,ul="We specifically selected a <strong>Llama 2</strong> chat variant to illustrate the excellent behaviour of the exported model when the length of the encoding context grows.",dt,ye,Jl="The model expects the prompts to be formatted following a specific template corresponding to the interactions between a <em>user</em> role and an <em>assistant</em> role.",It,we,Tl='Each chat model has its own convention for encoding such contents, and we will not go into too much details in this guide, because we will directly use the <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">Hugging Face chat templates</a> corresponding to our model.',Ct,he,cl="The utility function below converts a list of exchanges between the user and the model into a well-formatted chat prompt.",ft,ue,bt,Je,jl="We are now equipped to build a simplistic chat application.",gt,Te,Ul=`We simply store the interactions between the user and the assistant in a list that we use to generate
the input prompt.`,At,ce,xt,je,dl="To test the chat application you can use for instance the following sequence of prompts:",vt,Ue,Bt,de,Il="While very powerful, Large language models can sometimes <em>hallucinate</em>. We call <em>hallucinations</em> generated content that is irrelevant or made-up but presented by the model as if it was accurate. This is a flaw of LLMs and is not a side effect of using them on Trainium / Inferentia.",Gt,Ce,Zt;return T=new fe({props:{title:"Create your own chatbot with llama-2-13B on AWS Inferentia",local:"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia",headingTag:"h1"}}),C=new fe({props:{title:"1. Export the Llama 2 model to Neuron",local:"1-export-the-llama-2-model-to-neuron",headingTag:"h2"}}),G=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJudW1fY29yZXMlMjIlM0ElMjAyNCUyQyUyMCUyMmF1dG9fY2FzdF90eXBlJTIyJTNBJTIwJ2ZwMTYnJTdEJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJzZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjAyMDQ4JTdEJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqaW5wdXRfc2hhcGVzKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

compiler_args = {<span class="hljs-string">&quot;num_cores&quot;</span>: <span class="hljs-number">24</span>, <span class="hljs-string">&quot;auto_cast_type&quot;</span>: <span class="hljs-string">&#x27;fp16&#x27;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),k=new u({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyKQ==",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>)',wrap:!1}}),X=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),S=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUwQSUwQW9yZyUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBJTBBcmVwb19pZCUyMCUzRCUyMGYlMjIlN0JvcmclN0QlMkZsbGFtYS0yLTEzYi1jaGF0LW5ldXJvbiUyMiUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami

org = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]

repo_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{org}</span>/llama-2-13b-chat-neuron&quot;</span>

model.push_to_hub(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>, repository_id=repo_id)`,wrap:!1}}),N=new fe({props:{title:"A few more words about export parameters.",local:"a-few-more-words-about-export-parameters",headingTag:"h3"}}),E=new u({props:{code:"JTIwJTIwJTIwbWVtb3J5JTIwJTNEJTIwYnl0ZXMlMjBwZXIlMjBwYXJhbWV0ZXIlMjAqJTIwbnVtYmVyJTIwb2YlMjBwYXJhbWV0ZXJz",highlighted:'   memory = bytes per <span class="hljs-keyword">parameter</span> * <span class="hljs-keyword">number</span> of parameters',wrap:!1}}),ee=new fe({props:{title:"2. Generate text using Llama 2 on AWS Inferentia2",local:"2-generate-text-using-llama-2-on-aws-inferentia2",headingTag:"h2"}}),se=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTBBZXhjZXB0JTIwTmFtZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRWRpdCUyMHRoaXMlMjB0byUyMHVzZSUyMGFub3RoZXIlMjBiYXNlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCdhd3MtbmV1cm9uJTJGTGxhbWEtMi0xM2ItY2hhdC1oZi1uZXVyb24tbGF0ZW5jeScp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

<span class="hljs-keyword">try</span>:
    model
<span class="hljs-keyword">except</span> NameError:
    <span class="hljs-comment"># Edit this to use another base model</span>
    model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;aws-neuron/Llama-2-13b-chat-hf-neuron-latency&#x27;</span>)`,wrap:!1}}),ae=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>)`,wrap:!1}}),pe=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMldoYXQlMjBpcyUyMGRlZXAtbGVhcm5pbmclMjAlM0YlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC45JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9wJTNEMC45KSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`inputs = tokenizer(<span class="hljs-string">&quot;What is deep-learning ?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model.generate(**inputs,
                         max_new_tokens=<span class="hljs-number">128</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         temperature=<span class="hljs-number">0.9</span>,
                         top_k=<span class="hljs-number">50</span>,
                         top_p=<span class="hljs-number">0.9</span>)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),me=new fe({props:{title:"3. Create a chat application using llama on AWS Inferentia2",local:"3-create-a-chat-application-using-llama-on-aws-inferentia2",headingTag:"h2"}}),ue=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_chat_prompt</span>(<span class="hljs-params">message, history, max_tokens</span>):
    <span class="hljs-string">&quot;&quot;&quot; Convert a history of messages to a chat prompt


    Args:
        message(str): the new user message.
        history (List[str]): the list of user messages and assistant responses.
        max_tokens (int): the maximum number of input tokens accepted by the model.

    Returns:
        a \`str\` prompt.
    &quot;&quot;&quot;</span>
    chat = []
    <span class="hljs-comment"># Convert all messages in history to chat interactions</span>
    <span class="hljs-keyword">for</span> interaction <span class="hljs-keyword">in</span> history:
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">0</span>]})
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">1</span>]})
    <span class="hljs-comment"># Add the new message</span>
    chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : message})
    <span class="hljs-comment"># Generate the prompt, verifying that we don&#x27;t go beyond the maximum number of tokens</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(chat), <span class="hljs-number">2</span>):
        <span class="hljs-comment"># Generate candidate prompt with the last n-i entries</span>
        prompt = tokenizer.apply_chat_template(chat[i:], tokenize=<span class="hljs-literal">False</span>)
        <span class="hljs-comment"># Tokenize to check if we&#x27;re over the limit</span>
        tokens = tokenizer(prompt)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(tokens.input_ids) &lt;= max_tokens:
            <span class="hljs-comment"># We&#x27;re good, stop here</span>
            <span class="hljs-keyword">return</span> prompt
    <span class="hljs-comment"># We shall never reach this line</span>
    <span class="hljs-keyword">raise</span> SystemError`,wrap:!1}}),ce=new u({props:{code:"aGlzdG9yeSUyMCUzRCUyMCU1QiU1RCUwQW1heF90b2tlbnMlMjAlM0QlMjAxMDI0JTBBJTBBZGVmJTIwY2hhdChtZXNzYWdlJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZm9ybWF0X2NoYXRfcHJvbXB0KG1lc3NhZ2UlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2VucyklMEElMjAlMjAlMjAlMjAlMjMlMjBVbmNvbW1lbnQlMjB0aGUlMjBsaW5lJTIwYmVsb3clMjB0byUyMHNlZSUyMHdoYXQlMjB0aGUlMjBmb3JtYXR0ZWQlMjBwcm9tcHQlMjBsb29rcyUyMGxpa2UlMEElMjAlMjAlMjAlMjAlMjNwcmludChwcm9tcHQpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDIwNDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfayUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4yKSUwQSUyMCUyMCUyMCUyMCUyMyUyMERvJTIwbm90JTIwaW5jbHVkZSUyMHRoZSUyMGlucHV0JTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUIwJTJDJTIwaW5wdXRzLmlucHV0X2lkcy5zaXplKC0xKSUzQSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaGlzdG9yeS5hcHBlbmQoJTVCbWVzc2FnZSUyQyUyMHJlc3BvbnNlJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNl",highlighted:`history = []
max_tokens = <span class="hljs-number">1024</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history, max_tokens</span>):
    prompt = format_chat_prompt(message, history, max_tokens)
    <span class="hljs-comment"># Uncomment the line below to see what the formatted prompt looks like</span>
    <span class="hljs-comment">#print(prompt)</span>
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs,
                             max_length=<span class="hljs-number">2048</span>,
                             do_sample=<span class="hljs-literal">True</span>,
                             temperature=<span class="hljs-number">0.9</span>,
                             top_k=<span class="hljs-number">50</span>,
                             repetition_penalty=<span class="hljs-number">1.2</span>)
    <span class="hljs-comment"># Do not include the input tokens</span>
    outputs = outputs[<span class="hljs-number">0</span>, inputs.input_ids.size(-<span class="hljs-number">1</span>):]
    response = tokenizer.decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
    history.append([message, response])
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),Ue=new u({props:{code:"cHJpbnQoY2hhdCglMjJNeSUyMGZhdm9yaXRlJTIwY29sb3IlMjBpcyUyMGJsdWUuJTIwTXklMjBmYXZvcml0ZSUyMGZydWl0JTIwaXMlMjBzdHJhd2JlcnJ5LiUyMiUyQyUyMGhpc3RvcnklMkMlMjBtYXhfdG9rZW5zKSklMEFwcmludChjaGF0KCUyMk5hbWUlMjBhJTIwZnJ1aXQlMjB0aGF0JTIwaXMlMjBvbiUyMG15JTIwZmF2b3JpdGUlMjBjb2xvdXIuJTIyJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpKSUwQXByaW50KGNoYXQoJTIyV2hhdCUyMGlzJTIwdGhlJTIwY29sb3VyJTIwb2YlMjBteSUyMGZhdm9yaXRlJTIwZnJ1aXQlMjAlM0YlMjIlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2Vucykp",highlighted:`<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;My favorite color is blue. My favorite fruit is strawberry.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;Name a fruit that is on my favorite colour.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;What is the colour of my favorite fruit ?&quot;</span>, history, max_tokens))`,wrap:!1}}),{c(){J=o("meta"),be=n(),Ie=o("p"),ge=n(),p(T.$$.fragment),Ae=n(),c=o("p"),c.innerHTML=kt,xe=n(),j=o("p"),j.innerHTML=$t,ve=n(),U=o("p"),U.textContent=Ht,Be=n(),d=o("ul"),d.innerHTML=_t,Ge=n(),I=o("p"),I.textContent=Xt,Ze=n(),p(C.$$.fragment),We=n(),f=o("p"),f.innerHTML=Vt,ke=n(),b=o("p"),b.innerHTML=zt,$e=n(),g=o("p"),g.innerHTML=St,He=n(),A=o("p"),A.textContent=Nt,_e=n(),x=o("ul"),x.innerHTML=Qt,Xe=n(),v=o("p"),v.textContent=Et,Ve=n(),B=o("p"),B.textContent=Yt,ze=n(),p(G.$$.fragment),Se=n(),Z=o("p"),Z.textContent=Lt,Ne=n(),W=o("p"),W.textContent=Rt,Qe=n(),p(k.$$.fragment),Ee=n(),$=o("p"),$.innerHTML=Ft,Ye=n(),H=o("p"),H.innerHTML=qt,Le=n(),_=o("p"),_.textContent=Pt,Re=n(),p(X.$$.fragment),Fe=n(),V=o("p"),V.textContent=Kt,qe=n(),z=o("p"),z.innerHTML=Dt,Pe=n(),p(S.$$.fragment),Ke=n(),p(N.$$.fragment),De=n(),Q=o("p"),Q.textContent=Ot,Oe=n(),p(E.$$.fragment),et=n(),Y=o("p"),Y.innerHTML=el,tt=n(),L=o("p"),L.textContent=tl,lt=n(),R=o("p"),R.textContent=ll,st=n(),F=o("p"),F.innerHTML=sl,nt=n(),q=o("p"),q.textContent=nl,at=n(),P=o("p"),P.textContent=al,ot=n(),K=o("p"),K.textContent=ol,it=n(),D=o("p"),D.textContent=il,Mt=n(),O=o("p"),O.innerHTML=Ml,pt=n(),p(ee.$$.fragment),mt=n(),te=o("p"),te.innerHTML=pl,rt=n(),le=o("p"),le.textContent=ml,yt=n(),p(se.$$.fragment),wt=n(),ne=o("p"),ne.innerHTML=rl,ht=n(),p(ae.$$.fragment),ut=n(),oe=o("p"),oe.textContent=yl,Jt=n(),ie=o("ul"),ie.innerHTML=wl,Tt=n(),Me=o("p"),Me.textContent=hl,ct=n(),p(pe.$$.fragment),jt=n(),p(me.$$.fragment),Ut=n(),re=o("p"),re.innerHTML=ul,dt=n(),ye=o("p"),ye.innerHTML=Jl,It=n(),we=o("p"),we.innerHTML=Tl,Ct=n(),he=o("p"),he.textContent=cl,ft=n(),p(ue.$$.fragment),bt=n(),Je=o("p"),Je.textContent=jl,gt=n(),Te=o("p"),Te.textContent=Ul,At=n(),p(ce.$$.fragment),xt=n(),je=o("p"),je.textContent=dl,vt=n(),p(Ue.$$.fragment),Bt=Cl(`
<Warning>
`),de=o("p"),de.innerHTML=Il,Gt=Cl(`
</Warning>

`),Ce=o("p"),this.h()},l(e){const t=Zl("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),be=a(e),Ie=i(e,"P",{}),fl(Ie).forEach(l),ge=a(e),m(T.$$.fragment,e),Ae=a(e),c=i(e,"P",{"data-svelte-h":!0}),M(c)!=="svelte-14mc9a1"&&(c.innerHTML=kt),xe=a(e),j=i(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1skq0wn"&&(j.innerHTML=$t),ve=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1hahfn0"&&(U.textContent=Ht),Be=a(e),d=i(e,"UL",{"data-svelte-h":!0}),M(d)!=="svelte-1ivcbtp"&&(d.innerHTML=_t),Ge=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1jogm5f"&&(I.textContent=Xt),Ze=a(e),m(C.$$.fragment,e),We=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1hepwaf"&&(f.innerHTML=Vt),ke=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1s9dc42"&&(b.innerHTML=zt),$e=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-16q26vx"&&(g.innerHTML=St),He=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-vz83yd"&&(A.textContent=Nt),_e=a(e),x=i(e,"UL",{"data-svelte-h":!0}),M(x)!=="svelte-1z4h5r"&&(x.innerHTML=Qt),Xe=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-i8skpg"&&(v.textContent=Et),Ve=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-121tgcd"&&(B.textContent=Yt),ze=a(e),m(G.$$.fragment,e),Se=a(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1j7pdia"&&(Z.textContent=Lt),Ne=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-wxy07q"&&(W.textContent=Rt),Qe=a(e),m(k.$$.fragment,e),Ee=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-16smhm8"&&($.innerHTML=Ft),Ye=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1jkprhy"&&(H.innerHTML=qt),Le=a(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1lo2b6p"&&(_.textContent=Pt),Re=a(e),m(X.$$.fragment,e),Fe=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-8c3of4"&&(V.textContent=Kt),qe=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1kcpd2e"&&(z.innerHTML=Dt),Pe=a(e),m(S.$$.fragment,e),Ke=a(e),m(N.$$.fragment,e),De=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-mi975y"&&(Q.textContent=Ot),Oe=a(e),m(E.$$.fragment,e),et=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-zmj8oy"&&(Y.innerHTML=el),tt=a(e),L=i(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1hs4joy"&&(L.textContent=tl),lt=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-13xxwf3"&&(R.textContent=ll),st=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-13q3i6n"&&(F.innerHTML=sl),nt=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-mdqsxr"&&(q.textContent=nl),at=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-12eo3v5"&&(P.textContent=al),ot=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-qqihmw"&&(K.textContent=ol),it=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-13dz4vh"&&(D.textContent=il),Mt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-exk3d9"&&(O.innerHTML=Ml),pt=a(e),m(ee.$$.fragment,e),mt=a(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-a6bs6o"&&(te.innerHTML=pl),rt=a(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-zz3frh"&&(le.textContent=ml),yt=a(e),m(se.$$.fragment,e),wt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1ps6mip"&&(ne.innerHTML=rl),ht=a(e),m(ae.$$.fragment,e),ut=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1y7mxpx"&&(oe.textContent=yl),Jt=a(e),ie=i(e,"UL",{"data-svelte-h":!0}),M(ie)!=="svelte-a4n5id"&&(ie.innerHTML=wl),Tt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-k217aq"&&(Me.textContent=hl),ct=a(e),m(pe.$$.fragment,e),jt=a(e),m(me.$$.fragment,e),Ut=a(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1ezk4g0"&&(re.innerHTML=ul),dt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1e1yopm"&&(ye.innerHTML=Jl),It=a(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1xcz5ok"&&(we.innerHTML=Tl),Ct=a(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1v5xgsn"&&(he.textContent=cl),ft=a(e),m(ue.$$.fragment,e),bt=a(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-1hfx6dq"&&(Je.textContent=jl),gt=a(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-ffg1bu"&&(Te.textContent=Ul),At=a(e),m(ce.$$.fragment,e),xt=a(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-hnyltz"&&(je.textContent=dl),vt=a(e),m(Ue.$$.fragment,e),Bt=bl(e,`
<Warning>
`),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-l0vp04"&&(de.innerHTML=Il),Gt=bl(e,`
</Warning>

`),Ce=i(e,"P",{}),fl(Ce).forEach(l),this.h()},h(){gl(J,"name","hf:doc:metadata"),gl(J,"content",$l)},m(e,t){Wl(document.head,J),s(e,be,t),s(e,Ie,t),s(e,ge,t),r(T,e,t),s(e,Ae,t),s(e,c,t),s(e,xe,t),s(e,j,t),s(e,ve,t),s(e,U,t),s(e,Be,t),s(e,d,t),s(e,Ge,t),s(e,I,t),s(e,Ze,t),r(C,e,t),s(e,We,t),s(e,f,t),s(e,ke,t),s(e,b,t),s(e,$e,t),s(e,g,t),s(e,He,t),s(e,A,t),s(e,_e,t),s(e,x,t),s(e,Xe,t),s(e,v,t),s(e,Ve,t),s(e,B,t),s(e,ze,t),r(G,e,t),s(e,Se,t),s(e,Z,t),s(e,Ne,t),s(e,W,t),s(e,Qe,t),r(k,e,t),s(e,Ee,t),s(e,$,t),s(e,Ye,t),s(e,H,t),s(e,Le,t),s(e,_,t),s(e,Re,t),r(X,e,t),s(e,Fe,t),s(e,V,t),s(e,qe,t),s(e,z,t),s(e,Pe,t),r(S,e,t),s(e,Ke,t),r(N,e,t),s(e,De,t),s(e,Q,t),s(e,Oe,t),r(E,e,t),s(e,et,t),s(e,Y,t),s(e,tt,t),s(e,L,t),s(e,lt,t),s(e,R,t),s(e,st,t),s(e,F,t),s(e,nt,t),s(e,q,t),s(e,at,t),s(e,P,t),s(e,ot,t),s(e,K,t),s(e,it,t),s(e,D,t),s(e,Mt,t),s(e,O,t),s(e,pt,t),r(ee,e,t),s(e,mt,t),s(e,te,t),s(e,rt,t),s(e,le,t),s(e,yt,t),r(se,e,t),s(e,wt,t),s(e,ne,t),s(e,ht,t),r(ae,e,t),s(e,ut,t),s(e,oe,t),s(e,Jt,t),s(e,ie,t),s(e,Tt,t),s(e,Me,t),s(e,ct,t),r(pe,e,t),s(e,jt,t),r(me,e,t),s(e,Ut,t),s(e,re,t),s(e,dt,t),s(e,ye,t),s(e,It,t),s(e,we,t),s(e,Ct,t),s(e,he,t),s(e,ft,t),r(ue,e,t),s(e,bt,t),s(e,Je,t),s(e,gt,t),s(e,Te,t),s(e,At,t),r(ce,e,t),s(e,xt,t),s(e,je,t),s(e,vt,t),r(Ue,e,t),s(e,Bt,t),s(e,de,t),s(e,Gt,t),s(e,Ce,t),Zt=!0},p:xl,i(e){Zt||(y(T.$$.fragment,e),y(C.$$.fragment,e),y(G.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(S.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ae.$$.fragment,e),y(pe.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(ce.$$.fragment,e),y(Ue.$$.fragment,e),Zt=!0)},o(e){w(T.$$.fragment,e),w(C.$$.fragment,e),w(G.$$.fragment,e),w(k.$$.fragment,e),w(X.$$.fragment,e),w(S.$$.fragment,e),w(N.$$.fragment,e),w(E.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(ae.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(ue.$$.fragment,e),w(ce.$$.fragment,e),w(Ue.$$.fragment,e),Zt=!1},d(e){e&&(l(be),l(Ie),l(ge),l(Ae),l(c),l(xe),l(j),l(ve),l(U),l(Be),l(d),l(Ge),l(I),l(Ze),l(We),l(f),l(ke),l(b),l($e),l(g),l(He),l(A),l(_e),l(x),l(Xe),l(v),l(Ve),l(B),l(ze),l(Se),l(Z),l(Ne),l(W),l(Qe),l(Ee),l($),l(Ye),l(H),l(Le),l(_),l(Re),l(Fe),l(V),l(qe),l(z),l(Pe),l(Ke),l(De),l(Q),l(Oe),l(et),l(Y),l(tt),l(L),l(lt),l(R),l(st),l(F),l(nt),l(q),l(at),l(P),l(ot),l(K),l(it),l(D),l(Mt),l(O),l(pt),l(mt),l(te),l(rt),l(le),l(yt),l(wt),l(ne),l(ht),l(ut),l(oe),l(Jt),l(ie),l(Tt),l(Me),l(ct),l(jt),l(Ut),l(re),l(dt),l(ye),l(It),l(we),l(Ct),l(he),l(ft),l(bt),l(Je),l(gt),l(Te),l(At),l(xt),l(je),l(vt),l(Bt),l(de),l(Gt),l(Ce)),l(J),h(T,e),h(C,e),h(G,e),h(k,e),h(X,e),h(S,e),h(N,e),h(E,e),h(ee,e),h(se,e),h(ae,e),h(pe,e),h(me,e),h(ue,e),h(ce,e),h(Ue,e)}}}const $l='{"title":"Create your own chatbot with llama-2-13B on AWS Inferentia","local":"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia","sections":[{"title":"1. Export the Llama 2 model to Neuron","local":"1-export-the-llama-2-model-to-neuron","sections":[{"title":"A few more words about export parameters.","local":"a-few-more-words-about-export-parameters","sections":[],"depth":3}],"depth":2},{"title":"2. Generate text using Llama 2 on AWS Inferentia2","local":"2-generate-text-using-llama-2-on-aws-inferentia2","sections":[],"depth":2},{"title":"3. Create a chat application using llama on AWS Inferentia2","local":"3-create-a-chat-application-using-llama-on-aws-inferentia2","sections":[],"depth":2}],"depth":1}';function Hl(Wt){return vl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Bl{constructor(J){super(),Gl(this,J,Hl,kl,Al,{})}}export{Sl as component};
