import{s as _l,n as kl,o as El}from"../chunks/scheduler.85c25b89.js";import{S as Rl,i as vl,g as i,s as n,r as o,A as xl,h as M,f as e,c as a,j as Gl,u as p,x as r,k as Vl,y as Fl,a as s,v as J,d as T,t as m,w as c}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.c004bd26.js";import{H as F}from"../chunks/getInferenceSnippets.d9278495.js";function Hl(jl){let y,Y,H,z,w,S,u,Ul="🤗 Optimum Neuron makes AWS accelerator adoption seamless for Hugging Face users with <strong>drop-in replacements</strong> for standard training and inference components.",L,d,Il='<strong>*🚀 Need to set up your environment first?</strong> Check out our <a href="getting-started-on-ec2">Getting Started on EC2</a> page for complete installation and AWS setup instructions.*',q,j,bl="<strong>Key Features:</strong>",D,U,hl="<li>🔄 <strong>Drop-in replacement</strong> for standard Transformers training and inference</li> <li>⚡ <strong>Distributed training</strong> support with minimal code changes</li> <li>🎯 <strong>Optimized models</strong> for AWS accelerators</li> <li>📈 <strong>Production-ready</strong> inference with compiled models</li>",P,I,K,b,fl="Training on AWS Trainium requires minimal changes to your existing code - just swap in Optimum Neuron’s drop-in replacements:",O,h,ll,f,Zl='This example demonstrates supervised fine-tuning on the <a href="https://huggingface.co/datasets/databricks/databricks-dolly-15k" rel="nofollow">Databricks Dolly dataset</a> using <code>NeuronSFTTrainer</code> and <code>NeuronModelForCausalLM</code> - the Trainium-optimized versions of standard Transformers components.',tl,Z,el,C,Cl="<strong>Compilation</strong> (optional for first run):",sl,g,nl,X,gl="<strong>Training:</strong>",al,B,il,W,Ml,A,Xl="Optimized inference requires two steps: <strong>export</strong> your model to Neuron format, then <strong>run</strong> it with <code>NeuronModelForXXX</code> classes.",rl,N,ol,G,pl,V,Bl='This exports the model with optimized settings: static shapes (<code>batch_size=1</code>, <code>sequence_length=32</code>) and BF16 precision for <code>matmul</code> operations. Check out the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">exporter guide</a> for more compilation options.',Jl,_,Tl,k,ml,E,Wl="The <code>NeuronModelForXXX</code> classes work as drop-in replacements for their <code>AutoModelForXXX</code> counterparts, making migration seamless.",cl,R,yl,v,Al="Ready to dive deeper? Check out our comprehensive guides:",wl,x,Nl='<li>📚 <strong><a href="getting-started">Getting Started</a></strong> - Complete setup and installation</li> <li>🏋️ <strong><a href="training_tutorials/notebooks">Training Tutorials</a></strong> - End-to-end training examples</li> <li>🔧 <strong><a href="guides/export_model">Export Guide</a></strong> - Advanced model compilation options</li>',ul,$,dl;return w=new F({props:{title:"Quickstart",local:"quickstart",headingTag:"h1"}}),I=new F({props:{title:"Training",local:"training",headingTag:"h2"}}),h=new Q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch_xla.runtime <span class="hljs-keyword">as</span> xr

<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># Optimum Neuron&#x27;s drop-in replacements for standard training components</span>
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronSFTConfig, NeuronSFTTrainer, NeuronTrainingArguments
<span class="hljs-keyword">from</span> optimum.neuron.models.training <span class="hljs-keyword">import</span> NeuronModelForCausalLM


<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_dolly_dataset</span>(<span class="hljs-params">example</span>):
    <span class="hljs-string">&quot;&quot;&quot;Format Dolly dataset into instruction-following format.&quot;&quot;&quot;</span>
    instruction = <span class="hljs-string">f&quot;### Instruction\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>]}</span>&quot;</span>
    context = <span class="hljs-string">f&quot;### Context\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;context&#x27;</span>]}</span>&quot;</span> <span class="hljs-keyword">if</span> example[<span class="hljs-string">&quot;context&quot;</span>] <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>
    response = <span class="hljs-string">f&quot;### Answer\\n<span class="hljs-subst">{example[<span class="hljs-string">&#x27;response&#x27;</span>]}</span>&quot;</span>
    
    <span class="hljs-comment"># Combine all parts with double newlines</span>
    parts = [instruction, context, response]
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n\\n&quot;</span>.join(part <span class="hljs-keyword">for</span> part <span class="hljs-keyword">in</span> parts <span class="hljs-keyword">if</span> part)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Load instruction-following dataset</span>
    dataset = load_dataset(<span class="hljs-string">&quot;databricks/databricks-dolly-15k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
    
    <span class="hljs-comment"># Model configuration</span>
    model_id = <span class="hljs-string">&quot;Qwen/Qwen3-1.7B&quot;</span>
    output_dir = <span class="hljs-string">&quot;qwen3-1.7b-finetuned&quot;</span>
    
    <span class="hljs-comment"># Setup tokenizer</span>
    tokenizer = AutoTokenizer.from_pretrained(model_id)
    tokenizer.pad_token = tokenizer.eos_token
    
    <span class="hljs-comment"># Configure training for Trainium</span>
    training_args = NeuronTrainingArguments(
        learning_rate=<span class="hljs-number">1e-4</span>,
        tensor_parallel_size=<span class="hljs-number">8</span>,  <span class="hljs-comment"># Split model across 8 accelerators</span>
        per_device_train_batch_size=<span class="hljs-number">1</span>,  <span class="hljs-comment"># Batch size per device</span>
        gradient_accumulation_steps=<span class="hljs-number">8</span>,
        logging_steps=<span class="hljs-number">1</span>,
        output_dir=output_dir,
    )
    
    <span class="hljs-comment"># Load model optimized for Trainium</span>
    model = NeuronModelForCausalLM.from_pretrained(
        model_id,
        training_args.trn_config,
        torch_dtype=torch.bfloat16,
        use_flash_attention_2=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable fast attention</span>
    )
    
    <span class="hljs-comment"># Setup supervised fine-tuning</span>
    sft_config = NeuronSFTConfig(
        max_seq_length=<span class="hljs-number">2048</span>,
        packing=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Pack multiple samples for efficiency</span>
        **training_args.to_dict(),
    )
    
    <span class="hljs-comment"># Initialize trainer and start training</span>
    trainer = NeuronSFTTrainer(
        model=model,
        args=sft_config,
        tokenizer=tokenizer,
        train_dataset=dataset,
        formatting_func=format_dolly_dataset,
    )
    
    trainer.train()
    
    <span class="hljs-comment"># Share your model with the community</span>
    trainer.push_to_hub(
        commit_message=<span class="hljs-string">&quot;Fine-tuned on Databricks Dolly dataset&quot;</span>,
        blocking=<span class="hljs-literal">True</span>,
        model_name=output_dir,
    )
    
    <span class="hljs-keyword">if</span> xr.local_ordinal() == <span class="hljs-number">0</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Training complete! Model saved to <span class="hljs-subst">{output_dir}</span>&quot;</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),Z=new F({props:{title:"Running Training",local:"running-training",headingTag:"h3"}}),g=new Q({props:{code:"TkVVUk9OX0NDX0ZMQUdTJTNEJTIyLS1tb2RlbC10eXBlJTIwdHJhbnNmb3JtZXIlMjIlMjBuZXVyb25fcGFyYWxsZWxfY29tcGlsZSUyMHRvcmNocnVuJTIwLS1ucHJvY19wZXJfbm9kZSUyMDMyJTIwc2Z0X2ZpbmV0dW5lX3F3ZW4zLnB5",highlighted:'NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer&quot;</span> neuron_parallel_compile torchrun --nproc_per_node 32 sft_finetune_qwen3.py',wrap:!1}}),B=new Q({props:{code:"TkVVUk9OX0NDX0ZMQUdTJTNEJTIyLS1tb2RlbC10eXBlJTIwdHJhbnNmb3JtZXIlMjIlMjB0b3JjaHJ1biUyMC0tbnByb2NfcGVyX25vZGUlMjAzMiUyMHNmdF9maW5ldHVuZV9xd2VuMy5weQ==",highlighted:'NEURON_CC_FLAGS=<span class="hljs-string">&quot;--model-type transformer&quot;</span> torchrun --nproc_per_node 32 sft_finetune_qwen3.py',wrap:!1}}),W=new F({props:{title:"Inference",local:"inference",headingTag:"h2"}}),N=new F({props:{title:"1. Export Your Model",local:"1-export-your-model",headingTag:"h3"}}),G=new Q({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAlNUMlMEElMjAlMjAtLW1vZGVsJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjAlNUMlMEElMjAlMjAtLWJhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwLS1zZXF1ZW5jZV9sZW5ndGglMjAzMiUyMCU1QyUwQSUyMCUyMC0tYXV0b19jYXN0JTIwbWF0bXVsJTIwJTVDJTBBJTIwJTIwLS1hdXRvX2Nhc3RfdHlwZSUyMGJmMTYlMjAlNUMlMEElMjAlMjBkaXN0aWxiZXJ0X2Jhc2VfdW5jYXNlZF9maW5ldHVuZWRfc3N0Ml9lbmdsaXNoX25ldXJvbiUyRg==",highlighted:`optimum-cli <span class="hljs-built_in">export</span> neuron \\
  --model distilbert-base-uncased-finetuned-sst-2-english \\
  --batch_size 1 \\
  --sequence_length 32 \\
  --auto_cast matmul \\
  --auto_cast_type bf16 \\
  distilbert_base_uncased_finetuned_sst2_english_neuron/`,wrap:!1}}),_=new F({props:{title:"2. Run Inference",local:"2-run-inference",headingTag:"h3"}}),k=new Q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwY29tcGlsZWQlMjBOZXVyb24lMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaXN0aWxiZXJ0X2Jhc2VfdW5jYXNlZF9maW5ldHVuZWRfc3N0Ml9lbmdsaXNoX25ldXJvbiUyMiUwQSklMEElMEElMjMlMjBTZXR1cCUyMHRva2VuaXplciUyMChzYW1lJTIwYXMlMjBvcmlnaW5hbCUyMG1vZGVsKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQSUyMyUyMFJ1biUyMGluZmVyZW5jZSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIYW1pbHRvbiUyMGlzJTIwY29uc2lkZXJlZCUyMHRvJTIwYmUlMjB0aGUlMjBiZXN0JTIwbXVzaWNhbCUyMG9mJTIwcGFzdCUyMHllYXJzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxvZ2l0cy5hcmdtYXgoKS5pdGVtKCklNUQpJTBBJTIzJTIwJ1BPU0lUSVZFJw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

<span class="hljs-comment"># Load the compiled Neuron model</span>
model = NeuronModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&quot;distilbert_base_uncased_finetuned_sst2_english_neuron&quot;</span>
)

<span class="hljs-comment"># Setup tokenizer (same as original model)</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-comment"># Run inference</span>
inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of past years.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
logits = model(**inputs).logits

<span class="hljs-built_in">print</span>(model.config.id2label[logits.argmax().item()])
<span class="hljs-comment"># &#x27;POSITIVE&#x27;</span>`,wrap:!1}}),R=new F({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),{c(){y=i("meta"),Y=n(),H=i("p"),z=n(),o(w.$$.fragment),S=n(),u=i("p"),u.innerHTML=Ul,L=n(),d=i("p"),d.innerHTML=Il,q=n(),j=i("p"),j.innerHTML=bl,D=n(),U=i("ul"),U.innerHTML=hl,P=n(),o(I.$$.fragment),K=n(),b=i("p"),b.textContent=fl,O=n(),o(h.$$.fragment),ll=n(),f=i("p"),f.innerHTML=Zl,tl=n(),o(Z.$$.fragment),el=n(),C=i("p"),C.innerHTML=Cl,sl=n(),o(g.$$.fragment),nl=n(),X=i("p"),X.innerHTML=gl,al=n(),o(B.$$.fragment),il=n(),o(W.$$.fragment),Ml=n(),A=i("p"),A.innerHTML=Xl,rl=n(),o(N.$$.fragment),ol=n(),o(G.$$.fragment),pl=n(),V=i("p"),V.innerHTML=Bl,Jl=n(),o(_.$$.fragment),Tl=n(),o(k.$$.fragment),ml=n(),E=i("p"),E.innerHTML=Wl,cl=n(),o(R.$$.fragment),yl=n(),v=i("p"),v.textContent=Al,wl=n(),x=i("ul"),x.innerHTML=Nl,ul=n(),$=i("p"),this.h()},l(l){const t=xl("svelte-u9bgzb",document.head);y=M(t,"META",{name:!0,content:!0}),t.forEach(e),Y=a(l),H=M(l,"P",{}),Gl(H).forEach(e),z=a(l),p(w.$$.fragment,l),S=a(l),u=M(l,"P",{"data-svelte-h":!0}),r(u)!=="svelte-rionjr"&&(u.innerHTML=Ul),L=a(l),d=M(l,"P",{"data-svelte-h":!0}),r(d)!=="svelte-4024ac"&&(d.innerHTML=Il),q=a(l),j=M(l,"P",{"data-svelte-h":!0}),r(j)!=="svelte-dcww01"&&(j.innerHTML=bl),D=a(l),U=M(l,"UL",{"data-svelte-h":!0}),r(U)!=="svelte-1x7ik4"&&(U.innerHTML=hl),P=a(l),p(I.$$.fragment,l),K=a(l),b=M(l,"P",{"data-svelte-h":!0}),r(b)!=="svelte-100vig6"&&(b.textContent=fl),O=a(l),p(h.$$.fragment,l),ll=a(l),f=M(l,"P",{"data-svelte-h":!0}),r(f)!=="svelte-6vr389"&&(f.innerHTML=Zl),tl=a(l),p(Z.$$.fragment,l),el=a(l),C=M(l,"P",{"data-svelte-h":!0}),r(C)!=="svelte-p86113"&&(C.innerHTML=Cl),sl=a(l),p(g.$$.fragment,l),nl=a(l),X=M(l,"P",{"data-svelte-h":!0}),r(X)!=="svelte-16jb019"&&(X.innerHTML=gl),al=a(l),p(B.$$.fragment,l),il=a(l),p(W.$$.fragment,l),Ml=a(l),A=M(l,"P",{"data-svelte-h":!0}),r(A)!=="svelte-18qqgpt"&&(A.innerHTML=Xl),rl=a(l),p(N.$$.fragment,l),ol=a(l),p(G.$$.fragment,l),pl=a(l),V=M(l,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1xuei7w"&&(V.innerHTML=Bl),Jl=a(l),p(_.$$.fragment,l),Tl=a(l),p(k.$$.fragment,l),ml=a(l),E=M(l,"P",{"data-svelte-h":!0}),r(E)!=="svelte-7flx79"&&(E.innerHTML=Wl),cl=a(l),p(R.$$.fragment,l),yl=a(l),v=M(l,"P",{"data-svelte-h":!0}),r(v)!=="svelte-f2vb7f"&&(v.textContent=Al),wl=a(l),x=M(l,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-e9xbbf"&&(x.innerHTML=Nl),ul=a(l),$=M(l,"P",{}),Gl($).forEach(e),this.h()},h(){Vl(y,"name","hf:doc:metadata"),Vl(y,"content",$l)},m(l,t){Fl(document.head,y),s(l,Y,t),s(l,H,t),s(l,z,t),J(w,l,t),s(l,S,t),s(l,u,t),s(l,L,t),s(l,d,t),s(l,q,t),s(l,j,t),s(l,D,t),s(l,U,t),s(l,P,t),J(I,l,t),s(l,K,t),s(l,b,t),s(l,O,t),J(h,l,t),s(l,ll,t),s(l,f,t),s(l,tl,t),J(Z,l,t),s(l,el,t),s(l,C,t),s(l,sl,t),J(g,l,t),s(l,nl,t),s(l,X,t),s(l,al,t),J(B,l,t),s(l,il,t),J(W,l,t),s(l,Ml,t),s(l,A,t),s(l,rl,t),J(N,l,t),s(l,ol,t),J(G,l,t),s(l,pl,t),s(l,V,t),s(l,Jl,t),J(_,l,t),s(l,Tl,t),J(k,l,t),s(l,ml,t),s(l,E,t),s(l,cl,t),J(R,l,t),s(l,yl,t),s(l,v,t),s(l,wl,t),s(l,x,t),s(l,ul,t),s(l,$,t),dl=!0},p:kl,i(l){dl||(T(w.$$.fragment,l),T(I.$$.fragment,l),T(h.$$.fragment,l),T(Z.$$.fragment,l),T(g.$$.fragment,l),T(B.$$.fragment,l),T(W.$$.fragment,l),T(N.$$.fragment,l),T(G.$$.fragment,l),T(_.$$.fragment,l),T(k.$$.fragment,l),T(R.$$.fragment,l),dl=!0)},o(l){m(w.$$.fragment,l),m(I.$$.fragment,l),m(h.$$.fragment,l),m(Z.$$.fragment,l),m(g.$$.fragment,l),m(B.$$.fragment,l),m(W.$$.fragment,l),m(N.$$.fragment,l),m(G.$$.fragment,l),m(_.$$.fragment,l),m(k.$$.fragment,l),m(R.$$.fragment,l),dl=!1},d(l){l&&(e(Y),e(H),e(z),e(S),e(u),e(L),e(d),e(q),e(j),e(D),e(U),e(P),e(K),e(b),e(O),e(ll),e(f),e(tl),e(el),e(C),e(sl),e(nl),e(X),e(al),e(il),e(Ml),e(A),e(rl),e(ol),e(pl),e(V),e(Jl),e(Tl),e(ml),e(E),e(cl),e(yl),e(v),e(wl),e(x),e(ul),e($)),e(y),c(w,l),c(I,l),c(h,l),c(Z,l),c(g,l),c(B,l),c(W,l),c(N,l),c(G,l),c(_,l),c(k,l),c(R,l)}}}const $l='{"title":"Quickstart","local":"quickstart","sections":[{"title":"Training","local":"training","sections":[{"title":"Running Training","local":"running-training","sections":[],"depth":3}],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"1. Export Your Model","local":"1-export-your-model","sections":[],"depth":3},{"title":"2. Run Inference","local":"2-run-inference","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ql(jl){return El(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Rl{constructor(y){super(),vl(this,y,Ql,Hl,_l,{})}}export{ql as component};
