import{s as bl,n as Il,o as _l}from"../chunks/scheduler.b108d059.js";import{S as fl,i as Cl,g as n,s as a,r as o,A as hl,h as M,f as t,c as i,j as rl,u as J,x as p,k as Ul,y as Bl,a as e,v as m,d as T,t as u,w}from"../chunks/index.008de539.js";import{C as R}from"../chunks/CodeBlock.3968c746.js";import{H as nl}from"../chunks/Heading.88bfeb84.js";function Wl(Ml){let c,V,Z,k,d,G,y,pl="In case you don’t settle for the default scikit-learn metrics, you can define your own metric.",Y,j,cl="Here, we expect the organizer to know python.",Q,r,x,U,ol="To define a custom metric, change <code>EVAL_METRIC</code> in <code>conf.json</code> to <code>custom</code>. You must also make sure that <code>EVAL_HIGHER_IS_BETTER</code> is set to <code>1</code> or <code>0</code> depending on whether a higher value of the metric is better or not.",F,b,Jl=`The second step is to create a file <code>metric.py</code> in the private competition repo.
The file should contain a <code>compute</code> function that takes competition params as input.`,$,I,ml="Here is the part where we check if metric is custom and calculate the metric value:",g,_,S,f,Tl="You can find the above part in competitions github repo <code>compute_metrics.py</code>",q,C,ul="<code>params</code> is defined as:",L,h,P,B,wl=`You are free to do whatever you want to in the <code>compute</code> function.
In the end it must return a dictionary with the following keys:`,K,W,D,X,dl=`public and private scores can be floats or can also be dictionaries in case you want to use multiple metrics.
Example for multiple metrics:`,O,A,ll,v,yl="Note: When using multiple metrics, a base metric (the first one) will be used to rank the participants in the competition.",sl,N,tl,z,el,E,jl=`Take a careful look at the above code.
You can see that we are downloading the solution file and the submission file from the dataset repo.
We are then calculating the metric on the public and private splits of the solution and submission files.
Finally, we are returning the metric values in a dictionary.`,al,H,il;return d=new nl({props:{title:"Custom metric",local:"custom-metric",headingTag:"h1"}}),r=new nl({props:{title:"How to define a custom metric",local:"how-to-define-a-custom-metric",headingTag:"h3"}}),_=new R({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKHBhcmFtcyklM0ElMEElMjAlMjAlMjAlMjBpZiUyMHBhcmFtcy5tZXRyaWMlMjAlM0QlM0QlMjAlMjJjdXN0b20lMjIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXRyaWNfZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXBvX2lkJTNEcGFyYW1zLmNvbXBldGl0aW9uX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtZXRyaWMucHklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbiUzRHBhcmFtcy50b2tlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3lzLnBhdGguYXBwZW5kKG9zLnBhdGguZGlybmFtZShtZXRyaWNfZmlsZSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwaW1wb3J0bGliLmltcG9ydF9tb2R1bGUoJTIybWV0cmljJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV2YWx1YXRpb24lMjAlM0QlMjBtZXRyaWMuY29tcHV0ZShwYXJhbXMpJTBBJTIwJTIwJTIwJTIwLiUwQSUyMCUyMCUyMCUyMC4lMEElMjAlMjAlMjAlMjAu",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">params</span>):
    <span class="hljs-keyword">if</span> params.metric == <span class="hljs-string">&quot;custom&quot;</span>:
        metric_file = hf_hub_download(
            repo_id=params.competition_id,
            filename=<span class="hljs-string">&quot;metric.py&quot;</span>,
            token=params.token,
            repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
        )
        sys.path.append(os.path.dirname(metric_file))
        metric = importlib.import_module(<span class="hljs-string">&quot;metric&quot;</span>)
        evaluation = metric.compute(params)
    .
    .
    .`,wrap:!1}}),h=new R({props:{code:"Y2xhc3MlMjBFdmFsUGFyYW1zKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb21wZXRpdGlvbl9pZCUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGNvbXBldGl0aW9uX3R5cGUlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBtZXRyaWMlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0b2tlbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMHRlYW1faWQlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2lkJTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9pZF9jb2wlM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX2NvbHMlM0ElMjBMaXN0JTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwc3VibWlzc2lvbl9yb3dzJTNBJTIwaW50JTBBJTIwJTIwJTIwJTIwb3V0cHV0X3BhdGglM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBzdWJtaXNzaW9uX3JlcG8lM0ElMjBzdHIlMEElMjAlMjAlMjAlMjB0aW1lX2xpbWl0JTNBJTIwaW50",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EvalParams</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    competition_id: <span class="hljs-built_in">str</span>
    competition_type: <span class="hljs-built_in">str</span>
    metric: <span class="hljs-built_in">str</span>
    token: <span class="hljs-built_in">str</span>
    team_id: <span class="hljs-built_in">str</span>
    submission_id: <span class="hljs-built_in">str</span>
    submission_id_col: <span class="hljs-built_in">str</span>
    submission_cols: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]
    submission_rows: <span class="hljs-built_in">int</span>
    output_path: <span class="hljs-built_in">str</span>
    submission_repo: <span class="hljs-built_in">str</span>
    time_limit: <span class="hljs-built_in">int</span>`,wrap:!1}}),W=new R({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwbWV0cmljX3ZhbHVlJTJDJTBBJTIwJTIwJTIwJTIwJTIycHJpdmF0ZV9zY29yZSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: metric_value,
    <span class="hljs-string">&quot;private_score&quot;</span>: metric_value,
}`,wrap:!1}}),A=new R({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycHVibGljX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJwcml2YXRlX3Njb3JlJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWV0cmljMSUyMiUzQSUyMG1ldHJpY192YWx1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpYzIlMjIlM0ElMjBtZXRyaWNfdmFsdWUlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&quot;public_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
    <span class="hljs-string">&quot;private_score&quot;</span>: {
        <span class="hljs-string">&quot;metric1&quot;</span>: metric_value,
        <span class="hljs-string">&quot;metric2&quot;</span>: metric_value,
    },
}`,wrap:!1}}),N=new nl({props:{title:"Example of a custom metric",local:"example-of-a-custom-metric",headingTag:"h3"}}),z=new R({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute</span>(<span class="hljs-params">params</span>):
    solution_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=<span class="hljs-string">&quot;solution.csv&quot;</span>,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )

    solution_df = pd.read_csv(solution_file)

    submission_filename = <span class="hljs-string">f&quot;submissions/<span class="hljs-subst">{params.team_id}</span>-<span class="hljs-subst">{params.submission_id}</span>.csv&quot;</span>
    submission_file = hf_hub_download(
        repo_id=params.competition_id,
        filename=submission_filename,
        token=params.token,
        repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
    )
    submission_df = pd.read_csv(submission_file)

    public_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;public&quot;</span>][params.submission_id_col].values
    private_ids = solution_df[solution_df.split == <span class="hljs-string">&quot;private&quot;</span>][params.submission_id_col].values

    public_solution_df = solution_df[solution_df[params.submission_id_col].isin(public_ids)]
    public_submission_df = submission_df[submission_df[params.submission_id_col].isin(public_ids)]

    private_solution_df = solution_df[solution_df[params.submission_id_col].isin(private_ids)]
    private_submission_df = submission_df[submission_df[params.submission_id_col].isin(private_ids)]

    public_solution_df = public_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    public_submission_df = public_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    private_solution_df = private_solution_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)
    private_submission_df = private_submission_df.sort_values(params.submission_id_col).reset_index(drop=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># CALCULATE METRICS HERE.......</span>
    <span class="hljs-comment"># _metric = SOME METRIC FUNCTION</span>
    target_cols = [col <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> solution_df.columns <span class="hljs-keyword">if</span> col <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [params.submission_id_col, <span class="hljs-string">&quot;split&quot;</span>]]
    public_score = _metric(public_solution_df[target_cols], public_submission_df[target_cols])
    private_score = _metric(private_solution_df[target_cols], private_submission_df[target_cols])

    evaluation = {
        <span class="hljs-string">&quot;public_score&quot;</span>: public_score,
        <span class="hljs-string">&quot;private_score&quot;</span>: private_score,
    }
    <span class="hljs-keyword">return</span> evaluation`,wrap:!1}}),{c(){c=n("meta"),V=a(),Z=n("p"),k=a(),o(d.$$.fragment),G=a(),y=n("p"),y.textContent=pl,Y=a(),j=n("p"),j.textContent=cl,Q=a(),o(r.$$.fragment),x=a(),U=n("p"),U.innerHTML=ol,F=a(),b=n("p"),b.innerHTML=Jl,$=a(),I=n("p"),I.textContent=ml,g=a(),o(_.$$.fragment),S=a(),f=n("p"),f.innerHTML=Tl,q=a(),C=n("p"),C.innerHTML=ul,L=a(),o(h.$$.fragment),P=a(),B=n("p"),B.innerHTML=wl,K=a(),o(W.$$.fragment),D=a(),X=n("p"),X.textContent=dl,O=a(),o(A.$$.fragment),ll=a(),v=n("p"),v.textContent=yl,sl=a(),o(N.$$.fragment),tl=a(),o(z.$$.fragment),el=a(),E=n("p"),E.textContent=jl,al=a(),H=n("p"),this.h()},l(l){const s=hl("svelte-u9bgzb",document.head);c=M(s,"META",{name:!0,content:!0}),s.forEach(t),V=i(l),Z=M(l,"P",{}),rl(Z).forEach(t),k=i(l),J(d.$$.fragment,l),G=i(l),y=M(l,"P",{"data-svelte-h":!0}),p(y)!=="svelte-thew86"&&(y.textContent=pl),Y=i(l),j=M(l,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1bv7n2t"&&(j.textContent=cl),Q=i(l),J(r.$$.fragment,l),x=i(l),U=M(l,"P",{"data-svelte-h":!0}),p(U)!=="svelte-x1ibbx"&&(U.innerHTML=ol),F=i(l),b=M(l,"P",{"data-svelte-h":!0}),p(b)!=="svelte-otcxp4"&&(b.innerHTML=Jl),$=i(l),I=M(l,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1g3svse"&&(I.textContent=ml),g=i(l),J(_.$$.fragment,l),S=i(l),f=M(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-14x4oq"&&(f.innerHTML=Tl),q=i(l),C=M(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1icqugy"&&(C.innerHTML=ul),L=i(l),J(h.$$.fragment,l),P=i(l),B=M(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1o6b4b1"&&(B.innerHTML=wl),K=i(l),J(W.$$.fragment,l),D=i(l),X=M(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1lswa00"&&(X.textContent=dl),O=i(l),J(A.$$.fragment,l),ll=i(l),v=M(l,"P",{"data-svelte-h":!0}),p(v)!=="svelte-18x004c"&&(v.textContent=yl),sl=i(l),J(N.$$.fragment,l),tl=i(l),J(z.$$.fragment,l),el=i(l),E=M(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-mlly83"&&(E.textContent=jl),al=i(l),H=M(l,"P",{}),rl(H).forEach(t),this.h()},h(){Ul(c,"name","hf:doc:metadata"),Ul(c,"content",Xl)},m(l,s){Bl(document.head,c),e(l,V,s),e(l,Z,s),e(l,k,s),m(d,l,s),e(l,G,s),e(l,y,s),e(l,Y,s),e(l,j,s),e(l,Q,s),m(r,l,s),e(l,x,s),e(l,U,s),e(l,F,s),e(l,b,s),e(l,$,s),e(l,I,s),e(l,g,s),m(_,l,s),e(l,S,s),e(l,f,s),e(l,q,s),e(l,C,s),e(l,L,s),m(h,l,s),e(l,P,s),e(l,B,s),e(l,K,s),m(W,l,s),e(l,D,s),e(l,X,s),e(l,O,s),m(A,l,s),e(l,ll,s),e(l,v,s),e(l,sl,s),m(N,l,s),e(l,tl,s),m(z,l,s),e(l,el,s),e(l,E,s),e(l,al,s),e(l,H,s),il=!0},p:Il,i(l){il||(T(d.$$.fragment,l),T(r.$$.fragment,l),T(_.$$.fragment,l),T(h.$$.fragment,l),T(W.$$.fragment,l),T(A.$$.fragment,l),T(N.$$.fragment,l),T(z.$$.fragment,l),il=!0)},o(l){u(d.$$.fragment,l),u(r.$$.fragment,l),u(_.$$.fragment,l),u(h.$$.fragment,l),u(W.$$.fragment,l),u(A.$$.fragment,l),u(N.$$.fragment,l),u(z.$$.fragment,l),il=!1},d(l){l&&(t(V),t(Z),t(k),t(G),t(y),t(Y),t(j),t(Q),t(x),t(U),t(F),t(b),t($),t(I),t(g),t(S),t(f),t(q),t(C),t(L),t(P),t(B),t(K),t(D),t(X),t(O),t(ll),t(v),t(sl),t(tl),t(el),t(E),t(al),t(H)),t(c),w(d,l),w(r,l),w(_,l),w(h,l),w(W,l),w(A,l),w(N,l),w(z,l)}}}const Xl='{"title":"Custom metric","local":"custom-metric","sections":[{"title":"How to define a custom metric","local":"how-to-define-a-custom-metric","sections":[],"depth":3},{"title":"Example of a custom metric","local":"example-of-a-custom-metric","sections":[],"depth":3}],"depth":1}';function Al(Ml){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends fl{constructor(c){super(),Cl(this,c,Al,Wl,bl,{})}}export{Zl as component};
