import{s as bo,o as yo,n as te}from"../chunks/scheduler.9bc65507.js";import{S as wo,i as $o,g as d,s as a,r as f,A as xo,h as m,f as n,c as s,j as x,u as h,x as C,k,y as l,a as c,v as u,d as g,t as _,w as T}from"../chunks/index.707bf1b6.js";import{T as Ae}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.17db21ae.js";import{C as Ot}from"../chunks/CodeBlock.54a9f38d.js";import{E as At}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as R}from"../chunks/Heading.342b1fa6.js";function ko($){let t,M="This model is in maintenance mode only, so we won’t accept any new PRs changing its code.",i,p,v=`If you run into any issues running this model, please reinstall the last version that supported this model: v4.30.0.
You can do so by running the following command: <code>pip install -U transformers==4.30.0</code>.`;return{c(){t=d("p"),t.textContent=M,i=a(),p=d("p"),p.innerHTML=v},l(r){t=m(r,"P",{"data-svelte-h":!0}),C(t)!=="svelte-lwu440"&&(t.textContent=M),i=s(r),p=m(r,"P",{"data-svelte-h":!0}),C(p)!=="svelte-4042uy"&&(p.innerHTML=v)},m(r,b){c(r,t,b),c(r,i,b),c(r,p,b)},p:te,d(r){r&&(n(t),n(i),n(p))}}}function jo($){let t,M="Example:",i,p,v;return p=new Ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1DVENUQ29uZmlnJTJDJTIwTUNUQ1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNLUNUQy1UJTIwbWN0Y3QtbGFyZ2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTUNUQ1RDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwbWN0Y3QtbGFyZ2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1DVENUTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MCTCTConfig, MCTCTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a M-CTC-T mctct-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MCTCTConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the mctct-large style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MCTCTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,i=a(),f(p.$$.fragment)},l(r){t=m(r,"P",{"data-svelte-h":!0}),C(t)!=="svelte-11lpom8"&&(t.textContent=M),i=s(r),h(p.$$.fragment,r)},m(r,b){c(r,t,b),c(r,i,b),u(p,r,b),v=!0},p:te,i(r){v||(g(p.$$.fragment,r),v=!0)},o(r){_(p.$$.fragment,r),v=!1},d(r){r&&(n(t),n(i)),T(p,r)}}}function Jo($){let t,M=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.38.1/en/main_classes/image_processor#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){t=d("p"),t.innerHTML=M},l(i){t=m(i,"P",{"data-svelte-h":!0}),C(t)!=="svelte-6pw8it"&&(t.innerHTML=M)},m(i,p){c(i,t,p)},p:te,d(i){i&&n(t)}}}function Uo($){let t,M=`This class method is simply calling <a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.38.1/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){t=d("p"),t.innerHTML=M},l(i){t=m(i,"P",{"data-svelte-h":!0}),C(t)!=="svelte-47gn2i"&&(t.innerHTML=M)},m(i,p){c(i,t,p)},p:te,d(i){i&&n(t)}}}function Fo($){let t,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=M},l(i){t=m(i,"P",{"data-svelte-h":!0}),C(t)!=="svelte-fincs2"&&(t.innerHTML=M)},m(i,p){c(i,t,p)},p:te,d(i){i&&n(t)}}}function zo($){let t,M="Example:",i,p,v;return p=new Ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNQ1RDVE1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyc3BlZWNoYnJhaW4lMkZtLWN0Yy10LWxhcmdlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTUNUQ1RNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3BlZWNoYnJhaW4lMkZtLWN0Yy10LWxhcmdlJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBJTIzJTIwdHJhbnNjcmliZSUyMHNwZWVjaCUwQXRyYW5zY3JpcHRpb24lMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKHByZWRpY3RlZF9pZHMpJTBBdHJhbnNjcmlwdGlvbiU1QjAlNUQlMEElMEFpbnB1dHMlNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRGRhdGFzZXQlNUIwJTVEJTVCJTIydGV4dCUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLmlucHV0X2lkcyUwQSUwQSUyMyUyMGNvbXB1dGUlMjBsb3NzJTBBbG9zcyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb3Nz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MCTCTModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;speechbrain/m-ctc-t-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MCTCTModel.from_pretrained(<span class="hljs-string">&quot;speechbrain/m-ctc-t-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
[<span class="hljs-number">1</span>, <span class="hljs-number">195</span>, <span class="hljs-number">1536</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,i=a(),f(p.$$.fragment)},l(r){t=m(r,"P",{"data-svelte-h":!0}),C(t)!=="svelte-11lpom8"&&(t.textContent=M),i=s(r),h(p.$$.fragment,r)},m(r,b){c(r,t,b),c(r,i,b),u(p,r,b),v=!0},p:te,i(r){v||(g(p.$$.fragment,r),v=!0)},o(r){_(p.$$.fragment,r),v=!1},d(r){r&&(n(t),n(i)),T(p,r)}}}function No($){let t,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=M},l(i){t=m(i,"P",{"data-svelte-h":!0}),C(t)!=="svelte-fincs2"&&(t.innerHTML=M)},m(i,p){c(i,t,p)},p:te,d(i){i&&n(t)}}}function Io($){let t,M="Example:",i,p,v;return p=new Ot({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNQ1RDVEZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnNwZWVjaGJyYWluJTJGbS1jdGMtdC1sYXJnZSUyMiklMEFtb2RlbCUyMCUzRCUyME1DVENURm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJzcGVlY2hicmFpbiUyRm0tY3RjLXQtbGFyZ2UlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjMlMjB0cmFuc2NyaWJlJTIwc3BlZWNoJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyklMEF0cmFuc2NyaXB0aW9uJTVCMCU1RCUwQSUwQWlucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBJTBBJTIzJTIwY29tcHV0ZSUyMGxvc3MlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvc3MlMEFyb3VuZChsb3NzLml0ZW0oKSUyQyUyMDIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MCTCTForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;speechbrain/m-ctc-t-large&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MCTCTForCTC.from_pretrained(<span class="hljs-string">&quot;speechbrain/m-ctc-t-large&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transcribe speech</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Mr. Quilter is the apostle of the middle classes, and we&#x27;re glad to welcome his gospel.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;labels&quot;</span>] = processor(text=dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># compute loss</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs).loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">1885.65</span>`,wrap:!1}}),{c(){t=d("p"),t.textContent=M,i=a(),f(p.$$.fragment)},l(r){t=m(r,"P",{"data-svelte-h":!0}),C(t)!=="svelte-11lpom8"&&(t.textContent=M),i=s(r),h(p.$$.fragment,r)},m(r,b){c(r,t,b),c(r,i,b),u(p,r,b),v=!0},p:te,i(r){v||(g(p.$$.fragment,r),v=!0)},o(r){_(p.$$.fragment,r),v=!1},d(r){r&&(n(t),n(i)),T(p,r)}}}function Eo($){let t,M,i,p,v,r,b,Oe,oe,Ke,ne,Kt='The M-CTC-T model was proposed in <a href="https://arxiv.org/abs/2111.00161" rel="nofollow">Pseudo-Labeling For Massively Multilingual Speech Recognition</a> by Loren Lugosch, Tatiana Likhomanenko, Gabriel Synnaeve, and Ronan Collobert. The model is a 1B-param transformer encoder, with a CTC head over 8065 character labels and a language identification head over 60 language ID labels. It is trained on Common Voice (version 6.1, December 2020 release) and VoxPopuli. After training on Common Voice and VoxPopuli, the model is trained on Common Voice only. The labels are unnormalized character-level transcripts (punctuation and capitalization are not removed). The model takes as input Mel filterbank features from a 16Khz audio signal.',et,re,eo="The abstract from the paper is the following:",tt,ae,to=`<em>Semi-supervised learning through pseudo-labeling has become a staple of state-of-the-art monolingual
speech recognition systems. In this work, we extend pseudo-labeling to massively multilingual speech
recognition with 60 languages. We propose a simple pseudo-labeling recipe that works well even
with low-resource languages: train a supervised multilingual model, fine-tune it with semi-supervised
learning on a target language, generate pseudo-labels for that language, and train a final model using
pseudo-labels for all languages, either from scratch or by fine-tuning. Experiments on the labeled
Common Voice and unlabeled VoxPopuli datasets show that our recipe can yield a model with better
performance for many languages that also transfers well to LibriSpeech.</em>`,ot,se,oo='This model was contributed by <a href="https://huggingface.co/cwkeam" rel="nofollow">cwkeam</a>. The original code can be found <a href="https://github.com/flashlight/wav2letter/tree/main/recipes/mling_pl" rel="nofollow">here</a>.',nt,le,rt,ie,no="The PyTorch version of this model is only available in torch 1.9 and higher.",at,ce,st,de,ro='<li><a href="../tasks/asr">Automatic speech recognition task guide</a></li>',lt,me,it,j,pe,Mt,ze,ao=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a>. It is used to instantiate an
M-CTC-T model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the M-CTC-T
<a href="https://huggingface.co/speechbrain/m-ctc-t-large" rel="nofollow">speechbrain/m-ctc-t-large</a> architecture.`,vt,Ne,so=`Configuration objects inherit from <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.38.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,bt,L,ct,fe,dt,J,he,yt,Ie,lo="Constructs a M-CTC-T feature extractor.",wt,Ee,io=`This feature extractor inherits from <a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.SequenceFeatureExtractor">SequenceFeatureExtractor</a> which contains
most of the main methods. Users should refer to this superclass for more information regarding those methods. This
code has been adapted from Flashlight’s C++ code. For more information about the implementation, one can refer to
this <a href="https://colab.research.google.com/drive/1GLtINkkhzms-IsdcGy_-tVCkv0qNF-Gt#scrollTo=pMCRGMmUC_an" rel="nofollow">notebook</a>
that takes the user step-by-step in the implementation.`,$t,B,ue,xt,Ze,co=`Main method to featurize and prepare for the model one or several sequence(s). sequences. It returns the
log-mel spectrogram of the input audio, as implemented in the original Flashlight MFSC feature extraction code.`,mt,ge,pt,y,_e,kt,qe,mo="Constructs a MCTCT processor which wraps a MCTCT feature extractor and a MCTCT tokenizer into a single processor.",jt,Pe,po=`<a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTProcessor">MCTCTProcessor</a> offers all the functionalities of <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTFeatureExtractor">MCTCTFeatureExtractor</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the
<a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTProcessor.__call__"><strong>call</strong>()</a> and <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTProcessor.decode">decode()</a> for more information.`,Jt,V,Te,Ut,We,fo=`When used in normal mode, this method forwards all its arguments to MCTCTFeatureExtractor’s
<a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTFeatureExtractor.__call__"><strong>call</strong>()</a> and returns its output. If used in the context
<code>as_target_processor()</code> this method forwards all its arguments to AutoTokenizer’s
<code>__call__()</code>. Please refer to the doctsring of the above two methods for more information.`,Ft,q,Ce,zt,Ge,ho="Instantiate a processor associated with a pretrained model.",Nt,H,It,P,Me,Et,Re,uo=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTProcessor.from_pretrained">from_pretrained()</a> method.`,Zt,X,qt,Q,ve,Pt,Le,go=`This method forwards all its arguments to AutoTokenizer’s <a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.batch_decode">batch_decode()</a>. Please refer
to the docstring of this method for more information.`,Wt,S,be,Gt,Be,_o=`This method forwards all its arguments to AutoTokenizer’s <a href="/docs/transformers/v4.38.1/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,ft,ye,ht,N,we,Rt,Ve,To=`The bare M-CTC-T Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Lt,F,$e,Bt,He,Co='The <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a> forward method, overrides the <code>__call__</code> special method.',Vt,Y,Ht,D,ut,xe,gt,I,ke,Xt,Xe,Mo=`MCTCT Model with a <code>language modeling</code> head on top for Connectionist Temporal Classification (CTC).
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Qt,z,je,St,Qe,vo='The <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a> forward method, overrides the <code>__call__</code> special method.',Yt,A,Dt,O,_t,De,Tt;return v=new R({props:{title:"M-CTC-T",local:"m-ctc-t",headingTag:"h1"}}),b=new Ae({props:{warning:!0,$$slots:{default:[ko]},$$scope:{ctx:$}}}),oe=new R({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new R({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ce=new R({props:{title:"Resources",local:"resources",headingTag:"h2"}}),me=new R({props:{title:"MCTCTConfig",local:"transformers.MCTCTConfig",headingTag:"h2"}}),pe=new U({props:{name:"class transformers.MCTCTConfig",anchor:"transformers.MCTCTConfig",parameters:[{name:"vocab_size",val:" = 8065"},{name:"hidden_size",val:" = 1536"},{name:"num_hidden_layers",val:" = 36"},{name:"intermediate_size",val:" = 6144"},{name:"num_attention_heads",val:" = 4"},{name:"attention_head_dim",val:" = 384"},{name:"max_position_embeddings",val:" = 920"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"layerdrop",val:" = 0.3"},{name:"hidden_act",val:" = 'relu'"},{name:"initializer_range",val:" = 0.02"},{name:"hidden_dropout_prob",val:" = 0.3"},{name:"attention_probs_dropout_prob",val:" = 0.3"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 0"},{name:"eos_token_id",val:" = 2"},{name:"conv_glu_dim",val:" = 1"},{name:"conv_dropout",val:" = 0.3"},{name:"num_conv_layers",val:" = 1"},{name:"conv_kernel",val:" = (7,)"},{name:"conv_stride",val:" = (3,)"},{name:"input_feat_per_channel",val:" = 80"},{name:"input_channels",val:" = 1"},{name:"conv_channels",val:" = None"},{name:"ctc_loss_reduction",val:" = 'sum'"},{name:"ctc_zero_infinity",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MCTCTConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8065) &#x2014;
Vocabulary size of the M-CTC-T model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTModel">MCTCTModel</a>.`,name:"vocab_size"},{anchor:"transformers.MCTCTConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MCTCTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.MCTCTConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6144) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.MCTCTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.MCTCTConfig.attention_head_dim",description:`<strong>attention_head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Dimensions of each attention head for each attention layer in the Transformer encoder.`,name:"attention_head_dim"},{anchor:"transformers.MCTCTConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 920) &#x2014;
The maximum sequence length that this model might ever be used with (after log-mel spectrogram extraction).`,name:"max_position_embeddings"},{anchor:"transformers.MCTCTConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.MCTCTConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
The probability of dropping an encoder layer during training. The default 0.3 value is used in the original
implementation.`,name:"layerdrop"},{anchor:"transformers.MCTCTConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.MCTCTConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.MCTCTConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.MCTCTConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.MCTCTConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The tokenizer index of the pad token.`,name:"pad_token_id"},{anchor:"transformers.MCTCTConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The tokenizer index of the bos token.`,name:"bos_token_id"},{anchor:"transformers.MCTCTConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The tokenizer index of the eos token.`,name:"eos_token_id"},{anchor:"transformers.MCTCTConfig.conv_glu_dim",description:`<strong>conv_glu_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The dimension of the output of the <code>Conv1dSubsampler</code> layer in which GLU is applied on. Though the original
Flashlight code uses the value of 2, here it&#x2019;s adapted to 1 due to transposition differences.`,name:"conv_glu_dim"},{anchor:"transformers.MCTCTConfig.conv_dropout",description:`<strong>conv_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.3) &#x2014;
The probability of randomly dropping the <code>Conv1dSubsampler</code> layer during training.`,name:"conv_dropout"},{anchor:"transformers.MCTCTConfig.num_conv_layers",description:`<strong>num_conv_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolution layers before applying transformer encoder layers.`,name:"num_conv_layers"},{anchor:"transformers.MCTCTConfig.conv_kernel",description:`<strong>conv_kernel</strong> (<code>Sequence[int]</code>, <em>optional</em>, defaults to <code>(7,)</code>) &#x2014;
The kernel size of the 1D convolution applied before transformer layers. <code>len(conv_kernel)</code> must be equal
to <code>num_conv_layers</code>.`,name:"conv_kernel"},{anchor:"transformers.MCTCTConfig.conv_stride",description:`<strong>conv_stride</strong> (<code>Sequence[int]</code>, <em>optional</em>, defaults to <code>(3,)</code>) &#x2014;
The stride length of the 1D convolution applied before transformer layers. <code>len(conv_stride)</code> must be equal
to <code>num_conv_layers</code>.`,name:"conv_stride"},{anchor:"transformers.MCTCTConfig.input_feat_per_channel",description:`<strong>input_feat_per_channel</strong> (<code>int</code>, <em>optional</em>, defaults to 80) &#x2014;
Feature dimensions of the channels of the input to the Conv1D layer.`,name:"input_feat_per_channel"},{anchor:"transformers.MCTCTConfig.input_channels",description:`<strong>input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of input channels of the input to the Conv1D layer.`,name:"input_channels"},{anchor:"transformers.MCTCTConfig.conv_channels",description:`<strong>conv_channels</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Channel sizes of intermediate Conv1D layers.`,name:"conv_channels"},{anchor:"transformers.MCTCTConfig.ctc_loss_reduction",description:`<strong>ctc_loss_reduction</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sum&quot;</code>) &#x2014;
Specifies the reduction to apply to the output of <code>torch.nn.CTCLoss</code>. Only relevant when training an
instance of <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a>.`,name:"ctc_loss_reduction"},{anchor:"transformers.MCTCTConfig.ctc_zero_infinity",description:`<strong>ctc_zero_infinity</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to zero infinite losses and the associated gradients of <code>torch.nn.CTCLoss</code>. Infinite losses mainly
occur when the inputs are too short to be aligned to the targets. Only relevant when training an instance
of <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTForCTC">MCTCTForCTC</a>.`,name:"ctc_zero_infinity"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/configuration_mctct.py#L29"}}),L=new At({props:{anchor:"transformers.MCTCTConfig.example",$$slots:{default:[jo]},$$scope:{ctx:$}}}),fe=new R({props:{title:"MCTCTFeatureExtractor",local:"transformers.MCTCTFeatureExtractor",headingTag:"h2"}}),he=new U({props:{name:"class transformers.MCTCTFeatureExtractor",anchor:"transformers.MCTCTFeatureExtractor",parameters:[{name:"feature_size",val:" = 80"},{name:"sampling_rate",val:" = 16000"},{name:"padding_value",val:" = 0.0"},{name:"hop_length",val:" = 10"},{name:"win_length",val:" = 25"},{name:"win_function",val:" = 'hamming_window'"},{name:"frame_signal_scale",val:" = 32768.0"},{name:"preemphasis_coeff",val:" = 0.97"},{name:"mel_floor",val:" = 1.0"},{name:"normalize_means",val:" = True"},{name:"normalize_vars",val:" = True"},{name:"return_attention_mask",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MCTCTFeatureExtractor.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, defaults to 80) &#x2014;
The feature dimension of the extracted features. This is the number of mel_frequency`,name:"feature_size"},{anchor:"transformers.MCTCTFeatureExtractor.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, defaults to 16000) &#x2014;
The sampling rate at which the audio files should be digitalized expressed in hertz (Hz).`,name:"sampling_rate"},{anchor:"transformers.MCTCTFeatureExtractor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;
The value that is used to fill the padding values.`,name:"padding_value"},{anchor:"transformers.MCTCTFeatureExtractor.hop_length",description:`<strong>hop_length</strong> (<code>int</code>, defaults to 10) &#x2014;
Number of audio samples between windows. Otherwise referred to as &#x201C;shift&#x201D; in many papers.`,name:"hop_length"},{anchor:"transformers.MCTCTFeatureExtractor.win_length",description:`<strong>win_length</strong> (<code>int</code>, defaults to 25) &#x2014;
Number of ms per window`,name:"win_length"},{anchor:"transformers.MCTCTFeatureExtractor.win_function",description:`<strong>win_function</strong> (<code>str</code>, defaults to <code>&quot;hamming_window&quot;</code>) &#x2014;
Name for the window function used for windowing, must be accessible via <code>torch.{win_function}</code>`,name:"win_function"},{anchor:"transformers.MCTCTFeatureExtractor.frame_signal_scale",description:`<strong>frame_signal_scale</strong> (<code>float</code>, defaults to 32768.0) &#x2014;
Constant multiplied in creating the frames before applying DFT.`,name:"frame_signal_scale"},{anchor:"transformers.MCTCTFeatureExtractor.preemphasis_coeff",description:`<strong>preemphasis_coeff</strong> (<code>float</code>, defaults to 0.97) &#x2014;
Constant multiplied in applying Pre-emphasis before DFT.`,name:"preemphasis_coeff"},{anchor:"transformers.MCTCTFeatureExtractor.mel_floor",description:`<strong>mel_floor</strong> (<code>float</code> defaults to 1.0) &#x2014;
Minimum value of mel frequency banks.`,name:"mel_floor"},{anchor:"transformers.MCTCTFeatureExtractor.normalize_means",description:`<strong>normalize_means</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to zero-mean normalize the extracted features.`,name:"normalize_means"},{anchor:"transformers.MCTCTFeatureExtractor.normalize_vars",description:`<strong>normalize_vars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to unit-variance normalize the extracted features.`,name:"normalize_vars"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/feature_extraction_mctct.py#L33"}}),ue=new U({props:{name:"__call__",anchor:"transformers.MCTCTFeatureExtractor.__call__",parameters:[{name:"raw_speech",val:": Union"},{name:"padding",val:": Union = False"},{name:"max_length",val:": Optional = None"},{name:"truncation",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"sampling_rate",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MCTCTFeatureExtractor.__call__.raw_speech",description:`<strong>raw_speech</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, <code>List[float]</code>, <code>List[torch.Tensor]</code>, <code>List[np.ndarray]</code>, <code>List[List[float]]</code>) &#x2014;
The sequence or batch of sequences to be padded. Each sequence can be a tensor, a numpy array, a list
of float values, a list of tensors, a list of numpy arrays or a list of list of float values. Must be
mono channel audio, not stereo, i.e. single float per timestep.`,name:"raw_speech"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.38.1/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Select a strategy to pad the returned sequences (according to the model&#x2019;s padding side and padding
index) among:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum length of the returned list and optionally padding length (see above).`,name:"max_length"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>) &#x2014;
Activates truncation to cut input sequences longer than <em>max_length</em> to <em>max_length</em>.`,name:"truncation"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value.</p>
<p>This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta), or on TPUs which benefit from having sequence lengths be a multiple of 128.`,name:"pad_to_multiple_of"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific feature_extractor&#x2019;s default.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.38.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.sampling_rate",description:`<strong>sampling_rate</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The sampling rate at which the <code>raw_speech</code> input was sampled. It is strongly recommended to pass
<code>sampling_rate</code> at the forward call to prevent silent errors.`,name:"sampling_rate"},{anchor:"transformers.MCTCTFeatureExtractor.__call__.padding_value",description:"<strong>padding_value</strong> (<code>float</code>, defaults to 0.0) &#x2014;",name:"padding_value"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/feature_extraction_mctct.py#L161"}}),ge=new R({props:{title:"MCTCTProcessor",local:"transformers.MCTCTProcessor",headingTag:"h2"}}),_e=new U({props:{name:"class transformers.MCTCTProcessor",anchor:"transformers.MCTCTProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MCTCTProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>MCTCTFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTFeatureExtractor">MCTCTFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MCTCTProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/v4.38.1/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/processing_mctct.py#L24"}}),Te=new U({props:{name:"__call__",anchor:"transformers.MCTCTProcessor.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/processing_mctct.py#L46"}}),Ce=new U({props:{name:"from_pretrained",anchor:"transformers.MCTCTProcessor.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MCTCTProcessor.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.38.1/en/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/processing_utils.py#L406"}}),H=new Ae({props:{$$slots:{default:[Jo]},$$scope:{ctx:$}}}),Me=new U({props:{name:"save_pretrained",anchor:"transformers.MCTCTProcessor.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MCTCTProcessor.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.MCTCTProcessor.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.MCTCTProcessor.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/processing_utils.py#L167"}}),X=new Ae({props:{$$slots:{default:[Uo]},$$scope:{ctx:$}}}),ve=new U({props:{name:"batch_decode",anchor:"transformers.MCTCTProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/processing_mctct.py#L84"}}),be=new U({props:{name:"decode",anchor:"transformers.MCTCTProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/processing_mctct.py#L121"}}),ye=new R({props:{title:"MCTCTModel",local:"transformers.MCTCTModel",headingTag:"h2"}}),we=new U({props:{name:"class transformers.MCTCTModel",anchor:"transformers.MCTCTModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MCTCTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/modeling_mctct.py#L633"}}),$e=new U({props:{name:"forward",anchor:"transformers.MCTCTModel.forward",parameters:[{name:"input_features",val:": Tensor"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MCTCTModel.forward.input_features",description:`<strong>input_features</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_features"},{anchor:"transformers.MCTCTModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MCTCTModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MCTCTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MCTCTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MCTCTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/modeling_mctct.py#L647",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig"
>MCTCTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Y=new Ae({props:{$$slots:{default:[Fo]},$$scope:{ctx:$}}}),D=new At({props:{anchor:"transformers.MCTCTModel.forward.example",$$slots:{default:[zo]},$$scope:{ctx:$}}}),xe=new R({props:{title:"MCTCTForCTC",local:"transformers.MCTCTForCTC",headingTag:"h2"}}),ke=new U({props:{name:"class transformers.MCTCTForCTC",anchor:"transformers.MCTCTForCTC",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MCTCTForCTC.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig">MCTCTConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.38.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/modeling_mctct.py#L693"}}),je=new U({props:{name:"forward",anchor:"transformers.MCTCTForCTC.forward",parameters:[{name:"input_features",val:": Tensor"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"labels",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MCTCTForCTC.forward.input_features",description:`<strong>input_features</strong> (<code>torch.LongTensor</code> of shape <code>({0})</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.38.1/en/model_doc/wav2vec2#transformers.Wav2Vec2CTCTokenizer">Wav2Vec2CTCTokenizer</a>. See <a href="/docs/transformers/v4.38.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.38.1/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_features"},{anchor:"transformers.MCTCTForCTC.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>({0})</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MCTCTForCTC.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MCTCTForCTC.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MCTCTForCTC.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MCTCTForCTC.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MCTCTForCTC.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_length)</code>, <em>optional</em>) &#x2014;
Labels for connectionist temporal classification. Note that <code>target_length</code> has to be smaller or equal to
the sequence length of the output logits. Indices are selected in <code>[-100, 0, ..., config.vocab_size - 1]</code>.
All labels set to <code>-100</code> are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.38.1/src/transformers/models/deprecated/mctct/modeling_mctct.py#L717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.38.1/en/model_doc/mctct#transformers.MCTCTConfig"
>MCTCTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.38.1/en/main_classes/output#transformers.modeling_outputs.CausalLMOutput"
>transformers.modeling_outputs.CausalLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Ae({props:{$$slots:{default:[No]},$$scope:{ctx:$}}}),O=new At({props:{anchor:"transformers.MCTCTForCTC.forward.example",$$slots:{default:[Io]},$$scope:{ctx:$}}}),{c(){t=d("meta"),M=a(),i=d("p"),p=a(),f(v.$$.fragment),r=a(),f(b.$$.fragment),Oe=a(),f(oe.$$.fragment),Ke=a(),ne=d("p"),ne.innerHTML=Kt,et=a(),re=d("p"),re.textContent=eo,tt=a(),ae=d("p"),ae.innerHTML=to,ot=a(),se=d("p"),se.innerHTML=oo,nt=a(),f(le.$$.fragment),rt=a(),ie=d("p"),ie.textContent=no,at=a(),f(ce.$$.fragment),st=a(),de=d("ul"),de.innerHTML=ro,lt=a(),f(me.$$.fragment),it=a(),j=d("div"),f(pe.$$.fragment),Mt=a(),ze=d("p"),ze.innerHTML=ao,vt=a(),Ne=d("p"),Ne.innerHTML=so,bt=a(),f(L.$$.fragment),ct=a(),f(fe.$$.fragment),dt=a(),J=d("div"),f(he.$$.fragment),yt=a(),Ie=d("p"),Ie.textContent=lo,wt=a(),Ee=d("p"),Ee.innerHTML=io,$t=a(),B=d("div"),f(ue.$$.fragment),xt=a(),Ze=d("p"),Ze.textContent=co,mt=a(),f(ge.$$.fragment),pt=a(),y=d("div"),f(_e.$$.fragment),kt=a(),qe=d("p"),qe.textContent=mo,jt=a(),Pe=d("p"),Pe.innerHTML=po,Jt=a(),V=d("div"),f(Te.$$.fragment),Ut=a(),We=d("p"),We.innerHTML=fo,Ft=a(),q=d("div"),f(Ce.$$.fragment),zt=a(),Ge=d("p"),Ge.textContent=ho,Nt=a(),f(H.$$.fragment),It=a(),P=d("div"),f(Me.$$.fragment),Et=a(),Re=d("p"),Re.innerHTML=uo,Zt=a(),f(X.$$.fragment),qt=a(),Q=d("div"),f(ve.$$.fragment),Pt=a(),Le=d("p"),Le.innerHTML=go,Wt=a(),S=d("div"),f(be.$$.fragment),Gt=a(),Be=d("p"),Be.innerHTML=_o,ft=a(),f(ye.$$.fragment),ht=a(),N=d("div"),f(we.$$.fragment),Rt=a(),Ve=d("p"),Ve.innerHTML=To,Lt=a(),F=d("div"),f($e.$$.fragment),Bt=a(),He=d("p"),He.innerHTML=Co,Vt=a(),f(Y.$$.fragment),Ht=a(),f(D.$$.fragment),ut=a(),f(xe.$$.fragment),gt=a(),I=d("div"),f(ke.$$.fragment),Xt=a(),Xe=d("p"),Xe.innerHTML=Mo,Qt=a(),z=d("div"),f(je.$$.fragment),St=a(),Qe=d("p"),Qe.innerHTML=vo,Yt=a(),f(A.$$.fragment),Dt=a(),f(O.$$.fragment),_t=a(),De=d("p"),this.h()},l(e){const o=xo("svelte-u9bgzb",document.head);t=m(o,"META",{name:!0,content:!0}),o.forEach(n),M=s(e),i=m(e,"P",{}),x(i).forEach(n),p=s(e),h(v.$$.fragment,e),r=s(e),h(b.$$.fragment,e),Oe=s(e),h(oe.$$.fragment,e),Ke=s(e),ne=m(e,"P",{"data-svelte-h":!0}),C(ne)!=="svelte-sgpevv"&&(ne.innerHTML=Kt),et=s(e),re=m(e,"P",{"data-svelte-h":!0}),C(re)!=="svelte-vfdo9a"&&(re.textContent=eo),tt=s(e),ae=m(e,"P",{"data-svelte-h":!0}),C(ae)!=="svelte-35ulb8"&&(ae.innerHTML=to),ot=s(e),se=m(e,"P",{"data-svelte-h":!0}),C(se)!=="svelte-12s67rv"&&(se.innerHTML=oo),nt=s(e),h(le.$$.fragment,e),rt=s(e),ie=m(e,"P",{"data-svelte-h":!0}),C(ie)!=="svelte-eygw0k"&&(ie.textContent=no),at=s(e),h(ce.$$.fragment,e),st=s(e),de=m(e,"UL",{"data-svelte-h":!0}),C(de)!=="svelte-c521vh"&&(de.innerHTML=ro),lt=s(e),h(me.$$.fragment,e),it=s(e),j=m(e,"DIV",{class:!0});var E=x(j);h(pe.$$.fragment,E),Mt=s(E),ze=m(E,"P",{"data-svelte-h":!0}),C(ze)!=="svelte-7l0s8l"&&(ze.innerHTML=ao),vt=s(E),Ne=m(E,"P",{"data-svelte-h":!0}),C(Ne)!=="svelte-1m96fjf"&&(Ne.innerHTML=so),bt=s(E),h(L.$$.fragment,E),E.forEach(n),ct=s(e),h(fe.$$.fragment,e),dt=s(e),J=m(e,"DIV",{class:!0});var Z=x(J);h(he.$$.fragment,Z),yt=s(Z),Ie=m(Z,"P",{"data-svelte-h":!0}),C(Ie)!=="svelte-u8ff7m"&&(Ie.textContent=lo),wt=s(Z),Ee=m(Z,"P",{"data-svelte-h":!0}),C(Ee)!=="svelte-1ygleat"&&(Ee.innerHTML=io),$t=s(Z),B=m(Z,"DIV",{class:!0});var Je=x(B);h(ue.$$.fragment,Je),xt=s(Je),Ze=m(Je,"P",{"data-svelte-h":!0}),C(Ze)!=="svelte-18g1o8a"&&(Ze.textContent=co),Je.forEach(n),Z.forEach(n),mt=s(e),h(ge.$$.fragment,e),pt=s(e),y=m(e,"DIV",{class:!0});var w=x(y);h(_e.$$.fragment,w),kt=s(w),qe=m(w,"P",{"data-svelte-h":!0}),C(qe)!=="svelte-g05zhb"&&(qe.textContent=mo),jt=s(w),Pe=m(w,"P",{"data-svelte-h":!0}),C(Pe)!=="svelte-1p6oe37"&&(Pe.innerHTML=po),Jt=s(w),V=m(w,"DIV",{class:!0});var Ue=x(V);h(Te.$$.fragment,Ue),Ut=s(Ue),We=m(Ue,"P",{"data-svelte-h":!0}),C(We)!=="svelte-1s59p7w"&&(We.innerHTML=fo),Ue.forEach(n),Ft=s(w),q=m(w,"DIV",{class:!0});var W=x(q);h(Ce.$$.fragment,W),zt=s(W),Ge=m(W,"P",{"data-svelte-h":!0}),C(Ge)!=="svelte-1cj8dcb"&&(Ge.textContent=ho),Nt=s(W),h(H.$$.fragment,W),W.forEach(n),It=s(w),P=m(w,"DIV",{class:!0});var G=x(P);h(Me.$$.fragment,G),Et=s(G),Re=m(G,"P",{"data-svelte-h":!0}),C(Re)!=="svelte-944n1s"&&(Re.innerHTML=uo),Zt=s(G),h(X.$$.fragment,G),G.forEach(n),qt=s(w),Q=m(w,"DIV",{class:!0});var Fe=x(Q);h(ve.$$.fragment,Fe),Pt=s(Fe),Le=m(Fe,"P",{"data-svelte-h":!0}),C(Le)!=="svelte-ewpmb3"&&(Le.innerHTML=go),Fe.forEach(n),Wt=s(w),S=m(w,"DIV",{class:!0});var Ct=x(S);h(be.$$.fragment,Ct),Gt=s(Ct),Be=m(Ct,"P",{"data-svelte-h":!0}),C(Be)!=="svelte-bp6ecs"&&(Be.innerHTML=_o),Ct.forEach(n),w.forEach(n),ft=s(e),h(ye.$$.fragment,e),ht=s(e),N=m(e,"DIV",{class:!0});var Se=x(N);h(we.$$.fragment,Se),Rt=s(Se),Ve=m(Se,"P",{"data-svelte-h":!0}),C(Ve)!=="svelte-6c6j4z"&&(Ve.innerHTML=To),Lt=s(Se),F=m(Se,"DIV",{class:!0});var K=x(F);h($e.$$.fragment,K),Bt=s(K),He=m(K,"P",{"data-svelte-h":!0}),C(He)!=="svelte-1p7tetb"&&(He.innerHTML=Co),Vt=s(K),h(Y.$$.fragment,K),Ht=s(K),h(D.$$.fragment,K),K.forEach(n),Se.forEach(n),ut=s(e),h(xe.$$.fragment,e),gt=s(e),I=m(e,"DIV",{class:!0});var Ye=x(I);h(ke.$$.fragment,Ye),Xt=s(Ye),Xe=m(Ye,"P",{"data-svelte-h":!0}),C(Xe)!=="svelte-14zwgek"&&(Xe.innerHTML=Mo),Qt=s(Ye),z=m(Ye,"DIV",{class:!0});var ee=x(z);h(je.$$.fragment,ee),St=s(ee),Qe=m(ee,"P",{"data-svelte-h":!0}),C(Qe)!=="svelte-veverz"&&(Qe.innerHTML=vo),Yt=s(ee),h(A.$$.fragment,ee),Dt=s(ee),h(O.$$.fragment,ee),ee.forEach(n),Ye.forEach(n),_t=s(e),De=m(e,"P",{}),x(De).forEach(n),this.h()},h(){k(t,"name","hf:doc:metadata"),k(t,"content",Zo),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,t),c(e,M,o),c(e,i,o),c(e,p,o),u(v,e,o),c(e,r,o),u(b,e,o),c(e,Oe,o),u(oe,e,o),c(e,Ke,o),c(e,ne,o),c(e,et,o),c(e,re,o),c(e,tt,o),c(e,ae,o),c(e,ot,o),c(e,se,o),c(e,nt,o),u(le,e,o),c(e,rt,o),c(e,ie,o),c(e,at,o),u(ce,e,o),c(e,st,o),c(e,de,o),c(e,lt,o),u(me,e,o),c(e,it,o),c(e,j,o),u(pe,j,null),l(j,Mt),l(j,ze),l(j,vt),l(j,Ne),l(j,bt),u(L,j,null),c(e,ct,o),u(fe,e,o),c(e,dt,o),c(e,J,o),u(he,J,null),l(J,yt),l(J,Ie),l(J,wt),l(J,Ee),l(J,$t),l(J,B),u(ue,B,null),l(B,xt),l(B,Ze),c(e,mt,o),u(ge,e,o),c(e,pt,o),c(e,y,o),u(_e,y,null),l(y,kt),l(y,qe),l(y,jt),l(y,Pe),l(y,Jt),l(y,V),u(Te,V,null),l(V,Ut),l(V,We),l(y,Ft),l(y,q),u(Ce,q,null),l(q,zt),l(q,Ge),l(q,Nt),u(H,q,null),l(y,It),l(y,P),u(Me,P,null),l(P,Et),l(P,Re),l(P,Zt),u(X,P,null),l(y,qt),l(y,Q),u(ve,Q,null),l(Q,Pt),l(Q,Le),l(y,Wt),l(y,S),u(be,S,null),l(S,Gt),l(S,Be),c(e,ft,o),u(ye,e,o),c(e,ht,o),c(e,N,o),u(we,N,null),l(N,Rt),l(N,Ve),l(N,Lt),l(N,F),u($e,F,null),l(F,Bt),l(F,He),l(F,Vt),u(Y,F,null),l(F,Ht),u(D,F,null),c(e,ut,o),u(xe,e,o),c(e,gt,o),c(e,I,o),u(ke,I,null),l(I,Xt),l(I,Xe),l(I,Qt),l(I,z),u(je,z,null),l(z,St),l(z,Qe),l(z,Yt),u(A,z,null),l(z,Dt),u(O,z,null),c(e,_t,o),c(e,De,o),Tt=!0},p(e,[o]){const E={};o&2&&(E.$$scope={dirty:o,ctx:e}),b.$set(E);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),L.$set(Z);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),H.$set(Je);const w={};o&2&&(w.$$scope={dirty:o,ctx:e}),X.$set(w);const Ue={};o&2&&(Ue.$$scope={dirty:o,ctx:e}),Y.$set(Ue);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),D.$set(W);const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),A.$set(G);const Fe={};o&2&&(Fe.$$scope={dirty:o,ctx:e}),O.$set(Fe)},i(e){Tt||(g(v.$$.fragment,e),g(b.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(me.$$.fragment,e),g(pe.$$.fragment,e),g(L.$$.fragment,e),g(fe.$$.fragment,e),g(he.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(H.$$.fragment,e),g(Me.$$.fragment,e),g(X.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(Y.$$.fragment,e),g(D.$$.fragment,e),g(xe.$$.fragment,e),g(ke.$$.fragment,e),g(je.$$.fragment,e),g(A.$$.fragment,e),g(O.$$.fragment,e),Tt=!0)},o(e){_(v.$$.fragment,e),_(b.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(L.$$.fragment,e),_(fe.$$.fragment,e),_(he.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(Te.$$.fragment,e),_(Ce.$$.fragment,e),_(H.$$.fragment,e),_(Me.$$.fragment,e),_(X.$$.fragment,e),_(ve.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(xe.$$.fragment,e),_(ke.$$.fragment,e),_(je.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),Tt=!1},d(e){e&&(n(M),n(i),n(p),n(r),n(Oe),n(Ke),n(ne),n(et),n(re),n(tt),n(ae),n(ot),n(se),n(nt),n(rt),n(ie),n(at),n(st),n(de),n(lt),n(it),n(j),n(ct),n(dt),n(J),n(mt),n(pt),n(y),n(ft),n(ht),n(N),n(ut),n(gt),n(I),n(_t),n(De)),n(t),T(v,e),T(b,e),T(oe,e),T(le,e),T(ce,e),T(me,e),T(pe),T(L),T(fe,e),T(he),T(ue),T(ge,e),T(_e),T(Te),T(Ce),T(H),T(Me),T(X),T(ve),T(be),T(ye,e),T(we),T($e),T(Y),T(D),T(xe,e),T(ke),T(je),T(A),T(O)}}}const Zo='{"title":"M-CTC-T","local":"m-ctc-t","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MCTCTConfig","local":"transformers.MCTCTConfig","sections":[],"depth":2},{"title":"MCTCTFeatureExtractor","local":"transformers.MCTCTFeatureExtractor","sections":[],"depth":2},{"title":"MCTCTProcessor","local":"transformers.MCTCTProcessor","sections":[],"depth":2},{"title":"MCTCTModel","local":"transformers.MCTCTModel","sections":[],"depth":2},{"title":"MCTCTForCTC","local":"transformers.MCTCTForCTC","sections":[],"depth":2}],"depth":1}';function qo($){return yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ho extends wo{constructor(t){super(),$o(this,t,qo,Eo,bo,{})}}export{Ho as component};
