import{s as Pi,o as Ki,n as G}from"../chunks/scheduler.37c15a92.js";import{S as Oi,i as er,g as i,s as l,r as p,A as tr,h as r,f as s,c as n,j as Li,u as d,x as o,k as fs,y as sr,a,v as c,d as h,t as u,w as M}from"../chunks/index.2bf4358c.js";import{T as v}from"../chunks/Tip.363c041f.js";import{Y as Jn}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as ar}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as Js}from"../chunks/Heading.8ada512a.js";function lr(T){let m,J="✏️ <strong>Try it out!</strong> Use the <code>Dataset.unique()</code> function to find the number of unique drugs and conditions in the training and test sets.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1c0v7hx"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function nr(T){let m,J="🙋 An alternative way to add new columns to a dataset is with the <code>Dataset.add_column()</code> function. This allows you to provide the column as a Python list or NumPy array and can be handy in situations where <code>Dataset.map()</code> is not well suited for your analysis.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-91he7h"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function ir(T){let m,J='✏️ <strong>Try it out!</strong> Use the <code>Dataset.sort()</code> function to inspect the reviews with the largest numbers of words. See the <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.sort" rel="nofollow">documentation</a> to see which argument you need to use sort the reviews by length in descending order.';return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-yu69sa"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function rr(T){let m,J="✏️ <strong>Try it out!</strong> Execute the same instruction with and without <code>batched=True</code>, then try it with a slow tokenizer (add <code>use_fast=False</code> in the <code>AutoTokenizer.from_pretrained()</code> method) so you can see what numbers you get on your hardware.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1wwgcqi"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function or(T){let m,J="Using <code>num_proc</code> to speed up your processing is usually a great idea, as long as the function you are using is not already doing some kind of multiprocessing of its own.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1i8a9in"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function pr(T){let m,J="💡 In machine learning, an <em>example</em> is usually defined as the set of <em>features</em> that we feed to the model. In some contexts, these features will be the set of columns in a <code>Dataset</code>, but in others (like here and for question answering), multiple features can be extracted from a single example and belong to a single column.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-14s5jwu"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function dr(T){let m,J="🚨 Under the hood, <code>Dataset.set_format()</code> changes the return format for the dataset’s <code>__getitem__()</code> dunder method. This means that when we want to create a new object like <code>train_df</code> from a <code>Dataset</code> in the <code>&quot;pandas&quot;</code> format, we need to slice the whole dataset to obtain a <code>pandas.DataFrame</code>. You can verify for yourself that the type of <code>drug_dataset[&quot;train&quot;]</code> is <code>Dataset</code>, irrespective of the output format.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-1myl3pp"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function cr(T){let m,J="✏️ <strong>Try it out!</strong> Compute the average rating per drug and store the result in a new <code>Dataset</code>.";return{c(){m=i("p"),m.innerHTML=J},l(w){m=r(w,"P",{"data-svelte-h":!0}),o(m)!=="svelte-f4oima"&&(m.innerHTML=J)},m(w,f){a(w,m,f)},p:G,d(w){w&&s(m)}}}function hr(T){let m,J,w,f,V,Us,_,js,X,fn="Most of the time, the data you work with won’t be perfectly prepared for training models. In this section we’ll explore the various features that 🤗 Datasets provides to clean up your datasets.",bs,W,gs,B,$s,Q,Tn='Similar to Pandas, 🤗 Datasets provides several functions to manipulate the contents of <code>Dataset</code> and <code>DatasetDict</code> objects. We already encountered the <code>Dataset.map()</code> method in <a href="/course/chapter3">Chapter 3</a>, and in this section we’ll explore some of the other functions at our disposal.',Cs,R,Un='For this example we’ll use the <a href="https://archive.ics.uci.edu/ml/datasets/Drug+Review+Dataset+%28Drugs.com%29" rel="nofollow">Drug Review Dataset</a> that’s hosted on the <a href="https://archive.ics.uci.edu/ml/index.php" rel="nofollow">UC Irvine Machine Learning Repository</a>, which contains patient reviews on various drugs, along with the condition being treated and a 10-star rating of the patient’s satisfaction.',Is,N,jn="First we need to download and extract the data, which can be done with the <code>wget</code> and <code>unzip</code> commands:",xs,H,Zs,z,bn="Since TSV is just a variant of CSV that uses tabs instead of commas as the separator, we can load these files by using the <code>csv</code> loading script and specifying the <code>delimiter</code> argument in the <code>load_dataset()</code> function as follows:",ks,Y,vs,F,gn="A good practice when doing any sort of data analysis is to grab a small random sample to get a quick feel for the type of data you’re working with. In 🤗 Datasets, we can create a random sample by chaining the <code>Dataset.shuffle()</code> and <code>Dataset.select()</code> functions together:",Gs,A,Vs,D,_s,E,$n="Note that we’ve fixed the seed in <code>Dataset.shuffle()</code> for reproducibility purposes. <code>Dataset.select()</code> expects an iterable of indices, so we’ve passed <code>range(1000)</code> to grab the first 1,000 examples from the shuffled dataset. From this sample we can already see a few quirks in our dataset:",Xs,S,Cn="<li>The <code>Unnamed: 0</code> column looks suspiciously like an anonymized ID for each patient.</li> <li>The <code>condition</code> column includes a mix of uppercase and lowercase labels.</li> <li>The reviews are of varying length and contain a mix of Python line separators (<code>\\r\\n</code>) as well as HTML character codes like <code>&amp;\\#039;</code>.</li>",Ws,q,In="Let’s see how we can use 🤗 Datasets to deal with each of these issues. To test the patient ID hypothesis for the <code>Unnamed: 0</code> column, we can use the <code>Dataset.unique()</code> function to verify that the number of IDs matches the number of rows in each split:",Bs,L,Qs,P,xn="This seems to confirm our hypothesis, so let’s clean up the dataset a bit by renaming the <code>Unnamed: 0</code> column to something a bit more interpretable. We can use the <code>DatasetDict.rename_column()</code> function to rename the column across both splits in one go:",Rs,K,Ns,O,Hs,b,zs,ee,Zn='Next, let’s normalize all the <code>condition</code> labels using <code>Dataset.map()</code>. As we did with tokenization in <a href="/course/chapter3">Chapter 3</a>, we can define a simple function that can be applied across all the rows of each split in <code>drug_dataset</code>:',Ys,te,Fs,se,As,ae,kn="Oh no, we’ve run into a problem with our map function! From the error we can infer that some of the entries in the <code>condition</code> column are <code>None</code>, which cannot be lowercased as they’re not strings. Let’s drop these rows using <code>Dataset.filter()</code>, which works in a similar way to <code>Dataset.map()</code> and expects a function that receives a single example of the dataset. Instead of writing an explicit function like:",Ds,le,Es,ne,vn="and then running <code>drug_dataset.filter(filter_nones)</code>, we can do this in one line using a <em>lambda function</em>. In Python, lambda functions are small functions that you can define without explicitly naming them. They take the general form:",Ss,ie,qs,re,Gn='where <code>lambda</code> is one of Python’s special <a href="https://docs.python.org/3/reference/lexical_analysis.html#keywords" rel="nofollow">keywords</a>, <code>&lt;arguments&gt;</code> is a list/set of comma-separated values that define the inputs to the function, and <code>&lt;expression&gt;</code> represents the operations you wish to execute. For example, we can define a simple lambda function that squares a number as follows:',Ls,oe,Ps,pe,Vn="To apply this function to an input, we need to wrap it and the input in parentheses:",Ks,de,Os,ce,ea,he,_n="Similarly, we can define lambda functions with multiple arguments by separating them with commas. For example, we can compute the area of a triangle as follows:",ta,ue,sa,Me,aa,me,Xn='Lambda functions are handy when you want to define small, single-use functions (for more information about them, we recommend reading the excellent <a href="https://realpython.com/python-lambda/" rel="nofollow">Real Python tutorial</a> by Andre Burgaud). In the 🤗 Datasets context, we can use lambda functions to define simple map and filter operations, so let’s use this trick to eliminate the <code>None</code> entries in our dataset:',la,ye,na,we,Wn="With the <code>None</code> entries removed, we can normalize our <code>condition</code> column:",ia,Je,ra,fe,oa,Te,Bn="It works! Now that we’ve cleaned up the labels, let’s take a look at cleaning up the reviews themselves.",pa,Ue,da,je,Qn="Whenever you’re dealing with customer reviews, a good practice is to check the number of words in each review. A review might be just a single word like “Great!” or a full-blown essay with thousands of words, and depending on the use case you’ll need to handle these extremes differently. To compute the number of words in each review, we’ll use a rough heuristic based on splitting each text by whitespace.",ca,be,Rn="Let’s define a simple function that counts the number of words in each review:",ha,ge,ua,$e,Nn="Unlike our <code>lowercase_condition()</code> function, <code>compute_review_length()</code> returns a dictionary whose key does not correspond to one of the column names in the dataset. In this case, when <code>compute_review_length()</code> is passed to <code>Dataset.map()</code>, it will be applied to all the rows in the dataset to create a new <code>review_length</code> column:",Ma,Ce,ma,Ie,ya,xe,Hn="As expected, we can see a <code>review_length</code> column has been added to our training set. We can sort this new column with <code>Dataset.sort()</code> to see what the extreme values look like:",wa,Ze,Ja,ke,fa,ve,zn="As we suspected, some reviews contain just a single word, which, although it may be okay for sentiment analysis, would not be informative if we want to predict the condition.",Ta,g,Ua,Ge,Yn="Let’s use the <code>Dataset.filter()</code> function to remove reviews that contain fewer than 30 words. Similarly to what we did with the <code>condition</code> column, we can filter out the very short reviews by requiring that the reviews have a length above this threshold:",ja,Ve,ba,_e,ga,Xe,Fn="As you can see, this has removed around 15% of the reviews from our original training and test sets.",$a,$,Ca,We,An="The last thing we need to deal with is the presence of HTML character codes in our reviews. We can use Python’s <code>html</code> module to unescape these characters, like so:",Ia,Be,xa,Qe,Za,Re,Dn="We’ll use <code>Dataset.map()</code> to unescape all the HTML characters in our corpus:",ka,Ne,va,He,En="As you can see, the <code>Dataset.map()</code> method is quite useful for processing data — and we haven’t even scratched the surface of everything it can do!",Ga,ze,Va,Ye,Sn="The <code>Dataset.map()</code> method takes a <code>batched</code> argument that, if set to <code>True</code>, causes it to send a batch of examples to the map function at once (the batch size is configurable but defaults to 1,000). For instance, the previous map function that unescaped all the HTML took a bit of time to run (you can read the time taken from the progress bars). We can speed this up by processing several elements at the same time using a list comprehension.",_a,Fe,qn="When you specify <code>batched=True</code> the function receives a dictionary with the fields of the dataset, but each value is now a <em>list of values</em>, and not just a single value. The return value of <code>Dataset.map()</code> should be the same: a dictionary with the fields we want to update or add to our dataset, and a list of values. For example, here is another way to unescape all HTML characters, but using <code>batched=True</code>:",Xa,Ae,Wa,De,Ln="If you’re running this code in a notebook, you’ll see that this command executes way faster than the previous one. And it’s not because our reviews have already been HTML-unescaped — if you re-execute the instruction from the previous section (without <code>batched=True</code>), it will take the same amount of time as before. This is because list comprehensions are usually faster than executing the same code in a <code>for</code> loop, and we also gain some performance by accessing lots of elements at the same time instead of one by one.",Ba,Ee,Pn='Using <code>Dataset.map()</code> with <code>batched=True</code> will be essential to unlock the speed of the “fast” tokenizers that we’ll encounter in <a href="/course/chapter6">Chapter 6</a>, which can quickly tokenize big lists of texts. For instance, to tokenize all the drug reviews with a fast tokenizer, we could use a function like this:',Qa,Se,Ra,qe,Kn='As you saw in <a href="/course/chapter3">Chapter 3</a>, we can pass one or several examples to the tokenizer, so we can use this function with or without <code>batched=True</code>. Let’s take this opportunity to compare the performance of the different options. In a notebook, you can time a one-line instruction by adding <code>%time</code> before the line of code you wish to measure:',Na,Le,Ha,Pe,On="You can also time a whole cell by putting <code>%%time</code> at the beginning of the cell. On the hardware we executed this on, it showed 10.8s for this instruction (it’s the number written after “Wall time”).",za,C,Ya,Ke,ei="Here are the results we obtained with and without batching, with a fast and a slow tokenizer:",Fa,Oe,ti='<thead><tr><th align="center">Options</th> <th align="center">Fast tokenizer</th> <th align="center">Slow tokenizer</th></tr></thead> <tbody><tr><td align="center"><code>batched=True</code></td> <td align="center">10.8s</td> <td align="center">4min41s</td></tr> <tr><td align="center"><code>batched=False</code></td> <td align="center">59.2s</td> <td align="center">5min3s</td></tr></tbody>',Aa,et,si="This means that using a fast tokenizer with the <code>batched=True</code> option is 30 times faster than its slow counterpart with no batching — this is truly amazing! That’s the main reason why fast tokenizers are the default when using <code>AutoTokenizer</code> (and why they are called “fast”). They’re able to achieve such a speedup because behind the scenes the tokenization code is executed in Rust, which is a language that makes it easy to parallelize code execution.",Da,tt,ai="Parallelization is also the reason for the nearly 6x speedup the fast tokenizer achieves with batching: you can’t parallelize a single tokenization operation, but when you want to tokenize lots of texts at the same time you can just split the execution across several processes, each responsible for its own texts.",Ea,st,li="<code>Dataset.map()</code> also has some parallelization capabilities of its own. Since they are not backed by Rust, they won’t let a slow tokenizer catch up with a fast one, but they can still be helpful (especially if you’re using a tokenizer that doesn’t have a fast version). To enable multiprocessing, use the <code>num_proc</code> argument and specify the number of processes to use in your call to <code>Dataset.map()</code>:",Sa,at,qa,lt,ni="You can experiment a little with timing to determine the optimal number of processes to use; in our case 8 seemed to produce the best speed gain. Here are the numbers we got with and without multiprocessing:",La,nt,ii='<thead><tr><th align="center">Options</th> <th align="center">Fast tokenizer</th> <th align="center">Slow tokenizer</th></tr></thead> <tbody><tr><td align="center"><code>batched=True</code></td> <td align="center">10.8s</td> <td align="center">4min41s</td></tr> <tr><td align="center"><code>batched=False</code></td> <td align="center">59.2s</td> <td align="center">5min3s</td></tr> <tr><td align="center"><code>batched=True</code>, <code>num_proc=8</code></td> <td align="center">6.52s</td> <td align="center">41.3s</td></tr> <tr><td align="center"><code>batched=False</code>, <code>num_proc=8</code></td> <td align="center">9.49s</td> <td align="center">45.2s</td></tr></tbody>',Pa,it,ri="Those are much more reasonable results for the slow tokenizer, but the performance of the fast tokenizer was also substantially improved. Note, however, that won’t always be the case — for values of <code>num_proc</code> other than 8, our tests showed that it was faster to use <code>batched=True</code> without that option. In general, we don’t recommend using Python multiprocessing for fast tokenizers with <code>batched=True</code>.",Ka,I,Oa,rt,oi='All of this functionality condensed into a single method is already pretty amazing, but there’s more! With <code>Dataset.map()</code> and <code>batched=True</code> you can change the number of elements in your dataset. This is super useful in many situations where you want to create several training features from one example, and we will need to do this as part of the preprocessing for several of the NLP tasks we’ll undertake in <a href="/course/chapter7">Chapter 7</a>.',el,x,tl,ot,pi="Let’s have a look at how it works! Here we will tokenize our examples and truncate them to a maximum length of 128, but we will ask the tokenizer to return <em>all</em> the chunks of the texts instead of just the first one. This can be done with <code>return_overflowing_tokens=True</code>:",sl,pt,al,dt,di="Let’s test this on one example before using <code>Dataset.map()</code> on the whole dataset:",ll,ct,nl,ht,il,ut,ci="So, our first example in the training set became two features because it was tokenized to more than the maximum number of tokens we specified: the first one of length 128 and the second one of length 49. Now let’s do this for all elements of the dataset!",rl,Mt,ol,mt,pl,yt,hi='Oh no! That didn’t work! Why not? Looking at the error message will give us a clue: there is a mismatch in the lengths of one of the columns, one being of length 1,463 and the other of length 1,000. If you’ve looked at the <code>Dataset.map()</code> <a href="https://huggingface.co/docs/datasets/package_reference/main_classes.html#datasets.Dataset.map" rel="nofollow">documentation</a>, you may recall that it’s the number of samples passed to the function that we are mapping; here those 1,000 examples gave 1,463 new features, resulting in a shape error.',dl,wt,ui="The problem is that we’re trying to mix two different datasets of different sizes: the <code>drug_dataset</code> columns will have a certain number of examples (the 1,000 in our error), but the <code>tokenized_dataset</code> we are building will have more (the 1,463 in the error message; it is more than 1,000 because we are tokenizing long reviews into more than one example by using <code>return_overflowing_tokens=True</code>). That doesn’t work for a <code>Dataset</code>, so we need to either remove the columns from the old dataset or make them the same size as they are in the new dataset. We can do the former with the <code>remove_columns</code> argument:",cl,Jt,hl,ft,Mi="Now this works without error. We can check that our new dataset has many more elements than the original dataset by comparing the lengths:",ul,Tt,Ml,Ut,ml,jt,mi="We mentioned that we can also deal with the mismatched length problem by making the old columns the same size as the new ones. To do this, we will need the <code>overflow_to_sample_mapping</code> field the tokenizer returns when we set <code>return_overflowing_tokens=True</code>. It gives us a mapping from a new feature index to the index of the sample it originated from. Using this, we can associate each key present in our original dataset with a list of values of the right size by repeating the values of each example as many times as it generates new features:",yl,bt,wl,gt,yi="We can see it works with <code>Dataset.map()</code> without us needing to remove the old columns:",Jl,$t,fl,Ct,Tl,It,wi="We get the same number of training features as before, but here we’ve kept all the old fields. If you need them for some post-processing after applying your model, you might want to use this approach.",Ul,xt,Ji=`You’ve now seen how 🤗 Datasets can be used to preprocess a dataset in various ways. Although the processing functions of 🤗 Datasets will cover most of your model training needs,
there may be times when you’ll need to switch to Pandas to access more powerful features, like <code>DataFrame.groupby()</code> or high-level APIs for visualization. Fortunately, 🤗 Datasets is designed to be interoperable with libraries such as Pandas, NumPy, PyTorch, TensorFlow, and JAX. Let’s take a look at how this works.`,jl,Zt,bl,kt,gl,vt,fi="To enable the conversion between various third-party libraries, 🤗 Datasets provides a <code>Dataset.set_format()</code> function. This function only changes the <em>output format</em> of the dataset, so you can easily switch to another format without affecting the underlying <em>data format</em>, which is Apache Arrow. The formatting is done in place. To demonstrate, let’s convert our dataset to Pandas:",$l,Gt,Cl,Vt,Ti="Now when we access elements of the dataset we get a <code>pandas.DataFrame</code> instead of a dictionary:",Il,_t,xl,U,Ui='<thead><tr style="text-align: right;"><th></th> <th>patient_id</th> <th>drugName</th> <th>condition</th> <th>review</th> <th>rating</th> <th>date</th> <th>usefulCount</th> <th>review_length</th></tr></thead> <tbody><tr><th>0</th> <td>95260</td> <td>Guanfacine</td> <td>adhd</td> <td>&quot;My son is halfway through his fourth week of Intuniv...&quot;</td> <td>8.0</td> <td>April 27, 2010</td> <td>192</td> <td>141</td></tr> <tr><th>1</th> <td>92703</td> <td>Lybrel</td> <td>birth control</td> <td>&quot;I used to take another oral contraceptive, which had 21 pill cycle, and was very happy- very light periods, max 5 days, no other side effects...&quot;</td> <td>5.0</td> <td>December 14, 2009</td> <td>17</td> <td>134</td></tr> <tr><th>2</th> <td>138000</td> <td>Ortho Evra</td> <td>birth control</td> <td>&quot;This is my first time using any form of birth control...&quot;</td> <td>8.0</td> <td>November 3, 2015</td> <td>10</td> <td>89</td></tr></tbody>',Zl,Xt,ji="Let’s create a <code>pandas.DataFrame</code> for the whole training set by selecting all the elements of <code>drug_dataset[&quot;train&quot;]</code>:",kl,Wt,vl,Z,Gl,Bt,bi="From here we can use all the Pandas functionality that we want. For example, we can do fancy chaining to compute the class distribution among the <code>condition</code> entries:",Vl,Qt,_l,j,gi='<thead><tr style="text-align: right;"><th></th> <th>condition</th> <th>frequency</th></tr></thead> <tbody><tr><th>0</th> <td>birth control</td> <td>27655</td></tr> <tr><th>1</th> <td>depression</td> <td>8023</td></tr> <tr><th>2</th> <td>acne</td> <td>5209</td></tr> <tr><th>3</th> <td>anxiety</td> <td>4991</td></tr> <tr><th>4</th> <td>pain</td> <td>4744</td></tr></tbody>',Xl,Rt,$i="And once we’re done with our Pandas analysis, we can always create a new <code>Dataset</code> object by using the <code>Dataset.from_pandas()</code> function as follows:",Wl,Nt,Bl,Ht,Ql,k,Rl,zt,Ci="This wraps up our tour of the various preprocessing techniques available in 🤗 Datasets. To round out the section, let’s create a validation set to prepare the dataset for training a classifier on. Before doing so, we’ll reset the output format of <code>drug_dataset</code> from <code>&quot;pandas&quot;</code> to <code>&quot;arrow&quot;</code>:",Nl,Yt,Hl,Ft,zl,At,Ii="Although we have a test set we could use for evaluation, it’s a good practice to leave the test set untouched and create a separate validation set during development. Once you are happy with the performance of your models on the validation set, you can do a final sanity check on the test set. This process helps mitigate the risk that you’ll overfit to the test set and deploy a model that fails on real-world data.",Yl,Dt,xi="🤗 Datasets provides a <code>Dataset.train_test_split()</code> function that is based on the famous functionality from <code>scikit-learn</code>. Let’s use it to split our training set into <code>train</code> and <code>validation</code> splits (we set the <code>seed</code> argument for reproducibility):",Fl,Et,Al,St,Dl,qt,Zi='Great, we’ve now prepared a dataset that’s ready for training some models on! In <a href="/course/chapter5/5">section 5</a> we’ll show you how to upload datasets to the Hugging Face Hub, but for now let’s cap off our analysis by looking at a few ways you can save datasets on your local machine.',El,Lt,Sl,Pt,ql,Kt,ki="Although 🤗 Datasets will cache every downloaded dataset and the operations performed on it, there are times when you’ll want to save a dataset to disk (e.g., in case the cache gets deleted). As shown in the table below, 🤗 Datasets provides three main functions to save your dataset in different formats:",Ll,Ot,vi='<thead><tr><th align="center">Data format</th> <th align="center">Function</th></tr></thead> <tbody><tr><td align="center">Arrow</td> <td align="center"><code>Dataset.save_to_disk()</code></td></tr> <tr><td align="center">CSV</td> <td align="center"><code>Dataset.to_csv()</code></td></tr> <tr><td align="center">JSON</td> <td align="center"><code>Dataset.to_json()</code></td></tr></tbody>',Pl,es,Gi="For example, let’s save our cleaned dataset in the Arrow format:",Kl,ts,Ol,ss,Vi="This will create a directory with the following structure:",en,as,tn,ls,_i="where we can see that each split is associated with its own <em>dataset.arrow</em> table, and some metadata in <em>dataset_info.json</em> and <em>state.json</em>. You can think of the Arrow format as a fancy table of columns and rows that is optimized for building high-performance applications that process and transport large datasets.",sn,ns,Xi="Once the dataset is saved, we can load it by using the <code>load_from_disk()</code> function as follows:",an,is,ln,rs,nn,os,Wi="For the CSV and JSON formats, we have to store each split as a separate file. One way to do this is by iterating over the keys and values in the <code>DatasetDict</code> object:",rn,ps,on,ds,Bi='This saves each split in <a href="https://jsonlines.org" rel="nofollow">JSON Lines format</a>, where each row in the dataset is stored as a single line of JSON. Here’s what the first example looks like:',pn,cs,dn,hs,cn,us,Qi='We can then use the techniques from <a href="/course/chapter5/2">section 2</a> to load the JSON files as follows:',hn,Ms,un,ms,Ri="And that’s it for our excursion into data wrangling with 🤗 Datasets! Now that we have a cleaned dataset for training a model on, here are a few ideas that you could try out:",Mn,ys,Ni='<li>Use the techniques from <a href="/course/chapter3">Chapter 3</a> to train a classifier that can predict the patient condition based on the drug review.</li> <li>Use the <code>summarization</code> pipeline from <a href="/course/chapter1">Chapter 1</a> to generate summaries of the reviews.</li>',mn,ws,Hi="Next, we’ll take a look at how 🤗 Datasets can enable you to work with huge datasets without blowing up your laptop!",yn,Ts,wn;return V=new Js({props:{title:"Time to slice and dice",local:"time-to-slice-and-dice",headingTag:"h1"}}),_=new ar({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section3.ipynb"}]}}),W=new Jn({props:{id:"tqfSFcPMgOI"}}),B=new Js({props:{title:"Slicing and dicing our data",local:"slicing-and-dicing-our-data",headingTag:"h2"}}),H=new y({props:{code:"IXdnZXQlMjAlMjJodHRwcyUzQSUyRiUyRmFyY2hpdmUuaWNzLnVjaS5lZHUlMkZtbCUyRm1hY2hpbmUtbGVhcm5pbmctZGF0YWJhc2VzJTJGMDA0NjIlMkZkcnVnc0NvbV9yYXcuemlwJTIyJTBBIXVuemlwJTIwZHJ1Z3NDb21fcmF3LnppcA==",highlighted:`!wget <span class="hljs-string">&quot;https://archive.ics.uci.edu/ml/machine-learning-databases/00462/drugsCom_raw.zip&quot;</span>
!unzip drugsCom_raw.<span class="hljs-built_in">zip</span>`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTIyZHJ1Z3NDb21UcmFpbl9yYXcudHN2JTIyJTJDJTIwJTIydGVzdCUyMiUzQSUyMCUyMmRydWdzQ29tVGVzdF9yYXcudHN2JTIyJTdEJTBBJTIzJTIwJTVDdCUyMGlzJTIwdGhlJTIwdGFiJTIwY2hhcmFjdGVyJTIwaW4lMjBQeXRob24lMEFkcnVnX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3N2JTIyJTJDJTIwZGF0YV9maWxlcyUzRGRhdGFfZmlsZXMlMkMlMjBkZWxpbWl0ZXIlM0QlMjIlNUN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data_files = {<span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;drugsComTrain_raw.tsv&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;drugsComTest_raw.tsv&quot;</span>}
<span class="hljs-comment"># \\t is the tab character in Python</span>
drug_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, delimiter=<span class="hljs-string">&quot;\\t&quot;</span>)`,wrap:!1}}),A=new y({props:{code:"ZHJ1Z19zYW1wbGUlMjAlM0QlMjBkcnVnX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKSUwQSUyMyUyMFBlZWslMjBhdCUyMHRoZSUyMGZpcnN0JTIwZmV3JTIwZXhhbXBsZXMlMEFkcnVnX3NhbXBsZSU1QiUzQTMlNUQ=",highlighted:`drug_sample = drug_dataset[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-comment"># Peek at the first few examples</span>
drug_sample[:<span class="hljs-number">3</span>]`,wrap:!1}}),D=new y({props:{code:"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",highlighted:`{<span class="hljs-string">&#x27;Unnamed: 0&#x27;</span>: [<span class="hljs-number">87571</span>, <span class="hljs-number">178045</span>, <span class="hljs-number">80482</span>],
 <span class="hljs-string">&#x27;drugName&#x27;</span>: [<span class="hljs-string">&#x27;Naproxen&#x27;</span>, <span class="hljs-string">&#x27;Duloxetine&#x27;</span>, <span class="hljs-string">&#x27;Mobic&#x27;</span>],
 <span class="hljs-string">&#x27;condition&#x27;</span>: [<span class="hljs-string">&#x27;Gout, Acute&#x27;</span>, <span class="hljs-string">&#x27;ibromyalgia&#x27;</span>, <span class="hljs-string">&#x27;Inflammatory Conditions&#x27;</span>],
 <span class="hljs-string">&#x27;review&#x27;</span>: [<span class="hljs-string">&#x27;&quot;like the previous person mention, I&amp;#039;m a strong believer of aleve, it works faster for my gout than the prescription meds I take. No more going to the doctor for refills.....Aleve works!&quot;&#x27;</span>,
  <span class="hljs-string">&#x27;&quot;I have taken Cymbalta for about a year and a half for fibromyalgia pain. It is great\\r\\nas a pain reducer and an anti-depressant, however, the side effects outweighed \\r\\nany benefit I got from it. I had trouble with restlessness, being tired constantly,\\r\\ndizziness, dry mouth, numbness and tingling in my feet, and horrible sweating. I am\\r\\nbeing weaned off of it now. Went from 60 mg to 30mg and now to 15 mg. I will be\\r\\noff completely in about a week. The fibro pain is coming back, but I would rather deal with it than the side effects.&quot;&#x27;</span>,
  <span class="hljs-string">&#x27;&quot;I have been taking Mobic for over a year with no side effects other than an elevated blood pressure.  I had severe knee and ankle pain which completely went away after taking Mobic.  I attempted to stop the medication however pain returned after a few days.&quot;&#x27;</span>],
 <span class="hljs-string">&#x27;rating&#x27;</span>: [<span class="hljs-number">9.0</span>, <span class="hljs-number">3.0</span>, <span class="hljs-number">10.0</span>],
 <span class="hljs-string">&#x27;date&#x27;</span>: [<span class="hljs-string">&#x27;September 2, 2015&#x27;</span>, <span class="hljs-string">&#x27;November 7, 2011&#x27;</span>, <span class="hljs-string">&#x27;June 5, 2013&#x27;</span>],
 <span class="hljs-string">&#x27;usefulCount&#x27;</span>: [<span class="hljs-number">36</span>, <span class="hljs-number">13</span>, <span class="hljs-number">128</span>]}`,wrap:!1}}),L=new y({props:{code:"Zm9yJTIwc3BsaXQlMjBpbiUyMGRydWdfZGF0YXNldC5rZXlzKCklM0ElMEElMjAlMjAlMjAlMjBhc3NlcnQlMjBsZW4oZHJ1Z19kYXRhc2V0JTVCc3BsaXQlNUQpJTIwJTNEJTNEJTIwbGVuKGRydWdfZGF0YXNldCU1QnNwbGl0JTVELnVuaXF1ZSglMjJVbm5hbWVkJTNBJTIwMCUyMikp",highlighted:`<span class="hljs-keyword">for</span> split <span class="hljs-keyword">in</span> drug_dataset.keys():
    <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(drug_dataset[split]) == <span class="hljs-built_in">len</span>(drug_dataset[split].unique(<span class="hljs-string">&quot;Unnamed: 0&quot;</span>))`,wrap:!1}}),K=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfY29sdW1uX25hbWUlM0QlMjJVbm5hbWVkJTNBJTIwMCUyMiUyQyUyMG5ld19jb2x1bW5fbmFtZSUzRCUyMnBhdGllbnRfaWQlMjIlMEEpJTBBZHJ1Z19kYXRhc2V0",highlighted:`drug_dataset = drug_dataset.rename_column(
    original_column_name=<span class="hljs-string">&quot;Unnamed: 0&quot;</span>, new_column_name=<span class="hljs-string">&quot;patient_id&quot;</span>
)
drug_dataset`,wrap:!1}}),O=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3BhdGllbnRfaWQnJTJDJTIwJ2RydWdOYW1lJyUyQyUyMCdjb25kaXRpb24nJTJDJTIwJ3JldmlldyclMkMlMjAncmF0aW5nJyUyQyUyMCdkYXRlJyUyQyUyMCd1c2VmdWxDb3VudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDE2MTI5NyUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidwYXRpZW50X2lkJyUyQyUyMCdkcnVnTmFtZSclMkMlMjAnY29uZGl0aW9uJyUyQyUyMCdyZXZpZXcnJTJDJTIwJ3JhdGluZyclMkMlMjAnZGF0ZSclMkMlMjAndXNlZnVsQ291bnQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA1Mzc2NiUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>],
        num_rows: <span class="hljs-number">161297</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>],
        num_rows: <span class="hljs-number">53766</span>
    })
})`,wrap:!1}}),b=new v({props:{$$slots:{default:[lr]},$$scope:{ctx:T}}}),te=new y({props:{code:"ZGVmJTIwbG93ZXJjYXNlX2NvbmRpdGlvbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmNvbmRpdGlvbiUyMiUzQSUyMGV4YW1wbGUlNUIlMjJjb25kaXRpb24lMjIlNUQubG93ZXIoKSU3RCUwQSUwQSUwQWRydWdfZGF0YXNldC5tYXAobG93ZXJjYXNlX2NvbmRpdGlvbik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">lowercase_condition</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;condition&quot;</span>: example[<span class="hljs-string">&quot;condition&quot;</span>].lower()}


drug_dataset.<span class="hljs-built_in">map</span>(lowercase_condition)`,wrap:!1}}),se=new y({props:{code:"QXR0cmlidXRlRXJyb3IlM0ElMjAnTm9uZVR5cGUnJTIwb2JqZWN0JTIwaGFzJTIwbm8lMjBhdHRyaWJ1dGUlMjAnbG93ZXIn",highlighted:'AttributeError: <span class="hljs-string">&#x27;NoneType&#x27;</span> <span class="hljs-built_in">object</span> has no attribute <span class="hljs-string">&#x27;lower&#x27;</span>',wrap:!1}}),le=new y({props:{code:"ZGVmJTIwZmlsdGVyX25vbmVzKHgpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIweCU1QiUyMmNvbmRpdGlvbiUyMiU1RCUyMGlzJTIwbm90JTIwTm9uZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">filter_nones</span>(<span class="hljs-params">x</span>):
    <span class="hljs-keyword">return</span> x[<span class="hljs-string">&quot;condition&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>`,wrap:!1}}),ie=new y({props:{code:"bGFtYmRhJTIwJTNDYXJndW1lbnRzJTNFJTIwJTNBJTIwJTNDZXhwcmVzc2lvbiUzRQ==",highlighted:'lambda <span class="hljs-tag">&lt;<span class="hljs-name">arguments</span>&gt;</span> : <span class="hljs-tag">&lt;<span class="hljs-name">expression</span>&gt;</span>',wrap:!1}}),oe=new y({props:{code:"bGFtYmRhJTIweCUyMCUzQSUyMHglMjAqJTIweA==",highlighted:'lambda <span class="hljs-keyword">x</span> : <span class="hljs-keyword">x</span> * <span class="hljs-keyword">x</span>',wrap:!1}}),de=new y({props:{code:"KGxhbWJkYSUyMHglM0ElMjB4JTIwKiUyMHgpKDMp",highlighted:'(<span class="hljs-keyword">lambda</span> x: x * x)(<span class="hljs-number">3</span>)',wrap:!1}}),ce=new y({props:{code:"OQ==",highlighted:'<span class="hljs-number">9</span>',wrap:!1}}),ue=new y({props:{code:"KGxhbWJkYSUyMGJhc2UlMkMlMjBoZWlnaHQlM0ElMjAwLjUlMjAqJTIwYmFzZSUyMColMjBoZWlnaHQpKDQlMkMlMjA4KQ==",highlighted:'(<span class="hljs-keyword">lambda</span> base, height: <span class="hljs-number">0.5</span> * base * height)(<span class="hljs-number">4</span>, <span class="hljs-number">8</span>)',wrap:!1}}),Me=new y({props:{code:"MTYuMA==",highlighted:'<span class="hljs-number">16.0</span>',wrap:!1}}),ye=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMmNvbmRpdGlvbiUyMiU1RCUyMGlzJTIwbm90JTIwTm9uZSk=",highlighted:'drug_dataset = drug_dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;condition&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>)',wrap:!1}}),Je=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0Lm1hcChsb3dlcmNhc2VfY29uZGl0aW9uKSUwQSUyMyUyMENoZWNrJTIwdGhhdCUyMGxvd2VyY2FzaW5nJTIwd29ya2VkJTBBZHJ1Z19kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIlMjJjb25kaXRpb24lMjIlNUQlNUIlM0EzJTVE",highlighted:`drug_dataset = drug_dataset.<span class="hljs-built_in">map</span>(lowercase_condition)
<span class="hljs-comment"># Check that lowercasing worked</span>
drug_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-string">&quot;condition&quot;</span>][:<span class="hljs-number">3</span>]`,wrap:!1}}),fe=new y({props:{code:"JTVCJ2xlZnQlMjB2ZW50cmljdWxhciUyMGR5c2Z1bmN0aW9uJyUyQyUyMCdhZGhkJyUyQyUyMCdiaXJ0aCUyMGNvbnRyb2wnJTVE",highlighted:'[<span class="hljs-string">&#x27;left ventricular dysfunction&#x27;</span>, <span class="hljs-string">&#x27;adhd&#x27;</span>, <span class="hljs-string">&#x27;birth control&#x27;</span>]',wrap:!1}}),Ue=new Js({props:{title:"Creating new columns",local:"creating-new-columns",headingTag:"h2"}}),ge=new y({props:{code:"ZGVmJTIwY29tcHV0ZV9yZXZpZXdfbGVuZ3RoKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIycmV2aWV3X2xlbmd0aCUyMiUzQSUyMGxlbihleGFtcGxlJTVCJTIycmV2aWV3JTIyJTVELnNwbGl0KCkpJTdE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_review_length</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;review_length&quot;</span>: <span class="hljs-built_in">len</span>(example[<span class="hljs-string">&quot;review&quot;</span>].split())}`,wrap:!1}}),Ce=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0Lm1hcChjb21wdXRlX3Jldmlld19sZW5ndGgpJTBBJTIzJTIwSW5zcGVjdCUyMHRoZSUyMGZpcnN0JTIwdHJhaW5pbmclMjBleGFtcGxlJTBBZHJ1Z19kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVE",highlighted:`drug_dataset = drug_dataset.<span class="hljs-built_in">map</span>(compute_review_length)
<span class="hljs-comment"># Inspect the first training example</span>
drug_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new y({props:{code:"JTdCJ3BhdGllbnRfaWQnJTNBJTIwMjA2NDYxJTJDJTBBJTIwJ2RydWdOYW1lJyUzQSUyMCdWYWxzYXJ0YW4nJTJDJTBBJTIwJ2NvbmRpdGlvbiclM0ElMjAnbGVmdCUyMHZlbnRyaWN1bGFyJTIwZHlzZnVuY3Rpb24nJTJDJTBBJTIwJ3JldmlldyclM0ElMjAnJTIySXQlMjBoYXMlMjBubyUyMHNpZGUlMjBlZmZlY3QlMkMlMjBJJTIwdGFrZSUyMGl0JTIwaW4lMjBjb21iaW5hdGlvbiUyMG9mJTIwQnlzdG9saWMlMjA1JTIwTWclMjBhbmQlMjBGaXNoJTIwT2lsJTIyJyUyQyUwQSUyMCdyYXRpbmcnJTNBJTIwOS4wJTJDJTBBJTIwJ2RhdGUnJTNBJTIwJ01heSUyMDIwJTJDJTIwMjAxMiclMkMlMEElMjAndXNlZnVsQ291bnQnJTNBJTIwMjclMkMlMEElMjAncmV2aWV3X2xlbmd0aCclM0ElMjAxNyU3RA==",highlighted:`{<span class="hljs-string">&#x27;patient_id&#x27;</span>: <span class="hljs-number">206461</span>,
 <span class="hljs-string">&#x27;drugName&#x27;</span>: <span class="hljs-string">&#x27;Valsartan&#x27;</span>,
 <span class="hljs-string">&#x27;condition&#x27;</span>: <span class="hljs-string">&#x27;left ventricular dysfunction&#x27;</span>,
 <span class="hljs-string">&#x27;review&#x27;</span>: <span class="hljs-string">&#x27;&quot;It has no side effect, I take it in combination of Bystolic 5 Mg and Fish Oil&quot;&#x27;</span>,
 <span class="hljs-string">&#x27;rating&#x27;</span>: <span class="hljs-number">9.0</span>,
 <span class="hljs-string">&#x27;date&#x27;</span>: <span class="hljs-string">&#x27;May 20, 2012&#x27;</span>,
 <span class="hljs-string">&#x27;usefulCount&#x27;</span>: <span class="hljs-number">27</span>,
 <span class="hljs-string">&#x27;review_length&#x27;</span>: <span class="hljs-number">17</span>}`,wrap:!1}}),Ze=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQuc29ydCglMjJyZXZpZXdfbGVuZ3RoJTIyKSU1QiUzQTMlNUQ=",highlighted:'drug_dataset[<span class="hljs-string">&quot;train&quot;</span>].sort(<span class="hljs-string">&quot;review_length&quot;</span>)[:<span class="hljs-number">3</span>]',wrap:!1}}),ke=new y({props:{code:"JTdCJ3BhdGllbnRfaWQnJTNBJTIwJTVCMTAzNDg4JTJDJTIwMjM2MjclMkMlMjAyMDU1OCU1RCUyQyUwQSUyMCdkcnVnTmFtZSclM0ElMjAlNUInTG9lc3RyaW4lMjAyMSUyMDElMjAlMkYlMjAyMCclMkMlMjAnQ2hsb3J6b3hhem9uZSclMkMlMjAnTnVjeW50YSclNUQlMkMlMEElMjAnY29uZGl0aW9uJyUzQSUyMCU1QidiaXJ0aCUyMGNvbnRyb2wnJTJDJTIwJ211c2NsZSUyMHNwYXNtJyUyQyUyMCdwYWluJyU1RCUyQyUwQSUyMCdyZXZpZXcnJTNBJTIwJTVCJyUyMkV4Y2VsbGVudC4lMjInJTJDJTIwJyUyMnVzZWxlc3MlMjInJTJDJTIwJyUyMm9rJTIyJyU1RCUyQyUwQSUyMCdyYXRpbmcnJTNBJTIwJTVCMTAuMCUyQyUyMDEuMCUyQyUyMDYuMCU1RCUyQyUwQSUyMCdkYXRlJyUzQSUyMCU1QidOb3ZlbWJlciUyMDQlMkMlMjAyMDA4JyUyQyUyMCdNYXJjaCUyMDI0JTJDJTIwMjAxNyclMkMlMjAnQXVndXN0JTIwMjAlMkMlMjAyMDE2JyU1RCUyQyUwQSUyMCd1c2VmdWxDb3VudCclM0ElMjAlNUI1JTJDJTIwMiUyQyUyMDEwJTVEJTJDJTBBJTIwJ3Jldmlld19sZW5ndGgnJTNBJTIwJTVCMSUyQyUyMDElMkMlMjAxJTVEJTdE",highlighted:`{<span class="hljs-string">&#x27;patient_id&#x27;</span>: [<span class="hljs-number">103488</span>, <span class="hljs-number">23627</span>, <span class="hljs-number">20558</span>],
 <span class="hljs-string">&#x27;drugName&#x27;</span>: [<span class="hljs-string">&#x27;Loestrin 21 1 / 20&#x27;</span>, <span class="hljs-string">&#x27;Chlorzoxazone&#x27;</span>, <span class="hljs-string">&#x27;Nucynta&#x27;</span>],
 <span class="hljs-string">&#x27;condition&#x27;</span>: [<span class="hljs-string">&#x27;birth control&#x27;</span>, <span class="hljs-string">&#x27;muscle spasm&#x27;</span>, <span class="hljs-string">&#x27;pain&#x27;</span>],
 <span class="hljs-string">&#x27;review&#x27;</span>: [<span class="hljs-string">&#x27;&quot;Excellent.&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;useless&quot;&#x27;</span>, <span class="hljs-string">&#x27;&quot;ok&quot;&#x27;</span>],
 <span class="hljs-string">&#x27;rating&#x27;</span>: [<span class="hljs-number">10.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">6.0</span>],
 <span class="hljs-string">&#x27;date&#x27;</span>: [<span class="hljs-string">&#x27;November 4, 2008&#x27;</span>, <span class="hljs-string">&#x27;March 24, 2017&#x27;</span>, <span class="hljs-string">&#x27;August 20, 2016&#x27;</span>],
 <span class="hljs-string">&#x27;usefulCount&#x27;</span>: [<span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">10</span>],
 <span class="hljs-string">&#x27;review_length&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),g=new v({props:{$$slots:{default:[nr]},$$scope:{ctx:T}}}),Ve=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0LmZpbHRlcihsYW1iZGElMjB4JTNBJTIweCU1QiUyMnJldmlld19sZW5ndGglMjIlNUQlMjAlM0UlMjAzMCklMEFwcmludChkcnVnX2RhdGFzZXQubnVtX3Jvd3Mp",highlighted:`drug_dataset = drug_dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;review_length&quot;</span>] &gt; <span class="hljs-number">30</span>)
<span class="hljs-built_in">print</span>(drug_dataset.num_rows)`,wrap:!1}}),_e=new y({props:{code:"JTdCJ3RyYWluJyUzQSUyMDEzODUxNCUyQyUyMCd0ZXN0JyUzQSUyMDQ2MTA4JTdE",highlighted:'{<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-number">138514</span>, <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-number">46108</span>}',wrap:!1}}),$=new v({props:{$$slots:{default:[ir]},$$scope:{ctx:T}}}),Be=new y({props:{code:"aW1wb3J0JTIwaHRtbCUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTI2JTIzMDM5JTNCbSUyMGElMjB0cmFuc2Zvcm1lciUyMGNhbGxlZCUyMEJFUlQlMjIlMEFodG1sLnVuZXNjYXBlKHRleHQp",highlighted:`<span class="hljs-keyword">import</span> html

text = <span class="hljs-string">&quot;I&amp;#039;m a transformer called BERT&quot;</span>
html.unescape(text)`,wrap:!1}}),Qe=new y({props:{code:"JTIySSdtJTIwYSUyMHRyYW5zZm9ybWVyJTIwY2FsbGVkJTIwQkVSVCUyMg==",highlighted:'<span class="hljs-string">&quot;I&#x27;m a transformer called BERT&quot;</span>',wrap:!1}}),Ne=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0Lm1hcChsYW1iZGElMjB4JTNBJTIwJTdCJTIycmV2aWV3JTIyJTNBJTIwaHRtbC51bmVzY2FwZSh4JTVCJTIycmV2aWV3JTIyJTVEKSU3RCk=",highlighted:'drug_dataset = drug_dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;review&quot;</span>: html.unescape(x[<span class="hljs-string">&quot;review&quot;</span>])})',wrap:!1}}),ze=new Js({props:{title:"The map() method’s superpowers",local:"the-map-methods-superpowers",headingTag:"h2"}}),Ae=new y({props:{code:"bmV3X2RydWdfZGF0YXNldCUyMCUzRCUyMGRydWdfZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIweCUzQSUyMCU3QiUyMnJldmlldyUyMiUzQSUyMCU1Qmh0bWwudW5lc2NhcGUobyklMjBmb3IlMjBvJTIwaW4lMjB4JTVCJTIycmV2aWV3JTIyJTVEJTVEJTdEJTJDJTIwYmF0Y2hlZCUzRFRydWUlMEEp",highlighted:`new_drug_dataset = drug_dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;review&quot;</span>: [html.unescape(o) <span class="hljs-keyword">for</span> o <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;review&quot;</span>]]}, batched=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTBBZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIycmV2aWV3JTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;review&quot;</span>], truncation=<span class="hljs-literal">True</span>)`,wrap:!1}}),Le=new y({props:{code:"JTI1dGltZSUyMHRva2VuaXplZF9kYXRhc2V0JTIwJTNEJTIwZHJ1Z19kYXRhc2V0Lm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:'%time tokenized_dataset = drug_dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)',wrap:!1}}),C=new v({props:{$$slots:{default:[rr]},$$scope:{ctx:T}}}),at=new y({props:{code:"c2xvd190b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIlMkMlMjB1c2VfZmFzdCUzREZhbHNlKSUwQSUwQSUwQWRlZiUyMHNsb3dfdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2xvd190b2tlbml6ZXIoZXhhbXBsZXMlNUIlMjJyZXZpZXclMjIlNUQlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMEF0b2tlbml6ZWRfZGF0YXNldCUyMCUzRCUyMGRydWdfZGF0YXNldC5tYXAoc2xvd190b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwbnVtX3Byb2MlM0Q4KQ==",highlighted:`slow_tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, use_fast=<span class="hljs-literal">False</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">slow_tokenize_function</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> slow_tokenizer(examples[<span class="hljs-string">&quot;review&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_dataset = drug_dataset.<span class="hljs-built_in">map</span>(slow_tokenize_function, batched=<span class="hljs-literal">True</span>, num_proc=<span class="hljs-number">8</span>)`,wrap:!1}}),I=new v({props:{$$slots:{default:[or]},$$scope:{ctx:T}}}),x=new v({props:{$$slots:{default:[pr]},$$scope:{ctx:T}}}),pt=new y({props:{code:"ZGVmJTIwdG9rZW5pemVfYW5kX3NwbGl0KGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnJldmlldyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9vdmVyZmxvd2luZ190b2tlbnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_and_split</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-keyword">return</span> tokenizer(
        examples[<span class="hljs-string">&quot;review&quot;</span>],
        truncation=<span class="hljs-literal">True</span>,
        max_length=<span class="hljs-number">128</span>,
        return_overflowing_tokens=<span class="hljs-literal">True</span>,
    )`,wrap:!1}}),ct=new y({props:{code:"cmVzdWx0JTIwJTNEJTIwdG9rZW5pemVfYW5kX3NwbGl0KGRydWdfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCklMEElNUJsZW4oaW5wKSUyMGZvciUyMGlucCUyMGluJTIwcmVzdWx0JTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVE",highlighted:`result = tokenize_and_split(drug_dataset[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>])
[<span class="hljs-built_in">len</span>(inp) <span class="hljs-keyword">for</span> inp <span class="hljs-keyword">in</span> result[<span class="hljs-string">&quot;input_ids&quot;</span>]]`,wrap:!1}}),ht=new y({props:{code:"JTVCMTI4JTJDJTIwNDklNUQ=",highlighted:'[<span class="hljs-number">128</span>, <span class="hljs-number">49</span>]',wrap:!1}}),Mt=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjBkcnVnX2RhdGFzZXQubWFwKHRva2VuaXplX2FuZF9zcGxpdCUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:'tokenized_dataset = drug_dataset.<span class="hljs-built_in">map</span>(tokenize_and_split, batched=<span class="hljs-literal">True</span>)',wrap:!1}}),mt=new y({props:{code:"QXJyb3dJbnZhbGlkJTNBJTIwQ29sdW1uJTIwMSUyMG5hbWVkJTIwY29uZGl0aW9uJTIwZXhwZWN0ZWQlMjBsZW5ndGglMjAxNDYzJTIwYnV0JTIwZ290JTIwbGVuZ3RoJTIwMTAwMA==",highlighted:'ArrowInvalid: Column <span class="hljs-number">1</span> named condition expected length <span class="hljs-number">1463</span> but got length <span class="hljs-number">1000</span>',wrap:!1}}),Jt=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjBkcnVnX2RhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMHRva2VuaXplX2FuZF9zcGxpdCUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0RkcnVnX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMEEp",highlighted:`tokenized_dataset = drug_dataset.<span class="hljs-built_in">map</span>(
    tokenize_and_split, batched=<span class="hljs-literal">True</span>, remove_columns=drug_dataset[<span class="hljs-string">&quot;train&quot;</span>].column_names
)`,wrap:!1}}),Tt=new y({props:{code:"bGVuKHRva2VuaXplZF9kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTJDJTIwbGVuKGRydWdfZGF0YXNldCU1QiUyMnRyYWluJTIyJTVEKQ==",highlighted:'<span class="hljs-built_in">len</span>(tokenized_dataset[<span class="hljs-string">&quot;train&quot;</span>]), <span class="hljs-built_in">len</span>(drug_dataset[<span class="hljs-string">&quot;train&quot;</span>])',wrap:!1}}),Ut=new y({props:{code:"KDIwNjc3MiUyQyUyMDEzODUxNCk=",highlighted:'(<span class="hljs-number">206772</span>, <span class="hljs-number">138514</span>)',wrap:!1}}),bt=new y({props:{code:"ZGVmJTIwdG9rZW5pemVfYW5kX3NwbGl0KGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMnJldmlldyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9vdmVyZmxvd2luZ190b2tlbnMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMCUyMyUyMEV4dHJhY3QlMjBtYXBwaW5nJTIwYmV0d2VlbiUyMG5ldyUyMGFuZCUyMG9sZCUyMGluZGljZXMlMEElMjAlMjAlMjAlMjBzYW1wbGVfbWFwJTIwJTNEJTIwcmVzdWx0LnBvcCglMjJvdmVyZmxvd190b19zYW1wbGVfbWFwcGluZyUyMiklMEElMjAlMjAlMjAlMjBmb3IlMjBrZXklMkMlMjB2YWx1ZXMlMjBpbiUyMGV4YW1wbGVzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlNUJrZXklNUQlMjAlM0QlMjAlNUJ2YWx1ZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwc2FtcGxlX21hcCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3VsdA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_and_split</span>(<span class="hljs-params">examples</span>):
    result = tokenizer(
        examples[<span class="hljs-string">&quot;review&quot;</span>],
        truncation=<span class="hljs-literal">True</span>,
        max_length=<span class="hljs-number">128</span>,
        return_overflowing_tokens=<span class="hljs-literal">True</span>,
    )
    <span class="hljs-comment"># Extract mapping between new and old indices</span>
    sample_map = result.pop(<span class="hljs-string">&quot;overflow_to_sample_mapping&quot;</span>)
    <span class="hljs-keyword">for</span> key, values <span class="hljs-keyword">in</span> examples.items():
        result[key] = [values[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> sample_map]
    <span class="hljs-keyword">return</span> result`,wrap:!1}}),$t=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXQlMjAlM0QlMjBkcnVnX2RhdGFzZXQubWFwKHRva2VuaXplX2FuZF9zcGxpdCUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRva2VuaXplZF9kYXRhc2V0",highlighted:`tokenized_dataset = drug_dataset.<span class="hljs-built_in">map</span>(tokenize_and_split, batched=<span class="hljs-literal">True</span>)
tokenized_dataset`,wrap:!1}}),Ct=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2F0dGVudGlvbl9tYXNrJyUyQyUyMCdjb25kaXRpb24nJTJDJTIwJ2RhdGUnJTJDJTIwJ2RydWdOYW1lJyUyQyUyMCdpbnB1dF9pZHMnJTJDJTIwJ3BhdGllbnRfaWQnJTJDJTIwJ3JhdGluZyclMkMlMjAncmV2aWV3JyUyQyUyMCdyZXZpZXdfbGVuZ3RoJyUyQyUyMCd0b2tlbl90eXBlX2lkcyclMkMlMjAndXNlZnVsQ291bnQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAyMDY3NzIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwdGVzdCUzQSUyMERhdGFzZXQoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0ElMjAlNUInYXR0ZW50aW9uX21hc2snJTJDJTIwJ2NvbmRpdGlvbiclMkMlMjAnZGF0ZSclMkMlMjAnZHJ1Z05hbWUnJTJDJTIwJ2lucHV0X2lkcyclMkMlMjAncGF0aWVudF9pZCclMkMlMjAncmF0aW5nJyUyQyUyMCdyZXZpZXcnJTJDJTIwJ3Jldmlld19sZW5ndGgnJTJDJTIwJ3Rva2VuX3R5cGVfaWRzJyUyQyUyMCd1c2VmdWxDb3VudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDY4ODc2JTBBJTIwJTIwJTIwJTIwJTdEKSUwQSU3RCk=",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>],
        num_rows: <span class="hljs-number">206772</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>],
        num_rows: <span class="hljs-number">68876</span>
    })
})`,wrap:!1}}),Zt=new Js({props:{title:"From Dataset s to DataFrame s and back",local:"from-datasets-to-dataframes-and-back",headingTag:"h2"}}),kt=new Jn({props:{id:"tfcY1067A5Q"}}),Gt=new y({props:{code:"ZHJ1Z19kYXRhc2V0LnNldF9mb3JtYXQoJTIycGFuZGFzJTIyKQ==",highlighted:'drug_dataset.set_format(<span class="hljs-string">&quot;pandas&quot;</span>)',wrap:!1}}),_t=new y({props:{code:"ZHJ1Z19kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlNUIlM0EzJTVE",highlighted:'drug_dataset[<span class="hljs-string">&quot;train&quot;</span>][:<span class="hljs-number">3</span>]',wrap:!1}}),Wt=new y({props:{code:"dHJhaW5fZGYlMjAlM0QlMjBkcnVnX2RhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RCU1QiUzQSU1RA==",highlighted:'train_df = drug_dataset[<span class="hljs-string">&quot;train&quot;</span>][:]',wrap:!1}}),Z=new v({props:{$$slots:{default:[dr]},$$scope:{ctx:T}}}),Qt=new y({props:{code:"ZnJlcXVlbmNpZXMlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGYlNUIlMjJjb25kaXRpb24lMjIlNUQlMEElMjAlMjAlMjAlMjAudmFsdWVfY291bnRzKCklMEElMjAlMjAlMjAlMjAudG9fZnJhbWUoKSUwQSUyMCUyMCUyMCUyMC5yZXNldF9pbmRleCgpJTBBJTIwJTIwJTIwJTIwLnJlbmFtZShjb2x1bW5zJTNEJTdCJTIyaW5kZXglMjIlM0ElMjAlMjJjb25kaXRpb24lMjIlMkMlMjAlMjJjb25kaXRpb24lMjIlM0ElMjAlMjJmcmVxdWVuY3klMjIlN0QpJTBBKSUwQWZyZXF1ZW5jaWVzLmhlYWQoKQ==",highlighted:`frequencies = (
    train_df[<span class="hljs-string">&quot;condition&quot;</span>]
    .value_counts()
    .to_frame()
    .reset_index()
    .rename(columns={<span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;condition&quot;</span>, <span class="hljs-string">&quot;condition&quot;</span>: <span class="hljs-string">&quot;frequency&quot;</span>})
)
frequencies.head()`,wrap:!1}}),Nt=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWZyZXFfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9wYW5kYXMoZnJlcXVlbmNpZXMpJTBBZnJlcV9kYXRhc2V0",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

freq_dataset = Dataset.from_pandas(frequencies)
freq_dataset`,wrap:!1}}),Ht=new y({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qidjb25kaXRpb24nJTJDJTIwJ2ZyZXF1ZW5jeSclNUQlMkMlMEElMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDgxOSUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;frequency&#x27;</span>],
    num_rows: <span class="hljs-number">819</span>
})`,wrap:!1}}),k=new v({props:{$$slots:{default:[cr]},$$scope:{ctx:T}}}),Yt=new y({props:{code:"ZHJ1Z19kYXRhc2V0LnJlc2V0X2Zvcm1hdCgp",highlighted:"drug_dataset.reset_format()",wrap:!1}}),Ft=new Js({props:{title:"Creating a validation set",local:"creating-a-validation-set",headingTag:"h2"}}),Et=new y({props:{code:"ZHJ1Z19kYXRhc2V0X2NsZWFuJTIwJTNEJTIwZHJ1Z19kYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQudHJhaW5fdGVzdF9zcGxpdCh0cmFpbl9zaXplJTNEMC44JTJDJTIwc2VlZCUzRDQyKSUwQSUyMyUyMFJlbmFtZSUyMHRoZSUyMGRlZmF1bHQlMjAlMjJ0ZXN0JTIyJTIwc3BsaXQlMjB0byUyMCUyMnZhbGlkYXRpb24lMjIlMEFkcnVnX2RhdGFzZXRfY2xlYW4lNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTIwJTNEJTIwZHJ1Z19kYXRhc2V0X2NsZWFuLnBvcCglMjJ0ZXN0JTIyKSUwQSUyMyUyMEFkZCUyMHRoZSUyMCUyMnRlc3QlMjIlMjBzZXQlMjB0byUyMG91ciUyMCU2MERhdGFzZXREaWN0JTYwJTBBZHJ1Z19kYXRhc2V0X2NsZWFuJTVCJTIydGVzdCUyMiU1RCUyMCUzRCUyMGRydWdfZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlMEFkcnVnX2RhdGFzZXRfY2xlYW4=",highlighted:`drug_dataset_clean = drug_dataset[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(train_size=<span class="hljs-number">0.8</span>, seed=<span class="hljs-number">42</span>)
<span class="hljs-comment"># Rename the default &quot;test&quot; split to &quot;validation&quot;</span>
drug_dataset_clean[<span class="hljs-string">&quot;validation&quot;</span>] = drug_dataset_clean.pop(<span class="hljs-string">&quot;test&quot;</span>)
<span class="hljs-comment"># Add the &quot;test&quot; set to our \`DatasetDict\`</span>
drug_dataset_clean[<span class="hljs-string">&quot;test&quot;</span>] = drug_dataset[<span class="hljs-string">&quot;test&quot;</span>]
drug_dataset_clean`,wrap:!1}}),St=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3BhdGllbnRfaWQnJTJDJTIwJ2RydWdOYW1lJyUyQyUyMCdjb25kaXRpb24nJTJDJTIwJ3JldmlldyclMkMlMjAncmF0aW5nJyUyQyUyMCdkYXRlJyUyQyUyMCd1c2VmdWxDb3VudCclMkMlMjAncmV2aWV3X2xlbmd0aCclMkMlMjAncmV2aWV3X2NsZWFuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMTEwODExJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSUyMCUyMCUyMCUyMHZhbGlkYXRpb24lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3BhdGllbnRfaWQnJTJDJTIwJ2RydWdOYW1lJyUyQyUyMCdjb25kaXRpb24nJTJDJTIwJ3JldmlldyclMkMlMjAncmF0aW5nJyUyQyUyMCdkYXRlJyUyQyUyMCd1c2VmdWxDb3VudCclMkMlMjAncmV2aWV3X2xlbmd0aCclMkMlMjAncmV2aWV3X2NsZWFuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMjc3MDMlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwdGVzdCUzQSUyMERhdGFzZXQoJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0ElMjAlNUIncGF0aWVudF9pZCclMkMlMjAnZHJ1Z05hbWUnJTJDJTIwJ2NvbmRpdGlvbiclMkMlMjAncmV2aWV3JyUyQyUyMCdyYXRpbmcnJTJDJTIwJ2RhdGUnJTJDJTIwJ3VzZWZ1bENvdW50JyUyQyUyMCdyZXZpZXdfbGVuZ3RoJyUyQyUyMCdyZXZpZXdfY2xlYW4nJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0NjEwOCUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>, <span class="hljs-string">&#x27;review_clean&#x27;</span>],
        num_rows: <span class="hljs-number">110811</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>, <span class="hljs-string">&#x27;review_clean&#x27;</span>],
        num_rows: <span class="hljs-number">27703</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>, <span class="hljs-string">&#x27;review_clean&#x27;</span>],
        num_rows: <span class="hljs-number">46108</span>
    })
})`,wrap:!1}}),Lt=new Js({props:{title:"Saving a dataset",local:"saving-a-dataset",headingTag:"h2"}}),Pt=new Jn({props:{id:"blF9uxYcKHo"}}),ts=new y({props:{code:"ZHJ1Z19kYXRhc2V0X2NsZWFuLnNhdmVfdG9fZGlzayglMjJkcnVnLXJldmlld3MlMjIp",highlighted:'drug_dataset_clean.save_to_disk(<span class="hljs-string">&quot;drug-reviews&quot;</span>)',wrap:!1}}),as=new y({props:{code:"ZHJ1Zy1yZXZpZXdzJTJGJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YXNldF9kaWN0Lmpzb24lMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0ZXN0JTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YXNldC5hcnJvdyUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRhdGFzZXRfaW5mby5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwc3RhdGUuanNvbiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMHRyYWluJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YXNldC5hcnJvdyUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRhdGFzZXRfaW5mby5qc29uJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwaW5kaWNlcy5hcnJvdyUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHN0YXRlLmpzb24lMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjB2YWxpZGF0aW9uJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YXNldC5hcnJvdyUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRhdGFzZXRfaW5mby5qc29uJTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwaW5kaWNlcy5hcnJvdyUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHN0YXRlLmpzb24=",highlighted:`drug-reviews/
├── dataset_dict.json
├── test
│   ├── dataset.arrow
│   ├── dataset_info.json
│   └── <span class="hljs-keyword">state</span>.json
├── train
│   ├── dataset.arrow
│   ├── dataset_info.json
│   ├── indices.arrow
│   └── <span class="hljs-keyword">state</span>.json
└── validation
    ├── dataset.arrow
    ├── dataset_info.json
    ├── indices.arrow
    └── <span class="hljs-keyword">state</span>.json`,wrap:!1}}),is=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9mcm9tX2Rpc2slMEElMEFkcnVnX2RhdGFzZXRfcmVsb2FkZWQlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayglMjJkcnVnLXJldmlld3MlMjIpJTBBZHJ1Z19kYXRhc2V0X3JlbG9hZGVk",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_from_disk

drug_dataset_reloaded = load_from_disk(<span class="hljs-string">&quot;drug-reviews&quot;</span>)
drug_dataset_reloaded`,wrap:!1}}),rs=new y({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ3BhdGllbnRfaWQnJTJDJTIwJ2RydWdOYW1lJyUyQyUyMCdjb25kaXRpb24nJTJDJTIwJ3JldmlldyclMkMlMjAncmF0aW5nJyUyQyUyMCdkYXRlJyUyQyUyMCd1c2VmdWxDb3VudCclMkMlMjAncmV2aWV3X2xlbmd0aCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDExMDgxMSUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB2YWxpZGF0aW9uJTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidwYXRpZW50X2lkJyUyQyUyMCdkcnVnTmFtZSclMkMlMjAnY29uZGl0aW9uJyUyQyUyMCdyZXZpZXcnJTJDJTIwJ3JhdGluZyclMkMlMjAnZGF0ZSclMkMlMjAndXNlZnVsQ291bnQnJTJDJTIwJ3Jldmlld19sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjAyNzcwMyUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidwYXRpZW50X2lkJyUyQyUyMCdkcnVnTmFtZSclMkMlMjAnY29uZGl0aW9uJyUyQyUyMCdyZXZpZXcnJTJDJTIwJ3JhdGluZyclMkMlMjAnZGF0ZSclMkMlMjAndXNlZnVsQ291bnQnJTJDJTIwJ3Jldmlld19sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0NjEwOCUwQSUyMCUyMCUyMCUyMCU3RCklMEElN0Qp",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>],
        num_rows: <span class="hljs-number">110811</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>],
        num_rows: <span class="hljs-number">27703</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;patient_id&#x27;</span>, <span class="hljs-string">&#x27;drugName&#x27;</span>, <span class="hljs-string">&#x27;condition&#x27;</span>, <span class="hljs-string">&#x27;review&#x27;</span>, <span class="hljs-string">&#x27;rating&#x27;</span>, <span class="hljs-string">&#x27;date&#x27;</span>, <span class="hljs-string">&#x27;usefulCount&#x27;</span>, <span class="hljs-string">&#x27;review_length&#x27;</span>],
        num_rows: <span class="hljs-number">46108</span>
    })
})`,wrap:!1}}),ps=new y({props:{code:"Zm9yJTIwc3BsaXQlMkMlMjBkYXRhc2V0JTIwaW4lMjBkcnVnX2RhdGFzZXRfY2xlYW4uaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQudG9fanNvbihmJTIyZHJ1Zy1yZXZpZXdzLSU3QnNwbGl0JTdELmpzb25sJTIyKQ==",highlighted:`<span class="hljs-keyword">for</span> split, dataset <span class="hljs-keyword">in</span> drug_dataset_clean.items():
    dataset.to_json(<span class="hljs-string">f&quot;drug-reviews-<span class="hljs-subst">{split}</span>.jsonl&quot;</span>)`,wrap:!1}}),cs=new y({props:{code:"IWhlYWQlMjAtbiUyMDElMjBkcnVnLXJldmlld3MtdHJhaW4uanNvbmw=",highlighted:'!head -n <span class="hljs-number">1</span> drug-reviews-train.jsonl',wrap:!1}}),hs=new y({props:{code:"JTdCJTIycGF0aWVudF9pZCUyMiUzQTE0MTc4MCUyQyUyMmRydWdOYW1lJTIyJTNBJTIyRXNjaXRhbG9wcmFtJTIyJTJDJTIyY29uZGl0aW9uJTIyJTNBJTIyZGVwcmVzc2lvbiUyMiUyQyUyMnJldmlldyUyMiUzQSUyMiU1QyUyMkklMjBzZWVtZWQlMjB0byUyMGV4cGVyaWVuY2UlMjB0aGUlMjByZWd1bGFyJTIwc2lkZSUyMGVmZmVjdHMlMjBvZiUyMExFWEFQUk8lMkMlMjBpbnNvbW5pYSUyQyUyMGxvdyUyMHNleCUyMGRyaXZlJTJDJTIwc2xlZXBpbmVzcyUyMGR1cmluZyUyMHRoZSUyMGRheS4lMjBJJTIwYW0lMjB0YWtpbmclMjBpdCUyMGF0JTIwbmlnaHQlMjBiZWNhdXNlJTIwbXklMjBkb2N0b3IlMjBzYWlkJTIwaWYlMjBpdCUyMG1hZGUlMjBtZSUyMHRpcmVkJTIwdG8lMjB0YWtlJTIwaXQlMjBhdCUyMG5pZ2h0LiUyMEklMjBhc3N1bWVkJTIwaXQlMjB3b3VsZCUyMGFuZCUyMHN0YXJ0ZWQlMjBvdXQlMjB0YWtpbmclMjBpdCUyMGF0JTIwbmlnaHQuJTIwU3RyYW5nZSUyMGRyZWFtcyUyQyUyMHNvbWUlMjBwbGVhc2FudC4lMjBJJTIwd2FzJTIwZGlhZ25vc2VkJTIwd2l0aCUyMGZpYnJvbXlhbGdpYS4lMjBTZWVtcyUyMHRvJTIwYmUlMjBoZWxwaW5nJTIwd2l0aCUyMHRoZSUyMHBhaW4uJTIwSGF2ZSUyMGhhZCUyMGFueGlldHklMjBhbmQlMjBkZXByZXNzaW9uJTIwaW4lMjBteSUyMGZhbWlseSUyQyUyMGFuZCUyMGhhdmUlMjB0cmllZCUyMHF1aXRlJTIwYSUyMGZldyUyMG90aGVyJTIwbWVkaWNhdGlvbnMlMjB0aGF0JTIwaGF2ZW4ndCUyMHdvcmtlZC4lMjBPbmx5JTIwaGF2ZSUyMGJlZW4lMjBvbiUyMGl0JTIwZm9yJTIwdHdvJTIwd2Vla3MlMjBidXQlMjBmZWVsJTIwbW9yZSUyMHBvc2l0aXZlJTIwaW4lMjBteSUyMG1pbmQlMkMlMjB3YW50JTIwdG8lMjBhY2NvbXBsaXNoJTIwbW9yZSUyMGluJTIwbXklMjBsaWZlLiUyMEhvcGVmdWxseSUyMHRoZSUyMHNpZGUlMjBlZmZlY3RzJTIwd2lsbCUyMGR3aW5kbGUlMjBhd2F5JTJDJTIwd29ydGglMjBpdCUyMHRvJTIwc3RpY2slMjB3aXRoJTIwaXQlMjBmcm9tJTIwaGVhcmluZyUyMG90aGVycyUyMHJlc3BvbnNlcy4lMjBHcmVhdCUyMG1lZGljYXRpb24uJTVDJTIyJTIyJTJDJTIycmF0aW5nJTIyJTNBOS4wJTJDJTIyZGF0ZSUyMiUzQSUyMk1heSUyMDI5JTJDJTIwMjAxMSUyMiUyQyUyMnVzZWZ1bENvdW50JTIyJTNBMTAlMkMlMjJyZXZpZXdfbGVuZ3RoJTIyJTNBMTI1JTdE",highlighted:'{<span class="hljs-string">&quot;patient_id&quot;</span>:<span class="hljs-number">141780</span>,<span class="hljs-string">&quot;drugName&quot;</span>:<span class="hljs-string">&quot;Escitalopram&quot;</span>,<span class="hljs-string">&quot;condition&quot;</span>:<span class="hljs-string">&quot;depression&quot;</span>,<span class="hljs-string">&quot;review&quot;</span>:<span class="hljs-string">&quot;\\&quot;I seemed to experience the regular side effects of LEXAPRO, insomnia, low sex drive, sleepiness during the day. I am taking it at night because my doctor said if it made me tired to take it at night. I assumed it would and started out taking it at night. Strange dreams, some pleasant. I was diagnosed with fibromyalgia. Seems to be helping with the pain. Have had anxiety and depression in my family, and have tried quite a few other medications that haven&#x27;t worked. Only have been on it for two weeks but feel more positive in my mind, want to accomplish more in my life. Hopefully the side effects will dwindle away, worth it to stick with it from hearing others responses. Great medication.\\&quot;&quot;</span>,<span class="hljs-string">&quot;rating&quot;</span>:<span class="hljs-number">9.0</span>,<span class="hljs-string">&quot;date&quot;</span>:<span class="hljs-string">&quot;May 29, 2011&quot;</span>,<span class="hljs-string">&quot;usefulCount&quot;</span>:<span class="hljs-number">10</span>,<span class="hljs-string">&quot;review_length&quot;</span>:<span class="hljs-number">125</span>}',wrap:!1}}),Ms=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYWluJTIyJTNBJTIwJTIyZHJ1Zy1yZXZpZXdzLXRyYWluLmpzb25sJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFsaWRhdGlvbiUyMiUzQSUyMCUyMmRydWctcmV2aWV3cy12YWxpZGF0aW9uLmpzb25sJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGVzdCUyMiUzQSUyMCUyMmRydWctcmV2aWV3cy10ZXN0Lmpzb25sJTIyJTJDJTBBJTdEJTBBZHJ1Z19kYXRhc2V0X3JlbG9hZGVkJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmpzb24lMjIlMkMlMjBkYXRhX2ZpbGVzJTNEZGF0YV9maWxlcyk=",highlighted:`data_files = {
    <span class="hljs-string">&quot;train&quot;</span>: <span class="hljs-string">&quot;drug-reviews-train.jsonl&quot;</span>,
    <span class="hljs-string">&quot;validation&quot;</span>: <span class="hljs-string">&quot;drug-reviews-validation.jsonl&quot;</span>,
    <span class="hljs-string">&quot;test&quot;</span>: <span class="hljs-string">&quot;drug-reviews-test.jsonl&quot;</span>,
}
drug_dataset_reloaded = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=data_files)`,wrap:!1}}),{c(){m=i("meta"),J=l(),w=i("p"),f=l(),p(V.$$.fragment),Us=l(),p(_.$$.fragment),js=l(),X=i("p"),X.textContent=fn,bs=l(),p(W.$$.fragment),gs=l(),p(B.$$.fragment),$s=l(),Q=i("p"),Q.innerHTML=Tn,Cs=l(),R=i("p"),R.innerHTML=Un,Is=l(),N=i("p"),N.innerHTML=jn,xs=l(),p(H.$$.fragment),Zs=l(),z=i("p"),z.innerHTML=bn,ks=l(),p(Y.$$.fragment),vs=l(),F=i("p"),F.innerHTML=gn,Gs=l(),p(A.$$.fragment),Vs=l(),p(D.$$.fragment),_s=l(),E=i("p"),E.innerHTML=$n,Xs=l(),S=i("ul"),S.innerHTML=Cn,Ws=l(),q=i("p"),q.innerHTML=In,Bs=l(),p(L.$$.fragment),Qs=l(),P=i("p"),P.innerHTML=xn,Rs=l(),p(K.$$.fragment),Ns=l(),p(O.$$.fragment),Hs=l(),p(b.$$.fragment),zs=l(),ee=i("p"),ee.innerHTML=Zn,Ys=l(),p(te.$$.fragment),Fs=l(),p(se.$$.fragment),As=l(),ae=i("p"),ae.innerHTML=kn,Ds=l(),p(le.$$.fragment),Es=l(),ne=i("p"),ne.innerHTML=vn,Ss=l(),p(ie.$$.fragment),qs=l(),re=i("p"),re.innerHTML=Gn,Ls=l(),p(oe.$$.fragment),Ps=l(),pe=i("p"),pe.textContent=Vn,Ks=l(),p(de.$$.fragment),Os=l(),p(ce.$$.fragment),ea=l(),he=i("p"),he.textContent=_n,ta=l(),p(ue.$$.fragment),sa=l(),p(Me.$$.fragment),aa=l(),me=i("p"),me.innerHTML=Xn,la=l(),p(ye.$$.fragment),na=l(),we=i("p"),we.innerHTML=Wn,ia=l(),p(Je.$$.fragment),ra=l(),p(fe.$$.fragment),oa=l(),Te=i("p"),Te.textContent=Bn,pa=l(),p(Ue.$$.fragment),da=l(),je=i("p"),je.textContent=Qn,ca=l(),be=i("p"),be.textContent=Rn,ha=l(),p(ge.$$.fragment),ua=l(),$e=i("p"),$e.innerHTML=Nn,Ma=l(),p(Ce.$$.fragment),ma=l(),p(Ie.$$.fragment),ya=l(),xe=i("p"),xe.innerHTML=Hn,wa=l(),p(Ze.$$.fragment),Ja=l(),p(ke.$$.fragment),fa=l(),ve=i("p"),ve.textContent=zn,Ta=l(),p(g.$$.fragment),Ua=l(),Ge=i("p"),Ge.innerHTML=Yn,ja=l(),p(Ve.$$.fragment),ba=l(),p(_e.$$.fragment),ga=l(),Xe=i("p"),Xe.textContent=Fn,$a=l(),p($.$$.fragment),Ca=l(),We=i("p"),We.innerHTML=An,Ia=l(),p(Be.$$.fragment),xa=l(),p(Qe.$$.fragment),Za=l(),Re=i("p"),Re.innerHTML=Dn,ka=l(),p(Ne.$$.fragment),va=l(),He=i("p"),He.innerHTML=En,Ga=l(),p(ze.$$.fragment),Va=l(),Ye=i("p"),Ye.innerHTML=Sn,_a=l(),Fe=i("p"),Fe.innerHTML=qn,Xa=l(),p(Ae.$$.fragment),Wa=l(),De=i("p"),De.innerHTML=Ln,Ba=l(),Ee=i("p"),Ee.innerHTML=Pn,Qa=l(),p(Se.$$.fragment),Ra=l(),qe=i("p"),qe.innerHTML=Kn,Na=l(),p(Le.$$.fragment),Ha=l(),Pe=i("p"),Pe.innerHTML=On,za=l(),p(C.$$.fragment),Ya=l(),Ke=i("p"),Ke.textContent=ei,Fa=l(),Oe=i("table"),Oe.innerHTML=ti,Aa=l(),et=i("p"),et.innerHTML=si,Da=l(),tt=i("p"),tt.textContent=ai,Ea=l(),st=i("p"),st.innerHTML=li,Sa=l(),p(at.$$.fragment),qa=l(),lt=i("p"),lt.textContent=ni,La=l(),nt=i("table"),nt.innerHTML=ii,Pa=l(),it=i("p"),it.innerHTML=ri,Ka=l(),p(I.$$.fragment),Oa=l(),rt=i("p"),rt.innerHTML=oi,el=l(),p(x.$$.fragment),tl=l(),ot=i("p"),ot.innerHTML=pi,sl=l(),p(pt.$$.fragment),al=l(),dt=i("p"),dt.innerHTML=di,ll=l(),p(ct.$$.fragment),nl=l(),p(ht.$$.fragment),il=l(),ut=i("p"),ut.textContent=ci,rl=l(),p(Mt.$$.fragment),ol=l(),p(mt.$$.fragment),pl=l(),yt=i("p"),yt.innerHTML=hi,dl=l(),wt=i("p"),wt.innerHTML=ui,cl=l(),p(Jt.$$.fragment),hl=l(),ft=i("p"),ft.textContent=Mi,ul=l(),p(Tt.$$.fragment),Ml=l(),p(Ut.$$.fragment),ml=l(),jt=i("p"),jt.innerHTML=mi,yl=l(),p(bt.$$.fragment),wl=l(),gt=i("p"),gt.innerHTML=yi,Jl=l(),p($t.$$.fragment),fl=l(),p(Ct.$$.fragment),Tl=l(),It=i("p"),It.textContent=wi,Ul=l(),xt=i("p"),xt.innerHTML=Ji,jl=l(),p(Zt.$$.fragment),bl=l(),p(kt.$$.fragment),gl=l(),vt=i("p"),vt.innerHTML=fi,$l=l(),p(Gt.$$.fragment),Cl=l(),Vt=i("p"),Vt.innerHTML=Ti,Il=l(),p(_t.$$.fragment),xl=l(),U=i("table"),U.innerHTML=Ui,Zl=l(),Xt=i("p"),Xt.innerHTML=ji,kl=l(),p(Wt.$$.fragment),vl=l(),p(Z.$$.fragment),Gl=l(),Bt=i("p"),Bt.innerHTML=bi,Vl=l(),p(Qt.$$.fragment),_l=l(),j=i("table"),j.innerHTML=gi,Xl=l(),Rt=i("p"),Rt.innerHTML=$i,Wl=l(),p(Nt.$$.fragment),Bl=l(),p(Ht.$$.fragment),Ql=l(),p(k.$$.fragment),Rl=l(),zt=i("p"),zt.innerHTML=Ci,Nl=l(),p(Yt.$$.fragment),Hl=l(),p(Ft.$$.fragment),zl=l(),At=i("p"),At.textContent=Ii,Yl=l(),Dt=i("p"),Dt.innerHTML=xi,Fl=l(),p(Et.$$.fragment),Al=l(),p(St.$$.fragment),Dl=l(),qt=i("p"),qt.innerHTML=Zi,El=l(),p(Lt.$$.fragment),Sl=l(),p(Pt.$$.fragment),ql=l(),Kt=i("p"),Kt.textContent=ki,Ll=l(),Ot=i("table"),Ot.innerHTML=vi,Pl=l(),es=i("p"),es.textContent=Gi,Kl=l(),p(ts.$$.fragment),Ol=l(),ss=i("p"),ss.textContent=Vi,en=l(),p(as.$$.fragment),tn=l(),ls=i("p"),ls.innerHTML=_i,sn=l(),ns=i("p"),ns.innerHTML=Xi,an=l(),p(is.$$.fragment),ln=l(),p(rs.$$.fragment),nn=l(),os=i("p"),os.innerHTML=Wi,rn=l(),p(ps.$$.fragment),on=l(),ds=i("p"),ds.innerHTML=Bi,pn=l(),p(cs.$$.fragment),dn=l(),p(hs.$$.fragment),cn=l(),us=i("p"),us.innerHTML=Qi,hn=l(),p(Ms.$$.fragment),un=l(),ms=i("p"),ms.textContent=Ri,Mn=l(),ys=i("ol"),ys.innerHTML=Ni,mn=l(),ws=i("p"),ws.textContent=Hi,yn=l(),Ts=i("p"),this.h()},l(e){const t=tr("svelte-u9bgzb",document.head);m=r(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),w=r(e,"P",{}),Li(w).forEach(s),f=n(e),d(V.$$.fragment,e),Us=n(e),d(_.$$.fragment,e),js=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-csrm5s"&&(X.textContent=fn),bs=n(e),d(W.$$.fragment,e),gs=n(e),d(B.$$.fragment,e),$s=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-jlvg65"&&(Q.innerHTML=Tn),Cs=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-12g7hz8"&&(R.innerHTML=Un),Is=n(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-l34lgx"&&(N.innerHTML=jn),xs=n(e),d(H.$$.fragment,e),Zs=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-a5hhan"&&(z.innerHTML=bn),ks=n(e),d(Y.$$.fragment,e),vs=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-19pmwsq"&&(F.innerHTML=gn),Gs=n(e),d(A.$$.fragment,e),Vs=n(e),d(D.$$.fragment,e),_s=n(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1lu6uwi"&&(E.innerHTML=$n),Xs=n(e),S=r(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-uo4x4c"&&(S.innerHTML=Cn),Ws=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-m23ty6"&&(q.innerHTML=In),Bs=n(e),d(L.$$.fragment,e),Qs=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-mrvkrq"&&(P.innerHTML=xn),Rs=n(e),d(K.$$.fragment,e),Ns=n(e),d(O.$$.fragment,e),Hs=n(e),d(b.$$.fragment,e),zs=n(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1y66o8n"&&(ee.innerHTML=Zn),Ys=n(e),d(te.$$.fragment,e),Fs=n(e),d(se.$$.fragment,e),As=n(e),ae=r(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1waxken"&&(ae.innerHTML=kn),Ds=n(e),d(le.$$.fragment,e),Es=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1h72a36"&&(ne.innerHTML=vn),Ss=n(e),d(ie.$$.fragment,e),qs=n(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-152af7g"&&(re.innerHTML=Gn),Ls=n(e),d(oe.$$.fragment,e),Ps=n(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-19khtc4"&&(pe.textContent=Vn),Ks=n(e),d(de.$$.fragment,e),Os=n(e),d(ce.$$.fragment,e),ea=n(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1kpyk2q"&&(he.textContent=_n),ta=n(e),d(ue.$$.fragment,e),sa=n(e),d(Me.$$.fragment,e),aa=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1hwcaz8"&&(me.innerHTML=Xn),la=n(e),d(ye.$$.fragment,e),na=n(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1cwj05l"&&(we.innerHTML=Wn),ia=n(e),d(Je.$$.fragment,e),ra=n(e),d(fe.$$.fragment,e),oa=n(e),Te=r(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-1k0j401"&&(Te.textContent=Bn),pa=n(e),d(Ue.$$.fragment,e),da=n(e),je=r(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-74pc19"&&(je.textContent=Qn),ca=n(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-658p1o"&&(be.textContent=Rn),ha=n(e),d(ge.$$.fragment,e),ua=n(e),$e=r(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-wcvbz5"&&($e.innerHTML=Nn),Ma=n(e),d(Ce.$$.fragment,e),ma=n(e),d(Ie.$$.fragment,e),ya=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-150z39c"&&(xe.innerHTML=Hn),wa=n(e),d(Ze.$$.fragment,e),Ja=n(e),d(ke.$$.fragment,e),fa=n(e),ve=r(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-12gej8c"&&(ve.textContent=zn),Ta=n(e),d(g.$$.fragment,e),Ua=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-q8f22k"&&(Ge.innerHTML=Yn),ja=n(e),d(Ve.$$.fragment,e),ba=n(e),d(_e.$$.fragment,e),ga=n(e),Xe=r(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-qf4tho"&&(Xe.textContent=Fn),$a=n(e),d($.$$.fragment,e),Ca=n(e),We=r(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-s0jr19"&&(We.innerHTML=An),Ia=n(e),d(Be.$$.fragment,e),xa=n(e),d(Qe.$$.fragment,e),Za=n(e),Re=r(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-j86005"&&(Re.innerHTML=Dn),ka=n(e),d(Ne.$$.fragment,e),va=n(e),He=r(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-1ufj8ue"&&(He.innerHTML=En),Ga=n(e),d(ze.$$.fragment,e),Va=n(e),Ye=r(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1k2bbkt"&&(Ye.innerHTML=Sn),_a=n(e),Fe=r(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-832j8"&&(Fe.innerHTML=qn),Xa=n(e),d(Ae.$$.fragment,e),Wa=n(e),De=r(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-19m12hl"&&(De.innerHTML=Ln),Ba=n(e),Ee=r(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-1kilt67"&&(Ee.innerHTML=Pn),Qa=n(e),d(Se.$$.fragment,e),Ra=n(e),qe=r(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1bqlxuk"&&(qe.innerHTML=Kn),Na=n(e),d(Le.$$.fragment,e),Ha=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),o(Pe)!=="svelte-1lb82s7"&&(Pe.innerHTML=On),za=n(e),d(C.$$.fragment,e),Ya=n(e),Ke=r(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-ygrf9"&&(Ke.textContent=ei),Fa=n(e),Oe=r(e,"TABLE",{"data-svelte-h":!0}),o(Oe)!=="svelte-1yr1fn7"&&(Oe.innerHTML=ti),Aa=n(e),et=r(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-s44f11"&&(et.innerHTML=si),Da=n(e),tt=r(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1h1vu44"&&(tt.textContent=ai),Ea=n(e),st=r(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-14vr73n"&&(st.innerHTML=li),Sa=n(e),d(at.$$.fragment,e),qa=n(e),lt=r(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-1m191hs"&&(lt.textContent=ni),La=n(e),nt=r(e,"TABLE",{"data-svelte-h":!0}),o(nt)!=="svelte-psfvtk"&&(nt.innerHTML=ii),Pa=n(e),it=r(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1e2c3j6"&&(it.innerHTML=ri),Ka=n(e),d(I.$$.fragment,e),Oa=n(e),rt=r(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-6vt52l"&&(rt.innerHTML=oi),el=n(e),d(x.$$.fragment,e),tl=n(e),ot=r(e,"P",{"data-svelte-h":!0}),o(ot)!=="svelte-4wkdqq"&&(ot.innerHTML=pi),sl=n(e),d(pt.$$.fragment,e),al=n(e),dt=r(e,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-191vd7q"&&(dt.innerHTML=di),ll=n(e),d(ct.$$.fragment,e),nl=n(e),d(ht.$$.fragment,e),il=n(e),ut=r(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-g9hgs2"&&(ut.textContent=ci),rl=n(e),d(Mt.$$.fragment,e),ol=n(e),d(mt.$$.fragment,e),pl=n(e),yt=r(e,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-11vbcn0"&&(yt.innerHTML=hi),dl=n(e),wt=r(e,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1t3dz9v"&&(wt.innerHTML=ui),cl=n(e),d(Jt.$$.fragment,e),hl=n(e),ft=r(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1xolhbu"&&(ft.textContent=Mi),ul=n(e),d(Tt.$$.fragment,e),Ml=n(e),d(Ut.$$.fragment,e),ml=n(e),jt=r(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-kj2250"&&(jt.innerHTML=mi),yl=n(e),d(bt.$$.fragment,e),wl=n(e),gt=r(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-eja9ii"&&(gt.innerHTML=yi),Jl=n(e),d($t.$$.fragment,e),fl=n(e),d(Ct.$$.fragment,e),Tl=n(e),It=r(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-mzwmkr"&&(It.textContent=wi),Ul=n(e),xt=r(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1k8jp83"&&(xt.innerHTML=Ji),jl=n(e),d(Zt.$$.fragment,e),bl=n(e),d(kt.$$.fragment,e),gl=n(e),vt=r(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-wocx06"&&(vt.innerHTML=fi),$l=n(e),d(Gt.$$.fragment,e),Cl=n(e),Vt=r(e,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-yi1dmj"&&(Vt.innerHTML=Ti),Il=n(e),d(_t.$$.fragment,e),xl=n(e),U=r(e,"TABLE",{border:!0,class:!0,"data-svelte-h":!0}),o(U)!=="svelte-fhhlil"&&(U.innerHTML=Ui),Zl=n(e),Xt=r(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-hi3vxr"&&(Xt.innerHTML=ji),kl=n(e),d(Wt.$$.fragment,e),vl=n(e),d(Z.$$.fragment,e),Gl=n(e),Bt=r(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-1g8bv72"&&(Bt.innerHTML=bi),Vl=n(e),d(Qt.$$.fragment,e),_l=n(e),j=r(e,"TABLE",{border:!0,class:!0,"data-svelte-h":!0}),o(j)!=="svelte-10crns6"&&(j.innerHTML=gi),Xl=n(e),Rt=r(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-1tw1fcp"&&(Rt.innerHTML=$i),Wl=n(e),d(Nt.$$.fragment,e),Bl=n(e),d(Ht.$$.fragment,e),Ql=n(e),d(k.$$.fragment,e),Rl=n(e),zt=r(e,"P",{"data-svelte-h":!0}),o(zt)!=="svelte-1u21wta"&&(zt.innerHTML=Ci),Nl=n(e),d(Yt.$$.fragment,e),Hl=n(e),d(Ft.$$.fragment,e),zl=n(e),At=r(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-lo3228"&&(At.textContent=Ii),Yl=n(e),Dt=r(e,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-1j7zkql"&&(Dt.innerHTML=xi),Fl=n(e),d(Et.$$.fragment,e),Al=n(e),d(St.$$.fragment,e),Dl=n(e),qt=r(e,"P",{"data-svelte-h":!0}),o(qt)!=="svelte-dwzni3"&&(qt.innerHTML=Zi),El=n(e),d(Lt.$$.fragment,e),Sl=n(e),d(Pt.$$.fragment,e),ql=n(e),Kt=r(e,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-md19k3"&&(Kt.textContent=ki),Ll=n(e),Ot=r(e,"TABLE",{"data-svelte-h":!0}),o(Ot)!=="svelte-pxl7xx"&&(Ot.innerHTML=vi),Pl=n(e),es=r(e,"P",{"data-svelte-h":!0}),o(es)!=="svelte-161r97v"&&(es.textContent=Gi),Kl=n(e),d(ts.$$.fragment,e),Ol=n(e),ss=r(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1w7teaf"&&(ss.textContent=Vi),en=n(e),d(as.$$.fragment,e),tn=n(e),ls=r(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-13499wg"&&(ls.innerHTML=_i),sn=n(e),ns=r(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1wl7w13"&&(ns.innerHTML=Xi),an=n(e),d(is.$$.fragment,e),ln=n(e),d(rs.$$.fragment,e),nn=n(e),os=r(e,"P",{"data-svelte-h":!0}),o(os)!=="svelte-1vgicsd"&&(os.innerHTML=Wi),rn=n(e),d(ps.$$.fragment,e),on=n(e),ds=r(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-1k6c8zy"&&(ds.innerHTML=Bi),pn=n(e),d(cs.$$.fragment,e),dn=n(e),d(hs.$$.fragment,e),cn=n(e),us=r(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1gqwxbn"&&(us.innerHTML=Qi),hn=n(e),d(Ms.$$.fragment,e),un=n(e),ms=r(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-7u7x7l"&&(ms.textContent=Ri),Mn=n(e),ys=r(e,"OL",{"data-svelte-h":!0}),o(ys)!=="svelte-1dyf3ap"&&(ys.innerHTML=Ni),mn=n(e),ws=r(e,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-125w4rf"&&(ws.textContent=Hi),yn=n(e),Ts=r(e,"P",{}),Li(Ts).forEach(s),this.h()},h(){fs(m,"name","hf:doc:metadata"),fs(m,"content",ur),fs(U,"border","1"),fs(U,"class","dataframe"),fs(j,"border","1"),fs(j,"class","dataframe")},m(e,t){sr(document.head,m),a(e,J,t),a(e,w,t),a(e,f,t),c(V,e,t),a(e,Us,t),c(_,e,t),a(e,js,t),a(e,X,t),a(e,bs,t),c(W,e,t),a(e,gs,t),c(B,e,t),a(e,$s,t),a(e,Q,t),a(e,Cs,t),a(e,R,t),a(e,Is,t),a(e,N,t),a(e,xs,t),c(H,e,t),a(e,Zs,t),a(e,z,t),a(e,ks,t),c(Y,e,t),a(e,vs,t),a(e,F,t),a(e,Gs,t),c(A,e,t),a(e,Vs,t),c(D,e,t),a(e,_s,t),a(e,E,t),a(e,Xs,t),a(e,S,t),a(e,Ws,t),a(e,q,t),a(e,Bs,t),c(L,e,t),a(e,Qs,t),a(e,P,t),a(e,Rs,t),c(K,e,t),a(e,Ns,t),c(O,e,t),a(e,Hs,t),c(b,e,t),a(e,zs,t),a(e,ee,t),a(e,Ys,t),c(te,e,t),a(e,Fs,t),c(se,e,t),a(e,As,t),a(e,ae,t),a(e,Ds,t),c(le,e,t),a(e,Es,t),a(e,ne,t),a(e,Ss,t),c(ie,e,t),a(e,qs,t),a(e,re,t),a(e,Ls,t),c(oe,e,t),a(e,Ps,t),a(e,pe,t),a(e,Ks,t),c(de,e,t),a(e,Os,t),c(ce,e,t),a(e,ea,t),a(e,he,t),a(e,ta,t),c(ue,e,t),a(e,sa,t),c(Me,e,t),a(e,aa,t),a(e,me,t),a(e,la,t),c(ye,e,t),a(e,na,t),a(e,we,t),a(e,ia,t),c(Je,e,t),a(e,ra,t),c(fe,e,t),a(e,oa,t),a(e,Te,t),a(e,pa,t),c(Ue,e,t),a(e,da,t),a(e,je,t),a(e,ca,t),a(e,be,t),a(e,ha,t),c(ge,e,t),a(e,ua,t),a(e,$e,t),a(e,Ma,t),c(Ce,e,t),a(e,ma,t),c(Ie,e,t),a(e,ya,t),a(e,xe,t),a(e,wa,t),c(Ze,e,t),a(e,Ja,t),c(ke,e,t),a(e,fa,t),a(e,ve,t),a(e,Ta,t),c(g,e,t),a(e,Ua,t),a(e,Ge,t),a(e,ja,t),c(Ve,e,t),a(e,ba,t),c(_e,e,t),a(e,ga,t),a(e,Xe,t),a(e,$a,t),c($,e,t),a(e,Ca,t),a(e,We,t),a(e,Ia,t),c(Be,e,t),a(e,xa,t),c(Qe,e,t),a(e,Za,t),a(e,Re,t),a(e,ka,t),c(Ne,e,t),a(e,va,t),a(e,He,t),a(e,Ga,t),c(ze,e,t),a(e,Va,t),a(e,Ye,t),a(e,_a,t),a(e,Fe,t),a(e,Xa,t),c(Ae,e,t),a(e,Wa,t),a(e,De,t),a(e,Ba,t),a(e,Ee,t),a(e,Qa,t),c(Se,e,t),a(e,Ra,t),a(e,qe,t),a(e,Na,t),c(Le,e,t),a(e,Ha,t),a(e,Pe,t),a(e,za,t),c(C,e,t),a(e,Ya,t),a(e,Ke,t),a(e,Fa,t),a(e,Oe,t),a(e,Aa,t),a(e,et,t),a(e,Da,t),a(e,tt,t),a(e,Ea,t),a(e,st,t),a(e,Sa,t),c(at,e,t),a(e,qa,t),a(e,lt,t),a(e,La,t),a(e,nt,t),a(e,Pa,t),a(e,it,t),a(e,Ka,t),c(I,e,t),a(e,Oa,t),a(e,rt,t),a(e,el,t),c(x,e,t),a(e,tl,t),a(e,ot,t),a(e,sl,t),c(pt,e,t),a(e,al,t),a(e,dt,t),a(e,ll,t),c(ct,e,t),a(e,nl,t),c(ht,e,t),a(e,il,t),a(e,ut,t),a(e,rl,t),c(Mt,e,t),a(e,ol,t),c(mt,e,t),a(e,pl,t),a(e,yt,t),a(e,dl,t),a(e,wt,t),a(e,cl,t),c(Jt,e,t),a(e,hl,t),a(e,ft,t),a(e,ul,t),c(Tt,e,t),a(e,Ml,t),c(Ut,e,t),a(e,ml,t),a(e,jt,t),a(e,yl,t),c(bt,e,t),a(e,wl,t),a(e,gt,t),a(e,Jl,t),c($t,e,t),a(e,fl,t),c(Ct,e,t),a(e,Tl,t),a(e,It,t),a(e,Ul,t),a(e,xt,t),a(e,jl,t),c(Zt,e,t),a(e,bl,t),c(kt,e,t),a(e,gl,t),a(e,vt,t),a(e,$l,t),c(Gt,e,t),a(e,Cl,t),a(e,Vt,t),a(e,Il,t),c(_t,e,t),a(e,xl,t),a(e,U,t),a(e,Zl,t),a(e,Xt,t),a(e,kl,t),c(Wt,e,t),a(e,vl,t),c(Z,e,t),a(e,Gl,t),a(e,Bt,t),a(e,Vl,t),c(Qt,e,t),a(e,_l,t),a(e,j,t),a(e,Xl,t),a(e,Rt,t),a(e,Wl,t),c(Nt,e,t),a(e,Bl,t),c(Ht,e,t),a(e,Ql,t),c(k,e,t),a(e,Rl,t),a(e,zt,t),a(e,Nl,t),c(Yt,e,t),a(e,Hl,t),c(Ft,e,t),a(e,zl,t),a(e,At,t),a(e,Yl,t),a(e,Dt,t),a(e,Fl,t),c(Et,e,t),a(e,Al,t),c(St,e,t),a(e,Dl,t),a(e,qt,t),a(e,El,t),c(Lt,e,t),a(e,Sl,t),c(Pt,e,t),a(e,ql,t),a(e,Kt,t),a(e,Ll,t),a(e,Ot,t),a(e,Pl,t),a(e,es,t),a(e,Kl,t),c(ts,e,t),a(e,Ol,t),a(e,ss,t),a(e,en,t),c(as,e,t),a(e,tn,t),a(e,ls,t),a(e,sn,t),a(e,ns,t),a(e,an,t),c(is,e,t),a(e,ln,t),c(rs,e,t),a(e,nn,t),a(e,os,t),a(e,rn,t),c(ps,e,t),a(e,on,t),a(e,ds,t),a(e,pn,t),c(cs,e,t),a(e,dn,t),c(hs,e,t),a(e,cn,t),a(e,us,t),a(e,hn,t),c(Ms,e,t),a(e,un,t),a(e,ms,t),a(e,Mn,t),a(e,ys,t),a(e,mn,t),a(e,ws,t),a(e,yn,t),a(e,Ts,t),wn=!0},p(e,[t]){const zi={};t&2&&(zi.$$scope={dirty:t,ctx:e}),b.$set(zi);const Yi={};t&2&&(Yi.$$scope={dirty:t,ctx:e}),g.$set(Yi);const Fi={};t&2&&(Fi.$$scope={dirty:t,ctx:e}),$.$set(Fi);const Ai={};t&2&&(Ai.$$scope={dirty:t,ctx:e}),C.$set(Ai);const Di={};t&2&&(Di.$$scope={dirty:t,ctx:e}),I.$set(Di);const Ei={};t&2&&(Ei.$$scope={dirty:t,ctx:e}),x.$set(Ei);const Si={};t&2&&(Si.$$scope={dirty:t,ctx:e}),Z.$set(Si);const qi={};t&2&&(qi.$$scope={dirty:t,ctx:e}),k.$set(qi)},i(e){wn||(h(V.$$.fragment,e),h(_.$$.fragment,e),h(W.$$.fragment,e),h(B.$$.fragment,e),h(H.$$.fragment,e),h(Y.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(L.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),h(b.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(oe.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(fe.$$.fragment,e),h(Ue.$$.fragment,e),h(ge.$$.fragment,e),h(Ce.$$.fragment,e),h(Ie.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(g.$$.fragment,e),h(Ve.$$.fragment,e),h(_e.$$.fragment,e),h($.$$.fragment,e),h(Be.$$.fragment,e),h(Qe.$$.fragment,e),h(Ne.$$.fragment,e),h(ze.$$.fragment,e),h(Ae.$$.fragment,e),h(Se.$$.fragment,e),h(Le.$$.fragment,e),h(C.$$.fragment,e),h(at.$$.fragment,e),h(I.$$.fragment,e),h(x.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(ht.$$.fragment,e),h(Mt.$$.fragment,e),h(mt.$$.fragment,e),h(Jt.$$.fragment,e),h(Tt.$$.fragment,e),h(Ut.$$.fragment,e),h(bt.$$.fragment,e),h($t.$$.fragment,e),h(Ct.$$.fragment,e),h(Zt.$$.fragment,e),h(kt.$$.fragment,e),h(Gt.$$.fragment,e),h(_t.$$.fragment,e),h(Wt.$$.fragment,e),h(Z.$$.fragment,e),h(Qt.$$.fragment,e),h(Nt.$$.fragment,e),h(Ht.$$.fragment,e),h(k.$$.fragment,e),h(Yt.$$.fragment,e),h(Ft.$$.fragment,e),h(Et.$$.fragment,e),h(St.$$.fragment,e),h(Lt.$$.fragment,e),h(Pt.$$.fragment,e),h(ts.$$.fragment,e),h(as.$$.fragment,e),h(is.$$.fragment,e),h(rs.$$.fragment,e),h(ps.$$.fragment,e),h(cs.$$.fragment,e),h(hs.$$.fragment,e),h(Ms.$$.fragment,e),wn=!0)},o(e){u(V.$$.fragment,e),u(_.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(b.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(Je.$$.fragment,e),u(fe.$$.fragment,e),u(Ue.$$.fragment,e),u(ge.$$.fragment,e),u(Ce.$$.fragment,e),u(Ie.$$.fragment,e),u(Ze.$$.fragment,e),u(ke.$$.fragment,e),u(g.$$.fragment,e),u(Ve.$$.fragment,e),u(_e.$$.fragment,e),u($.$$.fragment,e),u(Be.$$.fragment,e),u(Qe.$$.fragment,e),u(Ne.$$.fragment,e),u(ze.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Le.$$.fragment,e),u(C.$$.fragment,e),u(at.$$.fragment,e),u(I.$$.fragment,e),u(x.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(ht.$$.fragment,e),u(Mt.$$.fragment,e),u(mt.$$.fragment,e),u(Jt.$$.fragment,e),u(Tt.$$.fragment,e),u(Ut.$$.fragment,e),u(bt.$$.fragment,e),u($t.$$.fragment,e),u(Ct.$$.fragment,e),u(Zt.$$.fragment,e),u(kt.$$.fragment,e),u(Gt.$$.fragment,e),u(_t.$$.fragment,e),u(Wt.$$.fragment,e),u(Z.$$.fragment,e),u(Qt.$$.fragment,e),u(Nt.$$.fragment,e),u(Ht.$$.fragment,e),u(k.$$.fragment,e),u(Yt.$$.fragment,e),u(Ft.$$.fragment,e),u(Et.$$.fragment,e),u(St.$$.fragment,e),u(Lt.$$.fragment,e),u(Pt.$$.fragment,e),u(ts.$$.fragment,e),u(as.$$.fragment,e),u(is.$$.fragment,e),u(rs.$$.fragment,e),u(ps.$$.fragment,e),u(cs.$$.fragment,e),u(hs.$$.fragment,e),u(Ms.$$.fragment,e),wn=!1},d(e){e&&(s(J),s(w),s(f),s(Us),s(js),s(X),s(bs),s(gs),s($s),s(Q),s(Cs),s(R),s(Is),s(N),s(xs),s(Zs),s(z),s(ks),s(vs),s(F),s(Gs),s(Vs),s(_s),s(E),s(Xs),s(S),s(Ws),s(q),s(Bs),s(Qs),s(P),s(Rs),s(Ns),s(Hs),s(zs),s(ee),s(Ys),s(Fs),s(As),s(ae),s(Ds),s(Es),s(ne),s(Ss),s(qs),s(re),s(Ls),s(Ps),s(pe),s(Ks),s(Os),s(ea),s(he),s(ta),s(sa),s(aa),s(me),s(la),s(na),s(we),s(ia),s(ra),s(oa),s(Te),s(pa),s(da),s(je),s(ca),s(be),s(ha),s(ua),s($e),s(Ma),s(ma),s(ya),s(xe),s(wa),s(Ja),s(fa),s(ve),s(Ta),s(Ua),s(Ge),s(ja),s(ba),s(ga),s(Xe),s($a),s(Ca),s(We),s(Ia),s(xa),s(Za),s(Re),s(ka),s(va),s(He),s(Ga),s(Va),s(Ye),s(_a),s(Fe),s(Xa),s(Wa),s(De),s(Ba),s(Ee),s(Qa),s(Ra),s(qe),s(Na),s(Ha),s(Pe),s(za),s(Ya),s(Ke),s(Fa),s(Oe),s(Aa),s(et),s(Da),s(tt),s(Ea),s(st),s(Sa),s(qa),s(lt),s(La),s(nt),s(Pa),s(it),s(Ka),s(Oa),s(rt),s(el),s(tl),s(ot),s(sl),s(al),s(dt),s(ll),s(nl),s(il),s(ut),s(rl),s(ol),s(pl),s(yt),s(dl),s(wt),s(cl),s(hl),s(ft),s(ul),s(Ml),s(ml),s(jt),s(yl),s(wl),s(gt),s(Jl),s(fl),s(Tl),s(It),s(Ul),s(xt),s(jl),s(bl),s(gl),s(vt),s($l),s(Cl),s(Vt),s(Il),s(xl),s(U),s(Zl),s(Xt),s(kl),s(vl),s(Gl),s(Bt),s(Vl),s(_l),s(j),s(Xl),s(Rt),s(Wl),s(Bl),s(Ql),s(Rl),s(zt),s(Nl),s(Hl),s(zl),s(At),s(Yl),s(Dt),s(Fl),s(Al),s(Dl),s(qt),s(El),s(Sl),s(ql),s(Kt),s(Ll),s(Ot),s(Pl),s(es),s(Kl),s(Ol),s(ss),s(en),s(tn),s(ls),s(sn),s(ns),s(an),s(ln),s(nn),s(os),s(rn),s(on),s(ds),s(pn),s(dn),s(cn),s(us),s(hn),s(un),s(ms),s(Mn),s(ys),s(mn),s(ws),s(yn),s(Ts)),s(m),M(V,e),M(_,e),M(W,e),M(B,e),M(H,e),M(Y,e),M(A,e),M(D,e),M(L,e),M(K,e),M(O,e),M(b,e),M(te,e),M(se,e),M(le,e),M(ie,e),M(oe,e),M(de,e),M(ce,e),M(ue,e),M(Me,e),M(ye,e),M(Je,e),M(fe,e),M(Ue,e),M(ge,e),M(Ce,e),M(Ie,e),M(Ze,e),M(ke,e),M(g,e),M(Ve,e),M(_e,e),M($,e),M(Be,e),M(Qe,e),M(Ne,e),M(ze,e),M(Ae,e),M(Se,e),M(Le,e),M(C,e),M(at,e),M(I,e),M(x,e),M(pt,e),M(ct,e),M(ht,e),M(Mt,e),M(mt,e),M(Jt,e),M(Tt,e),M(Ut,e),M(bt,e),M($t,e),M(Ct,e),M(Zt,e),M(kt,e),M(Gt,e),M(_t,e),M(Wt,e),M(Z,e),M(Qt,e),M(Nt,e),M(Ht,e),M(k,e),M(Yt,e),M(Ft,e),M(Et,e),M(St,e),M(Lt,e),M(Pt,e),M(ts,e),M(as,e),M(is,e),M(rs,e),M(ps,e),M(cs,e),M(hs,e),M(Ms,e)}}}const ur='{"title":"Time to slice and dice","local":"time-to-slice-and-dice","sections":[{"title":"Slicing and dicing our data","local":"slicing-and-dicing-our-data","sections":[],"depth":2},{"title":"Creating new columns","local":"creating-new-columns","sections":[],"depth":2},{"title":"The map() method’s superpowers","local":"the-map-methods-superpowers","sections":[],"depth":2},{"title":"From Dataset s to DataFrame s and back","local":"from-datasets-to-dataframes-and-back","sections":[],"depth":2},{"title":"Creating a validation set","local":"creating-a-validation-set","sections":[],"depth":2},{"title":"Saving a dataset","local":"saving-a-dataset","sections":[],"depth":2}],"depth":1}';function Mr(T){return Ki(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jr extends Oi{constructor(m){super(),er(this,m,Mr,hr,Pi,{})}}export{jr as component};
