import{s as ni,n as ui,o as hi}from"../chunks/scheduler.b108d059.js";import{S as _i,i as fi,g as l,s,r as p,A as gi,h as d,f as r,c as a,j as f,u as m,x as i,k as c,y as xi,a as o,v as n,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as Jl}from"../chunks/CodeBlock.3968c746.js";import{H as g}from"../chunks/Heading.88bfeb84.js";function Ti(Il){let x,gr,_r,xr,T,Tr,b,br,y,Hl="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",yr,v,Fl="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",vr,$,$r,w,kl='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',wr,Mr,Er,M,Cr,E,Pr,C,jl="Base class for feature extractors.",Jr,P,Ll='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Ir,Hr,Fr,J,kr,I,jr,H,zl="Constructs a new FeatureExtractor instance.",Lr,F,Al="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",zr,Ar,Rr,k,Ur,j,Dr,L,Rl="Feature extractor for image models.",Br,z,Ul='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',Wr,A,Dl='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Nr,Gr,Zr,R,Qr,U,Xr,D,Bl="Constructs a new ImageFeatureExtractor instance.",Vr,B,Wl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",Yr,Sr,qr,W,Kr,N,Or,G,Nl=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,eo,Z,Gl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',to,Q,Zl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",ro,oo,so,X,ao,V,lo,Y,Ql="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",io,S,Xl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',co,q,Vl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",po,mo,no,K,uo,O,ho,ee,Yl="Pad the image by a certain amount.",_o,te,Sl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',fo,re,ql="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image.</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",go,xo,To,oe,bo,se,yo,ae,Kl="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",vo,le,Ol='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',$o,de,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",wo,Mo,Eo,ie,Co,ce,Po,pe,td=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,Jo,me,rd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',Io,ne,od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",Ho,Fo,ko,ue,jo,he,Lo,_e,sd="Resizes the image.",zo,fe,ad='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Ao,ge,ld="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",Ro,Uo,Do,xe,Bo,Te,Wo,be,dd="Preprocesses the given image.",No,ye,id='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',Go,ve,cd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",Zo,Qo,Xo,$e,Vo,we,Yo,Me,pd=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,So,Ee,md='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',qo,Ce,nd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Ko,Oo,es,Pe,ts,Je,rs,Ie,ud="Detr Feature Extractor.",os,He,hd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',ss,Fe,_d='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',as,ls,ds,ke,is,je,cs,Le,fd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,ps,ze,gd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',ms,Ae,xd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",ns,us,hs,Re,_s,Ue,fs,De,Td='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',gs,xs,Ts,Be,bs,We,ys,Ne,bd="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",vs,Ge,yd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',$s,Ze,vd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",ws,Ms,Es,Qe,Cs,Xe,Ps,Ve,$d="Checks whether the segment is valid or not.",Js,Ye,wd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',Is,Se,Md="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Hs,Fs,ks,qe,js,Ke,Ls,Oe,Ed="Computes the segments.",zs,et,Cd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',As,tt,Pd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",Rs,Us,Ds,rt,Bs,ot,Ws,st,Jd="Post-process the model output to generate the final panoptic segmentation.",Ns,at,Id='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Gs,lt,Hd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",Zs,Qs,Xs,dt,Vs,it,Ys,ct,Fd="Represents a Processor that extracts features from an input.",Ss,pt,kd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',qs,mt,jd='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',Ks,Os,ea,nt,ta,ut,ra,ht,Ld="Creates a new Processor with the given feature extractor.",oa,_t,zd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",sa,aa,la,ft,da,gt,ia,xt,Ad="Calls the feature_extractor function with the given input.",ca,Tt,Rd='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',pa,bt,Ud="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ma,na,ua,yt,ha,vt,_a,$t,Dd="Represents a WhisperProcessor that extracts features from an audio input.",fa,wt,Bd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',ga,xa,Ta,Mt,ba,Et,ya,Ct,Wd="Calls the feature_extractor function with the given audio input.",va,Pt,Nd='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',$a,Jt,Gd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",wa,Ma,Ea,It,Ca,Ht,Pa,Ft,Zd=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,Ja,kt,Qd="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",Ia,jt,Ha,Lt,Xd="<strong>Example:</strong> Run an image through a processor.",Fa,zt,ka,At,Vd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',ja,La,za,Rt,Aa,Ut,Ra,Dt,Yd="Instantiate one of the processor classes of the library from a pretrained model.",Ua,Bt,Sd=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Da,Wt,qd='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',Ba,Nt,Kd=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,Wa,Na,Ga,Gt,Za,Zt,Qa,Qt,Od="Converts bounding boxes from center format to corners format.",Xa,Xt,ei='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',Va,Vt,ti="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",Ya,Sa,qa,Yt,Ka,St,Oa,qt,ri=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,el,Kt,oi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',tl,rl,ol,Ot,sl,er,al,tr,si='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ll,rr,ai="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",dl,il,cl,or,pl,sr,ml,ar,li='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',nl,lr,di="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",ul,hl,_l,dr,fl,ir,gl,cr,ii='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',xl,pr,ci="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Tl,bl,yl,mr,vl,nr,$l,ur,pi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',wl,hr,mi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td></tr></tbody>",Ml,El,Cl,fr,Pl;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new Jl({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),I=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),U=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),se=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),ce=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),he=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Te=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),we=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),Je=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),je=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Ue=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),We=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),Xe=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),Ke=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),ot=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),it=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),ut=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),gt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),vt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),Et=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),Ht=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),jt=new Jl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),zt=new Jl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ut=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Zt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),St=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),er=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),sr=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),ir=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),nr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){x=l("meta"),gr=s(),_r=l("p"),xr=s(),T=l("a"),Tr=s(),p(b.$$.fragment),br=s(),y=l("p"),y.textContent=Hl,yr=s(),v=l("p"),v.innerHTML=Fl,vr=s(),p($.$$.fragment),$r=s(),w=l("ul"),w.innerHTML=kl,wr=s(),Mr=l("hr"),Er=s(),M=l("a"),Cr=s(),p(E.$$.fragment),Pr=s(),C=l("p"),C.textContent=jl,Jr=s(),P=l("p"),P.innerHTML=Ll,Ir=s(),Hr=l("hr"),Fr=s(),J=l("a"),kr=s(),p(I.$$.fragment),jr=s(),H=l("p"),H.textContent=zl,Lr=s(),F=l("table"),F.innerHTML=Al,zr=s(),Ar=l("hr"),Rr=s(),k=l("a"),Ur=s(),p(j.$$.fragment),Dr=s(),L=l("p"),L.textContent=Rl,Br=s(),z=l("p"),z.innerHTML=Ul,Wr=s(),A=l("ul"),A.innerHTML=Dl,Nr=s(),Gr=l("hr"),Zr=s(),R=l("a"),Qr=s(),p(U.$$.fragment),Xr=s(),D=l("p"),D.textContent=Bl,Vr=s(),B=l("table"),B.innerHTML=Wl,Yr=s(),Sr=l("hr"),qr=s(),W=l("a"),Kr=s(),p(N.$$.fragment),Or=s(),G=l("p"),G.textContent=Nl,eo=s(),Z=l("p"),Z.innerHTML=Gl,to=s(),Q=l("table"),Q.innerHTML=Zl,ro=s(),oo=l("hr"),so=s(),X=l("a"),ao=s(),p(V.$$.fragment),lo=s(),Y=l("p"),Y.textContent=Ql,io=s(),S=l("p"),S.innerHTML=Xl,co=s(),q=l("table"),q.innerHTML=Vl,po=s(),mo=l("hr"),no=s(),K=l("a"),uo=s(),p(O.$$.fragment),ho=s(),ee=l("p"),ee.textContent=Yl,_o=s(),te=l("p"),te.innerHTML=Sl,fo=s(),re=l("table"),re.innerHTML=ql,go=s(),xo=l("hr"),To=s(),oe=l("a"),bo=s(),p(se.$$.fragment),yo=s(),ae=l("p"),ae.innerHTML=Kl,vo=s(),le=l("p"),le.innerHTML=Ol,$o=s(),de=l("table"),de.innerHTML=ed,wo=s(),Mo=l("hr"),Eo=s(),ie=l("a"),Co=s(),p(ce.$$.fragment),Po=s(),pe=l("p"),pe.textContent=td,Jo=s(),me=l("p"),me.innerHTML=rd,Io=s(),ne=l("table"),ne.innerHTML=od,Ho=s(),Fo=l("hr"),ko=s(),ue=l("a"),jo=s(),p(he.$$.fragment),Lo=s(),_e=l("p"),_e.textContent=sd,zo=s(),fe=l("p"),fe.innerHTML=ad,Ao=s(),ge=l("table"),ge.innerHTML=ld,Ro=s(),Uo=l("hr"),Do=s(),xe=l("a"),Bo=s(),p(Te.$$.fragment),Wo=s(),be=l("p"),be.textContent=dd,No=s(),ye=l("p"),ye.innerHTML=id,Go=s(),ve=l("table"),ve.innerHTML=cd,Zo=s(),Qo=l("hr"),Xo=s(),$e=l("a"),Vo=s(),p(we.$$.fragment),Yo=s(),Me=l("p"),Me.textContent=pd,So=s(),Ee=l("p"),Ee.innerHTML=md,qo=s(),Ce=l("table"),Ce.innerHTML=nd,Ko=s(),Oo=l("hr"),es=s(),Pe=l("a"),ts=s(),p(Je.$$.fragment),rs=s(),Ie=l("p"),Ie.textContent=ud,os=s(),He=l("p"),He.innerHTML=hd,ss=s(),Fe=l("ul"),Fe.innerHTML=_d,as=s(),ls=l("hr"),ds=s(),ke=l("a"),is=s(),p(je.$$.fragment),cs=s(),Le=l("p"),Le.textContent=fd,ps=s(),ze=l("p"),ze.innerHTML=gd,ms=s(),Ae=l("table"),Ae.innerHTML=xd,ns=s(),us=l("hr"),hs=s(),Re=l("a"),_s=s(),p(Ue.$$.fragment),fs=s(),De=l("p"),De.innerHTML=Td,gs=s(),xs=l("hr"),Ts=s(),Be=l("a"),bs=s(),p(We.$$.fragment),ys=s(),Ne=l("p"),Ne.innerHTML=bd,vs=s(),Ge=l("p"),Ge.innerHTML=yd,$s=s(),Ze=l("table"),Ze.innerHTML=vd,ws=s(),Ms=l("hr"),Es=s(),Qe=l("a"),Cs=s(),p(Xe.$$.fragment),Ps=s(),Ve=l("p"),Ve.textContent=$d,Js=s(),Ye=l("p"),Ye.innerHTML=wd,Is=s(),Se=l("table"),Se.innerHTML=Md,Hs=s(),Fs=l("hr"),ks=s(),qe=l("a"),js=s(),p(Ke.$$.fragment),Ls=s(),Oe=l("p"),Oe.textContent=Ed,zs=s(),et=l("p"),et.innerHTML=Cd,As=s(),tt=l("table"),tt.innerHTML=Pd,Rs=s(),Us=l("hr"),Ds=s(),rt=l("a"),Bs=s(),p(ot.$$.fragment),Ws=s(),st=l("p"),st.textContent=Jd,Ns=s(),at=l("p"),at.innerHTML=Id,Gs=s(),lt=l("table"),lt.innerHTML=Hd,Zs=s(),Qs=l("hr"),Xs=s(),dt=l("a"),Vs=s(),p(it.$$.fragment),Ys=s(),ct=l("p"),ct.textContent=Fd,Ss=s(),pt=l("p"),pt.innerHTML=kd,qs=s(),mt=l("ul"),mt.innerHTML=jd,Ks=s(),Os=l("hr"),ea=s(),nt=l("a"),ta=s(),p(ut.$$.fragment),ra=s(),ht=l("p"),ht.textContent=Ld,oa=s(),_t=l("table"),_t.innerHTML=zd,sa=s(),aa=l("hr"),la=s(),ft=l("a"),da=s(),p(gt.$$.fragment),ia=s(),xt=l("p"),xt.textContent=Ad,ca=s(),Tt=l("p"),Tt.innerHTML=Rd,pa=s(),bt=l("table"),bt.innerHTML=Ud,ma=s(),na=l("hr"),ua=s(),yt=l("a"),ha=s(),p(vt.$$.fragment),_a=s(),$t=l("p"),$t.textContent=Dd,fa=s(),wt=l("p"),wt.innerHTML=Bd,ga=s(),xa=l("hr"),Ta=s(),Mt=l("a"),ba=s(),p(Et.$$.fragment),ya=s(),Ct=l("p"),Ct.textContent=Wd,va=s(),Pt=l("p"),Pt.innerHTML=Nd,$a=s(),Jt=l("table"),Jt.innerHTML=Gd,wa=s(),Ma=l("hr"),Ea=s(),It=l("a"),Ca=s(),p(Ht.$$.fragment),Pa=s(),Ft=l("p"),Ft.innerHTML=Zd,Ja=s(),kt=l("p"),kt.innerHTML=Qd,Ia=s(),p(jt.$$.fragment),Ha=s(),Lt=l("p"),Lt.innerHTML=Xd,Fa=s(),p(zt.$$.fragment),ka=s(),At=l("p"),At.innerHTML=Vd,ja=s(),La=l("hr"),za=s(),Rt=l("a"),Aa=s(),p(Ut.$$.fragment),Ra=s(),Dt=l("p"),Dt.textContent=Yd,Ua=s(),Bt=l("p"),Bt.innerHTML=Sd,Da=s(),Wt=l("p"),Wt.innerHTML=qd,Ba=s(),Nt=l("table"),Nt.innerHTML=Kd,Wa=s(),Na=l("hr"),Ga=s(),Gt=l("a"),Za=s(),p(Zt.$$.fragment),Qa=s(),Qt=l("p"),Qt.textContent=Od,Xa=s(),Xt=l("p"),Xt.innerHTML=ei,Va=s(),Vt=l("table"),Vt.innerHTML=ti,Ya=s(),Sa=l("hr"),qa=s(),Yt=l("a"),Ka=s(),p(St.$$.fragment),Oa=s(),qt=l("p"),qt.textContent=ri,el=s(),Kt=l("p"),Kt.innerHTML=oi,tl=s(),rl=l("hr"),ol=s(),Ot=l("a"),sl=s(),p(er.$$.fragment),al=s(),tr=l("p"),tr.innerHTML=si,ll=s(),rr=l("table"),rr.innerHTML=ai,dl=s(),il=l("hr"),cl=s(),or=l("a"),pl=s(),p(sr.$$.fragment),ml=s(),ar=l("p"),ar.innerHTML=li,nl=s(),lr=l("table"),lr.innerHTML=di,ul=s(),hl=l("hr"),_l=s(),dr=l("a"),fl=s(),p(ir.$$.fragment),gl=s(),cr=l("p"),cr.innerHTML=ii,xl=s(),pr=l("table"),pr.innerHTML=ci,Tl=s(),bl=l("hr"),yl=s(),mr=l("a"),vl=s(),p(nr.$$.fragment),$l=s(),ur=l("p"),ur.innerHTML=pi,wl=s(),hr=l("table"),hr.innerHTML=mi,Ml=s(),El=l("hr"),Cl=s(),fr=l("p"),this.h()},l(e){const t=gi("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),gr=a(e),_r=d(e,"P",{}),f(_r).forEach(r),xr=a(e),T=d(e,"A",{id:!0,class:!0}),f(T).forEach(r),Tr=a(e),m(b.$$.fragment,e),br=a(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-w0rx8m"&&(y.textContent=Hl),yr=a(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1olsie5"&&(v.innerHTML=Fl),vr=a(e),m($.$$.fragment,e),$r=a(e),w=d(e,"UL",{"data-svelte-h":!0}),i(w)!=="svelte-14hmzap"&&(w.innerHTML=kl),wr=a(e),Mr=d(e,"HR",{}),Er=a(e),M=d(e,"A",{id:!0,class:!0}),f(M).forEach(r),Cr=a(e),m(E.$$.fragment,e),Pr=a(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=jl),Jr=a(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-fac4cj"&&(P.innerHTML=Ll),Ir=a(e),Hr=d(e,"HR",{}),Fr=a(e),J=d(e,"A",{id:!0,class:!0}),f(J).forEach(r),kr=a(e),m(I.$$.fragment,e),jr=a(e),H=d(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-k3m2wg"&&(H.textContent=zl),Lr=a(e),F=d(e,"TABLE",{"data-svelte-h":!0}),i(F)!=="svelte-rd7ds7"&&(F.innerHTML=Al),zr=a(e),Ar=d(e,"HR",{}),Rr=a(e),k=d(e,"A",{id:!0,class:!0}),f(k).forEach(r),Ur=a(e),m(j.$$.fragment,e),Dr=a(e),L=d(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-8k8cys"&&(L.textContent=Rl),Br=a(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-18p52n5"&&(z.innerHTML=Ul),Wr=a(e),A=d(e,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-1ne2ywl"&&(A.innerHTML=Dl),Nr=a(e),Gr=d(e,"HR",{}),Zr=a(e),R=d(e,"A",{id:!0,class:!0}),f(R).forEach(r),Qr=a(e),m(U.$$.fragment,e),Xr=a(e),D=d(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1mp2vol"&&(D.textContent=Bl),Vr=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),i(B)!=="svelte-eb9kev"&&(B.innerHTML=Wl),Yr=a(e),Sr=d(e,"HR",{}),qr=a(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),Kr=a(e),m(N.$$.fragment,e),Or=a(e),G=d(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1q6eyx4"&&(G.textContent=Nl),eo=a(e),Z=d(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ar7q77"&&(Z.innerHTML=Gl),to=a(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),i(Q)!=="svelte-klyf4z"&&(Q.innerHTML=Zl),ro=a(e),oo=d(e,"HR",{}),so=a(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),ao=a(e),m(V.$$.fragment,e),lo=a(e),Y=d(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-7fx89a"&&(Y.textContent=Ql),io=a(e),S=d(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-65os4c"&&(S.innerHTML=Xl),co=a(e),q=d(e,"TABLE",{"data-svelte-h":!0}),i(q)!=="svelte-1dnvwno"&&(q.innerHTML=Vl),po=a(e),mo=d(e,"HR",{}),no=a(e),K=d(e,"A",{id:!0,class:!0}),f(K).forEach(r),uo=a(e),m(O.$$.fragment,e),ho=a(e),ee=d(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1mmkb9p"&&(ee.textContent=Yl),_o=a(e),te=d(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-110o3sn"&&(te.innerHTML=Sl),fo=a(e),re=d(e,"TABLE",{"data-svelte-h":!0}),i(re)!=="svelte-iqjbgm"&&(re.innerHTML=ql),go=a(e),xo=d(e,"HR",{}),To=a(e),oe=d(e,"A",{id:!0,class:!0}),f(oe).forEach(r),bo=a(e),m(se.$$.fragment,e),yo=a(e),ae=d(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-pyd72v"&&(ae.innerHTML=Kl),vo=a(e),le=d(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1isxmg1"&&(le.innerHTML=Ol),$o=a(e),de=d(e,"TABLE",{"data-svelte-h":!0}),i(de)!=="svelte-1e1ka8e"&&(de.innerHTML=ed),wo=a(e),Mo=d(e,"HR",{}),Eo=a(e),ie=d(e,"A",{id:!0,class:!0}),f(ie).forEach(r),Co=a(e),m(ce.$$.fragment,e),Po=a(e),pe=d(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-8leww2"&&(pe.textContent=td),Jo=a(e),me=d(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-eqxqo6"&&(me.innerHTML=rd),Io=a(e),ne=d(e,"TABLE",{"data-svelte-h":!0}),i(ne)!=="svelte-1n361ub"&&(ne.innerHTML=od),Ho=a(e),Fo=d(e,"HR",{}),ko=a(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),jo=a(e),m(he.$$.fragment,e),Lo=a(e),_e=d(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-5iny39"&&(_e.textContent=sd),zo=a(e),fe=d(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-ar7q77"&&(fe.innerHTML=ad),Ao=a(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),i(ge)!=="svelte-d8vk38"&&(ge.innerHTML=ld),Ro=a(e),Uo=d(e,"HR",{}),Do=a(e),xe=d(e,"A",{id:!0,class:!0}),f(xe).forEach(r),Bo=a(e),m(Te.$$.fragment,e),Wo=a(e),be=d(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-10g8wi9"&&(be.textContent=dd),No=a(e),ye=d(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-cd20o3"&&(ye.innerHTML=id),Go=a(e),ve=d(e,"TABLE",{"data-svelte-h":!0}),i(ve)!=="svelte-1773mps"&&(ve.innerHTML=cd),Zo=a(e),Qo=d(e,"HR",{}),Xo=a(e),$e=d(e,"A",{id:!0,class:!0}),f($e).forEach(r),Vo=a(e),m(we.$$.fragment,e),Yo=a(e),Me=d(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1uytqp8"&&(Me.textContent=pd),So=a(e),Ee=d(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1pa0uk8"&&(Ee.innerHTML=md),qo=a(e),Ce=d(e,"TABLE",{"data-svelte-h":!0}),i(Ce)!=="svelte-hch5rz"&&(Ce.innerHTML=nd),Ko=a(e),Oo=d(e,"HR",{}),es=a(e),Pe=d(e,"A",{id:!0,class:!0}),f(Pe).forEach(r),ts=a(e),m(Je.$$.fragment,e),rs=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-y1gxwn"&&(Ie.textContent=ud),os=a(e),He=d(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1xz91ac"&&(He.innerHTML=hd),ss=a(e),Fe=d(e,"UL",{"data-svelte-h":!0}),i(Fe)!=="svelte-1obx36y"&&(Fe.innerHTML=_d),as=a(e),ls=d(e,"HR",{}),ds=a(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),is=a(e),m(je.$$.fragment,e),cs=a(e),Le=d(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-1ec3vsm"&&(Le.textContent=fd),ps=a(e),ze=d(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-6tjpr7"&&(ze.innerHTML=gd),ms=a(e),Ae=d(e,"TABLE",{"data-svelte-h":!0}),i(Ae)!=="svelte-1px7bnv"&&(Ae.innerHTML=xd),ns=a(e),us=d(e,"HR",{}),hs=a(e),Re=d(e,"A",{id:!0,class:!0}),f(Re).forEach(r),_s=a(e),m(Ue.$$.fragment,e),fs=a(e),De=d(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-j2v54d"&&(De.innerHTML=Td),gs=a(e),xs=d(e,"HR",{}),Ts=a(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),bs=a(e),m(We.$$.fragment,e),ys=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-75c7d5"&&(Ne.innerHTML=bd),vs=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-o8p6wm"&&(Ge.innerHTML=yd),$s=a(e),Ze=d(e,"TABLE",{"data-svelte-h":!0}),i(Ze)!=="svelte-yqya7v"&&(Ze.innerHTML=vd),ws=a(e),Ms=d(e,"HR",{}),Es=a(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),Cs=a(e),m(Xe.$$.fragment,e),Ps=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-gl8gb6"&&(Ve.textContent=$d),Js=a(e),Ye=d(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1qxvzd2"&&(Ye.innerHTML=wd),Is=a(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),i(Se)!=="svelte-1f7z42u"&&(Se.innerHTML=Md),Hs=a(e),Fs=d(e,"HR",{}),ks=a(e),qe=d(e,"A",{id:!0,class:!0}),f(qe).forEach(r),js=a(e),m(Ke.$$.fragment,e),Ls=a(e),Oe=d(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-7vs1p7"&&(Oe.textContent=Ed),zs=a(e),et=d(e,"P",{"data-svelte-h":!0}),i(et)!=="svelte-15rcpil"&&(et.innerHTML=Cd),As=a(e),tt=d(e,"TABLE",{"data-svelte-h":!0}),i(tt)!=="svelte-3xdz32"&&(tt.innerHTML=Pd),Rs=a(e),Us=d(e,"HR",{}),Ds=a(e),rt=d(e,"A",{id:!0,class:!0}),f(rt).forEach(r),Bs=a(e),m(ot.$$.fragment,e),Ws=a(e),st=d(e,"P",{"data-svelte-h":!0}),i(st)!=="svelte-frdp8m"&&(st.textContent=Jd),Ns=a(e),at=d(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-j2v54d"&&(at.innerHTML=Id),Gs=a(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),i(lt)!=="svelte-11rkhka"&&(lt.innerHTML=Hd),Zs=a(e),Qs=d(e,"HR",{}),Xs=a(e),dt=d(e,"A",{id:!0,class:!0}),f(dt).forEach(r),Vs=a(e),m(it.$$.fragment,e),Ys=a(e),ct=d(e,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-o9f953"&&(ct.textContent=Fd),Ss=a(e),pt=d(e,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-fac4cj"&&(pt.innerHTML=kd),qs=a(e),mt=d(e,"UL",{"data-svelte-h":!0}),i(mt)!=="svelte-1v579im"&&(mt.innerHTML=jd),Ks=a(e),Os=d(e,"HR",{}),ea=a(e),nt=d(e,"A",{id:!0,class:!0}),f(nt).forEach(r),ta=a(e),m(ut.$$.fragment,e),ra=a(e),ht=d(e,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1naom0u"&&(ht.textContent=Ld),oa=a(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),i(_t)!=="svelte-ilxs6c"&&(_t.innerHTML=zd),sa=a(e),aa=d(e,"HR",{}),la=a(e),ft=d(e,"A",{id:!0,class:!0}),f(ft).forEach(r),da=a(e),m(gt.$$.fragment,e),ia=a(e),xt=d(e,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-zbbm3j"&&(xt.textContent=Ad),ca=a(e),Tt=d(e,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-kflsb2"&&(Tt.innerHTML=Rd),pa=a(e),bt=d(e,"TABLE",{"data-svelte-h":!0}),i(bt)!=="svelte-pm1u9z"&&(bt.innerHTML=Ud),ma=a(e),na=d(e,"HR",{}),ua=a(e),yt=d(e,"A",{id:!0,class:!0}),f(yt).forEach(r),ha=a(e),m(vt.$$.fragment,e),_a=a(e),$t=d(e,"P",{"data-svelte-h":!0}),i($t)!=="svelte-17pib55"&&($t.textContent=Dd),fa=a(e),wt=d(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1ljhyyr"&&(wt.innerHTML=Bd),ga=a(e),xa=d(e,"HR",{}),Ta=a(e),Mt=d(e,"A",{id:!0,class:!0}),f(Mt).forEach(r),ba=a(e),m(Et.$$.fragment,e),ya=a(e),Ct=d(e,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-r5x3fh"&&(Ct.textContent=Wd),va=a(e),Pt=d(e,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-1vpvonk"&&(Pt.innerHTML=Nd),$a=a(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),i(Jt)!=="svelte-nv3lon"&&(Jt.innerHTML=Gd),wa=a(e),Ma=d(e,"HR",{}),Ea=a(e),It=d(e,"A",{id:!0,class:!0}),f(It).forEach(r),Ca=a(e),m(Ht.$$.fragment,e),Pa=a(e),Ft=d(e,"P",{"data-svelte-h":!0}),i(Ft)!=="svelte-62dsf9"&&(Ft.innerHTML=Zd),Ja=a(e),kt=d(e,"P",{"data-svelte-h":!0}),i(kt)!=="svelte-11vd43e"&&(kt.innerHTML=Qd),Ia=a(e),m(jt.$$.fragment,e),Ha=a(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-c0cgha"&&(Lt.innerHTML=Xd),Fa=a(e),m(zt.$$.fragment,e),ka=a(e),At=d(e,"P",{"data-svelte-h":!0}),i(At)!=="svelte-wmyz1o"&&(At.innerHTML=Vd),ja=a(e),La=d(e,"HR",{}),za=a(e),Rt=d(e,"A",{id:!0,class:!0}),f(Rt).forEach(r),Aa=a(e),m(Ut.$$.fragment,e),Ra=a(e),Dt=d(e,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-jwfdp9"&&(Dt.textContent=Yd),Ua=a(e),Bt=d(e,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-t85gxq"&&(Bt.innerHTML=Sd),Da=a(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-y7m8db"&&(Wt.innerHTML=qd),Ba=a(e),Nt=d(e,"TABLE",{"data-svelte-h":!0}),i(Nt)!=="svelte-1oj79mt"&&(Nt.innerHTML=Kd),Wa=a(e),Na=d(e,"HR",{}),Ga=a(e),Gt=d(e,"A",{id:!0,class:!0}),f(Gt).forEach(r),Za=a(e),m(Zt.$$.fragment,e),Qa=a(e),Qt=d(e,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-kjzox5"&&(Qt.textContent=Od),Xa=a(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-19qboln"&&(Xt.innerHTML=ei),Va=a(e),Vt=d(e,"TABLE",{"data-svelte-h":!0}),i(Vt)!=="svelte-1bv5sxq"&&(Vt.innerHTML=ti),Ya=a(e),Sa=d(e,"HR",{}),qa=a(e),Yt=d(e,"A",{id:!0,class:!0}),f(Yt).forEach(r),Ka=a(e),m(St.$$.fragment,e),Oa=a(e),qt=d(e,"P",{"data-svelte-h":!0}),i(qt)!=="svelte-2u8xbp"&&(qt.textContent=ri),el=a(e),Kt=d(e,"P",{"data-svelte-h":!0}),i(Kt)!=="svelte-3xndnt"&&(Kt.innerHTML=oi),tl=a(e),rl=d(e,"HR",{}),ol=a(e),Ot=d(e,"A",{id:!0,class:!0}),f(Ot).forEach(r),sl=a(e),m(er.$$.fragment,e),al=a(e),tr=d(e,"P",{"data-svelte-h":!0}),i(tr)!=="svelte-cy5pwv"&&(tr.innerHTML=si),ll=a(e),rr=d(e,"TABLE",{"data-svelte-h":!0}),i(rr)!=="svelte-1dyar84"&&(rr.innerHTML=ai),dl=a(e),il=d(e,"HR",{}),cl=a(e),or=d(e,"A",{id:!0,class:!0}),f(or).forEach(r),pl=a(e),m(sr.$$.fragment,e),ml=a(e),ar=d(e,"P",{"data-svelte-h":!0}),i(ar)!=="svelte-cy5pwv"&&(ar.innerHTML=li),nl=a(e),lr=d(e,"TABLE",{"data-svelte-h":!0}),i(lr)!=="svelte-1cnys15"&&(lr.innerHTML=di),ul=a(e),hl=d(e,"HR",{}),_l=a(e),dr=d(e,"A",{id:!0,class:!0}),f(dr).forEach(r),fl=a(e),m(ir.$$.fragment,e),gl=a(e),cr=d(e,"P",{"data-svelte-h":!0}),i(cr)!=="svelte-cy5pwv"&&(cr.innerHTML=ii),xl=a(e),pr=d(e,"TABLE",{"data-svelte-h":!0}),i(pr)!=="svelte-179cln2"&&(pr.innerHTML=ci),Tl=a(e),bl=d(e,"HR",{}),yl=a(e),mr=d(e,"A",{id:!0,class:!0}),f(mr).forEach(r),vl=a(e),m(nr.$$.fragment,e),$l=a(e),ur=d(e,"P",{"data-svelte-h":!0}),i(ur)!=="svelte-cy5pwv"&&(ur.innerHTML=pi),wl=a(e),hr=d(e,"TABLE",{"data-svelte-h":!0}),i(hr)!=="svelte-vnvxdo"&&(hr.innerHTML=mi),Ml=a(e),El=d(e,"HR",{}),Cl=a(e),fr=d(e,"P",{}),f(fr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",bi),c(T,"id","module_processors"),c(T,"class","group"),c(M,"id","module_processors.FeatureExtractor"),c(M,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(k,"id","module_processors.ImageFeatureExtractor"),c(k,"class","group"),c(R,"id","new_module_processors.ImageFeatureExtractor_new"),c(R,"class","group"),c(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(W,"class","group"),c(X,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(X,"class","group"),c(K,"id","module_processors.ImageFeatureExtractor+pad_image"),c(K,"class","group"),c(oe,"id","module_processors.ImageFeatureExtractor+rescale"),c(oe,"class","group"),c(ie,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(ie,"class","group"),c(ue,"id","module_processors.ImageFeatureExtractor+resize"),c(ue,"class","group"),c(xe,"id","module_processors.ImageFeatureExtractor+preprocess"),c(xe,"class","group"),c($e,"id","module_processors.ImageFeatureExtractor+_call"),c($e,"class","group"),c(Pe,"id","module_processors.DetrFeatureExtractor"),c(Pe,"class","group"),c(ke,"id","module_processors.DetrFeatureExtractor+_call"),c(ke,"class","group"),c(Re,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Re,"class","group"),c(Be,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Be,"class","group"),c(Qe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Qe,"class","group"),c(qe,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(qe,"class","group"),c(rt,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(rt,"class","group"),c(dt,"id","module_processors.Processor"),c(dt,"class","group"),c(nt,"id","new_module_processors.Processor_new"),c(nt,"class","group"),c(ft,"id","module_processors.Processor+_call"),c(ft,"class","group"),c(yt,"id","module_processors.WhisperProcessor"),c(yt,"class","group"),c(Mt,"id","module_processors.WhisperProcessor+_call"),c(Mt,"class","group"),c(It,"id","module_processors.AutoProcessor"),c(It,"class","group"),c(Rt,"id","module_processors.AutoProcessor.from_pretrained"),c(Rt,"class","group"),c(Gt,"id","module_processors..center_to_corners_format"),c(Gt,"class","group"),c(Yt,"id","module_processors..HeightWidth"),c(Yt,"class","group"),c(Ot,"id","module_processors..ImageFeatureExtractorResult"),c(Ot,"class","group"),c(or,"id","module_processors..PreprocessedImage"),c(or,"class","group"),c(dr,"id","module_processors..DetrFeatureExtractorResult"),c(dr,"class","group"),c(mr,"id","module_processors..SamImageProcessorResult"),c(mr,"class","group")},m(e,t){xi(document.head,x),o(e,gr,t),o(e,_r,t),o(e,xr,t),o(e,T,t),o(e,Tr,t),n(b,e,t),o(e,br,t),o(e,y,t),o(e,yr,t),o(e,v,t),o(e,vr,t),n($,e,t),o(e,$r,t),o(e,w,t),o(e,wr,t),o(e,Mr,t),o(e,Er,t),o(e,M,t),o(e,Cr,t),n(E,e,t),o(e,Pr,t),o(e,C,t),o(e,Jr,t),o(e,P,t),o(e,Ir,t),o(e,Hr,t),o(e,Fr,t),o(e,J,t),o(e,kr,t),n(I,e,t),o(e,jr,t),o(e,H,t),o(e,Lr,t),o(e,F,t),o(e,zr,t),o(e,Ar,t),o(e,Rr,t),o(e,k,t),o(e,Ur,t),n(j,e,t),o(e,Dr,t),o(e,L,t),o(e,Br,t),o(e,z,t),o(e,Wr,t),o(e,A,t),o(e,Nr,t),o(e,Gr,t),o(e,Zr,t),o(e,R,t),o(e,Qr,t),n(U,e,t),o(e,Xr,t),o(e,D,t),o(e,Vr,t),o(e,B,t),o(e,Yr,t),o(e,Sr,t),o(e,qr,t),o(e,W,t),o(e,Kr,t),n(N,e,t),o(e,Or,t),o(e,G,t),o(e,eo,t),o(e,Z,t),o(e,to,t),o(e,Q,t),o(e,ro,t),o(e,oo,t),o(e,so,t),o(e,X,t),o(e,ao,t),n(V,e,t),o(e,lo,t),o(e,Y,t),o(e,io,t),o(e,S,t),o(e,co,t),o(e,q,t),o(e,po,t),o(e,mo,t),o(e,no,t),o(e,K,t),o(e,uo,t),n(O,e,t),o(e,ho,t),o(e,ee,t),o(e,_o,t),o(e,te,t),o(e,fo,t),o(e,re,t),o(e,go,t),o(e,xo,t),o(e,To,t),o(e,oe,t),o(e,bo,t),n(se,e,t),o(e,yo,t),o(e,ae,t),o(e,vo,t),o(e,le,t),o(e,$o,t),o(e,de,t),o(e,wo,t),o(e,Mo,t),o(e,Eo,t),o(e,ie,t),o(e,Co,t),n(ce,e,t),o(e,Po,t),o(e,pe,t),o(e,Jo,t),o(e,me,t),o(e,Io,t),o(e,ne,t),o(e,Ho,t),o(e,Fo,t),o(e,ko,t),o(e,ue,t),o(e,jo,t),n(he,e,t),o(e,Lo,t),o(e,_e,t),o(e,zo,t),o(e,fe,t),o(e,Ao,t),o(e,ge,t),o(e,Ro,t),o(e,Uo,t),o(e,Do,t),o(e,xe,t),o(e,Bo,t),n(Te,e,t),o(e,Wo,t),o(e,be,t),o(e,No,t),o(e,ye,t),o(e,Go,t),o(e,ve,t),o(e,Zo,t),o(e,Qo,t),o(e,Xo,t),o(e,$e,t),o(e,Vo,t),n(we,e,t),o(e,Yo,t),o(e,Me,t),o(e,So,t),o(e,Ee,t),o(e,qo,t),o(e,Ce,t),o(e,Ko,t),o(e,Oo,t),o(e,es,t),o(e,Pe,t),o(e,ts,t),n(Je,e,t),o(e,rs,t),o(e,Ie,t),o(e,os,t),o(e,He,t),o(e,ss,t),o(e,Fe,t),o(e,as,t),o(e,ls,t),o(e,ds,t),o(e,ke,t),o(e,is,t),n(je,e,t),o(e,cs,t),o(e,Le,t),o(e,ps,t),o(e,ze,t),o(e,ms,t),o(e,Ae,t),o(e,ns,t),o(e,us,t),o(e,hs,t),o(e,Re,t),o(e,_s,t),n(Ue,e,t),o(e,fs,t),o(e,De,t),o(e,gs,t),o(e,xs,t),o(e,Ts,t),o(e,Be,t),o(e,bs,t),n(We,e,t),o(e,ys,t),o(e,Ne,t),o(e,vs,t),o(e,Ge,t),o(e,$s,t),o(e,Ze,t),o(e,ws,t),o(e,Ms,t),o(e,Es,t),o(e,Qe,t),o(e,Cs,t),n(Xe,e,t),o(e,Ps,t),o(e,Ve,t),o(e,Js,t),o(e,Ye,t),o(e,Is,t),o(e,Se,t),o(e,Hs,t),o(e,Fs,t),o(e,ks,t),o(e,qe,t),o(e,js,t),n(Ke,e,t),o(e,Ls,t),o(e,Oe,t),o(e,zs,t),o(e,et,t),o(e,As,t),o(e,tt,t),o(e,Rs,t),o(e,Us,t),o(e,Ds,t),o(e,rt,t),o(e,Bs,t),n(ot,e,t),o(e,Ws,t),o(e,st,t),o(e,Ns,t),o(e,at,t),o(e,Gs,t),o(e,lt,t),o(e,Zs,t),o(e,Qs,t),o(e,Xs,t),o(e,dt,t),o(e,Vs,t),n(it,e,t),o(e,Ys,t),o(e,ct,t),o(e,Ss,t),o(e,pt,t),o(e,qs,t),o(e,mt,t),o(e,Ks,t),o(e,Os,t),o(e,ea,t),o(e,nt,t),o(e,ta,t),n(ut,e,t),o(e,ra,t),o(e,ht,t),o(e,oa,t),o(e,_t,t),o(e,sa,t),o(e,aa,t),o(e,la,t),o(e,ft,t),o(e,da,t),n(gt,e,t),o(e,ia,t),o(e,xt,t),o(e,ca,t),o(e,Tt,t),o(e,pa,t),o(e,bt,t),o(e,ma,t),o(e,na,t),o(e,ua,t),o(e,yt,t),o(e,ha,t),n(vt,e,t),o(e,_a,t),o(e,$t,t),o(e,fa,t),o(e,wt,t),o(e,ga,t),o(e,xa,t),o(e,Ta,t),o(e,Mt,t),o(e,ba,t),n(Et,e,t),o(e,ya,t),o(e,Ct,t),o(e,va,t),o(e,Pt,t),o(e,$a,t),o(e,Jt,t),o(e,wa,t),o(e,Ma,t),o(e,Ea,t),o(e,It,t),o(e,Ca,t),n(Ht,e,t),o(e,Pa,t),o(e,Ft,t),o(e,Ja,t),o(e,kt,t),o(e,Ia,t),n(jt,e,t),o(e,Ha,t),o(e,Lt,t),o(e,Fa,t),n(zt,e,t),o(e,ka,t),o(e,At,t),o(e,ja,t),o(e,La,t),o(e,za,t),o(e,Rt,t),o(e,Aa,t),n(Ut,e,t),o(e,Ra,t),o(e,Dt,t),o(e,Ua,t),o(e,Bt,t),o(e,Da,t),o(e,Wt,t),o(e,Ba,t),o(e,Nt,t),o(e,Wa,t),o(e,Na,t),o(e,Ga,t),o(e,Gt,t),o(e,Za,t),n(Zt,e,t),o(e,Qa,t),o(e,Qt,t),o(e,Xa,t),o(e,Xt,t),o(e,Va,t),o(e,Vt,t),o(e,Ya,t),o(e,Sa,t),o(e,qa,t),o(e,Yt,t),o(e,Ka,t),n(St,e,t),o(e,Oa,t),o(e,qt,t),o(e,el,t),o(e,Kt,t),o(e,tl,t),o(e,rl,t),o(e,ol,t),o(e,Ot,t),o(e,sl,t),n(er,e,t),o(e,al,t),o(e,tr,t),o(e,ll,t),o(e,rr,t),o(e,dl,t),o(e,il,t),o(e,cl,t),o(e,or,t),o(e,pl,t),n(sr,e,t),o(e,ml,t),o(e,ar,t),o(e,nl,t),o(e,lr,t),o(e,ul,t),o(e,hl,t),o(e,_l,t),o(e,dr,t),o(e,fl,t),n(ir,e,t),o(e,gl,t),o(e,cr,t),o(e,xl,t),o(e,pr,t),o(e,Tl,t),o(e,bl,t),o(e,yl,t),o(e,mr,t),o(e,vl,t),n(nr,e,t),o(e,$l,t),o(e,ur,t),o(e,wl,t),o(e,hr,t),o(e,Ml,t),o(e,El,t),o(e,Cl,t),o(e,fr,t),Pl=!0},p:ui,i(e){Pl||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(U.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(ot.$$.fragment,e),u(it.$$.fragment,e),u(ut.$$.fragment,e),u(gt.$$.fragment,e),u(vt.$$.fragment,e),u(Et.$$.fragment,e),u(Ht.$$.fragment,e),u(jt.$$.fragment,e),u(zt.$$.fragment,e),u(Ut.$$.fragment,e),u(Zt.$$.fragment,e),u(St.$$.fragment,e),u(er.$$.fragment,e),u(sr.$$.fragment,e),u(ir.$$.fragment,e),u(nr.$$.fragment,e),Pl=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(I.$$.fragment,e),h(j.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(se.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ke.$$.fragment,e),h(ot.$$.fragment,e),h(it.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h(Et.$$.fragment,e),h(Ht.$$.fragment,e),h(jt.$$.fragment,e),h(zt.$$.fragment,e),h(Ut.$$.fragment,e),h(Zt.$$.fragment,e),h(St.$$.fragment,e),h(er.$$.fragment,e),h(sr.$$.fragment,e),h(ir.$$.fragment,e),h(nr.$$.fragment,e),Pl=!1},d(e){e&&(r(gr),r(_r),r(xr),r(T),r(Tr),r(br),r(y),r(yr),r(v),r(vr),r($r),r(w),r(wr),r(Mr),r(Er),r(M),r(Cr),r(Pr),r(C),r(Jr),r(P),r(Ir),r(Hr),r(Fr),r(J),r(kr),r(jr),r(H),r(Lr),r(F),r(zr),r(Ar),r(Rr),r(k),r(Ur),r(Dr),r(L),r(Br),r(z),r(Wr),r(A),r(Nr),r(Gr),r(Zr),r(R),r(Qr),r(Xr),r(D),r(Vr),r(B),r(Yr),r(Sr),r(qr),r(W),r(Kr),r(Or),r(G),r(eo),r(Z),r(to),r(Q),r(ro),r(oo),r(so),r(X),r(ao),r(lo),r(Y),r(io),r(S),r(co),r(q),r(po),r(mo),r(no),r(K),r(uo),r(ho),r(ee),r(_o),r(te),r(fo),r(re),r(go),r(xo),r(To),r(oe),r(bo),r(yo),r(ae),r(vo),r(le),r($o),r(de),r(wo),r(Mo),r(Eo),r(ie),r(Co),r(Po),r(pe),r(Jo),r(me),r(Io),r(ne),r(Ho),r(Fo),r(ko),r(ue),r(jo),r(Lo),r(_e),r(zo),r(fe),r(Ao),r(ge),r(Ro),r(Uo),r(Do),r(xe),r(Bo),r(Wo),r(be),r(No),r(ye),r(Go),r(ve),r(Zo),r(Qo),r(Xo),r($e),r(Vo),r(Yo),r(Me),r(So),r(Ee),r(qo),r(Ce),r(Ko),r(Oo),r(es),r(Pe),r(ts),r(rs),r(Ie),r(os),r(He),r(ss),r(Fe),r(as),r(ls),r(ds),r(ke),r(is),r(cs),r(Le),r(ps),r(ze),r(ms),r(Ae),r(ns),r(us),r(hs),r(Re),r(_s),r(fs),r(De),r(gs),r(xs),r(Ts),r(Be),r(bs),r(ys),r(Ne),r(vs),r(Ge),r($s),r(Ze),r(ws),r(Ms),r(Es),r(Qe),r(Cs),r(Ps),r(Ve),r(Js),r(Ye),r(Is),r(Se),r(Hs),r(Fs),r(ks),r(qe),r(js),r(Ls),r(Oe),r(zs),r(et),r(As),r(tt),r(Rs),r(Us),r(Ds),r(rt),r(Bs),r(Ws),r(st),r(Ns),r(at),r(Gs),r(lt),r(Zs),r(Qs),r(Xs),r(dt),r(Vs),r(Ys),r(ct),r(Ss),r(pt),r(qs),r(mt),r(Ks),r(Os),r(ea),r(nt),r(ta),r(ra),r(ht),r(oa),r(_t),r(sa),r(aa),r(la),r(ft),r(da),r(ia),r(xt),r(ca),r(Tt),r(pa),r(bt),r(ma),r(na),r(ua),r(yt),r(ha),r(_a),r($t),r(fa),r(wt),r(ga),r(xa),r(Ta),r(Mt),r(ba),r(ya),r(Ct),r(va),r(Pt),r($a),r(Jt),r(wa),r(Ma),r(Ea),r(It),r(Ca),r(Pa),r(Ft),r(Ja),r(kt),r(Ia),r(Ha),r(Lt),r(Fa),r(ka),r(At),r(ja),r(La),r(za),r(Rt),r(Aa),r(Ra),r(Dt),r(Ua),r(Bt),r(Da),r(Wt),r(Ba),r(Nt),r(Wa),r(Na),r(Ga),r(Gt),r(Za),r(Qa),r(Qt),r(Xa),r(Xt),r(Va),r(Vt),r(Ya),r(Sa),r(qa),r(Yt),r(Ka),r(Oa),r(qt),r(el),r(Kt),r(tl),r(rl),r(ol),r(Ot),r(sl),r(al),r(tr),r(ll),r(rr),r(dl),r(il),r(cl),r(or),r(pl),r(ml),r(ar),r(nl),r(lr),r(ul),r(hl),r(_l),r(dr),r(fl),r(gl),r(cr),r(xl),r(pr),r(Tl),r(bl),r(yl),r(mr),r(vl),r($l),r(ur),r(wl),r(hr),r(Ml),r(El),r(Cl),r(fr)),r(x),_(b,e),_($,e),_(E,e),_(I,e),_(j,e),_(U,e),_(N,e),_(V,e),_(O,e),_(se,e),_(ce,e),_(he,e),_(Te,e),_(we,e),_(Je,e),_(je,e),_(Ue,e),_(We,e),_(Xe,e),_(Ke,e),_(ot,e),_(it,e),_(ut,e),_(gt,e),_(vt,e),_(Et,e),_(Ht,e),_(jt,e),_(zt,e),_(Ut,e),_(Zt,e),_(St,e),_(er,e),_(sr,e),_(ir,e),_(nr,e)}}}const bi='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function yi(Il){return hi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ei extends _i{constructor(x){super(),fi(this,x,yi,Ti,ni,{})}}export{Ei as component};
