import{s as ys,n as fs,o as Ts}from"../chunks/scheduler.9039eef2.js";import{S as gs,i as ws,g as o,s,r as p,A as Us,h as i,f as a,c as l,j as on,u as d,x as r,k as rn,l as us,y as J,a as n,v as c,d as m,t as M,w as u}from"../chunks/index.ded8f90d.js";import{D as hs}from"../chunks/Docstring.a2ba2b54.js";import{C as h}from"../chunks/CodeBlock.8580f3e8.js";import{H as y}from"../chunks/Heading.f027f30d.js";function bs(Mn){let T,he,Me,ye,j,fe,_,un="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",Te,k,hn='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',ge,C,we,x,yn=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Ue,F,be,I,fn="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Je,v,Tn="You can also construct a model outside of the trainer and pass it as follows:",je,$,_e,G,gn='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',ke,R,Ce,Z,xe,B,wn=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Fe,z,Ie,E,Un="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",ve,X,$e,Q,bn="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Ge,S,Re,V,Jn="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",Ze,A,Be,W,jn="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",ze,N,_n="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Ee,H,kn="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",Xe,L,Qe,q,Cn="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Se,Y,Ve,D,Ae,P,xn=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,We,O,Ne,K,Fn="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",He,tt,Le,et,In='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',qe,at,Ye,nt,vn='<a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',De,st,Pe,lt,$n="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Oe,ot,Ke,it,Gn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",ta,rt,ea,pt,Rn='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',aa,dt,na,ct,Zn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',sa,mt,la,Mt,oa,ut,Bn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",ia,ht,ra,yt,zn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",pa,ft,da,Tt,En="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",ca,gt,ma,wt,Xn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",Ma,Ut,ua,bt,ha,Jt,Qn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,ya,jt,fa,_t,Sn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Ta,kt,ga,Ct,Vn="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",wa,xt,Ua,Ft,An="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",ba,It,Ja,vt,Wn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",ja,$t,Nn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",_a,Gt,Hn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",ka,Rt,Ca,Zt,Ln="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",xa,Bt,Fa,zt,qn="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",Ia,Et,va,Xt,Yn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,$a,Qt,Dn="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Ga,St,Ra,Vt,Pn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Za,At,On="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Ba,w,Kn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',za,Wt,ts="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",Ea,Nt,Xa,Ht,es='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',Qa,U,as='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',Sa,Lt,ns='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',Va,qt,Aa,Yt,ss='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Wa,Dt,ls="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",Na,Pt,os='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',Ha,Ot,La,Kt,is='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',qa,te,Ya,ee,rs="Pay attention to the following best practices when training a model with that trainer:",Da,ae,ps='<li><a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/main/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',Pa,ne,Oa,se,ds="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Ka,le,tn,g,oe,pn,de,cs=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,en,ie,an,f,re,dn,ce,ms=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,cn,pe,mn,me,Ms=`”<code>infinite (</code>bool<code>, *optional*, defaults to </code>False<code>): If True the iterator is reset after dataset reaches end else stops. seq_length (</code>int<code>, *optional*, defaults to </code>1024<code>): Length of token sequences to return. num_of_sequences (</code>int<code>, *optional*, defaults to </code>1024<code>): Number of token sequences to keep in buffer. chars_per_token (</code>int<code>, *optional*, defaults to </code>3.6<code>): Number of characters per token used to estimate number of tokens in text buffer. eos_token_id (</code>int<code>, *optional*, defaults to </code>0<code>): Id of the end of sequence token if the passed tokenizer does not have an EOS token. shuffle (&#39;bool&#39;, *optional*, defaults to True) Shuffle the examples before they are returned append_concat_token (&#39;bool&#39;, *optional*, defaults to True) If true, appends </code>eos_token_id\` at the end of each sample being packed.
add_special_tokens (‘bool’, <em>optional</em>, defaults to True)
If true, tokenizers adds special tokens to each sample being packed.`,nn,ue,sn;return j=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),C=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),F=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),$=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),R=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),Z=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),z=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),S=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),A=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),L=new h({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),Y=new h({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),D=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),O=new h({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),tt=new h({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),at=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),st=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),ot=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),rt=new h({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),dt=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),mt=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),Mt=new h({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),ht=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),ft=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),gt=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Ut=new h({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),bt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),jt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),kt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),xt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),It=new h({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Rt=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Bt=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Et=new h({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),St=new y({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),Nt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),qt=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),Ot=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir = <span class="hljs-string">&quot;./output&quot;</span>)

trainer = SFTTrainer(
    model = model,
    args = args,
    train_dataset = dataset,
    dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length = max_seq_length,
)
trainer.train()`,wrap:!1}}),te=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),ne=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),le=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),oe=new hs({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"dataset_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L53"}}),ie=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),re=new hs({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"*args",val:""},{name:"**kwds",val:""}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as \`&#x201D;### Question: {question}`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/utils.py#L343"}}),pe=new y({props:{title:"Answer: {answer}",local:"answer-answer",headingTag:"h3"}}),{c(){T=o("meta"),he=s(),Me=o("p"),ye=s(),p(j.$$.fragment),fe=s(),_=o("p"),_.textContent=un,Te=s(),k=o("p"),k.innerHTML=hn,ge=s(),p(C.$$.fragment),we=s(),x=o("p"),x.innerHTML=yn,Ue=s(),p(F.$$.fragment),be=s(),I=o("p"),I.innerHTML=fn,Je=s(),v=o("p"),v.textContent=Tn,je=s(),p($.$$.fragment),_e=s(),G=o("p"),G.innerHTML=gn,ke=s(),p(R.$$.fragment),Ce=s(),p(Z.$$.fragment),xe=s(),B=o("p"),B.innerHTML=wn,Fe=s(),p(z.$$.fragment),Ie=s(),E=o("p"),E.innerHTML=Un,ve=s(),p(X.$$.fragment),$e=s(),Q=o("p"),Q.innerHTML=bn,Ge=s(),p(S.$$.fragment),Re=s(),V=o("p"),V.innerHTML=Jn,Ze=s(),p(A.$$.fragment),Be=s(),W=o("p"),W.innerHTML=jn,ze=s(),N=o("ul"),N.innerHTML=_n,Ee=s(),H=o("p"),H.innerHTML=kn,Xe=s(),p(L.$$.fragment),Qe=s(),q=o("p"),q.innerHTML=Cn,Se=s(),p(Y.$$.fragment),Ve=s(),p(D.$$.fragment),Ae=s(),P=o("p"),P.innerHTML=xn,We=s(),p(O.$$.fragment),Ne=s(),K=o("p"),K.innerHTML=Fn,He=s(),p(tt.$$.fragment),Le=s(),et=o("p"),et.innerHTML=In,qe=s(),p(at.$$.fragment),Ye=s(),nt=o("p"),nt.innerHTML=vn,De=s(),p(st.$$.fragment),Pe=s(),lt=o("p"),lt.innerHTML=$n,Oe=s(),p(ot.$$.fragment),Ke=s(),it=o("p"),it.innerHTML=Gn,ta=s(),p(rt.$$.fragment),ea=s(),pt=o("p"),pt.innerHTML=Rn,aa=s(),p(dt.$$.fragment),na=s(),ct=o("p"),ct.innerHTML=Zn,sa=s(),p(mt.$$.fragment),la=s(),p(Mt.$$.fragment),oa=s(),ut=o("p"),ut.innerHTML=Bn,ia=s(),p(ht.$$.fragment),ra=s(),yt=o("p"),yt.textContent=zn,pa=s(),p(ft.$$.fragment),da=s(),Tt=o("p"),Tt.innerHTML=En,ca=s(),p(gt.$$.fragment),ma=s(),wt=o("p"),wt.innerHTML=Xn,Ma=s(),p(Ut.$$.fragment),ua=s(),p(bt.$$.fragment),ha=s(),Jt=o("p"),Jt.textContent=Qn,ya=s(),p(jt.$$.fragment),fa=s(),_t=o("p"),_t.textContent=Sn,Ta=s(),p(kt.$$.fragment),ga=s(),Ct=o("p"),Ct.innerHTML=Vn,wa=s(),p(xt.$$.fragment),Ua=s(),Ft=o("p"),Ft.innerHTML=An,ba=s(),p(It.$$.fragment),Ja=s(),vt=o("p"),vt.innerHTML=Wn,ja=s(),$t=o("p"),$t.textContent=Nn,_a=s(),Gt=o("table"),Gt.innerHTML=Hn,ka=s(),p(Rt.$$.fragment),Ca=s(),Zt=o("p"),Zt.innerHTML=Ln,xa=s(),p(Bt.$$.fragment),Fa=s(),zt=o("p"),zt.innerHTML=qn,Ia=s(),p(Et.$$.fragment),va=s(),Xt=o("p"),Xt.textContent=Yn,$a=s(),Qt=o("p"),Qt.textContent=Dn,Ga=s(),p(St.$$.fragment),Ra=s(),Vt=o("p"),Vt.innerHTML=Pn,Za=s(),At=o("blockquote"),At.innerHTML=On,Ba=s(),w=o("div"),w.innerHTML=Kn,za=s(),Wt=o("p"),Wt.innerHTML=ts,Ea=s(),p(Nt.$$.fragment),Xa=s(),Ht=o("p"),Ht.innerHTML=es,Qa=s(),U=o("div"),U.innerHTML=as,Sa=s(),Lt=o("p"),Lt.innerHTML=ns,Va=s(),p(qt.$$.fragment),Aa=s(),Yt=o("p"),Yt.innerHTML=ss,Wa=s(),Dt=o("table"),Dt.innerHTML=ls,Na=s(),Pt=o("p"),Pt.innerHTML=os,Ha=s(),p(Ot.$$.fragment),La=s(),Kt=o("p"),Kt.innerHTML=is,qa=s(),p(te.$$.fragment),Ya=s(),ee=o("p"),ee.textContent=rs,Da=s(),ae=o("ul"),ae.innerHTML=ps,Pa=s(),p(ne.$$.fragment),Oa=s(),se=o("p"),se.innerHTML=ds,Ka=s(),p(le.$$.fragment),tn=s(),g=o("div"),p(oe.$$.fragment),pn=s(),de=o("p"),de.innerHTML=cs,en=s(),p(ie.$$.fragment),an=s(),f=o("div"),p(re.$$.fragment),dn=s(),ce=o("p"),ce.textContent=ms,cn=s(),p(pe.$$.fragment),mn=s(),me=o("p"),me.innerHTML=Ms,nn=s(),ue=o("p"),this.h()},l(t){const e=Us("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(a),he=l(t),Me=i(t,"P",{}),on(Me).forEach(a),ye=l(t),d(j.$$.fragment,t),fe=l(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-o839x3"&&(_.textContent=un),Te=l(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-exgkch"&&(k.innerHTML=hn),ge=l(t),d(C.$$.fragment,t),we=l(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-8asaew"&&(x.innerHTML=yn),Ue=l(t),d(F.$$.fragment,t),be=l(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gbidw"&&(I.innerHTML=fn),Je=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ulikv8"&&(v.textContent=Tn),je=l(t),d($.$$.fragment,t),_e=l(t),G=i(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ryagwl"&&(G.innerHTML=gn),ke=l(t),d(R.$$.fragment,t),Ce=l(t),d(Z.$$.fragment,t),xe=l(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-13sbeoj"&&(B.innerHTML=wn),Fe=l(t),d(z.$$.fragment,t),Ie=l(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a743rp"&&(E.innerHTML=Un),ve=l(t),d(X.$$.fragment,t),$e=l(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-rjhq4r"&&(Q.innerHTML=bn),Ge=l(t),d(S.$$.fragment,t),Re=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-dfggk8"&&(V.innerHTML=Jn),Ze=l(t),d(A.$$.fragment,t),Be=l(t),W=i(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-xlwe87"&&(W.innerHTML=jn),ze=l(t),N=i(t,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1enki0k"&&(N.innerHTML=_n),Ee=l(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-14yxh0m"&&(H.innerHTML=kn),Xe=l(t),d(L.$$.fragment,t),Qe=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-13h81gp"&&(q.innerHTML=Cn),Se=l(t),d(Y.$$.fragment,t),Ve=l(t),d(D.$$.fragment,t),Ae=l(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-cqsf2h"&&(P.innerHTML=xn),We=l(t),d(O.$$.fragment,t),Ne=l(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-l25vq0"&&(K.innerHTML=Fn),He=l(t),d(tt.$$.fragment,t),Le=l(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1iqmdsd"&&(et.innerHTML=In),qe=l(t),d(at.$$.fragment,t),Ye=l(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1a4epj8"&&(nt.innerHTML=vn),De=l(t),d(st.$$.fragment,t),Pe=l(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-5wxaqa"&&(lt.innerHTML=$n),Oe=l(t),d(ot.$$.fragment,t),Ke=l(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-iejqw3"&&(it.innerHTML=Gn),ta=l(t),d(rt.$$.fragment,t),ea=l(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-qqgn8q"&&(pt.innerHTML=Rn),aa=l(t),d(dt.$$.fragment,t),na=l(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1bm376s"&&(ct.innerHTML=Zn),sa=l(t),d(mt.$$.fragment,t),la=l(t),d(Mt.$$.fragment,t),oa=l(t),ut=i(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1su7aih"&&(ut.innerHTML=Bn),ia=l(t),d(ht.$$.fragment,t),ra=l(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-11jfbzz"&&(yt.textContent=zn),pa=l(t),d(ft.$$.fragment,t),da=l(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-pwdaav"&&(Tt.innerHTML=En),ca=l(t),d(gt.$$.fragment,t),ma=l(t),wt=i(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-zbh7v5"&&(wt.innerHTML=Xn),Ma=l(t),d(Ut.$$.fragment,t),ua=l(t),d(bt.$$.fragment,t),ha=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-fyvvsj"&&(Jt.textContent=Qn),ya=l(t),d(jt.$$.fragment,t),fa=l(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-yypgof"&&(_t.textContent=Sn),Ta=l(t),d(kt.$$.fragment,t),ga=l(t),Ct=i(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-yugu96"&&(Ct.innerHTML=Vn),wa=l(t),d(xt.$$.fragment,t),Ua=l(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1qms4cl"&&(Ft.innerHTML=An),ba=l(t),d(It.$$.fragment,t),Ja=l(t),vt=i(t,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-qe5zfz"&&(vt.innerHTML=Wn),ja=l(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-69u1rz"&&($t.textContent=Nn),_a=l(t),Gt=i(t,"TABLE",{"data-svelte-h":!0}),r(Gt)!=="svelte-8fq96j"&&(Gt.innerHTML=Hn),ka=l(t),d(Rt.$$.fragment,t),Ca=l(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-1rqlm78"&&(Zt.innerHTML=Ln),xa=l(t),d(Bt.$$.fragment,t),Fa=l(t),zt=i(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-sqoxna"&&(zt.innerHTML=qn),Ia=l(t),d(Et.$$.fragment,t),va=l(t),Xt=i(t,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-vfpk19"&&(Xt.textContent=Yn),$a=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-zatc00"&&(Qt.textContent=Dn),Ga=l(t),d(St.$$.fragment,t),Ra=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-6trhkk"&&(Vt.innerHTML=Pn),Za=l(t),At=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(At)!=="svelte-1ejl1pl"&&(At.innerHTML=On),Ba=l(t),w=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wkjgyb"&&(w.innerHTML=Kn),za=l(t),Wt=i(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-7jwpzy"&&(Wt.innerHTML=ts),Ea=l(t),d(Nt.$$.fragment,t),Xa=l(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-sqj12"&&(Ht.innerHTML=es),Qa=l(t),U=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(U)!=="svelte-a1m5gi"&&(U.innerHTML=as),Sa=l(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-rwofnh"&&(Lt.innerHTML=ns),Va=l(t),d(qt.$$.fragment,t),Aa=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-1q1m1nw"&&(Yt.innerHTML=ss),Wa=l(t),Dt=i(t,"TABLE",{"data-svelte-h":!0}),r(Dt)!=="svelte-lj2wpp"&&(Dt.innerHTML=ls),Na=l(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1p74c9x"&&(Pt.innerHTML=os),Ha=l(t),d(Ot.$$.fragment,t),La=l(t),Kt=i(t,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-1o18rwj"&&(Kt.innerHTML=is),qa=l(t),d(te.$$.fragment,t),Ya=l(t),ee=i(t,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-g801h1"&&(ee.textContent=rs),Da=l(t),ae=i(t,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1nhm2ti"&&(ae.innerHTML=ps),Pa=l(t),d(ne.$$.fragment,t),Oa=l(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-xofzi2"&&(se.innerHTML=ds),Ka=l(t),d(le.$$.fragment,t),tn=l(t),g=i(t,"DIV",{class:!0});var ln=on(g);d(oe.$$.fragment,ln),pn=l(ln),de=i(ln,"P",{"data-svelte-h":!0}),r(de)!=="svelte-14oyph8"&&(de.innerHTML=cs),ln.forEach(a),en=l(t),d(ie.$$.fragment,t),an=l(t),f=i(t,"DIV",{class:!0});var b=on(f);d(re.$$.fragment,b),dn=l(b),ce=i(b,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1dlriq1"&&(ce.textContent=ms),cn=l(b),d(pe.$$.fragment,b),mn=l(b),me=i(b,"P",{"data-svelte-h":!0}),r(me)!=="svelte-gymob5"&&(me.innerHTML=Ms),b.forEach(a),nn=l(t),ue=i(t,"P",{}),on(ue).forEach(a),this.h()},h(){rn(T,"name","hf:doc:metadata"),rn(T,"content",Js),us(w,"text-align","center"),us(U,"text-align","center"),rn(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),rn(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){J(document.head,T),n(t,he,e),n(t,Me,e),n(t,ye,e),c(j,t,e),n(t,fe,e),n(t,_,e),n(t,Te,e),n(t,k,e),n(t,ge,e),c(C,t,e),n(t,we,e),n(t,x,e),n(t,Ue,e),c(F,t,e),n(t,be,e),n(t,I,e),n(t,Je,e),n(t,v,e),n(t,je,e),c($,t,e),n(t,_e,e),n(t,G,e),n(t,ke,e),c(R,t,e),n(t,Ce,e),c(Z,t,e),n(t,xe,e),n(t,B,e),n(t,Fe,e),c(z,t,e),n(t,Ie,e),n(t,E,e),n(t,ve,e),c(X,t,e),n(t,$e,e),n(t,Q,e),n(t,Ge,e),c(S,t,e),n(t,Re,e),n(t,V,e),n(t,Ze,e),c(A,t,e),n(t,Be,e),n(t,W,e),n(t,ze,e),n(t,N,e),n(t,Ee,e),n(t,H,e),n(t,Xe,e),c(L,t,e),n(t,Qe,e),n(t,q,e),n(t,Se,e),c(Y,t,e),n(t,Ve,e),c(D,t,e),n(t,Ae,e),n(t,P,e),n(t,We,e),c(O,t,e),n(t,Ne,e),n(t,K,e),n(t,He,e),c(tt,t,e),n(t,Le,e),n(t,et,e),n(t,qe,e),c(at,t,e),n(t,Ye,e),n(t,nt,e),n(t,De,e),c(st,t,e),n(t,Pe,e),n(t,lt,e),n(t,Oe,e),c(ot,t,e),n(t,Ke,e),n(t,it,e),n(t,ta,e),c(rt,t,e),n(t,ea,e),n(t,pt,e),n(t,aa,e),c(dt,t,e),n(t,na,e),n(t,ct,e),n(t,sa,e),c(mt,t,e),n(t,la,e),c(Mt,t,e),n(t,oa,e),n(t,ut,e),n(t,ia,e),c(ht,t,e),n(t,ra,e),n(t,yt,e),n(t,pa,e),c(ft,t,e),n(t,da,e),n(t,Tt,e),n(t,ca,e),c(gt,t,e),n(t,ma,e),n(t,wt,e),n(t,Ma,e),c(Ut,t,e),n(t,ua,e),c(bt,t,e),n(t,ha,e),n(t,Jt,e),n(t,ya,e),c(jt,t,e),n(t,fa,e),n(t,_t,e),n(t,Ta,e),c(kt,t,e),n(t,ga,e),n(t,Ct,e),n(t,wa,e),c(xt,t,e),n(t,Ua,e),n(t,Ft,e),n(t,ba,e),c(It,t,e),n(t,Ja,e),n(t,vt,e),n(t,ja,e),n(t,$t,e),n(t,_a,e),n(t,Gt,e),n(t,ka,e),c(Rt,t,e),n(t,Ca,e),n(t,Zt,e),n(t,xa,e),c(Bt,t,e),n(t,Fa,e),n(t,zt,e),n(t,Ia,e),c(Et,t,e),n(t,va,e),n(t,Xt,e),n(t,$a,e),n(t,Qt,e),n(t,Ga,e),c(St,t,e),n(t,Ra,e),n(t,Vt,e),n(t,Za,e),n(t,At,e),n(t,Ba,e),n(t,w,e),n(t,za,e),n(t,Wt,e),n(t,Ea,e),c(Nt,t,e),n(t,Xa,e),n(t,Ht,e),n(t,Qa,e),n(t,U,e),n(t,Sa,e),n(t,Lt,e),n(t,Va,e),c(qt,t,e),n(t,Aa,e),n(t,Yt,e),n(t,Wa,e),n(t,Dt,e),n(t,Na,e),n(t,Pt,e),n(t,Ha,e),c(Ot,t,e),n(t,La,e),n(t,Kt,e),n(t,qa,e),c(te,t,e),n(t,Ya,e),n(t,ee,e),n(t,Da,e),n(t,ae,e),n(t,Pa,e),c(ne,t,e),n(t,Oa,e),n(t,se,e),n(t,Ka,e),c(le,t,e),n(t,tn,e),n(t,g,e),c(oe,g,null),J(g,pn),J(g,de),n(t,en,e),c(ie,t,e),n(t,an,e),n(t,f,e),c(re,f,null),J(f,dn),J(f,ce),J(f,cn),c(pe,f,null),J(f,mn),J(f,me),n(t,nn,e),n(t,ue,e),sn=!0},p:fs,i(t){sn||(m(j.$$.fragment,t),m(C.$$.fragment,t),m(F.$$.fragment,t),m($.$$.fragment,t),m(R.$$.fragment,t),m(Z.$$.fragment,t),m(z.$$.fragment,t),m(X.$$.fragment,t),m(S.$$.fragment,t),m(A.$$.fragment,t),m(L.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(tt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(Mt.$$.fragment,t),m(ht.$$.fragment,t),m(ft.$$.fragment,t),m(gt.$$.fragment,t),m(Ut.$$.fragment,t),m(bt.$$.fragment,t),m(jt.$$.fragment,t),m(kt.$$.fragment,t),m(xt.$$.fragment,t),m(It.$$.fragment,t),m(Rt.$$.fragment,t),m(Bt.$$.fragment,t),m(Et.$$.fragment,t),m(St.$$.fragment,t),m(Nt.$$.fragment,t),m(qt.$$.fragment,t),m(Ot.$$.fragment,t),m(te.$$.fragment,t),m(ne.$$.fragment,t),m(le.$$.fragment,t),m(oe.$$.fragment,t),m(ie.$$.fragment,t),m(re.$$.fragment,t),m(pe.$$.fragment,t),sn=!0)},o(t){M(j.$$.fragment,t),M(C.$$.fragment,t),M(F.$$.fragment,t),M($.$$.fragment,t),M(R.$$.fragment,t),M(Z.$$.fragment,t),M(z.$$.fragment,t),M(X.$$.fragment,t),M(S.$$.fragment,t),M(A.$$.fragment,t),M(L.$$.fragment,t),M(Y.$$.fragment,t),M(D.$$.fragment,t),M(O.$$.fragment,t),M(tt.$$.fragment,t),M(at.$$.fragment,t),M(st.$$.fragment,t),M(ot.$$.fragment,t),M(rt.$$.fragment,t),M(dt.$$.fragment,t),M(mt.$$.fragment,t),M(Mt.$$.fragment,t),M(ht.$$.fragment,t),M(ft.$$.fragment,t),M(gt.$$.fragment,t),M(Ut.$$.fragment,t),M(bt.$$.fragment,t),M(jt.$$.fragment,t),M(kt.$$.fragment,t),M(xt.$$.fragment,t),M(It.$$.fragment,t),M(Rt.$$.fragment,t),M(Bt.$$.fragment,t),M(Et.$$.fragment,t),M(St.$$.fragment,t),M(Nt.$$.fragment,t),M(qt.$$.fragment,t),M(Ot.$$.fragment,t),M(te.$$.fragment,t),M(ne.$$.fragment,t),M(le.$$.fragment,t),M(oe.$$.fragment,t),M(ie.$$.fragment,t),M(re.$$.fragment,t),M(pe.$$.fragment,t),sn=!1},d(t){t&&(a(he),a(Me),a(ye),a(fe),a(_),a(Te),a(k),a(ge),a(we),a(x),a(Ue),a(be),a(I),a(Je),a(v),a(je),a(_e),a(G),a(ke),a(Ce),a(xe),a(B),a(Fe),a(Ie),a(E),a(ve),a($e),a(Q),a(Ge),a(Re),a(V),a(Ze),a(Be),a(W),a(ze),a(N),a(Ee),a(H),a(Xe),a(Qe),a(q),a(Se),a(Ve),a(Ae),a(P),a(We),a(Ne),a(K),a(He),a(Le),a(et),a(qe),a(Ye),a(nt),a(De),a(Pe),a(lt),a(Oe),a(Ke),a(it),a(ta),a(ea),a(pt),a(aa),a(na),a(ct),a(sa),a(la),a(oa),a(ut),a(ia),a(ra),a(yt),a(pa),a(da),a(Tt),a(ca),a(ma),a(wt),a(Ma),a(ua),a(ha),a(Jt),a(ya),a(fa),a(_t),a(Ta),a(ga),a(Ct),a(wa),a(Ua),a(Ft),a(ba),a(Ja),a(vt),a(ja),a($t),a(_a),a(Gt),a(ka),a(Ca),a(Zt),a(xa),a(Fa),a(zt),a(Ia),a(va),a(Xt),a($a),a(Qt),a(Ga),a(Ra),a(Vt),a(Za),a(At),a(Ba),a(w),a(za),a(Wt),a(Ea),a(Xa),a(Ht),a(Qa),a(U),a(Sa),a(Lt),a(Va),a(Aa),a(Yt),a(Wa),a(Dt),a(Na),a(Pt),a(Ha),a(La),a(Kt),a(qa),a(Ya),a(ee),a(Da),a(ae),a(Pa),a(Oa),a(se),a(Ka),a(tn),a(g),a(en),a(an),a(f),a(nn),a(ue)),a(T),u(j,t),u(C,t),u(F,t),u($,t),u(R,t),u(Z,t),u(z,t),u(X,t),u(S,t),u(A,t),u(L,t),u(Y,t),u(D,t),u(O,t),u(tt,t),u(at,t),u(st,t),u(ot,t),u(rt,t),u(dt,t),u(mt,t),u(Mt,t),u(ht,t),u(ft,t),u(gt,t),u(Ut,t),u(bt,t),u(jt,t),u(kt,t),u(xt,t),u(It,t),u(Rt,t),u(Bt,t),u(Et,t),u(St,t),u(Nt,t),u(qt,t),u(Ot,t),u(te,t),u(ne,t),u(le,t),u(oe),u(ie,t),u(re),u(pe)}}}const Js='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[{"title":"Answer: {answer}","local":"answer-answer","sections":[],"depth":3}],"depth":2}],"depth":1}';function js(Mn){return Ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends gs{constructor(T){super(),ws(this,T,js,bs,ys,{})}}export{Is as component};
