import{s as Bo,n as Ko,o as Go}from"../chunks/scheduler.9039eef2.js";import{S as Jo,i as Yo,g as r,s as n,r as d,A as Zo,h as o,f as i,c as a,j as _,u as c,x as s,k as u,y as t,a as b,v as p,d as m,t as g,w as h}from"../chunks/index.ded8f90d.js";import{D as f}from"../chunks/Docstring.a2ba2b54.js";import{H as L}from"../chunks/Heading.f027f30d.js";function Qo(Wr){let q,vn,un,bn,ge,Tn,he,Br=`At TRL we support PPO (Proximal Policy Optimisation) with an implementation that largely follows  the structure introduced in the paper “Fine-Tuning Language Models from Human Preferences” by D. Ziegler et al. [<a href="https://arxiv.org/pdf/1909.08593.pdf" rel="nofollow">paper</a>, <a href="https://github.com/openai/lm-human-preferences" rel="nofollow">code</a>].
The Trainer and model classes are largely inspired from <code>transformers.Trainer</code> and <code>transformers.AutoModel</code> classes and adapted for RL.
We also support a <code>RewardTrainer</code> that can be used to train a reward model.`,yn,_e,xn,S,ue,fa,pt,Kr="Configuration class for PPOTrainer",$n,fe,Pn,y,ve,va,mt,Gr=`The PPOTrainer uses Proximal Policy Optimization to optimise language models.
Note, this trainer is heavily inspired by the original OpenAI learning to summarize work here:
<a href="https://github.com/openai/summarize-from-feedback" rel="nofollow">https://github.com/openai/summarize-from-feedback</a>`,ba,U,be,Ta,gt,Jr="Calculate model outputs in multiple batches.",ya,R,Te,xa,ht,Yr="Compute per token rewards from scores and KL-penalty.",$a,V,ye,Pa,_t,Zr="Creates and saves a model card for a TRL model.",Oa,j,xe,Da,ut,Qr="Gather stats from all processes. Useful in the context of distributed training.",wa,W,$e,ka,ft,Xr=`Generate response with the model given the query tensor.
call the <code>generate</code> method of the model.`,Ca,B,Pe,La,vt,eo="A function that logs all the training stats. Call it at the end of each epoch.",Na,K,Oe,Fa,bt,to="Calculate policy and value losses.",za,G,De,Ia,Tt,no="Prepare the dataloader for training.",Ma,J,we,qa,yt,ao="Record training step statistics.",Sa,Y,ke,Aa,xt,ro="Run a PPO optimisation step given a list of queries, model responses, and rewards.",Ea,Z,Ce,Ha,$t,oo="Train one PPO minibatch",On,Le,Dn,k,Ne,Ua,Pt,io='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a> class.',Ra,Ot,so=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,wn,Fe,kn,P,ze,Va,Dt,lo=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,ja,wt,co=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Wa,kt,po="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Ba,Ct,mo=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,Cn,Ie,Ln,A,Me,Ka,Lt,go=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,Nn,qe,Fn,v,Se,Ga,Nt,ho="Initialize DPOTrainer.",Ja,Q,Ae,Ya,Ft,_o=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Za,X,Ee,Qa,zt,uo="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",Xa,N,He,er,It,fo="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",tr,Mt,vo="We do this to avoid doing two forward passes, because it’s faster for FSDP.",nr,ee,Ue,ar,qt,bo="Concatenate the chosen and rejected inputs into a single tensor.",rr,te,Re,or,St,To="Compute the DPO loss for a batch of policy and reference model log probabilities.",ir,F,Ve,sr,At,yo=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,lr,Et,xo="Works both with or without labels.",dr,ne,je,cr,Ht,$o="Compute the log probabilities of the given labels under the given logits.",pr,ae,We,mr,Ut,Po="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",gr,re,Be,hr,Rt,Oo="Generate samples from the model and reference model for the given batch of inputs.",_r,z,Ke,ur,Vt,Do="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",fr,jt,wo="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",vr,I,Ge,br,Wt,ko="Returns the training <code>~torch.utils.data.DataLoader</code>.",Tr,Bt,Co="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",yr,oe,Je,xr,Kt,Lo="Log <code>logs</code> on the various objects watching training, including stored metrics.",$r,ie,Ye,Pr,Gt,No="Context manager for handling null reference model (that is, peft adapter manipulation).",Or,O,Ze,Dr,Jt,Fo="Tokenize a single row from a DPO specific dataset.",wr,Yt,zo=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,kr,Zt,Io=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,zn,Qe,In,E,Xe,Cr,Qt,Mo="Configuration class for DDPOTrainer",Mn,et,qn,$,tt,Lr,Xt,qo=`The DDPOTrainer uses Deep Diffusion Policy Optimization to optimise diffusion models.
Note, this trainer is heavily inspired by the work here: <a href="https://github.com/kvablack/ddpo-pytorch" rel="nofollow">https://github.com/kvablack/ddpo-pytorch</a>
As of now only Stable Diffusion based pipelines are supported`,Nr,se,nt,Fr,en,So="Calculate the loss for a batch of an unpacked sample",zr,le,at,Ir,tn,Ao="Creates and saves a model card for a TRL model.",Mr,D,rt,qr,nn,Eo="Perform a single step of training.",Sr,an,Ho="Side Effects:",Ar,rn,Uo="<li>Model weights are updated</li> <li>Logs the statistics to the accelerator trackers.</li> <li>If <code>self.image_samples_callback</code> is not None, it will be called with the prompt_image_pairs, global_step, and the accelerator tracker.</li>",Er,de,ot,Hr,on,Ro="Train the model for a given number of epochs",Sn,it,An,C,st,Ur,sn,Vo="The IterativeSFTTrainer can be used to finetune models with methods that requires some steps between optimization.",Rr,ce,lt,Vr,ln,jo="Run an optimisation step given a list of input_ids, attention_mask, and labels or a list of text and text_labels.",En,dt,Hn,H,ct,jr,dn,Wo="Helper function for reproducible behavior to set the seed in <code>random</code>, <code>numpy</code>, and <code>torch</code>.",Un,fn,Rn;return ge=new L({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),_e=new L({props:{title:"PPOConfig",local:"trl.PPOConfig",headingTag:"h2"}}),ue=new f({props:{name:"class trl.PPOConfig",anchor:"trl.PPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"task_name",val:": typing.Optional[str] = None"},{name:"model_name",val:": typing.Optional[str] = None"},{name:"query_dataset",val:": typing.Optional[str] = None"},{name:"reward_model",val:": typing.Optional[str] = None"},{name:"remove_unused_columns",val:": bool = True"},{name:"tracker_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f9c86b18ee0>)] = <factory>"},{name:"accelerator_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f9c86b18ee0>)] = <factory>"},{name:"project_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f9c86b18ee0>)] = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"push_to_hub_if_best_kwargs",val:": typing_extensions.Annotated[typing.Optional[dict], _ArgConfiguration(name=None, metavar='JSON', help=None, aliases=None, prefix_name=None, constructor_factory=<function arg.<locals>.<lambda> at 0x7f9c86b18ee0>)] = <factory>"},{name:"steps",val:": int = 20000"},{name:"learning_rate",val:": float = 1e-05"},{name:"adap_kl_ctrl",val:": bool = True"},{name:"init_kl_coef",val:": typing.Optional[float] = 0.2"},{name:"kl_penalty",val:": typing.Literal['kl', 'abs', 'mse', 'full'] = 'kl'"},{name:"target",val:": typing.Optional[float] = 6"},{name:"horizon",val:": typing.Optional[float] = 10000"},{name:"gamma",val:": float = 1"},{name:"lam",val:": float = 0.95"},{name:"cliprange",val:": float = 0.2"},{name:"cliprange_value",val:": float = 0.2"},{name:"vf_coef",val:": float = 0.1"},{name:"batch_size",val:": int = 256"},{name:"forward_batch_size",val:": typing.Optional[int] = None"},{name:"mini_batch_size",val:": int = 1"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"world_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"ppo_epochs",val:": int = 4"},{name:"max_grad_norm",val:": typing.Optional[float] = None"},{name:"optimize_cuda_cache",val:": typing.Optional[bool] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"},{name:"early_stopping",val:": bool = False"},{name:"target_kl",val:": float = 1"},{name:"compare_steps",val:": int = 1"},{name:"ratio_threshold",val:": float = 10.0"},{name:"use_score_scaling",val:": bool = False"},{name:"use_score_norm",val:": bool = False"},{name:"score_clip",val:": typing.Optional[float] = None"},{name:"whiten_rewards",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"is_peft_model",val:": typing.Union[typing_extensions.Annotated[bool, Suppress], NoneType] = None"},{name:"backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_backward_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"},{name:"global_batch_size",val:": typing_extensions.Annotated[int, Suppress] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_config.py#L35"}}),fe=new L({props:{title:"PPOTrainer",local:"trl.PPOTrainer",headingTag:"h2"}}),ve=new f({props:{name:"class trl.PPOTrainer",anchor:"trl.PPOTrainer",parameters:[{name:"config",val:": PPOConfig = None"},{name:"model",val:": PreTrainedModelWrapper = None"},{name:"ref_model",val:": typing.Optional[trl.models.modeling_base.PreTrainedModelWrapper] = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset, NoneType] = None"},{name:"optimizer",val:": typing.Optional[torch.optim.optimizer.Optimizer] = None"},{name:"data_collator",val:": typing.Optional[typing.Callable] = None"},{name:"num_shared_layers",val:": typing.Optional[int] = None"},{name:"lr_scheduler",val:": typing.Optional[torch.optim.lr_scheduler._LRScheduler] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>PPOConfig</code>) &#x2014; Configuration object for PPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.PPOTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModelWrapper</code>) &#x2014; Model to be optimized, Hugging Face transformer model with a value head. &#x2014;
Check the documentation of <code>PreTrainedModelWrapper</code> for more details.`,name:"*model**"},{anchor:"trl.PPOTrainer.*ref_model**",description:`*<strong>*ref_model**</strong> (<code>PreTrainedModelWrapper</code>, <em>optional</em>) &#x2014; Reference model to be used for KL penalty, Hugging Face &#x2014;
transformer model with a casual language modelling head. Check the documentation of <code>PreTrainedModelWrapper</code>
for more details. If no reference model is provided, the trainer will create a reference model with the same
architecture as the model to be optimized with shared layers.`,name:"*ref_model**"},{anchor:"trl.PPOTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.PPOTrainer.*dataset**",description:`*<strong>*dataset**</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>], <em>optional</em>) &#x2014; PyTorch dataset or Hugging &#x2014;
Face dataset. This is used to create a PyTorch dataloader. If no dataset is provided, the dataloader must be
created outside the trainer users needs to design their own dataloader and make sure the batch
size that is used is the same as the one specified in the configuration object.`,name:"*dataset**"},{anchor:"trl.PPOTrainer.*optimizer**",description:`*<strong>*optimizer**</strong> (<code>torch.optim.Optimizer</code>, <em>optional</em>) &#x2014; Optimizer to be used for training. If no optimizer is &#x2014;
provided, the trainer will create an Adam optimizer with the learning rate specified in the configuration
object.`,name:"*optimizer**"},{anchor:"trl.PPOTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (DataCollatorForLanguageModeling, <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader`,name:"*data_collator**"},{anchor:"trl.PPOTrainer.*num_shared_layers**",description:`*<strong>*num_shared_layers**</strong> (int, <em>optional</em>) &#x2014; Number of layers to be shared between the model and the reference &#x2014;
model, if no reference model is passed. If no number is provided, all the layers will be shared.`,name:"*num_shared_layers**"},{anchor:"trl.PPOTrainer.*lr_scheduler**",description:"*<strong>*lr_scheduler**</strong> (<code>torch.optim.lr_scheduler</code>, <em>optional</em>) &#x2014; Learning rate scheduler to be used for training. &#x2014;",name:"*lr_scheduler**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L109"}}),be=new f({props:{name:"batched_forward_pass",anchor:"trl.PPOTrainer.batched_forward_pass",parameters:[{name:"model",val:": PreTrainedModelWrapper"},{name:"queries",val:": Tensor"},{name:"responses",val:": Tensor"},{name:"model_inputs",val:": dict"},{name:"return_logits",val:": bool = False"},{name:"response_masks",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.batched_forward_pass.queries",description:`<strong>queries</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries, shape (<code>batch_size</code>, <code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.batched_forward_pass.responses",description:`<strong>responses</strong> (<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.batched_forward_pass.return_logits",description:`<strong>return_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return all_logits. Set to <code>False</code> if logits are not needed to reduce memory consumption.`,name:"return_logits"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L941",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>all_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_ref_logprobs (<code>torch.FloatTensor</code>): Log probabilities of the responses,
shape (<code>batch_size</code>, <code>response_length</code>)</li>
<li>all_values (<code>torch.FloatTensor</code>): Values of the responses, shape (<code>batch_size</code>, <code>response_length</code>)</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(tuple)</p>
`}}),Te=new f({props:{name:"compute_rewards",anchor:"trl.PPOTrainer.compute_rewards",parameters:[{name:"scores",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"ref_logprobs",val:": FloatTensor"},{name:"masks",val:": LongTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.compute_rewards.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code>) &#x2014;
Scores from the reward model, shape (<code>batch_size</code>)`,name:"scores"},{anchor:"trl.PPOTrainer.compute_rewards.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"},{anchor:"trl.PPOTrainer.compute_rewards.ref_logprobs",description:`<strong>ref_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the reference model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"ref_logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1078",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Per token rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: Non score rewards, shape (<code>batch_size</code>, <code>response_length</code>)
<code>torch.FloatTensor</code>: KL penalty, shape (<code>batch_size</code>, <code>response_length</code>)</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),ye=new f({props:{name:"create_model_card",anchor:"trl.PPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL Model'"}],parametersDescription:[{anchor:"trl.PPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.PPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1386"}}),xe=new f({props:{name:"gather_stats",anchor:"trl.PPOTrainer.gather_stats",parameters:[{name:"stats",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.gather_stats.stats",description:"<strong>stats</strong> (dict[str, Any]) &#x2014;",name:"stats"},{anchor:"trl.PPOTrainer.gather_stats.a",description:"<strong>a</strong> dictionary of stats to be gathered. The stats should contain torch tensors. &#x2014;",name:"a"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L897",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary of stats with the tensors gathered.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),$e=new f({props:{name:"generate",anchor:"trl.PPOTrainer.generate",parameters:[{name:"query_tensor",val:": typing.Union[torch.Tensor, typing.List[torch.Tensor]]"},{name:"length_sampler",val:": typing.Callable = None"},{name:"batch_size",val:": int = 4"},{name:"return_prompt",val:": bool = True"},{name:"generate_ref_response",val:": bool = False"},{name:"**generation_kwargs",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.generate.query_tensor",description:`<strong>query_tensor</strong> (<code>torch.LongTensor</code>) &#x2014;
A tensor of shape (<code>seq_len</code>) containing query tokens or a list of tensors of shape (<code>seq_len</code>).`,name:"query_tensor"},{anchor:"trl.PPOTrainer.generate.generation_kwargs",description:`<strong>generation_kwargs</strong> (dict[str, Any]) &#x2014;
Keyword arguments for generation.`,name:"generation_kwargs"},{anchor:"trl.PPOTrainer.generate.length_sampler",description:`<strong>length_sampler</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Callable that returns the number of newly generated tokens.`,name:"length_sampler"},{anchor:"trl.PPOTrainer.generate.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, *optional) &#x2014;
Batch size used for generation, defaults to <code>4</code>.`,name:"batch_size"},{anchor:"trl.PPOTrainer.generate.return_prompt",description:`<strong>return_prompt</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>False</code> the prompt is not returned but only the newly generated tokens, defaults to <code>True</code>.`,name:"return_prompt"},{anchor:"trl.PPOTrainer.generate.generate_ref_response",description:`<strong>generate_ref_response</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code> the reference response is also generated, defaults to <code>False</code>.`,name:"generate_ref_response"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (<code>batch_size</code>, <code>gen_len</code>) containing response tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code></p>
`}}),Pe=new f({props:{name:"log_stats",anchor:"trl.PPOTrainer.log_stats",parameters:[{name:"stats",val:": dict"},{name:"batch",val:": dict"},{name:"rewards",val:": typing.List[torch.FloatTensor]"},{name:"columns_to_log",val:": typing.List[str] = ['query', 'response']"}],parametersDescription:[{anchor:"trl.PPOTrainer.log_stats.stats",description:`<strong>stats</strong> (dict[str, Any]) &#x2014;
A dictionary of training stats.`,name:"stats"},{anchor:"trl.PPOTrainer.log_stats.batch",description:`<strong>batch</strong> (dict[str, Any]) &#x2014;
A dictionary of batch data, this contains the queries and responses.`,name:"batch"},{anchor:"trl.PPOTrainer.log_stats.rewards",description:`<strong>rewards</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
A tensor of rewards.`,name:"rewards"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1313"}}),Oe=new f({props:{name:"loss",anchor:"trl.PPOTrainer.loss",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.loss.old_logprobs",description:`<strong>old_logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"old_logprobs"},{anchor:"trl.PPOTrainer.loss.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"values"},{anchor:"trl.PPOTrainer.loss.rewards",description:`<strong>rewards</strong> (<code>torch.FloatTensor</code>) &#x2014;
Rewards from the reward model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"rewards"},{anchor:"trl.PPOTrainer.loss.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
Logits of the model, shape (<code>batch_size</code>, <code>response_length</code>, <code>vocab_size</code>)`,name:"logits"},{anchor:"trl.PPOTrainer.loss.v_pred",description:`<strong>v_pred</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"v_pred"},{anchor:"trl.PPOTrainer.loss.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape (<code>batch_size</code>, <code>response_length</code>)`,name:"logprobs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1160"}}),De=new f({props:{name:"prepare_dataloader",anchor:"trl.PPOTrainer.prepare_dataloader",parameters:[{name:"dataset",val:": typing.Union[torch.utils.data.dataset.Dataset, datasets.arrow_dataset.Dataset]"},{name:"data_collator",val:" = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.prepare_dataloader.dataset",description:`<strong>dataset</strong> (Union[<code>torch.utils.data.Dataset</code>, <code>datasets.Dataset</code>]) &#x2014;
PyTorch dataset or Hugging Face dataset. If a Hugging Face dataset is passed, the dataset
will be preprocessed by removing the columns that are not used by the model.`,name:"dataset"},{anchor:"trl.PPOTrainer.prepare_dataloader.data_collator",description:`<strong>data_collator</strong> (Optional[function]) &#x2014;
Data collator function.`,name:"data_collator"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L376",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>PyTorch dataloader</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.data.DataLoader</code></p>
`}}),we=new f({props:{name:"record_step_stats",anchor:"trl.PPOTrainer.record_step_stats",parameters:[{name:"kl_coef",val:": float"},{name:"**data",val:""}],parametersDescription:[{anchor:"trl.PPOTrainer.record_step_stats.kl_coef",description:`<strong>kl_coef</strong> (<code>float</code>) &#x2014;
KL coefficient`,name:"kl_coef"},{anchor:"trl.PPOTrainer.record_step_stats.data",description:`<strong>data</strong> (<code>dict</code>) &#x2014;
Dictionary of training step data`,name:"data"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1249",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training step statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stats (<code>dict</code>)</p>
`}}),ke=new f({props:{name:"step",anchor:"trl.PPOTrainer.step",parameters:[{name:"queries",val:": typing.List[torch.LongTensor]"},{name:"responses",val:": typing.List[torch.LongTensor]"},{name:"scores",val:": typing.List[torch.FloatTensor]"},{name:"response_masks",val:": typing.Optional[typing.List[torch.LongTensor]] = None"}],parametersDescription:[{anchor:"trl.PPOTrainer.step.queries",description:`<strong>queries</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded queries of shape (<code>query_length</code>)`,name:"queries"},{anchor:"trl.PPOTrainer.step.responses",description:`<strong>responses</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the encoded responses of shape (<code>response_length</code>)`,name:"responses"},{anchor:"trl.PPOTrainer.step.scores",description:`<strong>scores</strong> (List<code>torch.FloatTensor</code>) &#x2014;
List of tensors containing the scores.`,name:"scores"},{anchor:"trl.PPOTrainer.step.response_masks",description:`<strong>response_masks</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>)) &#x2014;
List of tensors containing masks of the response tokens.`,name:"response_masks"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),Ce=new f({props:{name:"train_minibatch",anchor:"trl.PPOTrainer.train_minibatch",parameters:[{name:"old_logprobs",val:": FloatTensor"},{name:"values",val:": FloatTensor"},{name:"logprobs",val:": FloatTensor"},{name:"logits",val:": FloatTensor"},{name:"vpreds",val:": FloatTensor"},{name:"mask",val:": LongTensor"},{name:"advantages",val:": FloatTensor"},{name:"returns",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.PPOTrainer.train_minibatch.logprobs",description:`<strong>logprobs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Log probabilities of the model, shape [mini_batch_size, response_length]`,name:"logprobs"},{anchor:"trl.PPOTrainer.train_minibatch.values",description:`<strong>values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Values of the value head, shape [mini_batch_size, response_length]`,name:"values"},{anchor:"trl.PPOTrainer.train_minibatch.query",description:`<strong>query</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded queries, shape [mini_batch_size, query_length]`,name:"query"},{anchor:"trl.PPOTrainer.train_minibatch.response",description:`<strong>response</strong> (<code>torch.LongTensor</code>) &#x2014;
Encoded responses, shape [mini_batch_size, response_length]`,name:"response"},{anchor:"trl.PPOTrainer.train_minibatch.model_input",description:`<strong>model_input</strong> (<code>torch.LongTensor</code>) &#x2014;
Concatenated queries and responses, shape [mini_batch_size, query_length+response_length]`,name:"model_input"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ppo_trainer.py#L1032",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>train_stats (dict[str, <code>torch.Tensor</code>])</p>
`}}),Le=new L({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),Ne=new f({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Optional[typing.Dict] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Optional[str] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"deepspeed",val:": typing.Optional[str] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Optional[typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": typing.Optional[bool] = True"},{name:"gradient_checkpointing_kwargs",val:": typing.Optional[dict] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = False"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": float = None"},{name:"max_length",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/training_configs.py#L23"}}),Fe=new L({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),ze=new f({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"},{name:"args",val:": typing.Optional[trl.trainer.training_configs.RewardConfig] = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),Ie=new L({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Me=new f({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalPrediction], typing.Dict], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"dataset_text_field",val:": typing.Optional[str] = None"},{name:"packing",val:": typing.Optional[bool] = False"},{name:"formatting_func",val:": typing.Optional[typing.Callable] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"infinite",val:": typing.Optional[bool] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = 1024"},{name:"chars_per_token",val:": typing.Optional[float] = 3.6"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"dataset_kwargs",val:": typing.Optional[typing.Dict] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/sft_trainer.py#L53"}}),qe=new L({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),Se=new f({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge', 'ipo', 'kto'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"model_adapter_name",val:": str = None"},{name:"ref_adapter_name",val:": str = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L64"}}),Ae=new f({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L523"}}),Ee=new f({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L731"}}),He=new f({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L934"}}),Ue=new f({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L755",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Re=new f({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L817",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),Ve=new f({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1154"}}),je=new f({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L898",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),We=new f({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L980"}}),Be=new f({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1063"}}),Ke=new f({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L471"}}),Ge=new f({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L428"}}),Je=new f({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1204"}}),Ye=new f({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L719"}}),Ze=new f({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L573"}}),Qe=new L({props:{title:"DDPOConfig",local:"trl.DDPOConfig",headingTag:"h2"}}),Xe=new f({props:{name:"class trl.DDPOConfig",anchor:"trl.DDPOConfig",parameters:[{name:"exp_name",val:": str = 'doc-buil'"},{name:"run_name",val:": typing.Optional[str] = ''"},{name:"seed",val:": int = 0"},{name:"log_with",val:": typing.Union[typing.Literal['wandb', 'tensorboard'], NoneType] = None"},{name:"tracker_kwargs",val:": dict = <factory>"},{name:"accelerator_kwargs",val:": dict = <factory>"},{name:"project_kwargs",val:": dict = <factory>"},{name:"tracker_project_name",val:": str = 'trl'"},{name:"logdir",val:": str = 'logs'"},{name:"num_epochs",val:": int = 100"},{name:"save_freq",val:": int = 1"},{name:"num_checkpoint_limit",val:": int = 5"},{name:"mixed_precision",val:": str = 'fp16'"},{name:"allow_tf32",val:": bool = True"},{name:"resume_from",val:": typing.Optional[str] = ''"},{name:"sample_num_steps",val:": int = 50"},{name:"sample_eta",val:": float = 1.0"},{name:"sample_guidance_scale",val:": float = 5.0"},{name:"sample_batch_size",val:": int = 1"},{name:"sample_num_batches_per_epoch",val:": int = 2"},{name:"train_batch_size",val:": int = 1"},{name:"train_use_8bit_adam",val:": bool = False"},{name:"train_learning_rate",val:": float = 0.0003"},{name:"train_adam_beta1",val:": float = 0.9"},{name:"train_adam_beta2",val:": float = 0.999"},{name:"train_adam_weight_decay",val:": float = 0.0001"},{name:"train_adam_epsilon",val:": float = 1e-08"},{name:"train_gradient_accumulation_steps",val:": int = 1"},{name:"train_max_grad_norm",val:": float = 1.0"},{name:"train_num_inner_epochs",val:": int = 1"},{name:"train_cfg",val:": bool = True"},{name:"train_adv_clip_max",val:": float = 5"},{name:"train_clip_range",val:": float = 0.0001"},{name:"train_timestep_fraction",val:": float = 1.0"},{name:"per_prompt_stat_tracking",val:": bool = False"},{name:"per_prompt_stat_tracking_buffer_size",val:": int = 16"},{name:"per_prompt_stat_tracking_min_count",val:": int = 16"},{name:"async_reward_computation",val:": bool = False"},{name:"max_workers",val:": int = 2"},{name:"negative_prompts",val:": typing.Optional[str] = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_config.py#L12"}}),et=new L({props:{title:"DDPOTrainer",local:"trl.DDPOTrainer",headingTag:"h2"}}),tt=new f({props:{name:"class trl.DDPOTrainer",anchor:"trl.DDPOTrainer",parameters:[{name:"config",val:": DDPOConfig"},{name:"reward_function",val:": typing.Callable[[torch.Tensor, typing.Tuple[str], typing.Tuple[typing.Any]], torch.Tensor]"},{name:"prompt_function",val:": typing.Callable[[], typing.Tuple[str, typing.Any]]"},{name:"sd_pipeline",val:": DDPOStableDiffusionPipeline"},{name:"image_samples_hook",val:": typing.Union[typing.Callable[[typing.Any, typing.Any, typing.Any], typing.Any], NoneType] = None"}],parametersDescription:[{anchor:"trl.DDPOTrainer.*config**",description:`*<strong>*config**</strong> (<code>DDPOConfig</code>) &#x2014; Configuration object for DDPOTrainer. Check the documentation of <code>PPOConfig</code> for more &#x2014;
details.`,name:"*config**"},{anchor:"trl.DDPOTrainer.*reward_function**",description:"*<strong>*reward_function**</strong> (Callable[[torch.Tensor, Tuple[str], Tuple[Any]], torch.Tensor]) &#x2014; Reward function to be used &#x2014;",name:"*reward_function**"},{anchor:"trl.DDPOTrainer.*prompt_function**",description:"*<strong>*prompt_function**</strong> (Callable[[], Tuple[str, Any]]) &#x2014; Function to generate prompts to guide model &#x2014;",name:"*prompt_function**"},{anchor:"trl.DDPOTrainer.*sd_pipeline**",description:"*<strong>*sd_pipeline**</strong> (<code>DDPOStableDiffusionPipeline</code>) &#x2014; Stable Diffusion pipeline to be used for training. &#x2014;",name:"*sd_pipeline**"},{anchor:"trl.DDPOTrainer.*image_samples_hook**",description:"*<strong>*image_samples_hook**</strong> (Optional[Callable[[Any, Any, Any], Any]]) &#x2014; Hook to be called to log images &#x2014;",name:"*image_samples_hook**"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L55"}}),nt=new f({props:{name:"calculate_loss",anchor:"trl.DDPOTrainer.calculate_loss",parameters:[{name:"latents",val:""},{name:"timesteps",val:""},{name:"next_latents",val:""},{name:"log_probs",val:""},{name:"advantages",val:""},{name:"embeds",val:""}],parametersDescription:[{anchor:"trl.DDPOTrainer.calculate_loss.latents",description:`<strong>latents</strong> (torch.Tensor) &#x2014;
The latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"latents"},{anchor:"trl.DDPOTrainer.calculate_loss.timesteps",description:`<strong>timesteps</strong> (torch.Tensor) &#x2014;
The timesteps sampled from the diffusion model, shape: [batch_size]`,name:"timesteps"},{anchor:"trl.DDPOTrainer.calculate_loss.next_latents",description:`<strong>next_latents</strong> (torch.Tensor) &#x2014;
The next latents sampled from the diffusion model, shape: [batch_size, num_channels_latents, height, width]`,name:"next_latents"},{anchor:"trl.DDPOTrainer.calculate_loss.log_probs",description:`<strong>log_probs</strong> (torch.Tensor) &#x2014;
The log probabilities of the latents, shape: [batch_size]`,name:"log_probs"},{anchor:"trl.DDPOTrainer.calculate_loss.advantages",description:`<strong>advantages</strong> (torch.Tensor) &#x2014;
The advantages of the latents, shape: [batch_size]`,name:"advantages"},{anchor:"trl.DDPOTrainer.calculate_loss.embeds",description:`<strong>embeds</strong> (torch.Tensor) &#x2014;
The embeddings of the prompts, shape: [2*batch_size or batch_size, &#x2026;]
Note: the &#x201C;or&#x201D; is because if train_cfg is True, the expectation is that negative prompts are concatenated to the embeds`,name:"embeds"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L340",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>loss (torch.Tensor), approx_kl (torch.Tensor), clipfrac (torch.Tensor)
(all of these are of shape (1,))</p>
`}}),at=new f({props:{name:"create_model_card",anchor:"trl.DDPOTrainer.create_model_card",parameters:[{name:"path",val:": str"},{name:"model_name",val:": typing.Optional[str] = 'TRL DDPO Model'"}],parametersDescription:[{anchor:"trl.DDPOTrainer.create_model_card.path",description:"<strong>path</strong> (<code>str</code>) &#x2014; The path to save the model card to.",name:"path"},{anchor:"trl.DDPOTrainer.create_model_card.model_name",description:"<strong>model_name</strong> (<code>str</code>, <em>optional</em>) &#x2014; The name of the model, defaults to <code>TRL DDPO Model</code>.",name:"model_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L606"}}),rt=new f({props:{name:"step",anchor:"trl.DDPOTrainer.step",parameters:[{name:"epoch",val:": int"},{name:"global_step",val:": int"}],parametersDescription:[{anchor:"trl.DDPOTrainer.step.epoch",description:"<strong>epoch</strong> (int) &#x2014; The current epoch.",name:"epoch"},{anchor:"trl.DDPOTrainer.step.global_step",description:"<strong>global_step</strong> (int) &#x2014; The current global step.",name:"global_step"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L234",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The updated global step.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>global_step (int)</p>
`}}),ot=new f({props:{name:"train",anchor:"trl.DDPOTrainer.train",parameters:[{name:"epochs",val:": typing.Optional[int] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/ddpo_trainer.py#L596"}}),it=new L({props:{title:"IterativeSFTTrainer",local:"trl.IterativeSFTTrainer",headingTag:"h2"}}),st=new f({props:{name:"class trl.IterativeSFTTrainer",anchor:"trl.IterativeSFTTrainer",parameters:[{name:"model",val:": PreTrainedModel = None"},{name:"args",val:": TrainingArguments = None"},{name:"tokenizer",val:": PreTrainedTokenizerBase = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": typing.Optional[str] = 'keep_end'"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"optimize_device_cache",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.*model**",description:`*<strong>*model**</strong> (<code>PreTrainedModel</code>) &#x2014; Model to be optimized, either an &#x2018;AutoModelForCausalLM&#x2019; or an &#x2018;AutoModelForSeq2SeqLM&#x2019;. &#x2014;
Check the documentation of <code>PreTrainedModel</code> for more details.`,name:"*model**"},{anchor:"trl.IterativeSFTTrainer.*args**",description:"*<strong>*args**</strong> (<code>transformers.TrainingArguments</code>) &#x2014; &#x2014; The arguments to use for training.",name:"*args**"},{anchor:"trl.IterativeSFTTrainer.*tokenizer**",description:`*<strong>*tokenizer**</strong> (<code>PreTrainedTokenizerBase</code>) &#x2014; Tokenizer to be used for encoding the &#x2014;
data. Check the documentation of <code>transformers.PreTrainedTokenizer</code> and
<code>transformers.PreTrainedTokenizerFast</code> for more details.`,name:"*tokenizer**"},{anchor:"trl.IterativeSFTTrainer.*optimizers**",description:"*<strong>*optimizers**</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014; &#x2014; The optimizer and scheduler to use for training.",name:"*optimizers**"},{anchor:"trl.IterativeSFTTrainer.*data_collator**",description:`*<strong>*data_collator**</strong> (Union[DataCollatorForLanguageModeling, DataCollatorForSeq2Seq], <em>optional</em>) &#x2014; Data collator to be used for training and &#x2014;
passed along the dataloader.`,name:"*data_collator**"},{anchor:"trl.IterativeSFTTrainer.*eval_dataset**",description:"*<strong>*eval_dataset**</strong> (<code>datasets.Dataset</code>) &#x2014; The dataset to use for evaluation.",name:"*eval_dataset**"},{anchor:"trl.IterativeSFTTrainer.*max_length**",description:"*<strong>*max_length**</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014; &#x2014; The maximum length of the input.",name:"*max_length**"},{anchor:"trl.IterativeSFTTrainer.*truncation_mode**",description:"*<strong>*truncation_mode**</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014; &#x2014; The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>.",name:"*truncation_mode**"},{anchor:"trl.IterativeSFTTrainer.*preprocess_logits_for_metrics**",description:"*<strong>*preprocess_logits_for_metrics**</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014; &#x2014; The function to use to preprocess the logits before computing the metrics.",name:"*preprocess_logits_for_metrics**"},{anchor:"trl.IterativeSFTTrainer.*compute_metrics**",description:"*<strong>*compute_metrics**</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014; &#x2014; The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return a dictionary string to metric values.",name:"*compute_metrics**"},{anchor:"trl.IterativeSFTTrainer.*optimize_device_cache",description:"*<strong>*optimize_device_cache</strong> *<em> (<code>bool</code>, </em>optional*, defaults to <code>False</code>) &#x2014; Optimize CUDA cache for slightly more memory-efficient training. &#x2014;",name:"*optimize_device_cache"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L39"}}),lt=new f({props:{name:"step",anchor:"trl.IterativeSFTTrainer.step",parameters:[{name:"input_ids",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"attention_mask",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"labels",val:": typing.Optional[typing.List[torch.LongTensor]] = None"},{name:"texts",val:": typing.Optional[typing.List[str]] = None"},{name:"texts_labels",val:": typing.Optional[typing.List[str]] = None"}],parametersDescription:[{anchor:"trl.IterativeSFTTrainer.step.input_ids",description:`<strong>input_ids</strong> (List<code>torch.LongTensor</code>) &#x2014;
List of tensors containing the input_ids (if not provided, text will be used)`,name:"input_ids"},{anchor:"trl.IterativeSFTTrainer.step.attention_mask",description:`<strong>attention_mask</strong> (List<code>torch.LongTensor</code>, , <em>optional</em>) &#x2014;
List of tensors containing the attention_mask`,name:"attention_mask"},{anchor:"trl.IterativeSFTTrainer.step.labels",description:`<strong>labels</strong> (List<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of tensors containing the labels (if set to None, will default to input_ids)`,name:"labels"},{anchor:"trl.IterativeSFTTrainer.step.texts",description:`<strong>texts</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text input (if not provided, input_ids will directly be used)`,name:"texts"},{anchor:"trl.IterativeSFTTrainer.step.texts_labels",description:`<strong>texts_labels</strong> (List<code>str</code>, <em>optional</em>) &#x2014;
List of strings containing the text labels (if set to None, will default to text)`,name:"texts_labels"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/iterative_sft_trainer.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A summary of the training statistics</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict[str, Any]</code></p>
`}}),dt=new L({props:{title:"set_seed",local:"trl.set_seed",headingTag:"h2"}}),ct=new f({props:{name:"trl.set_seed",anchor:"trl.set_seed",parameters:[{name:"seed",val:": int"}],parametersDescription:[{anchor:"trl.set_seed.seed",description:"<strong>seed</strong> (<code>int</code>) &#x2014; The seed to set.",name:"seed"}],source:"https://github.com/huggingface/trl/blob/main/trl/core.py#L209"}}),{c(){q=r("meta"),vn=n(),un=r("p"),bn=n(),d(ge.$$.fragment),Tn=n(),he=r("p"),he.innerHTML=Br,yn=n(),d(_e.$$.fragment),xn=n(),S=r("div"),d(ue.$$.fragment),fa=n(),pt=r("p"),pt.textContent=Kr,$n=n(),d(fe.$$.fragment),Pn=n(),y=r("div"),d(ve.$$.fragment),va=n(),mt=r("p"),mt.innerHTML=Gr,ba=n(),U=r("div"),d(be.$$.fragment),Ta=n(),gt=r("p"),gt.textContent=Jr,ya=n(),R=r("div"),d(Te.$$.fragment),xa=n(),ht=r("p"),ht.textContent=Yr,$a=n(),V=r("div"),d(ye.$$.fragment),Pa=n(),_t=r("p"),_t.textContent=Zr,Oa=n(),j=r("div"),d(xe.$$.fragment),Da=n(),ut=r("p"),ut.textContent=Qr,wa=n(),W=r("div"),d($e.$$.fragment),ka=n(),ft=r("p"),ft.innerHTML=Xr,Ca=n(),B=r("div"),d(Pe.$$.fragment),La=n(),vt=r("p"),vt.textContent=eo,Na=n(),K=r("div"),d(Oe.$$.fragment),Fa=n(),bt=r("p"),bt.textContent=to,za=n(),G=r("div"),d(De.$$.fragment),Ia=n(),Tt=r("p"),Tt.textContent=no,Ma=n(),J=r("div"),d(we.$$.fragment),qa=n(),yt=r("p"),yt.textContent=ao,Sa=n(),Y=r("div"),d(ke.$$.fragment),Aa=n(),xt=r("p"),xt.textContent=ro,Ea=n(),Z=r("div"),d(Ce.$$.fragment),Ha=n(),$t=r("p"),$t.textContent=oo,On=n(),d(Le.$$.fragment),Dn=n(),k=r("div"),d(Ne.$$.fragment),Ua=n(),Pt=r("p"),Pt.innerHTML=io,Ra=n(),Ot=r("p"),Ot.innerHTML=so,wn=n(),d(Fe.$$.fragment),kn=n(),P=r("div"),d(ze.$$.fragment),Va=n(),Dt=r("p"),Dt.innerHTML=lo,ja=n(),wt=r("p"),wt.innerHTML=co,Wa=n(),kt=r("ul"),kt.innerHTML=po,Ba=n(),Ct=r("p"),Ct.innerHTML=mo,Cn=n(),d(Ie.$$.fragment),Ln=n(),A=r("div"),d(Me.$$.fragment),Ka=n(),Lt=r("p"),Lt.innerHTML=go,Nn=n(),d(qe.$$.fragment),Fn=n(),v=r("div"),d(Se.$$.fragment),Ga=n(),Nt=r("p"),Nt.textContent=ho,Ja=n(),Q=r("div"),d(Ae.$$.fragment),Ya=n(),Ft=r("p"),Ft.innerHTML=_o,Za=n(),X=r("div"),d(Ee.$$.fragment),Qa=n(),zt=r("p"),zt.textContent=uo,Xa=n(),N=r("div"),d(He.$$.fragment),er=n(),It=r("p"),It.textContent=fo,tr=n(),Mt=r("p"),Mt.textContent=vo,nr=n(),ee=r("div"),d(Ue.$$.fragment),ar=n(),qt=r("p"),qt.textContent=bo,rr=n(),te=r("div"),d(Re.$$.fragment),or=n(),St=r("p"),St.textContent=To,ir=n(),F=r("div"),d(Ve.$$.fragment),sr=n(),At=r("p"),At.innerHTML=yo,lr=n(),Et=r("p"),Et.textContent=xo,dr=n(),ne=r("div"),d(je.$$.fragment),cr=n(),Ht=r("p"),Ht.textContent=$o,pr=n(),ae=r("div"),d(We.$$.fragment),mr=n(),Ut=r("p"),Ut.textContent=Po,gr=n(),re=r("div"),d(Be.$$.fragment),hr=n(),Rt=r("p"),Rt.textContent=Oo,_r=n(),z=r("div"),d(Ke.$$.fragment),ur=n(),Vt=r("p"),Vt.innerHTML=Do,fr=n(),jt=r("p"),jt.innerHTML=wo,vr=n(),I=r("div"),d(Ge.$$.fragment),br=n(),Wt=r("p"),Wt.innerHTML=ko,Tr=n(),Bt=r("p"),Bt.innerHTML=Co,yr=n(),oe=r("div"),d(Je.$$.fragment),xr=n(),Kt=r("p"),Kt.innerHTML=Lo,$r=n(),ie=r("div"),d(Ye.$$.fragment),Pr=n(),Gt=r("p"),Gt.textContent=No,Or=n(),O=r("div"),d(Ze.$$.fragment),Dr=n(),Jt=r("p"),Jt.textContent=Fo,wr=n(),Yt=r("p"),Yt.textContent=zo,kr=n(),Zt=r("p"),Zt.textContent=Io,zn=n(),d(Qe.$$.fragment),In=n(),E=r("div"),d(Xe.$$.fragment),Cr=n(),Qt=r("p"),Qt.textContent=Mo,Mn=n(),d(et.$$.fragment),qn=n(),$=r("div"),d(tt.$$.fragment),Lr=n(),Xt=r("p"),Xt.innerHTML=qo,Nr=n(),se=r("div"),d(nt.$$.fragment),Fr=n(),en=r("p"),en.textContent=So,zr=n(),le=r("div"),d(at.$$.fragment),Ir=n(),tn=r("p"),tn.textContent=Ao,Mr=n(),D=r("div"),d(rt.$$.fragment),qr=n(),nn=r("p"),nn.textContent=Eo,Sr=n(),an=r("p"),an.textContent=Ho,Ar=n(),rn=r("ul"),rn.innerHTML=Uo,Er=n(),de=r("div"),d(ot.$$.fragment),Hr=n(),on=r("p"),on.textContent=Ro,Sn=n(),d(it.$$.fragment),An=n(),C=r("div"),d(st.$$.fragment),Ur=n(),sn=r("p"),sn.textContent=Vo,Rr=n(),ce=r("div"),d(lt.$$.fragment),Vr=n(),ln=r("p"),ln.textContent=jo,En=n(),d(dt.$$.fragment),Hn=n(),H=r("div"),d(ct.$$.fragment),jr=n(),dn=r("p"),dn.innerHTML=Wo,Un=n(),fn=r("p"),this.h()},l(e){const l=Zo("svelte-u9bgzb",document.head);q=o(l,"META",{name:!0,content:!0}),l.forEach(i),vn=a(e),un=o(e,"P",{}),_(un).forEach(i),bn=a(e),c(ge.$$.fragment,e),Tn=a(e),he=o(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-dxrcnp"&&(he.innerHTML=Br),yn=a(e),c(_e.$$.fragment,e),xn=a(e),S=o(e,"DIV",{class:!0});var Vn=_(S);c(ue.$$.fragment,Vn),fa=a(Vn),pt=o(Vn,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-aondqr"&&(pt.textContent=Kr),Vn.forEach(i),$n=a(e),c(fe.$$.fragment,e),Pn=a(e),y=o(e,"DIV",{class:!0});var x=_(y);c(ve.$$.fragment,x),va=a(x),mt=o(x,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-hys9rl"&&(mt.innerHTML=Gr),ba=a(x),U=o(x,"DIV",{class:!0});var jn=_(U);c(be.$$.fragment,jn),Ta=a(jn),gt=o(jn,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-185nst0"&&(gt.textContent=Jr),jn.forEach(i),ya=a(x),R=o(x,"DIV",{class:!0});var Wn=_(R);c(Te.$$.fragment,Wn),xa=a(Wn),ht=o(Wn,"P",{"data-svelte-h":!0}),s(ht)!=="svelte-3nt516"&&(ht.textContent=Yr),Wn.forEach(i),$a=a(x),V=o(x,"DIV",{class:!0});var Bn=_(V);c(ye.$$.fragment,Bn),Pa=a(Bn),_t=o(Bn,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-3jfrz9"&&(_t.textContent=Zr),Bn.forEach(i),Oa=a(x),j=o(x,"DIV",{class:!0});var Kn=_(j);c(xe.$$.fragment,Kn),Da=a(Kn),ut=o(Kn,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-lcc1u3"&&(ut.textContent=Qr),Kn.forEach(i),wa=a(x),W=o(x,"DIV",{class:!0});var Gn=_(W);c($e.$$.fragment,Gn),ka=a(Gn),ft=o(Gn,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-1gqqzmu"&&(ft.innerHTML=Xr),Gn.forEach(i),Ca=a(x),B=o(x,"DIV",{class:!0});var Jn=_(B);c(Pe.$$.fragment,Jn),La=a(Jn),vt=o(Jn,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-ffqz5"&&(vt.textContent=eo),Jn.forEach(i),Na=a(x),K=o(x,"DIV",{class:!0});var Yn=_(K);c(Oe.$$.fragment,Yn),Fa=a(Yn),bt=o(Yn,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-febvhf"&&(bt.textContent=to),Yn.forEach(i),za=a(x),G=o(x,"DIV",{class:!0});var Zn=_(G);c(De.$$.fragment,Zn),Ia=a(Zn),Tt=o(Zn,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-1hbodkw"&&(Tt.textContent=no),Zn.forEach(i),Ma=a(x),J=o(x,"DIV",{class:!0});var Qn=_(J);c(we.$$.fragment,Qn),qa=a(Qn),yt=o(Qn,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-1hfgx92"&&(yt.textContent=ao),Qn.forEach(i),Sa=a(x),Y=o(x,"DIV",{class:!0});var Xn=_(Y);c(ke.$$.fragment,Xn),Aa=a(Xn),xt=o(Xn,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-yrsdu6"&&(xt.textContent=ro),Xn.forEach(i),Ea=a(x),Z=o(x,"DIV",{class:!0});var ea=_(Z);c(Ce.$$.fragment,ea),Ha=a(ea),$t=o(ea,"P",{"data-svelte-h":!0}),s($t)!=="svelte-3k7k5e"&&($t.textContent=oo),ea.forEach(i),x.forEach(i),On=a(e),c(Le.$$.fragment,e),Dn=a(e),k=o(e,"DIV",{class:!0});var cn=_(k);c(Ne.$$.fragment,cn),Ua=a(cn),Pt=o(cn,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1alpag9"&&(Pt.innerHTML=io),Ra=a(cn),Ot=o(cn,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-1xl7jqc"&&(Ot.innerHTML=so),cn.forEach(i),wn=a(e),c(Fe.$$.fragment,e),kn=a(e),P=o(e,"DIV",{class:!0});var M=_(P);c(ze.$$.fragment,M),Va=a(M),Dt=o(M,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-qafafj"&&(Dt.innerHTML=lo),ja=a(M),wt=o(M,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-bkmbwh"&&(wt.innerHTML=co),Wa=a(M),kt=o(M,"UL",{"data-svelte-h":!0}),s(kt)!=="svelte-1ytuxgw"&&(kt.innerHTML=po),Ba=a(M),Ct=o(M,"P",{"data-svelte-h":!0}),s(Ct)!=="svelte-18tbp4c"&&(Ct.innerHTML=mo),M.forEach(i),Cn=a(e),c(Ie.$$.fragment,e),Ln=a(e),A=o(e,"DIV",{class:!0});var ta=_(A);c(Me.$$.fragment,ta),Ka=a(ta),Lt=o(ta,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-14oyph8"&&(Lt.innerHTML=go),ta.forEach(i),Nn=a(e),c(qe.$$.fragment,e),Fn=a(e),v=o(e,"DIV",{class:!0});var T=_(v);c(Se.$$.fragment,T),Ga=a(T),Nt=o(T,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-n6cc8y"&&(Nt.textContent=ho),Ja=a(T),Q=o(T,"DIV",{class:!0});var na=_(Q);c(Ae.$$.fragment,na),Ya=a(na),Ft=o(na,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-mcz8nm"&&(Ft.innerHTML=_o),na.forEach(i),Za=a(T),X=o(T,"DIV",{class:!0});var aa=_(X);c(Ee.$$.fragment,aa),Qa=a(aa),zt=o(aa,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-10t1062"&&(zt.textContent=uo),aa.forEach(i),Xa=a(T),N=o(T,"DIV",{class:!0});var pn=_(N);c(He.$$.fragment,pn),er=a(pn),It=o(pn,"P",{"data-svelte-h":!0}),s(It)!=="svelte-16i1nac"&&(It.textContent=fo),tr=a(pn),Mt=o(pn,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-tgti68"&&(Mt.textContent=vo),pn.forEach(i),nr=a(T),ee=o(T,"DIV",{class:!0});var ra=_(ee);c(Ue.$$.fragment,ra),ar=a(ra),qt=o(ra,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-1cvsgkk"&&(qt.textContent=bo),ra.forEach(i),rr=a(T),te=o(T,"DIV",{class:!0});var oa=_(te);c(Re.$$.fragment,oa),or=a(oa),St=o(oa,"P",{"data-svelte-h":!0}),s(St)!=="svelte-ymgxq7"&&(St.textContent=To),oa.forEach(i),ir=a(T),F=o(T,"DIV",{class:!0});var mn=_(F);c(Ve.$$.fragment,mn),sr=a(mn),At=o(mn,"P",{"data-svelte-h":!0}),s(At)!=="svelte-8qlty5"&&(At.innerHTML=yo),lr=a(mn),Et=o(mn,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-1tyo99t"&&(Et.textContent=xo),mn.forEach(i),dr=a(T),ne=o(T,"DIV",{class:!0});var ia=_(ne);c(je.$$.fragment,ia),cr=a(ia),Ht=o(ia,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-4nmimv"&&(Ht.textContent=$o),ia.forEach(i),pr=a(T),ae=o(T,"DIV",{class:!0});var sa=_(ae);c(We.$$.fragment,sa),mr=a(sa),Ut=o(sa,"P",{"data-svelte-h":!0}),s(Ut)!=="svelte-11q8u7l"&&(Ut.textContent=Po),sa.forEach(i),gr=a(T),re=o(T,"DIV",{class:!0});var la=_(re);c(Be.$$.fragment,la),hr=a(la),Rt=o(la,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-18uwvbi"&&(Rt.textContent=Oo),la.forEach(i),_r=a(T),z=o(T,"DIV",{class:!0});var gn=_(z);c(Ke.$$.fragment,gn),ur=a(gn),Vt=o(gn,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-xesobz"&&(Vt.innerHTML=Do),fr=a(gn),jt=o(gn,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-qg43tm"&&(jt.innerHTML=wo),gn.forEach(i),vr=a(T),I=o(T,"DIV",{class:!0});var hn=_(I);c(Ge.$$.fragment,hn),br=a(hn),Wt=o(hn,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-dkae9b"&&(Wt.innerHTML=ko),Tr=a(hn),Bt=o(hn,"P",{"data-svelte-h":!0}),s(Bt)!=="svelte-hmd5cw"&&(Bt.innerHTML=Co),hn.forEach(i),yr=a(T),oe=o(T,"DIV",{class:!0});var da=_(oe);c(Je.$$.fragment,da),xr=a(da),Kt=o(da,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-nqksfz"&&(Kt.innerHTML=Lo),da.forEach(i),$r=a(T),ie=o(T,"DIV",{class:!0});var ca=_(ie);c(Ye.$$.fragment,ca),Pr=a(ca),Gt=o(ca,"P",{"data-svelte-h":!0}),s(Gt)!=="svelte-17kjsy4"&&(Gt.textContent=No),ca.forEach(i),Or=a(T),O=o(T,"DIV",{class:!0});var pe=_(O);c(Ze.$$.fragment,pe),Dr=a(pe),Jt=o(pe,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-1861yti"&&(Jt.textContent=Fo),wr=a(pe),Yt=o(pe,"P",{"data-svelte-h":!0}),s(Yt)!=="svelte-1mn1gnw"&&(Yt.textContent=zo),kr=a(pe),Zt=o(pe,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1xvpyih"&&(Zt.textContent=Io),pe.forEach(i),T.forEach(i),zn=a(e),c(Qe.$$.fragment,e),In=a(e),E=o(e,"DIV",{class:!0});var pa=_(E);c(Xe.$$.fragment,pa),Cr=a(pa),Qt=o(pa,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-2zpx1f"&&(Qt.textContent=Mo),pa.forEach(i),Mn=a(e),c(et.$$.fragment,e),qn=a(e),$=o(e,"DIV",{class:!0});var w=_($);c(tt.$$.fragment,w),Lr=a(w),Xt=o(w,"P",{"data-svelte-h":!0}),s(Xt)!=="svelte-8q861t"&&(Xt.innerHTML=qo),Nr=a(w),se=o(w,"DIV",{class:!0});var ma=_(se);c(nt.$$.fragment,ma),Fr=a(ma),en=o(ma,"P",{"data-svelte-h":!0}),s(en)!=="svelte-1ag17u3"&&(en.textContent=So),ma.forEach(i),zr=a(w),le=o(w,"DIV",{class:!0});var ga=_(le);c(at.$$.fragment,ga),Ir=a(ga),tn=o(ga,"P",{"data-svelte-h":!0}),s(tn)!=="svelte-3jfrz9"&&(tn.textContent=Ao),ga.forEach(i),Mr=a(w),D=o(w,"DIV",{class:!0});var me=_(D);c(rt.$$.fragment,me),qr=a(me),nn=o(me,"P",{"data-svelte-h":!0}),s(nn)!=="svelte-r6y15n"&&(nn.textContent=Eo),Sr=a(me),an=o(me,"P",{"data-svelte-h":!0}),s(an)!=="svelte-imqqfp"&&(an.textContent=Ho),Ar=a(me),rn=o(me,"UL",{"data-svelte-h":!0}),s(rn)!=="svelte-105j238"&&(rn.innerHTML=Uo),me.forEach(i),Er=a(w),de=o(w,"DIV",{class:!0});var ha=_(de);c(ot.$$.fragment,ha),Hr=a(ha),on=o(ha,"P",{"data-svelte-h":!0}),s(on)!=="svelte-1an944l"&&(on.textContent=Ro),ha.forEach(i),w.forEach(i),Sn=a(e),c(it.$$.fragment,e),An=a(e),C=o(e,"DIV",{class:!0});var _n=_(C);c(st.$$.fragment,_n),Ur=a(_n),sn=o(_n,"P",{"data-svelte-h":!0}),s(sn)!=="svelte-xqyw6w"&&(sn.textContent=Vo),Rr=a(_n),ce=o(_n,"DIV",{class:!0});var _a=_(ce);c(lt.$$.fragment,_a),Vr=a(_a),ln=o(_a,"P",{"data-svelte-h":!0}),s(ln)!=="svelte-v7dhdf"&&(ln.textContent=jo),_a.forEach(i),_n.forEach(i),En=a(e),c(dt.$$.fragment,e),Hn=a(e),H=o(e,"DIV",{class:!0});var ua=_(H);c(ct.$$.fragment,ua),jr=a(ua),dn=o(ua,"P",{"data-svelte-h":!0}),s(dn)!=="svelte-1aeuhep"&&(dn.innerHTML=Wo),ua.forEach(i),Un=a(e),fn=o(e,"P",{}),_(fn).forEach(i),this.h()},h(){u(q,"name","hf:doc:metadata"),u(q,"content",Xo),u(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,q),b(e,vn,l),b(e,un,l),b(e,bn,l),p(ge,e,l),b(e,Tn,l),b(e,he,l),b(e,yn,l),p(_e,e,l),b(e,xn,l),b(e,S,l),p(ue,S,null),t(S,fa),t(S,pt),b(e,$n,l),p(fe,e,l),b(e,Pn,l),b(e,y,l),p(ve,y,null),t(y,va),t(y,mt),t(y,ba),t(y,U),p(be,U,null),t(U,Ta),t(U,gt),t(y,ya),t(y,R),p(Te,R,null),t(R,xa),t(R,ht),t(y,$a),t(y,V),p(ye,V,null),t(V,Pa),t(V,_t),t(y,Oa),t(y,j),p(xe,j,null),t(j,Da),t(j,ut),t(y,wa),t(y,W),p($e,W,null),t(W,ka),t(W,ft),t(y,Ca),t(y,B),p(Pe,B,null),t(B,La),t(B,vt),t(y,Na),t(y,K),p(Oe,K,null),t(K,Fa),t(K,bt),t(y,za),t(y,G),p(De,G,null),t(G,Ia),t(G,Tt),t(y,Ma),t(y,J),p(we,J,null),t(J,qa),t(J,yt),t(y,Sa),t(y,Y),p(ke,Y,null),t(Y,Aa),t(Y,xt),t(y,Ea),t(y,Z),p(Ce,Z,null),t(Z,Ha),t(Z,$t),b(e,On,l),p(Le,e,l),b(e,Dn,l),b(e,k,l),p(Ne,k,null),t(k,Ua),t(k,Pt),t(k,Ra),t(k,Ot),b(e,wn,l),p(Fe,e,l),b(e,kn,l),b(e,P,l),p(ze,P,null),t(P,Va),t(P,Dt),t(P,ja),t(P,wt),t(P,Wa),t(P,kt),t(P,Ba),t(P,Ct),b(e,Cn,l),p(Ie,e,l),b(e,Ln,l),b(e,A,l),p(Me,A,null),t(A,Ka),t(A,Lt),b(e,Nn,l),p(qe,e,l),b(e,Fn,l),b(e,v,l),p(Se,v,null),t(v,Ga),t(v,Nt),t(v,Ja),t(v,Q),p(Ae,Q,null),t(Q,Ya),t(Q,Ft),t(v,Za),t(v,X),p(Ee,X,null),t(X,Qa),t(X,zt),t(v,Xa),t(v,N),p(He,N,null),t(N,er),t(N,It),t(N,tr),t(N,Mt),t(v,nr),t(v,ee),p(Ue,ee,null),t(ee,ar),t(ee,qt),t(v,rr),t(v,te),p(Re,te,null),t(te,or),t(te,St),t(v,ir),t(v,F),p(Ve,F,null),t(F,sr),t(F,At),t(F,lr),t(F,Et),t(v,dr),t(v,ne),p(je,ne,null),t(ne,cr),t(ne,Ht),t(v,pr),t(v,ae),p(We,ae,null),t(ae,mr),t(ae,Ut),t(v,gr),t(v,re),p(Be,re,null),t(re,hr),t(re,Rt),t(v,_r),t(v,z),p(Ke,z,null),t(z,ur),t(z,Vt),t(z,fr),t(z,jt),t(v,vr),t(v,I),p(Ge,I,null),t(I,br),t(I,Wt),t(I,Tr),t(I,Bt),t(v,yr),t(v,oe),p(Je,oe,null),t(oe,xr),t(oe,Kt),t(v,$r),t(v,ie),p(Ye,ie,null),t(ie,Pr),t(ie,Gt),t(v,Or),t(v,O),p(Ze,O,null),t(O,Dr),t(O,Jt),t(O,wr),t(O,Yt),t(O,kr),t(O,Zt),b(e,zn,l),p(Qe,e,l),b(e,In,l),b(e,E,l),p(Xe,E,null),t(E,Cr),t(E,Qt),b(e,Mn,l),p(et,e,l),b(e,qn,l),b(e,$,l),p(tt,$,null),t($,Lr),t($,Xt),t($,Nr),t($,se),p(nt,se,null),t(se,Fr),t(se,en),t($,zr),t($,le),p(at,le,null),t(le,Ir),t(le,tn),t($,Mr),t($,D),p(rt,D,null),t(D,qr),t(D,nn),t(D,Sr),t(D,an),t(D,Ar),t(D,rn),t($,Er),t($,de),p(ot,de,null),t(de,Hr),t(de,on),b(e,Sn,l),p(it,e,l),b(e,An,l),b(e,C,l),p(st,C,null),t(C,Ur),t(C,sn),t(C,Rr),t(C,ce),p(lt,ce,null),t(ce,Vr),t(ce,ln),b(e,En,l),p(dt,e,l),b(e,Hn,l),b(e,H,l),p(ct,H,null),t(H,jr),t(H,dn),b(e,Un,l),b(e,fn,l),Rn=!0},p:Ko,i(e){Rn||(m(ge.$$.fragment,e),m(_e.$$.fragment,e),m(ue.$$.fragment,e),m(fe.$$.fragment,e),m(ve.$$.fragment,e),m(be.$$.fragment,e),m(Te.$$.fragment,e),m(ye.$$.fragment,e),m(xe.$$.fragment,e),m($e.$$.fragment,e),m(Pe.$$.fragment,e),m(Oe.$$.fragment,e),m(De.$$.fragment,e),m(we.$$.fragment,e),m(ke.$$.fragment,e),m(Ce.$$.fragment,e),m(Le.$$.fragment,e),m(Ne.$$.fragment,e),m(Fe.$$.fragment,e),m(ze.$$.fragment,e),m(Ie.$$.fragment,e),m(Me.$$.fragment,e),m(qe.$$.fragment,e),m(Se.$$.fragment,e),m(Ae.$$.fragment,e),m(Ee.$$.fragment,e),m(He.$$.fragment,e),m(Ue.$$.fragment,e),m(Re.$$.fragment,e),m(Ve.$$.fragment,e),m(je.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Ke.$$.fragment,e),m(Ge.$$.fragment,e),m(Je.$$.fragment,e),m(Ye.$$.fragment,e),m(Ze.$$.fragment,e),m(Qe.$$.fragment,e),m(Xe.$$.fragment,e),m(et.$$.fragment,e),m(tt.$$.fragment,e),m(nt.$$.fragment,e),m(at.$$.fragment,e),m(rt.$$.fragment,e),m(ot.$$.fragment,e),m(it.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(dt.$$.fragment,e),m(ct.$$.fragment,e),Rn=!0)},o(e){g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(Te.$$.fragment,e),g(ye.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(Pe.$$.fragment,e),g(Oe.$$.fragment,e),g(De.$$.fragment,e),g(we.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Le.$$.fragment,e),g(Ne.$$.fragment,e),g(Fe.$$.fragment,e),g(ze.$$.fragment,e),g(Ie.$$.fragment,e),g(Me.$$.fragment,e),g(qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ae.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ue.$$.fragment,e),g(Re.$$.fragment,e),g(Ve.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(Ke.$$.fragment,e),g(Ge.$$.fragment,e),g(Je.$$.fragment,e),g(Ye.$$.fragment,e),g(Ze.$$.fragment,e),g(Qe.$$.fragment,e),g(Xe.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(at.$$.fragment,e),g(rt.$$.fragment,e),g(ot.$$.fragment,e),g(it.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),Rn=!1},d(e){e&&(i(vn),i(un),i(bn),i(Tn),i(he),i(yn),i(xn),i(S),i($n),i(Pn),i(y),i(On),i(Dn),i(k),i(wn),i(kn),i(P),i(Cn),i(Ln),i(A),i(Nn),i(Fn),i(v),i(zn),i(In),i(E),i(Mn),i(qn),i($),i(Sn),i(An),i(C),i(En),i(Hn),i(H),i(Un),i(fn)),i(q),h(ge,e),h(_e,e),h(ue),h(fe,e),h(ve),h(be),h(Te),h(ye),h(xe),h($e),h(Pe),h(Oe),h(De),h(we),h(ke),h(Ce),h(Le,e),h(Ne),h(Fe,e),h(ze),h(Ie,e),h(Me),h(qe,e),h(Se),h(Ae),h(Ee),h(He),h(Ue),h(Re),h(Ve),h(je),h(We),h(Be),h(Ke),h(Ge),h(Je),h(Ye),h(Ze),h(Qe,e),h(Xe),h(et,e),h(tt),h(nt),h(at),h(rt),h(ot),h(it,e),h(st),h(lt),h(dt,e),h(ct)}}}const Xo='{"title":"Trainer","local":"trainer","sections":[{"title":"PPOConfig","local":"trl.PPOConfig","sections":[],"depth":2},{"title":"PPOTrainer","local":"trl.PPOTrainer","sections":[],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2},{"title":"DDPOConfig","local":"trl.DDPOConfig","sections":[],"depth":2},{"title":"DDPOTrainer","local":"trl.DDPOTrainer","sections":[],"depth":2},{"title":"IterativeSFTTrainer","local":"trl.IterativeSFTTrainer","sections":[],"depth":2},{"title":"set_seed","local":"trl.set_seed","sections":[],"depth":2}],"depth":1}';function ei(Wr){return Go(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oi extends Jo{constructor(q){super(),Yo(this,q,ei,Qo,Bo,{})}}export{oi as component};
