import{s as oo,n as lo,o as ro}from"../chunks/scheduler.9039eef2.js";import{S as so,i as io,g as s,s as n,r as m,A as po,h as i,f as a,c as o,j as y,u as h,x as d,k as T,l as co,y as r,a as l,v as u,d as g,t as M,w as f}from"../chunks/index.ded8f90d.js";import{D as b}from"../chunks/Docstring.a2ba2b54.js";import{C as yt}from"../chunks/CodeBlock.8580f3e8.js";import{H as _}from"../chunks/Heading.f027f30d.js";function mo(ln){let C,Tt,Mt,bt,E,wt,L,rn='TRL supports the DPO Trainer for training language models from preference data, as described in the paper <a href="https://arxiv.org/abs/2305.18290" rel="nofollow">Direct Preference Optimization: Your Language Model is Secretly a Reward Model</a> by Rafailov et al., 2023. For a full example have a look at  <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo.py" rel="nofollow"><code>examples/scripts/dpo.py</code></a>.',_t,R,sn="The first step as always is to train your SFT model, to ensure the data we train on is in-distribution for the DPO algorithm.",Jt,O,vt,F,dn='The DPO trainer expects a very specific format for the dataset. Since the model will be trained to directly optimize the preference of which sentence is the most relevant, given two sentences. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',Ut,I,pn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',jt,N,cn="Therefore the final dataset object should contain these 3 entries if you use the default <code>DPODataCollatorWithPadding</code> data collator. The entries should be named:",Ct,H,mn="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",It,Q,hn="for example:",xt,G,$t,z,un="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Dt,X,At,V,gn="The DPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Pt,Y,kt,S,Mn="For a detailed example have a look at the <code>examples/scripts/dpo.py</code> script. At a high level we need to initialize the <code>DPOTrainer</code> with a <code>model</code> we wish to train, a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response, the <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Bt,K,qt,ee,fn="After this one can then call:",Wt,te,Zt,ae,yn="Note that the <code>beta</code> is the temperature parameter for the DPO loss, typically something in the range of <code>0.1</code> to <code>0.5</code>. We ignore the reference model as <code>beta</code> -&gt; 0.",Et,ne,Lt,oe,Tn="Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the DPO authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",Rt,le,bn='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>DPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',Ot,re,wn='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer.',Ft,se,_n='The <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> is a tweak on the DPO loss where we assume that the preference labels are noisy with some probability that can be passed to the <code>DPOTrainer</code> via <code>label_smoothing</code> argument (between 0 and 0.5) and then a conservative DPO loss is used. Use the <code>loss_type=&quot;cdpo&quot;</code> argument to the trainer to use it.',Nt,ie,Jn='The <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">KTO</a> loss is derived to directly maximize the utility of LLM generations instead of the log-likelihood of preferences. Thus the dataset are not necessarily preferences but rather desirable vs undesirable completions. For paired preference data as required by the <code>DPOTrainer</code>, use the <code>loss_type=&quot;kto_pair&quot;</code> argument to the trainer to utilize this loss, while for the more general case of desired and undesirable data, use the as of yet unimplemented <code>KTOTrainer</code>.',Ht,de,Qt,pe,vn="While training and evaluating we record the following reward metrics:",Gt,ce,Un="<li><code>rewards/chosen</code>: the mean difference between the log probabilities of the policy model and the reference model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean difference between the log probabilities of the policy model and the reference model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li>",zt,me,Xt,he,jn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks for DPO listed below:',Vt,ue,Cn="<thead><tr><th>GPU</th> <th>Model</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>A100 40G</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.24x</td> <td><strong>1.88x</strong></td> <td>-11.6%</td></tr> <tr><td>Tesla T4</td> <td>Zephyr 7b</td> <td>Ultra Chat</td> <td>1x</td> <td>1.09x</td> <td><strong>1.55x</strong></td> <td>-18.6%</td></tr></tbody>",Yt,ge,In='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',St,Me,Kt,fe,xn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',ea,ye,ta,Te,$n="You have three main options (plus several variants) for how the reference model works when using PEFT, assuming the model that you would like to further enhance with DPO was tuned using (Q)LoRA.",aa,be,Dn="<li>Simply create two instances of the model, each loading your adapter - works fine but is very inefficient.</li> <li>Merge the adapter into the base model, create another adapter on top, then leave the <code>model_ref</code> param null, in which case DPOTrainer will unload the adapter for reference inference - efficient, but has potential downsides discussed below.</li> <li>Load the adapter twice with different names, then use <code>set_adapter</code> during training to swap between the adapter being DPO’d and the reference adapter - slightly less efficient compared to 2 (~adapter size VRAM overhead), but avoids the pitfalls.</li>",na,we,oa,_e,An='As suggested by <a href="https://twitter.com/Tim_Dettmers/status/1694654191325573456" rel="nofollow">Tim Dettmers</a>, the best option for merging QLoRA adapters is to first quantize the base model, merge the adapter, then convert back to bf16.  Something similar to <a href="https://github.com/jondurbin/qlora/blob/main/qmerge.py" rel="nofollow">this script</a>',la,Je,Pn="You can also just merge the adapters the standard way without quantizing the base model, but then you have 1-2% reduced performance (and evidently, more issues with empty responses).",ra,ve,kn="If you use the recommended approach, which quantizes the model, you’re now in a situation where to use QLoRA for DPO, you will need to re-quantize the merged model again or use an unquantized merge with lower overall performance.",sa,Ue,ia,je,Bn="To avoid the downsides with option 2, at the expense of slightly increased VRAM, you can load your fine-tuned adapter into the model twice, with different names, and set the model/ref adapter names in DPOTrainer.",da,Ce,qn="For example:",pa,Ie,ca,xe,ma,p,$e,va,He,Wn="Initialize DPOTrainer.",Ua,x,De,ja,Qe,Zn=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Ca,$,Ae,Ia,Ge,En="Computes log probabilities of the reference model for a single padded batch of a DPO specific dataset.",xa,J,Pe,$a,ze,Ln="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Da,Xe,Rn="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Aa,D,ke,Pa,Ve,On="Concatenate the chosen and rejected inputs into a single tensor.",ka,A,Be,Ba,Ye,Fn="Compute the DPO loss for a batch of policy and reference model log probabilities.",qa,v,qe,Wa,Se,Nn=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Za,Ke,Hn="Works both with or without labels.",Ea,P,We,La,et,Qn="Compute the log probabilities of the given labels under the given logits.",Ra,k,Ze,Oa,tt,Gn="Compute the DPO loss and other metrics for the given batch of inputs for train or test.",Fa,B,Ee,Na,at,zn="Generate samples from the model and reference model for the given batch of inputs.",Ha,U,Le,Qa,nt,Xn="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Ga,ot,Vn="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",za,j,Re,Xa,lt,Yn="Returns the training <code>~torch.utils.data.DataLoader</code>.",Va,rt,Sn="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Ya,q,Oe,Sa,st,Kn="Log <code>logs</code> on the various objects watching training, including stored metrics.",Ka,W,Fe,en,it,eo="Context manager for handling null reference model (that is, peft adapter manipulation).",tn,w,Ne,an,dt,to="Tokenize a single row from a DPO specific dataset.",nn,pt,ao=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,on,ct,no=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,ha,ft,ua;return E=new _({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h1"}}),O=new _({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),G=new yt({props:{code:"ZHBvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`dpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),X=new _({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Y=new _({props:{title:"Using the DPOTrainer",local:"using-the-dpotrainer",headingTag:"h2"}}),K=new yt({props:{code:"JTIwZHBvX3RyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfcmVmJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:` dpo_trainer = DPOTrainer(
    model,
    model_ref,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),te=new yt({props:{code:"ZHBvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"dpo_trainer.train()",wrap:!1}}),ne=new _({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),de=new _({props:{title:"Logging",local:"logging",headingTag:"h2"}}),me=new _({props:{title:"Accelerate DPO fine-tuning using unsloth",local:"accelerate-dpo-fine-tuning-using-unsloth",headingTag:"h2"}}),Me=new yt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number.</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/zephyr-sft&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False.</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir=<span class="hljs-string">&quot;./output&quot;</span>)

dpo_trainer = DPOTrainer(
    model,
    model_ref=<span class="hljs-literal">None</span>,
    args=training_args,
    beta=<span class="hljs-number">0.1</span>,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)
dpo_trainer.train()`,wrap:!1}}),ye=new _({props:{title:"Reference model considerations with PEFT",local:"reference-model-considerations-with-peft",headingTag:"h2"}}),we=new _({props:{title:"Downsides to merging QLoRA before DPO (approach 2)",local:"downsides-to-merging-qlora-before-dpo-approach-2",headingTag:"h3"}}),Ue=new _({props:{title:"Using option 3 - load the adapter twice",local:"using-option-3---load-the-adapter-twice",headingTag:"h3"}}),Ie=new yt({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbC4lMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF90aHJlc2hvbGQlM0Q2LjAlMkMlMEElMjAlMjAlMjAlMjBsbG1faW50OF9oYXNfZnAxNl93ZWlnaHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaXN0cmFsYWklMkZtaXh0cmFsLTh4N2ItdjAuMSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0QlMjJmbGFzaF9hdHRlbnRpb25fMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSklMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwYWRhcHRlci4lMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5hYmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMnRyYWluJTIyJTJDJTBBKSUwQSUyMyUyMExvYWQlMjB0aGUlMjBhZGFwdGVyJTIwYSUyMHNlY29uZCUyMHRpbWUlMkMlMjB3aXRoJTIwYSUyMGRpZmZlcmVudCUyMG5hbWUlMkMlMjB3aGljaCUyMHdpbGwlMjBiZSUyMG91ciUyMHJlZmVyZW5jZSUyMG1vZGVsLiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjIlMkZwYXRoJTJGdG8lMkZwZWZ0JTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIycmVmZXJlbmNlJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjB0cmFpbmVyJTJDJTIwd2l0aG91dCUyMGElMjByZWZfbW9kZWwlMjBwYXJhbS4lMEFkcG9fdHJhaW5lciUyMCUzRCUyMERQT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjBtb2RlbF9hZGFwdGVyX25hbWUlM0QlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlZl9hZGFwdGVyX25hbWUlM0QlMjJyZWZlcmVuY2UlMjIlMkMlMEEp",highlighted:`<span class="hljs-comment"># Load the base model.</span>
bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    llm_int8_threshold=<span class="hljs-number">6.0</span>,
    llm_int8_has_fp16_weight=<span class="hljs-literal">False</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)
model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/mixtral-8x7b-v0.1&quot;</span>,
    load_in_4bit=<span class="hljs-literal">True</span>,
    quantization_config=bnb_config,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># Load the adapter.</span>
model = PeftModel.from_pretrained(
    model,
    <span class="hljs-string">&quot;/path/to/peft&quot;</span>,
    is_trainable=<span class="hljs-literal">True</span>,
    adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
)
<span class="hljs-comment"># Load the adapter a second time, with a different name, which will be our reference model.</span>
model.load_adapter(<span class="hljs-string">&quot;/path/to/peft&quot;</span>, adapter_name=<span class="hljs-string">&quot;reference&quot;</span>)

<span class="hljs-comment"># Initialize the trainer, without a ref_model param.</span>
dpo_trainer = DPOTrainer(
    model,
    ...
    model_adapter_name=<span class="hljs-string">&quot;train&quot;</span>,
    ref_adapter_name=<span class="hljs-string">&quot;reference&quot;</span>,
)`,wrap:!1}}),xe=new _({props:{title:"DPOTrainer",local:"trl.DPOTrainer",headingTag:"h2"}}),$e=new b({props:{name:"class trl.DPOTrainer",anchor:"trl.DPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": typing.Literal['sigmoid', 'hinge', 'ipo', 'kto'] = 'sigmoid'"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": typing.Optional[DataCollator] = None"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"},{name:"model_init",val:": typing.Union[typing.Callable[[], transformers.modeling_utils.PreTrainedModel], NoneType] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Union[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor], NoneType] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_target_length",val:": typing.Optional[int] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"compute_metrics",val:": typing.Union[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict], NoneType] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"model_adapter_name",val:": str = None"},{name:"ref_adapter_name",val:": str = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.DPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.DPOTrainer.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in DPO loss. Higher beta means less divergence from the initial policy. For the IPO loss, beta is the regularization parameter denoted by tau in the paper.`,name:"beta"},{anchor:"trl.DPOTrainer.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The robust DPO label smoothing parameter from the <a href="https://ericmitchell.ai/cdpo.pdf" rel="nofollow">cDPO</a> report that should be between 0 and 0.5.`,name:"label_smoothing"},{anchor:"trl.DPOTrainer.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
The type of DPO loss to use. Either <code>&quot;sigmoid&quot;</code> the default DPO loss,<code>&quot;hinge&quot;</code> loss from <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper, <code>&quot;ipo&quot;</code> from <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> paper, or <code>&quot;kto&quot;</code> from the HALOs <a href="https://github.com/ContextualAI/HALOs/blob/main/assets/report.pdf" rel="nofollow">report</a>.`,name:"loss_type"},{anchor:"trl.DPOTrainer.args",description:`<strong>args</strong> (<code>transformers.TrainingArguments</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.DPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.DPOTrainer.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.DPOTrainer.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.DPOTrainer.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.DPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.DPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.DPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.DPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.DPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.DPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.DPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.DPOTrainer.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.DPOTrainer.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.DPOTrainer.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.DPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.DPOTrainer.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.DPOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.DPOTrainer.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.DPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.DPOTrainer.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string`,name:"precompute_ref_log_probs"},{anchor:"trl.DPOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.DPOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L64"}}),De=new b({props:{name:"build_tokenized_answer",anchor:"trl.DPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L523"}}),Ae=new b({props:{name:"compute_reference_log_probs",anchor:"trl.DPOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L731"}}),Pe=new b({props:{name:"concatenated_forward",anchor:"trl.DPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L934"}}),ke=new b({props:{name:"concatenated_inputs",anchor:"trl.DPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L755",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),Be=new b({props:{name:"dpo_loss",anchor:"trl.DPOTrainer.dpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_free",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L817",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the DPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),qe=new b({props:{name:"evaluation_loop",anchor:"trl.DPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1154"}}),We=new b({props:{name:"get_batch_logps",anchor:"trl.DPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L898",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),Ze=new b({props:{name:"get_batch_loss_metrics",anchor:"trl.DPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L980"}}),Ee=new b({props:{name:"get_batch_samples",anchor:"trl.DPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1063"}}),Le=new b({props:{name:"get_eval_dataloader",anchor:"trl.DPOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.DPOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L471"}}),Re=new b({props:{name:"get_train_dataloader",anchor:"trl.DPOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L428"}}),Oe=new b({props:{name:"log",anchor:"trl.DPOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.DPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L1204"}}),Fe=new b({props:{name:"null_ref_context",anchor:"trl.DPOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L719"}}),Ne=new b({props:{name:"tokenize_row",anchor:"trl.DPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module] = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/dpo_trainer.py#L573"}}),{c(){C=s("meta"),Tt=n(),Mt=s("p"),bt=n(),m(E.$$.fragment),wt=n(),L=s("p"),L.innerHTML=rn,_t=n(),R=s("p"),R.textContent=sn,Jt=n(),m(O.$$.fragment),vt=n(),F=s("p"),F.innerHTML=dn,Ut=n(),I=s("div"),I.innerHTML=pn,jt=n(),N=s("p"),N.innerHTML=cn,Ct=n(),H=s("ul"),H.innerHTML=mn,It=n(),Q=s("p"),Q.textContent=hn,xt=n(),m(G.$$.fragment),$t=n(),z=s("p"),z.innerHTML=un,Dt=n(),m(X.$$.fragment),At=n(),V=s("p"),V.innerHTML=gn,Pt=n(),m(Y.$$.fragment),kt=n(),S=s("p"),S.innerHTML=Mn,Bt=n(),m(K.$$.fragment),qt=n(),ee=s("p"),ee.textContent=fn,Wt=n(),m(te.$$.fragment),Zt=n(),ae=s("p"),ae.innerHTML=yn,Et=n(),m(ne.$$.fragment),Lt=n(),oe=s("p"),oe.innerHTML=Tn,Rt=n(),le=s("p"),le.innerHTML=bn,Ot=n(),re=s("p"),re.innerHTML=wn,Ft=n(),se=s("p"),se.innerHTML=_n,Nt=n(),ie=s("p"),ie.innerHTML=Jn,Ht=n(),m(de.$$.fragment),Qt=n(),pe=s("p"),pe.textContent=vn,Gt=n(),ce=s("ul"),ce.innerHTML=Un,zt=n(),m(me.$$.fragment),Xt=n(),he=s("p"),he.innerHTML=jn,Vt=n(),ue=s("table"),ue.innerHTML=Cn,Yt=n(),ge=s("p"),ge.innerHTML=In,St=n(),m(Me.$$.fragment),Kt=n(),fe=s("p"),fe.innerHTML=xn,ea=n(),m(ye.$$.fragment),ta=n(),Te=s("p"),Te.textContent=$n,aa=n(),be=s("ol"),be.innerHTML=Dn,na=n(),m(we.$$.fragment),oa=n(),_e=s("p"),_e.innerHTML=An,la=n(),Je=s("p"),Je.textContent=Pn,ra=n(),ve=s("p"),ve.textContent=kn,sa=n(),m(Ue.$$.fragment),ia=n(),je=s("p"),je.textContent=Bn,da=n(),Ce=s("p"),Ce.textContent=qn,pa=n(),m(Ie.$$.fragment),ca=n(),m(xe.$$.fragment),ma=n(),p=s("div"),m($e.$$.fragment),va=n(),He=s("p"),He.textContent=Wn,Ua=n(),x=s("div"),m(De.$$.fragment),ja=n(),Qe=s("p"),Qe.innerHTML=Zn,Ca=n(),$=s("div"),m(Ae.$$.fragment),Ia=n(),Ge=s("p"),Ge.textContent=En,xa=n(),J=s("div"),m(Pe.$$.fragment),$a=n(),ze=s("p"),ze.textContent=Ln,Da=n(),Xe=s("p"),Xe.textContent=Rn,Aa=n(),D=s("div"),m(ke.$$.fragment),Pa=n(),Ve=s("p"),Ve.textContent=On,ka=n(),A=s("div"),m(Be.$$.fragment),Ba=n(),Ye=s("p"),Ye.textContent=Fn,qa=n(),v=s("div"),m(qe.$$.fragment),Wa=n(),Se=s("p"),Se.innerHTML=Nn,Za=n(),Ke=s("p"),Ke.textContent=Hn,Ea=n(),P=s("div"),m(We.$$.fragment),La=n(),et=s("p"),et.textContent=Qn,Ra=n(),k=s("div"),m(Ze.$$.fragment),Oa=n(),tt=s("p"),tt.textContent=Gn,Fa=n(),B=s("div"),m(Ee.$$.fragment),Na=n(),at=s("p"),at.textContent=zn,Ha=n(),U=s("div"),m(Le.$$.fragment),Qa=n(),nt=s("p"),nt.innerHTML=Xn,Ga=n(),ot=s("p"),ot.innerHTML=Vn,za=n(),j=s("div"),m(Re.$$.fragment),Xa=n(),lt=s("p"),lt.innerHTML=Yn,Va=n(),rt=s("p"),rt.innerHTML=Sn,Ya=n(),q=s("div"),m(Oe.$$.fragment),Sa=n(),st=s("p"),st.innerHTML=Kn,Ka=n(),W=s("div"),m(Fe.$$.fragment),en=n(),it=s("p"),it.textContent=eo,tn=n(),w=s("div"),m(Ne.$$.fragment),an=n(),dt=s("p"),dt.textContent=to,nn=n(),pt=s("p"),pt.textContent=ao,on=n(),ct=s("p"),ct.textContent=no,ha=n(),ft=s("p"),this.h()},l(e){const t=po("svelte-u9bgzb",document.head);C=i(t,"META",{name:!0,content:!0}),t.forEach(a),Tt=o(e),Mt=i(e,"P",{}),y(Mt).forEach(a),bt=o(e),h(E.$$.fragment,e),wt=o(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-5p7twb"&&(L.innerHTML=rn),_t=o(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-xh4sh7"&&(R.textContent=sn),Jt=o(e),h(O.$$.fragment,e),vt=o(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-dcawbe"&&(F.innerHTML=dn),Ut=o(e),I=i(e,"DIV",{style:!0,"data-svelte-h":!0}),d(I)!=="svelte-z15c7z"&&(I.innerHTML=pn),jt=o(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-cb9b0v"&&(N.innerHTML=cn),Ct=o(e),H=i(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-17vxuta"&&(H.innerHTML=mn),It=o(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1gl9mvz"&&(Q.textContent=hn),xt=o(e),h(G.$$.fragment,e),$t=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1a8oxjk"&&(z.innerHTML=un),Dt=o(e),h(X.$$.fragment,e),At=o(e),V=i(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-174yw9s"&&(V.innerHTML=gn),Pt=o(e),h(Y.$$.fragment,e),kt=o(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-1wn9xrv"&&(S.innerHTML=Mn),Bt=o(e),h(K.$$.fragment,e),qt=o(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1lg6q1l"&&(ee.textContent=fn),Wt=o(e),h(te.$$.fragment,e),Zt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1ac5mum"&&(ae.innerHTML=yn),Et=o(e),h(ne.$$.fragment,e),Lt=o(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-7nvktz"&&(oe.innerHTML=Tn),Rt=o(e),le=i(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-bl9wh7"&&(le.innerHTML=bn),Ot=o(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1x8box7"&&(re.innerHTML=wn),Ft=o(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-x8vvul"&&(se.innerHTML=_n),Nt=o(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-qfh893"&&(ie.innerHTML=Jn),Ht=o(e),h(de.$$.fragment,e),Qt=o(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-132s7j9"&&(pe.textContent=vn),Gt=o(e),ce=i(e,"UL",{"data-svelte-h":!0}),d(ce)!=="svelte-1oji3mm"&&(ce.innerHTML=Un),zt=o(e),h(me.$$.fragment,e),Xt=o(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-2145zu"&&(he.innerHTML=jn),Vt=o(e),ue=i(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-435mua"&&(ue.innerHTML=Cn),Yt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1p74c9x"&&(ge.innerHTML=In),St=o(e),h(Me.$$.fragment,e),Kt=o(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1o18rwj"&&(fe.innerHTML=xn),ea=o(e),h(ye.$$.fragment,e),ta=o(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-4infz6"&&(Te.textContent=$n),aa=o(e),be=i(e,"OL",{"data-svelte-h":!0}),d(be)!=="svelte-1p7od7"&&(be.innerHTML=Dn),na=o(e),h(we.$$.fragment,e),oa=o(e),_e=i(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-qnlv77"&&(_e.innerHTML=An),la=o(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-a6wqh1"&&(Je.textContent=Pn),ra=o(e),ve=i(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-18ysviz"&&(ve.textContent=kn),sa=o(e),h(Ue.$$.fragment,e),ia=o(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1gj19cj"&&(je.textContent=Bn),da=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1gkqha7"&&(Ce.textContent=qn),pa=o(e),h(Ie.$$.fragment,e),ca=o(e),h(xe.$$.fragment,e),ma=o(e),p=i(e,"DIV",{class:!0});var c=y(p);h($e.$$.fragment,c),va=o(c),He=i(c,"P",{"data-svelte-h":!0}),d(He)!=="svelte-n6cc8y"&&(He.textContent=Wn),Ua=o(c),x=i(c,"DIV",{class:!0});var ga=y(x);h(De.$$.fragment,ga),ja=o(ga),Qe=i(ga,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-mcz8nm"&&(Qe.innerHTML=Zn),ga.forEach(a),Ca=o(c),$=i(c,"DIV",{class:!0});var Ma=y($);h(Ae.$$.fragment,Ma),Ia=o(Ma),Ge=i(Ma,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-10t1062"&&(Ge.textContent=En),Ma.forEach(a),xa=o(c),J=i(c,"DIV",{class:!0});var mt=y(J);h(Pe.$$.fragment,mt),$a=o(mt),ze=i(mt,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-16i1nac"&&(ze.textContent=Ln),Da=o(mt),Xe=i(mt,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-tgti68"&&(Xe.textContent=Rn),mt.forEach(a),Aa=o(c),D=i(c,"DIV",{class:!0});var fa=y(D);h(ke.$$.fragment,fa),Pa=o(fa),Ve=i(fa,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1cvsgkk"&&(Ve.textContent=On),fa.forEach(a),ka=o(c),A=i(c,"DIV",{class:!0});var ya=y(A);h(Be.$$.fragment,ya),Ba=o(ya),Ye=i(ya,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-ymgxq7"&&(Ye.textContent=Fn),ya.forEach(a),qa=o(c),v=i(c,"DIV",{class:!0});var ht=y(v);h(qe.$$.fragment,ht),Wa=o(ht),Se=i(ht,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-8qlty5"&&(Se.innerHTML=Nn),Za=o(ht),Ke=i(ht,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1tyo99t"&&(Ke.textContent=Hn),ht.forEach(a),Ea=o(c),P=i(c,"DIV",{class:!0});var Ta=y(P);h(We.$$.fragment,Ta),La=o(Ta),et=i(Ta,"P",{"data-svelte-h":!0}),d(et)!=="svelte-4nmimv"&&(et.textContent=Qn),Ta.forEach(a),Ra=o(c),k=i(c,"DIV",{class:!0});var ba=y(k);h(Ze.$$.fragment,ba),Oa=o(ba),tt=i(ba,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-11q8u7l"&&(tt.textContent=Gn),ba.forEach(a),Fa=o(c),B=i(c,"DIV",{class:!0});var wa=y(B);h(Ee.$$.fragment,wa),Na=o(wa),at=i(wa,"P",{"data-svelte-h":!0}),d(at)!=="svelte-18uwvbi"&&(at.textContent=zn),wa.forEach(a),Ha=o(c),U=i(c,"DIV",{class:!0});var ut=y(U);h(Le.$$.fragment,ut),Qa=o(ut),nt=i(ut,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-xesobz"&&(nt.innerHTML=Xn),Ga=o(ut),ot=i(ut,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-qg43tm"&&(ot.innerHTML=Vn),ut.forEach(a),za=o(c),j=i(c,"DIV",{class:!0});var gt=y(j);h(Re.$$.fragment,gt),Xa=o(gt),lt=i(gt,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-dkae9b"&&(lt.innerHTML=Yn),Va=o(gt),rt=i(gt,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-hmd5cw"&&(rt.innerHTML=Sn),gt.forEach(a),Ya=o(c),q=i(c,"DIV",{class:!0});var _a=y(q);h(Oe.$$.fragment,_a),Sa=o(_a),st=i(_a,"P",{"data-svelte-h":!0}),d(st)!=="svelte-nqksfz"&&(st.innerHTML=Kn),_a.forEach(a),Ka=o(c),W=i(c,"DIV",{class:!0});var Ja=y(W);h(Fe.$$.fragment,Ja),en=o(Ja),it=i(Ja,"P",{"data-svelte-h":!0}),d(it)!=="svelte-17kjsy4"&&(it.textContent=eo),Ja.forEach(a),tn=o(c),w=i(c,"DIV",{class:!0});var Z=y(w);h(Ne.$$.fragment,Z),an=o(Z),dt=i(Z,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1861yti"&&(dt.textContent=to),nn=o(Z),pt=i(Z,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1mn1gnw"&&(pt.textContent=ao),on=o(Z),ct=i(Z,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1xvpyih"&&(ct.textContent=no),Z.forEach(a),c.forEach(a),ha=o(e),ft=i(e,"P",{}),y(ft).forEach(a),this.h()},h(){T(C,"name","hf:doc:metadata"),T(C,"content",ho),co(I,"text-align","center"),T(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,C),l(e,Tt,t),l(e,Mt,t),l(e,bt,t),u(E,e,t),l(e,wt,t),l(e,L,t),l(e,_t,t),l(e,R,t),l(e,Jt,t),u(O,e,t),l(e,vt,t),l(e,F,t),l(e,Ut,t),l(e,I,t),l(e,jt,t),l(e,N,t),l(e,Ct,t),l(e,H,t),l(e,It,t),l(e,Q,t),l(e,xt,t),u(G,e,t),l(e,$t,t),l(e,z,t),l(e,Dt,t),u(X,e,t),l(e,At,t),l(e,V,t),l(e,Pt,t),u(Y,e,t),l(e,kt,t),l(e,S,t),l(e,Bt,t),u(K,e,t),l(e,qt,t),l(e,ee,t),l(e,Wt,t),u(te,e,t),l(e,Zt,t),l(e,ae,t),l(e,Et,t),u(ne,e,t),l(e,Lt,t),l(e,oe,t),l(e,Rt,t),l(e,le,t),l(e,Ot,t),l(e,re,t),l(e,Ft,t),l(e,se,t),l(e,Nt,t),l(e,ie,t),l(e,Ht,t),u(de,e,t),l(e,Qt,t),l(e,pe,t),l(e,Gt,t),l(e,ce,t),l(e,zt,t),u(me,e,t),l(e,Xt,t),l(e,he,t),l(e,Vt,t),l(e,ue,t),l(e,Yt,t),l(e,ge,t),l(e,St,t),u(Me,e,t),l(e,Kt,t),l(e,fe,t),l(e,ea,t),u(ye,e,t),l(e,ta,t),l(e,Te,t),l(e,aa,t),l(e,be,t),l(e,na,t),u(we,e,t),l(e,oa,t),l(e,_e,t),l(e,la,t),l(e,Je,t),l(e,ra,t),l(e,ve,t),l(e,sa,t),u(Ue,e,t),l(e,ia,t),l(e,je,t),l(e,da,t),l(e,Ce,t),l(e,pa,t),u(Ie,e,t),l(e,ca,t),u(xe,e,t),l(e,ma,t),l(e,p,t),u($e,p,null),r(p,va),r(p,He),r(p,Ua),r(p,x),u(De,x,null),r(x,ja),r(x,Qe),r(p,Ca),r(p,$),u(Ae,$,null),r($,Ia),r($,Ge),r(p,xa),r(p,J),u(Pe,J,null),r(J,$a),r(J,ze),r(J,Da),r(J,Xe),r(p,Aa),r(p,D),u(ke,D,null),r(D,Pa),r(D,Ve),r(p,ka),r(p,A),u(Be,A,null),r(A,Ba),r(A,Ye),r(p,qa),r(p,v),u(qe,v,null),r(v,Wa),r(v,Se),r(v,Za),r(v,Ke),r(p,Ea),r(p,P),u(We,P,null),r(P,La),r(P,et),r(p,Ra),r(p,k),u(Ze,k,null),r(k,Oa),r(k,tt),r(p,Fa),r(p,B),u(Ee,B,null),r(B,Na),r(B,at),r(p,Ha),r(p,U),u(Le,U,null),r(U,Qa),r(U,nt),r(U,Ga),r(U,ot),r(p,za),r(p,j),u(Re,j,null),r(j,Xa),r(j,lt),r(j,Va),r(j,rt),r(p,Ya),r(p,q),u(Oe,q,null),r(q,Sa),r(q,st),r(p,Ka),r(p,W),u(Fe,W,null),r(W,en),r(W,it),r(p,tn),r(p,w),u(Ne,w,null),r(w,an),r(w,dt),r(w,nn),r(w,pt),r(w,on),r(w,ct),l(e,ha,t),l(e,ft,t),ua=!0},p:lo,i(e){ua||(g(E.$$.fragment,e),g(O.$$.fragment,e),g(G.$$.fragment,e),g(X.$$.fragment,e),g(Y.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(Me.$$.fragment,e),g(ye.$$.fragment,e),g(we.$$.fragment,e),g(Ue.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g($e.$$.fragment,e),g(De.$$.fragment,e),g(Ae.$$.fragment,e),g(Pe.$$.fragment,e),g(ke.$$.fragment,e),g(Be.$$.fragment,e),g(qe.$$.fragment,e),g(We.$$.fragment,e),g(Ze.$$.fragment,e),g(Ee.$$.fragment,e),g(Le.$$.fragment,e),g(Re.$$.fragment,e),g(Oe.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),ua=!0)},o(e){M(E.$$.fragment,e),M(O.$$.fragment,e),M(G.$$.fragment,e),M(X.$$.fragment,e),M(Y.$$.fragment,e),M(K.$$.fragment,e),M(te.$$.fragment,e),M(ne.$$.fragment,e),M(de.$$.fragment,e),M(me.$$.fragment,e),M(Me.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(Ue.$$.fragment,e),M(Ie.$$.fragment,e),M(xe.$$.fragment,e),M($e.$$.fragment,e),M(De.$$.fragment,e),M(Ae.$$.fragment,e),M(Pe.$$.fragment,e),M(ke.$$.fragment,e),M(Be.$$.fragment,e),M(qe.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(Ee.$$.fragment,e),M(Le.$$.fragment,e),M(Re.$$.fragment,e),M(Oe.$$.fragment,e),M(Fe.$$.fragment,e),M(Ne.$$.fragment,e),ua=!1},d(e){e&&(a(Tt),a(Mt),a(bt),a(wt),a(L),a(_t),a(R),a(Jt),a(vt),a(F),a(Ut),a(I),a(jt),a(N),a(Ct),a(H),a(It),a(Q),a(xt),a($t),a(z),a(Dt),a(At),a(V),a(Pt),a(kt),a(S),a(Bt),a(qt),a(ee),a(Wt),a(Zt),a(ae),a(Et),a(Lt),a(oe),a(Rt),a(le),a(Ot),a(re),a(Ft),a(se),a(Nt),a(ie),a(Ht),a(Qt),a(pe),a(Gt),a(ce),a(zt),a(Xt),a(he),a(Vt),a(ue),a(Yt),a(ge),a(St),a(Kt),a(fe),a(ea),a(ta),a(Te),a(aa),a(be),a(na),a(oa),a(_e),a(la),a(Je),a(ra),a(ve),a(sa),a(ia),a(je),a(da),a(Ce),a(pa),a(ca),a(ma),a(p),a(ha),a(ft)),a(C),f(E,e),f(O,e),f(G,e),f(X,e),f(Y,e),f(K,e),f(te,e),f(ne,e),f(de,e),f(me,e),f(Me,e),f(ye,e),f(we,e),f(Ue,e),f(Ie,e),f(xe,e),f($e),f(De),f(Ae),f(Pe),f(ke),f(Be),f(qe),f(We),f(Ze),f(Ee),f(Le),f(Re),f(Oe),f(Fe),f(Ne)}}}const ho='{"title":"DPO Trainer","local":"dpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the DPOTrainer","local":"using-the-dpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Accelerate DPO fine-tuning using unsloth","local":"accelerate-dpo-fine-tuning-using-unsloth","sections":[],"depth":2},{"title":"Reference model considerations with PEFT","local":"reference-model-considerations-with-peft","sections":[{"title":"Downsides to merging QLoRA before DPO (approach 2)","local":"downsides-to-merging-qlora-before-dpo-approach-2","sections":[],"depth":3},{"title":"Using option 3 - load the adapter twice","local":"using-option-3---load-the-adapter-twice","sections":[],"depth":3}],"depth":2},{"title":"DPOTrainer","local":"trl.DPOTrainer","sections":[],"depth":2}],"depth":1}';function uo(ln){return ro(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bo extends so{constructor(C){super(),io(this,C,uo,mo,oo,{})}}export{bo as component};
